// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// API operation for creating and managing Amazon Bedrock automatic model
// evaluation jobs and model evaluation jobs that use human workers. To learn more
// about the requirements for creating a model evaluation job see, [Model evaluations].
//
// [Model evaluations]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html
func (c *Client) CreateEvaluationJob(ctx context.Context, params *CreateEvaluationJobInput, optFns ...func(*Options)) (*CreateEvaluationJobOutput, error) {
	if params == nil {
		params = &CreateEvaluationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEvaluationJob", params, optFns, c.addOperationCreateEvaluationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEvaluationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEvaluationJobInput struct {

	// Specifies whether the model evaluation job is automatic or uses human worker.
	//
	// This member is required.
	EvaluationConfig types.EvaluationConfig

	// Specify the models you want to use in your model evaluation job. Automatic
	// model evaluation jobs support a single model, and model evaluation job that use
	// human workers support two models.
	//
	// This member is required.
	InferenceConfig types.EvaluationInferenceConfig

	// The name of the model evaluation job. Model evaluation job names must unique
	// with your AWS account, and your account's AWS region.
	//
	// This member is required.
	JobName *string

	// An object that defines where the results of model evaluation job will be saved
	// in Amazon S3.
	//
	// This member is required.
	OutputDataConfig *types.EvaluationOutputDataConfig

	// The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can
	// assume to perform tasks on your behalf. The service role must have Amazon
	// Bedrock as the service principal, and provide access to any Amazon S3 buckets
	// specified in the EvaluationConfig object. To pass this role to Amazon Bedrock,
	// the caller of this API must have the iam:PassRole permission. To learn more
	// about the required permissions, see [Required permissions].
	//
	// [Required permissions]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html
	//
	// This member is required.
	RoleArn *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientRequestToken *string

	// Specify your customer managed key ARN that will be used to encrypt your model
	// evaluation job.
	CustomerEncryptionKeyId *string

	// A description of the model evaluation job.
	JobDescription *string

	// Tags to attach to the model evaluation job.
	JobTags []types.Tag

	noSmithyDocumentSerde
}

type CreateEvaluationJobOutput struct {

	// The ARN of the model evaluation job.
	//
	// This member is required.
	JobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEvaluationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateEvaluationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateEvaluationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEvaluationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateEvaluationJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEvaluationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEvaluationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateEvaluationJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateEvaluationJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateEvaluationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateEvaluationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateEvaluationJobInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateEvaluationJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateEvaluationJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateEvaluationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEvaluationJob",
	}
}
