// Code generated by smithy-go-codegen DO NOT EDIT.

package drs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/drs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Recovery Snapshots for a single Source Server.
func (c *Client) DescribeRecoverySnapshots(ctx context.Context, params *DescribeRecoverySnapshotsInput, optFns ...func(*Options)) (*DescribeRecoverySnapshotsOutput, error) {
	if params == nil {
		params = &DescribeRecoverySnapshotsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRecoverySnapshots", params, optFns, c.addOperationDescribeRecoverySnapshotsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRecoverySnapshotsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRecoverySnapshotsInput struct {

	// Filter Recovery Snapshots by Source Server ID.
	//
	// This member is required.
	SourceServerID *string

	// A set of filters by which to return Recovery Snapshots.
	Filters *types.DescribeRecoverySnapshotsRequestFilters

	// Maximum number of Recovery Snapshots to retrieve.
	MaxResults *int32

	// The token of the next Recovery Snapshot to retrieve.
	NextToken *string

	// The sorted ordering by which to return Recovery Snapshots.
	Order types.RecoverySnapshotsOrder

	noSmithyDocumentSerde
}

type DescribeRecoverySnapshotsOutput struct {

	// An array of Recovery Snapshots.
	Items []types.RecoverySnapshot

	// The token of the next Recovery Snapshot to retrieve.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRecoverySnapshotsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeRecoverySnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeRecoverySnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeRecoverySnapshots"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeRecoverySnapshotsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRecoverySnapshots(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeRecoverySnapshotsAPIClient is a client that implements the
// DescribeRecoverySnapshots operation.
type DescribeRecoverySnapshotsAPIClient interface {
	DescribeRecoverySnapshots(context.Context, *DescribeRecoverySnapshotsInput, ...func(*Options)) (*DescribeRecoverySnapshotsOutput, error)
}

var _ DescribeRecoverySnapshotsAPIClient = (*Client)(nil)

// DescribeRecoverySnapshotsPaginatorOptions is the paginator options for
// DescribeRecoverySnapshots
type DescribeRecoverySnapshotsPaginatorOptions struct {
	// Maximum number of Recovery Snapshots to retrieve.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeRecoverySnapshotsPaginator is a paginator for DescribeRecoverySnapshots
type DescribeRecoverySnapshotsPaginator struct {
	options   DescribeRecoverySnapshotsPaginatorOptions
	client    DescribeRecoverySnapshotsAPIClient
	params    *DescribeRecoverySnapshotsInput
	nextToken *string
	firstPage bool
}

// NewDescribeRecoverySnapshotsPaginator returns a new
// DescribeRecoverySnapshotsPaginator
func NewDescribeRecoverySnapshotsPaginator(client DescribeRecoverySnapshotsAPIClient, params *DescribeRecoverySnapshotsInput, optFns ...func(*DescribeRecoverySnapshotsPaginatorOptions)) *DescribeRecoverySnapshotsPaginator {
	if params == nil {
		params = &DescribeRecoverySnapshotsInput{}
	}

	options := DescribeRecoverySnapshotsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeRecoverySnapshotsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeRecoverySnapshotsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeRecoverySnapshots page.
func (p *DescribeRecoverySnapshotsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeRecoverySnapshotsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeRecoverySnapshots(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeRecoverySnapshots(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRecoverySnapshots",
	}
}
