// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/netapp/v1/volume.proto

package netapppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Protocols is an enum of all the supported network protocols for a volume.
type Protocols int32

const (
	// Unspecified protocol
	Protocols_PROTOCOLS_UNSPECIFIED Protocols = 0
	// NFS V3 protocol
	Protocols_NFSV3 Protocols = 1
	// NFS V4 protocol
	Protocols_NFSV4 Protocols = 2
	// SMB protocol
	Protocols_SMB Protocols = 3
)

// Enum value maps for Protocols.
var (
	Protocols_name = map[int32]string{
		0: "PROTOCOLS_UNSPECIFIED",
		1: "NFSV3",
		2: "NFSV4",
		3: "SMB",
	}
	Protocols_value = map[string]int32{
		"PROTOCOLS_UNSPECIFIED": 0,
		"NFSV3":                 1,
		"NFSV4":                 2,
		"SMB":                   3,
	}
)

func (x Protocols) Enum() *Protocols {
	p := new(Protocols)
	*p = x
	return p
}

func (x Protocols) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Protocols) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_volume_proto_enumTypes[0].Descriptor()
}

func (Protocols) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_volume_proto_enumTypes[0]
}

func (x Protocols) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Protocols.Descriptor instead.
func (Protocols) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{0}
}

// AccessType is an enum of all the supported access types for a volume.
type AccessType int32

const (
	// Unspecified Access Type
	AccessType_ACCESS_TYPE_UNSPECIFIED AccessType = 0
	// Read Only
	AccessType_READ_ONLY AccessType = 1
	// Read Write
	AccessType_READ_WRITE AccessType = 2
	// None
	AccessType_READ_NONE AccessType = 3
)

// Enum value maps for AccessType.
var (
	AccessType_name = map[int32]string{
		0: "ACCESS_TYPE_UNSPECIFIED",
		1: "READ_ONLY",
		2: "READ_WRITE",
		3: "READ_NONE",
	}
	AccessType_value = map[string]int32{
		"ACCESS_TYPE_UNSPECIFIED": 0,
		"READ_ONLY":               1,
		"READ_WRITE":              2,
		"READ_NONE":               3,
	}
)

func (x AccessType) Enum() *AccessType {
	p := new(AccessType)
	*p = x
	return p
}

func (x AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_volume_proto_enumTypes[1].Descriptor()
}

func (AccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_volume_proto_enumTypes[1]
}

func (x AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessType.Descriptor instead.
func (AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{1}
}

// SMBSettings
// Modifies the behaviour of a SMB volume.
type SMBSettings int32

const (
	// Unspecified default option
	SMBSettings_SMB_SETTINGS_UNSPECIFIED SMBSettings = 0
	// SMB setting encrypt data
	SMBSettings_ENCRYPT_DATA SMBSettings = 1
	// SMB setting browsable
	SMBSettings_BROWSABLE SMBSettings = 2
	// SMB setting notify change
	SMBSettings_CHANGE_NOTIFY SMBSettings = 3
	// SMB setting not to notify change
	SMBSettings_NON_BROWSABLE SMBSettings = 4
	// SMB setting oplocks
	SMBSettings_OPLOCKS SMBSettings = 5
	// SMB setting to show snapshots
	SMBSettings_SHOW_SNAPSHOT SMBSettings = 6
	// SMB setting to show previous versions
	SMBSettings_SHOW_PREVIOUS_VERSIONS SMBSettings = 7
	// SMB setting to access volume based on enumerartion
	SMBSettings_ACCESS_BASED_ENUMERATION SMBSettings = 8
	// Continuously available enumeration
	SMBSettings_CONTINUOUSLY_AVAILABLE SMBSettings = 9
)

// Enum value maps for SMBSettings.
var (
	SMBSettings_name = map[int32]string{
		0: "SMB_SETTINGS_UNSPECIFIED",
		1: "ENCRYPT_DATA",
		2: "BROWSABLE",
		3: "CHANGE_NOTIFY",
		4: "NON_BROWSABLE",
		5: "OPLOCKS",
		6: "SHOW_SNAPSHOT",
		7: "SHOW_PREVIOUS_VERSIONS",
		8: "ACCESS_BASED_ENUMERATION",
		9: "CONTINUOUSLY_AVAILABLE",
	}
	SMBSettings_value = map[string]int32{
		"SMB_SETTINGS_UNSPECIFIED": 0,
		"ENCRYPT_DATA":             1,
		"BROWSABLE":                2,
		"CHANGE_NOTIFY":            3,
		"NON_BROWSABLE":            4,
		"OPLOCKS":                  5,
		"SHOW_SNAPSHOT":            6,
		"SHOW_PREVIOUS_VERSIONS":   7,
		"ACCESS_BASED_ENUMERATION": 8,
		"CONTINUOUSLY_AVAILABLE":   9,
	}
)

func (x SMBSettings) Enum() *SMBSettings {
	p := new(SMBSettings)
	*p = x
	return p
}

func (x SMBSettings) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SMBSettings) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_volume_proto_enumTypes[2].Descriptor()
}

func (SMBSettings) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_volume_proto_enumTypes[2]
}

func (x SMBSettings) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SMBSettings.Descriptor instead.
func (SMBSettings) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{2}
}

// The security style of the volume, can be either UNIX or NTFS.
type SecurityStyle int32

const (
	// SecurityStyle is unspecified
	SecurityStyle_SECURITY_STYLE_UNSPECIFIED SecurityStyle = 0
	// SecurityStyle uses NTFS
	SecurityStyle_NTFS SecurityStyle = 1
	// SecurityStyle uses UNIX
	SecurityStyle_UNIX SecurityStyle = 2
)

// Enum value maps for SecurityStyle.
var (
	SecurityStyle_name = map[int32]string{
		0: "SECURITY_STYLE_UNSPECIFIED",
		1: "NTFS",
		2: "UNIX",
	}
	SecurityStyle_value = map[string]int32{
		"SECURITY_STYLE_UNSPECIFIED": 0,
		"NTFS":                       1,
		"UNIX":                       2,
	}
)

func (x SecurityStyle) Enum() *SecurityStyle {
	p := new(SecurityStyle)
	*p = x
	return p
}

func (x SecurityStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_volume_proto_enumTypes[3].Descriptor()
}

func (SecurityStyle) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_volume_proto_enumTypes[3]
}

func (x SecurityStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityStyle.Descriptor instead.
func (SecurityStyle) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{3}
}

// Actions to be restricted for a volume.
type RestrictedAction int32

const (
	// Unspecified restricted action
	RestrictedAction_RESTRICTED_ACTION_UNSPECIFIED RestrictedAction = 0
	// Prevent volume from being deleted when mounted.
	RestrictedAction_DELETE RestrictedAction = 1
)

// Enum value maps for RestrictedAction.
var (
	RestrictedAction_name = map[int32]string{
		0: "RESTRICTED_ACTION_UNSPECIFIED",
		1: "DELETE",
	}
	RestrictedAction_value = map[string]int32{
		"RESTRICTED_ACTION_UNSPECIFIED": 0,
		"DELETE":                        1,
	}
)

func (x RestrictedAction) Enum() *RestrictedAction {
	p := new(RestrictedAction)
	*p = x
	return p
}

func (x RestrictedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestrictedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_volume_proto_enumTypes[4].Descriptor()
}

func (RestrictedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_volume_proto_enumTypes[4]
}

func (x RestrictedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestrictedAction.Descriptor instead.
func (RestrictedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{4}
}

// The volume states
type Volume_State int32

const (
	// Unspecified Volume State
	Volume_STATE_UNSPECIFIED Volume_State = 0
	// Volume State is Ready
	Volume_READY Volume_State = 1
	// Volume State is Creating
	Volume_CREATING Volume_State = 2
	// Volume State is Deleting
	Volume_DELETING Volume_State = 3
	// Volume State is Updating
	Volume_UPDATING Volume_State = 4
	// Volume State is Restoring
	Volume_RESTORING Volume_State = 5
	// Volume State is Disabled
	Volume_DISABLED Volume_State = 6
	// Volume State is Error
	Volume_ERROR Volume_State = 7
)

// Enum value maps for Volume_State.
var (
	Volume_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		2: "CREATING",
		3: "DELETING",
		4: "UPDATING",
		5: "RESTORING",
		6: "DISABLED",
		7: "ERROR",
	}
	Volume_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"CREATING":          2,
		"DELETING":          3,
		"UPDATING":          4,
		"RESTORING":         5,
		"DISABLED":          6,
		"ERROR":             7,
	}
)

func (x Volume_State) Enum() *Volume_State {
	p := new(Volume_State)
	*p = x
	return p
}

func (x Volume_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Volume_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_volume_proto_enumTypes[5].Descriptor()
}

func (Volume_State) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_volume_proto_enumTypes[5]
}

func (x Volume_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Volume_State.Descriptor instead.
func (Volume_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{7, 0}
}

// Message for requesting list of Volumes
type ListVolumesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListVolumesRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVolumesRequest) Reset() {
	*x = ListVolumesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumesRequest) ProtoMessage() {}

func (x *ListVolumesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumesRequest.ProtoReflect.Descriptor instead.
func (*ListVolumesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{0}
}

func (x *ListVolumesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVolumesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVolumesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVolumesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVolumesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Volumes
type ListVolumesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Volume
	Volumes []*Volume `protobuf:"bytes,1,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListVolumesResponse) Reset() {
	*x = ListVolumesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumesResponse) ProtoMessage() {}

func (x *ListVolumesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumesResponse.ProtoReflect.Descriptor instead.
func (*ListVolumesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{1}
}

func (x *ListVolumesResponse) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *ListVolumesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListVolumesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Volume
type GetVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the volume
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVolumeRequest) Reset() {
	*x = GetVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeRequest) ProtoMessage() {}

func (x *GetVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeRequest.ProtoReflect.Descriptor instead.
func (*GetVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{2}
}

func (x *GetVolumeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Volume
type CreateVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting volume
	// If auto-generating Id server-side, remove this field and
	// Id from the method_signature of Create RPC
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Required. The volume being created.
	Volume *Volume `protobuf:"bytes,3,opt,name=volume,proto3" json:"volume,omitempty"`
}

func (x *CreateVolumeRequest) Reset() {
	*x = CreateVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVolumeRequest) ProtoMessage() {}

func (x *CreateVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVolumeRequest.ProtoReflect.Descriptor instead.
func (*CreateVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{3}
}

func (x *CreateVolumeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVolumeRequest) GetVolumeId() string {
	if x != nil {
		return x.VolumeId
	}
	return ""
}

func (x *CreateVolumeRequest) GetVolume() *Volume {
	if x != nil {
		return x.Volume
	}
	return nil
}

// Message for updating a Volume
type UpdateVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Volume resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The volume being updated
	Volume *Volume `protobuf:"bytes,2,opt,name=volume,proto3" json:"volume,omitempty"`
}

func (x *UpdateVolumeRequest) Reset() {
	*x = UpdateVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVolumeRequest) ProtoMessage() {}

func (x *UpdateVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVolumeRequest.ProtoReflect.Descriptor instead.
func (*UpdateVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateVolumeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateVolumeRequest) GetVolume() *Volume {
	if x != nil {
		return x.Volume
	}
	return nil
}

// Message for deleting a Volume
type DeleteVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the volume
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If this field is set as true, CCFE will not block the volume resource
	// deletion even if it has any snapshots resource. (Otherwise, the request
	// will only work if the volume has no snapshots.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteVolumeRequest) Reset() {
	*x = DeleteVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVolumeRequest) ProtoMessage() {}

func (x *DeleteVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVolumeRequest.ProtoReflect.Descriptor instead.
func (*DeleteVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteVolumeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteVolumeRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// RevertVolumeRequest reverts the given volume to the specified snapshot.
type RevertVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the volume, in the format of
	// projects/{project_id}/locations/{location}/volumes/{volume_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The snapshot resource ID, in the format 'my-snapshot', where the
	// specified ID is the {snapshot_id} of the fully qualified name like
	// projects/{project_id}/locations/{location_id}/volumes/{volume_id}/snapshots/{snapshot_id}
	SnapshotId string `protobuf:"bytes,2,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
}

func (x *RevertVolumeRequest) Reset() {
	*x = RevertVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RevertVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevertVolumeRequest) ProtoMessage() {}

func (x *RevertVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevertVolumeRequest.ProtoReflect.Descriptor instead.
func (*RevertVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{6}
}

func (x *RevertVolumeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RevertVolumeRequest) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

// Volume provides a filesystem that you can mount.
type Volume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the volume
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the volume
	State Volume_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.netapp.v1.Volume_State" json:"state,omitempty"`
	// Output only. State details of the volume
	StateDetails string `protobuf:"bytes,3,opt,name=state_details,json=stateDetails,proto3" json:"state_details,omitempty"`
	// Output only. Create time of the volume
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Required. Share name of the volume
	ShareName string `protobuf:"bytes,5,opt,name=share_name,json=shareName,proto3" json:"share_name,omitempty"`
	// Output only. This field is not implemented. The values provided in this
	// field are ignored.
	PsaRange string `protobuf:"bytes,6,opt,name=psa_range,json=psaRange,proto3" json:"psa_range,omitempty"`
	// Required. StoragePool name of the volume
	StoragePool string `protobuf:"bytes,7,opt,name=storage_pool,json=storagePool,proto3" json:"storage_pool,omitempty"`
	// Output only. VPC Network name.
	// Format: projects/{project}/global/networks/{network}
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. Service level of the volume
	ServiceLevel ServiceLevel `protobuf:"varint,9,opt,name=service_level,json=serviceLevel,proto3,enum=google.cloud.netapp.v1.ServiceLevel" json:"service_level,omitempty"`
	// Required. Capacity in GIB of the volume
	CapacityGib int64 `protobuf:"varint,10,opt,name=capacity_gib,json=capacityGib,proto3" json:"capacity_gib,omitempty"`
	// Optional. Export policy of the volume
	ExportPolicy *ExportPolicy `protobuf:"bytes,11,opt,name=export_policy,json=exportPolicy,proto3" json:"export_policy,omitempty"`
	// Required. Protocols required for the volume
	Protocols []Protocols `protobuf:"varint,12,rep,packed,name=protocols,proto3,enum=google.cloud.netapp.v1.Protocols" json:"protocols,omitempty"`
	// Optional. SMB share settings for the volume.
	SmbSettings []SMBSettings `protobuf:"varint,13,rep,packed,name=smb_settings,json=smbSettings,proto3,enum=google.cloud.netapp.v1.SMBSettings" json:"smb_settings,omitempty"`
	// Output only. Mount options of this volume
	MountOptions []*MountOption `protobuf:"bytes,14,rep,name=mount_options,json=mountOptions,proto3" json:"mount_options,omitempty"`
	// Optional. Default unix style permission (e.g. 777) the mount point will be
	// created with. Applicable for NFS protocol types only.
	UnixPermissions string `protobuf:"bytes,15,opt,name=unix_permissions,json=unixPermissions,proto3" json:"unix_permissions,omitempty"`
	// Optional. Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,16,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the volume
	Description string `protobuf:"bytes,17,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. SnapshotPolicy for a volume.
	SnapshotPolicy *SnapshotPolicy `protobuf:"bytes,18,opt,name=snapshot_policy,json=snapshotPolicy,proto3" json:"snapshot_policy,omitempty"`
	// Optional. Snap_reserve specifies percentage of volume storage reserved for
	// snapshot storage. Default is 0 percent.
	SnapReserve float64 `protobuf:"fixed64,19,opt,name=snap_reserve,json=snapReserve,proto3" json:"snap_reserve,omitempty"`
	// Optional. Snapshot_directory if enabled (true) the volume will contain a
	// read-only .snapshot directory which provides access to each of the volume's
	// snapshots.
	SnapshotDirectory bool `protobuf:"varint,20,opt,name=snapshot_directory,json=snapshotDirectory,proto3" json:"snapshot_directory,omitempty"`
	// Output only. Used capacity in GIB of the volume. This is computed
	// periodically and it does not represent the realtime usage.
	UsedGib int64 `protobuf:"varint,21,opt,name=used_gib,json=usedGib,proto3" json:"used_gib,omitempty"`
	// Optional. Security Style of the Volume
	SecurityStyle SecurityStyle `protobuf:"varint,22,opt,name=security_style,json=securityStyle,proto3,enum=google.cloud.netapp.v1.SecurityStyle" json:"security_style,omitempty"`
	// Optional. Flag indicating if the volume is a kerberos volume or not, export
	// policy rules control kerberos security modes (krb5, krb5i, krb5p).
	KerberosEnabled bool `protobuf:"varint,23,opt,name=kerberos_enabled,json=kerberosEnabled,proto3" json:"kerberos_enabled,omitempty"`
	// Output only. Flag indicating if the volume is NFS LDAP enabled or not.
	LdapEnabled bool `protobuf:"varint,24,opt,name=ldap_enabled,json=ldapEnabled,proto3" json:"ldap_enabled,omitempty"`
	// Output only. Specifies the ActiveDirectory name of a SMB volume.
	ActiveDirectory string `protobuf:"bytes,25,opt,name=active_directory,json=activeDirectory,proto3" json:"active_directory,omitempty"`
	// Optional. Specifies the source of the volume to be created from.
	RestoreParameters *RestoreParameters `protobuf:"bytes,26,opt,name=restore_parameters,json=restoreParameters,proto3" json:"restore_parameters,omitempty"`
	// Output only. Specifies the KMS config to be used for volume encryption.
	KmsConfig string `protobuf:"bytes,27,opt,name=kms_config,json=kmsConfig,proto3" json:"kms_config,omitempty"`
	// Output only. Specified the current volume encryption key source.
	EncryptionType EncryptionType `protobuf:"varint,28,opt,name=encryption_type,json=encryptionType,proto3,enum=google.cloud.netapp.v1.EncryptionType" json:"encryption_type,omitempty"`
	// Output only. Indicates whether the volume is part of a replication
	// relationship.
	HasReplication bool `protobuf:"varint,29,opt,name=has_replication,json=hasReplication,proto3" json:"has_replication,omitempty"`
	// BackupConfig of the volume.
	BackupConfig *BackupConfig `protobuf:"bytes,30,opt,name=backup_config,json=backupConfig,proto3,oneof" json:"backup_config,omitempty"`
	// Optional. List of actions that are restricted on this volume.
	RestrictedActions []RestrictedAction `protobuf:"varint,31,rep,packed,name=restricted_actions,json=restrictedActions,proto3,enum=google.cloud.netapp.v1.RestrictedAction" json:"restricted_actions,omitempty"`
}

func (x *Volume) Reset() {
	*x = Volume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Volume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Volume) ProtoMessage() {}

func (x *Volume) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Volume.ProtoReflect.Descriptor instead.
func (*Volume) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{7}
}

func (x *Volume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Volume) GetState() Volume_State {
	if x != nil {
		return x.State
	}
	return Volume_STATE_UNSPECIFIED
}

func (x *Volume) GetStateDetails() string {
	if x != nil {
		return x.StateDetails
	}
	return ""
}

func (x *Volume) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Volume) GetShareName() string {
	if x != nil {
		return x.ShareName
	}
	return ""
}

func (x *Volume) GetPsaRange() string {
	if x != nil {
		return x.PsaRange
	}
	return ""
}

func (x *Volume) GetStoragePool() string {
	if x != nil {
		return x.StoragePool
	}
	return ""
}

func (x *Volume) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Volume) GetServiceLevel() ServiceLevel {
	if x != nil {
		return x.ServiceLevel
	}
	return ServiceLevel_SERVICE_LEVEL_UNSPECIFIED
}

func (x *Volume) GetCapacityGib() int64 {
	if x != nil {
		return x.CapacityGib
	}
	return 0
}

func (x *Volume) GetExportPolicy() *ExportPolicy {
	if x != nil {
		return x.ExportPolicy
	}
	return nil
}

func (x *Volume) GetProtocols() []Protocols {
	if x != nil {
		return x.Protocols
	}
	return nil
}

func (x *Volume) GetSmbSettings() []SMBSettings {
	if x != nil {
		return x.SmbSettings
	}
	return nil
}

func (x *Volume) GetMountOptions() []*MountOption {
	if x != nil {
		return x.MountOptions
	}
	return nil
}

func (x *Volume) GetUnixPermissions() string {
	if x != nil {
		return x.UnixPermissions
	}
	return ""
}

func (x *Volume) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Volume) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Volume) GetSnapshotPolicy() *SnapshotPolicy {
	if x != nil {
		return x.SnapshotPolicy
	}
	return nil
}

func (x *Volume) GetSnapReserve() float64 {
	if x != nil {
		return x.SnapReserve
	}
	return 0
}

func (x *Volume) GetSnapshotDirectory() bool {
	if x != nil {
		return x.SnapshotDirectory
	}
	return false
}

func (x *Volume) GetUsedGib() int64 {
	if x != nil {
		return x.UsedGib
	}
	return 0
}

func (x *Volume) GetSecurityStyle() SecurityStyle {
	if x != nil {
		return x.SecurityStyle
	}
	return SecurityStyle_SECURITY_STYLE_UNSPECIFIED
}

func (x *Volume) GetKerberosEnabled() bool {
	if x != nil {
		return x.KerberosEnabled
	}
	return false
}

func (x *Volume) GetLdapEnabled() bool {
	if x != nil {
		return x.LdapEnabled
	}
	return false
}

func (x *Volume) GetActiveDirectory() string {
	if x != nil {
		return x.ActiveDirectory
	}
	return ""
}

func (x *Volume) GetRestoreParameters() *RestoreParameters {
	if x != nil {
		return x.RestoreParameters
	}
	return nil
}

func (x *Volume) GetKmsConfig() string {
	if x != nil {
		return x.KmsConfig
	}
	return ""
}

func (x *Volume) GetEncryptionType() EncryptionType {
	if x != nil {
		return x.EncryptionType
	}
	return EncryptionType_ENCRYPTION_TYPE_UNSPECIFIED
}

func (x *Volume) GetHasReplication() bool {
	if x != nil {
		return x.HasReplication
	}
	return false
}

func (x *Volume) GetBackupConfig() *BackupConfig {
	if x != nil {
		return x.BackupConfig
	}
	return nil
}

func (x *Volume) GetRestrictedActions() []RestrictedAction {
	if x != nil {
		return x.RestrictedActions
	}
	return nil
}

// Defines the export policy for the volume.
type ExportPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of export policy rules
	Rules []*SimpleExportPolicyRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ExportPolicy) Reset() {
	*x = ExportPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPolicy) ProtoMessage() {}

func (x *ExportPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPolicy.ProtoReflect.Descriptor instead.
func (*ExportPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{8}
}

func (x *ExportPolicy) GetRules() []*SimpleExportPolicyRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// An export policy rule describing various export options.
type SimpleExportPolicyRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Comma separated list of allowed clients IP addresses
	AllowedClients *string `protobuf:"bytes,1,opt,name=allowed_clients,json=allowedClients,proto3,oneof" json:"allowed_clients,omitempty"`
	// Whether Unix root access will be granted.
	HasRootAccess *string `protobuf:"bytes,2,opt,name=has_root_access,json=hasRootAccess,proto3,oneof" json:"has_root_access,omitempty"`
	// Access type (ReadWrite, ReadOnly, None)
	AccessType *AccessType `protobuf:"varint,3,opt,name=access_type,json=accessType,proto3,enum=google.cloud.netapp.v1.AccessType,oneof" json:"access_type,omitempty"`
	// NFS V3 protocol.
	Nfsv3 *bool `protobuf:"varint,4,opt,name=nfsv3,proto3,oneof" json:"nfsv3,omitempty"`
	// NFS V4 protocol.
	Nfsv4 *bool `protobuf:"varint,5,opt,name=nfsv4,proto3,oneof" json:"nfsv4,omitempty"`
	// If enabled (true) the rule defines a read only access for clients matching
	// the 'allowedClients' specification. It enables nfs clients to mount using
	// 'authentication' kerberos security mode.
	Kerberos_5ReadOnly *bool `protobuf:"varint,6,opt,name=kerberos_5_read_only,json=kerberos5ReadOnly,proto3,oneof" json:"kerberos_5_read_only,omitempty"`
	// If enabled (true) the rule defines read and write access for clients
	// matching the 'allowedClients' specification. It enables nfs clients to
	// mount using 'authentication' kerberos security mode. The
	// 'kerberos5ReadOnly' value be ignored if this is enabled.
	Kerberos_5ReadWrite *bool `protobuf:"varint,7,opt,name=kerberos_5_read_write,json=kerberos5ReadWrite,proto3,oneof" json:"kerberos_5_read_write,omitempty"`
	// If enabled (true) the rule defines a read only access for clients matching
	// the 'allowedClients' specification. It enables nfs clients to mount using
	// 'integrity' kerberos security mode.
	Kerberos_5IReadOnly *bool `protobuf:"varint,8,opt,name=kerberos_5i_read_only,json=kerberos5iReadOnly,proto3,oneof" json:"kerberos_5i_read_only,omitempty"`
	// If enabled (true) the rule defines read and write access for clients
	// matching the 'allowedClients' specification. It enables nfs clients to
	// mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly'
	// value be ignored if this is enabled.
	Kerberos_5IReadWrite *bool `protobuf:"varint,9,opt,name=kerberos_5i_read_write,json=kerberos5iReadWrite,proto3,oneof" json:"kerberos_5i_read_write,omitempty"`
	// If enabled (true) the rule defines a read only access for clients matching
	// the 'allowedClients' specification. It enables nfs clients to mount using
	// 'privacy' kerberos security mode.
	Kerberos_5PReadOnly *bool `protobuf:"varint,10,opt,name=kerberos_5p_read_only,json=kerberos5pReadOnly,proto3,oneof" json:"kerberos_5p_read_only,omitempty"`
	// If enabled (true) the rule defines read and write access for clients
	// matching the 'allowedClients' specification. It enables nfs clients to
	// mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly'
	// value be ignored if this is enabled.
	Kerberos_5PReadWrite *bool `protobuf:"varint,11,opt,name=kerberos_5p_read_write,json=kerberos5pReadWrite,proto3,oneof" json:"kerberos_5p_read_write,omitempty"`
}

func (x *SimpleExportPolicyRule) Reset() {
	*x = SimpleExportPolicyRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimpleExportPolicyRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimpleExportPolicyRule) ProtoMessage() {}

func (x *SimpleExportPolicyRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimpleExportPolicyRule.ProtoReflect.Descriptor instead.
func (*SimpleExportPolicyRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{9}
}

func (x *SimpleExportPolicyRule) GetAllowedClients() string {
	if x != nil && x.AllowedClients != nil {
		return *x.AllowedClients
	}
	return ""
}

func (x *SimpleExportPolicyRule) GetHasRootAccess() string {
	if x != nil && x.HasRootAccess != nil {
		return *x.HasRootAccess
	}
	return ""
}

func (x *SimpleExportPolicyRule) GetAccessType() AccessType {
	if x != nil && x.AccessType != nil {
		return *x.AccessType
	}
	return AccessType_ACCESS_TYPE_UNSPECIFIED
}

func (x *SimpleExportPolicyRule) GetNfsv3() bool {
	if x != nil && x.Nfsv3 != nil {
		return *x.Nfsv3
	}
	return false
}

func (x *SimpleExportPolicyRule) GetNfsv4() bool {
	if x != nil && x.Nfsv4 != nil {
		return *x.Nfsv4
	}
	return false
}

func (x *SimpleExportPolicyRule) GetKerberos_5ReadOnly() bool {
	if x != nil && x.Kerberos_5ReadOnly != nil {
		return *x.Kerberos_5ReadOnly
	}
	return false
}

func (x *SimpleExportPolicyRule) GetKerberos_5ReadWrite() bool {
	if x != nil && x.Kerberos_5ReadWrite != nil {
		return *x.Kerberos_5ReadWrite
	}
	return false
}

func (x *SimpleExportPolicyRule) GetKerberos_5IReadOnly() bool {
	if x != nil && x.Kerberos_5IReadOnly != nil {
		return *x.Kerberos_5IReadOnly
	}
	return false
}

func (x *SimpleExportPolicyRule) GetKerberos_5IReadWrite() bool {
	if x != nil && x.Kerberos_5IReadWrite != nil {
		return *x.Kerberos_5IReadWrite
	}
	return false
}

func (x *SimpleExportPolicyRule) GetKerberos_5PReadOnly() bool {
	if x != nil && x.Kerberos_5PReadOnly != nil {
		return *x.Kerberos_5PReadOnly
	}
	return false
}

func (x *SimpleExportPolicyRule) GetKerberos_5PReadWrite() bool {
	if x != nil && x.Kerberos_5PReadWrite != nil {
		return *x.Kerberos_5PReadWrite
	}
	return false
}

// Snapshot Policy for a volume.
type SnapshotPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If enabled, make snapshots automatically according to the schedules.
	// Default is false.
	Enabled *bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
	// Hourly schedule policy.
	HourlySchedule *HourlySchedule `protobuf:"bytes,2,opt,name=hourly_schedule,json=hourlySchedule,proto3,oneof" json:"hourly_schedule,omitempty"`
	// Daily schedule policy.
	DailySchedule *DailySchedule `protobuf:"bytes,3,opt,name=daily_schedule,json=dailySchedule,proto3,oneof" json:"daily_schedule,omitempty"`
	// Weekly schedule policy.
	WeeklySchedule *WeeklySchedule `protobuf:"bytes,4,opt,name=weekly_schedule,json=weeklySchedule,proto3,oneof" json:"weekly_schedule,omitempty"`
	// Monthly schedule policy.
	MonthlySchedule *MonthlySchedule `protobuf:"bytes,5,opt,name=monthly_schedule,json=monthlySchedule,proto3,oneof" json:"monthly_schedule,omitempty"`
}

func (x *SnapshotPolicy) Reset() {
	*x = SnapshotPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotPolicy) ProtoMessage() {}

func (x *SnapshotPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotPolicy.ProtoReflect.Descriptor instead.
func (*SnapshotPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{10}
}

func (x *SnapshotPolicy) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

func (x *SnapshotPolicy) GetHourlySchedule() *HourlySchedule {
	if x != nil {
		return x.HourlySchedule
	}
	return nil
}

func (x *SnapshotPolicy) GetDailySchedule() *DailySchedule {
	if x != nil {
		return x.DailySchedule
	}
	return nil
}

func (x *SnapshotPolicy) GetWeeklySchedule() *WeeklySchedule {
	if x != nil {
		return x.WeeklySchedule
	}
	return nil
}

func (x *SnapshotPolicy) GetMonthlySchedule() *MonthlySchedule {
	if x != nil {
		return x.MonthlySchedule
	}
	return nil
}

// Make a snapshot every hour e.g. at 04:00, 05:00, 06:00.
type HourlySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of Snapshots to keep for the hourly schedule
	SnapshotsToKeep *float64 `protobuf:"fixed64,1,opt,name=snapshots_to_keep,json=snapshotsToKeep,proto3,oneof" json:"snapshots_to_keep,omitempty"`
	// Set the minute of the hour to start the snapshot (0-59), defaults to the
	// top of the hour (0).
	Minute *float64 `protobuf:"fixed64,2,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
}

func (x *HourlySchedule) Reset() {
	*x = HourlySchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HourlySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HourlySchedule) ProtoMessage() {}

func (x *HourlySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HourlySchedule.ProtoReflect.Descriptor instead.
func (*HourlySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{11}
}

func (x *HourlySchedule) GetSnapshotsToKeep() float64 {
	if x != nil && x.SnapshotsToKeep != nil {
		return *x.SnapshotsToKeep
	}
	return 0
}

func (x *HourlySchedule) GetMinute() float64 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

// Make a snapshot every day e.g. at 04:00, 05:20, 23:50
type DailySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of Snapshots to keep for the hourly schedule
	SnapshotsToKeep *float64 `protobuf:"fixed64,1,opt,name=snapshots_to_keep,json=snapshotsToKeep,proto3,oneof" json:"snapshots_to_keep,omitempty"`
	// Set the minute of the hour to start the snapshot (0-59), defaults to the
	// top of the hour (0).
	Minute *float64 `protobuf:"fixed64,2,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
	// Set the hour to start the snapshot (0-23), defaults to midnight (0).
	Hour *float64 `protobuf:"fixed64,3,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
}

func (x *DailySchedule) Reset() {
	*x = DailySchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailySchedule) ProtoMessage() {}

func (x *DailySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailySchedule.ProtoReflect.Descriptor instead.
func (*DailySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{12}
}

func (x *DailySchedule) GetSnapshotsToKeep() float64 {
	if x != nil && x.SnapshotsToKeep != nil {
		return *x.SnapshotsToKeep
	}
	return 0
}

func (x *DailySchedule) GetMinute() float64 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

func (x *DailySchedule) GetHour() float64 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

// Make a snapshot every week e.g. at Monday 04:00, Wednesday 05:20, Sunday
// 23:50
type WeeklySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of Snapshots to keep for the hourly schedule
	SnapshotsToKeep *float64 `protobuf:"fixed64,1,opt,name=snapshots_to_keep,json=snapshotsToKeep,proto3,oneof" json:"snapshots_to_keep,omitempty"`
	// Set the minute of the hour to start the snapshot (0-59), defaults to the
	// top of the hour (0).
	Minute *float64 `protobuf:"fixed64,2,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
	// Set the hour to start the snapshot (0-23), defaults to midnight (0).
	Hour *float64 `protobuf:"fixed64,3,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// Set the day or days of the week to make a snapshot. Accepts a comma
	// separated days of the week. Defaults to 'Sunday'.
	Day *string `protobuf:"bytes,4,opt,name=day,proto3,oneof" json:"day,omitempty"`
}

func (x *WeeklySchedule) Reset() {
	*x = WeeklySchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WeeklySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeeklySchedule) ProtoMessage() {}

func (x *WeeklySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeeklySchedule.ProtoReflect.Descriptor instead.
func (*WeeklySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{13}
}

func (x *WeeklySchedule) GetSnapshotsToKeep() float64 {
	if x != nil && x.SnapshotsToKeep != nil {
		return *x.SnapshotsToKeep
	}
	return 0
}

func (x *WeeklySchedule) GetMinute() float64 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

func (x *WeeklySchedule) GetHour() float64 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *WeeklySchedule) GetDay() string {
	if x != nil && x.Day != nil {
		return *x.Day
	}
	return ""
}

// Make a snapshot once a month e.g. at 2nd 04:00, 7th 05:20, 24th 23:50
type MonthlySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of Snapshots to keep for the hourly schedule
	SnapshotsToKeep *float64 `protobuf:"fixed64,1,opt,name=snapshots_to_keep,json=snapshotsToKeep,proto3,oneof" json:"snapshots_to_keep,omitempty"`
	// Set the minute of the hour to start the snapshot (0-59), defaults to the
	// top of the hour (0).
	Minute *float64 `protobuf:"fixed64,2,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
	// Set the hour to start the snapshot (0-23), defaults to midnight (0).
	Hour *float64 `protobuf:"fixed64,3,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// Set the day or days of the month to make a snapshot (1-31). Accepts a
	// comma separated number of days. Defaults to '1'.
	DaysOfMonth *string `protobuf:"bytes,4,opt,name=days_of_month,json=daysOfMonth,proto3,oneof" json:"days_of_month,omitempty"`
}

func (x *MonthlySchedule) Reset() {
	*x = MonthlySchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonthlySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonthlySchedule) ProtoMessage() {}

func (x *MonthlySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonthlySchedule.ProtoReflect.Descriptor instead.
func (*MonthlySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{14}
}

func (x *MonthlySchedule) GetSnapshotsToKeep() float64 {
	if x != nil && x.SnapshotsToKeep != nil {
		return *x.SnapshotsToKeep
	}
	return 0
}

func (x *MonthlySchedule) GetMinute() float64 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

func (x *MonthlySchedule) GetHour() float64 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *MonthlySchedule) GetDaysOfMonth() string {
	if x != nil && x.DaysOfMonth != nil {
		return *x.DaysOfMonth
	}
	return ""
}

// View only mount options for a volume.
type MountOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Export string
	Export string `protobuf:"bytes,1,opt,name=export,proto3" json:"export,omitempty"`
	// Full export string
	ExportFull string `protobuf:"bytes,2,opt,name=export_full,json=exportFull,proto3" json:"export_full,omitempty"`
	// Protocol to mount with.
	Protocol Protocols `protobuf:"varint,3,opt,name=protocol,proto3,enum=google.cloud.netapp.v1.Protocols" json:"protocol,omitempty"`
	// Instructions for mounting
	Instructions string `protobuf:"bytes,4,opt,name=instructions,proto3" json:"instructions,omitempty"`
}

func (x *MountOption) Reset() {
	*x = MountOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MountOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MountOption) ProtoMessage() {}

func (x *MountOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MountOption.ProtoReflect.Descriptor instead.
func (*MountOption) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{15}
}

func (x *MountOption) GetExport() string {
	if x != nil {
		return x.Export
	}
	return ""
}

func (x *MountOption) GetExportFull() string {
	if x != nil {
		return x.ExportFull
	}
	return ""
}

func (x *MountOption) GetProtocol() Protocols {
	if x != nil {
		return x.Protocol
	}
	return Protocols_PROTOCOLS_UNSPECIFIED
}

func (x *MountOption) GetInstructions() string {
	if x != nil {
		return x.Instructions
	}
	return ""
}

// The RestoreParameters if volume is created from a snapshot or backup.
type RestoreParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source that the volume is created from.
	//
	// Types that are assignable to Source:
	//
	//	*RestoreParameters_SourceSnapshot
	//	*RestoreParameters_SourceBackup
	Source isRestoreParameters_Source `protobuf_oneof:"source"`
}

func (x *RestoreParameters) Reset() {
	*x = RestoreParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreParameters) ProtoMessage() {}

func (x *RestoreParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreParameters.ProtoReflect.Descriptor instead.
func (*RestoreParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{16}
}

func (m *RestoreParameters) GetSource() isRestoreParameters_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *RestoreParameters) GetSourceSnapshot() string {
	if x, ok := x.GetSource().(*RestoreParameters_SourceSnapshot); ok {
		return x.SourceSnapshot
	}
	return ""
}

func (x *RestoreParameters) GetSourceBackup() string {
	if x, ok := x.GetSource().(*RestoreParameters_SourceBackup); ok {
		return x.SourceBackup
	}
	return ""
}

type isRestoreParameters_Source interface {
	isRestoreParameters_Source()
}

type RestoreParameters_SourceSnapshot struct {
	// Full name of the snapshot resource.
	// Format:
	// projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
	SourceSnapshot string `protobuf:"bytes,1,opt,name=source_snapshot,json=sourceSnapshot,proto3,oneof"`
}

type RestoreParameters_SourceBackup struct {
	// Full name of the backup resource.
	// Format:
	// projects/{project}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}
	SourceBackup string `protobuf:"bytes,2,opt,name=source_backup,json=sourceBackup,proto3,oneof"`
}

func (*RestoreParameters_SourceSnapshot) isRestoreParameters_Source() {}

func (*RestoreParameters_SourceBackup) isRestoreParameters_Source() {}

// BackupConfig contains backup related config on a volume.
type BackupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. When specified, schedule backups will be created based on the
	// policy configuration.
	BackupPolicies []string `protobuf:"bytes,1,rep,name=backup_policies,json=backupPolicies,proto3" json:"backup_policies,omitempty"`
	// Optional. Name of backup vault.
	// Format:
	// projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}
	BackupVault string `protobuf:"bytes,2,opt,name=backup_vault,json=backupVault,proto3" json:"backup_vault,omitempty"`
	// Optional. When set to true, scheduled backup is enabled on the volume.
	// This field should be nil when there's no backup policy attached.
	ScheduledBackupEnabled *bool `protobuf:"varint,3,opt,name=scheduled_backup_enabled,json=scheduledBackupEnabled,proto3,oneof" json:"scheduled_backup_enabled,omitempty"`
}

func (x *BackupConfig) Reset() {
	*x = BackupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupConfig) ProtoMessage() {}

func (x *BackupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_volume_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupConfig.ProtoReflect.Descriptor instead.
func (*BackupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_volume_proto_rawDescGZIP(), []int{17}
}

func (x *BackupConfig) GetBackupPolicies() []string {
	if x != nil {
		return x.BackupPolicies
	}
	return nil
}

func (x *BackupConfig) GetBackupVault() string {
	if x != nil {
		return x.BackupVault
	}
	return ""
}

func (x *BackupConfig) GetScheduledBackupEnabled() bool {
	if x != nil && x.ScheduledBackupEnabled != nil {
		return *x.ScheduledBackupEnabled
	}
	return false
}

var File_google_cloud_netapp_v1_volume_proto protoreflect.FileDescriptor

var file_google_cloud_netapp_v1_volume_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xc1, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e,
	0x12, 0x1c, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x99, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a,
	0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x07,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x4c, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb2, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x12,
	0x1c, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3b,
	0x0a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x22, 0x75, 0x0a, 0x13, 0x52, 0x65, 0x76, 0x65, 0x72, 0x74, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a,
	0x1c, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x49, 0x64, 0x22, 0xd6, 0x11, 0x0a, 0x06, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x73, 0x61, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x73, 0x61, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x4c, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x40,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x4e, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x12, 0x26, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x69, 0x62,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x47, 0x69, 0x62, 0x12, 0x4e, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x44, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x12, 0x4b,
	0x0a, 0x0c, 0x73, 0x6d, 0x62, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0d,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x4d,
	0x42, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x73, 0x6d, 0x62, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x75, 0x6e,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x75, 0x6e,
	0x69, 0x78, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x75, 0x6e, 0x69, 0x78, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x26, 0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x6e, 0x61,
	0x70, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x12, 0x32, 0x0a, 0x12, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1e, 0x0a, 0x08,
	0x75, 0x73, 0x65, 0x64, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x15, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x75, 0x73, 0x65, 0x64, 0x47, 0x69, 0x62, 0x12, 0x51, 0x0a, 0x0e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12,
	0x2e, 0x0a, 0x10, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x26, 0x0a, 0x0c, 0x6c, 0x64, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x18, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6c, 0x64, 0x61, 0x70,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x58, 0x0a, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x5d, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x46, 0x0a, 0x0a, 0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1b,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x6b,
	0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x68, 0x61, 0x73, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x68, 0x61,
	0x73, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0d,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x5c, 0x0a, 0x12,
	0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x1f, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45,
	0x53, 0x54, 0x4f, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x07, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x1c, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x7d, 0x2a,
	0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x32, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x59, 0x0a, 0x0c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x49, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x70, 0x6c,
	0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xae, 0x06,
	0x0a, 0x16, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x68, 0x61, 0x73, 0x5f, 0x72, 0x6f,
	0x6f, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x01, 0x52, 0x0d, 0x68, 0x61, 0x73, 0x52, 0x6f, 0x6f, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x48, 0x02, 0x52, 0x0a,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a,
	0x05, 0x6e, 0x66, 0x73, 0x76, 0x33, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x05,
	0x6e, 0x66, 0x73, 0x76, 0x33, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x6e, 0x66, 0x73, 0x76,
	0x34, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x04, 0x52, 0x05, 0x6e, 0x66, 0x73, 0x76, 0x34,
	0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x14, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f,
	0x35, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x05, 0x52, 0x11, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x35, 0x52, 0x65,
	0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x15, 0x6b, 0x65, 0x72,
	0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x06, 0x52, 0x12, 0x6b, 0x65, 0x72, 0x62,
	0x65, 0x72, 0x6f, 0x73, 0x35, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x36, 0x0a, 0x15, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35, 0x69,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x07, 0x52, 0x12, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x35, 0x69, 0x52, 0x65,
	0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x16, 0x6b, 0x65, 0x72,
	0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35, 0x69, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x08, 0x52, 0x13, 0x6b, 0x65, 0x72,
	0x62, 0x65, 0x72, 0x6f, 0x73, 0x35, 0x69, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x15, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f,
	0x35, 0x70, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x09, 0x52, 0x12, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x35, 0x70,
	0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x16, 0x6b,
	0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35, 0x70, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0a, 0x52, 0x13, 0x6b,
	0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x35, 0x70, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x68, 0x61,
	0x73, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x08, 0x0a,
	0x06, 0x5f, 0x6e, 0x66, 0x73, 0x76, 0x33, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6e, 0x66, 0x73, 0x76,
	0x34, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x6b,
	0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f,
	0x73, 0x5f, 0x35, 0x69, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x19,
	0x0a, 0x17, 0x5f, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35, 0x69, 0x5f, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x6b, 0x65,
	0x72, 0x62, 0x65, 0x72, 0x6f, 0x73, 0x5f, 0x35, 0x70, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x6b, 0x65, 0x72, 0x62, 0x65, 0x72, 0x6f, 0x73,
	0x5f, 0x35, 0x70, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x22, 0xe3,
	0x03, 0x0a, 0x0e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x54, 0x0a, 0x0f, 0x68, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x48, 0x01, 0x52, 0x0e, 0x68, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x51, 0x0a, 0x0e, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x02, 0x52, 0x0d, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x0f, 0x77, 0x65, 0x65,
	0x6b, 0x6c, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x65, 0x6b,
	0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x03, 0x52, 0x0e, 0x77, 0x65,
	0x65, 0x6b, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x57, 0x0a, 0x10, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x48, 0x04, 0x52, 0x0f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x64, 0x61, 0x69,
	0x6c, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x22, 0x7f, 0x0a, 0x0e, 0x48, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x54, 0x6f,
	0x4b, 0x65, 0x65, 0x70, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74,
	0x65, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65, 0x70, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x0d, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x54,
	0x6f, 0x4b, 0x65, 0x65, 0x70, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x88, 0x01, 0x01, 0x42, 0x14,
	0x0a, 0x12, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x5f,
	0x6b, 0x65, 0x65, 0x70, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x42,
	0x07, 0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x22, 0xc0, 0x01, 0x0a, 0x0e, 0x57, 0x65, 0x65,
	0x6b, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x54, 0x6f, 0x4b, 0x65, 0x65, 0x70, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06,
	0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x06,
	0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x6f, 0x75,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x88,
	0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x64, 0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x03, 0x52, 0x03, 0x64, 0x61, 0x79, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x65, 0x70, 0x42,
	0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x68,
	0x6f, 0x75, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x64, 0x61, 0x79, 0x22, 0xdd, 0x01, 0x0a, 0x0f,
	0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x2f, 0x0a, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x5f,
	0x6b, 0x65, 0x65, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x54, 0x6f, 0x4b, 0x65, 0x65, 0x70, 0x88, 0x01, 0x01,
	0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x01, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a,
	0x04, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x04, 0x68,
	0x6f, 0x75, 0x72, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0d, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x6f,
	0x66, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52,
	0x0b, 0x64, 0x61, 0x79, 0x73, 0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x88, 0x01, 0x01, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x74, 0x6f,
	0x5f, 0x6b, 0x65, 0x65, 0x70, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x64, 0x61,
	0x79, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x22, 0xa9, 0x01, 0x0a, 0x0b,
	0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x75,
	0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x46, 0x75, 0x6c, 0x6c, 0x12, 0x3d, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x12, 0x22, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x6f, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x29, 0x0a, 0x0f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x92, 0x02, 0x0a, 0x0c, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x4c,
	0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x52,
	0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x42, 0x0a, 0x18,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x16, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01,
	0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x2a, 0x45, 0x0a,
	0x09, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52,
	0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x46, 0x53, 0x56, 0x33, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x4e, 0x46, 0x53, 0x56, 0x34, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x53,
	0x4d, 0x42, 0x10, 0x03, 0x2a, 0x57, 0x0a, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0d,
	0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x2a, 0xe8, 0x01,
	0x0a, 0x0b, 0x53, 0x4d, 0x42, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1c, 0x0a,
	0x18, 0x53, 0x4d, 0x42, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x45,
	0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x42, 0x52, 0x4f, 0x57, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x59, 0x10, 0x03, 0x12,
	0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x4e, 0x5f, 0x42, 0x52, 0x4f, 0x57, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x50, 0x4c, 0x4f, 0x43, 0x4b, 0x53, 0x10, 0x05, 0x12,
	0x11, 0x0a, 0x0d, 0x53, 0x48, 0x4f, 0x57, 0x5f, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54,
	0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x48, 0x4f, 0x57, 0x5f, 0x50, 0x52, 0x45, 0x56, 0x49,
	0x4f, 0x55, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x07, 0x12, 0x1c,
	0x0a, 0x18, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x5f, 0x45,
	0x4e, 0x55, 0x4d, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x1a, 0x0a, 0x16,
	0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x4f, 0x55, 0x53, 0x4c, 0x59, 0x5f, 0x41, 0x56, 0x41,
	0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x09, 0x2a, 0x43, 0x0a, 0x0d, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x43,
	0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x54, 0x46,
	0x53, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x4e, 0x49, 0x58, 0x10, 0x02, 0x2a, 0x41, 0x0a,
	0x10, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x5f,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x01,
	0x42, 0xad, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x42,
	0x0b, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x41, 0x70,
	0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_netapp_v1_volume_proto_rawDescOnce sync.Once
	file_google_cloud_netapp_v1_volume_proto_rawDescData = file_google_cloud_netapp_v1_volume_proto_rawDesc
)

func file_google_cloud_netapp_v1_volume_proto_rawDescGZIP() []byte {
	file_google_cloud_netapp_v1_volume_proto_rawDescOnce.Do(func() {
		file_google_cloud_netapp_v1_volume_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_netapp_v1_volume_proto_rawDescData)
	})
	return file_google_cloud_netapp_v1_volume_proto_rawDescData
}

var file_google_cloud_netapp_v1_volume_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_netapp_v1_volume_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_netapp_v1_volume_proto_goTypes = []interface{}{
	(Protocols)(0),                 // 0: google.cloud.netapp.v1.Protocols
	(AccessType)(0),                // 1: google.cloud.netapp.v1.AccessType
	(SMBSettings)(0),               // 2: google.cloud.netapp.v1.SMBSettings
	(SecurityStyle)(0),             // 3: google.cloud.netapp.v1.SecurityStyle
	(RestrictedAction)(0),          // 4: google.cloud.netapp.v1.RestrictedAction
	(Volume_State)(0),              // 5: google.cloud.netapp.v1.Volume.State
	(*ListVolumesRequest)(nil),     // 6: google.cloud.netapp.v1.ListVolumesRequest
	(*ListVolumesResponse)(nil),    // 7: google.cloud.netapp.v1.ListVolumesResponse
	(*GetVolumeRequest)(nil),       // 8: google.cloud.netapp.v1.GetVolumeRequest
	(*CreateVolumeRequest)(nil),    // 9: google.cloud.netapp.v1.CreateVolumeRequest
	(*UpdateVolumeRequest)(nil),    // 10: google.cloud.netapp.v1.UpdateVolumeRequest
	(*DeleteVolumeRequest)(nil),    // 11: google.cloud.netapp.v1.DeleteVolumeRequest
	(*RevertVolumeRequest)(nil),    // 12: google.cloud.netapp.v1.RevertVolumeRequest
	(*Volume)(nil),                 // 13: google.cloud.netapp.v1.Volume
	(*ExportPolicy)(nil),           // 14: google.cloud.netapp.v1.ExportPolicy
	(*SimpleExportPolicyRule)(nil), // 15: google.cloud.netapp.v1.SimpleExportPolicyRule
	(*SnapshotPolicy)(nil),         // 16: google.cloud.netapp.v1.SnapshotPolicy
	(*HourlySchedule)(nil),         // 17: google.cloud.netapp.v1.HourlySchedule
	(*DailySchedule)(nil),          // 18: google.cloud.netapp.v1.DailySchedule
	(*WeeklySchedule)(nil),         // 19: google.cloud.netapp.v1.WeeklySchedule
	(*MonthlySchedule)(nil),        // 20: google.cloud.netapp.v1.MonthlySchedule
	(*MountOption)(nil),            // 21: google.cloud.netapp.v1.MountOption
	(*RestoreParameters)(nil),      // 22: google.cloud.netapp.v1.RestoreParameters
	(*BackupConfig)(nil),           // 23: google.cloud.netapp.v1.BackupConfig
	nil,                            // 24: google.cloud.netapp.v1.Volume.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),  // 25: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),  // 26: google.protobuf.Timestamp
	(ServiceLevel)(0),              // 27: google.cloud.netapp.v1.ServiceLevel
	(EncryptionType)(0),            // 28: google.cloud.netapp.v1.EncryptionType
}
var file_google_cloud_netapp_v1_volume_proto_depIdxs = []int32{
	13, // 0: google.cloud.netapp.v1.ListVolumesResponse.volumes:type_name -> google.cloud.netapp.v1.Volume
	13, // 1: google.cloud.netapp.v1.CreateVolumeRequest.volume:type_name -> google.cloud.netapp.v1.Volume
	25, // 2: google.cloud.netapp.v1.UpdateVolumeRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 3: google.cloud.netapp.v1.UpdateVolumeRequest.volume:type_name -> google.cloud.netapp.v1.Volume
	5,  // 4: google.cloud.netapp.v1.Volume.state:type_name -> google.cloud.netapp.v1.Volume.State
	26, // 5: google.cloud.netapp.v1.Volume.create_time:type_name -> google.protobuf.Timestamp
	27, // 6: google.cloud.netapp.v1.Volume.service_level:type_name -> google.cloud.netapp.v1.ServiceLevel
	14, // 7: google.cloud.netapp.v1.Volume.export_policy:type_name -> google.cloud.netapp.v1.ExportPolicy
	0,  // 8: google.cloud.netapp.v1.Volume.protocols:type_name -> google.cloud.netapp.v1.Protocols
	2,  // 9: google.cloud.netapp.v1.Volume.smb_settings:type_name -> google.cloud.netapp.v1.SMBSettings
	21, // 10: google.cloud.netapp.v1.Volume.mount_options:type_name -> google.cloud.netapp.v1.MountOption
	24, // 11: google.cloud.netapp.v1.Volume.labels:type_name -> google.cloud.netapp.v1.Volume.LabelsEntry
	16, // 12: google.cloud.netapp.v1.Volume.snapshot_policy:type_name -> google.cloud.netapp.v1.SnapshotPolicy
	3,  // 13: google.cloud.netapp.v1.Volume.security_style:type_name -> google.cloud.netapp.v1.SecurityStyle
	22, // 14: google.cloud.netapp.v1.Volume.restore_parameters:type_name -> google.cloud.netapp.v1.RestoreParameters
	28, // 15: google.cloud.netapp.v1.Volume.encryption_type:type_name -> google.cloud.netapp.v1.EncryptionType
	23, // 16: google.cloud.netapp.v1.Volume.backup_config:type_name -> google.cloud.netapp.v1.BackupConfig
	4,  // 17: google.cloud.netapp.v1.Volume.restricted_actions:type_name -> google.cloud.netapp.v1.RestrictedAction
	15, // 18: google.cloud.netapp.v1.ExportPolicy.rules:type_name -> google.cloud.netapp.v1.SimpleExportPolicyRule
	1,  // 19: google.cloud.netapp.v1.SimpleExportPolicyRule.access_type:type_name -> google.cloud.netapp.v1.AccessType
	17, // 20: google.cloud.netapp.v1.SnapshotPolicy.hourly_schedule:type_name -> google.cloud.netapp.v1.HourlySchedule
	18, // 21: google.cloud.netapp.v1.SnapshotPolicy.daily_schedule:type_name -> google.cloud.netapp.v1.DailySchedule
	19, // 22: google.cloud.netapp.v1.SnapshotPolicy.weekly_schedule:type_name -> google.cloud.netapp.v1.WeeklySchedule
	20, // 23: google.cloud.netapp.v1.SnapshotPolicy.monthly_schedule:type_name -> google.cloud.netapp.v1.MonthlySchedule
	0,  // 24: google.cloud.netapp.v1.MountOption.protocol:type_name -> google.cloud.netapp.v1.Protocols
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_netapp_v1_volume_proto_init() }
func file_google_cloud_netapp_v1_volume_proto_init() {
	if File_google_cloud_netapp_v1_volume_proto != nil {
		return
	}
	file_google_cloud_netapp_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_netapp_v1_volume_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RevertVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Volume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimpleExportPolicyRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HourlySchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailySchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WeeklySchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonthlySchedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MountOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_netapp_v1_volume_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[13].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*RestoreParameters_SourceSnapshot)(nil),
		(*RestoreParameters_SourceBackup)(nil),
	}
	file_google_cloud_netapp_v1_volume_proto_msgTypes[17].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_netapp_v1_volume_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_netapp_v1_volume_proto_goTypes,
		DependencyIndexes: file_google_cloud_netapp_v1_volume_proto_depIdxs,
		EnumInfos:         file_google_cloud_netapp_v1_volume_proto_enumTypes,
		MessageInfos:      file_google_cloud_netapp_v1_volume_proto_msgTypes,
	}.Build()
	File_google_cloud_netapp_v1_volume_proto = out.File
	file_google_cloud_netapp_v1_volume_proto_rawDesc = nil
	file_google_cloud_netapp_v1_volume_proto_goTypes = nil
	file_google_cloud_netapp_v1_volume_proto_depIdxs = nil
}
