package dtl

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/devtestlabs/mgmt/2016-05-15/dtl"

// ApplicableSchedule schedules applicable to a virtual machine. The schedules may have been defined on a
// VM or on lab level.
type ApplicableSchedule struct {
	autorest.Response `json:"-"`
	// ApplicableScheduleProperties - The properties of the resource.
	*ApplicableScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicableSchedule.
func (as ApplicableSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.ApplicableScheduleProperties != nil {
		objectMap["properties"] = as.ApplicableScheduleProperties
	}
	if as.Location != nil {
		objectMap["location"] = as.Location
	}
	if as.Tags != nil {
		objectMap["tags"] = as.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicableSchedule struct.
func (as *ApplicableSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicableScheduleProperties ApplicableScheduleProperties
				err = json.Unmarshal(*v, &applicableScheduleProperties)
				if err != nil {
					return err
				}
				as.ApplicableScheduleProperties = &applicableScheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				as.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				as.Tags = tags
			}
		}
	}

	return nil
}

// ApplicableScheduleFragment schedules applicable to a virtual machine. The schedules may have been
// defined on a VM or on lab level.
type ApplicableScheduleFragment struct {
	// ApplicableSchedulePropertiesFragment - The properties of the resource.
	*ApplicableSchedulePropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicableScheduleFragment.
func (asf ApplicableScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asf.ApplicableSchedulePropertiesFragment != nil {
		objectMap["properties"] = asf.ApplicableSchedulePropertiesFragment
	}
	if asf.Location != nil {
		objectMap["location"] = asf.Location
	}
	if asf.Tags != nil {
		objectMap["tags"] = asf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicableScheduleFragment struct.
func (asf *ApplicableScheduleFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicableSchedulePropertiesFragment ApplicableSchedulePropertiesFragment
				err = json.Unmarshal(*v, &applicableSchedulePropertiesFragment)
				if err != nil {
					return err
				}
				asf.ApplicableSchedulePropertiesFragment = &applicableSchedulePropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asf.Tags = tags
			}
		}
	}

	return nil
}

// ApplicableScheduleProperties properties of a schedules applicable to a virtual machine.
type ApplicableScheduleProperties struct {
	// LabVmsShutdown - The auto-shutdown schedule, if one has been set at the lab or lab resource level.
	LabVmsShutdown *Schedule `json:"labVmsShutdown,omitempty"`
	// LabVmsStartup - The auto-startup schedule, if one has been set at the lab or lab resource level.
	LabVmsStartup *Schedule `json:"labVmsStartup,omitempty"`
}

// ApplicableSchedulePropertiesFragment properties of a schedules applicable to a virtual machine.
type ApplicableSchedulePropertiesFragment struct {
	// LabVmsShutdown - The auto-shutdown schedule, if one has been set at the lab or lab resource level.
	LabVmsShutdown *ScheduleFragment `json:"labVmsShutdown,omitempty"`
	// LabVmsStartup - The auto-startup schedule, if one has been set at the lab or lab resource level.
	LabVmsStartup *ScheduleFragment `json:"labVmsStartup,omitempty"`
}

// ApplyArtifactsRequest request body for applying artifacts to a virtual machine.
type ApplyArtifactsRequest struct {
	// Artifacts - The list of artifacts to apply.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
}

// ArmTemplate an Azure Resource Manager template.
type ArmTemplate struct {
	autorest.Response `json:"-"`
	// ArmTemplateProperties - The properties of the resource.
	*ArmTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ArmTemplate.
func (at ArmTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if at.ArmTemplateProperties != nil {
		objectMap["properties"] = at.ArmTemplateProperties
	}
	if at.Location != nil {
		objectMap["location"] = at.Location
	}
	if at.Tags != nil {
		objectMap["tags"] = at.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArmTemplate struct.
func (at *ArmTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var armTemplateProperties ArmTemplateProperties
				err = json.Unmarshal(*v, &armTemplateProperties)
				if err != nil {
					return err
				}
				at.ArmTemplateProperties = &armTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				at.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				at.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				at.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				at.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				at.Tags = tags
			}
		}
	}

	return nil
}

// ArmTemplateInfo information about a generated ARM template.
type ArmTemplateInfo struct {
	autorest.Response `json:"-"`
	// Template - The template's contents.
	Template interface{} `json:"template,omitempty"`
	// Parameters - The parameters of the ARM template.
	Parameters interface{} `json:"parameters,omitempty"`
}

// ArmTemplateParameterProperties properties of an Azure Resource Manager template parameter.
type ArmTemplateParameterProperties struct {
	// Name - The name of the template parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the template parameter.
	Value *string `json:"value,omitempty"`
}

// ArmTemplateProperties properties of an Azure Resource Manager template.
type ArmTemplateProperties struct {
	// DisplayName - READ-ONLY; The display name of the ARM template.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the ARM template.
	Description *string `json:"description,omitempty"`
	// Publisher - READ-ONLY; The publisher of the ARM template.
	Publisher *string `json:"publisher,omitempty"`
	// Icon - READ-ONLY; The URI to the icon of the ARM template.
	Icon *string `json:"icon,omitempty"`
	// Contents - READ-ONLY; The contents of the ARM template.
	Contents interface{} `json:"contents,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the armTemplate.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ParametersValueFilesInfo - READ-ONLY; File name and parameter values information from all azuredeploy.*.parameters.json for the ARM template.
	ParametersValueFilesInfo *[]ParametersValueFileInfo `json:"parametersValueFilesInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ArmTemplateProperties.
func (atp ArmTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Artifact an artifact.
type Artifact struct {
	autorest.Response `json:"-"`
	// ArtifactProperties - The properties of the resource.
	*ArtifactProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Artifact.
func (a Artifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ArtifactProperties != nil {
		objectMap["properties"] = a.ArtifactProperties
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Artifact struct.
func (a *Artifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactProperties ArtifactProperties
				err = json.Unmarshal(*v, &artifactProperties)
				if err != nil {
					return err
				}
				a.ArtifactProperties = &artifactProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactDeploymentStatusProperties properties of an artifact deployment.
type ArtifactDeploymentStatusProperties struct {
	// DeploymentStatus - The deployment status of the artifact.
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`
	// ArtifactsApplied - The total count of the artifacts that were successfully applied.
	ArtifactsApplied *int32 `json:"artifactsApplied,omitempty"`
	// TotalArtifacts - The total count of the artifacts that were tentatively applied.
	TotalArtifacts *int32 `json:"totalArtifacts,omitempty"`
}

// ArtifactDeploymentStatusPropertiesFragment properties of an artifact deployment.
type ArtifactDeploymentStatusPropertiesFragment struct {
	// DeploymentStatus - The deployment status of the artifact.
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`
	// ArtifactsApplied - The total count of the artifacts that were successfully applied.
	ArtifactsApplied *int32 `json:"artifactsApplied,omitempty"`
	// TotalArtifacts - The total count of the artifacts that were tentatively applied.
	TotalArtifacts *int32 `json:"totalArtifacts,omitempty"`
}

// ArtifactInstallProperties properties of an artifact.
type ArtifactInstallProperties struct {
	// ArtifactID - The artifact's identifier.
	ArtifactID *string `json:"artifactId,omitempty"`
	// Parameters - The parameters of the artifact.
	Parameters *[]ArtifactParameterProperties `json:"parameters,omitempty"`
	// Status - The status of the artifact.
	Status *string `json:"status,omitempty"`
	// DeploymentStatusMessage - The status message from the deployment.
	DeploymentStatusMessage *string `json:"deploymentStatusMessage,omitempty"`
	// VMExtensionStatusMessage - The status message from the virtual machine extension.
	VMExtensionStatusMessage *string `json:"vmExtensionStatusMessage,omitempty"`
	// InstallTime - The time that the artifact starts to install on the virtual machine.
	InstallTime *date.Time `json:"installTime,omitempty"`
}

// ArtifactInstallPropertiesFragment properties of an artifact.
type ArtifactInstallPropertiesFragment struct {
	// ArtifactID - The artifact's identifier.
	ArtifactID *string `json:"artifactId,omitempty"`
	// Parameters - The parameters of the artifact.
	Parameters *[]ArtifactParameterPropertiesFragment `json:"parameters,omitempty"`
	// Status - The status of the artifact.
	Status *string `json:"status,omitempty"`
	// DeploymentStatusMessage - The status message from the deployment.
	DeploymentStatusMessage *string `json:"deploymentStatusMessage,omitempty"`
	// VMExtensionStatusMessage - The status message from the virtual machine extension.
	VMExtensionStatusMessage *string `json:"vmExtensionStatusMessage,omitempty"`
	// InstallTime - The time that the artifact starts to install on the virtual machine.
	InstallTime *date.Time `json:"installTime,omitempty"`
}

// ArtifactParameterProperties properties of an artifact parameter.
type ArtifactParameterProperties struct {
	// Name - The name of the artifact parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ArtifactParameterPropertiesFragment properties of an artifact parameter.
type ArtifactParameterPropertiesFragment struct {
	// Name - The name of the artifact parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ArtifactProperties properties of an artifact.
type ArtifactProperties struct {
	// Title - READ-ONLY; The artifact's title.
	Title *string `json:"title,omitempty"`
	// Description - READ-ONLY; The artifact's description.
	Description *string `json:"description,omitempty"`
	// Publisher - READ-ONLY; The artifact's publisher.
	Publisher *string `json:"publisher,omitempty"`
	// FilePath - READ-ONLY; The file path to the artifact.
	FilePath *string `json:"filePath,omitempty"`
	// Icon - READ-ONLY; The URI to the artifact icon.
	Icon *string `json:"icon,omitempty"`
	// TargetOsType - READ-ONLY; The artifact's target OS.
	TargetOsType *string `json:"targetOsType,omitempty"`
	// Parameters - READ-ONLY; The artifact's parameters.
	Parameters interface{} `json:"parameters,omitempty"`
	// CreatedDate - READ-ONLY; The artifact's creation date.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
}

// MarshalJSON is the custom marshaler for ArtifactProperties.
func (ap ArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ArtifactSource properties of an artifact source.
type ArtifactSource struct {
	autorest.Response `json:"-"`
	// ArtifactSourceProperties - The properties of the resource.
	*ArtifactSourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ArtifactSource.
func (as ArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.ArtifactSourceProperties != nil {
		objectMap["properties"] = as.ArtifactSourceProperties
	}
	if as.Location != nil {
		objectMap["location"] = as.Location
	}
	if as.Tags != nil {
		objectMap["tags"] = as.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArtifactSource struct.
func (as *ArtifactSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactSourceProperties ArtifactSourceProperties
				err = json.Unmarshal(*v, &artifactSourceProperties)
				if err != nil {
					return err
				}
				as.ArtifactSourceProperties = &artifactSourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				as.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				as.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactSourceFragment properties of an artifact source.
type ArtifactSourceFragment struct {
	// ArtifactSourcePropertiesFragment - The properties of the resource.
	*ArtifactSourcePropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ArtifactSourceFragment.
func (asf ArtifactSourceFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asf.ArtifactSourcePropertiesFragment != nil {
		objectMap["properties"] = asf.ArtifactSourcePropertiesFragment
	}
	if asf.Location != nil {
		objectMap["location"] = asf.Location
	}
	if asf.Tags != nil {
		objectMap["tags"] = asf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArtifactSourceFragment struct.
func (asf *ArtifactSourceFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactSourcePropertiesFragment ArtifactSourcePropertiesFragment
				err = json.Unmarshal(*v, &artifactSourcePropertiesFragment)
				if err != nil {
					return err
				}
				asf.ArtifactSourcePropertiesFragment = &artifactSourcePropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asf.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactSourceProperties properties of an artifact source.
type ArtifactSourceProperties struct {
	// DisplayName - The artifact source's display name.
	DisplayName *string `json:"displayName,omitempty"`
	// URI - The artifact source's URI.
	URI *string `json:"uri,omitempty"`
	// SourceType - The artifact source's type. Possible values include: 'VsoGit', 'GitHub'
	SourceType SourceControlType `json:"sourceType,omitempty"`
	// FolderPath - The folder containing artifacts.
	FolderPath *string `json:"folderPath,omitempty"`
	// ArmTemplateFolderPath - The folder containing Azure Resource Manager templates.
	ArmTemplateFolderPath *string `json:"armTemplateFolderPath,omitempty"`
	// BranchRef - The artifact source's branch reference.
	BranchRef *string `json:"branchRef,omitempty"`
	// SecurityToken - The security token to authenticate to the artifact source.
	SecurityToken *string `json:"securityToken,omitempty"`
	// Status - Indicates if the artifact source is enabled (values: Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// CreatedDate - READ-ONLY; The artifact source's creation date.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for ArtifactSourceProperties.
func (asp ArtifactSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.DisplayName != nil {
		objectMap["displayName"] = asp.DisplayName
	}
	if asp.URI != nil {
		objectMap["uri"] = asp.URI
	}
	if asp.SourceType != "" {
		objectMap["sourceType"] = asp.SourceType
	}
	if asp.FolderPath != nil {
		objectMap["folderPath"] = asp.FolderPath
	}
	if asp.ArmTemplateFolderPath != nil {
		objectMap["armTemplateFolderPath"] = asp.ArmTemplateFolderPath
	}
	if asp.BranchRef != nil {
		objectMap["branchRef"] = asp.BranchRef
	}
	if asp.SecurityToken != nil {
		objectMap["securityToken"] = asp.SecurityToken
	}
	if asp.Status != "" {
		objectMap["status"] = asp.Status
	}
	if asp.ProvisioningState != nil {
		objectMap["provisioningState"] = asp.ProvisioningState
	}
	if asp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = asp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// ArtifactSourcePropertiesFragment properties of an artifact source.
type ArtifactSourcePropertiesFragment struct {
	// DisplayName - The artifact source's display name.
	DisplayName *string `json:"displayName,omitempty"`
	// URI - The artifact source's URI.
	URI *string `json:"uri,omitempty"`
	// SourceType - The artifact source's type. Possible values include: 'VsoGit', 'GitHub'
	SourceType SourceControlType `json:"sourceType,omitempty"`
	// FolderPath - The folder containing artifacts.
	FolderPath *string `json:"folderPath,omitempty"`
	// ArmTemplateFolderPath - The folder containing Azure Resource Manager templates.
	ArmTemplateFolderPath *string `json:"armTemplateFolderPath,omitempty"`
	// BranchRef - The artifact source's branch reference.
	BranchRef *string `json:"branchRef,omitempty"`
	// SecurityToken - The security token to authenticate to the artifact source.
	SecurityToken *string `json:"securityToken,omitempty"`
	// Status - Indicates if the artifact source is enabled (values: Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// AttachDiskProperties properties of the disk to attach.
type AttachDiskProperties struct {
	// LeasedByLabVMID - The resource ID of the Lab virtual machine to which the disk is attached.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// AttachNewDataDiskOptions properties to attach new disk to the Virtual Machine.
type AttachNewDataDiskOptions struct {
	// DiskSizeGiB - Size of the disk to be attached in Gibibytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
	// DiskName - The name of the disk to be attached.
	DiskName *string `json:"diskName,omitempty"`
	// DiskType - The storage type for the disk (i.e. Standard, Premium). Possible values include: 'Standard', 'Premium'
	DiskType StorageType `json:"diskType,omitempty"`
}

// BulkCreationParameters parameters for creating multiple virtual machines as a single action.
type BulkCreationParameters struct {
	// InstanceCount - The number of virtual machine instances to create.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// CloudError error from a REST request.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody body of an error from a REST request.
type CloudErrorBody struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Target  *string `json:"target,omitempty"`
	// Details - Inner errors.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ComputeDataDisk a data disks attached to a virtual machine.
type ComputeDataDisk struct {
	// Name - Gets data disk name.
	Name *string `json:"name,omitempty"`
	// DiskURI - When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`
	// ManagedDiskID - When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	// DiskSizeGiB - Gets data disk size in GiB.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
}

// ComputeDataDiskFragment a data disks attached to a virtual machine.
type ComputeDataDiskFragment struct {
	// Name - Gets data disk name.
	Name *string `json:"name,omitempty"`
	// DiskURI - When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`
	// ManagedDiskID - When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	// DiskSizeGiB - Gets data disk size in GiB.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
}

// ComputeVMInstanceViewStatus status information about a virtual machine.
type ComputeVMInstanceViewStatus struct {
	// Code - Gets the status Code.
	Code *string `json:"code,omitempty"`
	// DisplayStatus - Gets the short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - Gets the message associated with the status.
	Message *string `json:"message,omitempty"`
}

// ComputeVMInstanceViewStatusFragment status information about a virtual machine.
type ComputeVMInstanceViewStatusFragment struct {
	// Code - Gets the status Code.
	Code *string `json:"code,omitempty"`
	// DisplayStatus - Gets the short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - Gets the message associated with the status.
	Message *string `json:"message,omitempty"`
}

// ComputeVMProperties properties of a virtual machine returned by the Microsoft.Compute API.
type ComputeVMProperties struct {
	// Statuses - Gets the statuses of the virtual machine.
	Statuses *[]ComputeVMInstanceViewStatus `json:"statuses,omitempty"`
	// OsType - Gets the OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// VMSize - Gets the size of the virtual machine.
	VMSize *string `json:"vmSize,omitempty"`
	// NetworkInterfaceID - Gets the network interface ID of the virtual machine.
	NetworkInterfaceID *string `json:"networkInterfaceId,omitempty"`
	// OsDiskID - Gets OS disk blob uri for the virtual machine.
	OsDiskID *string `json:"osDiskId,omitempty"`
	// DataDiskIds - Gets data disks blob uri for the virtual machine.
	DataDiskIds *[]string `json:"dataDiskIds,omitempty"`
	// DataDisks - Gets all data disks attached to the virtual machine.
	DataDisks *[]ComputeDataDisk `json:"dataDisks,omitempty"`
}

// ComputeVMPropertiesFragment properties of a virtual machine returned by the Microsoft.Compute API.
type ComputeVMPropertiesFragment struct {
	// Statuses - Gets the statuses of the virtual machine.
	Statuses *[]ComputeVMInstanceViewStatusFragment `json:"statuses,omitempty"`
	// OsType - Gets the OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// VMSize - Gets the size of the virtual machine.
	VMSize *string `json:"vmSize,omitempty"`
	// NetworkInterfaceID - Gets the network interface ID of the virtual machine.
	NetworkInterfaceID *string `json:"networkInterfaceId,omitempty"`
	// OsDiskID - Gets OS disk blob uri for the virtual machine.
	OsDiskID *string `json:"osDiskId,omitempty"`
	// DataDiskIds - Gets data disks blob uri for the virtual machine.
	DataDiskIds *[]string `json:"dataDiskIds,omitempty"`
	// DataDisks - Gets all data disks attached to the virtual machine.
	DataDisks *[]ComputeDataDiskFragment `json:"dataDisks,omitempty"`
}

// CostThresholdProperties properties of a cost threshold item.
type CostThresholdProperties struct {
	// ThresholdID - The ID of the cost threshold item.
	ThresholdID *string `json:"thresholdId,omitempty"`
	// PercentageThreshold - The value of the percentage cost threshold.
	PercentageThreshold *PercentageCostThresholdProperties `json:"percentageThreshold,omitempty"`
	// DisplayOnChart - Indicates whether this threshold will be displayed on cost charts. Possible values include: 'Enabled', 'Disabled'
	DisplayOnChart CostThresholdStatus `json:"displayOnChart,omitempty"`
	// SendNotificationWhenExceeded - Indicates whether notifications will be sent when this threshold is exceeded. Possible values include: 'Enabled', 'Disabled'
	SendNotificationWhenExceeded CostThresholdStatus `json:"sendNotificationWhenExceeded,omitempty"`
	// NotificationSent - Indicates the datetime when notifications were last sent for this threshold.
	NotificationSent *string `json:"notificationSent,omitempty"`
}

// CustomImage a custom image.
type CustomImage struct {
	autorest.Response `json:"-"`
	// CustomImageProperties - The properties of the resource.
	*CustomImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CustomImage.
func (ci CustomImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.CustomImageProperties != nil {
		objectMap["properties"] = ci.CustomImageProperties
	}
	if ci.Location != nil {
		objectMap["location"] = ci.Location
	}
	if ci.Tags != nil {
		objectMap["tags"] = ci.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomImage struct.
func (ci *CustomImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customImageProperties CustomImageProperties
				err = json.Unmarshal(*v, &customImageProperties)
				if err != nil {
					return err
				}
				ci.CustomImageProperties = &customImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ci.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ci.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ci.Tags = tags
			}
		}
	}

	return nil
}

// CustomImageProperties properties of a custom image.
type CustomImageProperties struct {
	// VM - The virtual machine from which the image is to be created.
	VM *CustomImagePropertiesFromVM `json:"vm,omitempty"`
	// Vhd - The VHD from which the image is to be created.
	Vhd *CustomImagePropertiesCustom `json:"vhd,omitempty"`
	// Description - The description of the custom image.
	Description *string `json:"description,omitempty"`
	// Author - The author of the custom image.
	Author *string `json:"author,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the custom image.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ManagedImageID - The Managed Image Id backing the custom image.
	ManagedImageID *string `json:"managedImageId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomImageProperties.
func (cip CustomImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cip.VM != nil {
		objectMap["vm"] = cip.VM
	}
	if cip.Vhd != nil {
		objectMap["vhd"] = cip.Vhd
	}
	if cip.Description != nil {
		objectMap["description"] = cip.Description
	}
	if cip.Author != nil {
		objectMap["author"] = cip.Author
	}
	if cip.ManagedImageID != nil {
		objectMap["managedImageId"] = cip.ManagedImageID
	}
	if cip.ProvisioningState != nil {
		objectMap["provisioningState"] = cip.ProvisioningState
	}
	if cip.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = cip.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// CustomImagePropertiesCustom properties for creating a custom image from a VHD.
type CustomImagePropertiesCustom struct {
	// ImageName - The image name.
	ImageName *string `json:"imageName,omitempty"`
	// SysPrep - Indicates whether sysprep has been run on the VHD.
	SysPrep *bool `json:"sysPrep,omitempty"`
	// OsType - The OS type of the custom image (i.e. Windows, Linux). Possible values include: 'Windows', 'Linux', 'None'
	OsType CustomImageOsType `json:"osType,omitempty"`
}

// CustomImagePropertiesFromVM properties for creating a custom image from a virtual machine.
type CustomImagePropertiesFromVM struct {
	// SourceVMID - The source vm identifier.
	SourceVMID *string `json:"sourceVmId,omitempty"`
	// WindowsOsInfo - The Windows OS information of the VM.
	WindowsOsInfo *WindowsOsInfo `json:"windowsOsInfo,omitempty"`
	// LinuxOsInfo - The Linux OS information of the VM.
	LinuxOsInfo *LinuxOsInfo `json:"linuxOsInfo,omitempty"`
}

// CustomImagesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CustomImagesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomImagesClient) (CustomImage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomImagesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomImagesCreateOrUpdateFuture.Result.
func (future *CustomImagesCreateOrUpdateFuture) result(client CustomImagesClient) (ci CustomImage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CustomImagesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ci.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.CustomImagesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ci.Response.Response, err = future.GetResult(sender); err == nil && ci.Response.Response.StatusCode != http.StatusNoContent {
		ci, err = client.CreateOrUpdateResponder(ci.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.CustomImagesCreateOrUpdateFuture", "Result", ci.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomImagesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomImagesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomImagesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomImagesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomImagesDeleteFuture.Result.
func (future *CustomImagesDeleteFuture) result(client CustomImagesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CustomImagesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.CustomImagesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataDiskProperties request body for adding a new or existing data disk to a virtual machine.
type DataDiskProperties struct {
	// AttachNewDataDiskOptions - Specifies options to attach a new disk to the virtual machine.
	AttachNewDataDiskOptions *AttachNewDataDiskOptions `json:"attachNewDataDiskOptions,omitempty"`
	// ExistingLabDiskID - Specifies the existing lab disk id to attach to virtual machine.
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`
	// HostCaching - Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). Possible values include: 'HostCachingOptionsNone', 'HostCachingOptionsReadOnly', 'HostCachingOptionsReadWrite'
	HostCaching HostCachingOptions `json:"hostCaching,omitempty"`
}

// DayDetails properties of a daily schedule.
type DayDetails struct {
	// Time - The time of day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// DayDetailsFragment properties of a daily schedule.
type DayDetailsFragment struct {
	// Time - The time of day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// DetachDataDiskProperties request body for detaching data disk from a virtual machine.
type DetachDataDiskProperties struct {
	// ExistingLabDiskID - Specifies the disk resource ID to detach from virtual machine.
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`
}

// DetachDiskProperties properties of the disk to detach.
type DetachDiskProperties struct {
	// LeasedByLabVMID - The resource ID of the Lab VM to which the disk is attached.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// Disk a Disk.
type Disk struct {
	autorest.Response `json:"-"`
	// DiskProperties - The properties of the resource.
	*DiskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DiskProperties != nil {
		objectMap["properties"] = d.DiskProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Disk struct.
func (d *Disk) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diskProperties DiskProperties
				err = json.Unmarshal(*v, &diskProperties)
				if err != nil {
					return err
				}
				d.DiskProperties = &diskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DiskProperties properties of a disk.
type DiskProperties struct {
	// DiskType - The storage type for the disk (i.e. Standard, Premium). Possible values include: 'Standard', 'Premium'
	DiskType StorageType `json:"diskType,omitempty"`
	// DiskSizeGiB - The size of the disk in Gibibytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`
	// LeasedByLabVMID - The resource ID of the VM to which this disk is leased.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
	// DiskBlobName - When backed by a blob, the name of the VHD blob without extension.
	DiskBlobName *string `json:"diskBlobName,omitempty"`
	// DiskURI - When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the disk.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// HostCaching - The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
	HostCaching *string `json:"hostCaching,omitempty"`
	// ManagedDiskID - When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskProperties.
func (dp DiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.DiskType != "" {
		objectMap["diskType"] = dp.DiskType
	}
	if dp.DiskSizeGiB != nil {
		objectMap["diskSizeGiB"] = dp.DiskSizeGiB
	}
	if dp.LeasedByLabVMID != nil {
		objectMap["leasedByLabVmId"] = dp.LeasedByLabVMID
	}
	if dp.DiskBlobName != nil {
		objectMap["diskBlobName"] = dp.DiskBlobName
	}
	if dp.DiskURI != nil {
		objectMap["diskUri"] = dp.DiskURI
	}
	if dp.HostCaching != nil {
		objectMap["hostCaching"] = dp.HostCaching
	}
	if dp.ManagedDiskID != nil {
		objectMap["managedDiskId"] = dp.ManagedDiskID
	}
	if dp.ProvisioningState != nil {
		objectMap["provisioningState"] = dp.ProvisioningState
	}
	if dp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = dp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// DisksAttachFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksAttachFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksAttachFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksAttachFuture.Result.
func (future *DisksAttachFuture) result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksAttachFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.DisksAttachFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DisksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (Disk, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksCreateOrUpdateFuture.Result.
func (future *DisksCreateOrUpdateFuture) result(client DisksClient) (d Disk, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.DisksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.DisksCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DisksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksDeleteFuture.Result.
func (future *DisksDeleteFuture) result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.DisksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisksDetachFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DisksDetachFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisksDetachFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisksDetachFuture.Result.
func (future *DisksDetachFuture) result(client DisksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.DisksDetachFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.DisksDetachFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Environment an environment, which is essentially an ARM template deployment.
type Environment struct {
	autorest.Response `json:"-"`
	// EnvironmentProperties - The properties of the resource.
	*EnvironmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Environment.
func (e Environment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EnvironmentProperties != nil {
		objectMap["properties"] = e.EnvironmentProperties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	if e.Tags != nil {
		objectMap["tags"] = e.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Environment struct.
func (e *Environment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var environmentProperties EnvironmentProperties
				err = json.Unmarshal(*v, &environmentProperties)
				if err != nil {
					return err
				}
				e.EnvironmentProperties = &environmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				e.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				e.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentDeploymentProperties properties of an environment deployment.
type EnvironmentDeploymentProperties struct {
	// ArmTemplateID - The Azure Resource Manager template's identifier.
	ArmTemplateID *string `json:"armTemplateId,omitempty"`
	// Parameters - The parameters of the Azure Resource Manager template.
	Parameters *[]ArmTemplateParameterProperties `json:"parameters,omitempty"`
}

// EnvironmentProperties properties of an environment.
type EnvironmentProperties struct {
	// DeploymentProperties - The deployment properties of the environment.
	DeploymentProperties *EnvironmentDeploymentProperties `json:"deploymentProperties,omitempty"`
	// ArmTemplateDisplayName - The display name of the Azure Resource Manager template that produced the environment.
	ArmTemplateDisplayName *string `json:"armTemplateDisplayName,omitempty"`
	// ResourceGroupID - READ-ONLY; The identifier of the resource group containing the environment's resources.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`
	// CreatedByUser - READ-ONLY; The creator of the environment.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentProperties.
func (ep EnvironmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.DeploymentProperties != nil {
		objectMap["deploymentProperties"] = ep.DeploymentProperties
	}
	if ep.ArmTemplateDisplayName != nil {
		objectMap["armTemplateDisplayName"] = ep.ArmTemplateDisplayName
	}
	if ep.ProvisioningState != nil {
		objectMap["provisioningState"] = ep.ProvisioningState
	}
	if ep.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = ep.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// EnvironmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EnvironmentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (Environment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsCreateOrUpdateFuture.Result.
func (future *EnvironmentsCreateOrUpdateFuture) result(client EnvironmentsClient) (e Environment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.EnvironmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.EnvironmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateOrUpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.EnvironmentsCreateOrUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EnvironmentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnvironmentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsDeleteFuture.Result.
func (future *EnvironmentsDeleteFuture) result(client EnvironmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.EnvironmentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.EnvironmentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EvaluatePoliciesProperties properties for evaluating a policy set.
type EvaluatePoliciesProperties struct {
	// FactName - The fact name.
	FactName *string `json:"factName,omitempty"`
	// FactData - The fact data.
	FactData *string `json:"factData,omitempty"`
	// ValueOffset - The value offset.
	ValueOffset *string `json:"valueOffset,omitempty"`
}

// EvaluatePoliciesRequest request body for evaluating a policy set.
type EvaluatePoliciesRequest struct {
	// Policies - Policies to evaluate.
	Policies *[]EvaluatePoliciesProperties `json:"policies,omitempty"`
}

// EvaluatePoliciesResponse response body for evaluating a policy set.
type EvaluatePoliciesResponse struct {
	autorest.Response `json:"-"`
	// Results - Results of evaluating a policy set.
	Results *[]PolicySetResult `json:"results,omitempty"`
}

// Event an event to be notified for.
type Event struct {
	// EventName - The event type for which this notification is enabled (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
}

// EventFragment an event to be notified for.
type EventFragment struct {
	// EventName - The event type for which this notification is enabled (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
}

// ExportResourceUsageParameters the parameters of the export operation.
type ExportResourceUsageParameters struct {
	// BlobStorageAbsoluteSasURI - The blob storage absolute sas uri with write permission to the container which the usage data needs to be uploaded to.
	BlobStorageAbsoluteSasURI *string `json:"blobStorageAbsoluteSasUri,omitempty"`
	// UsageStartDate - The start time of the usage. If not provided, usage will be reported since the beginning of data collection.
	UsageStartDate *date.Time `json:"usageStartDate,omitempty"`
}

// ExternalSubnet subnet information as returned by the Microsoft.Network API.
type ExternalSubnet struct {
	// ID - Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name.
	Name *string `json:"name,omitempty"`
}

// ExternalSubnetFragment subnet information as returned by the Microsoft.Network API.
type ExternalSubnetFragment struct {
	// ID - Gets or sets the identifier.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name.
	Name *string `json:"name,omitempty"`
}

// Formula a formula for creating a VM, specifying an image base and other parameters
type Formula struct {
	autorest.Response `json:"-"`
	// FormulaProperties - The properties of the resource.
	*FormulaProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Formula.
func (f Formula) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.FormulaProperties != nil {
		objectMap["properties"] = f.FormulaProperties
	}
	if f.Location != nil {
		objectMap["location"] = f.Location
	}
	if f.Tags != nil {
		objectMap["tags"] = f.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Formula struct.
func (f *Formula) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var formulaProperties FormulaProperties
				err = json.Unmarshal(*v, &formulaProperties)
				if err != nil {
					return err
				}
				f.FormulaProperties = &formulaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				f.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				f.Tags = tags
			}
		}
	}

	return nil
}

// FormulaProperties properties of a formula.
type FormulaProperties struct {
	// Description - The description of the formula.
	Description *string `json:"description,omitempty"`
	// Author - The author of the formula.
	Author *string `json:"author,omitempty"`
	// OsType - The OS type of the formula.
	OsType *string `json:"osType,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the formula.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// FormulaContent - The content of the formula.
	FormulaContent *LabVirtualMachineCreationParameter `json:"formulaContent,omitempty"`
	// VM - Information about a VM from which a formula is to be created.
	VM *FormulaPropertiesFromVM `json:"vm,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for FormulaProperties.
func (fp FormulaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.Description != nil {
		objectMap["description"] = fp.Description
	}
	if fp.Author != nil {
		objectMap["author"] = fp.Author
	}
	if fp.OsType != nil {
		objectMap["osType"] = fp.OsType
	}
	if fp.FormulaContent != nil {
		objectMap["formulaContent"] = fp.FormulaContent
	}
	if fp.VM != nil {
		objectMap["vm"] = fp.VM
	}
	if fp.ProvisioningState != nil {
		objectMap["provisioningState"] = fp.ProvisioningState
	}
	if fp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = fp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// FormulaPropertiesFromVM information about a VM from which a formula is to be created.
type FormulaPropertiesFromVM struct {
	// LabVMID - The identifier of the VM from which a formula is to be created.
	LabVMID *string `json:"labVmId,omitempty"`
}

// FormulasCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FormulasCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FormulasClient) (Formula, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FormulasCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FormulasCreateOrUpdateFuture.Result.
func (future *FormulasCreateOrUpdateFuture) result(client FormulasClient) (f Formula, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.FormulasCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		f.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.FormulasCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.CreateOrUpdateResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.FormulasCreateOrUpdateFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GalleryImage a gallery image.
type GalleryImage struct {
	// GalleryImageProperties - The properties of the resource.
	*GalleryImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImage.
func (gi GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gi.GalleryImageProperties != nil {
		objectMap["properties"] = gi.GalleryImageProperties
	}
	if gi.Location != nil {
		objectMap["location"] = gi.Location
	}
	if gi.Tags != nil {
		objectMap["tags"] = gi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImage struct.
func (gi *GalleryImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageProperties GalleryImageProperties
				err = json.Unmarshal(*v, &galleryImageProperties)
				if err != nil {
					return err
				}
				gi.GalleryImageProperties = &galleryImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gi.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gi.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageProperties properties of a gallery image.
type GalleryImageProperties struct {
	// Author - The author of the gallery image.
	Author *string `json:"author,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the gallery image.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Description - The description of the gallery image.
	Description *string `json:"description,omitempty"`
	// ImageReference - The image reference of the gallery image.
	ImageReference *GalleryImageReference `json:"imageReference,omitempty"`
	// Icon - The icon of the gallery image.
	Icon *string `json:"icon,omitempty"`
	// Enabled - Indicates whether this gallery image is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryImageProperties.
func (gip GalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gip.Author != nil {
		objectMap["author"] = gip.Author
	}
	if gip.Description != nil {
		objectMap["description"] = gip.Description
	}
	if gip.ImageReference != nil {
		objectMap["imageReference"] = gip.ImageReference
	}
	if gip.Icon != nil {
		objectMap["icon"] = gip.Icon
	}
	if gip.Enabled != nil {
		objectMap["enabled"] = gip.Enabled
	}
	return json.Marshal(objectMap)
}

// GalleryImageReference the reference information for an Azure Marketplace image.
type GalleryImageReference struct {
	// Offer - The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU of the gallery image.
	Sku *string `json:"sku,omitempty"`
	// OsType - The OS type of the gallery image.
	OsType *string `json:"osType,omitempty"`
	// Version - The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GalleryImageReferenceFragment the reference information for an Azure Marketplace image.
type GalleryImageReferenceFragment struct {
	// Offer - The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU of the gallery image.
	Sku *string `json:"sku,omitempty"`
	// OsType - The OS type of the gallery image.
	OsType *string `json:"osType,omitempty"`
	// Version - The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GenerateArmTemplateRequest parameters for generating an ARM template for deploying artifacts.
type GenerateArmTemplateRequest struct {
	// VirtualMachineName - The resource name of the virtual machine.
	VirtualMachineName *string `json:"virtualMachineName,omitempty"`
	// Parameters - The parameters of the ARM template.
	Parameters *[]ParameterInfo `json:"parameters,omitempty"`
	// Location - The location of the virtual machine.
	Location *string `json:"location,omitempty"`
	// FileUploadOptions - Options for uploading the files for the artifact. UploadFilesAndGenerateSasTokens is the default value. Possible values include: 'FileUploadOptionsUploadFilesAndGenerateSasTokens', 'FileUploadOptionsNone'
	FileUploadOptions FileUploadOptions `json:"fileUploadOptions,omitempty"`
}

// GenerateUploadURIParameter properties for generating an upload URI.
type GenerateUploadURIParameter struct {
	// BlobName - The blob name of the upload URI.
	BlobName *string `json:"blobName,omitempty"`
}

// GenerateUploadURIResponse response body for generating an upload URI.
type GenerateUploadURIResponse struct {
	autorest.Response `json:"-"`
	// UploadURI - The upload URI for the VHD.
	UploadURI *string `json:"uploadUri,omitempty"`
}

// GlobalSchedulesExecuteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GlobalSchedulesExecuteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalSchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalSchedulesExecuteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalSchedulesExecuteFuture.Result.
func (future *GlobalSchedulesExecuteFuture) result(client GlobalSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.GlobalSchedulesExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.GlobalSchedulesExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GlobalSchedulesRetargetFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GlobalSchedulesRetargetFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalSchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalSchedulesRetargetFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalSchedulesRetargetFuture.Result.
func (future *GlobalSchedulesRetargetFuture) result(client GlobalSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.GlobalSchedulesRetargetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.GlobalSchedulesRetargetFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HourDetails properties of an hourly schedule.
type HourDetails struct {
	// Minute - Minutes of the hour the schedule will run.
	Minute *int32 `json:"minute,omitempty"`
}

// HourDetailsFragment properties of an hourly schedule.
type HourDetailsFragment struct {
	// Minute - Minutes of the hour the schedule will run.
	Minute *int32 `json:"minute,omitempty"`
}

// IdentityProperties properties of a managed identity
type IdentityProperties struct {
	// Type - Managed identity.
	Type *string `json:"type,omitempty"`
	// PrincipalID - The principal id of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant identifier of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// ClientSecretURL - The client secret URL of the identity.
	ClientSecretURL *string `json:"clientSecretUrl,omitempty"`
}

// InboundNatRule a rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load
// balancer.
type InboundNatRule struct {
	// TransportProtocol - The transport protocol for the endpoint. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// FrontendPort - The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port to which the external traffic will be redirected.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// InboundNatRuleFragment a rule for NAT - exposing a VM's port (backendPort) on the public IP address
// using a load balancer.
type InboundNatRuleFragment struct {
	// TransportProtocol - The transport protocol for the endpoint. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// FrontendPort - The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port to which the external traffic will be redirected.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// Lab a lab.
type Lab struct {
	autorest.Response `json:"-"`
	// LabProperties - The properties of the resource.
	*LabProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Lab.
func (l Lab) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LabProperties != nil {
		objectMap["properties"] = l.LabProperties
	}
	if l.Location != nil {
		objectMap["location"] = l.Location
	}
	if l.Tags != nil {
		objectMap["tags"] = l.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Lab struct.
func (l *Lab) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labProperties LabProperties
				err = json.Unmarshal(*v, &labProperties)
				if err != nil {
					return err
				}
				l.LabProperties = &labProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				l.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				l.Tags = tags
			}
		}
	}

	return nil
}

// LabCost a cost item.
type LabCost struct {
	autorest.Response `json:"-"`
	// LabCostProperties - The properties of the resource.
	*LabCostProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabCost.
func (lc LabCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lc.LabCostProperties != nil {
		objectMap["properties"] = lc.LabCostProperties
	}
	if lc.Location != nil {
		objectMap["location"] = lc.Location
	}
	if lc.Tags != nil {
		objectMap["tags"] = lc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabCost struct.
func (lc *LabCost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labCostProperties LabCostProperties
				err = json.Unmarshal(*v, &labCostProperties)
				if err != nil {
					return err
				}
				lc.LabCostProperties = &labCostProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lc.Tags = tags
			}
		}
	}

	return nil
}

// LabCostDetailsProperties the properties of a lab cost item.
type LabCostDetailsProperties struct {
	// Date - The date of the cost item.
	Date *date.Time `json:"date,omitempty"`
	// Cost - The cost component of the cost item.
	Cost *float64 `json:"cost,omitempty"`
	// CostType - The type of the cost. Possible values include: 'Unavailable', 'Reported', 'Projected'
	CostType CostType `json:"costType,omitempty"`
}

// LabCostProperties properties of a cost item.
type LabCostProperties struct {
	// TargetCost - The target cost properties
	TargetCost *TargetCostProperties `json:"targetCost,omitempty"`
	// LabCostSummary - READ-ONLY; The lab cost summary component of the cost data.
	LabCostSummary *LabCostSummaryProperties `json:"labCostSummary,omitempty"`
	// LabCostDetails - READ-ONLY; The lab cost details component of the cost data.
	LabCostDetails *[]LabCostDetailsProperties `json:"labCostDetails,omitempty"`
	// ResourceCosts - READ-ONLY; The resource cost component of the cost data.
	ResourceCosts *[]LabResourceCostProperties `json:"resourceCosts,omitempty"`
	// CurrencyCode - The currency code of the cost.
	CurrencyCode *string `json:"currencyCode,omitempty"`
	// StartDateTime - The start time of the cost data.
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// EndDateTime - The end time of the cost data.
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// CreatedDate - The creation date of the cost.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for LabCostProperties.
func (lcp LabCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lcp.TargetCost != nil {
		objectMap["targetCost"] = lcp.TargetCost
	}
	if lcp.CurrencyCode != nil {
		objectMap["currencyCode"] = lcp.CurrencyCode
	}
	if lcp.StartDateTime != nil {
		objectMap["startDateTime"] = lcp.StartDateTime
	}
	if lcp.EndDateTime != nil {
		objectMap["endDateTime"] = lcp.EndDateTime
	}
	if lcp.CreatedDate != nil {
		objectMap["createdDate"] = lcp.CreatedDate
	}
	if lcp.ProvisioningState != nil {
		objectMap["provisioningState"] = lcp.ProvisioningState
	}
	if lcp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = lcp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// LabCostSummaryProperties the properties of the cost summary.
type LabCostSummaryProperties struct {
	// EstimatedLabCost - The cost component of the cost item.
	EstimatedLabCost *float64 `json:"estimatedLabCost,omitempty"`
}

// LabFragment a lab.
type LabFragment struct {
	// LabPropertiesFragment - The properties of the resource.
	*LabPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabFragment.
func (lf LabFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lf.LabPropertiesFragment != nil {
		objectMap["properties"] = lf.LabPropertiesFragment
	}
	if lf.Location != nil {
		objectMap["location"] = lf.Location
	}
	if lf.Tags != nil {
		objectMap["tags"] = lf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabFragment struct.
func (lf *LabFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labPropertiesFragment LabPropertiesFragment
				err = json.Unmarshal(*v, &labPropertiesFragment)
				if err != nil {
					return err
				}
				lf.LabPropertiesFragment = &labPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lf.Tags = tags
			}
		}
	}

	return nil
}

// LabProperties properties of a lab.
type LabProperties struct {
	// DefaultStorageAccount - READ-ONLY; The lab's default storage account.
	DefaultStorageAccount *string `json:"defaultStorageAccount,omitempty"`
	// DefaultPremiumStorageAccount - READ-ONLY; The lab's default premium storage account.
	DefaultPremiumStorageAccount *string `json:"defaultPremiumStorageAccount,omitempty"`
	// ArtifactsStorageAccount - READ-ONLY; The lab's artifact storage account.
	ArtifactsStorageAccount *string `json:"artifactsStorageAccount,omitempty"`
	// PremiumDataDiskStorageAccount - READ-ONLY; The lab's premium data disk storage account.
	PremiumDataDiskStorageAccount *string `json:"premiumDataDiskStorageAccount,omitempty"`
	// VaultName - READ-ONLY; The lab's Key vault.
	VaultName *string `json:"vaultName,omitempty"`
	// LabStorageType - Type of storage used by the lab. It can be either Premium or Standard. Default is Premium. Possible values include: 'Standard', 'Premium'
	LabStorageType StorageType `json:"labStorageType,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the lab.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// PremiumDataDisks - The setting to enable usage of premium data disks.
	// When its value is 'Enabled', creation of standard or premium data disks is allowed.
	// When its value is 'Disabled', only creation of standard data disks is allowed. Possible values include: 'PremiumDataDiskDisabled', 'PremiumDataDiskEnabled'
	PremiumDataDisks PremiumDataDisk `json:"premiumDataDisks,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for LabProperties.
func (lp LabProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lp.LabStorageType != "" {
		objectMap["labStorageType"] = lp.LabStorageType
	}
	if lp.PremiumDataDisks != "" {
		objectMap["premiumDataDisks"] = lp.PremiumDataDisks
	}
	if lp.ProvisioningState != nil {
		objectMap["provisioningState"] = lp.ProvisioningState
	}
	if lp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = lp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// LabPropertiesFragment properties of a lab.
type LabPropertiesFragment struct {
	// LabStorageType - Type of storage used by the lab. It can be either Premium or Standard. Default is Premium. Possible values include: 'Standard', 'Premium'
	LabStorageType StorageType `json:"labStorageType,omitempty"`
	// PremiumDataDisks - The setting to enable usage of premium data disks.
	// When its value is 'Enabled', creation of standard or premium data disks is allowed.
	// When its value is 'Disabled', only creation of standard data disks is allowed. Possible values include: 'PremiumDataDiskDisabled', 'PremiumDataDiskEnabled'
	PremiumDataDisks PremiumDataDisk `json:"premiumDataDisks,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LabResourceCostProperties the properties of a resource cost item.
type LabResourceCostProperties struct {
	// Resourcename - The name of the resource.
	Resourcename *string `json:"resourcename,omitempty"`
	// ResourceUID - The unique identifier of the resource.
	ResourceUID *string `json:"resourceUId,omitempty"`
	// ResourceCost - The cost component of the resource cost item.
	ResourceCost *float64 `json:"resourceCost,omitempty"`
	// ResourceType - The logical resource type (ex. virtualmachine, storageaccount)
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceOwner - The owner of the resource (ex. janedoe@microsoft.com)
	ResourceOwner *string `json:"resourceOwner,omitempty"`
	// ResourcePricingTier - The category of the resource (ex. Premium_LRS, Standard_DS1)
	ResourcePricingTier *string `json:"resourcePricingTier,omitempty"`
	// ResourceStatus - The status of the resource (ex. Active)
	ResourceStatus *string `json:"resourceStatus,omitempty"`
	// ResourceID - The ID of the resource
	ResourceID *string `json:"resourceId,omitempty"`
	// ExternalResourceID - The ID of the external resource
	ExternalResourceID *string `json:"externalResourceId,omitempty"`
}

// LabsClaimAnyVMFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsClaimAnyVMFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsClaimAnyVMFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsClaimAnyVMFuture.Result.
func (future *LabsClaimAnyVMFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsClaimAnyVMFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.LabsClaimAnyVMFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsCreateEnvironmentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsCreateEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsCreateEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsCreateEnvironmentFuture.Result.
func (future *LabsCreateEnvironmentFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsCreateEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.LabsCreateEnvironmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (Lab, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsCreateOrUpdateFuture.Result.
func (future *LabsCreateOrUpdateFuture) result(client LabsClient) (l Lab, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		l.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.LabsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if l.Response.Response, err = future.GetResult(sender); err == nil && l.Response.Response.StatusCode != http.StatusNoContent {
		l, err = client.CreateOrUpdateResponder(l.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.LabsCreateOrUpdateFuture", "Result", l.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LabsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsDeleteFuture.Result.
func (future *LabsDeleteFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.LabsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabsExportResourceUsageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabsExportResourceUsageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsExportResourceUsageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsExportResourceUsageFuture.Result.
func (future *LabsExportResourceUsageFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabsExportResourceUsageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.LabsExportResourceUsageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabVhd properties of a VHD in the lab.
type LabVhd struct {
	// ID - The URI to the VHD.
	ID *string `json:"id,omitempty"`
}

// LabVirtualMachine a virtual machine.
type LabVirtualMachine struct {
	autorest.Response `json:"-"`
	// LabVirtualMachineProperties - The properties of the resource.
	*LabVirtualMachineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachine.
func (lvm LabVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvm.LabVirtualMachineProperties != nil {
		objectMap["properties"] = lvm.LabVirtualMachineProperties
	}
	if lvm.Location != nil {
		objectMap["location"] = lvm.Location
	}
	if lvm.Tags != nil {
		objectMap["tags"] = lvm.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachine struct.
func (lvm *LabVirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachineProperties LabVirtualMachineProperties
				err = json.Unmarshal(*v, &labVirtualMachineProperties)
				if err != nil {
					return err
				}
				lvm.LabVirtualMachineProperties = &labVirtualMachineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lvm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lvm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lvm.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lvm.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvm.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineCreationParameter properties for creating a virtual machine.
type LabVirtualMachineCreationParameter struct {
	// LabVirtualMachineCreationParameterProperties - The properties of the resource.
	*LabVirtualMachineCreationParameterProperties `json:"properties,omitempty"`
	// Name - The name of the virtual machine or environment
	Name *string `json:"name,omitempty"`
	// Location - The location of the new virtual machine or environment
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachineCreationParameter.
func (lvmcp LabVirtualMachineCreationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvmcp.LabVirtualMachineCreationParameterProperties != nil {
		objectMap["properties"] = lvmcp.LabVirtualMachineCreationParameterProperties
	}
	if lvmcp.Name != nil {
		objectMap["name"] = lvmcp.Name
	}
	if lvmcp.Location != nil {
		objectMap["location"] = lvmcp.Location
	}
	if lvmcp.Tags != nil {
		objectMap["tags"] = lvmcp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachineCreationParameter struct.
func (lvmcp *LabVirtualMachineCreationParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachineCreationParameterProperties LabVirtualMachineCreationParameterProperties
				err = json.Unmarshal(*v, &labVirtualMachineCreationParameterProperties)
				if err != nil {
					return err
				}
				lvmcp.LabVirtualMachineCreationParameterProperties = &labVirtualMachineCreationParameterProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lvmcp.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lvmcp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvmcp.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineCreationParameterProperties properties for virtual machine creation.
type LabVirtualMachineCreationParameterProperties struct {
	// BulkCreationParameters - The number of virtual machine instances to create.
	BulkCreationParameters *BulkCreationParameters `json:"bulkCreationParameters,omitempty"`
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// OwnerUserPrincipalName - The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// CreatedDate - The creation date of the virtual machine.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReference `json:"galleryImageReference,omitempty"`
	// ComputeVM - The compute virtual machine properties.
	ComputeVM *ComputeVMProperties `json:"computeVm,omitempty"`
	// NetworkInterface - The network interface properties.
	NetworkInterface *NetworkInterfaceProperties `json:"networkInterface,omitempty"`
	// ApplicableSchedule - The applicable schedule for the virtual machine.
	ApplicableSchedule *ApplicableSchedule `json:"applicableSchedule,omitempty"`
	// ExpirationDate - The expiration date for VM.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// AllowClaim - Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`
	// StorageType - Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`
	// VirtualMachineCreationSource - Tells source of creation of lab virtual machine. Output property only. Possible values include: 'FromCustomImage', 'FromGalleryImage'
	VirtualMachineCreationSource VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty"`
	// EnvironmentID - The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LabVirtualMachineFragment a virtual machine.
type LabVirtualMachineFragment struct {
	// LabVirtualMachinePropertiesFragment - The properties of the resource.
	*LabVirtualMachinePropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachineFragment.
func (lvmf LabVirtualMachineFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvmf.LabVirtualMachinePropertiesFragment != nil {
		objectMap["properties"] = lvmf.LabVirtualMachinePropertiesFragment
	}
	if lvmf.Location != nil {
		objectMap["location"] = lvmf.Location
	}
	if lvmf.Tags != nil {
		objectMap["tags"] = lvmf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachineFragment struct.
func (lvmf *LabVirtualMachineFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachinePropertiesFragment LabVirtualMachinePropertiesFragment
				err = json.Unmarshal(*v, &labVirtualMachinePropertiesFragment)
				if err != nil {
					return err
				}
				lvmf.LabVirtualMachinePropertiesFragment = &labVirtualMachinePropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lvmf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lvmf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lvmf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lvmf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvmf.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineProperties properties of a virtual machine.
type LabVirtualMachineProperties struct {
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// OwnerUserPrincipalName - The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// CreatedDate - The creation date of the virtual machine.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ComputeID - READ-ONLY; The resource identifier (Microsoft.Compute) of the virtual machine.
	ComputeID *string `json:"computeId,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReference `json:"galleryImageReference,omitempty"`
	// ComputeVM - The compute virtual machine properties.
	ComputeVM *ComputeVMProperties `json:"computeVm,omitempty"`
	// NetworkInterface - The network interface properties.
	NetworkInterface *NetworkInterfaceProperties `json:"networkInterface,omitempty"`
	// ApplicableSchedule - The applicable schedule for the virtual machine.
	ApplicableSchedule *ApplicableSchedule `json:"applicableSchedule,omitempty"`
	// ExpirationDate - The expiration date for VM.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// AllowClaim - Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`
	// StorageType - Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`
	// VirtualMachineCreationSource - Tells source of creation of lab virtual machine. Output property only. Possible values include: 'FromCustomImage', 'FromGalleryImage'
	VirtualMachineCreationSource VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty"`
	// EnvironmentID - The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachineProperties.
func (lvmp LabVirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvmp.Notes != nil {
		objectMap["notes"] = lvmp.Notes
	}
	if lvmp.OwnerObjectID != nil {
		objectMap["ownerObjectId"] = lvmp.OwnerObjectID
	}
	if lvmp.OwnerUserPrincipalName != nil {
		objectMap["ownerUserPrincipalName"] = lvmp.OwnerUserPrincipalName
	}
	if lvmp.CreatedByUserID != nil {
		objectMap["createdByUserId"] = lvmp.CreatedByUserID
	}
	if lvmp.CreatedByUser != nil {
		objectMap["createdByUser"] = lvmp.CreatedByUser
	}
	if lvmp.CreatedDate != nil {
		objectMap["createdDate"] = lvmp.CreatedDate
	}
	if lvmp.CustomImageID != nil {
		objectMap["customImageId"] = lvmp.CustomImageID
	}
	if lvmp.OsType != nil {
		objectMap["osType"] = lvmp.OsType
	}
	if lvmp.Size != nil {
		objectMap["size"] = lvmp.Size
	}
	if lvmp.UserName != nil {
		objectMap["userName"] = lvmp.UserName
	}
	if lvmp.Password != nil {
		objectMap["password"] = lvmp.Password
	}
	if lvmp.SSHKey != nil {
		objectMap["sshKey"] = lvmp.SSHKey
	}
	if lvmp.IsAuthenticationWithSSHKey != nil {
		objectMap["isAuthenticationWithSshKey"] = lvmp.IsAuthenticationWithSSHKey
	}
	if lvmp.Fqdn != nil {
		objectMap["fqdn"] = lvmp.Fqdn
	}
	if lvmp.LabSubnetName != nil {
		objectMap["labSubnetName"] = lvmp.LabSubnetName
	}
	if lvmp.LabVirtualNetworkID != nil {
		objectMap["labVirtualNetworkId"] = lvmp.LabVirtualNetworkID
	}
	if lvmp.DisallowPublicIPAddress != nil {
		objectMap["disallowPublicIpAddress"] = lvmp.DisallowPublicIPAddress
	}
	if lvmp.Artifacts != nil {
		objectMap["artifacts"] = lvmp.Artifacts
	}
	if lvmp.ArtifactDeploymentStatus != nil {
		objectMap["artifactDeploymentStatus"] = lvmp.ArtifactDeploymentStatus
	}
	if lvmp.GalleryImageReference != nil {
		objectMap["galleryImageReference"] = lvmp.GalleryImageReference
	}
	if lvmp.ComputeVM != nil {
		objectMap["computeVm"] = lvmp.ComputeVM
	}
	if lvmp.NetworkInterface != nil {
		objectMap["networkInterface"] = lvmp.NetworkInterface
	}
	if lvmp.ApplicableSchedule != nil {
		objectMap["applicableSchedule"] = lvmp.ApplicableSchedule
	}
	if lvmp.ExpirationDate != nil {
		objectMap["expirationDate"] = lvmp.ExpirationDate
	}
	if lvmp.AllowClaim != nil {
		objectMap["allowClaim"] = lvmp.AllowClaim
	}
	if lvmp.StorageType != nil {
		objectMap["storageType"] = lvmp.StorageType
	}
	if lvmp.VirtualMachineCreationSource != "" {
		objectMap["virtualMachineCreationSource"] = lvmp.VirtualMachineCreationSource
	}
	if lvmp.EnvironmentID != nil {
		objectMap["environmentId"] = lvmp.EnvironmentID
	}
	if lvmp.ProvisioningState != nil {
		objectMap["provisioningState"] = lvmp.ProvisioningState
	}
	if lvmp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = lvmp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// LabVirtualMachinePropertiesFragment properties of a virtual machine.
type LabVirtualMachinePropertiesFragment struct {
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// OwnerUserPrincipalName - The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// CreatedDate - The creation date of the virtual machine.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallPropertiesFragment `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusPropertiesFragment `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReferenceFragment `json:"galleryImageReference,omitempty"`
	// ComputeVM - The compute virtual machine properties.
	ComputeVM *ComputeVMPropertiesFragment `json:"computeVm,omitempty"`
	// NetworkInterface - The network interface properties.
	NetworkInterface *NetworkInterfacePropertiesFragment `json:"networkInterface,omitempty"`
	// ApplicableSchedule - The applicable schedule for the virtual machine.
	ApplicableSchedule *ApplicableScheduleFragment `json:"applicableSchedule,omitempty"`
	// ExpirationDate - The expiration date for VM.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// AllowClaim - Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`
	// StorageType - Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`
	// VirtualMachineCreationSource - Tells source of creation of lab virtual machine. Output property only. Possible values include: 'FromCustomImage', 'FromGalleryImage'
	VirtualMachineCreationSource VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty"`
	// EnvironmentID - The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LinuxOsInfo information about a Linux OS.
type LinuxOsInfo struct {
	// LinuxOsState - The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied). Possible values include: 'NonDeprovisioned', 'DeprovisionRequested', 'DeprovisionApplied'
	LinuxOsState LinuxOsState `json:"linuxOsState,omitempty"`
}

// NetworkInterfaceProperties properties of a network interface.
type NetworkInterfaceProperties struct {
	// VirtualNetworkID - The resource ID of the virtual network.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
	// SubnetID - The resource ID of the sub net.
	SubnetID *string `json:"subnetId,omitempty"`
	// PublicIPAddressID - The resource ID of the public IP address.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`
	// PublicIPAddress - The public IP address.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// PrivateIPAddress - The private IP address.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// DNSName - The DNS name.
	DNSName *string `json:"dnsName,omitempty"`
	// RdpAuthority - The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// SSHAuthority - The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// SharedPublicIPAddressConfiguration - The configuration for sharing a public IP address across multiple virtual machines.
	SharedPublicIPAddressConfiguration *SharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`
}

// NetworkInterfacePropertiesFragment properties of a network interface.
type NetworkInterfacePropertiesFragment struct {
	// VirtualNetworkID - The resource ID of the virtual network.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
	// SubnetID - The resource ID of the sub net.
	SubnetID *string `json:"subnetId,omitempty"`
	// PublicIPAddressID - The resource ID of the public IP address.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`
	// PublicIPAddress - The public IP address.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// PrivateIPAddress - The private IP address.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// DNSName - The DNS name.
	DNSName *string `json:"dnsName,omitempty"`
	// RdpAuthority - The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// SSHAuthority - The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// SharedPublicIPAddressConfiguration - The configuration for sharing a public IP address across multiple virtual machines.
	SharedPublicIPAddressConfiguration *SharedPublicIPAddressConfigurationFragment `json:"sharedPublicIpAddressConfiguration,omitempty"`
}

// NotificationChannel a notification.
type NotificationChannel struct {
	autorest.Response `json:"-"`
	// NotificationChannelProperties - The properties of the resource.
	*NotificationChannelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for NotificationChannel.
func (nc NotificationChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nc.NotificationChannelProperties != nil {
		objectMap["properties"] = nc.NotificationChannelProperties
	}
	if nc.Location != nil {
		objectMap["location"] = nc.Location
	}
	if nc.Tags != nil {
		objectMap["tags"] = nc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotificationChannel struct.
func (nc *NotificationChannel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var notificationChannelProperties NotificationChannelProperties
				err = json.Unmarshal(*v, &notificationChannelProperties)
				if err != nil {
					return err
				}
				nc.NotificationChannelProperties = &notificationChannelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nc.Tags = tags
			}
		}
	}

	return nil
}

// NotificationChannelFragment a notification.
type NotificationChannelFragment struct {
	// NotificationChannelPropertiesFragment - The properties of the resource.
	*NotificationChannelPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for NotificationChannelFragment.
func (ncf NotificationChannelFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ncf.NotificationChannelPropertiesFragment != nil {
		objectMap["properties"] = ncf.NotificationChannelPropertiesFragment
	}
	if ncf.Location != nil {
		objectMap["location"] = ncf.Location
	}
	if ncf.Tags != nil {
		objectMap["tags"] = ncf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotificationChannelFragment struct.
func (ncf *NotificationChannelFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var notificationChannelPropertiesFragment NotificationChannelPropertiesFragment
				err = json.Unmarshal(*v, &notificationChannelPropertiesFragment)
				if err != nil {
					return err
				}
				ncf.NotificationChannelPropertiesFragment = &notificationChannelPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ncf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ncf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ncf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ncf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ncf.Tags = tags
			}
		}
	}

	return nil
}

// NotificationChannelProperties properties of a schedule.
type NotificationChannelProperties struct {
	// WebHookURL - The webhook URL to send notifications to.
	WebHookURL *string `json:"webHookUrl,omitempty"`
	// Description - Description of notification.
	Description *string `json:"description,omitempty"`
	// Events - The list of event for which this notification is enabled.
	Events *[]Event `json:"events,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the notification channel.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for NotificationChannelProperties.
func (ncp NotificationChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ncp.WebHookURL != nil {
		objectMap["webHookUrl"] = ncp.WebHookURL
	}
	if ncp.Description != nil {
		objectMap["description"] = ncp.Description
	}
	if ncp.Events != nil {
		objectMap["events"] = ncp.Events
	}
	if ncp.ProvisioningState != nil {
		objectMap["provisioningState"] = ncp.ProvisioningState
	}
	if ncp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = ncp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// NotificationChannelPropertiesFragment properties of a schedule.
type NotificationChannelPropertiesFragment struct {
	// WebHookURL - The webhook URL to send notifications to.
	WebHookURL *string `json:"webHookUrl,omitempty"`
	// Description - Description of notification.
	Description *string `json:"description,omitempty"`
	// Events - The list of event for which this notification is enabled.
	Events *[]EventFragment `json:"events,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// NotificationSettings notification settings for a schedule.
type NotificationSettings struct {
	// Status - If notifications are enabled for this schedule (i.e. Enabled, Disabled). Possible values include: 'NotificationStatusDisabled', 'NotificationStatusEnabled'
	Status NotificationStatus `json:"status,omitempty"`
	// TimeInMinutes - Time in minutes before event at which notification will be sent.
	TimeInMinutes *int32 `json:"timeInMinutes,omitempty"`
	// WebhookURL - The webhook URL to which the notification will be sent.
	WebhookURL *string `json:"webhookUrl,omitempty"`
}

// NotificationSettingsFragment notification settings for a schedule.
type NotificationSettingsFragment struct {
	// Status - If notifications are enabled for this schedule (i.e. Enabled, Disabled). Possible values include: 'NotificationStatusDisabled', 'NotificationStatusEnabled'
	Status NotificationStatus `json:"status,omitempty"`
	// TimeInMinutes - Time in minutes before event at which notification will be sent.
	TimeInMinutes *int32 `json:"timeInMinutes,omitempty"`
	// WebhookURL - The webhook URL to which the notification will be sent.
	WebhookURL *string `json:"webhookUrl,omitempty"`
}

// NotifyParameters properties for generating a Notification.
type NotifyParameters struct {
	// EventName - The type of event (i.e. AutoShutdown, Cost). Possible values include: 'AutoShutdown', 'Cost'
	EventName NotificationChannelEventType `json:"eventName,omitempty"`
	// JSONPayload - Properties for the notification in json format.
	JSONPayload *string `json:"jsonPayload,omitempty"`
}

// OperationError error details for the operation in case of a failure.
type OperationError struct {
	// Code - The error code of the operation error.
	Code *string `json:"code,omitempty"`
	// Message - The error message of the operation error.
	Message *string `json:"message,omitempty"`
}

// OperationMetadata the REST API operation supported by DevTestLab ResourceProvider.
type OperationMetadata struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operations
	Display *OperationMetadataDisplay `json:"display,omitempty"`
}

// OperationMetadataDisplay the object that describes the operations
type OperationMetadataDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationResult an Operation Result
type OperationResult struct {
	autorest.Response `json:"-"`
	// Status - The operation status.
	Status *string `json:"status,omitempty"`
	// StatusCode - The status code for the operation. Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'MovedPermanently', 'Redirect', 'SeeOther', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	// Error - Error details for the operation in case of a failure.
	Error *OperationError `json:"error,omitempty"`
}

// ParameterInfo information about an artifact's parameter.
type ParameterInfo struct {
	// Name - The name of the artifact parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ParametersValueFileInfo a file containing a set of parameter values for an ARM template.
type ParametersValueFileInfo struct {
	// FileName - File name.
	FileName *string `json:"fileName,omitempty"`
	// ParametersValueInfo - Contents of the file.
	ParametersValueInfo interface{} `json:"parametersValueInfo,omitempty"`
}

// PercentageCostThresholdProperties properties of a percentage cost threshold.
type PercentageCostThresholdProperties struct {
	// ThresholdValue - The cost threshold value.
	ThresholdValue *float64 `json:"thresholdValue,omitempty"`
}

// Policy a Policy.
type Policy struct {
	autorest.Response `json:"-"`
	// PolicyProperties - The properties of the resource.
	*PolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PolicyProperties != nil {
		objectMap["properties"] = p.PolicyProperties
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Policy struct.
func (p *Policy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyProperties PolicyProperties
				err = json.Unmarshal(*v, &policyProperties)
				if err != nil {
					return err
				}
				p.PolicyProperties = &policyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		}
	}

	return nil
}

// PolicyFragment a Policy.
type PolicyFragment struct {
	// PolicyPropertiesFragment - The properties of the resource.
	*PolicyPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PolicyFragment.
func (pf PolicyFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pf.PolicyPropertiesFragment != nil {
		objectMap["properties"] = pf.PolicyPropertiesFragment
	}
	if pf.Location != nil {
		objectMap["location"] = pf.Location
	}
	if pf.Tags != nil {
		objectMap["tags"] = pf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PolicyFragment struct.
func (pf *PolicyFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyPropertiesFragment PolicyPropertiesFragment
				err = json.Unmarshal(*v, &policyPropertiesFragment)
				if err != nil {
					return err
				}
				pf.PolicyPropertiesFragment = &policyPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pf.Tags = tags
			}
		}
	}

	return nil
}

// PolicyProperties properties of a Policy.
type PolicyProperties struct {
	// Description - The description of the policy.
	Description *string `json:"description,omitempty"`
	// Status - The status of the policy. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
	// FactName - The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc. Possible values include: 'PolicyFactNameUserOwnedLabVMCount', 'PolicyFactNameUserOwnedLabPremiumVMCount', 'PolicyFactNameLabVMCount', 'PolicyFactNameLabPremiumVMCount', 'PolicyFactNameLabVMSize', 'PolicyFactNameGalleryImage', 'PolicyFactNameUserOwnedLabVMCountInSubnet', 'PolicyFactNameLabTargetCost'
	FactName PolicyFactName `json:"factName,omitempty"`
	// FactData - The fact data of the policy.
	FactData *string `json:"factData,omitempty"`
	// Threshold - The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
	Threshold *string `json:"threshold,omitempty"`
	// EvaluatorType - The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy). Possible values include: 'AllowedValuesPolicy', 'MaxValuePolicy'
	EvaluatorType PolicyEvaluatorType `json:"evaluatorType,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the policy.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyProperties.
func (pp PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Description != nil {
		objectMap["description"] = pp.Description
	}
	if pp.Status != "" {
		objectMap["status"] = pp.Status
	}
	if pp.FactName != "" {
		objectMap["factName"] = pp.FactName
	}
	if pp.FactData != nil {
		objectMap["factData"] = pp.FactData
	}
	if pp.Threshold != nil {
		objectMap["threshold"] = pp.Threshold
	}
	if pp.EvaluatorType != "" {
		objectMap["evaluatorType"] = pp.EvaluatorType
	}
	if pp.ProvisioningState != nil {
		objectMap["provisioningState"] = pp.ProvisioningState
	}
	if pp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = pp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// PolicyPropertiesFragment properties of a Policy.
type PolicyPropertiesFragment struct {
	// Description - The description of the policy.
	Description *string `json:"description,omitempty"`
	// Status - The status of the policy. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
	// FactName - The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc. Possible values include: 'PolicyFactNameUserOwnedLabVMCount', 'PolicyFactNameUserOwnedLabPremiumVMCount', 'PolicyFactNameLabVMCount', 'PolicyFactNameLabPremiumVMCount', 'PolicyFactNameLabVMSize', 'PolicyFactNameGalleryImage', 'PolicyFactNameUserOwnedLabVMCountInSubnet', 'PolicyFactNameLabTargetCost'
	FactName PolicyFactName `json:"factName,omitempty"`
	// FactData - The fact data of the policy.
	FactData *string `json:"factData,omitempty"`
	// Threshold - The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
	Threshold *string `json:"threshold,omitempty"`
	// EvaluatorType - The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy). Possible values include: 'AllowedValuesPolicy', 'MaxValuePolicy'
	EvaluatorType PolicyEvaluatorType `json:"evaluatorType,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// PolicySetResult result of a policy set evaluation.
type PolicySetResult struct {
	// HasError - A value indicating whether this policy set evaluation has discovered violations.
	HasError *bool `json:"hasError,omitempty"`
	// PolicyViolations - The list of policy violations.
	PolicyViolations *[]PolicyViolation `json:"policyViolations,omitempty"`
}

// PolicyViolation policy violation.
type PolicyViolation struct {
	// Code - The code of the policy violation.
	Code *string `json:"code,omitempty"`
	// Message - The message of the policy violation.
	Message *string `json:"message,omitempty"`
}

// Port properties of a network port.
type Port struct {
	// TransportProtocol - Protocol type of the port. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// BackendPort - Backend port of the target virtual machine.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// PortFragment properties of a network port.
type PortFragment struct {
	// TransportProtocol - Protocol type of the port. Possible values include: 'TCP', 'UDP'
	TransportProtocol TransportProtocol `json:"transportProtocol,omitempty"`
	// BackendPort - Backend port of the target virtual machine.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// ProviderOperationResult result of the request to list REST API operations
type ProviderOperationResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]OperationMetadata `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderOperationResult.
func (por ProviderOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if por.Value != nil {
		objectMap["value"] = por.Value
	}
	return json.Marshal(objectMap)
}

// ProviderOperationResultIterator provides access to a complete listing of OperationMetadata values.
type ProviderOperationResultIterator struct {
	i    int
	page ProviderOperationResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderOperationResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderOperationResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderOperationResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderOperationResultIterator) Response() ProviderOperationResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderOperationResultIterator) Value() OperationMetadata {
	if !iter.page.NotDone() {
		return OperationMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderOperationResultIterator type.
func NewProviderOperationResultIterator(page ProviderOperationResultPage) ProviderOperationResultIterator {
	return ProviderOperationResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (por ProviderOperationResult) IsEmpty() bool {
	return por.Value == nil || len(*por.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (por ProviderOperationResult) hasNextLink() bool {
	return por.NextLink != nil && len(*por.NextLink) != 0
}

// providerOperationResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (por ProviderOperationResult) providerOperationResultPreparer(ctx context.Context) (*http.Request, error) {
	if !por.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(por.NextLink)))
}

// ProviderOperationResultPage contains a page of OperationMetadata values.
type ProviderOperationResultPage struct {
	fn  func(context.Context, ProviderOperationResult) (ProviderOperationResult, error)
	por ProviderOperationResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderOperationResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.por)
		if err != nil {
			return err
		}
		page.por = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderOperationResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderOperationResultPage) NotDone() bool {
	return !page.por.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderOperationResultPage) Response() ProviderOperationResult {
	return page.por
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderOperationResultPage) Values() []OperationMetadata {
	if page.por.IsEmpty() {
		return nil
	}
	return *page.por.Value
}

// Creates a new instance of the ProviderOperationResultPage type.
func NewProviderOperationResultPage(cur ProviderOperationResult, getNextPage func(context.Context, ProviderOperationResult) (ProviderOperationResult, error)) ProviderOperationResultPage {
	return ProviderOperationResultPage{
		fn:  getNextPage,
		por: cur,
	}
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResponseWithContinuationArmTemplate the response of a list operation.
type ResponseWithContinuationArmTemplate struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ArmTemplate `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArmTemplateIterator provides access to a complete listing of ArmTemplate values.
type ResponseWithContinuationArmTemplateIterator struct {
	i    int
	page ResponseWithContinuationArmTemplatePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationArmTemplateIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationArmTemplateIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationArmTemplateIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationArmTemplateIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationArmTemplateIterator) Response() ResponseWithContinuationArmTemplate {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationArmTemplateIterator) Value() ArmTemplate {
	if !iter.page.NotDone() {
		return ArmTemplate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationArmTemplateIterator type.
func NewResponseWithContinuationArmTemplateIterator(page ResponseWithContinuationArmTemplatePage) ResponseWithContinuationArmTemplateIterator {
	return ResponseWithContinuationArmTemplateIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcAt ResponseWithContinuationArmTemplate) IsEmpty() bool {
	return rwcAt.Value == nil || len(*rwcAt.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcAt ResponseWithContinuationArmTemplate) hasNextLink() bool {
	return rwcAt.NextLink != nil && len(*rwcAt.NextLink) != 0
}

// responseWithContinuationArmTemplatePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcAt ResponseWithContinuationArmTemplate) responseWithContinuationArmTemplatePreparer(ctx context.Context) (*http.Request, error) {
	if !rwcAt.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcAt.NextLink)))
}

// ResponseWithContinuationArmTemplatePage contains a page of ArmTemplate values.
type ResponseWithContinuationArmTemplatePage struct {
	fn    func(context.Context, ResponseWithContinuationArmTemplate) (ResponseWithContinuationArmTemplate, error)
	rwcat ResponseWithContinuationArmTemplate
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationArmTemplatePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationArmTemplatePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcat)
		if err != nil {
			return err
		}
		page.rwcat = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationArmTemplatePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationArmTemplatePage) NotDone() bool {
	return !page.rwcat.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationArmTemplatePage) Response() ResponseWithContinuationArmTemplate {
	return page.rwcat
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationArmTemplatePage) Values() []ArmTemplate {
	if page.rwcat.IsEmpty() {
		return nil
	}
	return *page.rwcat.Value
}

// Creates a new instance of the ResponseWithContinuationArmTemplatePage type.
func NewResponseWithContinuationArmTemplatePage(cur ResponseWithContinuationArmTemplate, getNextPage func(context.Context, ResponseWithContinuationArmTemplate) (ResponseWithContinuationArmTemplate, error)) ResponseWithContinuationArmTemplatePage {
	return ResponseWithContinuationArmTemplatePage{
		fn:    getNextPage,
		rwcat: cur,
	}
}

// ResponseWithContinuationArtifact the response of a list operation.
type ResponseWithContinuationArtifact struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Artifact `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArtifactIterator provides access to a complete listing of Artifact values.
type ResponseWithContinuationArtifactIterator struct {
	i    int
	page ResponseWithContinuationArtifactPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationArtifactIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationArtifactIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationArtifactIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationArtifactIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationArtifactIterator) Response() ResponseWithContinuationArtifact {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationArtifactIterator) Value() Artifact {
	if !iter.page.NotDone() {
		return Artifact{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationArtifactIterator type.
func NewResponseWithContinuationArtifactIterator(page ResponseWithContinuationArtifactPage) ResponseWithContinuationArtifactIterator {
	return ResponseWithContinuationArtifactIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcA ResponseWithContinuationArtifact) IsEmpty() bool {
	return rwcA.Value == nil || len(*rwcA.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcA ResponseWithContinuationArtifact) hasNextLink() bool {
	return rwcA.NextLink != nil && len(*rwcA.NextLink) != 0
}

// responseWithContinuationArtifactPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcA ResponseWithContinuationArtifact) responseWithContinuationArtifactPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcA.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcA.NextLink)))
}

// ResponseWithContinuationArtifactPage contains a page of Artifact values.
type ResponseWithContinuationArtifactPage struct {
	fn   func(context.Context, ResponseWithContinuationArtifact) (ResponseWithContinuationArtifact, error)
	rwca ResponseWithContinuationArtifact
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationArtifactPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationArtifactPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwca)
		if err != nil {
			return err
		}
		page.rwca = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationArtifactPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationArtifactPage) NotDone() bool {
	return !page.rwca.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationArtifactPage) Response() ResponseWithContinuationArtifact {
	return page.rwca
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationArtifactPage) Values() []Artifact {
	if page.rwca.IsEmpty() {
		return nil
	}
	return *page.rwca.Value
}

// Creates a new instance of the ResponseWithContinuationArtifactPage type.
func NewResponseWithContinuationArtifactPage(cur ResponseWithContinuationArtifact, getNextPage func(context.Context, ResponseWithContinuationArtifact) (ResponseWithContinuationArtifact, error)) ResponseWithContinuationArtifactPage {
	return ResponseWithContinuationArtifactPage{
		fn:   getNextPage,
		rwca: cur,
	}
}

// ResponseWithContinuationArtifactSource the response of a list operation.
type ResponseWithContinuationArtifactSource struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ArtifactSource `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArtifactSourceIterator provides access to a complete listing of ArtifactSource
// values.
type ResponseWithContinuationArtifactSourceIterator struct {
	i    int
	page ResponseWithContinuationArtifactSourcePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationArtifactSourceIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationArtifactSourceIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationArtifactSourceIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationArtifactSourceIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationArtifactSourceIterator) Response() ResponseWithContinuationArtifactSource {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationArtifactSourceIterator) Value() ArtifactSource {
	if !iter.page.NotDone() {
		return ArtifactSource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationArtifactSourceIterator type.
func NewResponseWithContinuationArtifactSourceIterator(page ResponseWithContinuationArtifactSourcePage) ResponseWithContinuationArtifactSourceIterator {
	return ResponseWithContinuationArtifactSourceIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcAs ResponseWithContinuationArtifactSource) IsEmpty() bool {
	return rwcAs.Value == nil || len(*rwcAs.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcAs ResponseWithContinuationArtifactSource) hasNextLink() bool {
	return rwcAs.NextLink != nil && len(*rwcAs.NextLink) != 0
}

// responseWithContinuationArtifactSourcePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcAs ResponseWithContinuationArtifactSource) responseWithContinuationArtifactSourcePreparer(ctx context.Context) (*http.Request, error) {
	if !rwcAs.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcAs.NextLink)))
}

// ResponseWithContinuationArtifactSourcePage contains a page of ArtifactSource values.
type ResponseWithContinuationArtifactSourcePage struct {
	fn    func(context.Context, ResponseWithContinuationArtifactSource) (ResponseWithContinuationArtifactSource, error)
	rwcas ResponseWithContinuationArtifactSource
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationArtifactSourcePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationArtifactSourcePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcas)
		if err != nil {
			return err
		}
		page.rwcas = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationArtifactSourcePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationArtifactSourcePage) NotDone() bool {
	return !page.rwcas.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationArtifactSourcePage) Response() ResponseWithContinuationArtifactSource {
	return page.rwcas
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationArtifactSourcePage) Values() []ArtifactSource {
	if page.rwcas.IsEmpty() {
		return nil
	}
	return *page.rwcas.Value
}

// Creates a new instance of the ResponseWithContinuationArtifactSourcePage type.
func NewResponseWithContinuationArtifactSourcePage(cur ResponseWithContinuationArtifactSource, getNextPage func(context.Context, ResponseWithContinuationArtifactSource) (ResponseWithContinuationArtifactSource, error)) ResponseWithContinuationArtifactSourcePage {
	return ResponseWithContinuationArtifactSourcePage{
		fn:    getNextPage,
		rwcas: cur,
	}
}

// ResponseWithContinuationCustomImage the response of a list operation.
type ResponseWithContinuationCustomImage struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]CustomImage `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationCustomImageIterator provides access to a complete listing of CustomImage values.
type ResponseWithContinuationCustomImageIterator struct {
	i    int
	page ResponseWithContinuationCustomImagePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationCustomImageIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationCustomImageIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationCustomImageIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationCustomImageIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationCustomImageIterator) Response() ResponseWithContinuationCustomImage {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationCustomImageIterator) Value() CustomImage {
	if !iter.page.NotDone() {
		return CustomImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationCustomImageIterator type.
func NewResponseWithContinuationCustomImageIterator(page ResponseWithContinuationCustomImagePage) ResponseWithContinuationCustomImageIterator {
	return ResponseWithContinuationCustomImageIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcCi ResponseWithContinuationCustomImage) IsEmpty() bool {
	return rwcCi.Value == nil || len(*rwcCi.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcCi ResponseWithContinuationCustomImage) hasNextLink() bool {
	return rwcCi.NextLink != nil && len(*rwcCi.NextLink) != 0
}

// responseWithContinuationCustomImagePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcCi ResponseWithContinuationCustomImage) responseWithContinuationCustomImagePreparer(ctx context.Context) (*http.Request, error) {
	if !rwcCi.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcCi.NextLink)))
}

// ResponseWithContinuationCustomImagePage contains a page of CustomImage values.
type ResponseWithContinuationCustomImagePage struct {
	fn    func(context.Context, ResponseWithContinuationCustomImage) (ResponseWithContinuationCustomImage, error)
	rwcci ResponseWithContinuationCustomImage
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationCustomImagePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationCustomImagePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcci)
		if err != nil {
			return err
		}
		page.rwcci = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationCustomImagePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationCustomImagePage) NotDone() bool {
	return !page.rwcci.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationCustomImagePage) Response() ResponseWithContinuationCustomImage {
	return page.rwcci
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationCustomImagePage) Values() []CustomImage {
	if page.rwcci.IsEmpty() {
		return nil
	}
	return *page.rwcci.Value
}

// Creates a new instance of the ResponseWithContinuationCustomImagePage type.
func NewResponseWithContinuationCustomImagePage(cur ResponseWithContinuationCustomImage, getNextPage func(context.Context, ResponseWithContinuationCustomImage) (ResponseWithContinuationCustomImage, error)) ResponseWithContinuationCustomImagePage {
	return ResponseWithContinuationCustomImagePage{
		fn:    getNextPage,
		rwcci: cur,
	}
}

// ResponseWithContinuationDisk the response of a list operation.
type ResponseWithContinuationDisk struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Disk `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationDiskIterator provides access to a complete listing of Disk values.
type ResponseWithContinuationDiskIterator struct {
	i    int
	page ResponseWithContinuationDiskPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationDiskIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationDiskIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationDiskIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationDiskIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationDiskIterator) Response() ResponseWithContinuationDisk {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationDiskIterator) Value() Disk {
	if !iter.page.NotDone() {
		return Disk{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationDiskIterator type.
func NewResponseWithContinuationDiskIterator(page ResponseWithContinuationDiskPage) ResponseWithContinuationDiskIterator {
	return ResponseWithContinuationDiskIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcD ResponseWithContinuationDisk) IsEmpty() bool {
	return rwcD.Value == nil || len(*rwcD.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcD ResponseWithContinuationDisk) hasNextLink() bool {
	return rwcD.NextLink != nil && len(*rwcD.NextLink) != 0
}

// responseWithContinuationDiskPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcD ResponseWithContinuationDisk) responseWithContinuationDiskPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcD.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcD.NextLink)))
}

// ResponseWithContinuationDiskPage contains a page of Disk values.
type ResponseWithContinuationDiskPage struct {
	fn   func(context.Context, ResponseWithContinuationDisk) (ResponseWithContinuationDisk, error)
	rwcd ResponseWithContinuationDisk
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationDiskPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationDiskPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcd)
		if err != nil {
			return err
		}
		page.rwcd = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationDiskPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationDiskPage) NotDone() bool {
	return !page.rwcd.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationDiskPage) Response() ResponseWithContinuationDisk {
	return page.rwcd
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationDiskPage) Values() []Disk {
	if page.rwcd.IsEmpty() {
		return nil
	}
	return *page.rwcd.Value
}

// Creates a new instance of the ResponseWithContinuationDiskPage type.
func NewResponseWithContinuationDiskPage(cur ResponseWithContinuationDisk, getNextPage func(context.Context, ResponseWithContinuationDisk) (ResponseWithContinuationDisk, error)) ResponseWithContinuationDiskPage {
	return ResponseWithContinuationDiskPage{
		fn:   getNextPage,
		rwcd: cur,
	}
}

// ResponseWithContinuationDtlEnvironment the response of a list operation.
type ResponseWithContinuationDtlEnvironment struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Environment `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationDtlEnvironmentIterator provides access to a complete listing of Environment
// values.
type ResponseWithContinuationDtlEnvironmentIterator struct {
	i    int
	page ResponseWithContinuationDtlEnvironmentPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationDtlEnvironmentIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationDtlEnvironmentIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationDtlEnvironmentIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationDtlEnvironmentIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationDtlEnvironmentIterator) Response() ResponseWithContinuationDtlEnvironment {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationDtlEnvironmentIterator) Value() Environment {
	if !iter.page.NotDone() {
		return Environment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationDtlEnvironmentIterator type.
func NewResponseWithContinuationDtlEnvironmentIterator(page ResponseWithContinuationDtlEnvironmentPage) ResponseWithContinuationDtlEnvironmentIterator {
	return ResponseWithContinuationDtlEnvironmentIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcDe ResponseWithContinuationDtlEnvironment) IsEmpty() bool {
	return rwcDe.Value == nil || len(*rwcDe.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcDe ResponseWithContinuationDtlEnvironment) hasNextLink() bool {
	return rwcDe.NextLink != nil && len(*rwcDe.NextLink) != 0
}

// responseWithContinuationDtlEnvironmentPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcDe ResponseWithContinuationDtlEnvironment) responseWithContinuationDtlEnvironmentPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcDe.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcDe.NextLink)))
}

// ResponseWithContinuationDtlEnvironmentPage contains a page of Environment values.
type ResponseWithContinuationDtlEnvironmentPage struct {
	fn    func(context.Context, ResponseWithContinuationDtlEnvironment) (ResponseWithContinuationDtlEnvironment, error)
	rwcde ResponseWithContinuationDtlEnvironment
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationDtlEnvironmentPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationDtlEnvironmentPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcde)
		if err != nil {
			return err
		}
		page.rwcde = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationDtlEnvironmentPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationDtlEnvironmentPage) NotDone() bool {
	return !page.rwcde.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationDtlEnvironmentPage) Response() ResponseWithContinuationDtlEnvironment {
	return page.rwcde
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationDtlEnvironmentPage) Values() []Environment {
	if page.rwcde.IsEmpty() {
		return nil
	}
	return *page.rwcde.Value
}

// Creates a new instance of the ResponseWithContinuationDtlEnvironmentPage type.
func NewResponseWithContinuationDtlEnvironmentPage(cur ResponseWithContinuationDtlEnvironment, getNextPage func(context.Context, ResponseWithContinuationDtlEnvironment) (ResponseWithContinuationDtlEnvironment, error)) ResponseWithContinuationDtlEnvironmentPage {
	return ResponseWithContinuationDtlEnvironmentPage{
		fn:    getNextPage,
		rwcde: cur,
	}
}

// ResponseWithContinuationFormula the response of a list operation.
type ResponseWithContinuationFormula struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Formula `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationFormulaIterator provides access to a complete listing of Formula values.
type ResponseWithContinuationFormulaIterator struct {
	i    int
	page ResponseWithContinuationFormulaPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationFormulaIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationFormulaIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationFormulaIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationFormulaIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationFormulaIterator) Response() ResponseWithContinuationFormula {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationFormulaIterator) Value() Formula {
	if !iter.page.NotDone() {
		return Formula{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationFormulaIterator type.
func NewResponseWithContinuationFormulaIterator(page ResponseWithContinuationFormulaPage) ResponseWithContinuationFormulaIterator {
	return ResponseWithContinuationFormulaIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcF ResponseWithContinuationFormula) IsEmpty() bool {
	return rwcF.Value == nil || len(*rwcF.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcF ResponseWithContinuationFormula) hasNextLink() bool {
	return rwcF.NextLink != nil && len(*rwcF.NextLink) != 0
}

// responseWithContinuationFormulaPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcF ResponseWithContinuationFormula) responseWithContinuationFormulaPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcF.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcF.NextLink)))
}

// ResponseWithContinuationFormulaPage contains a page of Formula values.
type ResponseWithContinuationFormulaPage struct {
	fn   func(context.Context, ResponseWithContinuationFormula) (ResponseWithContinuationFormula, error)
	rwcf ResponseWithContinuationFormula
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationFormulaPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationFormulaPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcf)
		if err != nil {
			return err
		}
		page.rwcf = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationFormulaPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationFormulaPage) NotDone() bool {
	return !page.rwcf.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationFormulaPage) Response() ResponseWithContinuationFormula {
	return page.rwcf
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationFormulaPage) Values() []Formula {
	if page.rwcf.IsEmpty() {
		return nil
	}
	return *page.rwcf.Value
}

// Creates a new instance of the ResponseWithContinuationFormulaPage type.
func NewResponseWithContinuationFormulaPage(cur ResponseWithContinuationFormula, getNextPage func(context.Context, ResponseWithContinuationFormula) (ResponseWithContinuationFormula, error)) ResponseWithContinuationFormulaPage {
	return ResponseWithContinuationFormulaPage{
		fn:   getNextPage,
		rwcf: cur,
	}
}

// ResponseWithContinuationGalleryImage the response of a list operation.
type ResponseWithContinuationGalleryImage struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]GalleryImage `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationGalleryImageIterator provides access to a complete listing of GalleryImage
// values.
type ResponseWithContinuationGalleryImageIterator struct {
	i    int
	page ResponseWithContinuationGalleryImagePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationGalleryImageIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationGalleryImageIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationGalleryImageIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationGalleryImageIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationGalleryImageIterator) Response() ResponseWithContinuationGalleryImage {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationGalleryImageIterator) Value() GalleryImage {
	if !iter.page.NotDone() {
		return GalleryImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationGalleryImageIterator type.
func NewResponseWithContinuationGalleryImageIterator(page ResponseWithContinuationGalleryImagePage) ResponseWithContinuationGalleryImageIterator {
	return ResponseWithContinuationGalleryImageIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcGi ResponseWithContinuationGalleryImage) IsEmpty() bool {
	return rwcGi.Value == nil || len(*rwcGi.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcGi ResponseWithContinuationGalleryImage) hasNextLink() bool {
	return rwcGi.NextLink != nil && len(*rwcGi.NextLink) != 0
}

// responseWithContinuationGalleryImagePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcGi ResponseWithContinuationGalleryImage) responseWithContinuationGalleryImagePreparer(ctx context.Context) (*http.Request, error) {
	if !rwcGi.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcGi.NextLink)))
}

// ResponseWithContinuationGalleryImagePage contains a page of GalleryImage values.
type ResponseWithContinuationGalleryImagePage struct {
	fn    func(context.Context, ResponseWithContinuationGalleryImage) (ResponseWithContinuationGalleryImage, error)
	rwcgi ResponseWithContinuationGalleryImage
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationGalleryImagePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationGalleryImagePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcgi)
		if err != nil {
			return err
		}
		page.rwcgi = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationGalleryImagePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationGalleryImagePage) NotDone() bool {
	return !page.rwcgi.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationGalleryImagePage) Response() ResponseWithContinuationGalleryImage {
	return page.rwcgi
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationGalleryImagePage) Values() []GalleryImage {
	if page.rwcgi.IsEmpty() {
		return nil
	}
	return *page.rwcgi.Value
}

// Creates a new instance of the ResponseWithContinuationGalleryImagePage type.
func NewResponseWithContinuationGalleryImagePage(cur ResponseWithContinuationGalleryImage, getNextPage func(context.Context, ResponseWithContinuationGalleryImage) (ResponseWithContinuationGalleryImage, error)) ResponseWithContinuationGalleryImagePage {
	return ResponseWithContinuationGalleryImagePage{
		fn:    getNextPage,
		rwcgi: cur,
	}
}

// ResponseWithContinuationLab the response of a list operation.
type ResponseWithContinuationLab struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Lab `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabIterator provides access to a complete listing of Lab values.
type ResponseWithContinuationLabIterator struct {
	i    int
	page ResponseWithContinuationLabPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationLabIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabIterator) Response() ResponseWithContinuationLab {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabIterator) Value() Lab {
	if !iter.page.NotDone() {
		return Lab{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationLabIterator type.
func NewResponseWithContinuationLabIterator(page ResponseWithContinuationLabPage) ResponseWithContinuationLabIterator {
	return ResponseWithContinuationLabIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcL ResponseWithContinuationLab) IsEmpty() bool {
	return rwcL.Value == nil || len(*rwcL.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcL ResponseWithContinuationLab) hasNextLink() bool {
	return rwcL.NextLink != nil && len(*rwcL.NextLink) != 0
}

// responseWithContinuationLabPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcL ResponseWithContinuationLab) responseWithContinuationLabPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcL.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcL.NextLink)))
}

// ResponseWithContinuationLabPage contains a page of Lab values.
type ResponseWithContinuationLabPage struct {
	fn   func(context.Context, ResponseWithContinuationLab) (ResponseWithContinuationLab, error)
	rwcl ResponseWithContinuationLab
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcl)
		if err != nil {
			return err
		}
		page.rwcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationLabPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabPage) NotDone() bool {
	return !page.rwcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabPage) Response() ResponseWithContinuationLab {
	return page.rwcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabPage) Values() []Lab {
	if page.rwcl.IsEmpty() {
		return nil
	}
	return *page.rwcl.Value
}

// Creates a new instance of the ResponseWithContinuationLabPage type.
func NewResponseWithContinuationLabPage(cur ResponseWithContinuationLab, getNextPage func(context.Context, ResponseWithContinuationLab) (ResponseWithContinuationLab, error)) ResponseWithContinuationLabPage {
	return ResponseWithContinuationLabPage{
		fn:   getNextPage,
		rwcl: cur,
	}
}

// ResponseWithContinuationLabVhd the response of a list operation.
type ResponseWithContinuationLabVhd struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LabVhd `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabVhdIterator provides access to a complete listing of LabVhd values.
type ResponseWithContinuationLabVhdIterator struct {
	i    int
	page ResponseWithContinuationLabVhdPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabVhdIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabVhdIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationLabVhdIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabVhdIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabVhdIterator) Response() ResponseWithContinuationLabVhd {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabVhdIterator) Value() LabVhd {
	if !iter.page.NotDone() {
		return LabVhd{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationLabVhdIterator type.
func NewResponseWithContinuationLabVhdIterator(page ResponseWithContinuationLabVhdPage) ResponseWithContinuationLabVhdIterator {
	return ResponseWithContinuationLabVhdIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcLv ResponseWithContinuationLabVhd) IsEmpty() bool {
	return rwcLv.Value == nil || len(*rwcLv.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcLv ResponseWithContinuationLabVhd) hasNextLink() bool {
	return rwcLv.NextLink != nil && len(*rwcLv.NextLink) != 0
}

// responseWithContinuationLabVhdPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcLv ResponseWithContinuationLabVhd) responseWithContinuationLabVhdPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcLv.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcLv.NextLink)))
}

// ResponseWithContinuationLabVhdPage contains a page of LabVhd values.
type ResponseWithContinuationLabVhdPage struct {
	fn    func(context.Context, ResponseWithContinuationLabVhd) (ResponseWithContinuationLabVhd, error)
	rwclv ResponseWithContinuationLabVhd
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabVhdPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabVhdPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwclv)
		if err != nil {
			return err
		}
		page.rwclv = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationLabVhdPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabVhdPage) NotDone() bool {
	return !page.rwclv.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabVhdPage) Response() ResponseWithContinuationLabVhd {
	return page.rwclv
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabVhdPage) Values() []LabVhd {
	if page.rwclv.IsEmpty() {
		return nil
	}
	return *page.rwclv.Value
}

// Creates a new instance of the ResponseWithContinuationLabVhdPage type.
func NewResponseWithContinuationLabVhdPage(cur ResponseWithContinuationLabVhd, getNextPage func(context.Context, ResponseWithContinuationLabVhd) (ResponseWithContinuationLabVhd, error)) ResponseWithContinuationLabVhdPage {
	return ResponseWithContinuationLabVhdPage{
		fn:    getNextPage,
		rwclv: cur,
	}
}

// ResponseWithContinuationLabVirtualMachine the response of a list operation.
type ResponseWithContinuationLabVirtualMachine struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LabVirtualMachine `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabVirtualMachineIterator provides access to a complete listing of
// LabVirtualMachine values.
type ResponseWithContinuationLabVirtualMachineIterator struct {
	i    int
	page ResponseWithContinuationLabVirtualMachinePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabVirtualMachineIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabVirtualMachineIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationLabVirtualMachineIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabVirtualMachineIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabVirtualMachineIterator) Response() ResponseWithContinuationLabVirtualMachine {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabVirtualMachineIterator) Value() LabVirtualMachine {
	if !iter.page.NotDone() {
		return LabVirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationLabVirtualMachineIterator type.
func NewResponseWithContinuationLabVirtualMachineIterator(page ResponseWithContinuationLabVirtualMachinePage) ResponseWithContinuationLabVirtualMachineIterator {
	return ResponseWithContinuationLabVirtualMachineIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcLvm ResponseWithContinuationLabVirtualMachine) IsEmpty() bool {
	return rwcLvm.Value == nil || len(*rwcLvm.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcLvm ResponseWithContinuationLabVirtualMachine) hasNextLink() bool {
	return rwcLvm.NextLink != nil && len(*rwcLvm.NextLink) != 0
}

// responseWithContinuationLabVirtualMachinePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcLvm ResponseWithContinuationLabVirtualMachine) responseWithContinuationLabVirtualMachinePreparer(ctx context.Context) (*http.Request, error) {
	if !rwcLvm.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcLvm.NextLink)))
}

// ResponseWithContinuationLabVirtualMachinePage contains a page of LabVirtualMachine values.
type ResponseWithContinuationLabVirtualMachinePage struct {
	fn     func(context.Context, ResponseWithContinuationLabVirtualMachine) (ResponseWithContinuationLabVirtualMachine, error)
	rwclvm ResponseWithContinuationLabVirtualMachine
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabVirtualMachinePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabVirtualMachinePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwclvm)
		if err != nil {
			return err
		}
		page.rwclvm = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationLabVirtualMachinePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabVirtualMachinePage) NotDone() bool {
	return !page.rwclvm.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabVirtualMachinePage) Response() ResponseWithContinuationLabVirtualMachine {
	return page.rwclvm
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabVirtualMachinePage) Values() []LabVirtualMachine {
	if page.rwclvm.IsEmpty() {
		return nil
	}
	return *page.rwclvm.Value
}

// Creates a new instance of the ResponseWithContinuationLabVirtualMachinePage type.
func NewResponseWithContinuationLabVirtualMachinePage(cur ResponseWithContinuationLabVirtualMachine, getNextPage func(context.Context, ResponseWithContinuationLabVirtualMachine) (ResponseWithContinuationLabVirtualMachine, error)) ResponseWithContinuationLabVirtualMachinePage {
	return ResponseWithContinuationLabVirtualMachinePage{
		fn:     getNextPage,
		rwclvm: cur,
	}
}

// ResponseWithContinuationNotificationChannel the response of a list operation.
type ResponseWithContinuationNotificationChannel struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]NotificationChannel `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationNotificationChannelIterator provides access to a complete listing of
// NotificationChannel values.
type ResponseWithContinuationNotificationChannelIterator struct {
	i    int
	page ResponseWithContinuationNotificationChannelPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationNotificationChannelIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationNotificationChannelIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationNotificationChannelIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationNotificationChannelIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationNotificationChannelIterator) Response() ResponseWithContinuationNotificationChannel {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationNotificationChannelIterator) Value() NotificationChannel {
	if !iter.page.NotDone() {
		return NotificationChannel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationNotificationChannelIterator type.
func NewResponseWithContinuationNotificationChannelIterator(page ResponseWithContinuationNotificationChannelPage) ResponseWithContinuationNotificationChannelIterator {
	return ResponseWithContinuationNotificationChannelIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcNc ResponseWithContinuationNotificationChannel) IsEmpty() bool {
	return rwcNc.Value == nil || len(*rwcNc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcNc ResponseWithContinuationNotificationChannel) hasNextLink() bool {
	return rwcNc.NextLink != nil && len(*rwcNc.NextLink) != 0
}

// responseWithContinuationNotificationChannelPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcNc ResponseWithContinuationNotificationChannel) responseWithContinuationNotificationChannelPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcNc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcNc.NextLink)))
}

// ResponseWithContinuationNotificationChannelPage contains a page of NotificationChannel values.
type ResponseWithContinuationNotificationChannelPage struct {
	fn    func(context.Context, ResponseWithContinuationNotificationChannel) (ResponseWithContinuationNotificationChannel, error)
	rwcnc ResponseWithContinuationNotificationChannel
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationNotificationChannelPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationNotificationChannelPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcnc)
		if err != nil {
			return err
		}
		page.rwcnc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationNotificationChannelPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationNotificationChannelPage) NotDone() bool {
	return !page.rwcnc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationNotificationChannelPage) Response() ResponseWithContinuationNotificationChannel {
	return page.rwcnc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationNotificationChannelPage) Values() []NotificationChannel {
	if page.rwcnc.IsEmpty() {
		return nil
	}
	return *page.rwcnc.Value
}

// Creates a new instance of the ResponseWithContinuationNotificationChannelPage type.
func NewResponseWithContinuationNotificationChannelPage(cur ResponseWithContinuationNotificationChannel, getNextPage func(context.Context, ResponseWithContinuationNotificationChannel) (ResponseWithContinuationNotificationChannel, error)) ResponseWithContinuationNotificationChannelPage {
	return ResponseWithContinuationNotificationChannelPage{
		fn:    getNextPage,
		rwcnc: cur,
	}
}

// ResponseWithContinuationPolicy the response of a list operation.
type ResponseWithContinuationPolicy struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Policy `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationPolicyIterator provides access to a complete listing of Policy values.
type ResponseWithContinuationPolicyIterator struct {
	i    int
	page ResponseWithContinuationPolicyPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationPolicyIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationPolicyIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationPolicyIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationPolicyIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationPolicyIterator) Response() ResponseWithContinuationPolicy {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationPolicyIterator) Value() Policy {
	if !iter.page.NotDone() {
		return Policy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationPolicyIterator type.
func NewResponseWithContinuationPolicyIterator(page ResponseWithContinuationPolicyPage) ResponseWithContinuationPolicyIterator {
	return ResponseWithContinuationPolicyIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcP ResponseWithContinuationPolicy) IsEmpty() bool {
	return rwcP.Value == nil || len(*rwcP.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcP ResponseWithContinuationPolicy) hasNextLink() bool {
	return rwcP.NextLink != nil && len(*rwcP.NextLink) != 0
}

// responseWithContinuationPolicyPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcP ResponseWithContinuationPolicy) responseWithContinuationPolicyPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcP.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcP.NextLink)))
}

// ResponseWithContinuationPolicyPage contains a page of Policy values.
type ResponseWithContinuationPolicyPage struct {
	fn   func(context.Context, ResponseWithContinuationPolicy) (ResponseWithContinuationPolicy, error)
	rwcp ResponseWithContinuationPolicy
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationPolicyPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationPolicyPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcp)
		if err != nil {
			return err
		}
		page.rwcp = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationPolicyPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationPolicyPage) NotDone() bool {
	return !page.rwcp.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationPolicyPage) Response() ResponseWithContinuationPolicy {
	return page.rwcp
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationPolicyPage) Values() []Policy {
	if page.rwcp.IsEmpty() {
		return nil
	}
	return *page.rwcp.Value
}

// Creates a new instance of the ResponseWithContinuationPolicyPage type.
func NewResponseWithContinuationPolicyPage(cur ResponseWithContinuationPolicy, getNextPage func(context.Context, ResponseWithContinuationPolicy) (ResponseWithContinuationPolicy, error)) ResponseWithContinuationPolicyPage {
	return ResponseWithContinuationPolicyPage{
		fn:   getNextPage,
		rwcp: cur,
	}
}

// ResponseWithContinuationSchedule the response of a list operation.
type ResponseWithContinuationSchedule struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Schedule `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationScheduleIterator provides access to a complete listing of Schedule values.
type ResponseWithContinuationScheduleIterator struct {
	i    int
	page ResponseWithContinuationSchedulePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationScheduleIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationScheduleIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationScheduleIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationScheduleIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationScheduleIterator) Response() ResponseWithContinuationSchedule {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationScheduleIterator) Value() Schedule {
	if !iter.page.NotDone() {
		return Schedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationScheduleIterator type.
func NewResponseWithContinuationScheduleIterator(page ResponseWithContinuationSchedulePage) ResponseWithContinuationScheduleIterator {
	return ResponseWithContinuationScheduleIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcS ResponseWithContinuationSchedule) IsEmpty() bool {
	return rwcS.Value == nil || len(*rwcS.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcS ResponseWithContinuationSchedule) hasNextLink() bool {
	return rwcS.NextLink != nil && len(*rwcS.NextLink) != 0
}

// responseWithContinuationSchedulePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcS ResponseWithContinuationSchedule) responseWithContinuationSchedulePreparer(ctx context.Context) (*http.Request, error) {
	if !rwcS.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcS.NextLink)))
}

// ResponseWithContinuationSchedulePage contains a page of Schedule values.
type ResponseWithContinuationSchedulePage struct {
	fn   func(context.Context, ResponseWithContinuationSchedule) (ResponseWithContinuationSchedule, error)
	rwcs ResponseWithContinuationSchedule
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationSchedulePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationSchedulePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcs)
		if err != nil {
			return err
		}
		page.rwcs = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationSchedulePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationSchedulePage) NotDone() bool {
	return !page.rwcs.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationSchedulePage) Response() ResponseWithContinuationSchedule {
	return page.rwcs
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationSchedulePage) Values() []Schedule {
	if page.rwcs.IsEmpty() {
		return nil
	}
	return *page.rwcs.Value
}

// Creates a new instance of the ResponseWithContinuationSchedulePage type.
func NewResponseWithContinuationSchedulePage(cur ResponseWithContinuationSchedule, getNextPage func(context.Context, ResponseWithContinuationSchedule) (ResponseWithContinuationSchedule, error)) ResponseWithContinuationSchedulePage {
	return ResponseWithContinuationSchedulePage{
		fn:   getNextPage,
		rwcs: cur,
	}
}

// ResponseWithContinuationSecret the response of a list operation.
type ResponseWithContinuationSecret struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Secret `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationSecretIterator provides access to a complete listing of Secret values.
type ResponseWithContinuationSecretIterator struct {
	i    int
	page ResponseWithContinuationSecretPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationSecretIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationSecretIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationSecretIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationSecretIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationSecretIterator) Response() ResponseWithContinuationSecret {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationSecretIterator) Value() Secret {
	if !iter.page.NotDone() {
		return Secret{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationSecretIterator type.
func NewResponseWithContinuationSecretIterator(page ResponseWithContinuationSecretPage) ResponseWithContinuationSecretIterator {
	return ResponseWithContinuationSecretIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcS ResponseWithContinuationSecret) IsEmpty() bool {
	return rwcS.Value == nil || len(*rwcS.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcS ResponseWithContinuationSecret) hasNextLink() bool {
	return rwcS.NextLink != nil && len(*rwcS.NextLink) != 0
}

// responseWithContinuationSecretPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcS ResponseWithContinuationSecret) responseWithContinuationSecretPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcS.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcS.NextLink)))
}

// ResponseWithContinuationSecretPage contains a page of Secret values.
type ResponseWithContinuationSecretPage struct {
	fn   func(context.Context, ResponseWithContinuationSecret) (ResponseWithContinuationSecret, error)
	rwcs ResponseWithContinuationSecret
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationSecretPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationSecretPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcs)
		if err != nil {
			return err
		}
		page.rwcs = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationSecretPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationSecretPage) NotDone() bool {
	return !page.rwcs.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationSecretPage) Response() ResponseWithContinuationSecret {
	return page.rwcs
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationSecretPage) Values() []Secret {
	if page.rwcs.IsEmpty() {
		return nil
	}
	return *page.rwcs.Value
}

// Creates a new instance of the ResponseWithContinuationSecretPage type.
func NewResponseWithContinuationSecretPage(cur ResponseWithContinuationSecret, getNextPage func(context.Context, ResponseWithContinuationSecret) (ResponseWithContinuationSecret, error)) ResponseWithContinuationSecretPage {
	return ResponseWithContinuationSecretPage{
		fn:   getNextPage,
		rwcs: cur,
	}
}

// ResponseWithContinuationServiceRunner the response of a list operation.
type ResponseWithContinuationServiceRunner struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ServiceRunner `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationServiceRunnerIterator provides access to a complete listing of ServiceRunner
// values.
type ResponseWithContinuationServiceRunnerIterator struct {
	i    int
	page ResponseWithContinuationServiceRunnerPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationServiceRunnerIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationServiceRunnerIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationServiceRunnerIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationServiceRunnerIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationServiceRunnerIterator) Response() ResponseWithContinuationServiceRunner {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationServiceRunnerIterator) Value() ServiceRunner {
	if !iter.page.NotDone() {
		return ServiceRunner{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationServiceRunnerIterator type.
func NewResponseWithContinuationServiceRunnerIterator(page ResponseWithContinuationServiceRunnerPage) ResponseWithContinuationServiceRunnerIterator {
	return ResponseWithContinuationServiceRunnerIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcSr ResponseWithContinuationServiceRunner) IsEmpty() bool {
	return rwcSr.Value == nil || len(*rwcSr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcSr ResponseWithContinuationServiceRunner) hasNextLink() bool {
	return rwcSr.NextLink != nil && len(*rwcSr.NextLink) != 0
}

// responseWithContinuationServiceRunnerPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcSr ResponseWithContinuationServiceRunner) responseWithContinuationServiceRunnerPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcSr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcSr.NextLink)))
}

// ResponseWithContinuationServiceRunnerPage contains a page of ServiceRunner values.
type ResponseWithContinuationServiceRunnerPage struct {
	fn    func(context.Context, ResponseWithContinuationServiceRunner) (ResponseWithContinuationServiceRunner, error)
	rwcsr ResponseWithContinuationServiceRunner
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationServiceRunnerPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationServiceRunnerPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcsr)
		if err != nil {
			return err
		}
		page.rwcsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationServiceRunnerPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationServiceRunnerPage) NotDone() bool {
	return !page.rwcsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationServiceRunnerPage) Response() ResponseWithContinuationServiceRunner {
	return page.rwcsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationServiceRunnerPage) Values() []ServiceRunner {
	if page.rwcsr.IsEmpty() {
		return nil
	}
	return *page.rwcsr.Value
}

// Creates a new instance of the ResponseWithContinuationServiceRunnerPage type.
func NewResponseWithContinuationServiceRunnerPage(cur ResponseWithContinuationServiceRunner, getNextPage func(context.Context, ResponseWithContinuationServiceRunner) (ResponseWithContinuationServiceRunner, error)) ResponseWithContinuationServiceRunnerPage {
	return ResponseWithContinuationServiceRunnerPage{
		fn:    getNextPage,
		rwcsr: cur,
	}
}

// ResponseWithContinuationUser the response of a list operation.
type ResponseWithContinuationUser struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]User `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationUserIterator provides access to a complete listing of User values.
type ResponseWithContinuationUserIterator struct {
	i    int
	page ResponseWithContinuationUserPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationUserIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationUserIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationUserIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationUserIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationUserIterator) Response() ResponseWithContinuationUser {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationUserIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationUserIterator type.
func NewResponseWithContinuationUserIterator(page ResponseWithContinuationUserPage) ResponseWithContinuationUserIterator {
	return ResponseWithContinuationUserIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcU ResponseWithContinuationUser) IsEmpty() bool {
	return rwcU.Value == nil || len(*rwcU.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcU ResponseWithContinuationUser) hasNextLink() bool {
	return rwcU.NextLink != nil && len(*rwcU.NextLink) != 0
}

// responseWithContinuationUserPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcU ResponseWithContinuationUser) responseWithContinuationUserPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcU.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcU.NextLink)))
}

// ResponseWithContinuationUserPage contains a page of User values.
type ResponseWithContinuationUserPage struct {
	fn   func(context.Context, ResponseWithContinuationUser) (ResponseWithContinuationUser, error)
	rwcu ResponseWithContinuationUser
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationUserPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationUserPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcu)
		if err != nil {
			return err
		}
		page.rwcu = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationUserPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationUserPage) NotDone() bool {
	return !page.rwcu.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationUserPage) Response() ResponseWithContinuationUser {
	return page.rwcu
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationUserPage) Values() []User {
	if page.rwcu.IsEmpty() {
		return nil
	}
	return *page.rwcu.Value
}

// Creates a new instance of the ResponseWithContinuationUserPage type.
func NewResponseWithContinuationUserPage(cur ResponseWithContinuationUser, getNextPage func(context.Context, ResponseWithContinuationUser) (ResponseWithContinuationUser, error)) ResponseWithContinuationUserPage {
	return ResponseWithContinuationUserPage{
		fn:   getNextPage,
		rwcu: cur,
	}
}

// ResponseWithContinuationVirtualNetwork the response of a list operation.
type ResponseWithContinuationVirtualNetwork struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]VirtualNetwork `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationVirtualNetworkIterator provides access to a complete listing of VirtualNetwork
// values.
type ResponseWithContinuationVirtualNetworkIterator struct {
	i    int
	page ResponseWithContinuationVirtualNetworkPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationVirtualNetworkIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationVirtualNetworkIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationVirtualNetworkIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationVirtualNetworkIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationVirtualNetworkIterator) Response() ResponseWithContinuationVirtualNetwork {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationVirtualNetworkIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationVirtualNetworkIterator type.
func NewResponseWithContinuationVirtualNetworkIterator(page ResponseWithContinuationVirtualNetworkPage) ResponseWithContinuationVirtualNetworkIterator {
	return ResponseWithContinuationVirtualNetworkIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcVn ResponseWithContinuationVirtualNetwork) IsEmpty() bool {
	return rwcVn.Value == nil || len(*rwcVn.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcVn ResponseWithContinuationVirtualNetwork) hasNextLink() bool {
	return rwcVn.NextLink != nil && len(*rwcVn.NextLink) != 0
}

// responseWithContinuationVirtualNetworkPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcVn ResponseWithContinuationVirtualNetwork) responseWithContinuationVirtualNetworkPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcVn.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcVn.NextLink)))
}

// ResponseWithContinuationVirtualNetworkPage contains a page of VirtualNetwork values.
type ResponseWithContinuationVirtualNetworkPage struct {
	fn    func(context.Context, ResponseWithContinuationVirtualNetwork) (ResponseWithContinuationVirtualNetwork, error)
	rwcvn ResponseWithContinuationVirtualNetwork
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationVirtualNetworkPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationVirtualNetworkPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcvn)
		if err != nil {
			return err
		}
		page.rwcvn = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationVirtualNetworkPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationVirtualNetworkPage) NotDone() bool {
	return !page.rwcvn.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationVirtualNetworkPage) Response() ResponseWithContinuationVirtualNetwork {
	return page.rwcvn
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationVirtualNetworkPage) Values() []VirtualNetwork {
	if page.rwcvn.IsEmpty() {
		return nil
	}
	return *page.rwcvn.Value
}

// Creates a new instance of the ResponseWithContinuationVirtualNetworkPage type.
func NewResponseWithContinuationVirtualNetworkPage(cur ResponseWithContinuationVirtualNetwork, getNextPage func(context.Context, ResponseWithContinuationVirtualNetwork) (ResponseWithContinuationVirtualNetwork, error)) ResponseWithContinuationVirtualNetworkPage {
	return ResponseWithContinuationVirtualNetworkPage{
		fn:    getNextPage,
		rwcvn: cur,
	}
}

// RetargetScheduleProperties properties for retargeting a virtual machine schedule.
type RetargetScheduleProperties struct {
	// CurrentResourceID - The resource Id of the virtual machine on which the schedule operates
	CurrentResourceID *string `json:"currentResourceId,omitempty"`
	// TargetResourceID - The resource Id of the virtual machine that the schedule should be retargeted to
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// Schedule a schedule.
type Schedule struct {
	autorest.Response `json:"-"`
	// ScheduleProperties - The properties of the resource.
	*ScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ScheduleProperties != nil {
		objectMap["properties"] = s.ScheduleProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Schedule struct.
func (s *Schedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleProperties ScheduleProperties
				err = json.Unmarshal(*v, &scheduleProperties)
				if err != nil {
					return err
				}
				s.ScheduleProperties = &scheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleFragment a schedule.
type ScheduleFragment struct {
	// SchedulePropertiesFragment - The properties of the resource.
	*SchedulePropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ScheduleFragment.
func (sf ScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sf.SchedulePropertiesFragment != nil {
		objectMap["properties"] = sf.SchedulePropertiesFragment
	}
	if sf.Location != nil {
		objectMap["location"] = sf.Location
	}
	if sf.Tags != nil {
		objectMap["tags"] = sf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScheduleFragment struct.
func (sf *ScheduleFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var schedulePropertiesFragment SchedulePropertiesFragment
				err = json.Unmarshal(*v, &schedulePropertiesFragment)
				if err != nil {
					return err
				}
				sf.SchedulePropertiesFragment = &schedulePropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sf.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleProperties properties of a schedule.
type ScheduleProperties struct {
	// Status - The status of the schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TaskType - The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`
	// WeeklyRecurrence - If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetails `json:"weeklyRecurrence,omitempty"`
	// DailyRecurrence - If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetails `json:"dailyRecurrence,omitempty"`
	// HourlyRecurrence - If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetails `json:"hourlyRecurrence,omitempty"`
	// TimeZoneID - The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// NotificationSettings - Notification settings.
	NotificationSettings *NotificationSettings `json:"notificationSettings,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the schedule.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// TargetResourceID - The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleProperties.
func (sp ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Status != "" {
		objectMap["status"] = sp.Status
	}
	if sp.TaskType != nil {
		objectMap["taskType"] = sp.TaskType
	}
	if sp.WeeklyRecurrence != nil {
		objectMap["weeklyRecurrence"] = sp.WeeklyRecurrence
	}
	if sp.DailyRecurrence != nil {
		objectMap["dailyRecurrence"] = sp.DailyRecurrence
	}
	if sp.HourlyRecurrence != nil {
		objectMap["hourlyRecurrence"] = sp.HourlyRecurrence
	}
	if sp.TimeZoneID != nil {
		objectMap["timeZoneId"] = sp.TimeZoneID
	}
	if sp.NotificationSettings != nil {
		objectMap["notificationSettings"] = sp.NotificationSettings
	}
	if sp.TargetResourceID != nil {
		objectMap["targetResourceId"] = sp.TargetResourceID
	}
	if sp.ProvisioningState != nil {
		objectMap["provisioningState"] = sp.ProvisioningState
	}
	if sp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = sp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// SchedulePropertiesFragment properties of a schedule.
type SchedulePropertiesFragment struct {
	// Status - The status of the schedule (i.e. Enabled, Disabled). Possible values include: 'EnableStatusEnabled', 'EnableStatusDisabled'
	Status EnableStatus `json:"status,omitempty"`
	// TaskType - The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`
	// WeeklyRecurrence - If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetailsFragment `json:"weeklyRecurrence,omitempty"`
	// DailyRecurrence - If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetailsFragment `json:"dailyRecurrence,omitempty"`
	// HourlyRecurrence - If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetailsFragment `json:"hourlyRecurrence,omitempty"`
	// TimeZoneID - The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// NotificationSettings - Notification settings.
	NotificationSettings *NotificationSettingsFragment `json:"notificationSettings,omitempty"`
	// TargetResourceID - The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// SchedulesExecuteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SchedulesExecuteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SchedulesExecuteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SchedulesExecuteFuture.Result.
func (future *SchedulesExecuteFuture) result(client SchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.SchedulesExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.SchedulesExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Secret a secret.
type Secret struct {
	autorest.Response `json:"-"`
	// SecretProperties - The properties of the resource.
	*SecretProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SecretProperties != nil {
		objectMap["properties"] = s.SecretProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Secret struct.
func (s *Secret) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secretProperties SecretProperties
				err = json.Unmarshal(*v, &secretProperties)
				if err != nil {
					return err
				}
				s.SecretProperties = &secretProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// SecretProperties properties of a secret.
type SecretProperties struct {
	// Value - The value of the secret for secret creation.
	Value *string `json:"value,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// ServiceRunner a container for a managed identity to execute DevTest lab services.
type ServiceRunner struct {
	autorest.Response `json:"-"`
	// Identity - The identity of the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceRunner.
func (sr ServiceRunner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Identity != nil {
		objectMap["identity"] = sr.Identity
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	return json.Marshal(objectMap)
}

// SharedPublicIPAddressConfiguration properties of a virtual machine that determine how it is connected to
// a load balancer.
type SharedPublicIPAddressConfiguration struct {
	// InboundNatRules - The incoming NAT rules
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
}

// SharedPublicIPAddressConfigurationFragment properties of a virtual machine that determine how it is
// connected to a load balancer.
type SharedPublicIPAddressConfigurationFragment struct {
	// InboundNatRules - The incoming NAT rules
	InboundNatRules *[]InboundNatRuleFragment `json:"inboundNatRules,omitempty"`
}

// ShutdownNotificationContent the contents of a shutdown notification. Webhooks can use this type to
// deserialize the request body when they get notified of an imminent shutdown.
type ShutdownNotificationContent struct {
	// SkipURL - The URL to skip auto-shutdown.
	SkipURL *string `json:"skipUrl,omitempty"`
	// DelayURL60 - The URL to delay shutdown by 60 minutes.
	DelayURL60 *string `json:"delayUrl60,omitempty"`
	// DelayURL120 - The URL to delay shutdown by 2 hours.
	DelayURL120 *string `json:"delayUrl120,omitempty"`
	// VMName - The virtual machine to be shut down.
	VMName *string `json:"vmName,omitempty"`
	// GUID - The GUID for the virtual machine to be shut down.
	GUID *string `json:"guid,omitempty"`
	// Owner - The owner of the virtual machine.
	Owner *string `json:"owner,omitempty"`
	// EventType - The event for which a notification will be sent.
	EventType *string `json:"eventType,omitempty"`
	// Text - The text for the notification.
	Text *string `json:"text,omitempty"`
	// SubscriptionID - The subscription ID for the schedule.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroupName - The resource group name for the schedule.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// LabName - The lab for the schedule.
	LabName *string `json:"labName,omitempty"`
}

// Subnet subnet information.
type Subnet struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name of the subnet as seen in the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// AllowPublicIP - The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)). Possible values include: 'Default', 'Deny', 'Allow'
	AllowPublicIP UsagePermissionType `json:"allowPublicIp,omitempty"`
}

// SubnetFragment subnet information.
type SubnetFragment struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name of the subnet as seen in the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// AllowPublicIP - The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)). Possible values include: 'Default', 'Deny', 'Allow'
	AllowPublicIP UsagePermissionType `json:"allowPublicIp,omitempty"`
}

// SubnetOverride property overrides on a subnet of a virtual network.
type SubnetOverride struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name given to the subnet within the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// UseInVMCreationPermission - Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UseInVMCreationPermission UsagePermissionType `json:"useInVmCreationPermission,omitempty"`
	// UsePublicIPAddressPermission - Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UsePublicIPAddressPermission UsagePermissionType `json:"usePublicIpAddressPermission,omitempty"`
	// SharedPublicIPAddressConfiguration - Properties that virtual machines on this subnet will share.
	SharedPublicIPAddressConfiguration *SubnetSharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`
	// VirtualNetworkPoolName - The virtual network pool associated with this subnet.
	VirtualNetworkPoolName *string `json:"virtualNetworkPoolName,omitempty"`
}

// SubnetOverrideFragment property overrides on a subnet of a virtual network.
type SubnetOverrideFragment struct {
	// ResourceID - The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name given to the subnet within the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// UseInVMCreationPermission - Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UseInVMCreationPermission UsagePermissionType `json:"useInVmCreationPermission,omitempty"`
	// UsePublicIPAddressPermission - Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny). Possible values include: 'Default', 'Deny', 'Allow'
	UsePublicIPAddressPermission UsagePermissionType `json:"usePublicIpAddressPermission,omitempty"`
	// SharedPublicIPAddressConfiguration - Properties that virtual machines on this subnet will share.
	SharedPublicIPAddressConfiguration *SubnetSharedPublicIPAddressConfigurationFragment `json:"sharedPublicIpAddressConfiguration,omitempty"`
	// VirtualNetworkPoolName - The virtual network pool associated with this subnet.
	VirtualNetworkPoolName *string `json:"virtualNetworkPoolName,omitempty"`
}

// SubnetSharedPublicIPAddressConfiguration configuration for public IP address sharing.
type SubnetSharedPublicIPAddressConfiguration struct {
	// AllowedPorts - Backend ports that virtual machines on this subnet are allowed to expose
	AllowedPorts *[]Port `json:"allowedPorts,omitempty"`
}

// SubnetSharedPublicIPAddressConfigurationFragment configuration for public IP address sharing.
type SubnetSharedPublicIPAddressConfigurationFragment struct {
	// AllowedPorts - Backend ports that virtual machines on this subnet are allowed to expose
	AllowedPorts *[]PortFragment `json:"allowedPorts,omitempty"`
}

// TargetCostProperties properties of a cost target.
type TargetCostProperties struct {
	// Status - Target cost status. Possible values include: 'TargetCostStatusEnabled', 'TargetCostStatusDisabled'
	Status TargetCostStatus `json:"status,omitempty"`
	// Target - Lab target cost
	Target *int32 `json:"target,omitempty"`
	// CostThresholds - Cost thresholds.
	CostThresholds *[]CostThresholdProperties `json:"costThresholds,omitempty"`
	// CycleStartDateTime - Reporting cycle start date.
	CycleStartDateTime *date.Time `json:"cycleStartDateTime,omitempty"`
	// CycleEndDateTime - Reporting cycle end date.
	CycleEndDateTime *date.Time `json:"cycleEndDateTime,omitempty"`
	// CycleType - Reporting cycle type. Possible values include: 'CalendarMonth', 'Custom'
	CycleType ReportingCycleType `json:"cycleType,omitempty"`
}

// User profile of a lab user.
type User struct {
	autorest.Response `json:"-"`
	// UserProperties - The properties of the resource.
	*UserProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	if u.Location != nil {
		objectMap["location"] = u.Location
	}
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				u.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				u.Tags = tags
			}
		}
	}

	return nil
}

// UserFragment profile of a lab user.
type UserFragment struct {
	// UserPropertiesFragment - The properties of the resource.
	*UserPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UserFragment.
func (uf UserFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uf.UserPropertiesFragment != nil {
		objectMap["properties"] = uf.UserPropertiesFragment
	}
	if uf.Location != nil {
		objectMap["location"] = uf.Location
	}
	if uf.Tags != nil {
		objectMap["tags"] = uf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserFragment struct.
func (uf *UserFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userPropertiesFragment UserPropertiesFragment
				err = json.Unmarshal(*v, &userPropertiesFragment)
				if err != nil {
					return err
				}
				uf.UserPropertiesFragment = &userPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				uf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				uf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				uf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				uf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				uf.Tags = tags
			}
		}
	}

	return nil
}

// UserIdentity identity attributes of a lab user.
type UserIdentity struct {
	// PrincipalName - Set to the principal name / UPN of the client JWT making the request.
	PrincipalName *string `json:"principalName,omitempty"`
	// PrincipalID - Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - Set to the tenant ID of the client JWT making the request.
	TenantID *string `json:"tenantId,omitempty"`
	// ObjectID - Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
	ObjectID *string `json:"objectId,omitempty"`
	// AppID - Set to the app Id of the client JWT making the request.
	AppID *string `json:"appId,omitempty"`
}

// UserIdentityFragment identity attributes of a lab user.
type UserIdentityFragment struct {
	// PrincipalName - Set to the principal name / UPN of the client JWT making the request.
	PrincipalName *string `json:"principalName,omitempty"`
	// PrincipalID - Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - Set to the tenant ID of the client JWT making the request.
	TenantID *string `json:"tenantId,omitempty"`
	// ObjectID - Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
	ObjectID *string `json:"objectId,omitempty"`
	// AppID - Set to the app Id of the client JWT making the request.
	AppID *string `json:"appId,omitempty"`
}

// UserProperties properties of a lab user profile.
type UserProperties struct {
	// Identity - The identity of the user.
	Identity *UserIdentity `json:"identity,omitempty"`
	// SecretStore - The secret store of the user.
	SecretStore *UserSecretStore `json:"secretStore,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the user profile.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for UserProperties.
func (up UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.Identity != nil {
		objectMap["identity"] = up.Identity
	}
	if up.SecretStore != nil {
		objectMap["secretStore"] = up.SecretStore
	}
	if up.ProvisioningState != nil {
		objectMap["provisioningState"] = up.ProvisioningState
	}
	if up.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = up.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// UserPropertiesFragment properties of a lab user profile.
type UserPropertiesFragment struct {
	// Identity - The identity of the user.
	Identity *UserIdentityFragment `json:"identity,omitempty"`
	// SecretStore - The secret store of the user.
	SecretStore *UserSecretStoreFragment `json:"secretStore,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// UsersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersDeleteFuture.Result.
func (future *UsersDeleteFuture) result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.UsersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.UsersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UserSecretStore properties of a user's secret store.
type UserSecretStore struct {
	// KeyVaultURI - The URI of the user's Key vault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// KeyVaultID - The ID of the user's Key vault.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// UserSecretStoreFragment properties of a user's secret store.
type UserSecretStoreFragment struct {
	// KeyVaultURI - The URI of the user's Key vault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// KeyVaultID - The ID of the user's Key vault.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// VirtualMachinesAddDataDiskFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesAddDataDiskFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesAddDataDiskFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesAddDataDiskFuture.Result.
func (future *VirtualMachinesAddDataDiskFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesAddDataDiskFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesAddDataDiskFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesApplyArtifactsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesApplyArtifactsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesApplyArtifactsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesApplyArtifactsFuture.Result.
func (future *VirtualMachinesApplyArtifactsFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesApplyArtifactsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesApplyArtifactsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineSchedulesExecuteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineSchedulesExecuteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineSchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineSchedulesExecuteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineSchedulesExecuteFuture.Result.
func (future *VirtualMachineSchedulesExecuteFuture) result(client VirtualMachineSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachineSchedulesExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachineSchedulesExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesClaimFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesClaimFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesClaimFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesClaimFuture.Result.
func (future *VirtualMachinesClaimFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesClaimFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesClaimFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (LabVirtualMachine, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesCreateOrUpdateFuture.Result.
func (future *VirtualMachinesCreateOrUpdateFuture) result(client VirtualMachinesClient) (lvm LabVirtualMachine, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		lvm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lvm.Response.Response, err = future.GetResult(sender); err == nil && lvm.Response.Response.StatusCode != http.StatusNoContent {
		lvm, err = client.CreateOrUpdateResponder(lvm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesCreateOrUpdateFuture", "Result", lvm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachinesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesDeleteFuture.Result.
func (future *VirtualMachinesDeleteFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesDetachDataDiskFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachinesDetachDataDiskFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesDetachDataDiskFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesDetachDataDiskFuture.Result.
func (future *VirtualMachinesDetachDataDiskFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesDetachDataDiskFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesDetachDataDiskFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesStartFuture.Result.
func (future *VirtualMachinesStartFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachinesStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachinesStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachinesStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachinesStopFuture.Result.
func (future *VirtualMachinesStopFuture) result(client VirtualMachinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachinesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachinesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetwork a virtual network.
type VirtualNetwork struct {
	autorest.Response `json:"-"`
	// VirtualNetworkProperties - The properties of the resource.
	*VirtualNetworkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkProperties != nil {
		objectMap["properties"] = vn.VirtualNetworkProperties
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkProperties VirtualNetworkProperties
				err = json.Unmarshal(*v, &virtualNetworkProperties)
				if err != nil {
					return err
				}
				vn.VirtualNetworkProperties = &virtualNetworkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkFragment a virtual network.
type VirtualNetworkFragment struct {
	// VirtualNetworkPropertiesFragment - The properties of the resource.
	*VirtualNetworkPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkFragment.
func (vnf VirtualNetworkFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnf.VirtualNetworkPropertiesFragment != nil {
		objectMap["properties"] = vnf.VirtualNetworkPropertiesFragment
	}
	if vnf.Location != nil {
		objectMap["location"] = vnf.Location
	}
	if vnf.Tags != nil {
		objectMap["tags"] = vnf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkFragment struct.
func (vnf *VirtualNetworkFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPropertiesFragment VirtualNetworkPropertiesFragment
				err = json.Unmarshal(*v, &virtualNetworkPropertiesFragment)
				if err != nil {
					return err
				}
				vnf.VirtualNetworkPropertiesFragment = &virtualNetworkPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vnf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vnf.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkProperties properties of a virtual network.
type VirtualNetworkProperties struct {
	// AllowedSubnets - The allowed subnets of the virtual network.
	AllowedSubnets *[]Subnet `json:"allowedSubnets,omitempty"`
	// Description - The description of the virtual network.
	Description *string `json:"description,omitempty"`
	// ExternalProviderResourceID - The Microsoft.Network resource identifier of the virtual network.
	ExternalProviderResourceID *string `json:"externalProviderResourceId,omitempty"`
	// ExternalSubnets - The external subnet properties.
	ExternalSubnets *[]ExternalSubnet `json:"externalSubnets,omitempty"`
	// SubnetOverrides - The subnet overrides of the virtual network.
	SubnetOverrides *[]SubnetOverride `json:"subnetOverrides,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the virtual network.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkProperties.
func (vnp VirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnp.AllowedSubnets != nil {
		objectMap["allowedSubnets"] = vnp.AllowedSubnets
	}
	if vnp.Description != nil {
		objectMap["description"] = vnp.Description
	}
	if vnp.ExternalProviderResourceID != nil {
		objectMap["externalProviderResourceId"] = vnp.ExternalProviderResourceID
	}
	if vnp.ExternalSubnets != nil {
		objectMap["externalSubnets"] = vnp.ExternalSubnets
	}
	if vnp.SubnetOverrides != nil {
		objectMap["subnetOverrides"] = vnp.SubnetOverrides
	}
	if vnp.ProvisioningState != nil {
		objectMap["provisioningState"] = vnp.ProvisioningState
	}
	if vnp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = vnp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkPropertiesFragment properties of a virtual network.
type VirtualNetworkPropertiesFragment struct {
	// AllowedSubnets - The allowed subnets of the virtual network.
	AllowedSubnets *[]SubnetFragment `json:"allowedSubnets,omitempty"`
	// Description - The description of the virtual network.
	Description *string `json:"description,omitempty"`
	// ExternalProviderResourceID - The Microsoft.Network resource identifier of the virtual network.
	ExternalProviderResourceID *string `json:"externalProviderResourceId,omitempty"`
	// ExternalSubnets - The external subnet properties.
	ExternalSubnets *[]ExternalSubnetFragment `json:"externalSubnets,omitempty"`
	// SubnetOverrides - The subnet overrides of the virtual network.
	SubnetOverrides *[]SubnetOverrideFragment `json:"subnetOverrides,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// VirtualNetworksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworksClient) (VirtualNetwork, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualNetworksCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualNetworksCreateOrUpdateFuture.Result.
func (future *VirtualNetworksCreateOrUpdateFuture) result(client VirtualNetworksClient) (vn VirtualNetwork, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualNetworksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vn.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualNetworksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vn.Response.Response, err = future.GetResult(sender); err == nil && vn.Response.Response.StatusCode != http.StatusNoContent {
		vn, err = client.CreateOrUpdateResponder(vn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.VirtualNetworksCreateOrUpdateFuture", "Result", vn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualNetworksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualNetworksDeleteFuture.Result.
func (future *VirtualNetworksDeleteFuture) result(client VirtualNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualNetworksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualNetworksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WeekDetails properties of a weekly schedule.
type WeekDetails struct {
	// Weekdays - The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
	Weekdays *[]string `json:"weekdays,omitempty"`
	// Time - The time of the day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// WeekDetailsFragment properties of a weekly schedule.
type WeekDetailsFragment struct {
	// Weekdays - The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
	Weekdays *[]string `json:"weekdays,omitempty"`
	// Time - The time of the day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// WindowsOsInfo information about a Windows OS.
type WindowsOsInfo struct {
	// WindowsOsState - The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied). Possible values include: 'NonSysprepped', 'SysprepRequested', 'SysprepApplied'
	WindowsOsState WindowsOsState `json:"windowsOsState,omitempty"`
}
