---
channel: release
version: 2.7
date: 2011-09-27
---

## New Features



### Application
- Jalview Desktop News Reader
- Tweaked default layout of web services menu
- View/alignment association menu to enable user to easily specify which alignment a multi-structure view takes its colours/correspondences from
- Allow properties file location to be specified as URL
- Extend Jalview project to preserve associations between many alignment views and a single Jmol display
- Store annotation row height in Jalview project file
- Annotation row column label formatting attributes stored in project file
- Annotation row order for auto-calculated annotation rows preserved in Jalview project file
- Visual progress indication when Jalview state is saved using Desktop window menu
- Visual indication that command line arguments are still being processed
- Groovy script execution from URL
- Colour by annotation default min and max colours in preferences
- Automatically associate PDB files dragged onto an alignment with sequences that have high similarity and matching IDs
- Update JGoogleAnalytics to latest release (0.3)
- 'view structures' option to open many structures in same window
- Sort associated views menu option for tree panel
- Group all JABA and non-JABA services for a particular analysis function in its own submenu


### Applet
- Userdefined and autogenerated annotation rows for groups
- Adjustment of alignment annotation pane height
- Annotation scrollbar for annotation panel
- Drag to reorder annotation rows in annotation panel
- 'automaticScrolling' parameter
- Allow sequences with partial ID string matches to be annotated from GFF/Jalview features files
- Sequence logo annotation row in applet
- Absolute paths relative to host server in applet parameters are treated as such
- New in the JalviewLite javascript API:
  - JalviewLite.js javascript library
  - Javascript callbacks for
    - Applet initialisation
    - Sequence/alignment mouse-overs and selections
  - scrollTo row and column alignment scrolling functions
  - Select sequence/alignment regions from javascript
  - javascript structure viewer harness to pass messages between Jmol and Jalview when running as distinct applets
  - sortBy method
  - Set of applet and application examples shipped with documentation
  - New example to demonstrate JalviewLite and Jmol javascript message exchange


### General
- Enable Jmol displays to be associated with multiple multiple alignments
- Option to automatically sort alignment with new tree
- User configurable link to enable redirects to a www.Jalview.org mirror
- Jmol colours option for Jmol displays
- Configurable newline string when writing alignment and other flat files
- Allow alignment annotation description lines to contain html tags


### Documentation and Development
- Add groovy test harness for bulk load testing to examples
- Groovy script to load and align a set of sequences using a web service before displaying the result in the Jalview desktop
- Restructured javascript and applet api documentation
- Ant target to publish example html files with applet archive
- Netbeans project for building Jalview from source
- ant task to create online javadoc for Jalview source


## Issues Resolved



### Application
- User defined colourscheme throws exception when current built in colourscheme is saved as new scheme
- AlignFrame->Save in application pops up save dialog for valid filename/format
- Cannot view associated structure for UniProt sequence
- PDB file association breaks for UniProt sequence P37173
- Associate PDB from file dialog does not tell you which sequence is to be associated with the file
- Find All raises null pointer exception when query only matches sequence IDs
- Pre 2.6 Jalview project cannot be loaded into v2.6
- Jalview project with Jmol views created with Jalview 2.4 cannot be loaded
- Filetype associations not installed for webstart launch
- Two or more chains in a single PDB file associated with sequences in different alignments do not get coloured by their associated sequence
- Visibility status of autocalculated annotation row not preserved when project is loaded
- Annotation row height and visibility attributes not stored in Jalview project
- Tree bootstraps are not preserved when saved as a Jalview project
- Envision2 workflow tooltips are corrupted
- Enabling show group conservation also enables colour by conservation
- Duplicate group associated conservation or consensus created on new view
- Annotation scrollbar not displayed after 'show all hidden annotation rows' option selected
- Alignment quality not updated after alignment annotation row is hidden then shown
- Preserve colouring of structures coloured by sequences in pre Jalview 2.7 projects
- Web service job parameter dialog is not laid out properly
- Web services menu not refreshed after 'reset services' button is pressed in preferences
- Annotation off by one in Jalview v2_3 example project
- Structures imported from file and saved in project get name like jalview_pdb1234.txt when reloaded
- Jalview does not always retrieve progress of a JABAWS job execution in full once it is complete


### Applet
- Alignment height set incorrectly when lots of annotation rows are displayed
- Relative URLs in feature HTML text not resolved to codebase
- View follows highlighting does not work for positions in sequences
- <= shown as = in tooltip
- Export features raises exception when no features exist
- Separator string used for serialising lists of IDs for javascript api is modified when separator string provided as parameter
- Null pointer exception when selecting tree leaves for alignment with no existing selection
- Relative URLs for datasources assumed to be relative to applet's codebase
- Status bar not updated after finished searching and search wraps around to first result
- StructureSelectionManager instance shared between several Jalview applets causes race conditions and memory leaks
- Hover tooltip and mouseover of position on structure not sent from Jmol in applet
- Certain sequences of javascript method calls to applet API fatally hang browser


### General
- View follows structure mouseover scrolls beyond position with wrapped view and hidden regions
- Find sequence position moves to wrong residue with/without hidden columns
- Sequence length given in alignment properties window is off by 1
- InvalidNumberFormat exceptions thrown when trying to import PDB like structure files
- Positional search results are only highlighted between user-supplied sequence start/end bounds
- End attribute of sequence is not validated
- Find dialog only finds first sequence containing a given sequence position
- Sequence numbering not preserved in MSF alignment output
- Jalview PDB file reader does not extract sequence from nucleotide chains correctly
- Structure colours not updated when tree partition changed in alignment
- Sequence associated secondary structure not correctly parsed in interleaved stockholm
- Colour by annotation dialog does not restore current state
- Hiding (nearly) all sequences doesn't work properly
- Sequences containing lowercase letters are not properly associated with their pdb files


### Documentation and Development
- schemas/JalviewWsParamSet.xsd corrupted by ApplyCopyright tool
