/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandEnd: public LWCommandSegment {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	(void) argc;
	(void) args;
	
	g_return_val_if_reached (NULL);
}

const gchar *getName ()
{
	return "end";
}	

gchar *getHint ()
{
	return _("Close logical block");
}

gboolean matchPrevCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL)
		throw new LWMessage (LW_ERROR_UnmatchedBrace);		
	
	if (g_ascii_strcasecmp (cmd->getName(), "begin"))
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	match();
	
	return TRUE;
}

gboolean canBeSkiped ()
{
	return isAlreadyMatched();
}

};

LWSymbol *new_LWCommandEnd()
{
	return new LWCommandEnd();
}
