; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the memcpy library call simplifier works correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128"

declare ptr @memcpy(ptr, ptr, i32)

; Check memcpy(mem1, mem2, size) -> llvm.memcpy(mem1, mem2, size, 1).

define ptr @test_simplify1(ptr %mem1, ptr %mem2, i32 %size) {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[MEM1:%.*]], ptr align 1 [[MEM2:%.*]], i32 [[SIZE:%.*]], i1 false)
; CHECK-NEXT:    ret ptr [[MEM1]]
;
  %ret = call ptr @memcpy(ptr %mem1, ptr %mem2, i32 %size)
  ret ptr %ret
}

; Verify that the strictfp attr doesn't block this optimization.

define ptr @test_simplify2(ptr %mem1, ptr %mem2, i32 %size) strictfp {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[MEM1:%.*]], ptr align 1 [[MEM2:%.*]], i32 [[SIZE:%.*]], i1 false) #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    ret ptr [[MEM1]]
;
  %ret = call ptr @memcpy(ptr %mem1, ptr %mem2, i32 %size) strictfp
  ret ptr %ret
}

; Verify that the first parameter to memcpy could itself be a call that's not
; tail, while the call to @memcpy could be tail.
declare ptr @get_dest()

define ptr @test_simplify3(ptr %mem2, i32 %size) {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    [[DEST:%.*]] = call ptr @get_dest()
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[DEST]], ptr align 1 [[MEM2:%.*]], i32 [[SIZE:%.*]], i1 false)
; CHECK-NEXT:    ret ptr [[DEST]]
;

  %dest = call ptr @get_dest()
  %ret = tail call ptr @memcpy(ptr %dest, ptr %mem2, i32 %size)
  ret ptr %ret
}

define ptr @test_no_incompatible_attr(ptr %mem1, ptr %mem2, i32 %size) {
; CHECK-LABEL: @test_no_incompatible_attr(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[MEM1:%.*]], ptr align 1 [[MEM2:%.*]], i32 [[SIZE:%.*]], i1 false)
; CHECK-NEXT:    ret ptr [[MEM1]]
;

  %ret = call dereferenceable(1) ptr @memcpy(ptr %mem1, ptr %mem2, i32 %size)
  ret ptr %ret
}

define ptr @test_no_simplify1(ptr %mem1, ptr %mem2, i32 %size) {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[RET:%.*]] = musttail call ptr @memcpy(ptr [[MEM1:%.*]], ptr [[MEM2:%.*]], i32 [[SIZE:%.*]])
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = musttail call ptr @memcpy(ptr %mem1, ptr %mem2, i32 %size)
  ret ptr %ret
}
