Poly1305 provides the following mathematical guarantee:
if legitimate users authenticate M messages under M secret Poly1305 keys
chosen independently and uniformly at random,
and attackers attempt F forgeries,
and each message has at most B bytes where B is a multiple of 16,
then all forgeries will be rejected
with probability at most FB/2^107^.
The amount of computation carried out by attackers is irrelevant:
all that matters is the number of forgery attempts and the message length.

Poly1305 is a "one-time" authenticator:
the guarantee does not apply if a key is reused for multiple messages.
(The original Poly1305 paper actually explains a stronger guarantee that allows partial key reuse,
but the stronger guarantee is overkill for typical applications.)

Poly1305 is typically combined with the ChaCha20 cipher,
which generates Poly1305 keys for any number of messages
from an initial 32-byte key.
The attacker's chance of breaking the ChaCha20-Poly1305 combination
is at most ε+FB/2^107^,
where ε is the attacker's chance of breaking ChaCha20.
A brute-force attack hoping for 2^100^ guesses to collide with one of 2^50^ legitimate ChaCha20 keys,
something currently at the edge of feasibility for a large-scale attacker,
would achieve ε only around 1/2^106^.
There is no mathematical guarantee ruling out better ChaCha20 attacks;
confidence in the security of ChaCha20 instead comes from how well ChaCha20 has resisted
[dozens of attack papers](https://cr.yp.to/snuffle.html).

lib1305 is intended to become a central target for verification of full functional correctness of implementations of Poly1305.
However, this verification is only a future plan at the moment,
so at this point the code (like the Poly1305 code in most other libraries)
should be presumed to have critical bugs.

The lib1305 API is a low-level API,
and in particular does not protect against callers failing to call `poly1305_verify`
or failing to properly handle nonzero return values from `poly1305_verify`.

lib1305 is designed to avoid all data flow from secret data to memory addresses and branch conditions.
lib1305 uses operations that naturally avoid such data flow,
and includes valgrind tests (based on TIMECOP from SUPERCOP) designed to catch any such data flow introduced by compilers.
Fully protecting the user against timing attacks requires addressing more issues, such as the following:

* Other CPU instructions can take variable time.
  For example, there are some CPUs, especially embedded CPUs,
  where integer multiplication takes variable time.

* Many CPUs include dynamic frequency-selection mechanisms
  such as
  [Turbo Boost](https://blog.cr.yp.to/20230609-turboboost.html),
  exposing power information via timing information.
  Fortunately,
  these CPUs are normally shipped with simple options
  to disable Turbo Boost etc., closing this leak;
  unfortunately,
  Turbo Boost is enabled by default on CPUs that support it.

* Cryptographic keys are normally handled by cryptographic software, but
  other user secrets are handled by many different pieces of software.

See [https://timing.attacks.cr.yp.to](https://timing.attacks.cr.yp.to)
for a timing-attack survey and many references.

Speculative-execution attacks:
Some countermeasures against speculative-execution attacks are planned
but are not included in the current version of lib1305.
Full protection again requires addressing issues at other system layers.

Further side-channel attacks:
Even if all legitimate user sensors are successfully kept isolated from attackers,
attackers can set up their own
power sensors, electromagnetic sensors, acoustic sensors, etc.
Keeping cryptographic operations physically separated from sensors
tends to make such attacks much more expensive but is often infeasible.
"Masking" cryptographic computations
seems to help and can be affordable,
although the security of masking is difficult to evaluate
and there are many broken masked implementations.
Currently lib1305 does not include any masked implementations,
so presumably it is easily breakable by power attacks
in environments where attackers can see power consumption.

Further attacks:
In general, lib1305 should be presumed breakable by fault attacks.
