
# ${PROJECT_MAJOR_VERSION}.${PROJECT_MINOR_VERSION}.${PROJECT_PATCH_VERSION}

set (CPACK_GENERATOR                    "TGZ;TZ")
set (CPACK_SET_DESTDIR                  ON)

set (CPACK_RESOURCE_FILE_LICENSE       "${CMAKE_CURRENT_SOURCE_DIR}/LICENSE")
set (CPACK_PACKAGE_DESCRIPTION_SUMMARY "Embedded Libevent based HTTP API")
set (CPACK_PACKAGE_DESCRIPTION
"Very fast HTTP server API, developed as a very flexible and replacement
for Libevent's evhttp API. Create a multi-threaded, SSL aware, secure,
HTTP server using only a minimal amount of code.")

set (CPACK_PACKAGE_NAME                "libevhtp")
set (CPACK_PACKAGE_CONTACT             "nate@cl0d.com")
set (CPACK_PACKAGE_VERSION_MAJOR       ${PROJECT_MAJOR_VERSION})
set (CPACK_PACKAGE_VERSION_MINOR       ${PROJECT_MINOR_VERSION})
set (CPACK_PACKAGE_VERSION_PATCH       ${PROJECT_PATCH_VERSION})

if(X86)
  set (CPACK_DEBIAN_PACKAGE_ARCHITECTURE "i386")
  set (CPACK_RPM_PACKAGE_ARCHITECTURE    "i686")
elseif(X86_64)
  set (CPACK_DEBIAN_PACKAGE_ARCHITECTURE "amd64")
  set (CPACK_RPM_PACKAGE_ARCHITECTURE    "x86_64")
elseif(ARM)
  set (CPACK_DEBIAN_PACKAGE_ARCHITECTURE "armhf")
  set (CPACK_RPM_PACKAGE_ARCHITECTURE    "armhf")
elseif(AARCH64)
  set (CPACK_DEBIAN_PACKAGE_ARCHITECTURE "arm64")
  set (CPACK_RPM_PACKAGE_ARCHITECTURE    "aarch64")
elseif(PPC64LE)
  set (CPACK_DEBIAN_PACKAGE_ARCHITECTURE "ppc64el")
  set (CPACK_RPM_PACKAGE_ARCHITECTURE    "ppc64le")
else()
  set (CPACK_DEBIAN_PACKAGE_ARCHITECTURE ${CMAKE_SYSTEM_PROCESSOR})
  set (CPACK_RPM_PACKAGE_ARCHITECTURE    ${CMAKE_SYSTEM_PROCESSOR})
endif()

if(CPACK_GENERATOR STREQUAL "DEB")
  set (LIBEVHTP_PACKAGE_ARCH_SUFFIX ${CPACK_DEBIAN_PACKAGE_ARCHITECTURE})
elseif (CPACK_GENERATOR STREQUAL "RPM")
  set (LIBEVHTP_PACKAGE_ARCH_SUFFIX ${CPACK_RPM_PACKAGE_ARCHITECTURE})
else()
  set (LIBEVHTP_PACKAGE_ARCH_SUFFIX ${CMAKE_SYSTEM_PROCESSOR})
endif()

set(CPACK_PACKAGE_FILE_NAME        "${CMAKE_PROJECT_NAME}-${PROJECT_VERSION}-${LIBEVHTP_PACKAGE_ARCH_SUFFIX}")
set(CPACK_SOURCE_PACKAGE_FILE_NAME "${CMAKE_PROJECT_NAME}-${PROJECT_VERSION}-${LIBEVHTP_PACKAGE_ARCH_SUFFIX}")

# RPM STUFF
set(CPACK_RPM_COMPONENT_INSTALL   TRUE)
set(CPACK_RPM_PACKAGE_SUMMARY     ${CPACK_PACKAGE_DESCRIPTION_SUMMARY})
set(CPACK_RPM_PACKAGE_DESCRIPTION ${CPACK_PACKAGE_DESCRIPTION})
set(CPACK_RPM_PACKAGE_URL         "http://github.com/criticalstack/libevhtp")
set(CPACK_RPM_PACKAGE_LICENSE     "BSD")

# DEB STUFF
set(CPACK_DEB_COMPONENT_INSTALL   TRUE)
set(CPACK_DEBIAN_PACKAGE_PRIORITY "optional")
set(CPACK_DEBIAN_PACKAGE_SECTION  "universe/libdevel")
set(CPACK_DEBIAN_PACKAGE_HOMEPAGE "http://github.com/criticalstack/libevhtp")

include (CPack)
