package de.intarsys.tools.format;

import java.text.SimpleDateFormat;
import java.util.Date;

public class ISO8601Format {

	private final SimpleDateFormat formater;

	private static final ISO8601Format Instance = new ISO8601Format();

	public static final ISO8601Format getInstance() {
		return Instance;
	}

	protected ISO8601Format() {
		formater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"); //$NON-NLS-1$
	}

	public String format(Date date) {
		String partial = formater.format(date);
		partial = partial.replaceAll("\\+0000$", "Z"); //$NON-NLS-1$//$NON-NLS-2$
		partial = partial.replaceAll("(\\d\\d)$", ":$1"); //$NON-NLS-1$//$NON-NLS-2$
		return partial;
	}
}
