
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GraphArrowAttributes.h
    \\brief Definition of GraphArrow Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "GraphArrowWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



GraphArrowWrapper::GraphArrowWrapper(): grapharrow_(new GraphArrow())


{


	
	GraphWrapper::object(grapharrow_);
	

}
GraphArrowWrapper::GraphArrowWrapper(GraphArrow* grapharrow): grapharrow_(grapharrow)
{

	
	GraphWrapper::object(grapharrow_);
	
}

GraphArrowWrapper::~GraphArrowWrapper()
{

}

void GraphArrowWrapper::set(const MagRequest& request)
{

	

	GraphWrapper::set(request);
	

	if  (request.countValues("GRAPH_ARROW_UNIT_VELOCITY") ) {
		double unit_velocity_value = request("GRAPH_ARROW_UNIT_VELOCITY");
		grapharrow_->unit_velocity_ = unit_velocity_value;
		}
	
	if  (request.countValues("GRAPH_ARROW_COLOUR") ) {
		string colour_value = request("GRAPH_ARROW_COLOUR");
		grapharrow_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
}

void GraphArrowWrapper::print(ostream& out)  const
{
	out << "GraphArrowWrapper[]";
}



