/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.allocator;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public class ReusableRecordsAllocator
implements DynamicRecordAllocator {
    private final int recordSize;
    private final Iterator<DynamicRecord> recordIterator;

    public ReusableRecordsAllocator(int recordSize, DynamicRecord ... records) {
        this.recordSize = recordSize;
        this.recordIterator = Iterators.iterator((Object[])records);
    }

    public ReusableRecordsAllocator(int recordSize, Collection<DynamicRecord> records) {
        this.recordSize = recordSize;
        this.recordIterator = records.iterator();
    }

    public ReusableRecordsAllocator(int recordSize, Iterator<DynamicRecord> recordsIterator) {
        this.recordSize = recordSize;
        this.recordIterator = recordsIterator;
    }

    @Override
    public int getRecordDataSize() {
        return this.recordSize;
    }

    @Override
    public DynamicRecord nextRecord(CursorContext cursorContext) {
        DynamicRecord record = this.recordIterator.next();
        if (!record.inUse()) {
            record.setCreated();
        }
        record.setInUse(true);
        return record;
    }

    public boolean hasNext() {
        return this.recordIterator.hasNext();
    }
}

