/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Determine the minimum ndarray data type of the closest "kind" necessary for storing a provided scalar value.
*
* @module @stdlib/ndarray/min-dtype
*
* @example
* var minDataType = require( '@stdlib/ndarray/min-dtype' );
*
* var dt = minDataType( 3.141592653589793 );
* // returns 'float32'
*
* dt = minDataType( 3 );
* // returns 'uint8'
*/

// MODULES //

var minDataType = require( './main.js' );


// EXPORTS //

module.exports = minDataType;
