/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Observable;
import java.util.Observer;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Event;
import org.chefproject.core.UsageSession;
import org.chefproject.core.User;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericEventTrackingService;

public abstract class BaseEventTrackingService
extends TurbineBaseService
implements GenericEventTrackingService {
    protected MyObservable m_observableHelper = new MyObservable();
    protected MyObservable m_priorityObservableHelper = new MyObservable();
    protected MyObservable m_localObservableHelper = new MyObservable();

    protected abstract void postEvent(Event var1);

    protected void notifyObservers(Event event, boolean local) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + " Notification - Event: " + event);
        }
        this.m_priorityObservableHelper.setChanged();
        this.m_priorityObservableHelper.notifyObservers(event);
        this.m_observableHelper.setChanged();
        this.m_observableHelper.notifyObservers(event);
        if (local) {
            this.m_localObservableHelper.setChanged();
            this.m_localObservableHelper.notifyObservers(event);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public Event newEvent(String event, String resource, boolean modify) {
        return new BaseEvent(event, resource, modify);
    }

    public void post(Event event) {
        UsageSession session = UsageSessionService.getSession();
        if (session != null) {
            this.post(event, session);
        } else {
            User user = UsageSessionService.getSessionUser();
            this.post(event, user);
        }
    }

    public void post(Event event, UsageSession session) {
        String id = "?";
        if (session != null) {
            id = session.getId();
        }
        ((BaseEvent)event).setSessionId(id);
        this.postEvent(event);
    }

    public void post(Event event, User user) {
        String id = "?";
        if (user != null) {
            id = user.getId();
        }
        ((BaseEvent)event).setUserId(id);
        this.postEvent(event);
    }

    public void addObserver(Observer observer) {
        this.m_priorityObservableHelper.deleteObserver(observer);
        this.m_localObservableHelper.deleteObserver(observer);
        this.m_observableHelper.addObserver(observer);
    }

    public void addPriorityObserver(Observer observer) {
        this.m_observableHelper.deleteObserver(observer);
        this.m_localObservableHelper.deleteObserver(observer);
        this.m_priorityObservableHelper.addObserver(observer);
    }

    public void addLocalObserver(Observer observer) {
        this.m_observableHelper.deleteObserver(observer);
        this.m_priorityObservableHelper.deleteObserver(observer);
        this.m_localObservableHelper.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.m_observableHelper.deleteObserver(observer);
        this.m_priorityObservableHelper.deleteObserver(observer);
        this.m_localObservableHelper.deleteObserver(observer);
    }

    protected class BaseEvent
    implements Event {
        protected long m_seq = 0L;
        protected String m_id = "";
        protected String m_resource = "";
        protected String m_session = null;
        protected String m_user = null;
        protected boolean m_modify = false;

        public String getEvent() {
            return this.m_id;
        }

        public String getResource() {
            return this.m_resource;
        }

        public String getSessionId() {
            return this.m_session;
        }

        public String getUserId() {
            return this.m_user;
        }

        public boolean getModify() {
            return this.m_modify;
        }

        public BaseEvent(String event, String resource, boolean modify) {
            this.setEvent(event);
            this.setResource(resource);
            this.m_modify = modify;
        }

        public BaseEvent(long seq, String event, String resource, boolean modify) {
            this(event, resource, modify);
            this.m_seq = seq;
        }

        protected void setEvent(String id) {
            this.m_id = id != null ? id : "";
        }

        protected void setResource(String id) {
            this.m_resource = id != null ? id : "";
        }

        protected void setSessionId(String id) {
            this.m_session = id != null && id.length() > 0 ? id : null;
        }

        protected void setUserId(String id) {
            this.m_user = id != null && id.length() > 0 ? id : null;
        }

        public String toString() {
            return this.m_seq + ":" + this.getEvent() + "@" + this.getResource();
        }
    }

    protected class MyObservable
    extends Observable {
        protected MyObservable() {
        }

        public void setChanged() {
            super.setChanged();
        }
    }
}

