/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ork.Logger;
import ork.ServerResult;

public class SysAccountEnumerator {
    private Connection m_oConn;
    private ServerResult m_oRes;
    private String m_sSID;
    private Logger m_oLogger = null;

    public SysAccountEnumerator() {
    }

    public SysAccountEnumerator(Connection oConn, String sSID, ServerResult oRes, Logger oLog) {
        this.m_oConn = oConn;
        this.m_oRes = oRes;
        this.m_sSID = sSID;
        this.m_oLogger = oLog;
    }

    public void setConnection(Connection oConn) {
        this.m_oConn = oConn;
    }

    public void setServerResult(ServerResult oRes) {
        this.m_oRes = oRes;
    }

    public void setLogger(Logger oLogger) {
        this.m_oLogger = oLogger;
    }

    public void setSID(String sSID) {
        this.m_sSID = sSID;
    }

    public boolean enumerateSysAccounts() {
        String sSQL = "SELECT username FROM all_users";
        Statement oStmt = null;
        ResultSet oRS = null;
        boolean bRet = false;
        int nAccounts = 0;
        this.m_oLogger.log("[-] Enumerating system accounts for SID (" + this.m_sSID + ")");
        try {
            oStmt = this.m_oConn.createStatement();
            oRS = oStmt.executeQuery(sSQL);
            while (oRS != null && oRS.next()) {
                String sUsername = oRS.getString("username");
                this.m_oLogger.debug("[-] Adding account " + sUsername);
                this.m_oRes.addAccount(this.m_sSID, sUsername, null, null, -1);
                ++nAccounts;
                bRet = true;
            }
            if (oRS != null) {
                oRS.close();
            } else {
                this.m_oLogger.log("[x] Enumerating system accounts failed");
            }
            if (oStmt != null) {
                oStmt.close();
            }
        }
        catch (SQLException e) {
            this.m_oLogger.log("[x] Enumerating system accounts failed");
            System.err.println(e.getMessage());
        }
        this.m_oLogger.log("[-] Succesfully enumerated " + nAccounts + " accounts");
        return bRet;
    }
}

