/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import oracle.net.ano.Ano;
import oracle.net.aso.C02;
import oracle.net.aso.C10;
import oracle.net.ns.DataPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class CryptoDataPacket
extends DataPacket
implements SQLnetDef {
    private C10 b = null;
    private Ano c = null;
    private int d = 0;
    private int e = 0;
    private C02 f = null;

    public void receive() throws IOException, NetException {
        super.receive();
        if (this.type != 6) {
            return;
        }
        this.c = this.sAtts.ano;
        if (this.c.encryptionAlg != null) {
            this.f = this.c.encryptionAlg;
            this.d += this.f.b();
            if (this.c.getRenewKey()) {
                this.f.a(null, null);
            }
        }
        if (this.c.dataIntegrityAlg != null) {
            this.b = this.c.dataIntegrityAlg;
            this.d += this.b.size();
            if (this.c.getRenewKey()) {
                this.b.renew();
            }
        }
        ++this.d;
        this.c.setRenewKey(false);
        this.decryptAndChecksum();
    }

    public CryptoDataPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.c = sessionAtts.ano;
        if (sessionAtts.ano.encryptionAlg != null) {
            this.f = sessionAtts.ano.encryptionAlg;
            this.d += this.f.b();
        }
        if (sessionAtts.ano.dataIntegrityAlg != null) {
            this.b = sessionAtts.ano.dataIntegrityAlg;
            this.d += this.b.size();
        }
        ++this.d;
    }

    protected void send(int n) throws IOException {
        if (this.e < 2) {
            this.a();
        }
        this.checksumAndEncrypt();
        super.send(n);
    }

    protected void decryptAndChecksum() throws IOException {
        byte[] byArray = new byte[this.dataLen - 1];
        byte by = this.buffer[this.length - 1];
        --this.dataLen;
        System.arraycopy(this.buffer, this.dataOff, byArray, 0, this.dataLen);
        byte[] byArray2 = this.f != null ? this.f.e(byArray) : byArray;
        if (byArray2 == null) {
            throw new IOException("Bad buffer - Fail to decrypt buffer");
        }
        this.dataLen = byArray2.length;
        if (this.b != null) {
            byte[] byArray3 = new byte[this.b.size()];
            this.dataLen -= this.b.size();
            System.arraycopy(byArray2, this.dataLen, byArray3, 0, this.b.size());
            byte[] byArray4 = new byte[this.dataLen];
            System.arraycopy(byArray2, 0, byArray4, 0, this.dataLen);
            if (this.b.compare(byArray4, byArray3)) {
                throw new IOException("Checksum fail");
            }
            System.arraycopy(byArray4, 0, this.buffer, this.dataOff, this.dataLen);
        } else {
            System.arraycopy(byArray2, 0, this.buffer, this.dataOff, this.dataLen);
        }
        this.length = this.dataOff + this.dataLen;
        this.pktOffset = 10;
    }

    protected void checksumAndEncrypt() throws IOException {
        int n = this.availableBytesToSend + this.dataOff;
        byte[] byArray = new byte[this.availableBytesToSend];
        System.arraycopy(this.buffer, this.dataOff, byArray, 0, byArray.length);
        byte[] byArray2 = null;
        this.dataLen = this.availableBytesToSend;
        if (this.b != null && (byArray2 = this.b.compute(byArray, byArray.length)) != null) {
            this.dataLen += byArray2.length;
        }
        byte[] byArray3 = new byte[this.dataLen];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        }
        if (this.f != null) {
            byte[] byArray4 = this.f.d(byArray3);
            if (byArray4 == null) {
                throw new IOException("Fail to encrypt buffer");
            }
            this.dataLen = byArray4.length;
            System.arraycopy(byArray4, 0, this.buffer, this.dataOff, this.dataLen);
        } else if (this.b != null) {
            System.arraycopy(byArray3, 0, this.buffer, this.dataOff, this.dataLen);
        }
        this.buffer[this.dataOff + this.dataLen] = (byte)(this.e >= 2 ? 1 : 0);
        ++this.dataLen;
        this.pktOffset = 10 + this.dataLen;
        this.length = 10 + this.dataLen;
    }

    private void a() throws IOException {
        byte[] byArray = this.c.getSessionKey();
        byte[] byArray2 = this.c.getO3logSessionKey();
        if (byArray2 != null) {
            byte[] byArray3 = new byte[Math.max(byArray2.length, byArray.length)];
            byte[] byArray4 = byArray2.length > byArray.length ? byArray2 : byArray;
            System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
            if (byArray2.length < 8 || byArray.length < 8) {
                throw new IOException("Key is too small");
            }
            int n = 0;
            while (n < 8) {
                byArray3[n] = (byte)((byArray2[n] ^ byArray[n]) & 0xFF);
                ++n;
            }
            byte[] byArray5 = this.c.getInitializationVector();
            if (this.f != null) {
                this.f.a(byArray3, byArray5);
            }
            if (this.b != null) {
                this.b.takeSessionKey(byArray3, byArray5);
            }
            this.e = 3;
        }
    }

    protected int putDataInBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(this.buffer.length - this.d - this.pktOffset, n2);
        if (n3 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.pktOffset, n3);
            this.pktOffset += n3;
            this.isBufferFull = this.pktOffset + this.d == this.buffer.length;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return n3;
    }
}

