# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AadAuthenticationParameters(_serialization.Model):
    """AAD Vpn authentication type related parameters.

    :ivar aad_tenant: AAD Vpn authentication parameter AAD tenant.
    :vartype aad_tenant: str
    :ivar aad_audience: AAD Vpn authentication parameter AAD audience.
    :vartype aad_audience: str
    :ivar aad_issuer: AAD Vpn authentication parameter AAD issuer.
    :vartype aad_issuer: str
    """

    _attribute_map = {
        "aad_tenant": {"key": "aadTenant", "type": "str"},
        "aad_audience": {"key": "aadAudience", "type": "str"},
        "aad_issuer": {"key": "aadIssuer", "type": "str"},
    }

    def __init__(
        self,
        *,
        aad_tenant: Optional[str] = None,
        aad_audience: Optional[str] = None,
        aad_issuer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword aad_tenant: AAD Vpn authentication parameter AAD tenant.
        :paramtype aad_tenant: str
        :keyword aad_audience: AAD Vpn authentication parameter AAD audience.
        :paramtype aad_audience: str
        :keyword aad_issuer: AAD Vpn authentication parameter AAD issuer.
        :paramtype aad_issuer: str
        """
        super().__init__(**kwargs)
        self.aad_tenant = aad_tenant
        self.aad_audience = aad_audience
        self.aad_issuer = aad_issuer


class Action(_serialization.Model):
    """Action to be taken on a route matching a RouteMap criterion.

    :ivar type: Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and
     'Drop.'. Known values are: "Unknown", "Remove", "Add", "Replace", and "Drop".
    :vartype type: str or ~azure.mgmt.network.models.RouteMapActionType
    :ivar parameters: List of parameters relevant to the action.For instance if type is drop then
     parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN
     numbers to be added.
    :vartype parameters: list[~azure.mgmt.network.models.Parameter]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "parameters": {"key": "parameters", "type": "[Parameter]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RouteMapActionType"]] = None,
        parameters: Optional[list["_models.Parameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and
         'Drop.'. Known values are: "Unknown", "Remove", "Add", "Replace", and "Drop".
        :paramtype type: str or ~azure.mgmt.network.models.RouteMapActionType
        :keyword parameters: List of parameters relevant to the action.For instance if type is drop
         then parameters has list of prefixes to be dropped.If type is add, parameters would have list
         of ASN numbers to be added.
        :paramtype parameters: list[~azure.mgmt.network.models.Parameter]
        """
        super().__init__(**kwargs)
        self.type = type
        self.parameters = parameters


class ActiveBaseSecurityAdminRule(_serialization.Model):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActiveSecurityAdminRule, ActiveDefaultSecurityAdminRule

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.EffectiveAdminRuleKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Custom": "ActiveSecurityAdminRule", "Default": "ActiveDefaultSecurityAdminRule"}}

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[list["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        """
        super().__init__(**kwargs)
        self.id = id
        self.commit_time = commit_time
        self.region = region
        self.configuration_description = configuration_description
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind: Optional[str] = None


class ActiveConfigurationParameter(_serialization.Model):
    """Effective Virtual Networks Parameter.

    :ivar regions: List of regions.
    :vartype regions: list[str]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "regions": {"key": "regions", "type": "[str]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(self, *, regions: Optional[list[str]] = None, skip_token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword regions: List of regions.
        :paramtype regions: list[str]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.regions = regions
        self.skip_token = skip_token


class EffectiveConnectivityConfiguration(_serialization.Model):
    """The network manager effective connectivity configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Connectivity configuration ID.
    :vartype id: str
    :ivar configuration_groups: Effective configuration groups.
    :vartype configuration_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar description: A description of the connectivity configuration.
    :vartype description: str
    :ivar connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
     "Mesh".
    :vartype connectivity_topology: str or ~azure.mgmt.network.models.ConnectivityTopology
    :ivar hubs: List of hubItems.
    :vartype hubs: list[~azure.mgmt.network.models.Hub]
    :ivar is_global: Flag if global mesh is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.models.IsGlobal
    :ivar connectivity_capabilities: Collection of additional settings to enhance specific topology
     behaviors of the connectivity configuration resource.
    :vartype connectivity_capabilities:
     ~azure.mgmt.network.models.ConnectivityConfigurationPropertiesConnectivityCapabilities
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups: list[~azure.mgmt.network.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar delete_existing_peering: Flag if need to remove current existing peerings. Known values
     are: "False" and "True".
    :vartype delete_existing_peering: str or ~azure.mgmt.network.models.DeleteExistingPeering
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_groups": {"key": "configurationGroups", "type": "[ConfigurationGroup]"},
        "description": {"key": "properties.description", "type": "str"},
        "connectivity_topology": {"key": "properties.connectivityTopology", "type": "str"},
        "hubs": {"key": "properties.hubs", "type": "[Hub]"},
        "is_global": {"key": "properties.isGlobal", "type": "str"},
        "connectivity_capabilities": {
            "key": "properties.connectivityCapabilities",
            "type": "ConnectivityConfigurationPropertiesConnectivityCapabilities",
        },
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[ConnectivityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "delete_existing_peering": {"key": "properties.deleteExistingPeering", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "_models.ConnectivityTopology"]] = None,
        hubs: Optional[list["_models.Hub"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        connectivity_capabilities: Optional[
            "_models.ConnectivityConfigurationPropertiesConnectivityCapabilities"
        ] = None,
        applies_to_groups: Optional[list["_models.ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "_models.DeleteExistingPeering"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Connectivity configuration ID.
        :paramtype id: str
        :keyword configuration_groups: Effective configuration groups.
        :paramtype configuration_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        :keyword description: A description of the connectivity configuration.
        :paramtype description: str
        :keyword connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
         "Mesh".
        :paramtype connectivity_topology: str or ~azure.mgmt.network.models.ConnectivityTopology
        :keyword hubs: List of hubItems.
        :paramtype hubs: list[~azure.mgmt.network.models.Hub]
        :keyword is_global: Flag if global mesh is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.models.IsGlobal
        :keyword connectivity_capabilities: Collection of additional settings to enhance specific
         topology behaviors of the connectivity configuration resource.
        :paramtype connectivity_capabilities:
         ~azure.mgmt.network.models.ConnectivityConfigurationPropertiesConnectivityCapabilities
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups: list[~azure.mgmt.network.models.ConnectivityGroupItem]
        :keyword delete_existing_peering: Flag if need to remove current existing peerings. Known
         values are: "False" and "True".
        :paramtype delete_existing_peering: str or ~azure.mgmt.network.models.DeleteExistingPeering
        """
        super().__init__(**kwargs)
        self.id = id
        self.configuration_groups = configuration_groups
        self.description = description
        self.connectivity_topology = connectivity_topology
        self.hubs = hubs
        self.is_global = is_global
        self.connectivity_capabilities = connectivity_capabilities
        self.applies_to_groups = applies_to_groups
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.delete_existing_peering = delete_existing_peering
        self.resource_guid: Optional[str] = None


class ActiveConnectivityConfiguration(EffectiveConnectivityConfiguration):
    """Active connectivity configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Connectivity configuration ID.
    :vartype id: str
    :ivar configuration_groups: Effective configuration groups.
    :vartype configuration_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar description: A description of the connectivity configuration.
    :vartype description: str
    :ivar connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
     "Mesh".
    :vartype connectivity_topology: str or ~azure.mgmt.network.models.ConnectivityTopology
    :ivar hubs: List of hubItems.
    :vartype hubs: list[~azure.mgmt.network.models.Hub]
    :ivar is_global: Flag if global mesh is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.models.IsGlobal
    :ivar connectivity_capabilities: Collection of additional settings to enhance specific topology
     behaviors of the connectivity configuration resource.
    :vartype connectivity_capabilities:
     ~azure.mgmt.network.models.ConnectivityConfigurationPropertiesConnectivityCapabilities
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups: list[~azure.mgmt.network.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar delete_existing_peering: Flag if need to remove current existing peerings. Known values
     are: "False" and "True".
    :vartype delete_existing_peering: str or ~azure.mgmt.network.models.DeleteExistingPeering
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_groups": {"key": "configurationGroups", "type": "[ConfigurationGroup]"},
        "description": {"key": "properties.description", "type": "str"},
        "connectivity_topology": {"key": "properties.connectivityTopology", "type": "str"},
        "hubs": {"key": "properties.hubs", "type": "[Hub]"},
        "is_global": {"key": "properties.isGlobal", "type": "str"},
        "connectivity_capabilities": {
            "key": "properties.connectivityCapabilities",
            "type": "ConnectivityConfigurationPropertiesConnectivityCapabilities",
        },
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[ConnectivityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "delete_existing_peering": {"key": "properties.deleteExistingPeering", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "_models.ConnectivityTopology"]] = None,
        hubs: Optional[list["_models.Hub"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        connectivity_capabilities: Optional[
            "_models.ConnectivityConfigurationPropertiesConnectivityCapabilities"
        ] = None,
        applies_to_groups: Optional[list["_models.ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "_models.DeleteExistingPeering"]] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Connectivity configuration ID.
        :paramtype id: str
        :keyword configuration_groups: Effective configuration groups.
        :paramtype configuration_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        :keyword description: A description of the connectivity configuration.
        :paramtype description: str
        :keyword connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
         "Mesh".
        :paramtype connectivity_topology: str or ~azure.mgmt.network.models.ConnectivityTopology
        :keyword hubs: List of hubItems.
        :paramtype hubs: list[~azure.mgmt.network.models.Hub]
        :keyword is_global: Flag if global mesh is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.models.IsGlobal
        :keyword connectivity_capabilities: Collection of additional settings to enhance specific
         topology behaviors of the connectivity configuration resource.
        :paramtype connectivity_capabilities:
         ~azure.mgmt.network.models.ConnectivityConfigurationPropertiesConnectivityCapabilities
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups: list[~azure.mgmt.network.models.ConnectivityGroupItem]
        :keyword delete_existing_peering: Flag if need to remove current existing peerings. Known
         values are: "False" and "True".
        :paramtype delete_existing_peering: str or ~azure.mgmt.network.models.DeleteExistingPeering
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        """
        super().__init__(
            id=id,
            configuration_groups=configuration_groups,
            description=description,
            connectivity_topology=connectivity_topology,
            hubs=hubs,
            is_global=is_global,
            connectivity_capabilities=connectivity_capabilities,
            applies_to_groups=applies_to_groups,
            delete_existing_peering=delete_existing_peering,
            **kwargs
        )
        self.commit_time = commit_time
        self.region = region


class ActiveConnectivityConfigurationsListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Result of the request to list active connectivity configurations. It contains a list of active
    connectivity configurations and a skiptoken to get the next set of results.

    :ivar value: Gets a page of active connectivity configurations.
    :vartype value: list[~azure.mgmt.network.models.ActiveConnectivityConfiguration]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActiveConnectivityConfiguration]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ActiveConnectivityConfiguration"]] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a page of active connectivity configurations.
        :paramtype value: list[~azure.mgmt.network.models.ActiveConnectivityConfiguration]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class ActiveDefaultSecurityAdminRule(ActiveBaseSecurityAdminRule):
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.EffectiveAdminRuleKind
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "kind": {"required": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "access": {"readonly": True},
        "priority": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[list["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(
            id=id,
            commit_time=commit_time,
            region=region,
            configuration_description=configuration_description,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind: str = "Default"
        self.description: Optional[str] = None
        self.flag = flag
        self.protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None
        self.sources: Optional[list["_models.AddressPrefixItem"]] = None
        self.destinations: Optional[list["_models.AddressPrefixItem"]] = None
        self.source_port_ranges: Optional[list[str]] = None
        self.destination_port_ranges: Optional[list[str]] = None
        self.access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None
        self.priority: Optional[int] = None
        self.direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class ActiveSecurityAdminRule(ActiveBaseSecurityAdminRule):
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.EffectiveAdminRuleKind
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "kind": {"required": True},
        "priority": {"maximum": 4096, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[list["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[list["_models.AddressPrefixItem"]] = None,
        destinations: Optional[list["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[list[str]] = None,
        destination_port_ranges: Optional[list[str]] = None,
        access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: Indicates the access allowed for this particular rule. Known values are:
         "Allow", "Deny", and "AlwaysAllow".
        :paramtype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
        :keyword priority: The priority of the rule. The value can be between 1 and 4096. The priority
         number must be unique for each rule in the collection. The lower the priority number, the
         higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
        """
        super().__init__(
            id=id,
            commit_time=commit_time,
            region=region,
            configuration_description=configuration_description,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind: str = "Custom"
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class ActiveSecurityAdminRulesListResult(_serialization.Model):
    """Result of the request to list active security admin rules. It contains a list of active
    security admin rules and a skiptoken to get the next set of results.

    :ivar value: Gets a page of active security admin rules.
    :vartype value: list[~azure.mgmt.network.models.ActiveBaseSecurityAdminRule]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActiveBaseSecurityAdminRule]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ActiveBaseSecurityAdminRule"]] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a page of active security admin rules.
        :paramtype value: list[~azure.mgmt.network.models.ActiveBaseSecurityAdminRule]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class AddressPrefixItem(_serialization.Model):
    """Address prefix item.

    :ivar address_prefix: Address prefix.
    :vartype address_prefix: str
    :ivar address_prefix_type: Address prefix type. Known values are: "IPPrefix", "ServiceTag", and
     "NetworkGroup".
    :vartype address_prefix_type: str or ~azure.mgmt.network.models.AddressPrefixType
    """

    _attribute_map = {
        "address_prefix": {"key": "addressPrefix", "type": "str"},
        "address_prefix_type": {"key": "addressPrefixType", "type": "str"},
    }

    def __init__(
        self,
        *,
        address_prefix: Optional[str] = None,
        address_prefix_type: Optional[Union[str, "_models.AddressPrefixType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address_prefix: Address prefix.
        :paramtype address_prefix: str
        :keyword address_prefix_type: Address prefix type. Known values are: "IPPrefix", "ServiceTag",
         and "NetworkGroup".
        :paramtype address_prefix_type: str or ~azure.mgmt.network.models.AddressPrefixType
        """
        super().__init__(**kwargs)
        self.address_prefix = address_prefix
        self.address_prefix_type = address_prefix_type


class AddressSpace(_serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual
    network.

    :ivar address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :vartype address_prefixes: list[str]
    :ivar ipam_pool_prefix_allocations: A list of IPAM Pools allocating IP address prefixes.
    :vartype ipam_pool_prefix_allocations:
     list[~azure.mgmt.network.models.IpamPoolPrefixAllocation]
    """

    _attribute_map = {
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
        "ipam_pool_prefix_allocations": {"key": "ipamPoolPrefixAllocations", "type": "[IpamPoolPrefixAllocation]"},
    }

    def __init__(
        self,
        *,
        address_prefixes: Optional[list[str]] = None,
        ipam_pool_prefix_allocations: Optional[list["_models.IpamPoolPrefixAllocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address_prefixes: A list of address blocks reserved for this virtual network in CIDR
         notation.
        :paramtype address_prefixes: list[str]
        :keyword ipam_pool_prefix_allocations: A list of IPAM Pools allocating IP address prefixes.
        :paramtype ipam_pool_prefix_allocations:
         list[~azure.mgmt.network.models.IpamPoolPrefixAllocation]
        """
        super().__init__(**kwargs)
        self.address_prefixes = address_prefixes
        self.ipam_pool_prefix_allocations = ipam_pool_prefix_allocations


class ChildResource(_serialization.Model):
    """Proxy resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.etag: Optional[str] = None


class BaseAdminRule(ChildResource):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AdminRule, DefaultAdminRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    _subtype_map = {"kind": {"Custom": "AdminRule", "Default": "DefaultAdminRule"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class AdminRule(BaseAdminRule):
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "priority": {"maximum": 4096, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[list["_models.AddressPrefixItem"]] = None,
        destinations: Optional[list["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[list[str]] = None,
        destination_port_ranges: Optional[list[str]] = None,
        access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: Indicates the access allowed for this particular rule. Known values are:
         "Allow", "Deny", and "AlwaysAllow".
        :paramtype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
        :keyword priority: The priority of the rule. The value can be between 1 and 4096. The priority
         number must be unique for each rule in the collection. The lower the priority number, the
         higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
        """
        super().__init__(**kwargs)
        self.kind: str = "Custom"
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class AdminRuleCollection(ChildResource):
    """Defines the admin rule collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    :ivar description: A description of the admin rule collection.
    :vartype description: str
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups: list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[NetworkManagerSecurityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        applies_to_groups: Optional[list["_models.NetworkManagerSecurityGroupItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: A description of the admin rule collection.
        :paramtype description: str
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups: list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.description = description
        self.applies_to_groups = applies_to_groups
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class AdminRuleCollectionListResult(_serialization.Model):
    """Security admin configuration rule collection list result.

    :ivar value: A list of network manager security admin configuration rule collections.
    :vartype value: list[~azure.mgmt.network.models.AdminRuleCollection]
    :ivar next_link: Gets the URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AdminRuleCollection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.AdminRuleCollection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of network manager security admin configuration rule collections.
        :paramtype value: list[~azure.mgmt.network.models.AdminRuleCollection]
        :keyword next_link: Gets the URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AdminRuleListResult(_serialization.Model):
    """security configuration admin rule list result.

    :ivar value: A list of admin rules.
    :vartype value: list[~azure.mgmt.network.models.BaseAdminRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BaseAdminRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.BaseAdminRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of admin rules.
        :paramtype value: list[~azure.mgmt.network.models.BaseAdminRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AdvertisedPublicPrefixProperties(_serialization.Model):
    """Prefix properties required to perform validation using openssl signature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar prefix: Advertised Public Prefix.
    :vartype prefix: str
    :ivar validation_id: Validation string that contains circuit peering info.
    :vartype validation_id: str
    :ivar signature: Signed string generated by encrypting validationId with a private key.
    :vartype signature: str
    :ivar validation_state: Advertised Public Prefix State that denotes if the prefix is validated
     or not. Known values are: "NotConfigured", "Configuring", "Configured", "ValidationNeeded",
     "ValidationFailed", "ManualValidationNeeded", "AsnValidationFailed",
     "CertificateMissingInRoutingRegistry", "InvalidSignatureEncoding", and
     "SignatureVerificationFailed".
    :vartype validation_state: str or
     ~azure.mgmt.network.models.AdvertisedPublicPrefixPropertiesValidationState
    """

    _validation = {
        "validation_state": {"readonly": True},
    }

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "validation_id": {"key": "validationId", "type": "str"},
        "signature": {"key": "signature", "type": "str"},
        "validation_state": {"key": "validationState", "type": "str"},
    }

    def __init__(
        self,
        *,
        prefix: Optional[str] = None,
        validation_id: Optional[str] = None,
        signature: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword prefix: Advertised Public Prefix.
        :paramtype prefix: str
        :keyword validation_id: Validation string that contains circuit peering info.
        :paramtype validation_id: str
        :keyword signature: Signed string generated by encrypting validationId with a private key.
        :paramtype signature: str
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.validation_id = validation_id
        self.signature = signature
        self.validation_state: Optional[Union[str, "_models.AdvertisedPublicPrefixPropertiesValidationState"]] = None


class Resource(_serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar identity: The identity of the application gateway, if configured.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar sku: SKU of the application gateway resource.
    :vartype sku: ~azure.mgmt.network.models.ApplicationGatewaySku
    :ivar ssl_policy: SSL policy of the application gateway resource.
    :vartype ssl_policy: ~azure.mgmt.network.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway resource. Known values
     are: "Stopped", "Starting", "Running", and "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.models.ApplicationGatewayOperationalState
    :ivar gateway_ip_configurations: Subnets of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype gateway_ip_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayIPConfiguration]
    :ivar authentication_certificates: Authentication certificates of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype authentication_certificates:
     list[~azure.mgmt.network.models.ApplicationGatewayAuthenticationCertificate]
    :ivar trusted_root_certificates: Trusted Root certificates of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype trusted_root_certificates:
     list[~azure.mgmt.network.models.ApplicationGatewayTrustedRootCertificate]
    :ivar trusted_client_certificates: Trusted client certificates of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype trusted_client_certificates:
     list[~azure.mgmt.network.models.ApplicationGatewayTrustedClientCertificate]
    :ivar ssl_certificates: SSL certificates of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype ssl_certificates: list[~azure.mgmt.network.models.ApplicationGatewaySslCertificate]
    :ivar frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayFrontendIPConfiguration]
    :ivar frontend_ports: Frontend ports of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype frontend_ports: list[~azure.mgmt.network.models.ApplicationGatewayFrontendPort]
    :ivar probes: Probes of the application gateway resource.
    :vartype probes: list[~azure.mgmt.network.models.ApplicationGatewayProbe]
    :ivar backend_address_pools: Backend address pool of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool]
    :ivar backend_http_settings_collection: Backend http settings of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings]
    :ivar backend_settings_collection: Backend settings of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_settings_collection:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendSettings]
    :ivar http_listeners: Http listeners of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype http_listeners: list[~azure.mgmt.network.models.ApplicationGatewayHttpListener]
    :ivar listeners: Listeners of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype listeners: list[~azure.mgmt.network.models.ApplicationGatewayListener]
    :ivar ssl_profiles: SSL profiles of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype ssl_profiles: list[~azure.mgmt.network.models.ApplicationGatewaySslProfile]
    :ivar url_path_maps: URL path map of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype url_path_maps: list[~azure.mgmt.network.models.ApplicationGatewayUrlPathMap]
    :ivar request_routing_rules: Request routing rules of the application gateway resource.
    :vartype request_routing_rules:
     list[~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRule]
    :ivar routing_rules: Routing rules of the application gateway resource.
    :vartype routing_rules: list[~azure.mgmt.network.models.ApplicationGatewayRoutingRule]
    :ivar rewrite_rule_sets: Rewrite rules for the application gateway resource.
    :vartype rewrite_rule_sets: list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleSet]
    :ivar redirect_configurations: Redirect configurations of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype redirect_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayRedirectConfiguration]
    :ivar web_application_firewall_configuration: Web application firewall configuration.
    :vartype web_application_firewall_configuration:
     ~azure.mgmt.network.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :ivar firewall_policy: Reference to the FirewallPolicy resource.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    :ivar enable_http2: Whether HTTP2 is enabled on the application gateway resource.
    :vartype enable_http2: bool
    :ivar enable_fips: Whether FIPS is enabled on the application gateway resource.
    :vartype enable_fips: bool
    :ivar autoscale_configuration: Autoscale Configuration.
    :vartype autoscale_configuration:
     ~azure.mgmt.network.models.ApplicationGatewayAutoscaleConfiguration
    :ivar private_link_configurations: PrivateLink configurations on application gateway.
    :vartype private_link_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkConfiguration]
    :ivar private_endpoint_connections: Private Endpoint connections on application gateway.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.network.models.ApplicationGatewayPrivateEndpointConnection]
    :ivar resource_guid: The resource GUID property of the application gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application gateway resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar custom_error_configurations: Custom error configurations of the application gateway
     resource.
    :vartype custom_error_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
    :ivar force_firewall_policy_association: If true, associates a firewall policy with an
     application gateway regardless whether the policy differs from the WAF Config.
    :vartype force_firewall_policy_association: bool
    :ivar load_distribution_policies: Load distribution policies of the application gateway
     resource.
    :vartype load_distribution_policies:
     list[~azure.mgmt.network.models.ApplicationGatewayLoadDistributionPolicy]
    :ivar global_configuration: Global Configuration.
    :vartype global_configuration: ~azure.mgmt.network.models.ApplicationGatewayGlobalConfiguration
    :ivar default_predefined_ssl_policy: The default predefined SSL Policy applied on the
     application gateway resource. Known values are: "AppGwSslPolicy20150501",
     "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and
     "AppGwSslPolicy20220101S".
    :vartype default_predefined_ssl_policy: str or
     ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "operational_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "default_predefined_ssl_policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "sku": {"key": "properties.sku", "type": "ApplicationGatewaySku"},
        "ssl_policy": {"key": "properties.sslPolicy", "type": "ApplicationGatewaySslPolicy"},
        "operational_state": {"key": "properties.operationalState", "type": "str"},
        "gateway_ip_configurations": {
            "key": "properties.gatewayIPConfigurations",
            "type": "[ApplicationGatewayIPConfiguration]",
        },
        "authentication_certificates": {
            "key": "properties.authenticationCertificates",
            "type": "[ApplicationGatewayAuthenticationCertificate]",
        },
        "trusted_root_certificates": {
            "key": "properties.trustedRootCertificates",
            "type": "[ApplicationGatewayTrustedRootCertificate]",
        },
        "trusted_client_certificates": {
            "key": "properties.trustedClientCertificates",
            "type": "[ApplicationGatewayTrustedClientCertificate]",
        },
        "ssl_certificates": {"key": "properties.sslCertificates", "type": "[ApplicationGatewaySslCertificate]"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[ApplicationGatewayFrontendIPConfiguration]",
        },
        "frontend_ports": {"key": "properties.frontendPorts", "type": "[ApplicationGatewayFrontendPort]"},
        "probes": {"key": "properties.probes", "type": "[ApplicationGatewayProbe]"},
        "backend_address_pools": {
            "key": "properties.backendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "backend_http_settings_collection": {
            "key": "properties.backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHttpSettings]",
        },
        "backend_settings_collection": {
            "key": "properties.backendSettingsCollection",
            "type": "[ApplicationGatewayBackendSettings]",
        },
        "http_listeners": {"key": "properties.httpListeners", "type": "[ApplicationGatewayHttpListener]"},
        "listeners": {"key": "properties.listeners", "type": "[ApplicationGatewayListener]"},
        "ssl_profiles": {"key": "properties.sslProfiles", "type": "[ApplicationGatewaySslProfile]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[ApplicationGatewayUrlPathMap]"},
        "request_routing_rules": {
            "key": "properties.requestRoutingRules",
            "type": "[ApplicationGatewayRequestRoutingRule]",
        },
        "routing_rules": {"key": "properties.routingRules", "type": "[ApplicationGatewayRoutingRule]"},
        "rewrite_rule_sets": {"key": "properties.rewriteRuleSets", "type": "[ApplicationGatewayRewriteRuleSet]"},
        "redirect_configurations": {
            "key": "properties.redirectConfigurations",
            "type": "[ApplicationGatewayRedirectConfiguration]",
        },
        "web_application_firewall_configuration": {
            "key": "properties.webApplicationFirewallConfiguration",
            "type": "ApplicationGatewayWebApplicationFirewallConfiguration",
        },
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "enable_http2": {"key": "properties.enableHttp2", "type": "bool"},
        "enable_fips": {"key": "properties.enableFips", "type": "bool"},
        "autoscale_configuration": {
            "key": "properties.autoscaleConfiguration",
            "type": "ApplicationGatewayAutoscaleConfiguration",
        },
        "private_link_configurations": {
            "key": "properties.privateLinkConfigurations",
            "type": "[ApplicationGatewayPrivateLinkConfiguration]",
        },
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[ApplicationGatewayPrivateEndpointConnection]",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "custom_error_configurations": {
            "key": "properties.customErrorConfigurations",
            "type": "[ApplicationGatewayCustomError]",
        },
        "force_firewall_policy_association": {"key": "properties.forceFirewallPolicyAssociation", "type": "bool"},
        "load_distribution_policies": {
            "key": "properties.loadDistributionPolicies",
            "type": "[ApplicationGatewayLoadDistributionPolicy]",
        },
        "global_configuration": {
            "key": "properties.globalConfiguration",
            "type": "ApplicationGatewayGlobalConfiguration",
        },
        "default_predefined_ssl_policy": {"key": "properties.defaultPredefinedSslPolicy", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        sku: Optional["_models.ApplicationGatewaySku"] = None,
        ssl_policy: Optional["_models.ApplicationGatewaySslPolicy"] = None,
        gateway_ip_configurations: Optional[list["_models.ApplicationGatewayIPConfiguration"]] = None,
        authentication_certificates: Optional[list["_models.ApplicationGatewayAuthenticationCertificate"]] = None,
        trusted_root_certificates: Optional[list["_models.ApplicationGatewayTrustedRootCertificate"]] = None,
        trusted_client_certificates: Optional[list["_models.ApplicationGatewayTrustedClientCertificate"]] = None,
        ssl_certificates: Optional[list["_models.ApplicationGatewaySslCertificate"]] = None,
        frontend_ip_configurations: Optional[list["_models.ApplicationGatewayFrontendIPConfiguration"]] = None,
        frontend_ports: Optional[list["_models.ApplicationGatewayFrontendPort"]] = None,
        probes: Optional[list["_models.ApplicationGatewayProbe"]] = None,
        backend_address_pools: Optional[list["_models.ApplicationGatewayBackendAddressPool"]] = None,
        backend_http_settings_collection: Optional[list["_models.ApplicationGatewayBackendHttpSettings"]] = None,
        backend_settings_collection: Optional[list["_models.ApplicationGatewayBackendSettings"]] = None,
        http_listeners: Optional[list["_models.ApplicationGatewayHttpListener"]] = None,
        listeners: Optional[list["_models.ApplicationGatewayListener"]] = None,
        ssl_profiles: Optional[list["_models.ApplicationGatewaySslProfile"]] = None,
        url_path_maps: Optional[list["_models.ApplicationGatewayUrlPathMap"]] = None,
        request_routing_rules: Optional[list["_models.ApplicationGatewayRequestRoutingRule"]] = None,
        routing_rules: Optional[list["_models.ApplicationGatewayRoutingRule"]] = None,
        rewrite_rule_sets: Optional[list["_models.ApplicationGatewayRewriteRuleSet"]] = None,
        redirect_configurations: Optional[list["_models.ApplicationGatewayRedirectConfiguration"]] = None,
        web_application_firewall_configuration: Optional[
            "_models.ApplicationGatewayWebApplicationFirewallConfiguration"
        ] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        enable_http2: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        autoscale_configuration: Optional["_models.ApplicationGatewayAutoscaleConfiguration"] = None,
        private_link_configurations: Optional[list["_models.ApplicationGatewayPrivateLinkConfiguration"]] = None,
        custom_error_configurations: Optional[list["_models.ApplicationGatewayCustomError"]] = None,
        force_firewall_policy_association: Optional[bool] = None,
        load_distribution_policies: Optional[list["_models.ApplicationGatewayLoadDistributionPolicy"]] = None,
        global_configuration: Optional["_models.ApplicationGatewayGlobalConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword identity: The identity of the application gateway, if configured.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword sku: SKU of the application gateway resource.
        :paramtype sku: ~azure.mgmt.network.models.ApplicationGatewaySku
        :keyword ssl_policy: SSL policy of the application gateway resource.
        :paramtype ssl_policy: ~azure.mgmt.network.models.ApplicationGatewaySslPolicy
        :keyword gateway_ip_configurations: Subnets of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype gateway_ip_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayIPConfiguration]
        :keyword authentication_certificates: Authentication certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype authentication_certificates:
         list[~azure.mgmt.network.models.ApplicationGatewayAuthenticationCertificate]
        :keyword trusted_root_certificates: Trusted Root certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype trusted_root_certificates:
         list[~azure.mgmt.network.models.ApplicationGatewayTrustedRootCertificate]
        :keyword trusted_client_certificates: Trusted client certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype trusted_client_certificates:
         list[~azure.mgmt.network.models.ApplicationGatewayTrustedClientCertificate]
        :keyword ssl_certificates: SSL certificates of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype ssl_certificates: list[~azure.mgmt.network.models.ApplicationGatewaySslCertificate]
        :keyword frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
         For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayFrontendIPConfiguration]
        :keyword frontend_ports: Frontend ports of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype frontend_ports: list[~azure.mgmt.network.models.ApplicationGatewayFrontendPort]
        :keyword probes: Probes of the application gateway resource.
        :paramtype probes: list[~azure.mgmt.network.models.ApplicationGatewayProbe]
        :keyword backend_address_pools: Backend address pool of the application gateway resource. For
         default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool]
        :keyword backend_http_settings_collection: Backend http settings of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings]
        :keyword backend_settings_collection: Backend settings of the application gateway resource. For
         default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_settings_collection:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendSettings]
        :keyword http_listeners: Http listeners of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype http_listeners: list[~azure.mgmt.network.models.ApplicationGatewayHttpListener]
        :keyword listeners: Listeners of the application gateway resource. For default limits, see
         `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype listeners: list[~azure.mgmt.network.models.ApplicationGatewayListener]
        :keyword ssl_profiles: SSL profiles of the application gateway resource. For default limits,
         see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype ssl_profiles: list[~azure.mgmt.network.models.ApplicationGatewaySslProfile]
        :keyword url_path_maps: URL path map of the application gateway resource. For default limits,
         see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype url_path_maps: list[~azure.mgmt.network.models.ApplicationGatewayUrlPathMap]
        :keyword request_routing_rules: Request routing rules of the application gateway resource.
        :paramtype request_routing_rules:
         list[~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRule]
        :keyword routing_rules: Routing rules of the application gateway resource.
        :paramtype routing_rules: list[~azure.mgmt.network.models.ApplicationGatewayRoutingRule]
        :keyword rewrite_rule_sets: Rewrite rules for the application gateway resource.
        :paramtype rewrite_rule_sets: list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleSet]
        :keyword redirect_configurations: Redirect configurations of the application gateway resource.
         For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype redirect_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayRedirectConfiguration]
        :keyword web_application_firewall_configuration: Web application firewall configuration.
        :paramtype web_application_firewall_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayWebApplicationFirewallConfiguration
        :keyword firewall_policy: Reference to the FirewallPolicy resource.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        :keyword enable_http2: Whether HTTP2 is enabled on the application gateway resource.
        :paramtype enable_http2: bool
        :keyword enable_fips: Whether FIPS is enabled on the application gateway resource.
        :paramtype enable_fips: bool
        :keyword autoscale_configuration: Autoscale Configuration.
        :paramtype autoscale_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayAutoscaleConfiguration
        :keyword private_link_configurations: PrivateLink configurations on application gateway.
        :paramtype private_link_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkConfiguration]
        :keyword custom_error_configurations: Custom error configurations of the application gateway
         resource.
        :paramtype custom_error_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
        :keyword force_firewall_policy_association: If true, associates a firewall policy with an
         application gateway regardless whether the policy differs from the WAF Config.
        :paramtype force_firewall_policy_association: bool
        :keyword load_distribution_policies: Load distribution policies of the application gateway
         resource.
        :paramtype load_distribution_policies:
         list[~azure.mgmt.network.models.ApplicationGatewayLoadDistributionPolicy]
        :keyword global_configuration: Global Configuration.
        :paramtype global_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayGlobalConfiguration
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.zones = zones
        self.identity = identity
        self.sku = sku
        self.ssl_policy = ssl_policy
        self.operational_state: Optional[Union[str, "_models.ApplicationGatewayOperationalState"]] = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.trusted_client_certificates = trusted_client_certificates
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.backend_settings_collection = backend_settings_collection
        self.http_listeners = http_listeners
        self.listeners = listeners
        self.ssl_profiles = ssl_profiles
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.routing_rules = routing_rules
        self.rewrite_rule_sets = rewrite_rule_sets
        self.redirect_configurations = redirect_configurations
        self.web_application_firewall_configuration = web_application_firewall_configuration
        self.firewall_policy = firewall_policy
        self.enable_http2 = enable_http2
        self.enable_fips = enable_fips
        self.autoscale_configuration = autoscale_configuration
        self.private_link_configurations = private_link_configurations
        self.private_endpoint_connections: Optional[list["_models.ApplicationGatewayPrivateEndpointConnection"]] = None
        self.resource_guid: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.custom_error_configurations = custom_error_configurations
        self.force_firewall_policy_association = force_firewall_policy_association
        self.load_distribution_policies = load_distribution_policies
        self.global_configuration = global_configuration
        self.default_predefined_ssl_policy: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None


class SubResource(_serialization.Model):
    """Reference to another subresource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApplicationGatewayAuthenticationCertificate(SubResource):  # pylint: disable=name-too-long
    """Authentication certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the authentication certificate that is unique within an Application
     Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar provisioning_state: The provisioning state of the authentication certificate resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the authentication certificate that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword data: Certificate public data.
        :paramtype data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.data = data
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayAutoscaleConfiguration(_serialization.Model):
    """Application Gateway autoscale configuration.

    All required parameters must be populated in order to send to server.

    :ivar min_capacity: Lower bound on number of Application Gateway capacity. Required.
    :vartype min_capacity: int
    :ivar max_capacity: Upper bound on number of Application Gateway capacity.
    :vartype max_capacity: int
    """

    _validation = {
        "min_capacity": {"required": True, "minimum": 0},
        "max_capacity": {"minimum": 2},
    }

    _attribute_map = {
        "min_capacity": {"key": "minCapacity", "type": "int"},
        "max_capacity": {"key": "maxCapacity", "type": "int"},
    }

    def __init__(self, *, min_capacity: int, max_capacity: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword min_capacity: Lower bound on number of Application Gateway capacity. Required.
        :paramtype min_capacity: int
        :keyword max_capacity: Upper bound on number of Application Gateway capacity.
        :paramtype max_capacity: int
        """
        super().__init__(**kwargs)
        self.min_capacity = min_capacity
        self.max_capacity = max_capacity


class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar predefined_policies: List of available Ssl predefined policy.
    :vartype predefined_policies: list[~azure.mgmt.network.models.SubResource]
    :ivar default_policy: Name of the Ssl predefined policy applied by default to application
     gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401",
     "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and "AppGwSslPolicy20220101S".
    :vartype default_policy: str or ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
    :ivar available_cipher_suites: List of available Ssl cipher suites.
    :vartype available_cipher_suites: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
    :ivar available_protocols: List of available Ssl protocols.
    :vartype available_protocols: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "predefined_policies": {"key": "properties.predefinedPolicies", "type": "[SubResource]"},
        "default_policy": {"key": "properties.defaultPolicy", "type": "str"},
        "available_cipher_suites": {"key": "properties.availableCipherSuites", "type": "[str]"},
        "available_protocols": {"key": "properties.availableProtocols", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        predefined_policies: Optional[list["_models.SubResource"]] = None,
        default_policy: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        available_cipher_suites: Optional[list[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        available_protocols: Optional[list[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword predefined_policies: List of available Ssl predefined policy.
        :paramtype predefined_policies: list[~azure.mgmt.network.models.SubResource]
        :keyword default_policy: Name of the Ssl predefined policy applied by default to application
         gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401",
         "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and "AppGwSslPolicy20220101S".
        :paramtype default_policy: str or ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
        :keyword available_cipher_suites: List of available Ssl cipher suites.
        :paramtype available_cipher_suites: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
        :keyword available_protocols: List of available Ssl protocols.
        :paramtype available_protocols: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.predefined_policies = predefined_policies
        self.default_policy = default_policy
        self.available_cipher_suites = available_cipher_suites
        self.available_protocols = available_protocols


class ApplicationGatewayAvailableSslPredefinedPolicies(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    :ivar value: List of available Ssl predefined policy.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGatewaySslPredefinedPolicy]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewaySslPredefinedPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ApplicationGatewaySslPredefinedPolicy"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of available Ssl predefined policy.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationGatewaySslPredefinedPolicy]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayAvailableWafRuleSetsResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :ivar value: The list of application gateway rule sets.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewayFirewallRuleSet]"},
    }

    def __init__(
        self, *, value: Optional[list["_models.ApplicationGatewayFirewallRuleSet"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of application gateway rule sets.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleSet]
        """
        super().__init__(**kwargs)
        self.value = value


class ApplicationGatewayBackendAddress(_serialization.Model):
    """Backend address of an application gateway.

    :ivar fqdn: Fully qualified domain name (FQDN).
    :vartype fqdn: str
    :ivar ip_address: IP address.
    :vartype ip_address: str
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(self, *, fqdn: Optional[str] = None, ip_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword fqdn: Fully qualified domain name (FQDN).
        :paramtype fqdn: str
        :keyword ip_address: IP address.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the backend address pool that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar backend_ip_configurations: Collection of references to IPs defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
    :ivar backend_addresses: Backend addresses.
    :vartype backend_addresses: list[~azure.mgmt.network.models.ApplicationGatewayBackendAddress]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "backend_ip_configurations": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "backend_addresses": {"key": "properties.backendAddresses", "type": "[ApplicationGatewayBackendAddress]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        backend_addresses: Optional[list["_models.ApplicationGatewayBackendAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the backend address pool that is unique within an Application Gateway.
        :paramtype name: str
        :keyword backend_addresses: Backend addresses.
        :paramtype backend_addresses: list[~azure.mgmt.network.models.ApplicationGatewayBackendAddress]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.backend_ip_configurations: Optional[list["_models.NetworkInterfaceIPConfiguration"]] = None
        self.backend_addresses = backend_addresses
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayBackendHealth(_serialization.Model):
    """Response for ApplicationGatewayBackendHealth API service call.

    :ivar backend_address_pools: A list of ApplicationGatewayBackendHealthPool resources.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        "backend_address_pools": {"key": "backendAddressPools", "type": "[ApplicationGatewayBackendHealthPool]"},
    }

    def __init__(
        self,
        *,
        backend_address_pools: Optional[list["_models.ApplicationGatewayBackendHealthPool"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backend_address_pools: A list of ApplicationGatewayBackendHealthPool resources.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthPool]
        """
        super().__init__(**kwargs)
        self.backend_address_pools = backend_address_pools


class ApplicationGatewayBackendHealthHttpSettings(_serialization.Model):  # pylint: disable=name-too-long
    """Application gateway BackendHealthHttp settings.

    :ivar backend_http_settings: Reference to an ApplicationGatewayBackendHttpSettings resource.
    :vartype backend_http_settings:
     ~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings
    :ivar servers: List of ApplicationGatewayBackendHealthServer resources.
    :vartype servers: list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        "backend_http_settings": {"key": "backendHttpSettings", "type": "ApplicationGatewayBackendHttpSettings"},
        "servers": {"key": "servers", "type": "[ApplicationGatewayBackendHealthServer]"},
    }

    def __init__(
        self,
        *,
        backend_http_settings: Optional["_models.ApplicationGatewayBackendHttpSettings"] = None,
        servers: Optional[list["_models.ApplicationGatewayBackendHealthServer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backend_http_settings: Reference to an ApplicationGatewayBackendHttpSettings resource.
        :paramtype backend_http_settings:
         ~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings
        :keyword servers: List of ApplicationGatewayBackendHealthServer resources.
        :paramtype servers: list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthServer]
        """
        super().__init__(**kwargs)
        self.backend_http_settings = backend_http_settings
        self.servers = servers


class ApplicationGatewayBackendHealthOnDemand(_serialization.Model):
    """Result of on demand test probe.

    :ivar backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
    :vartype backend_address_pool: ~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool
    :ivar backend_health_http_settings: Application gateway BackendHealthHttp settings.
    :vartype backend_health_http_settings:
     ~azure.mgmt.network.models.ApplicationGatewayBackendHealthHttpSettings
    """

    _attribute_map = {
        "backend_address_pool": {"key": "backendAddressPool", "type": "ApplicationGatewayBackendAddressPool"},
        "backend_health_http_settings": {
            "key": "backendHealthHttpSettings",
            "type": "ApplicationGatewayBackendHealthHttpSettings",
        },
    }

    def __init__(
        self,
        *,
        backend_address_pool: Optional["_models.ApplicationGatewayBackendAddressPool"] = None,
        backend_health_http_settings: Optional["_models.ApplicationGatewayBackendHealthHttpSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
        :paramtype backend_address_pool:
         ~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool
        :keyword backend_health_http_settings: Application gateway BackendHealthHttp settings.
        :paramtype backend_health_http_settings:
         ~azure.mgmt.network.models.ApplicationGatewayBackendHealthHttpSettings
        """
        super().__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_health_http_settings = backend_health_http_settings


class ApplicationGatewayBackendHealthPool(_serialization.Model):
    """Application gateway BackendHealth pool.

    :ivar backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
    :vartype backend_address_pool: ~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool
    :ivar backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
     resources.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        "backend_address_pool": {"key": "backendAddressPool", "type": "ApplicationGatewayBackendAddressPool"},
        "backend_http_settings_collection": {
            "key": "backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHealthHttpSettings]",
        },
    }

    def __init__(
        self,
        *,
        backend_address_pool: Optional["_models.ApplicationGatewayBackendAddressPool"] = None,
        backend_http_settings_collection: Optional[list["_models.ApplicationGatewayBackendHealthHttpSettings"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
        :paramtype backend_address_pool:
         ~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool
        :keyword backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
         resources.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthHttpSettings]
        """
        super().__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings_collection = backend_http_settings_collection


class ApplicationGatewayBackendHealthServer(_serialization.Model):
    """Application gateway backendhealth http settings.

    :ivar address: IP address or FQDN of backend server.
    :vartype address: str
    :ivar ip_configuration: Reference to IP configuration of backend server.
    :vartype ip_configuration: ~azure.mgmt.network.models.NetworkInterfaceIPConfiguration
    :ivar health: Health of backend server. Known values are: "Unknown", "Up", "Down", "Partial",
     and "Draining".
    :vartype health: str or ~azure.mgmt.network.models.ApplicationGatewayBackendHealthServerHealth
    :ivar health_probe_log: Health Probe Log.
    :vartype health_probe_log: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "ip_configuration": {"key": "ipConfiguration", "type": "NetworkInterfaceIPConfiguration"},
        "health": {"key": "health", "type": "str"},
        "health_probe_log": {"key": "healthProbeLog", "type": "str"},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        ip_configuration: Optional["_models.NetworkInterfaceIPConfiguration"] = None,
        health: Optional[Union[str, "_models.ApplicationGatewayBackendHealthServerHealth"]] = None,
        health_probe_log: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address: IP address or FQDN of backend server.
        :paramtype address: str
        :keyword ip_configuration: Reference to IP configuration of backend server.
        :paramtype ip_configuration: ~azure.mgmt.network.models.NetworkInterfaceIPConfiguration
        :keyword health: Health of backend server. Known values are: "Unknown", "Up", "Down",
         "Partial", and "Draining".
        :paramtype health: str or
         ~azure.mgmt.network.models.ApplicationGatewayBackendHealthServerHealth
        :keyword health_probe_log: Health Probe Log.
        :paramtype health_probe_log: str
        """
        super().__init__(**kwargs)
        self.address = address
        self.ip_configuration = ip_configuration
        self.health = health
        self.health_probe_log = health_probe_log


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the backend http settings that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: The destination port on the backend.
    :vartype port: int
    :ivar protocol: The protocol used to communicate with the backend. Known values are: "Http",
     "Https", "Tcp", and "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and "Disabled".
    :vartype cookie_based_affinity: str or
     ~azure.mgmt.network.models.ApplicationGatewayCookieBasedAffinity
    :ivar request_timeout: Request timeout in seconds. Application Gateway will fail the request if
     response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :vartype request_timeout: int
    :ivar probe: Probe resource of an application gateway.
    :vartype probe: ~azure.mgmt.network.models.SubResource
    :ivar authentication_certificates: Array of references to application gateway authentication
     certificates.
    :vartype authentication_certificates: list[~azure.mgmt.network.models.SubResource]
    :ivar trusted_root_certificates: Array of references to application gateway trusted root
     certificates.
    :vartype trusted_root_certificates: list[~azure.mgmt.network.models.SubResource]
    :ivar connection_draining: Connection draining of the backend http settings resource.
    :vartype connection_draining: ~azure.mgmt.network.models.ApplicationGatewayConnectionDraining
    :ivar host_name: Host header to be sent to the backend servers.
    :vartype host_name: str
    :ivar pick_host_name_from_backend_address: Whether to pick host header should be picked from
     the host name of the backend server. Default value is false.
    :vartype pick_host_name_from_backend_address: bool
    :ivar affinity_cookie_name: Cookie name to use for the affinity cookie.
    :vartype affinity_cookie_name: str
    :ivar probe_enabled: Whether the probe is enabled. Default value is false.
    :vartype probe_enabled: bool
    :ivar path: Path which should be used as a prefix for all HTTP requests. Null means no path
     will be prefixed. Default value is null.
    :vartype path: str
    :ivar dedicated_backend_connection: Enable or disable dedicated connection per backend server.
     Default is set to false.
    :vartype dedicated_backend_connection: bool
    :ivar validate_cert_chain_and_expiry: Verify or skip both chain and expiry validations of the
     certificate on the backend server. Default is set to true.
    :vartype validate_cert_chain_and_expiry: bool
    :ivar validate_sni: When enabled, verifies if the Common Name of the certificate provided by
     the backend server matches the Server Name Indication (SNI) value. Default value is true.
    :vartype validate_sni: bool
    :ivar sni_name: Specify an SNI value to match the common name of the certificate on the
     backend. By default, the application gateway uses the incoming request’s host header as the
     SNI. Default value is null.
    :vartype sni_name: str
    :ivar provisioning_state: The provisioning state of the backend HTTP settings resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "cookie_based_affinity": {"key": "properties.cookieBasedAffinity", "type": "str"},
        "request_timeout": {"key": "properties.requestTimeout", "type": "int"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "authentication_certificates": {"key": "properties.authenticationCertificates", "type": "[SubResource]"},
        "trusted_root_certificates": {"key": "properties.trustedRootCertificates", "type": "[SubResource]"},
        "connection_draining": {"key": "properties.connectionDraining", "type": "ApplicationGatewayConnectionDraining"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "pick_host_name_from_backend_address": {"key": "properties.pickHostNameFromBackendAddress", "type": "bool"},
        "affinity_cookie_name": {"key": "properties.affinityCookieName", "type": "str"},
        "probe_enabled": {"key": "properties.probeEnabled", "type": "bool"},
        "path": {"key": "properties.path", "type": "str"},
        "dedicated_backend_connection": {"key": "properties.dedicatedBackendConnection", "type": "bool"},
        "validate_cert_chain_and_expiry": {"key": "properties.validateCertChainAndExpiry", "type": "bool"},
        "validate_sni": {"key": "properties.validateSNI", "type": "bool"},
        "sni_name": {"key": "properties.sniName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        cookie_based_affinity: Optional[Union[str, "_models.ApplicationGatewayCookieBasedAffinity"]] = None,
        request_timeout: Optional[int] = None,
        probe: Optional["_models.SubResource"] = None,
        authentication_certificates: Optional[list["_models.SubResource"]] = None,
        trusted_root_certificates: Optional[list["_models.SubResource"]] = None,
        connection_draining: Optional["_models.ApplicationGatewayConnectionDraining"] = None,
        host_name: Optional[str] = None,
        pick_host_name_from_backend_address: Optional[bool] = None,
        affinity_cookie_name: Optional[str] = None,
        probe_enabled: Optional[bool] = None,
        path: Optional[str] = None,
        dedicated_backend_connection: Optional[bool] = None,
        validate_cert_chain_and_expiry: bool = True,
        validate_sni: bool = True,
        sni_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the backend http settings that is unique within an Application Gateway.
        :paramtype name: str
        :keyword port: The destination port on the backend.
        :paramtype port: int
        :keyword protocol: The protocol used to communicate with the backend. Known values are: "Http",
         "Https", "Tcp", and "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and
         "Disabled".
        :paramtype cookie_based_affinity: str or
         ~azure.mgmt.network.models.ApplicationGatewayCookieBasedAffinity
        :keyword request_timeout: Request timeout in seconds. Application Gateway will fail the request
         if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
         seconds.
        :paramtype request_timeout: int
        :keyword probe: Probe resource of an application gateway.
        :paramtype probe: ~azure.mgmt.network.models.SubResource
        :keyword authentication_certificates: Array of references to application gateway authentication
         certificates.
        :paramtype authentication_certificates: list[~azure.mgmt.network.models.SubResource]
        :keyword trusted_root_certificates: Array of references to application gateway trusted root
         certificates.
        :paramtype trusted_root_certificates: list[~azure.mgmt.network.models.SubResource]
        :keyword connection_draining: Connection draining of the backend http settings resource.
        :paramtype connection_draining: ~azure.mgmt.network.models.ApplicationGatewayConnectionDraining
        :keyword host_name: Host header to be sent to the backend servers.
        :paramtype host_name: str
        :keyword pick_host_name_from_backend_address: Whether to pick host header should be picked from
         the host name of the backend server. Default value is false.
        :paramtype pick_host_name_from_backend_address: bool
        :keyword affinity_cookie_name: Cookie name to use for the affinity cookie.
        :paramtype affinity_cookie_name: str
        :keyword probe_enabled: Whether the probe is enabled. Default value is false.
        :paramtype probe_enabled: bool
        :keyword path: Path which should be used as a prefix for all HTTP requests. Null means no path
         will be prefixed. Default value is null.
        :paramtype path: str
        :keyword dedicated_backend_connection: Enable or disable dedicated connection per backend
         server. Default is set to false.
        :paramtype dedicated_backend_connection: bool
        :keyword validate_cert_chain_and_expiry: Verify or skip both chain and expiry validations of
         the certificate on the backend server. Default is set to true.
        :paramtype validate_cert_chain_and_expiry: bool
        :keyword validate_sni: When enabled, verifies if the Common Name of the certificate provided by
         the backend server matches the Server Name Indication (SNI) value. Default value is true.
        :paramtype validate_sni: bool
        :keyword sni_name: Specify an SNI value to match the common name of the certificate on the
         backend. By default, the application gateway uses the incoming request’s host header as the
         SNI. Default value is null.
        :paramtype sni_name: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.connection_draining = connection_draining
        self.host_name = host_name
        self.pick_host_name_from_backend_address = pick_host_name_from_backend_address
        self.affinity_cookie_name = affinity_cookie_name
        self.probe_enabled = probe_enabled
        self.path = path
        self.dedicated_backend_connection = dedicated_backend_connection
        self.validate_cert_chain_and_expiry = validate_cert_chain_and_expiry
        self.validate_sni = validate_sni
        self.sni_name = sni_name
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayBackendSettings(SubResource):
    """Backend address pool settings of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the backend settings that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: The destination port on the backend.
    :vartype port: int
    :ivar protocol: The protocol used to communicate with the backend. Known values are: "Http",
     "Https", "Tcp", and "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar timeout: Connection timeout in seconds. Application Gateway will fail the request if
     response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :vartype timeout: int
    :ivar probe: Probe resource of an application gateway.
    :vartype probe: ~azure.mgmt.network.models.SubResource
    :ivar trusted_root_certificates: Array of references to application gateway trusted root
     certificates.
    :vartype trusted_root_certificates: list[~azure.mgmt.network.models.SubResource]
    :ivar host_name: Server name indication to be sent to the backend servers for Tls protocol.
    :vartype host_name: str
    :ivar pick_host_name_from_backend_address: Whether to pick server name indication from the host
     name of the backend server for Tls protocol. Default value is false.
    :vartype pick_host_name_from_backend_address: bool
    :ivar provisioning_state: The provisioning state of the backend HTTP settings resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "trusted_root_certificates": {"key": "properties.trustedRootCertificates", "type": "[SubResource]"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "pick_host_name_from_backend_address": {"key": "properties.pickHostNameFromBackendAddress", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        timeout: Optional[int] = None,
        probe: Optional["_models.SubResource"] = None,
        trusted_root_certificates: Optional[list["_models.SubResource"]] = None,
        host_name: Optional[str] = None,
        pick_host_name_from_backend_address: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the backend settings that is unique within an Application Gateway.
        :paramtype name: str
        :keyword port: The destination port on the backend.
        :paramtype port: int
        :keyword protocol: The protocol used to communicate with the backend. Known values are: "Http",
         "Https", "Tcp", and "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword timeout: Connection timeout in seconds. Application Gateway will fail the request if
         response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400
         seconds.
        :paramtype timeout: int
        :keyword probe: Probe resource of an application gateway.
        :paramtype probe: ~azure.mgmt.network.models.SubResource
        :keyword trusted_root_certificates: Array of references to application gateway trusted root
         certificates.
        :paramtype trusted_root_certificates: list[~azure.mgmt.network.models.SubResource]
        :keyword host_name: Server name indication to be sent to the backend servers for Tls protocol.
        :paramtype host_name: str
        :keyword pick_host_name_from_backend_address: Whether to pick server name indication from the
         host name of the backend server for Tls protocol. Default value is false.
        :paramtype pick_host_name_from_backend_address: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.port = port
        self.protocol = protocol
        self.timeout = timeout
        self.probe = probe
        self.trusted_root_certificates = trusted_root_certificates
        self.host_name = host_name
        self.pick_host_name_from_backend_address = pick_host_name_from_backend_address
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayClientAuthConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Application gateway client authentication configuration.

    :ivar verify_client_cert_issuer_dn: Verify client certificate issuer name on the application
     gateway.
    :vartype verify_client_cert_issuer_dn: bool
    :ivar verify_client_revocation: Verify client certificate revocation status. Known values are:
     "None" and "OCSP".
    :vartype verify_client_revocation: str or
     ~azure.mgmt.network.models.ApplicationGatewayClientRevocationOptions
    """

    _attribute_map = {
        "verify_client_cert_issuer_dn": {"key": "verifyClientCertIssuerDN", "type": "bool"},
        "verify_client_revocation": {"key": "verifyClientRevocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        verify_client_cert_issuer_dn: Optional[bool] = None,
        verify_client_revocation: Optional[Union[str, "_models.ApplicationGatewayClientRevocationOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword verify_client_cert_issuer_dn: Verify client certificate issuer name on the application
         gateway.
        :paramtype verify_client_cert_issuer_dn: bool
        :keyword verify_client_revocation: Verify client certificate revocation status. Known values
         are: "None" and "OCSP".
        :paramtype verify_client_revocation: str or
         ~azure.mgmt.network.models.ApplicationGatewayClientRevocationOptions
        """
        super().__init__(**kwargs)
        self.verify_client_cert_issuer_dn = verify_client_cert_issuer_dn
        self.verify_client_revocation = verify_client_revocation


class ApplicationGatewayConnectionDraining(_serialization.Model):
    """Connection draining allows open connections to a backend server to be active for a specified
    time after the backend server got removed from the configuration.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether connection draining is enabled or not. Required.
    :vartype enabled: bool
    :ivar drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
     values are from 1 second to 3600 seconds. Required.
    :vartype drain_timeout_in_sec: int
    """

    _validation = {
        "enabled": {"required": True},
        "drain_timeout_in_sec": {"required": True, "maximum": 3600, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "drain_timeout_in_sec": {"key": "drainTimeoutInSec", "type": "int"},
    }

    def __init__(self, *, enabled: bool, drain_timeout_in_sec: int, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether connection draining is enabled or not. Required.
        :paramtype enabled: bool
        :keyword drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
         values are from 1 second to 3600 seconds. Required.
        :paramtype drain_timeout_in_sec: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.drain_timeout_in_sec = drain_timeout_in_sec


class ApplicationGatewayCustomError(_serialization.Model):
    """Custom error of an application gateway.

    :ivar status_code: Status code of the application gateway custom error. Known values are:
     "HttpStatus400", "HttpStatus403", "HttpStatus404", "HttpStatus405", "HttpStatus408",
     "HttpStatus500", "HttpStatus502", "HttpStatus503", and "HttpStatus504".
    :vartype status_code: str or ~azure.mgmt.network.models.ApplicationGatewayCustomErrorStatusCode
    :ivar custom_error_page_url: Error page URL of the application gateway custom error.
    :vartype custom_error_page_url: str
    """

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "str"},
        "custom_error_page_url": {"key": "customErrorPageUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "_models.ApplicationGatewayCustomErrorStatusCode"]] = None,
        custom_error_page_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status_code: Status code of the application gateway custom error. Known values are:
         "HttpStatus400", "HttpStatus403", "HttpStatus404", "HttpStatus405", "HttpStatus408",
         "HttpStatus500", "HttpStatus502", "HttpStatus503", and "HttpStatus504".
        :paramtype status_code: str or
         ~azure.mgmt.network.models.ApplicationGatewayCustomErrorStatusCode
        :keyword custom_error_page_url: Error page URL of the application gateway custom error.
        :paramtype custom_error_page_url: str
        """
        super().__init__(**kwargs)
        self.status_code = status_code
        self.custom_error_page_url = custom_error_page_url


class ApplicationGatewayFirewallDisabledRuleGroup(_serialization.Model):  # pylint: disable=name-too-long
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to server.

    :ivar rule_group_name: The name of the rule group that will be disabled. Required.
    :vartype rule_group_name: str
    :ivar rules: The list of rules that will be disabled. If null, all rules of the rule group will
     be disabled.
    :vartype rules: list[int]
    """

    _validation = {
        "rule_group_name": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "rules": {"key": "rules", "type": "[int]"},
    }

    def __init__(self, *, rule_group_name: str, rules: Optional[list[int]] = None, **kwargs: Any) -> None:
        """
        :keyword rule_group_name: The name of the rule group that will be disabled. Required.
        :paramtype rule_group_name: str
        :keyword rules: The list of rules that will be disabled. If null, all rules of the rule group
         will be disabled.
        :paramtype rules: list[int]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ApplicationGatewayFirewallExclusion(_serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to server.

    :ivar match_variable: The variable to be excluded. Required.
    :vartype match_variable: str
    :ivar selector_match_operator: When matchVariable is a collection, operate on the selector to
     specify which elements in the collection this exclusion applies to. Required.
    :vartype selector_match_operator: str
    :ivar selector: When matchVariable is a collection, operator used to specify which elements in
     the collection this exclusion applies to. Required.
    :vartype selector: str
    """

    _validation = {
        "match_variable": {"required": True},
        "selector_match_operator": {"required": True},
        "selector": {"required": True},
    }

    _attribute_map = {
        "match_variable": {"key": "matchVariable", "type": "str"},
        "selector_match_operator": {"key": "selectorMatchOperator", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
    }

    def __init__(self, *, match_variable: str, selector_match_operator: str, selector: str, **kwargs: Any) -> None:
        """
        :keyword match_variable: The variable to be excluded. Required.
        :paramtype match_variable: str
        :keyword selector_match_operator: When matchVariable is a collection, operate on the selector
         to specify which elements in the collection this exclusion applies to. Required.
        :paramtype selector_match_operator: str
        :keyword selector: When matchVariable is a collection, operator used to specify which elements
         in the collection this exclusion applies to. Required.
        :paramtype selector: str
        """
        super().__init__(**kwargs)
        self.match_variable = match_variable
        self.selector_match_operator = selector_match_operator
        self.selector = selector


class ApplicationGatewayFirewallManifestRuleSet(_serialization.Model):  # pylint: disable=name-too-long
    """Properties of the web application firewall rule set.

    All required parameters must be populated in order to send to server.

    :ivar rule_set_type: The type of the web application firewall rule set. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the web application firewall rule set type. Required.
    :vartype rule_set_version: str
    :ivar status: The rule set status. Known values are: "Preview", "GA", "Supported", and
     "Deprecated".
    :vartype status: str or ~azure.mgmt.network.models.ApplicationGatewayRuleSetStatusOptions
    :ivar tiers: Tier of an application gateway that support the rule set.
    :vartype tiers: list[str or ~azure.mgmt.network.models.ApplicationGatewayTierTypes]
    :ivar rule_groups: The rule groups of the web application firewall rule set. Required.
    :vartype rule_groups: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleGroup]
    """

    _validation = {
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
        "rule_groups": {"required": True},
    }

    _attribute_map = {
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "tiers": {"key": "tiers", "type": "[str]"},
        "rule_groups": {"key": "ruleGroups", "type": "[ApplicationGatewayFirewallRuleGroup]"},
    }

    def __init__(
        self,
        *,
        rule_set_type: str,
        rule_set_version: str,
        rule_groups: list["_models.ApplicationGatewayFirewallRuleGroup"],
        status: Optional[Union[str, "_models.ApplicationGatewayRuleSetStatusOptions"]] = None,
        tiers: Optional[list[Union[str, "_models.ApplicationGatewayTierTypes"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_set_type: The type of the web application firewall rule set. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the web application firewall rule set type. Required.
        :paramtype rule_set_version: str
        :keyword status: The rule set status. Known values are: "Preview", "GA", "Supported", and
         "Deprecated".
        :paramtype status: str or ~azure.mgmt.network.models.ApplicationGatewayRuleSetStatusOptions
        :keyword tiers: Tier of an application gateway that support the rule set.
        :paramtype tiers: list[str or ~azure.mgmt.network.models.ApplicationGatewayTierTypes]
        :keyword rule_groups: The rule groups of the web application firewall rule set. Required.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleGroup]
        """
        super().__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.status = status
        self.tiers = tiers
        self.rule_groups = rule_groups


class ApplicationGatewayFirewallRule(_serialization.Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to server.

    :ivar rule_id: The identifier of the web application firewall rule. Required.
    :vartype rule_id: int
    :ivar rule_id_string: The string representation of the web application firewall rule
     identifier.
    :vartype rule_id_string: str
    :ivar state: The string representation of the web application firewall rule state. Known values
     are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.network.models.ApplicationGatewayWafRuleStateTypes
    :ivar action: The string representation of the web application firewall rule action. Known
     values are: "None", "AnomalyScoring", "Allow", "Block", and "Log".
    :vartype action: str or ~azure.mgmt.network.models.ApplicationGatewayWafRuleActionTypes
    :ivar sensitivity: The string representation of the web application firewall rule sensitivity.
     Known values are: "None", "Low", "Medium", and "High".
    :vartype sensitivity: str or
     ~azure.mgmt.network.models.ApplicationGatewayWafRuleSensitivityTypes
    :ivar description: The description of the web application firewall rule.
    :vartype description: str
    """

    _validation = {
        "rule_id": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "int"},
        "rule_id_string": {"key": "ruleIdString", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "sensitivity": {"key": "sensitivity", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        rule_id: int,
        rule_id_string: Optional[str] = None,
        state: Optional[Union[str, "_models.ApplicationGatewayWafRuleStateTypes"]] = None,
        action: Optional[Union[str, "_models.ApplicationGatewayWafRuleActionTypes"]] = None,
        sensitivity: Optional[Union[str, "_models.ApplicationGatewayWafRuleSensitivityTypes"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_id: The identifier of the web application firewall rule. Required.
        :paramtype rule_id: int
        :keyword rule_id_string: The string representation of the web application firewall rule
         identifier.
        :paramtype rule_id_string: str
        :keyword state: The string representation of the web application firewall rule state. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.network.models.ApplicationGatewayWafRuleStateTypes
        :keyword action: The string representation of the web application firewall rule action. Known
         values are: "None", "AnomalyScoring", "Allow", "Block", and "Log".
        :paramtype action: str or ~azure.mgmt.network.models.ApplicationGatewayWafRuleActionTypes
        :keyword sensitivity: The string representation of the web application firewall rule
         sensitivity. Known values are: "None", "Low", "Medium", and "High".
        :paramtype sensitivity: str or
         ~azure.mgmt.network.models.ApplicationGatewayWafRuleSensitivityTypes
        :keyword description: The description of the web application firewall rule.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.rule_id_string = rule_id_string
        self.state = state
        self.action = action
        self.sensitivity = sensitivity
        self.description = description


class ApplicationGatewayFirewallRuleGroup(_serialization.Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to server.

    :ivar rule_group_name: The name of the web application firewall rule group. Required.
    :vartype rule_group_name: str
    :ivar description: The description of the web application firewall rule group.
    :vartype description: str
    :ivar rules: The rules of the web application firewall rule group. Required.
    :vartype rules: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        "rule_group_name": {"required": True},
        "rules": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rules": {"key": "rules", "type": "[ApplicationGatewayFirewallRule]"},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: list["_models.ApplicationGatewayFirewallRule"],
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_group_name: The name of the web application firewall rule group. Required.
        :paramtype rule_group_name: str
        :keyword description: The description of the web application firewall rule group.
        :paramtype description: str
        :keyword rules: The rules of the web application firewall rule group. Required.
        :paramtype rules: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRule]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.description = description
        self.rules = rules


class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the web application firewall rule set.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar rule_set_type: The type of the web application firewall rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the web application firewall rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: The rule groups of the web application firewall rule set.
    :vartype rule_groups: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleGroup]
    :ivar tiers: Tier of an application gateway that support the rule set.
    :vartype tiers: list[str or ~azure.mgmt.network.models.ApplicationGatewayTierTypes]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rule_set_type": {"key": "properties.ruleSetType", "type": "str"},
        "rule_set_version": {"key": "properties.ruleSetVersion", "type": "str"},
        "rule_groups": {"key": "properties.ruleGroups", "type": "[ApplicationGatewayFirewallRuleGroup]"},
        "tiers": {"key": "properties.tiers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        rule_set_type: Optional[str] = None,
        rule_set_version: Optional[str] = None,
        rule_groups: Optional[list["_models.ApplicationGatewayFirewallRuleGroup"]] = None,
        tiers: Optional[list[Union[str, "_models.ApplicationGatewayTierTypes"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rule_set_type: The type of the web application firewall rule set.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the web application firewall rule set type.
        :paramtype rule_set_version: str
        :keyword rule_groups: The rule groups of the web application firewall rule set.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleGroup]
        :keyword tiers: Tier of an application gateway that support the rule set.
        :paramtype tiers: list[str or ~azure.mgmt.network.models.ApplicationGatewayTierTypes]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_groups = rule_groups
        self.tiers = tiers


class ApplicationGatewayForContainersReferenceDefinition(_serialization.Model):  # pylint: disable=name-too-long
    """Defines an application gateway for containers reference.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id of the application gateway for containers. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id of the application gateway for containers. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApplicationGatewayFrontendIPConfiguration(SubResource):  # pylint: disable=name-too-long
    """Frontend IP configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the frontend IP configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
    :ivar subnet: Reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar public_ip_address: Reference to the PublicIP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.SubResource
    :ivar private_link_configuration: Reference to the application gateway private link
     configuration.
    :vartype private_link_configuration: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "private_link_configuration": {"key": "properties.privateLinkConfiguration", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        private_link_configuration: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the frontend IP configuration that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
        :keyword subnet: Reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword public_ip_address: Reference to the PublicIP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.SubResource
        :keyword private_link_configuration: Reference to the application gateway private link
         configuration.
        :paramtype private_link_configuration: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.private_link_configuration = private_link_configuration
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the frontend port that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: Frontend port.
    :vartype port: int
    :ivar provisioning_state: The provisioning state of the frontend port resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the frontend port that is unique within an Application Gateway.
        :paramtype name: str
        :keyword port: Frontend port.
        :paramtype port: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.port = port
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayGlobalConfiguration(_serialization.Model):
    """Application Gateway global configuration.

    :ivar enable_request_buffering: Enable request buffering.
    :vartype enable_request_buffering: bool
    :ivar enable_response_buffering: Enable response buffering.
    :vartype enable_response_buffering: bool
    """

    _attribute_map = {
        "enable_request_buffering": {"key": "enableRequestBuffering", "type": "bool"},
        "enable_response_buffering": {"key": "enableResponseBuffering", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enable_request_buffering: Optional[bool] = None,
        enable_response_buffering: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_request_buffering: Enable request buffering.
        :paramtype enable_request_buffering: bool
        :keyword enable_response_buffering: Enable response buffering.
        :paramtype enable_response_buffering: bool
        """
        super().__init__(**kwargs)
        self.enable_request_buffering = enable_request_buffering
        self.enable_response_buffering = enable_response_buffering


class ApplicationGatewayHeaderConfiguration(_serialization.Model):
    """Header configuration of the Actions set in Application Gateway.

    :ivar header_name: Header name of the header configuration.
    :vartype header_name: str
    :ivar header_value_matcher: An optional field under "Rewrite Action". It lets you capture and
     modify the value(s) of a specific header when multiple headers with the same name exist.
     Currently supported for Set-Cookie Response header only. For more details, visit
     https://aka.ms/appgwheadercrud.
    :vartype header_value_matcher: ~azure.mgmt.network.models.HeaderValueMatcher
    :ivar header_value: Header value of the header configuration.
    :vartype header_value: str
    """

    _attribute_map = {
        "header_name": {"key": "headerName", "type": "str"},
        "header_value_matcher": {"key": "headerValueMatcher", "type": "HeaderValueMatcher"},
        "header_value": {"key": "headerValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        header_name: Optional[str] = None,
        header_value_matcher: Optional["_models.HeaderValueMatcher"] = None,
        header_value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword header_name: Header name of the header configuration.
        :paramtype header_name: str
        :keyword header_value_matcher: An optional field under "Rewrite Action". It lets you capture
         and modify the value(s) of a specific header when multiple headers with the same name exist.
         Currently supported for Set-Cookie Response header only. For more details, visit
         https://aka.ms/appgwheadercrud.
        :paramtype header_value_matcher: ~azure.mgmt.network.models.HeaderValueMatcher
        :keyword header_value: Header value of the header configuration.
        :paramtype header_value: str
        """
        super().__init__(**kwargs)
        self.header_name = header_name
        self.header_value_matcher = header_value_matcher
        self.header_value = header_value


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the HTTP listener that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar frontend_port: Frontend port resource of an application gateway.
    :vartype frontend_port: ~azure.mgmt.network.models.SubResource
    :ivar protocol: Protocol of the HTTP listener. Known values are: "Http", "Https", "Tcp", and
     "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar host_name: Host name of HTTP listener.
    :vartype host_name: str
    :ivar ssl_certificate: SSL certificate resource of an application gateway.
    :vartype ssl_certificate: ~azure.mgmt.network.models.SubResource
    :ivar ssl_profile: SSL profile resource of the application gateway.
    :vartype ssl_profile: ~azure.mgmt.network.models.SubResource
    :ivar require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :vartype require_server_name_indication: bool
    :ivar provisioning_state: The provisioning state of the HTTP listener resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar custom_error_configurations: Custom error configurations of the HTTP listener.
    :vartype custom_error_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
    :ivar firewall_policy: Reference to the FirewallPolicy resource.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    :ivar host_names: List of Host names for HTTP Listener that allows special wildcard characters
     as well.
    :vartype host_names: list[str]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "frontend_port": {"key": "properties.frontendPort", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "ssl_certificate": {"key": "properties.sslCertificate", "type": "SubResource"},
        "ssl_profile": {"key": "properties.sslProfile", "type": "SubResource"},
        "require_server_name_indication": {"key": "properties.requireServerNameIndication", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "custom_error_configurations": {
            "key": "properties.customErrorConfigurations",
            "type": "[ApplicationGatewayCustomError]",
        },
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        frontend_port: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host_name: Optional[str] = None,
        ssl_certificate: Optional["_models.SubResource"] = None,
        ssl_profile: Optional["_models.SubResource"] = None,
        require_server_name_indication: Optional[bool] = None,
        custom_error_configurations: Optional[list["_models.ApplicationGatewayCustomError"]] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        host_names: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the HTTP listener that is unique within an Application Gateway.
        :paramtype name: str
        :keyword frontend_ip_configuration: Frontend IP configuration resource of an application
         gateway.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword frontend_port: Frontend port resource of an application gateway.
        :paramtype frontend_port: ~azure.mgmt.network.models.SubResource
        :keyword protocol: Protocol of the HTTP listener. Known values are: "Http", "Https", "Tcp", and
         "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword host_name: Host name of HTTP listener.
        :paramtype host_name: str
        :keyword ssl_certificate: SSL certificate resource of an application gateway.
        :paramtype ssl_certificate: ~azure.mgmt.network.models.SubResource
        :keyword ssl_profile: SSL profile resource of the application gateway.
        :paramtype ssl_profile: ~azure.mgmt.network.models.SubResource
        :keyword require_server_name_indication: Applicable only if protocol is https. Enables SNI for
         multi-hosting.
        :paramtype require_server_name_indication: bool
        :keyword custom_error_configurations: Custom error configurations of the HTTP listener.
        :paramtype custom_error_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
        :keyword firewall_policy: Reference to the FirewallPolicy resource.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        :keyword host_names: List of Host names for HTTP Listener that allows special wildcard
         characters as well.
        :paramtype host_names: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.ssl_profile = ssl_profile
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.custom_error_configurations = custom_error_configurations
        self.firewall_policy = firewall_policy
        self.host_names = host_names


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration
    is allowed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the IP configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar subnet: Reference to the subnet resource. A subnet from where application gateway gets
     its private address.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the application gateway IP configuration
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the IP configuration that is unique within an Application Gateway.
        :paramtype name: str
        :keyword subnet: Reference to the subnet resource. A subnet from where application gateway gets
         its private address.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.subnet = subnet
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayListener(SubResource):
    """Listener of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the listener that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar frontend_port: Frontend port resource of an application gateway.
    :vartype frontend_port: ~azure.mgmt.network.models.SubResource
    :ivar protocol: Protocol of the listener. Known values are: "Http", "Https", "Tcp", and "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar ssl_certificate: SSL certificate resource of an application gateway.
    :vartype ssl_certificate: ~azure.mgmt.network.models.SubResource
    :ivar ssl_profile: SSL profile resource of the application gateway.
    :vartype ssl_profile: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the listener resource. Known values are:
     "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar host_names: List of Server Name Indications(SNI) for TLS Multi-site Listener that allows
     special wildcard characters as well.
    :vartype host_names: list[str]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "frontend_port": {"key": "properties.frontendPort", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "ssl_certificate": {"key": "properties.sslCertificate", "type": "SubResource"},
        "ssl_profile": {"key": "properties.sslProfile", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        frontend_port: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        ssl_certificate: Optional["_models.SubResource"] = None,
        ssl_profile: Optional["_models.SubResource"] = None,
        host_names: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the listener that is unique within an Application Gateway.
        :paramtype name: str
        :keyword frontend_ip_configuration: Frontend IP configuration resource of an application
         gateway.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword frontend_port: Frontend port resource of an application gateway.
        :paramtype frontend_port: ~azure.mgmt.network.models.SubResource
        :keyword protocol: Protocol of the listener. Known values are: "Http", "Https", "Tcp", and
         "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword ssl_certificate: SSL certificate resource of an application gateway.
        :paramtype ssl_certificate: ~azure.mgmt.network.models.SubResource
        :keyword ssl_profile: SSL profile resource of the application gateway.
        :paramtype ssl_profile: ~azure.mgmt.network.models.SubResource
        :keyword host_names: List of Server Name Indications(SNI) for TLS Multi-site Listener that
         allows special wildcard characters as well.
        :paramtype host_names: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.ssl_certificate = ssl_certificate
        self.ssl_profile = ssl_profile
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.host_names = host_names


class ApplicationGatewayListResult(_serialization.Model):
    """Response for ListApplicationGateways API service call.

    :ivar value: List of an application gateways in a resource group.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGateway]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ApplicationGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of an application gateways in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationGateway]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayLoadDistributionPolicy(SubResource):
    """Load Distribution Policy of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the load distribution policy that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar load_distribution_targets: Load Distribution Targets resource of an application gateway.
    :vartype load_distribution_targets:
     list[~azure.mgmt.network.models.ApplicationGatewayLoadDistributionTarget]
    :ivar load_distribution_algorithm: Load Distribution Targets resource of an application
     gateway. Known values are: "RoundRobin", "LeastConnections", and "IpHash".
    :vartype load_distribution_algorithm: str or
     ~azure.mgmt.network.models.ApplicationGatewayLoadDistributionAlgorithm
    :ivar provisioning_state: The provisioning state of the Load Distribution Policy resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "load_distribution_targets": {
            "key": "properties.loadDistributionTargets",
            "type": "[ApplicationGatewayLoadDistributionTarget]",
        },
        "load_distribution_algorithm": {"key": "properties.loadDistributionAlgorithm", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        load_distribution_targets: Optional[list["_models.ApplicationGatewayLoadDistributionTarget"]] = None,
        load_distribution_algorithm: Optional[Union[str, "_models.ApplicationGatewayLoadDistributionAlgorithm"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the load distribution policy that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword load_distribution_targets: Load Distribution Targets resource of an application
         gateway.
        :paramtype load_distribution_targets:
         list[~azure.mgmt.network.models.ApplicationGatewayLoadDistributionTarget]
        :keyword load_distribution_algorithm: Load Distribution Targets resource of an application
         gateway. Known values are: "RoundRobin", "LeastConnections", and "IpHash".
        :paramtype load_distribution_algorithm: str or
         ~azure.mgmt.network.models.ApplicationGatewayLoadDistributionAlgorithm
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.load_distribution_targets = load_distribution_targets
        self.load_distribution_algorithm = load_distribution_algorithm
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayLoadDistributionTarget(SubResource):
    """Load Distribution Target of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the load distribution policy that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar weight_per_server: Weight per server. Range between 1 and 100.
    :vartype weight_per_server: int
    :ivar backend_address_pool: Backend address pool resource of the application gateway.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "weight_per_server": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "weight_per_server": {"key": "properties.weightPerServer", "type": "int"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        weight_per_server: Optional[int] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the load distribution policy that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword weight_per_server: Weight per server. Range between 1 and 100.
        :paramtype weight_per_server: int
        :keyword backend_address_pool: Backend address pool resource of the application gateway.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.weight_per_server = weight_per_server
        self.backend_address_pool = backend_address_pool


class ApplicationGatewayOnDemandProbe(_serialization.Model):
    """Details of on demand test probe request.

    :ivar protocol: The protocol used for the probe. Known values are: "Http", "Https", "Tcp", and
     "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar host: Host name to send the probe to.
    :vartype host: str
    :ivar path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://\\ :code:`<host>`:\\ :code:`<port>`\\ :code:`<path>`.
    :vartype path: str
    :ivar timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :vartype timeout: int
    :ivar pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :vartype pick_host_name_from_backend_http_settings: bool
    :ivar match: Criterion for classifying a healthy probe response.
    :vartype match: ~azure.mgmt.network.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar backend_address_pool: Reference to backend pool of application gateway to which probe
     request will be sent.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar backend_http_settings: Reference to backend http setting of application gateway to be
     used for test probe.
    :vartype backend_http_settings: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "host": {"key": "host", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "timeout": {"key": "timeout", "type": "int"},
        "pick_host_name_from_backend_http_settings": {"key": "pickHostNameFromBackendHttpSettings", "type": "bool"},
        "match": {"key": "match", "type": "ApplicationGatewayProbeHealthResponseMatch"},
        "backend_address_pool": {"key": "backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "backendHttpSettings", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        timeout: Optional[int] = None,
        pick_host_name_from_backend_http_settings: Optional[bool] = None,
        match: Optional["_models.ApplicationGatewayProbeHealthResponseMatch"] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol: The protocol used for the probe. Known values are: "Http", "Https", "Tcp",
         and "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword host: Host name to send the probe to.
        :paramtype host: str
        :keyword path: Relative path of probe. Valid path starts from '/'. Probe is sent to
         :code:`<Protocol>`://\\ :code:`<host>`:\\ :code:`<port>`\\ :code:`<path>`.
        :paramtype path: str
        :keyword timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
         received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :paramtype timeout: int
        :keyword pick_host_name_from_backend_http_settings: Whether the host header should be picked
         from the backend http settings. Default value is false.
        :paramtype pick_host_name_from_backend_http_settings: bool
        :keyword match: Criterion for classifying a healthy probe response.
        :paramtype match: ~azure.mgmt.network.models.ApplicationGatewayProbeHealthResponseMatch
        :keyword backend_address_pool: Reference to backend pool of application gateway to which probe
         request will be sent.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword backend_http_settings: Reference to backend http setting of application gateway to be
         used for test probe.
        :paramtype backend_http_settings: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.host = host
        self.path = path
        self.timeout = timeout
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.match = match
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the path rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar paths: Path rules of URL path map.
    :vartype paths: list[str]
    :ivar backend_address_pool: Backend address pool resource of URL path map path rule.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of URL path map path rule.
    :vartype backend_http_settings: ~azure.mgmt.network.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of URL path map path rule.
    :vartype redirect_configuration: ~azure.mgmt.network.models.SubResource
    :ivar rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
    :vartype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
    :ivar load_distribution_policy: Load Distribution Policy resource of URL path map path rule.
    :vartype load_distribution_policy: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the path rule resource. Known values are:
     "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar firewall_policy: Reference to the FirewallPolicy resource.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "paths": {"key": "properties.paths", "type": "[str]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "rewrite_rule_set": {"key": "properties.rewriteRuleSet", "type": "SubResource"},
        "load_distribution_policy": {"key": "properties.loadDistributionPolicy", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        paths: Optional[list[str]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        rewrite_rule_set: Optional["_models.SubResource"] = None,
        load_distribution_policy: Optional["_models.SubResource"] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the path rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword paths: Path rules of URL path map.
        :paramtype paths: list[str]
        :keyword backend_address_pool: Backend address pool resource of URL path map path rule.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of URL path map path rule.
        :paramtype backend_http_settings: ~azure.mgmt.network.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of URL path map path rule.
        :paramtype redirect_configuration: ~azure.mgmt.network.models.SubResource
        :keyword rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
        :paramtype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
        :keyword load_distribution_policy: Load Distribution Policy resource of URL path map path rule.
        :paramtype load_distribution_policy: ~azure.mgmt.network.models.SubResource
        :keyword firewall_policy: Reference to the FirewallPolicy resource.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.redirect_configuration = redirect_configuration
        self.rewrite_rule_set = rewrite_rule_set
        self.load_distribution_policy = load_distribution_policy
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.firewall_policy = firewall_policy


class ApplicationGatewayPrivateEndpointConnection(SubResource):  # pylint: disable=name-too-long
    """Private Endpoint connection on an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the private endpoint connection on an application gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.network.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.network.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the application gateway private endpoint
     connection resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating",
     "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar link_identifier: The consumer link id.
    :vartype link_identifier: str
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "link_identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "link_identifier": {"key": "properties.linkIdentifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the private endpoint connection on an application gateway.
        :paramtype name: str
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.network.models.PrivateLinkServiceConnectionState
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.private_endpoint: Optional["_models.PrivateEndpoint"] = None
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.link_identifier: Optional[str] = None


class ApplicationGatewayPrivateEndpointConnectionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListApplicationGatewayPrivateEndpointConnection API service call. Gets all private
    endpoint connections for an application gateway.

    :ivar value: List of private endpoint connections on an application gateway.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGatewayPrivateEndpointConnection]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewayPrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ApplicationGatewayPrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of private endpoint connections on an application gateway.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationGatewayPrivateEndpointConnection]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayPrivateLinkConfiguration(SubResource):  # pylint: disable=name-too-long
    """Private Link Configuration on an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the private link configuration that is unique within an Application
     Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar ip_configurations: An array of application gateway private link ip configurations.
    :vartype ip_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkIpConfiguration]
    :ivar provisioning_state: The provisioning state of the application gateway private link
     configuration. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[ApplicationGatewayPrivateLinkIpConfiguration]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        ip_configurations: Optional[list["_models.ApplicationGatewayPrivateLinkIpConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the private link configuration that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword ip_configurations: An array of application gateway private link ip configurations.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkIpConfiguration]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.ip_configurations = ip_configurations
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayPrivateLinkIpConfiguration(SubResource):  # pylint: disable=name-too-long
    """The application gateway private link ip configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of application gateway private link ip configuration.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
    :ivar subnet: Reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar primary: Whether the ip configuration is primary or not.
    :vartype primary: bool
    :ivar provisioning_state: The provisioning state of the application gateway private link IP
     configuration. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        primary: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of application gateway private link ip configuration.
        :paramtype name: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
        :keyword subnet: Reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword primary: Whether the ip configuration is primary or not.
        :paramtype primary: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.primary = primary
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayPrivateLinkResource(SubResource):
    """PrivateLink Resource of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the private link resource that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        required_zone_names: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the private link resource that is unique within an Application Gateway.
        :paramtype name: str
        :keyword required_zone_names: Required DNS zone names of the the private link resource.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.group_id: Optional[str] = None
        self.required_members: Optional[list[str]] = None
        self.required_zone_names = required_zone_names


class ApplicationGatewayPrivateLinkResourceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListApplicationGatewayPrivateLinkResources API service call. Gets all private link
    resources for an application gateway.

    :ivar value: List of private link resources of an application gateway.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkResource]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewayPrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ApplicationGatewayPrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of private link resources of an application gateway.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkResource]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the probe that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar protocol: The protocol used for the probe. Known values are: "Http", "Https", "Tcp", and
     "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar host: Host name to send the probe to.
    :vartype host: str
    :ivar path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://\\ :code:`<host>`:\\ :code:`<port>`\\ :code:`<path>`.
    :vartype path: str
    :ivar interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :vartype interval: int
    :ivar timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :vartype timeout: int
    :ivar unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :vartype unhealthy_threshold: int
    :ivar pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :vartype pick_host_name_from_backend_http_settings: bool
    :ivar pick_host_name_from_backend_settings: Whether the server name indication should be picked
     from the backend settings for Tls protocol. Default value is false.
    :vartype pick_host_name_from_backend_settings: bool
    :ivar min_servers: Minimum number of servers that are always marked healthy. Default value is
     0.
    :vartype min_servers: int
    :ivar match: Criterion for classifying a healthy probe response.
    :vartype match: ~azure.mgmt.network.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar provisioning_state: The provisioning state of the probe resource. Known values are:
     "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar port: Custom port which will be used for probing the backend servers. The valid value
     ranges from 1 to 65535. In case not set, port from http settings will be used. This property is
     valid for Basic, Standard_v2 and WAF_v2 only.
    :vartype port: int
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "port": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host": {"key": "properties.host", "type": "str"},
        "path": {"key": "properties.path", "type": "str"},
        "interval": {"key": "properties.interval", "type": "int"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "unhealthy_threshold": {"key": "properties.unhealthyThreshold", "type": "int"},
        "pick_host_name_from_backend_http_settings": {
            "key": "properties.pickHostNameFromBackendHttpSettings",
            "type": "bool",
        },
        "pick_host_name_from_backend_settings": {"key": "properties.pickHostNameFromBackendSettings", "type": "bool"},
        "min_servers": {"key": "properties.minServers", "type": "int"},
        "match": {"key": "properties.match", "type": "ApplicationGatewayProbeHealthResponseMatch"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        interval: Optional[int] = None,
        timeout: Optional[int] = None,
        unhealthy_threshold: Optional[int] = None,
        pick_host_name_from_backend_http_settings: Optional[bool] = None,
        pick_host_name_from_backend_settings: Optional[bool] = None,
        min_servers: Optional[int] = None,
        match: Optional["_models.ApplicationGatewayProbeHealthResponseMatch"] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the probe that is unique within an Application Gateway.
        :paramtype name: str
        :keyword protocol: The protocol used for the probe. Known values are: "Http", "Https", "Tcp",
         and "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword host: Host name to send the probe to.
        :paramtype host: str
        :keyword path: Relative path of probe. Valid path starts from '/'. Probe is sent to
         :code:`<Protocol>`://\\ :code:`<host>`:\\ :code:`<port>`\\ :code:`<path>`.
        :paramtype path: str
        :keyword interval: The probing interval in seconds. This is the time interval between two
         consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :paramtype interval: int
        :keyword timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
         received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :paramtype timeout: int
        :keyword unhealthy_threshold: The probe retry count. Backend server is marked down after
         consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
         to 20.
        :paramtype unhealthy_threshold: int
        :keyword pick_host_name_from_backend_http_settings: Whether the host header should be picked
         from the backend http settings. Default value is false.
        :paramtype pick_host_name_from_backend_http_settings: bool
        :keyword pick_host_name_from_backend_settings: Whether the server name indication should be
         picked from the backend settings for Tls protocol. Default value is false.
        :paramtype pick_host_name_from_backend_settings: bool
        :keyword min_servers: Minimum number of servers that are always marked healthy. Default value
         is 0.
        :paramtype min_servers: int
        :keyword match: Criterion for classifying a healthy probe response.
        :paramtype match: ~azure.mgmt.network.models.ApplicationGatewayProbeHealthResponseMatch
        :keyword port: Custom port which will be used for probing the backend servers. The valid value
         ranges from 1 to 65535. In case not set, port from http settings will be used. This property is
         valid for Basic, Standard_v2 and WAF_v2 only.
        :paramtype port: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.pick_host_name_from_backend_settings = pick_host_name_from_backend_settings
        self.min_servers = min_servers
        self.match = match
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.port = port


class ApplicationGatewayProbeHealthResponseMatch(_serialization.Model):  # pylint: disable=name-too-long
    """Application gateway probe health response match.

    :ivar body: Body that must be contained in the health response. Default value is empty.
    :vartype body: str
    :ivar status_codes: Allowed ranges of healthy status codes. Default range of healthy status
     codes is 200-399.
    :vartype status_codes: list[str]
    """

    _attribute_map = {
        "body": {"key": "body", "type": "str"},
        "status_codes": {"key": "statusCodes", "type": "[str]"},
    }

    def __init__(self, *, body: Optional[str] = None, status_codes: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword body: Body that must be contained in the health response. Default value is empty.
        :paramtype body: str
        :keyword status_codes: Allowed ranges of healthy status codes. Default range of healthy status
         codes is 200-399.
        :paramtype status_codes: list[str]
        """
        super().__init__(**kwargs)
        self.body = body
        self.status_codes = status_codes


class ApplicationGatewayRedirectConfiguration(SubResource):
    """Redirect configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the redirect configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar redirect_type: HTTP redirection type. Known values are: "Permanent", "Found", "SeeOther",
     and "Temporary".
    :vartype redirect_type: str or ~azure.mgmt.network.models.ApplicationGatewayRedirectType
    :ivar target_listener: Reference to a listener to redirect the request to.
    :vartype target_listener: ~azure.mgmt.network.models.SubResource
    :ivar target_url: Url to redirect the request to.
    :vartype target_url: str
    :ivar include_path: Include path in the redirected url.
    :vartype include_path: bool
    :ivar include_query_string: Include query string in the redirected url.
    :vartype include_query_string: bool
    :ivar request_routing_rules: Request routing specifying redirect configuration.
    :vartype request_routing_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar url_path_maps: Url path maps specifying default redirect configuration.
    :vartype url_path_maps: list[~azure.mgmt.network.models.SubResource]
    :ivar path_rules: Path rules specifying redirect configuration.
    :vartype path_rules: list[~azure.mgmt.network.models.SubResource]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "redirect_type": {"key": "properties.redirectType", "type": "str"},
        "target_listener": {"key": "properties.targetListener", "type": "SubResource"},
        "target_url": {"key": "properties.targetUrl", "type": "str"},
        "include_path": {"key": "properties.includePath", "type": "bool"},
        "include_query_string": {"key": "properties.includeQueryString", "type": "bool"},
        "request_routing_rules": {"key": "properties.requestRoutingRules", "type": "[SubResource]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[SubResource]"},
        "path_rules": {"key": "properties.pathRules", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        redirect_type: Optional[Union[str, "_models.ApplicationGatewayRedirectType"]] = None,
        target_listener: Optional["_models.SubResource"] = None,
        target_url: Optional[str] = None,
        include_path: Optional[bool] = None,
        include_query_string: Optional[bool] = None,
        request_routing_rules: Optional[list["_models.SubResource"]] = None,
        url_path_maps: Optional[list["_models.SubResource"]] = None,
        path_rules: Optional[list["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the redirect configuration that is unique within an Application Gateway.
        :paramtype name: str
        :keyword redirect_type: HTTP redirection type. Known values are: "Permanent", "Found",
         "SeeOther", and "Temporary".
        :paramtype redirect_type: str or ~azure.mgmt.network.models.ApplicationGatewayRedirectType
        :keyword target_listener: Reference to a listener to redirect the request to.
        :paramtype target_listener: ~azure.mgmt.network.models.SubResource
        :keyword target_url: Url to redirect the request to.
        :paramtype target_url: str
        :keyword include_path: Include path in the redirected url.
        :paramtype include_path: bool
        :keyword include_query_string: Include query string in the redirected url.
        :paramtype include_query_string: bool
        :keyword request_routing_rules: Request routing specifying redirect configuration.
        :paramtype request_routing_rules: list[~azure.mgmt.network.models.SubResource]
        :keyword url_path_maps: Url path maps specifying default redirect configuration.
        :paramtype url_path_maps: list[~azure.mgmt.network.models.SubResource]
        :keyword path_rules: Path rules specifying redirect configuration.
        :paramtype path_rules: list[~azure.mgmt.network.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.redirect_type = redirect_type
        self.target_listener = target_listener
        self.target_url = target_url
        self.include_path = include_path
        self.include_query_string = include_query_string
        self.request_routing_rules = request_routing_rules
        self.url_path_maps = url_path_maps
        self.path_rules = path_rules


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the request routing rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
    :vartype rule_type: str or ~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRuleType
    :ivar priority: Priority of the request routing rule.
    :vartype priority: int
    :ivar backend_address_pool: Backend address pool resource of the application gateway.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of the application gateway.
    :vartype backend_http_settings: ~azure.mgmt.network.models.SubResource
    :ivar http_listener: Http listener resource of the application gateway.
    :vartype http_listener: ~azure.mgmt.network.models.SubResource
    :ivar url_path_map: URL path map resource of the application gateway.
    :vartype url_path_map: ~azure.mgmt.network.models.SubResource
    :ivar rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
    :vartype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of the application gateway.
    :vartype redirect_configuration: ~azure.mgmt.network.models.SubResource
    :ivar load_distribution_policy: Load Distribution Policy resource of the application gateway.
    :vartype load_distribution_policy: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the request routing rule resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "priority": {"maximum": 20000, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "http_listener": {"key": "properties.httpListener", "type": "SubResource"},
        "url_path_map": {"key": "properties.urlPathMap", "type": "SubResource"},
        "rewrite_rule_set": {"key": "properties.rewriteRuleSet", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "load_distribution_policy": {"key": "properties.loadDistributionPolicy", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.ApplicationGatewayRequestRoutingRuleType"]] = None,
        priority: Optional[int] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        http_listener: Optional["_models.SubResource"] = None,
        url_path_map: Optional["_models.SubResource"] = None,
        rewrite_rule_set: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        load_distribution_policy: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the request routing rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
        :paramtype rule_type: str or
         ~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRuleType
        :keyword priority: Priority of the request routing rule.
        :paramtype priority: int
        :keyword backend_address_pool: Backend address pool resource of the application gateway.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of the application gateway.
        :paramtype backend_http_settings: ~azure.mgmt.network.models.SubResource
        :keyword http_listener: Http listener resource of the application gateway.
        :paramtype http_listener: ~azure.mgmt.network.models.SubResource
        :keyword url_path_map: URL path map resource of the application gateway.
        :paramtype url_path_map: ~azure.mgmt.network.models.SubResource
        :keyword rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
        :paramtype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of the application gateway.
        :paramtype redirect_configuration: ~azure.mgmt.network.models.SubResource
        :keyword load_distribution_policy: Load Distribution Policy resource of the application
         gateway.
        :paramtype load_distribution_policy: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.rule_type = rule_type
        self.priority = priority
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.rewrite_rule_set = rewrite_rule_set
        self.redirect_configuration = redirect_configuration
        self.load_distribution_policy = load_distribution_policy
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayRewriteRule(_serialization.Model):
    """Rewrite rule of an application gateway.

    :ivar name: Name of the rewrite rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar rule_sequence: Rule Sequence of the rewrite rule that determines the order of execution
     of a particular rule in a RewriteRuleSet.
    :vartype rule_sequence: int
    :ivar conditions: Conditions based on which the action set execution will be evaluated.
    :vartype conditions: list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleCondition]
    :ivar action_set: Set of actions to be done as part of the rewrite Rule.
    :vartype action_set: ~azure.mgmt.network.models.ApplicationGatewayRewriteRuleActionSet
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "rule_sequence": {"key": "ruleSequence", "type": "int"},
        "conditions": {"key": "conditions", "type": "[ApplicationGatewayRewriteRuleCondition]"},
        "action_set": {"key": "actionSet", "type": "ApplicationGatewayRewriteRuleActionSet"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        rule_sequence: Optional[int] = None,
        conditions: Optional[list["_models.ApplicationGatewayRewriteRuleCondition"]] = None,
        action_set: Optional["_models.ApplicationGatewayRewriteRuleActionSet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the rewrite rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rule_sequence: Rule Sequence of the rewrite rule that determines the order of
         execution of a particular rule in a RewriteRuleSet.
        :paramtype rule_sequence: int
        :keyword conditions: Conditions based on which the action set execution will be evaluated.
        :paramtype conditions: list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleCondition]
        :keyword action_set: Set of actions to be done as part of the rewrite Rule.
        :paramtype action_set: ~azure.mgmt.network.models.ApplicationGatewayRewriteRuleActionSet
        """
        super().__init__(**kwargs)
        self.name = name
        self.rule_sequence = rule_sequence
        self.conditions = conditions
        self.action_set = action_set


class ApplicationGatewayRewriteRuleActionSet(_serialization.Model):
    """Set of actions in the Rewrite Rule in Application Gateway.

    :ivar request_header_configurations: Request Header Actions in the Action Set.
    :vartype request_header_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
    :ivar response_header_configurations: Response Header Actions in the Action Set.
    :vartype response_header_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
    :ivar url_configuration: Url Configuration Action in the Action Set.
    :vartype url_configuration: ~azure.mgmt.network.models.ApplicationGatewayUrlConfiguration
    """

    _attribute_map = {
        "request_header_configurations": {
            "key": "requestHeaderConfigurations",
            "type": "[ApplicationGatewayHeaderConfiguration]",
        },
        "response_header_configurations": {
            "key": "responseHeaderConfigurations",
            "type": "[ApplicationGatewayHeaderConfiguration]",
        },
        "url_configuration": {"key": "urlConfiguration", "type": "ApplicationGatewayUrlConfiguration"},
    }

    def __init__(
        self,
        *,
        request_header_configurations: Optional[list["_models.ApplicationGatewayHeaderConfiguration"]] = None,
        response_header_configurations: Optional[list["_models.ApplicationGatewayHeaderConfiguration"]] = None,
        url_configuration: Optional["_models.ApplicationGatewayUrlConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword request_header_configurations: Request Header Actions in the Action Set.
        :paramtype request_header_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
        :keyword response_header_configurations: Response Header Actions in the Action Set.
        :paramtype response_header_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
        :keyword url_configuration: Url Configuration Action in the Action Set.
        :paramtype url_configuration: ~azure.mgmt.network.models.ApplicationGatewayUrlConfiguration
        """
        super().__init__(**kwargs)
        self.request_header_configurations = request_header_configurations
        self.response_header_configurations = response_header_configurations
        self.url_configuration = url_configuration


class ApplicationGatewayRewriteRuleCondition(_serialization.Model):
    """Set of conditions in the Rewrite Rule in Application Gateway.

    :ivar variable: The condition parameter of the RewriteRuleCondition.
    :vartype variable: str
    :ivar pattern: The pattern, either fixed string or regular expression, that evaluates the
     truthfulness of the condition.
    :vartype pattern: str
    :ivar ignore_case: Setting this parameter to truth value with force the pattern to do a case
     in-sensitive comparison.
    :vartype ignore_case: bool
    :ivar negate: Setting this value as truth will force to check the negation of the condition
     given by the user.
    :vartype negate: bool
    """

    _attribute_map = {
        "variable": {"key": "variable", "type": "str"},
        "pattern": {"key": "pattern", "type": "str"},
        "ignore_case": {"key": "ignoreCase", "type": "bool"},
        "negate": {"key": "negate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        variable: Optional[str] = None,
        pattern: Optional[str] = None,
        ignore_case: Optional[bool] = None,
        negate: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword variable: The condition parameter of the RewriteRuleCondition.
        :paramtype variable: str
        :keyword pattern: The pattern, either fixed string or regular expression, that evaluates the
         truthfulness of the condition.
        :paramtype pattern: str
        :keyword ignore_case: Setting this parameter to truth value with force the pattern to do a case
         in-sensitive comparison.
        :paramtype ignore_case: bool
        :keyword negate: Setting this value as truth will force to check the negation of the condition
         given by the user.
        :paramtype negate: bool
        """
        super().__init__(**kwargs)
        self.variable = variable
        self.pattern = pattern
        self.ignore_case = ignore_case
        self.negate = negate


class ApplicationGatewayRewriteRuleSet(SubResource):
    """Rewrite rule set of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the rewrite rule set that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rewrite_rules: Rewrite rules in the rewrite rule set.
    :vartype rewrite_rules: list[~azure.mgmt.network.models.ApplicationGatewayRewriteRule]
    :ivar provisioning_state: The provisioning state of the rewrite rule set resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "rewrite_rules": {"key": "properties.rewriteRules", "type": "[ApplicationGatewayRewriteRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        rewrite_rules: Optional[list["_models.ApplicationGatewayRewriteRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the rewrite rule set that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rewrite_rules: Rewrite rules in the rewrite rule set.
        :paramtype rewrite_rules: list[~azure.mgmt.network.models.ApplicationGatewayRewriteRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.rewrite_rules = rewrite_rules
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayRoutingRule(SubResource):
    """Routing rule of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the routing rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
    :vartype rule_type: str or ~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRuleType
    :ivar priority: Priority of the routing rule.
    :vartype priority: int
    :ivar backend_address_pool: Backend address pool resource of the application gateway.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar backend_settings: Backend settings resource of the application gateway.
    :vartype backend_settings: ~azure.mgmt.network.models.SubResource
    :ivar listener: Listener resource of the application gateway.
    :vartype listener: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the request routing rule resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "priority": {"maximum": 20000, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_settings": {"key": "properties.backendSettings", "type": "SubResource"},
        "listener": {"key": "properties.listener", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.ApplicationGatewayRequestRoutingRuleType"]] = None,
        priority: Optional[int] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_settings: Optional["_models.SubResource"] = None,
        listener: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the routing rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
        :paramtype rule_type: str or
         ~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRuleType
        :keyword priority: Priority of the routing rule.
        :paramtype priority: int
        :keyword backend_address_pool: Backend address pool resource of the application gateway.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword backend_settings: Backend settings resource of the application gateway.
        :paramtype backend_settings: ~azure.mgmt.network.models.SubResource
        :keyword listener: Listener resource of the application gateway.
        :paramtype listener: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.rule_type = rule_type
        self.priority = priority
        self.backend_address_pool = backend_address_pool
        self.backend_settings = backend_settings
        self.listener = listener
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewaySku(_serialization.Model):
    """SKU of an application gateway.

    :ivar name: Name of an application gateway SKU. Known values are: "Standard_Small",
     "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large", "Standard_v2", "WAF_v2", and
     "Basic".
    :vartype name: str or ~azure.mgmt.network.models.ApplicationGatewaySkuName
    :ivar tier: Tier of an application gateway. Known values are: "Standard", "WAF", "Standard_v2",
     "WAF_v2", and "Basic".
    :vartype tier: str or ~azure.mgmt.network.models.ApplicationGatewayTier
    :ivar capacity: Capacity (instance count) of an application gateway.
    :vartype capacity: int
    :ivar family: Family of an application gateway SKU. Known values are: "Generation_1" and
     "Generation_2".
    :vartype family: str or ~azure.mgmt.network.models.ApplicationGatewaySkuFamily
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ApplicationGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.ApplicationGatewayTier"]] = None,
        capacity: Optional[int] = None,
        family: Optional[Union[str, "_models.ApplicationGatewaySkuFamily"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of an application gateway SKU. Known values are: "Standard_Small",
         "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large", "Standard_v2", "WAF_v2", and
         "Basic".
        :paramtype name: str or ~azure.mgmt.network.models.ApplicationGatewaySkuName
        :keyword tier: Tier of an application gateway. Known values are: "Standard", "WAF",
         "Standard_v2", "WAF_v2", and "Basic".
        :paramtype tier: str or ~azure.mgmt.network.models.ApplicationGatewayTier
        :keyword capacity: Capacity (instance count) of an application gateway.
        :paramtype capacity: int
        :keyword family: Family of an application gateway SKU. Known values are: "Generation_1" and
         "Generation_2".
        :paramtype family: str or ~azure.mgmt.network.models.ApplicationGatewaySkuFamily
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity
        self.family = family


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the SSL certificate that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :vartype data: str
    :ivar password: Password for the pfx file specified in data. Only applicable in PUT request.
    :vartype password: str
    :ivar public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :vartype public_cert_data: str
    :ivar key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :vartype key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the SSL certificate resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "public_cert_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "key_vault_secret_id": {"key": "properties.keyVaultSecretId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the SSL certificate that is unique within an Application Gateway.
        :paramtype name: str
        :keyword data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :paramtype data: str
        :keyword password: Password for the pfx file specified in data. Only applicable in PUT request.
        :paramtype password: str
        :keyword key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
         'Certificate' object stored in KeyVault.
        :paramtype key_vault_secret_id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.data = data
        self.password = password
        self.public_cert_data: Optional[str] = None
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewaySslPolicy(_serialization.Model):
    """Application Gateway Ssl policy.

    :ivar disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
    :vartype disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
    :ivar policy_type: Type of Ssl Policy. Known values are: "Predefined", "Custom", and
     "CustomV2".
    :vartype policy_type: str or ~azure.mgmt.network.models.ApplicationGatewaySslPolicyType
    :ivar policy_name: Name of Ssl predefined policy. Known values are: "AppGwSslPolicy20150501",
     "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and
     "AppGwSslPolicy20220101S".
    :vartype policy_name: str or ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order to application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
    :vartype min_protocol_version: str or ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "disabled_ssl_protocols": {"key": "disabledSslProtocols", "type": "[str]"},
        "policy_type": {"key": "policyType", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "cipher_suites": {"key": "cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        disabled_ssl_protocols: Optional[list[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        policy_type: Optional[Union[str, "_models.ApplicationGatewaySslPolicyType"]] = None,
        policy_name: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        cipher_suites: Optional[list[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
        :paramtype disabled_ssl_protocols: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
        :keyword policy_type: Type of Ssl Policy. Known values are: "Predefined", "Custom", and
         "CustomV2".
        :paramtype policy_type: str or ~azure.mgmt.network.models.ApplicationGatewaySslPolicyType
        :keyword policy_name: Name of Ssl predefined policy. Known values are:
         "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S",
         "AppGwSslPolicy20220101", and "AppGwSslPolicy20220101S".
        :paramtype policy_name: str or ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order to application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
        """
        super().__init__(**kwargs)
        self.disabled_ssl_protocols = disabled_ssl_protocols
        self.policy_type = policy_type
        self.policy_name = policy_name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the Ssl predefined policy.
    :vartype name: str
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order for application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
    :vartype min_protocol_version: str or ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "cipher_suites": {"key": "properties.cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "properties.minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        cipher_suites: Optional[list[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the Ssl predefined policy.
        :paramtype name: str
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order for application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewaySslProfile(SubResource):
    """SSL profile of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the SSL profile that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar trusted_client_certificates: Array of references to application gateway trusted client
     certificates.
    :vartype trusted_client_certificates: list[~azure.mgmt.network.models.SubResource]
    :ivar ssl_policy: SSL policy of the application gateway resource.
    :vartype ssl_policy: ~azure.mgmt.network.models.ApplicationGatewaySslPolicy
    :ivar client_auth_configuration: Client authentication configuration of the application gateway
     resource.
    :vartype client_auth_configuration:
     ~azure.mgmt.network.models.ApplicationGatewayClientAuthConfiguration
    :ivar provisioning_state: The provisioning state of the HTTP listener resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "trusted_client_certificates": {"key": "properties.trustedClientCertificates", "type": "[SubResource]"},
        "ssl_policy": {"key": "properties.sslPolicy", "type": "ApplicationGatewaySslPolicy"},
        "client_auth_configuration": {
            "key": "properties.clientAuthConfiguration",
            "type": "ApplicationGatewayClientAuthConfiguration",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        trusted_client_certificates: Optional[list["_models.SubResource"]] = None,
        ssl_policy: Optional["_models.ApplicationGatewaySslPolicy"] = None,
        client_auth_configuration: Optional["_models.ApplicationGatewayClientAuthConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the SSL profile that is unique within an Application Gateway.
        :paramtype name: str
        :keyword trusted_client_certificates: Array of references to application gateway trusted client
         certificates.
        :paramtype trusted_client_certificates: list[~azure.mgmt.network.models.SubResource]
        :keyword ssl_policy: SSL policy of the application gateway resource.
        :paramtype ssl_policy: ~azure.mgmt.network.models.ApplicationGatewaySslPolicy
        :keyword client_auth_configuration: Client authentication configuration of the application
         gateway resource.
        :paramtype client_auth_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayClientAuthConfiguration
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.trusted_client_certificates = trusted_client_certificates
        self.ssl_policy = ssl_policy
        self.client_auth_configuration = client_auth_configuration
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayTrustedClientCertificate(SubResource):  # pylint: disable=name-too-long
    """Trusted client certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the trusted client certificate that is unique within an Application
     Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar validated_cert_data: Validated certificate data.
    :vartype validated_cert_data: str
    :ivar client_cert_issuer_dn: Distinguished name of client certificate issuer.
    :vartype client_cert_issuer_dn: str
    :ivar provisioning_state: The provisioning state of the trusted client certificate resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "validated_cert_data": {"readonly": True},
        "client_cert_issuer_dn": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "validated_cert_data": {"key": "properties.validatedCertData", "type": "str"},
        "client_cert_issuer_dn": {"key": "properties.clientCertIssuerDN", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the trusted client certificate that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword data: Certificate public data.
        :paramtype data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.data = data
        self.validated_cert_data: Optional[str] = None
        self.client_cert_issuer_dn: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayTrustedRootCertificate(SubResource):
    """Trusted Root certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the trusted root certificate that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :vartype key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the trusted root certificate resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "key_vault_secret_id": {"key": "properties.keyVaultSecretId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        data: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the trusted root certificate that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword data: Certificate public data.
        :paramtype data: str
        :keyword key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
         'Certificate' object stored in KeyVault.
        :paramtype key_vault_secret_id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.data = data
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayUrlConfiguration(_serialization.Model):
    """Url configuration of the Actions set in Application Gateway.

    :ivar modified_path: Url path which user has provided for url rewrite. Null means no path will
     be updated. Default value is null.
    :vartype modified_path: str
    :ivar modified_query_string: Query string which user has provided for url rewrite. Null means
     no query string will be updated. Default value is null.
    :vartype modified_query_string: str
    :ivar reroute: If set as true, it will re-evaluate the url path map provided in path based
     request routing rules using modified path. Default value is false.
    :vartype reroute: bool
    """

    _attribute_map = {
        "modified_path": {"key": "modifiedPath", "type": "str"},
        "modified_query_string": {"key": "modifiedQueryString", "type": "str"},
        "reroute": {"key": "reroute", "type": "bool"},
    }

    def __init__(
        self,
        *,
        modified_path: Optional[str] = None,
        modified_query_string: Optional[str] = None,
        reroute: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword modified_path: Url path which user has provided for url rewrite. Null means no path
         will be updated. Default value is null.
        :paramtype modified_path: str
        :keyword modified_query_string: Query string which user has provided for url rewrite. Null
         means no query string will be updated. Default value is null.
        :paramtype modified_query_string: str
        :keyword reroute: If set as true, it will re-evaluate the url path map provided in path based
         request routing rules using modified path. Default value is false.
        :paramtype reroute: bool
        """
        super().__init__(**kwargs)
        self.modified_path = modified_path
        self.modified_query_string = modified_query_string
        self.reroute = reroute


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the URL path map that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar default_backend_address_pool: Default backend address pool resource of URL path map.
    :vartype default_backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar default_backend_http_settings: Default backend http settings resource of URL path map.
    :vartype default_backend_http_settings: ~azure.mgmt.network.models.SubResource
    :ivar default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
    :vartype default_rewrite_rule_set: ~azure.mgmt.network.models.SubResource
    :ivar default_redirect_configuration: Default redirect configuration resource of URL path map.
    :vartype default_redirect_configuration: ~azure.mgmt.network.models.SubResource
    :ivar default_load_distribution_policy: Default Load Distribution Policy resource of URL path
     map.
    :vartype default_load_distribution_policy: ~azure.mgmt.network.models.SubResource
    :ivar path_rules: Path rule of URL path map resource.
    :vartype path_rules: list[~azure.mgmt.network.models.ApplicationGatewayPathRule]
    :ivar provisioning_state: The provisioning state of the URL path map resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_backend_address_pool": {"key": "properties.defaultBackendAddressPool", "type": "SubResource"},
        "default_backend_http_settings": {"key": "properties.defaultBackendHttpSettings", "type": "SubResource"},
        "default_rewrite_rule_set": {"key": "properties.defaultRewriteRuleSet", "type": "SubResource"},
        "default_redirect_configuration": {"key": "properties.defaultRedirectConfiguration", "type": "SubResource"},
        "default_load_distribution_policy": {"key": "properties.defaultLoadDistributionPolicy", "type": "SubResource"},
        "path_rules": {"key": "properties.pathRules", "type": "[ApplicationGatewayPathRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        default_backend_address_pool: Optional["_models.SubResource"] = None,
        default_backend_http_settings: Optional["_models.SubResource"] = None,
        default_rewrite_rule_set: Optional["_models.SubResource"] = None,
        default_redirect_configuration: Optional["_models.SubResource"] = None,
        default_load_distribution_policy: Optional["_models.SubResource"] = None,
        path_rules: Optional[list["_models.ApplicationGatewayPathRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the URL path map that is unique within an Application Gateway.
        :paramtype name: str
        :keyword default_backend_address_pool: Default backend address pool resource of URL path map.
        :paramtype default_backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword default_backend_http_settings: Default backend http settings resource of URL path map.
        :paramtype default_backend_http_settings: ~azure.mgmt.network.models.SubResource
        :keyword default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
        :paramtype default_rewrite_rule_set: ~azure.mgmt.network.models.SubResource
        :keyword default_redirect_configuration: Default redirect configuration resource of URL path
         map.
        :paramtype default_redirect_configuration: ~azure.mgmt.network.models.SubResource
        :keyword default_load_distribution_policy: Default Load Distribution Policy resource of URL
         path map.
        :paramtype default_load_distribution_policy: ~azure.mgmt.network.models.SubResource
        :keyword path_rules: Path rule of URL path map resource.
        :paramtype path_rules: list[~azure.mgmt.network.models.ApplicationGatewayPathRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.default_rewrite_rule_set = default_rewrite_rule_set
        self.default_redirect_configuration = default_redirect_configuration
        self.default_load_distribution_policy = default_load_distribution_policy
        self.path_rules = path_rules
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationGatewayWafDynamicManifestResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ApplicationGatewayWafDynamicManifest API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar available_rule_sets: The available rulesets.
    :vartype available_rule_sets:
     list[~azure.mgmt.network.models.ApplicationGatewayFirewallManifestRuleSet]
    :ivar rule_set_type: The type of the web application firewall rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the web application firewall rule set type.
    :vartype rule_set_version: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "available_rule_sets": {
            "key": "properties.availableRuleSets",
            "type": "[ApplicationGatewayFirewallManifestRuleSet]",
        },
        "rule_set_type": {"key": "properties.defaultRuleSet.ruleSetType", "type": "str"},
        "rule_set_version": {"key": "properties.defaultRuleSet.ruleSetVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        available_rule_sets: Optional[list["_models.ApplicationGatewayFirewallManifestRuleSet"]] = None,
        rule_set_type: Optional[str] = None,
        rule_set_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword available_rule_sets: The available rulesets.
        :paramtype available_rule_sets:
         list[~azure.mgmt.network.models.ApplicationGatewayFirewallManifestRuleSet]
        :keyword rule_set_type: The type of the web application firewall rule set.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the web application firewall rule set type.
        :paramtype rule_set_version: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.available_rule_sets = available_rule_sets
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version


class ApplicationGatewayWafDynamicManifestResultList(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ApplicationGatewayWafDynamicManifests API service call.

    :ivar value: The list of application gateway waf manifest.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGatewayWafDynamicManifestResult]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewayWafDynamicManifestResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ApplicationGatewayWafDynamicManifestResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of application gateway waf manifest.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationGatewayWafDynamicManifestResult]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayWebApplicationFirewallConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether the web application firewall is enabled or not. Required.
    :vartype enabled: bool
    :ivar firewall_mode: Web application firewall mode. Required. Known values are: "Detection" and
     "Prevention".
    :vartype firewall_mode: str or ~azure.mgmt.network.models.ApplicationGatewayFirewallMode
    :ivar rule_set_type: The type of the web application firewall rule set. Possible values are:
     'OWASP'. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the rule set type. Required.
    :vartype rule_set_version: str
    :ivar disabled_rule_groups: The disabled rule groups.
    :vartype disabled_rule_groups:
     list[~azure.mgmt.network.models.ApplicationGatewayFirewallDisabledRuleGroup]
    :ivar request_body_check: Whether allow WAF to check request Body.
    :vartype request_body_check: bool
    :ivar max_request_body_size: Maximum request body size for WAF.
    :vartype max_request_body_size: int
    :ivar max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
    :vartype max_request_body_size_in_kb: int
    :ivar file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :vartype file_upload_limit_in_mb: int
    :ivar exclusions: The exclusion list.
    :vartype exclusions: list[~azure.mgmt.network.models.ApplicationGatewayFirewallExclusion]
    """

    _validation = {
        "enabled": {"required": True},
        "firewall_mode": {"required": True},
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
        "max_request_body_size": {"maximum": 128, "minimum": 8},
        "max_request_body_size_in_kb": {"maximum": 128, "minimum": 8},
        "file_upload_limit_in_mb": {"minimum": 0},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "firewall_mode": {"key": "firewallMode", "type": "str"},
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "disabled_rule_groups": {"key": "disabledRuleGroups", "type": "[ApplicationGatewayFirewallDisabledRuleGroup]"},
        "request_body_check": {"key": "requestBodyCheck", "type": "bool"},
        "max_request_body_size": {"key": "maxRequestBodySize", "type": "int"},
        "max_request_body_size_in_kb": {"key": "maxRequestBodySizeInKb", "type": "int"},
        "file_upload_limit_in_mb": {"key": "fileUploadLimitInMb", "type": "int"},
        "exclusions": {"key": "exclusions", "type": "[ApplicationGatewayFirewallExclusion]"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        firewall_mode: Union[str, "_models.ApplicationGatewayFirewallMode"],
        rule_set_type: str,
        rule_set_version: str,
        disabled_rule_groups: Optional[list["_models.ApplicationGatewayFirewallDisabledRuleGroup"]] = None,
        request_body_check: Optional[bool] = None,
        max_request_body_size: Optional[int] = None,
        max_request_body_size_in_kb: Optional[int] = None,
        file_upload_limit_in_mb: Optional[int] = None,
        exclusions: Optional[list["_models.ApplicationGatewayFirewallExclusion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether the web application firewall is enabled or not. Required.
        :paramtype enabled: bool
        :keyword firewall_mode: Web application firewall mode. Required. Known values are: "Detection"
         and "Prevention".
        :paramtype firewall_mode: str or ~azure.mgmt.network.models.ApplicationGatewayFirewallMode
        :keyword rule_set_type: The type of the web application firewall rule set. Possible values are:
         'OWASP'. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the rule set type. Required.
        :paramtype rule_set_version: str
        :keyword disabled_rule_groups: The disabled rule groups.
        :paramtype disabled_rule_groups:
         list[~azure.mgmt.network.models.ApplicationGatewayFirewallDisabledRuleGroup]
        :keyword request_body_check: Whether allow WAF to check request Body.
        :paramtype request_body_check: bool
        :keyword max_request_body_size: Maximum request body size for WAF.
        :paramtype max_request_body_size: int
        :keyword max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :paramtype max_request_body_size_in_kb: int
        :keyword file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :paramtype file_upload_limit_in_mb: int
        :keyword exclusions: The exclusion list.
        :paramtype exclusions: list[~azure.mgmt.network.models.ApplicationGatewayFirewallExclusion]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.firewall_mode = firewall_mode
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.disabled_rule_groups = disabled_rule_groups
        self.request_body_check = request_body_check
        self.max_request_body_size = max_request_body_size
        self.max_request_body_size_in_kb = max_request_body_size_in_kb
        self.file_upload_limit_in_mb = file_upload_limit_in_mb
        self.exclusions = exclusions


class FirewallPolicyRule(_serialization.Model):
    """Properties of a rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ApplicationRule, NatRule, NetworkRule

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar rule_type: Rule Type. Required. Known values are: "ApplicationRule", "NetworkRule", and
     "NatRule".
    :vartype rule_type: str or ~azure.mgmt.network.models.FirewallPolicyRuleType
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
    }

    _subtype_map = {
        "rule_type": {"ApplicationRule": "ApplicationRule", "NatRule": "NatRule", "NetworkRule": "NetworkRule"}
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.rule_type: Optional[str] = None


class ApplicationRule(FirewallPolicyRule):
    """Rule of type application.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar rule_type: Rule Type. Required. Known values are: "ApplicationRule", "NetworkRule", and
     "NatRule".
    :vartype rule_type: str or ~azure.mgmt.network.models.FirewallPolicyRuleType
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses or Service Tags.
    :vartype destination_addresses: list[str]
    :ivar protocols: Array of Application Protocols.
    :vartype protocols: list[~azure.mgmt.network.models.FirewallPolicyRuleApplicationProtocol]
    :ivar target_fqdns: List of FQDNs for this rule.
    :vartype target_fqdns: list[str]
    :ivar target_urls: List of Urls for this rule condition.
    :vartype target_urls: list[str]
    :ivar fqdn_tags: List of FQDN Tags for this rule.
    :vartype fqdn_tags: list[str]
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    :ivar terminate_tls: Terminate TLS connections for this rule.
    :vartype terminate_tls: bool
    :ivar web_categories: List of destination azure web categories.
    :vartype web_categories: list[str]
    :ivar http_headers_to_insert: List of HTTP/S headers to insert.
    :vartype http_headers_to_insert:
     list[~azure.mgmt.network.models.FirewallPolicyHttpHeaderToInsert]
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[FirewallPolicyRuleApplicationProtocol]"},
        "target_fqdns": {"key": "targetFqdns", "type": "[str]"},
        "target_urls": {"key": "targetUrls", "type": "[str]"},
        "fqdn_tags": {"key": "fqdnTags", "type": "[str]"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
        "terminate_tls": {"key": "terminateTLS", "type": "bool"},
        "web_categories": {"key": "webCategories", "type": "[str]"},
        "http_headers_to_insert": {"key": "httpHeadersToInsert", "type": "[FirewallPolicyHttpHeaderToInsert]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[list[str]] = None,
        destination_addresses: Optional[list[str]] = None,
        protocols: Optional[list["_models.FirewallPolicyRuleApplicationProtocol"]] = None,
        target_fqdns: Optional[list[str]] = None,
        target_urls: Optional[list[str]] = None,
        fqdn_tags: Optional[list[str]] = None,
        source_ip_groups: Optional[list[str]] = None,
        terminate_tls: Optional[bool] = None,
        web_categories: Optional[list[str]] = None,
        http_headers_to_insert: Optional[list["_models.FirewallPolicyHttpHeaderToInsert"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses or Service Tags.
        :paramtype destination_addresses: list[str]
        :keyword protocols: Array of Application Protocols.
        :paramtype protocols: list[~azure.mgmt.network.models.FirewallPolicyRuleApplicationProtocol]
        :keyword target_fqdns: List of FQDNs for this rule.
        :paramtype target_fqdns: list[str]
        :keyword target_urls: List of Urls for this rule condition.
        :paramtype target_urls: list[str]
        :keyword fqdn_tags: List of FQDN Tags for this rule.
        :paramtype fqdn_tags: list[str]
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        :keyword terminate_tls: Terminate TLS connections for this rule.
        :paramtype terminate_tls: bool
        :keyword web_categories: List of destination azure web categories.
        :paramtype web_categories: list[str]
        :keyword http_headers_to_insert: List of HTTP/S headers to insert.
        :paramtype http_headers_to_insert:
         list[~azure.mgmt.network.models.FirewallPolicyHttpHeaderToInsert]
        """
        super().__init__(name=name, description=description, **kwargs)
        self.rule_type: str = "ApplicationRule"
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.protocols = protocols
        self.target_fqdns = target_fqdns
        self.target_urls = target_urls
        self.fqdn_tags = fqdn_tags
        self.source_ip_groups = source_ip_groups
        self.terminate_tls = terminate_tls
        self.web_categories = web_categories
        self.http_headers_to_insert = http_headers_to_insert


class ApplicationSecurityGroup(Resource):
    """An application security group in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the application security group resource. It
     uniquely identifies a resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application security group resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.resource_guid: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ApplicationSecurityGroupListResult(_serialization.Model):
    """A list of application security groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of application security groups.
    :vartype value: list[~azure.mgmt.network.models.ApplicationSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.ApplicationSecurityGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of application security groups.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AuthorizationListResult(_serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to
    an ExpressRouteCircuit.

    :ivar value: The authorizations in an ExpressRoute Circuit.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitAuthorization]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteCircuitAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The authorizations in an ExpressRoute Circuit.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutoApprovedPrivateLinkService(_serialization.Model):
    """The information of an AutoApprovedPrivateLinkService.

    :ivar private_link_service: The id of the private link service resource.
    :vartype private_link_service: str
    """

    _attribute_map = {
        "private_link_service": {"key": "privateLinkService", "type": "str"},
    }

    def __init__(self, *, private_link_service: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword private_link_service: The id of the private link service resource.
        :paramtype private_link_service: str
        """
        super().__init__(**kwargs)
        self.private_link_service = private_link_service


class AutoApprovedPrivateLinkServicesResult(_serialization.Model):
    """An array of private link service id that can be linked to a private end point with auto
    approved.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of auto approved private link service.
    :vartype value: list[~azure.mgmt.network.models.AutoApprovedPrivateLinkService]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutoApprovedPrivateLinkService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.AutoApprovedPrivateLinkService"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of auto approved private link service.
        :paramtype value: list[~azure.mgmt.network.models.AutoApprovedPrivateLinkService]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class Availability(_serialization.Model):
    """Availability of the metric.

    :ivar time_grain: The time grain of the availability.
    :vartype time_grain: str
    :ivar retention: The retention of the availability.
    :vartype retention: str
    :ivar blob_duration: Duration of the availability blob.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        retention: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: The time grain of the availability.
        :paramtype time_grain: str
        :keyword retention: The retention of the availability.
        :paramtype retention: str
        :keyword blob_duration: Duration of the availability blob.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention
        self.blob_duration = blob_duration


class AvailableDelegation(_serialization.Model):
    """The serviceName of an AvailableDelegation indicates a possible delegation for a subnet.

    :ivar name: The name of the AvailableDelegation resource.
    :vartype name: str
    :ivar id: A unique identifier of the AvailableDelegation resource.
    :vartype id: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_name: The name of the service and resource.
    :vartype service_name: str
    :ivar actions: The actions permitted to the service upon delegation.
    :vartype actions: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_name": {"key": "serviceName", "type": "str"},
        "actions": {"key": "actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        service_name: Optional[str] = None,
        actions: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the AvailableDelegation resource.
        :paramtype name: str
        :keyword id: A unique identifier of the AvailableDelegation resource.
        :paramtype id: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword service_name: The name of the service and resource.
        :paramtype service_name: str
        :keyword actions: The actions permitted to the service upon delegation.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.service_name = service_name
        self.actions = actions


class AvailableDelegationsResult(_serialization.Model):
    """An array of available delegations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of available delegations.
    :vartype value: list[~azure.mgmt.network.models.AvailableDelegation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableDelegation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.AvailableDelegation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of available delegations.
        :paramtype value: list[~azure.mgmt.network.models.AvailableDelegation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AvailablePrivateEndpointType(_serialization.Model):
    """The information of an AvailablePrivateEndpointType.

    :ivar name: The name of the service and resource.
    :vartype name: str
    :ivar id: A unique identifier of the AvailablePrivateEndpoint Type resource.
    :vartype id: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_name: The name of the service and resource.
    :vartype resource_name: str
    :ivar display_name: Display name of the resource.
    :vartype display_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        resource_name: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the service and resource.
        :paramtype name: str
        :keyword id: A unique identifier of the AvailablePrivateEndpoint Type resource.
        :paramtype id: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword resource_name: The name of the service and resource.
        :paramtype resource_name: str
        :keyword display_name: Display name of the resource.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.resource_name = resource_name
        self.display_name = display_name


class AvailablePrivateEndpointTypesResult(_serialization.Model):
    """An array of available PrivateEndpoint types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of available privateEndpoint type.
    :vartype value: list[~azure.mgmt.network.models.AvailablePrivateEndpointType]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailablePrivateEndpointType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.AvailablePrivateEndpointType"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of available privateEndpoint type.
        :paramtype value: list[~azure.mgmt.network.models.AvailablePrivateEndpointType]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AvailableProvidersList(_serialization.Model):
    """List of available countries with details.

    All required parameters must be populated in order to send to server.

    :ivar countries: List of available countries. Required.
    :vartype countries: list[~azure.mgmt.network.models.AvailableProvidersListCountry]
    """

    _validation = {
        "countries": {"required": True},
    }

    _attribute_map = {
        "countries": {"key": "countries", "type": "[AvailableProvidersListCountry]"},
    }

    def __init__(self, *, countries: list["_models.AvailableProvidersListCountry"], **kwargs: Any) -> None:
        """
        :keyword countries: List of available countries. Required.
        :paramtype countries: list[~azure.mgmt.network.models.AvailableProvidersListCountry]
        """
        super().__init__(**kwargs)
        self.countries = countries


class AvailableProvidersListCity(_serialization.Model):
    """City or town details.

    :ivar city_name: The city or town name.
    :vartype city_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    """

    _attribute_map = {
        "city_name": {"key": "cityName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
    }

    def __init__(
        self, *, city_name: Optional[str] = None, providers: Optional[list[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword city_name: The city or town name.
        :paramtype city_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        """
        super().__init__(**kwargs)
        self.city_name = city_name
        self.providers = providers


class AvailableProvidersListCountry(_serialization.Model):
    """Country details.

    :ivar country_name: The country name.
    :vartype country_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    :ivar states: List of available states in the country.
    :vartype states: list[~azure.mgmt.network.models.AvailableProvidersListState]
    """

    _attribute_map = {
        "country_name": {"key": "countryName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
        "states": {"key": "states", "type": "[AvailableProvidersListState]"},
    }

    def __init__(
        self,
        *,
        country_name: Optional[str] = None,
        providers: Optional[list[str]] = None,
        states: Optional[list["_models.AvailableProvidersListState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword country_name: The country name.
        :paramtype country_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        :keyword states: List of available states in the country.
        :paramtype states: list[~azure.mgmt.network.models.AvailableProvidersListState]
        """
        super().__init__(**kwargs)
        self.country_name = country_name
        self.providers = providers
        self.states = states


class AvailableProvidersListParameters(_serialization.Model):
    """Constraints that determine the list of available Internet service providers.

    :ivar azure_locations: A list of Azure regions.
    :vartype azure_locations: list[str]
    :ivar country: The country for available providers list.
    :vartype country: str
    :ivar state: The state for available providers list.
    :vartype state: str
    :ivar city: The city or town for available providers list.
    :vartype city: str
    """

    _attribute_map = {
        "azure_locations": {"key": "azureLocations", "type": "[str]"},
        "country": {"key": "country", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_locations: Optional[list[str]] = None,
        country: Optional[str] = None,
        state: Optional[str] = None,
        city: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_locations: A list of Azure regions.
        :paramtype azure_locations: list[str]
        :keyword country: The country for available providers list.
        :paramtype country: str
        :keyword state: The state for available providers list.
        :paramtype state: str
        :keyword city: The city or town for available providers list.
        :paramtype city: str
        """
        super().__init__(**kwargs)
        self.azure_locations = azure_locations
        self.country = country
        self.state = state
        self.city = city


class AvailableProvidersListState(_serialization.Model):
    """State details.

    :ivar state_name: The state name.
    :vartype state_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    :ivar cities: List of available cities or towns in the state.
    :vartype cities: list[~azure.mgmt.network.models.AvailableProvidersListCity]
    """

    _attribute_map = {
        "state_name": {"key": "stateName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
        "cities": {"key": "cities", "type": "[AvailableProvidersListCity]"},
    }

    def __init__(
        self,
        *,
        state_name: Optional[str] = None,
        providers: Optional[list[str]] = None,
        cities: Optional[list["_models.AvailableProvidersListCity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state_name: The state name.
        :paramtype state_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        :keyword cities: List of available cities or towns in the state.
        :paramtype cities: list[~azure.mgmt.network.models.AvailableProvidersListCity]
        """
        super().__init__(**kwargs)
        self.state_name = state_name
        self.providers = providers
        self.cities = cities


class AvailableServiceAlias(_serialization.Model):
    """The available service alias.

    :ivar name: The name of the service alias.
    :vartype name: str
    :ivar id: The ID of the service alias.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar resource_name: The resource name of the service alias.
    :vartype resource_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the service alias.
        :paramtype name: str
        :keyword id: The ID of the service alias.
        :paramtype id: str
        :keyword type: The type of the resource.
        :paramtype type: str
        :keyword resource_name: The resource name of the service alias.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.resource_name = resource_name


class AvailableServiceAliasesResult(_serialization.Model):
    """An array of available service aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of available service aliases.
    :vartype value: list[~azure.mgmt.network.models.AvailableServiceAlias]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableServiceAlias]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.AvailableServiceAlias"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of available service aliases.
        :paramtype value: list[~azure.mgmt.network.models.AvailableServiceAlias]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AzureAsyncOperationResult(_serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating
    whether it has succeeded, is in progress, or has failed. Note that this status is distinct from
    the HTTP status code returned for the Get Operation Status operation itself. If the
    asynchronous operation succeeded, the response body includes the HTTP status code for the
    successful request. If the asynchronous operation failed, the response body includes the HTTP
    status code for the failed request and error information regarding the failure.

    :ivar status: Status of the Azure async operation. Known values are: "InProgress", "Succeeded",
     and "Failed".
    :vartype status: str or ~azure.mgmt.network.models.NetworkOperationStatus
    :ivar error: Details of the error occurred during specified asynchronous operation.
    :vartype error: ~azure.mgmt.network.models.Error
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.NetworkOperationStatus"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the Azure async operation. Known values are: "InProgress",
         "Succeeded", and "Failed".
        :paramtype status: str or ~azure.mgmt.network.models.NetworkOperationStatus
        :keyword error: Details of the error occurred during specified asynchronous operation.
        :paramtype error: ~azure.mgmt.network.models.Error
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class AzureFirewall(Resource):
    """Azure Firewall resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of type local virtual network gateway.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar application_rule_collections: Collection of application rule collections used by Azure
     Firewall.
    :vartype application_rule_collections:
     list[~azure.mgmt.network.models.AzureFirewallApplicationRuleCollection]
    :ivar nat_rule_collections: Collection of NAT rule collections used by Azure Firewall.
    :vartype nat_rule_collections: list[~azure.mgmt.network.models.AzureFirewallNatRuleCollection]
    :ivar network_rule_collections: Collection of network rule collections used by Azure Firewall.
    :vartype network_rule_collections:
     list[~azure.mgmt.network.models.AzureFirewallNetworkRuleCollection]
    :ivar ip_configurations: IP configuration of the Azure Firewall resource.
    :vartype ip_configurations: list[~azure.mgmt.network.models.AzureFirewallIPConfiguration]
    :ivar management_ip_configuration: IP configuration of the Azure Firewall used for management
     traffic.
    :vartype management_ip_configuration: ~azure.mgmt.network.models.AzureFirewallIPConfiguration
    :ivar provisioning_state: The provisioning state of the Azure firewall resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar threat_intel_mode: The operation mode for Threat Intelligence. Known values are: "Alert",
     "Deny", and "Off".
    :vartype threat_intel_mode: str or ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
    :ivar virtual_hub: The virtualHub to which the firewall belongs.
    :vartype virtual_hub: ~azure.mgmt.network.models.SubResource
    :ivar firewall_policy: The firewallPolicy associated with this azure firewall.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    :ivar hub_ip_addresses: IP addresses associated with AzureFirewall.
    :vartype hub_ip_addresses: ~azure.mgmt.network.models.HubIPAddresses
    :ivar ip_groups: IpGroups associated with AzureFirewall.
    :vartype ip_groups: list[~azure.mgmt.network.models.AzureFirewallIpGroups]
    :ivar sku: The Azure Firewall Resource SKU.
    :vartype sku: ~azure.mgmt.network.models.AzureFirewallSku
    :ivar additional_properties: The additional properties used to further config this azure
     firewall.
    :vartype additional_properties: dict[str, str]
    :ivar autoscale_configuration: Properties to provide a custom autoscale configuration to this
     azure firewall.
    :vartype autoscale_configuration:
     ~azure.mgmt.network.models.AzureFirewallAutoscaleConfiguration
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "ip_groups": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "zones": {"key": "zones", "type": "[str]"},
        "etag": {"key": "etag", "type": "str"},
        "application_rule_collections": {
            "key": "properties.applicationRuleCollections",
            "type": "[AzureFirewallApplicationRuleCollection]",
        },
        "nat_rule_collections": {"key": "properties.natRuleCollections", "type": "[AzureFirewallNatRuleCollection]"},
        "network_rule_collections": {
            "key": "properties.networkRuleCollections",
            "type": "[AzureFirewallNetworkRuleCollection]",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[AzureFirewallIPConfiguration]"},
        "management_ip_configuration": {
            "key": "properties.managementIpConfiguration",
            "type": "AzureFirewallIPConfiguration",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "threat_intel_mode": {"key": "properties.threatIntelMode", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "SubResource"},
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "hub_ip_addresses": {"key": "properties.hubIPAddresses", "type": "HubIPAddresses"},
        "ip_groups": {"key": "properties.ipGroups", "type": "[AzureFirewallIpGroups]"},
        "sku": {"key": "properties.sku", "type": "AzureFirewallSku"},
        "additional_properties": {"key": "properties.additionalProperties", "type": "{str}"},
        "autoscale_configuration": {
            "key": "properties.autoscaleConfiguration",
            "type": "AzureFirewallAutoscaleConfiguration",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        zones: Optional[list[str]] = None,
        application_rule_collections: Optional[list["_models.AzureFirewallApplicationRuleCollection"]] = None,
        nat_rule_collections: Optional[list["_models.AzureFirewallNatRuleCollection"]] = None,
        network_rule_collections: Optional[list["_models.AzureFirewallNetworkRuleCollection"]] = None,
        ip_configurations: Optional[list["_models.AzureFirewallIPConfiguration"]] = None,
        management_ip_configuration: Optional["_models.AzureFirewallIPConfiguration"] = None,
        threat_intel_mode: Optional[Union[str, "_models.AzureFirewallThreatIntelMode"]] = None,
        virtual_hub: Optional["_models.SubResource"] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        hub_ip_addresses: Optional["_models.HubIPAddresses"] = None,
        sku: Optional["_models.AzureFirewallSku"] = None,
        additional_properties: Optional[dict[str, str]] = None,
        autoscale_configuration: Optional["_models.AzureFirewallAutoscaleConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of type local virtual network gateway.
        :paramtype extended_location: ~azure.mgmt.network.models.ExtendedLocation
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword application_rule_collections: Collection of application rule collections used by Azure
         Firewall.
        :paramtype application_rule_collections:
         list[~azure.mgmt.network.models.AzureFirewallApplicationRuleCollection]
        :keyword nat_rule_collections: Collection of NAT rule collections used by Azure Firewall.
        :paramtype nat_rule_collections:
         list[~azure.mgmt.network.models.AzureFirewallNatRuleCollection]
        :keyword network_rule_collections: Collection of network rule collections used by Azure
         Firewall.
        :paramtype network_rule_collections:
         list[~azure.mgmt.network.models.AzureFirewallNetworkRuleCollection]
        :keyword ip_configurations: IP configuration of the Azure Firewall resource.
        :paramtype ip_configurations: list[~azure.mgmt.network.models.AzureFirewallIPConfiguration]
        :keyword management_ip_configuration: IP configuration of the Azure Firewall used for
         management traffic.
        :paramtype management_ip_configuration: ~azure.mgmt.network.models.AzureFirewallIPConfiguration
        :keyword threat_intel_mode: The operation mode for Threat Intelligence. Known values are:
         "Alert", "Deny", and "Off".
        :paramtype threat_intel_mode: str or ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
        :keyword virtual_hub: The virtualHub to which the firewall belongs.
        :paramtype virtual_hub: ~azure.mgmt.network.models.SubResource
        :keyword firewall_policy: The firewallPolicy associated with this azure firewall.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        :keyword hub_ip_addresses: IP addresses associated with AzureFirewall.
        :paramtype hub_ip_addresses: ~azure.mgmt.network.models.HubIPAddresses
        :keyword sku: The Azure Firewall Resource SKU.
        :paramtype sku: ~azure.mgmt.network.models.AzureFirewallSku
        :keyword additional_properties: The additional properties used to further config this azure
         firewall.
        :paramtype additional_properties: dict[str, str]
        :keyword autoscale_configuration: Properties to provide a custom autoscale configuration to
         this azure firewall.
        :paramtype autoscale_configuration:
         ~azure.mgmt.network.models.AzureFirewallAutoscaleConfiguration
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.zones = zones
        self.etag: Optional[str] = None
        self.application_rule_collections = application_rule_collections
        self.nat_rule_collections = nat_rule_collections
        self.network_rule_collections = network_rule_collections
        self.ip_configurations = ip_configurations
        self.management_ip_configuration = management_ip_configuration
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.threat_intel_mode = threat_intel_mode
        self.virtual_hub = virtual_hub
        self.firewall_policy = firewall_policy
        self.hub_ip_addresses = hub_ip_addresses
        self.ip_groups: Optional[list["_models.AzureFirewallIpGroups"]] = None
        self.sku = sku
        self.additional_properties = additional_properties
        self.autoscale_configuration = autoscale_configuration


class AzureFirewallApplicationRule(_serialization.Model):
    """Properties of an application rule.

    :ivar name: Name of the application rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar protocols: Array of ApplicationRuleProtocols.
    :vartype protocols: list[~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocol]
    :ivar target_fqdns: List of FQDNs for this rule.
    :vartype target_fqdns: list[str]
    :ivar fqdn_tags: List of FQDN Tags for this rule.
    :vartype fqdn_tags: list[str]
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[AzureFirewallApplicationRuleProtocol]"},
        "target_fqdns": {"key": "targetFqdns", "type": "[str]"},
        "fqdn_tags": {"key": "fqdnTags", "type": "[str]"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[list[str]] = None,
        protocols: Optional[list["_models.AzureFirewallApplicationRuleProtocol"]] = None,
        target_fqdns: Optional[list[str]] = None,
        fqdn_tags: Optional[list[str]] = None,
        source_ip_groups: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the application rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword protocols: Array of ApplicationRuleProtocols.
        :paramtype protocols: list[~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocol]
        :keyword target_fqdns: List of FQDNs for this rule.
        :paramtype target_fqdns: list[str]
        :keyword fqdn_tags: List of FQDN Tags for this rule.
        :paramtype fqdn_tags: list[str]
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.protocols = protocols
        self.target_fqdns = target_fqdns
        self.fqdn_tags = fqdn_tags
        self.source_ip_groups = source_ip_groups


class AzureFirewallApplicationRuleCollection(SubResource):
    """Application rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the application rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a rule collection.
    :vartype action: ~azure.mgmt.network.models.AzureFirewallRCAction
    :ivar rules: Collection of rules used by a application rule collection.
    :vartype rules: list[~azure.mgmt.network.models.AzureFirewallApplicationRule]
    :ivar provisioning_state: The provisioning state of the application rule collection resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallApplicationRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallRCAction"] = None,
        rules: Optional[list["_models.AzureFirewallApplicationRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the application rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a rule collection.
        :paramtype action: ~azure.mgmt.network.models.AzureFirewallRCAction
        :keyword rules: Collection of rules used by a application rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.AzureFirewallApplicationRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class AzureFirewallApplicationRuleProtocol(_serialization.Model):
    """Properties of the application rule protocol.

    :ivar protocol_type: Protocol type. Known values are: "Http", "Https", and "Mssql".
    :vartype protocol_type: str or
     ~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocolType
    :ivar port: Port number for the protocol, cannot be greater than 64000. This field is optional.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 64000, "minimum": 0},
    }

    _attribute_map = {
        "protocol_type": {"key": "protocolType", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.AzureFirewallApplicationRuleProtocolType"]] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_type: Protocol type. Known values are: "Http", "Https", and "Mssql".
        :paramtype protocol_type: str or
         ~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocolType
        :keyword port: Port number for the protocol, cannot be greater than 64000. This field is
         optional.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.protocol_type = protocol_type
        self.port = port


class AzureFirewallAutoscaleConfiguration(_serialization.Model):
    """Azure Firewall Autoscale Configuration parameters.

    :ivar min_capacity: The minimum number of capacity units for this azure firewall. Use null to
     reset the value to the service default.
    :vartype min_capacity: int
    :ivar max_capacity: The maximum number of capacity units for this azure firewall. Use null to
     reset the value to the service default.
    :vartype max_capacity: int
    """

    _validation = {
        "min_capacity": {"minimum": 2},
        "max_capacity": {"minimum": 2},
    }

    _attribute_map = {
        "min_capacity": {"key": "minCapacity", "type": "int"},
        "max_capacity": {"key": "maxCapacity", "type": "int"},
    }

    def __init__(
        self, *, min_capacity: Optional[int] = None, max_capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword min_capacity: The minimum number of capacity units for this azure firewall. Use null
         to reset the value to the service default.
        :paramtype min_capacity: int
        :keyword max_capacity: The maximum number of capacity units for this azure firewall. Use null
         to reset the value to the service default.
        :paramtype max_capacity: int
        """
        super().__init__(**kwargs)
        self.min_capacity = min_capacity
        self.max_capacity = max_capacity


class AzureFirewallFqdnTag(Resource):
    """Azure Firewall FQDN Tag Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the Azure firewall FQDN tag resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar fqdn_tag_name: The name of this FQDN Tag.
    :vartype fqdn_tag_name: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "fqdn_tag_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "fqdn_tag_name": {"key": "properties.fqdnTagName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.fqdn_tag_name: Optional[str] = None


class AzureFirewallFqdnTagListResult(_serialization.Model):
    """Response for ListAzureFirewallFqdnTags API service call.

    :ivar value: List of Azure Firewall FQDN Tags in a resource group.
    :vartype value: list[~azure.mgmt.network.models.AzureFirewallFqdnTag]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureFirewallFqdnTag]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.AzureFirewallFqdnTag"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Firewall FQDN Tags in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.AzureFirewallFqdnTag]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureFirewallIPConfiguration(SubResource):
    """IP configuration of an Azure Firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_ip_address: The Firewall Internal Load Balancer IP to be used as the next hop in
     User Defined Routes.
    :vartype private_ip_address: str
    :ivar subnet: Reference to the subnet resource. This resource must be named
     'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar public_ip_address: Reference to the PublicIP resource. This field is a mandatory input if
     subnet is not null.
    :vartype public_ip_address: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the Azure firewall IP configuration
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "private_ip_address": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword subnet: Reference to the subnet resource. This resource must be named
         'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword public_ip_address: Reference to the PublicIP resource. This field is a mandatory input
         if subnet is not null.
        :paramtype public_ip_address: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.private_ip_address: Optional[str] = None
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class AzureFirewallIpGroups(_serialization.Model):
    """IpGroups associated with azure firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar change_number: The iteration number.
    :vartype change_number: str
    """

    _validation = {
        "id": {"readonly": True},
        "change_number": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "change_number": {"key": "changeNumber", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.change_number: Optional[str] = None


class AzureFirewallListResult(_serialization.Model):
    """Response for ListAzureFirewalls API service call.

    :ivar value: List of Azure Firewalls in a resource group.
    :vartype value: list[~azure.mgmt.network.models.AzureFirewall]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureFirewall]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.AzureFirewall"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Firewalls in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.AzureFirewall]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureFirewallNatRCAction(_serialization.Model):
    """AzureFirewall NAT Rule Collection Action.

    :ivar type: The type of action. Known values are: "Snat" and "Dnat".
    :vartype type: str or ~azure.mgmt.network.models.AzureFirewallNatRCActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.AzureFirewallNatRCActionType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of action. Known values are: "Snat" and "Dnat".
        :paramtype type: str or ~azure.mgmt.network.models.AzureFirewallNatRCActionType
        """
        super().__init__(**kwargs)
        self.type = type


class AzureFirewallNatRule(_serialization.Model):
    """Properties of a NAT rule.

    :ivar name: Name of the NAT rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses for this rule. Supports IP
     ranges, prefixes, and service tags.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports.
    :vartype destination_ports: list[str]
    :ivar protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
    :vartype protocols: list[str or ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
    :ivar translated_address: The translated address for this NAT rule.
    :vartype translated_address: str
    :ivar translated_port: The translated port for this NAT rule.
    :vartype translated_port: str
    :ivar translated_fqdn: The translated FQDN for this NAT rule.
    :vartype translated_fqdn: str
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "translated_address": {"key": "translatedAddress", "type": "str"},
        "translated_port": {"key": "translatedPort", "type": "str"},
        "translated_fqdn": {"key": "translatedFqdn", "type": "str"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[list[str]] = None,
        destination_addresses: Optional[list[str]] = None,
        destination_ports: Optional[list[str]] = None,
        protocols: Optional[list[Union[str, "_models.AzureFirewallNetworkRuleProtocol"]]] = None,
        translated_address: Optional[str] = None,
        translated_port: Optional[str] = None,
        translated_fqdn: Optional[str] = None,
        source_ip_groups: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the NAT rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses for this rule. Supports IP
         ranges, prefixes, and service tags.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports.
        :paramtype destination_ports: list[str]
        :keyword protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        :paramtype protocols: list[str or ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
        :keyword translated_address: The translated address for this NAT rule.
        :paramtype translated_address: str
        :keyword translated_port: The translated port for this NAT rule.
        :paramtype translated_port: str
        :keyword translated_fqdn: The translated FQDN for this NAT rule.
        :paramtype translated_fqdn: str
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.protocols = protocols
        self.translated_address = translated_address
        self.translated_port = translated_port
        self.translated_fqdn = translated_fqdn
        self.source_ip_groups = source_ip_groups


class AzureFirewallNatRuleCollection(SubResource):
    """NAT rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the NAT rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a NAT rule collection.
    :vartype action: ~azure.mgmt.network.models.AzureFirewallNatRCAction
    :ivar rules: Collection of rules used by a NAT rule collection.
    :vartype rules: list[~azure.mgmt.network.models.AzureFirewallNatRule]
    :ivar provisioning_state: The provisioning state of the NAT rule collection resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallNatRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallNatRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallNatRCAction"] = None,
        rules: Optional[list["_models.AzureFirewallNatRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the NAT rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a NAT rule collection.
        :paramtype action: ~azure.mgmt.network.models.AzureFirewallNatRCAction
        :keyword rules: Collection of rules used by a NAT rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.AzureFirewallNatRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class AzureFirewallNetworkRule(_serialization.Model):
    """Properties of the network rule.

    :ivar name: Name of the network rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar protocols: Array of AzureFirewallNetworkRuleProtocols.
    :vartype protocols: list[str or ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports.
    :vartype destination_ports: list[str]
    :ivar destination_fqdns: List of destination FQDNs.
    :vartype destination_fqdns: list[str]
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    :ivar destination_ip_groups: List of destination IpGroups for this rule.
    :vartype destination_ip_groups: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
        "destination_fqdns": {"key": "destinationFqdns", "type": "[str]"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
        "destination_ip_groups": {"key": "destinationIpGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        protocols: Optional[list[Union[str, "_models.AzureFirewallNetworkRuleProtocol"]]] = None,
        source_addresses: Optional[list[str]] = None,
        destination_addresses: Optional[list[str]] = None,
        destination_ports: Optional[list[str]] = None,
        destination_fqdns: Optional[list[str]] = None,
        source_ip_groups: Optional[list[str]] = None,
        destination_ip_groups: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the network rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword protocols: Array of AzureFirewallNetworkRuleProtocols.
        :paramtype protocols: list[str or ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports.
        :paramtype destination_ports: list[str]
        :keyword destination_fqdns: List of destination FQDNs.
        :paramtype destination_fqdns: list[str]
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        :keyword destination_ip_groups: List of destination IpGroups for this rule.
        :paramtype destination_ip_groups: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.protocols = protocols
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.destination_fqdns = destination_fqdns
        self.source_ip_groups = source_ip_groups
        self.destination_ip_groups = destination_ip_groups


class AzureFirewallNetworkRuleCollection(SubResource):
    """Network rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the network rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a rule collection.
    :vartype action: ~azure.mgmt.network.models.AzureFirewallRCAction
    :ivar rules: Collection of rules used by a network rule collection.
    :vartype rules: list[~azure.mgmt.network.models.AzureFirewallNetworkRule]
    :ivar provisioning_state: The provisioning state of the network rule collection resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallNetworkRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallRCAction"] = None,
        rules: Optional[list["_models.AzureFirewallNetworkRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the network rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a rule collection.
        :paramtype action: ~azure.mgmt.network.models.AzureFirewallRCAction
        :keyword rules: Collection of rules used by a network rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.AzureFirewallNetworkRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class AzureFirewallPacketCaptureFlags(_serialization.Model):
    """Properties of the AzureFirewallRCAction.

    :ivar type: Flags to capture. Known values are: "fin", "syn", "rst", "push", "ack", and "urg".
    :vartype type: str or ~azure.mgmt.network.models.AzureFirewallPacketCaptureFlagsType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.AzureFirewallPacketCaptureFlagsType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: Flags to capture. Known values are: "fin", "syn", "rst", "push", "ack", and
         "urg".
        :paramtype type: str or ~azure.mgmt.network.models.AzureFirewallPacketCaptureFlagsType
        """
        super().__init__(**kwargs)
        self.type = type


class AzureFirewallPacketCaptureResponse(_serialization.Model):
    """Response of an Azure Firewall Packet Capture Operation.

    :ivar status_code: The response code of the performed packet capture operation. Known values
     are: "NotImplemented", "AzureFirewallPacketCaptureStartSucceeded",
     "AzureFirewallPacketCaptureStartFailed", "AzureFirewallPacketCaptureStartFailedToUpload",
     "AzureFirewallPacketCaptureStartFailure", "AzureFirewallPacketCaptureInProgress",
     "AzureFirewallPacketCaptureNotInProgress", "AzureFirewallPacketCaptureStopSucceeded",
     "AzureFirewallPacketCaptureFailed", and "AzureFirewallPacketCaptureCompleted".
    :vartype status_code: str or ~azure.mgmt.network.models.AzureFirewallPacketCaptureResponseCode
    :ivar message: Localized Message String of The Result Of The Azure Firewall Packet Capture
     Operation.
    :vartype message: str
    """

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "_models.AzureFirewallPacketCaptureResponseCode"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status_code: The response code of the performed packet capture operation. Known values
         are: "NotImplemented", "AzureFirewallPacketCaptureStartSucceeded",
         "AzureFirewallPacketCaptureStartFailed", "AzureFirewallPacketCaptureStartFailedToUpload",
         "AzureFirewallPacketCaptureStartFailure", "AzureFirewallPacketCaptureInProgress",
         "AzureFirewallPacketCaptureNotInProgress", "AzureFirewallPacketCaptureStopSucceeded",
         "AzureFirewallPacketCaptureFailed", and "AzureFirewallPacketCaptureCompleted".
        :paramtype status_code: str or
         ~azure.mgmt.network.models.AzureFirewallPacketCaptureResponseCode
        :keyword message: Localized Message String of The Result Of The Azure Firewall Packet Capture
         Operation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.status_code = status_code
        self.message = message


class AzureFirewallPacketCaptureRule(_serialization.Model):
    """Group of src/dest ips and ports to be captured.

    :ivar sources: List of source IP addresses/subnets to be captured.
    :vartype sources: list[str]
    :ivar destinations: List of destination IP addresses/subnets to be captured.
    :vartype destinations: list[str]
    :ivar destination_ports: List of ports to be captured.
    :vartype destination_ports: list[str]
    """

    _attribute_map = {
        "sources": {"key": "sources", "type": "[str]"},
        "destinations": {"key": "destinations", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        sources: Optional[list[str]] = None,
        destinations: Optional[list[str]] = None,
        destination_ports: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sources: List of source IP addresses/subnets to be captured.
        :paramtype sources: list[str]
        :keyword destinations: List of destination IP addresses/subnets to be captured.
        :paramtype destinations: list[str]
        :keyword destination_ports: List of ports to be captured.
        :paramtype destination_ports: list[str]
        """
        super().__init__(**kwargs)
        self.sources = sources
        self.destinations = destinations
        self.destination_ports = destination_ports


class AzureFirewallPublicIPAddress(_serialization.Model):
    """Public IP Address associated with azure firewall.

    :ivar address: Public IP Address value.
    :vartype address: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
    }

    def __init__(self, *, address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address: Public IP Address value.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.address = address


class AzureFirewallRCAction(_serialization.Model):
    """Properties of the AzureFirewallRCAction.

    :ivar type: The type of action. Known values are: "Allow" and "Deny".
    :vartype type: str or ~azure.mgmt.network.models.AzureFirewallRCActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.AzureFirewallRCActionType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of action. Known values are: "Allow" and "Deny".
        :paramtype type: str or ~azure.mgmt.network.models.AzureFirewallRCActionType
        """
        super().__init__(**kwargs)
        self.type = type


class AzureFirewallSku(_serialization.Model):
    """SKU of an Azure Firewall.

    :ivar name: Name of an Azure Firewall SKU. Known values are: "AZFW_VNet" and "AZFW_Hub".
    :vartype name: str or ~azure.mgmt.network.models.AzureFirewallSkuName
    :ivar tier: Tier of an Azure Firewall. Known values are: "Standard", "Premium", and "Basic".
    :vartype tier: str or ~azure.mgmt.network.models.AzureFirewallSkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.AzureFirewallSkuName"]] = None,
        tier: Optional[Union[str, "_models.AzureFirewallSkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of an Azure Firewall SKU. Known values are: "AZFW_VNet" and "AZFW_Hub".
        :paramtype name: str or ~azure.mgmt.network.models.AzureFirewallSkuName
        :keyword tier: Tier of an Azure Firewall. Known values are: "Standard", "Premium", and "Basic".
        :paramtype tier: str or ~azure.mgmt.network.models.AzureFirewallSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class AzureReachabilityReport(_serialization.Model):
    """Azure reachability report details.

    All required parameters must be populated in order to send to server.

    :ivar aggregation_level: The aggregation level of Azure reachability report. Can be Country,
     State or City. Required.
    :vartype aggregation_level: str
    :ivar provider_location: Parameters that define a geographic location. Required.
    :vartype provider_location: ~azure.mgmt.network.models.AzureReachabilityReportLocation
    :ivar reachability_report: List of Azure reachability report items. Required.
    :vartype reachability_report: list[~azure.mgmt.network.models.AzureReachabilityReportItem]
    """

    _validation = {
        "aggregation_level": {"required": True},
        "provider_location": {"required": True},
        "reachability_report": {"required": True},
    }

    _attribute_map = {
        "aggregation_level": {"key": "aggregationLevel", "type": "str"},
        "provider_location": {"key": "providerLocation", "type": "AzureReachabilityReportLocation"},
        "reachability_report": {"key": "reachabilityReport", "type": "[AzureReachabilityReportItem]"},
    }

    def __init__(
        self,
        *,
        aggregation_level: str,
        provider_location: "_models.AzureReachabilityReportLocation",
        reachability_report: list["_models.AzureReachabilityReportItem"],
        **kwargs: Any
    ) -> None:
        """
        :keyword aggregation_level: The aggregation level of Azure reachability report. Can be Country,
         State or City. Required.
        :paramtype aggregation_level: str
        :keyword provider_location: Parameters that define a geographic location. Required.
        :paramtype provider_location: ~azure.mgmt.network.models.AzureReachabilityReportLocation
        :keyword reachability_report: List of Azure reachability report items. Required.
        :paramtype reachability_report: list[~azure.mgmt.network.models.AzureReachabilityReportItem]
        """
        super().__init__(**kwargs)
        self.aggregation_level = aggregation_level
        self.provider_location = provider_location
        self.reachability_report = reachability_report


class AzureReachabilityReportItem(_serialization.Model):
    """Azure reachability report details for a given provider location.

    :ivar provider: The Internet service provider.
    :vartype provider: str
    :ivar azure_location: The Azure region.
    :vartype azure_location: str
    :ivar latencies: List of latency details for each of the time series.
    :vartype latencies: list[~azure.mgmt.network.models.AzureReachabilityReportLatencyInfo]
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "azure_location": {"key": "azureLocation", "type": "str"},
        "latencies": {"key": "latencies", "type": "[AzureReachabilityReportLatencyInfo]"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        azure_location: Optional[str] = None,
        latencies: Optional[list["_models.AzureReachabilityReportLatencyInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The Internet service provider.
        :paramtype provider: str
        :keyword azure_location: The Azure region.
        :paramtype azure_location: str
        :keyword latencies: List of latency details for each of the time series.
        :paramtype latencies: list[~azure.mgmt.network.models.AzureReachabilityReportLatencyInfo]
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.azure_location = azure_location
        self.latencies = latencies


class AzureReachabilityReportLatencyInfo(_serialization.Model):
    """Details on latency for a time series.

    :ivar time_stamp: The time stamp.
    :vartype time_stamp: ~datetime.datetime
    :ivar score: The relative latency score between 1 and 100, higher values indicating a faster
     connection.
    :vartype score: int
    """

    _validation = {
        "score": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "score": {"key": "score", "type": "int"},
    }

    def __init__(
        self, *, time_stamp: Optional[datetime.datetime] = None, score: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword time_stamp: The time stamp.
        :paramtype time_stamp: ~datetime.datetime
        :keyword score: The relative latency score between 1 and 100, higher values indicating a faster
         connection.
        :paramtype score: int
        """
        super().__init__(**kwargs)
        self.time_stamp = time_stamp
        self.score = score


class AzureReachabilityReportLocation(_serialization.Model):
    """Parameters that define a geographic location.

    All required parameters must be populated in order to send to server.

    :ivar country: The name of the country. Required.
    :vartype country: str
    :ivar state: The name of the state.
    :vartype state: str
    :ivar city: The name of the city or town.
    :vartype city: str
    """

    _validation = {
        "country": {"required": True},
    }

    _attribute_map = {
        "country": {"key": "country", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(self, *, country: str, state: Optional[str] = None, city: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword country: The name of the country. Required.
        :paramtype country: str
        :keyword state: The name of the state.
        :paramtype state: str
        :keyword city: The name of the city or town.
        :paramtype city: str
        """
        super().__init__(**kwargs)
        self.country = country
        self.state = state
        self.city = city


class AzureReachabilityReportParameters(_serialization.Model):
    """Geographic and time constraints for Azure reachability report.

    All required parameters must be populated in order to send to server.

    :ivar provider_location: Parameters that define a geographic location. Required.
    :vartype provider_location: ~azure.mgmt.network.models.AzureReachabilityReportLocation
    :ivar providers: List of Internet service providers.
    :vartype providers: list[str]
    :ivar azure_locations: Optional Azure regions to scope the query to.
    :vartype azure_locations: list[str]
    :ivar start_time: The start time for the Azure reachability report. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time for the Azure reachability report. Required.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "provider_location": {"required": True},
        "start_time": {"required": True},
        "end_time": {"required": True},
    }

    _attribute_map = {
        "provider_location": {"key": "providerLocation", "type": "AzureReachabilityReportLocation"},
        "providers": {"key": "providers", "type": "[str]"},
        "azure_locations": {"key": "azureLocations", "type": "[str]"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        provider_location: "_models.AzureReachabilityReportLocation",
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        providers: Optional[list[str]] = None,
        azure_locations: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider_location: Parameters that define a geographic location. Required.
        :paramtype provider_location: ~azure.mgmt.network.models.AzureReachabilityReportLocation
        :keyword providers: List of Internet service providers.
        :paramtype providers: list[str]
        :keyword azure_locations: Optional Azure regions to scope the query to.
        :paramtype azure_locations: list[str]
        :keyword start_time: The start time for the Azure reachability report. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time for the Azure reachability report. Required.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.provider_location = provider_location
        self.providers = providers
        self.azure_locations = azure_locations
        self.start_time = start_time
        self.end_time = end_time


class AzureWebCategory(_serialization.Model):
    """Azure Web Category Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar group: The name of the group that the category belongs to.
    :vartype group: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "group": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "group": {"key": "properties.group", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.group: Optional[str] = None


class AzureWebCategoryListResult(_serialization.Model):
    """Response for ListAzureWebCategories API service call.

    :ivar value: List of Azure Web Categories for a given Subscription.
    :vartype value: list[~azure.mgmt.network.models.AzureWebCategory]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureWebCategory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.AzureWebCategory"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Web Categories for a given Subscription.
        :paramtype value: list[~azure.mgmt.network.models.AzureWebCategory]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BackendAddressInboundNatRulePortMappings(_serialization.Model):
    """The response for a QueryInboundNatRulePortMapping API.

    :ivar inbound_nat_rule_port_mappings: Collection of inbound NAT rule port mappings.
    :vartype inbound_nat_rule_port_mappings:
     list[~azure.mgmt.network.models.InboundNatRulePortMapping]
    """

    _attribute_map = {
        "inbound_nat_rule_port_mappings": {"key": "inboundNatRulePortMappings", "type": "[InboundNatRulePortMapping]"},
    }

    def __init__(
        self,
        *,
        inbound_nat_rule_port_mappings: Optional[list["_models.InboundNatRulePortMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword inbound_nat_rule_port_mappings: Collection of inbound NAT rule port mappings.
        :paramtype inbound_nat_rule_port_mappings:
         list[~azure.mgmt.network.models.InboundNatRulePortMapping]
        """
        super().__init__(**kwargs)
        self.inbound_nat_rule_port_mappings = inbound_nat_rule_port_mappings


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of backend address pools
     used by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: The location of the backend address pool.
    :vartype location: str
    :ivar tunnel_interfaces: An array of gateway load balancer tunnel interfaces.
    :vartype tunnel_interfaces: list[~azure.mgmt.network.models.GatewayLoadBalancerTunnelInterface]
    :ivar load_balancer_backend_addresses: An array of backend addresses.
    :vartype load_balancer_backend_addresses:
     list[~azure.mgmt.network.models.LoadBalancerBackendAddress]
    :ivar backend_ip_configurations: An array of references to IP addresses defined in network
     interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar outbound_rule: A reference to an outbound rule that uses this backend address pool.
    :vartype outbound_rule: ~azure.mgmt.network.models.SubResource
    :ivar outbound_rules: An array of references to outbound rules that use this backend address
     pool.
    :vartype outbound_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar inbound_nat_rules: An array of references to inbound NAT rules that use this backend
     address pool.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar drain_period_in_seconds: Amount of seconds Load Balancer waits for before sending RESET
     to client and backend address.
    :vartype drain_period_in_seconds: int
    :ivar virtual_network: A reference to a virtual network.
    :vartype virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar sync_mode: Backend address synchronous mode for the backend pool. Known values are:
     "Automatic" and "Manual".
    :vartype sync_mode: str or ~azure.mgmt.network.models.SyncMode
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "backend_ip_configurations": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "outbound_rule": {"readonly": True},
        "outbound_rules": {"readonly": True},
        "inbound_nat_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "tunnel_interfaces": {"key": "properties.tunnelInterfaces", "type": "[GatewayLoadBalancerTunnelInterface]"},
        "load_balancer_backend_addresses": {
            "key": "properties.loadBalancerBackendAddresses",
            "type": "[LoadBalancerBackendAddress]",
        },
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "outbound_rule": {"key": "properties.outboundRule", "type": "SubResource"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[SubResource]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "drain_period_in_seconds": {"key": "properties.drainPeriodInSeconds", "type": "int"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "SubResource"},
        "sync_mode": {"key": "properties.syncMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        location: Optional[str] = None,
        tunnel_interfaces: Optional[list["_models.GatewayLoadBalancerTunnelInterface"]] = None,
        load_balancer_backend_addresses: Optional[list["_models.LoadBalancerBackendAddress"]] = None,
        drain_period_in_seconds: Optional[int] = None,
        virtual_network: Optional["_models.SubResource"] = None,
        sync_mode: Optional[Union[str, "_models.SyncMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of backend address pools
         used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword location: The location of the backend address pool.
        :paramtype location: str
        :keyword tunnel_interfaces: An array of gateway load balancer tunnel interfaces.
        :paramtype tunnel_interfaces:
         list[~azure.mgmt.network.models.GatewayLoadBalancerTunnelInterface]
        :keyword load_balancer_backend_addresses: An array of backend addresses.
        :paramtype load_balancer_backend_addresses:
         list[~azure.mgmt.network.models.LoadBalancerBackendAddress]
        :keyword drain_period_in_seconds: Amount of seconds Load Balancer waits for before sending
         RESET to client and backend address.
        :paramtype drain_period_in_seconds: int
        :keyword virtual_network: A reference to a virtual network.
        :paramtype virtual_network: ~azure.mgmt.network.models.SubResource
        :keyword sync_mode: Backend address synchronous mode for the backend pool. Known values are:
         "Automatic" and "Manual".
        :paramtype sync_mode: str or ~azure.mgmt.network.models.SyncMode
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tunnel_interfaces = tunnel_interfaces
        self.load_balancer_backend_addresses = load_balancer_backend_addresses
        self.backend_ip_configurations: Optional[list["_models.NetworkInterfaceIPConfiguration"]] = None
        self.load_balancing_rules: Optional[list["_models.SubResource"]] = None
        self.outbound_rule: Optional["_models.SubResource"] = None
        self.outbound_rules: Optional[list["_models.SubResource"]] = None
        self.inbound_nat_rules: Optional[list["_models.SubResource"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.drain_period_in_seconds = drain_period_in_seconds
        self.virtual_network = virtual_network
        self.sync_mode = sync_mode


class BastionActiveSession(_serialization.Model):
    """The session detail for a target.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar session_id: A unique id for the session.
    :vartype session_id: str
    :ivar start_time: The time when the session started.
    :vartype start_time: JSON
    :ivar target_subscription_id: The subscription id for the target virtual machine.
    :vartype target_subscription_id: str
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar target_host_name: The host name of the target.
    :vartype target_host_name: str
    :ivar target_resource_group: The resource group of the target.
    :vartype target_resource_group: str
    :ivar user_name: The user name who is active on this session.
    :vartype user_name: str
    :ivar target_ip_address: The IP Address of the target.
    :vartype target_ip_address: str
    :ivar protocol: The protocol used to connect to the target. Known values are: "SSH" and "RDP".
    :vartype protocol: str or ~azure.mgmt.network.models.BastionConnectProtocol
    :ivar target_resource_id: The resource id of the target.
    :vartype target_resource_id: str
    :ivar session_duration_in_mins: Duration in mins the session has been active.
    :vartype session_duration_in_mins: float
    """

    _validation = {
        "session_id": {"readonly": True},
        "start_time": {"readonly": True},
        "target_subscription_id": {"readonly": True},
        "resource_type": {"readonly": True},
        "target_host_name": {"readonly": True},
        "target_resource_group": {"readonly": True},
        "user_name": {"readonly": True},
        "target_ip_address": {"readonly": True},
        "protocol": {"readonly": True},
        "target_resource_id": {"readonly": True},
        "session_duration_in_mins": {"readonly": True},
    }

    _attribute_map = {
        "session_id": {"key": "sessionId", "type": "str"},
        "start_time": {"key": "startTime", "type": "object"},
        "target_subscription_id": {"key": "targetSubscriptionId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "target_host_name": {"key": "targetHostName", "type": "str"},
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "target_ip_address": {"key": "targetIpAddress", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "session_duration_in_mins": {"key": "sessionDurationInMins", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.session_id: Optional[str] = None
        self.start_time: Optional[JSON] = None
        self.target_subscription_id: Optional[str] = None
        self.resource_type: Optional[str] = None
        self.target_host_name: Optional[str] = None
        self.target_resource_group: Optional[str] = None
        self.user_name: Optional[str] = None
        self.target_ip_address: Optional[str] = None
        self.protocol: Optional[Union[str, "_models.BastionConnectProtocol"]] = None
        self.target_resource_id: Optional[str] = None
        self.session_duration_in_mins: Optional[float] = None


class BastionActiveSessionListResult(_serialization.Model):
    """Response for GetActiveSessions.

    :ivar value: List of active sessions on the bastion.
    :vartype value: list[~azure.mgmt.network.models.BastionActiveSession]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BastionActiveSession]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.BastionActiveSession"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of active sessions on the bastion.
        :paramtype value: list[~azure.mgmt.network.models.BastionActiveSession]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BastionHost(Resource):
    """Bastion Host resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar sku: The sku of this Bastion Host.
    :vartype sku: ~azure.mgmt.network.models.Sku
    :ivar ip_configurations: IP configuration of the Bastion Host resource.
    :vartype ip_configurations: list[~azure.mgmt.network.models.BastionHostIPConfiguration]
    :ivar dns_name: FQDN for the endpoint on which bastion host is accessible.
    :vartype dns_name: str
    :ivar virtual_network: Reference to an existing virtual network required for Developer Bastion
     Host only.
    :vartype virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar network_acls:
    :vartype network_acls: ~azure.mgmt.network.models.BastionHostPropertiesFormatNetworkAcls
    :ivar provisioning_state: The provisioning state of the bastion host resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar scale_units: The scale units for the Bastion Host resource.
    :vartype scale_units: int
    :ivar disable_copy_paste: Enable/Disable Copy/Paste feature of the Bastion Host resource.
    :vartype disable_copy_paste: bool
    :ivar enable_file_copy: Enable/Disable File Copy feature of the Bastion Host resource.
    :vartype enable_file_copy: bool
    :ivar enable_ip_connect: Enable/Disable IP Connect feature of the Bastion Host resource.
    :vartype enable_ip_connect: bool
    :ivar enable_shareable_link: Enable/Disable Shareable Link of the Bastion Host resource.
    :vartype enable_shareable_link: bool
    :ivar enable_tunneling: Enable/Disable Tunneling feature of the Bastion Host resource.
    :vartype enable_tunneling: bool
    :ivar enable_kerberos: Enable/Disable Kerberos feature of the Bastion Host resource.
    :vartype enable_kerberos: bool
    :ivar enable_session_recording: Enable/Disable Session Recording feature of the Bastion Host
     resource.
    :vartype enable_session_recording: bool
    :ivar enable_private_only_bastion: Enable/Disable Private Only feature of the Bastion Host
     resource.
    :vartype enable_private_only_bastion: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "scale_units": {"maximum": 50, "minimum": 2},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "etag": {"key": "etag", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[BastionHostIPConfiguration]"},
        "dns_name": {"key": "properties.dnsName", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "SubResource"},
        "network_acls": {"key": "properties.networkAcls", "type": "BastionHostPropertiesFormatNetworkAcls"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "scale_units": {"key": "properties.scaleUnits", "type": "int"},
        "disable_copy_paste": {"key": "properties.disableCopyPaste", "type": "bool"},
        "enable_file_copy": {"key": "properties.enableFileCopy", "type": "bool"},
        "enable_ip_connect": {"key": "properties.enableIpConnect", "type": "bool"},
        "enable_shareable_link": {"key": "properties.enableShareableLink", "type": "bool"},
        "enable_tunneling": {"key": "properties.enableTunneling", "type": "bool"},
        "enable_kerberos": {"key": "properties.enableKerberos", "type": "bool"},
        "enable_session_recording": {"key": "properties.enableSessionRecording", "type": "bool"},
        "enable_private_only_bastion": {"key": "properties.enablePrivateOnlyBastion", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
        sku: Optional["_models.Sku"] = None,
        ip_configurations: Optional[list["_models.BastionHostIPConfiguration"]] = None,
        dns_name: Optional[str] = None,
        virtual_network: Optional["_models.SubResource"] = None,
        network_acls: Optional["_models.BastionHostPropertiesFormatNetworkAcls"] = None,
        scale_units: Optional[int] = None,
        disable_copy_paste: bool = False,
        enable_file_copy: bool = False,
        enable_ip_connect: bool = False,
        enable_shareable_link: bool = False,
        enable_tunneling: bool = False,
        enable_kerberos: bool = False,
        enable_session_recording: bool = False,
        enable_private_only_bastion: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword sku: The sku of this Bastion Host.
        :paramtype sku: ~azure.mgmt.network.models.Sku
        :keyword ip_configurations: IP configuration of the Bastion Host resource.
        :paramtype ip_configurations: list[~azure.mgmt.network.models.BastionHostIPConfiguration]
        :keyword dns_name: FQDN for the endpoint on which bastion host is accessible.
        :paramtype dns_name: str
        :keyword virtual_network: Reference to an existing virtual network required for Developer
         Bastion Host only.
        :paramtype virtual_network: ~azure.mgmt.network.models.SubResource
        :keyword network_acls:
        :paramtype network_acls: ~azure.mgmt.network.models.BastionHostPropertiesFormatNetworkAcls
        :keyword scale_units: The scale units for the Bastion Host resource.
        :paramtype scale_units: int
        :keyword disable_copy_paste: Enable/Disable Copy/Paste feature of the Bastion Host resource.
        :paramtype disable_copy_paste: bool
        :keyword enable_file_copy: Enable/Disable File Copy feature of the Bastion Host resource.
        :paramtype enable_file_copy: bool
        :keyword enable_ip_connect: Enable/Disable IP Connect feature of the Bastion Host resource.
        :paramtype enable_ip_connect: bool
        :keyword enable_shareable_link: Enable/Disable Shareable Link of the Bastion Host resource.
        :paramtype enable_shareable_link: bool
        :keyword enable_tunneling: Enable/Disable Tunneling feature of the Bastion Host resource.
        :paramtype enable_tunneling: bool
        :keyword enable_kerberos: Enable/Disable Kerberos feature of the Bastion Host resource.
        :paramtype enable_kerberos: bool
        :keyword enable_session_recording: Enable/Disable Session Recording feature of the Bastion Host
         resource.
        :paramtype enable_session_recording: bool
        :keyword enable_private_only_bastion: Enable/Disable Private Only feature of the Bastion Host
         resource.
        :paramtype enable_private_only_bastion: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.zones = zones
        self.etag: Optional[str] = None
        self.sku = sku
        self.ip_configurations = ip_configurations
        self.dns_name = dns_name
        self.virtual_network = virtual_network
        self.network_acls = network_acls
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.scale_units = scale_units
        self.disable_copy_paste = disable_copy_paste
        self.enable_file_copy = enable_file_copy
        self.enable_ip_connect = enable_ip_connect
        self.enable_shareable_link = enable_shareable_link
        self.enable_tunneling = enable_tunneling
        self.enable_kerberos = enable_kerberos
        self.enable_session_recording = enable_session_recording
        self.enable_private_only_bastion = enable_private_only_bastion


class BastionHostIPConfiguration(SubResource):
    """IP configuration of an Bastion Host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Ip configuration type.
    :vartype type: str
    :ivar subnet: Reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar public_ip_address: Reference of the PublicIP resource. Null for private only bastion.
    :vartype public_ip_address: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the bastion host IP configuration resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar private_ip_allocation_method: Private IP allocation method. Known values are: "Static"
     and "Dynamic".
    :vartype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword subnet: Reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword public_ip_address: Reference of the PublicIP resource. Null for private only bastion.
        :paramtype public_ip_address: ~azure.mgmt.network.models.SubResource
        :keyword private_ip_allocation_method: Private IP allocation method. Known values are: "Static"
         and "Dynamic".
        :paramtype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.private_ip_allocation_method = private_ip_allocation_method


class BastionHostListResult(_serialization.Model):
    """Response for ListBastionHosts API service call.

    :ivar value: List of Bastion Hosts in a resource group.
    :vartype value: list[~azure.mgmt.network.models.BastionHost]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BastionHost]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.BastionHost"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Bastion Hosts in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.BastionHost]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BastionHostPropertiesFormatNetworkAcls(_serialization.Model):
    """BastionHostPropertiesFormatNetworkAcls.

    :ivar ip_rules: Sets the IP ACL rules for Developer Bastion Host.
    :vartype ip_rules: list[~azure.mgmt.network.models.IPRule]
    """

    _attribute_map = {
        "ip_rules": {"key": "ipRules", "type": "[IPRule]"},
    }

    def __init__(self, *, ip_rules: Optional[list["_models.IPRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_rules: Sets the IP ACL rules for Developer Bastion Host.
        :paramtype ip_rules: list[~azure.mgmt.network.models.IPRule]
        """
        super().__init__(**kwargs)
        self.ip_rules = ip_rules


class BastionSessionDeleteResult(_serialization.Model):
    """Response for DisconnectActiveSessions.

    :ivar value: List of sessions with their corresponding state.
    :vartype value: list[~azure.mgmt.network.models.BastionSessionState]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BastionSessionState]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.BastionSessionState"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of sessions with their corresponding state.
        :paramtype value: list[~azure.mgmt.network.models.BastionSessionState]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BastionSessionState(_serialization.Model):
    """The session state detail for a target.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar session_id: A unique id for the session.
    :vartype session_id: str
    :ivar message: Used for extra information.
    :vartype message: str
    :ivar state: The state of the session. Disconnected/Failed/NotFound.
    :vartype state: str
    """

    _validation = {
        "session_id": {"readonly": True},
        "message": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "session_id": {"key": "sessionId", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.session_id: Optional[str] = None
        self.message: Optional[str] = None
        self.state: Optional[str] = None


class BastionShareableLink(_serialization.Model):
    """Bastion Shareable Link.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar vm: Reference of the virtual machine resource. Required.
    :vartype vm: ~azure.mgmt.network.models.VM
    :ivar bsl: The unique Bastion Shareable Link to the virtual machine.
    :vartype bsl: str
    :ivar created_at: The time when the link was created.
    :vartype created_at: str
    :ivar message: Optional field indicating the warning or error message related to the vm in case
     of partial failure.
    :vartype message: str
    """

    _validation = {
        "vm": {"required": True},
        "bsl": {"readonly": True},
        "created_at": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "vm": {"key": "vm", "type": "VM"},
        "bsl": {"key": "bsl", "type": "str"},
        "created_at": {"key": "createdAt", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, vm: "_models.VM", **kwargs: Any) -> None:
        """
        :keyword vm: Reference of the virtual machine resource. Required.
        :paramtype vm: ~azure.mgmt.network.models.VM
        """
        super().__init__(**kwargs)
        self.vm = vm
        self.bsl: Optional[str] = None
        self.created_at: Optional[str] = None
        self.message: Optional[str] = None


class BastionShareableLinkListRequest(_serialization.Model):
    """Post request for Create/Delete/Get Bastion Shareable Link endpoints.

    :ivar vms: List of VM references.
    :vartype vms: list[~azure.mgmt.network.models.BastionShareableLink]
    """

    _attribute_map = {
        "vms": {"key": "vms", "type": "[BastionShareableLink]"},
    }

    def __init__(self, *, vms: Optional[list["_models.BastionShareableLink"]] = None, **kwargs: Any) -> None:
        """
        :keyword vms: List of VM references.
        :paramtype vms: list[~azure.mgmt.network.models.BastionShareableLink]
        """
        super().__init__(**kwargs)
        self.vms = vms


class BastionShareableLinkListResult(_serialization.Model):
    """Response for all the Bastion Shareable Link endpoints.

    :ivar value: List of Bastion Shareable Links for the request.
    :vartype value: list[~azure.mgmt.network.models.BastionShareableLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BastionShareableLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.BastionShareableLink"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Bastion Shareable Links for the request.
        :paramtype value: list[~azure.mgmt.network.models.BastionShareableLink]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BastionShareableLinkTokenListRequest(_serialization.Model):
    """Post request for Delete Bastion Shareable Link By Token endpoint.

    :ivar tokens: List of Bastion Shareable Link Token.
    :vartype tokens: list[str]
    """

    _attribute_map = {
        "tokens": {"key": "tokens", "type": "[str]"},
    }

    def __init__(self, *, tokens: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword tokens: List of Bastion Shareable Link Token.
        :paramtype tokens: list[str]
        """
        super().__init__(**kwargs)
        self.tokens = tokens


class BGPCommunity(_serialization.Model):
    """Contains bgp community information offered in Service Community resources.

    :ivar service_supported_region: The region which the service support. e.g. For O365, region is
     Global.
    :vartype service_supported_region: str
    :ivar community_name: The name of the bgp community. e.g. Skype.
    :vartype community_name: str
    :ivar community_value: The value of the bgp community. For more information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :vartype community_value: str
    :ivar community_prefixes: The prefixes that the bgp community contains.
    :vartype community_prefixes: list[str]
    :ivar is_authorized_to_use: Customer is authorized to use bgp community or not.
    :vartype is_authorized_to_use: bool
    :ivar service_group: The service group of the bgp community contains.
    :vartype service_group: str
    """

    _attribute_map = {
        "service_supported_region": {"key": "serviceSupportedRegion", "type": "str"},
        "community_name": {"key": "communityName", "type": "str"},
        "community_value": {"key": "communityValue", "type": "str"},
        "community_prefixes": {"key": "communityPrefixes", "type": "[str]"},
        "is_authorized_to_use": {"key": "isAuthorizedToUse", "type": "bool"},
        "service_group": {"key": "serviceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_supported_region: Optional[str] = None,
        community_name: Optional[str] = None,
        community_value: Optional[str] = None,
        community_prefixes: Optional[list[str]] = None,
        is_authorized_to_use: Optional[bool] = None,
        service_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_supported_region: The region which the service support. e.g. For O365, region
         is Global.
        :paramtype service_supported_region: str
        :keyword community_name: The name of the bgp community. e.g. Skype.
        :paramtype community_name: str
        :keyword community_value: The value of the bgp community. For more information:
         https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
        :paramtype community_value: str
        :keyword community_prefixes: The prefixes that the bgp community contains.
        :paramtype community_prefixes: list[str]
        :keyword is_authorized_to_use: Customer is authorized to use bgp community or not.
        :paramtype is_authorized_to_use: bool
        :keyword service_group: The service group of the bgp community contains.
        :paramtype service_group: str
        """
        super().__init__(**kwargs)
        self.service_supported_region = service_supported_region
        self.community_name = community_name
        self.community_value = community_value
        self.community_prefixes = community_prefixes
        self.is_authorized_to_use = is_authorized_to_use
        self.service_group = service_group


class BgpConnection(SubResource):
    """Virtual Appliance Site resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the connection.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Connection type.
    :vartype type: str
    :ivar peer_asn: Peer ASN.
    :vartype peer_asn: int
    :ivar peer_ip: Peer IP.
    :vartype peer_ip: str
    :ivar hub_virtual_network_connection: The reference to the HubVirtualNetworkConnection
     resource.
    :vartype hub_virtual_network_connection: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar connection_state: The current state of the VirtualHub to Peer. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_state: str or ~azure.mgmt.network.models.HubBgpConnectionStatus
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 0},
        "provisioning_state": {"readonly": True},
        "connection_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "peer_asn": {"key": "properties.peerAsn", "type": "int"},
        "peer_ip": {"key": "properties.peerIp", "type": "str"},
        "hub_virtual_network_connection": {"key": "properties.hubVirtualNetworkConnection", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "connection_state": {"key": "properties.connectionState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peer_asn: Optional[int] = None,
        peer_ip: Optional[str] = None,
        hub_virtual_network_connection: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the connection.
        :paramtype name: str
        :keyword peer_asn: Peer ASN.
        :paramtype peer_asn: int
        :keyword peer_ip: Peer IP.
        :paramtype peer_ip: str
        :keyword hub_virtual_network_connection: The reference to the HubVirtualNetworkConnection
         resource.
        :paramtype hub_virtual_network_connection: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.peer_asn = peer_asn
        self.peer_ip = peer_ip
        self.hub_virtual_network_connection = hub_virtual_network_connection
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.connection_state: Optional[Union[str, "_models.HubBgpConnectionStatus"]] = None


class BgpPeerStatus(_serialization.Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The virtual network gateway's local address.
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer.
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer.
    :vartype asn: int
    :ivar state: The BGP peer state. Known values are: "Unknown", "Stopped", "Idle", "Connecting",
     and "Connected".
    :vartype state: str or ~azure.mgmt.network.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up.
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer.
    :vartype routes_received: int
    :ivar messages_sent: The number of BGP messages sent.
    :vartype messages_sent: int
    :ivar messages_received: The number of BGP messages received.
    :vartype messages_received: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "neighbor": {"readonly": True},
        "asn": {"readonly": True, "maximum": 4294967295, "minimum": 0},
        "state": {"readonly": True},
        "connected_duration": {"readonly": True},
        "routes_received": {"readonly": True},
        "messages_sent": {"readonly": True},
        "messages_received": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "neighbor": {"key": "neighbor", "type": "str"},
        "asn": {"key": "asn", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "connected_duration": {"key": "connectedDuration", "type": "str"},
        "routes_received": {"key": "routesReceived", "type": "int"},
        "messages_sent": {"key": "messagesSent", "type": "int"},
        "messages_received": {"key": "messagesReceived", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.local_address: Optional[str] = None
        self.neighbor: Optional[str] = None
        self.asn: Optional[int] = None
        self.state: Optional[Union[str, "_models.BgpPeerState"]] = None
        self.connected_duration: Optional[str] = None
        self.routes_received: Optional[int] = None
        self.messages_sent: Optional[int] = None
        self.messages_received: Optional[int] = None


class BgpPeerStatusListResult(_serialization.Model):
    """Response for list BGP peer status API service call.

    :ivar value: List of BGP peers.
    :vartype value: list[~azure.mgmt.network.models.BgpPeerStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpPeerStatus]"},
    }

    def __init__(self, *, value: Optional[list["_models.BgpPeerStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of BGP peers.
        :paramtype value: list[~azure.mgmt.network.models.BgpPeerStatus]
        """
        super().__init__(**kwargs)
        self.value = value


class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar service_name: The name of the bgp community. e.g. Skype.
    :vartype service_name: str
    :ivar bgp_communities: A list of bgp communities.
    :vartype bgp_communities: list[~azure.mgmt.network.models.BGPCommunity]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "service_name": {"key": "properties.serviceName", "type": "str"},
        "bgp_communities": {"key": "properties.bgpCommunities", "type": "[BGPCommunity]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        service_name: Optional[str] = None,
        bgp_communities: Optional[list["_models.BGPCommunity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword service_name: The name of the bgp community. e.g. Skype.
        :paramtype service_name: str
        :keyword bgp_communities: A list of bgp communities.
        :paramtype bgp_communities: list[~azure.mgmt.network.models.BGPCommunity]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.service_name = service_name
        self.bgp_communities = bgp_communities


class BgpServiceCommunityListResult(_serialization.Model):
    """Response for the ListServiceCommunity API service call.

    :ivar value: A list of service community resources.
    :vartype value: list[~azure.mgmt.network.models.BgpServiceCommunity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpServiceCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.BgpServiceCommunity"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of service community resources.
        :paramtype value: list[~azure.mgmt.network.models.BgpServiceCommunity]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BgpSettings(_serialization.Model):
    """BGP settings details.

    :ivar asn: The BGP speaker's ASN.
    :vartype asn: int
    :ivar bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
    :vartype bgp_peering_address: str
    :ivar peer_weight: The weight added to routes learned from this BGP speaker.
    :vartype peer_weight: int
    :ivar bgp_peering_addresses: BGP peering address with IP configuration ID for virtual network
     gateway.
    :vartype bgp_peering_addresses:
     list[~azure.mgmt.network.models.IPConfigurationBgpPeeringAddress]
    """

    _validation = {
        "asn": {"maximum": 4294967295, "minimum": 0},
    }

    _attribute_map = {
        "asn": {"key": "asn", "type": "int"},
        "bgp_peering_address": {"key": "bgpPeeringAddress", "type": "str"},
        "peer_weight": {"key": "peerWeight", "type": "int"},
        "bgp_peering_addresses": {"key": "bgpPeeringAddresses", "type": "[IPConfigurationBgpPeeringAddress]"},
    }

    def __init__(
        self,
        *,
        asn: Optional[int] = None,
        bgp_peering_address: Optional[str] = None,
        peer_weight: Optional[int] = None,
        bgp_peering_addresses: Optional[list["_models.IPConfigurationBgpPeeringAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword asn: The BGP speaker's ASN.
        :paramtype asn: int
        :keyword bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :paramtype bgp_peering_address: str
        :keyword peer_weight: The weight added to routes learned from this BGP speaker.
        :paramtype peer_weight: int
        :keyword bgp_peering_addresses: BGP peering address with IP configuration ID for virtual
         network gateway.
        :paramtype bgp_peering_addresses:
         list[~azure.mgmt.network.models.IPConfigurationBgpPeeringAddress]
        """
        super().__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight
        self.bgp_peering_addresses = bgp_peering_addresses


class BreakOutCategoryPolicies(_serialization.Model):
    """Network Virtual Appliance Sku Properties.

    :ivar allow: Flag to control breakout of o365 allow category.
    :vartype allow: bool
    :ivar optimize: Flag to control breakout of o365 optimize category.
    :vartype optimize: bool
    :ivar default: Flag to control breakout of o365 default category.
    :vartype default: bool
    """

    _attribute_map = {
        "allow": {"key": "allow", "type": "bool"},
        "optimize": {"key": "optimize", "type": "bool"},
        "default": {"key": "default", "type": "bool"},
    }

    def __init__(
        self,
        *,
        allow: Optional[bool] = None,
        optimize: Optional[bool] = None,
        default: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow: Flag to control breakout of o365 allow category.
        :paramtype allow: bool
        :keyword optimize: Flag to control breakout of o365 optimize category.
        :paramtype optimize: bool
        :keyword default: Flag to control breakout of o365 default category.
        :paramtype default: bool
        """
        super().__init__(**kwargs)
        self.allow = allow
        self.optimize = optimize
        self.default = default


class CheckPrivateLinkServiceVisibilityRequest(_serialization.Model):
    """Request body of the CheckPrivateLinkServiceVisibility API service call.

    :ivar private_link_service_alias: The alias of the private link service.
    :vartype private_link_service_alias: str
    """

    _attribute_map = {
        "private_link_service_alias": {"key": "privateLinkServiceAlias", "type": "str"},
    }

    def __init__(self, *, private_link_service_alias: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword private_link_service_alias: The alias of the private link service.
        :paramtype private_link_service_alias: str
        """
        super().__init__(**kwargs)
        self.private_link_service_alias = private_link_service_alias


class CircuitMetadataMap(_serialization.Model):
    """CircuitMetadataMap.

    :ivar name: Express Route Circuit Name.
    :vartype name: str
    :ivar link: Link to the Express Route circuit.
    :vartype link: str
    :ivar location: Peering location of the Express Route Circuit.
    :vartype location: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "link": {"key": "link", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, link: Optional[str] = None, location: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Express Route Circuit Name.
        :paramtype name: str
        :keyword link: Link to the Express Route circuit.
        :paramtype link: str
        :keyword location: Peering location of the Express Route Circuit.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.link = link
        self.location = location


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.network.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.network.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CommonErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class CommonErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.network.models.CommonErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.network.models.CommonErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CommonErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[CommonErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.CommonErrorDetail"]] = None
        self.additional_info: Optional[list["_models.CommonErrorAdditionalInfo"]] = None


class CommonErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.network.models.CommonErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "CommonErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.CommonErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.network.models.CommonErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class CommonResource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class CommonProxyResource(CommonResource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    """


class CommonTrackedResource(CommonResource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class ConfigurationGroup(_serialization.Model):
    """The network configuration group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Network group ID.
    :vartype id: str
    :ivar description: A description of the network group.
    :vartype description: str
    :ivar member_type: The type of the group member. Known values are: "VirtualNetwork" and
     "Subnet".
    :vartype member_type: str or ~azure.mgmt.network.models.GroupMemberType
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "member_type": {"key": "properties.memberType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        description: Optional[str] = None,
        member_type: Optional[Union[str, "_models.GroupMemberType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Network group ID.
        :paramtype id: str
        :keyword description: A description of the network group.
        :paramtype description: str
        :keyword member_type: The type of the group member. Known values are: "VirtualNetwork" and
         "Subnet".
        :paramtype member_type: str or ~azure.mgmt.network.models.GroupMemberType
        """
        super().__init__(**kwargs)
        self.id = id
        self.description = description
        self.member_type = member_type
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class ConnectionMonitor(_serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    :ivar location: Connection monitor location.
    :vartype location: str
    :ivar tags: Connection monitor tags.
    :vartype tags: dict[str, str]
    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    """

    _validation = {
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "properties.destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "properties.autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "properties.monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "properties.endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "properties.testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "properties.testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "properties.outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "properties.notes", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[list["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[list["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[list["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[list["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Connection monitor location.
        :paramtype location: str
        :keyword tags: Connection monitor tags.
        :paramtype tags: dict[str, str]
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.endpoints = endpoints
        self.test_configurations = test_configurations
        self.test_groups = test_groups
        self.outputs = outputs
        self.notes = notes


class ConnectionMonitorDestination(_serialization.Model):
    """Describes the destination of connection monitor.

    :ivar resource_id: The ID of the resource used as the destination by connection monitor.
    :vartype resource_id: str
    :ivar address: Address of the connection monitor destination (IP or domain name).
    :vartype address: str
    :ivar port: The destination port used by connection monitor.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        address: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The ID of the resource used as the destination by connection monitor.
        :paramtype resource_id: str
        :keyword address: Address of the connection monitor destination (IP or domain name).
        :paramtype address: str
        :keyword port: The destination port used by connection monitor.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectionMonitorEndpoint(_serialization.Model):
    """Describes the connection monitor endpoint.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the connection monitor endpoint. Required.
    :vartype name: str
    :ivar type: The endpoint type. Known values are: "AzureVM", "AzureVNet", "AzureSubnet",
     "ExternalAddress", "MMAWorkspaceMachine", "MMAWorkspaceNetwork", "AzureArcVM", "AzureVMSS", and
     "AzureArcNetwork".
    :vartype type: str or ~azure.mgmt.network.models.EndpointType
    :ivar resource_id: Resource ID of the connection monitor endpoint are supported for AzureVM,
     AzureVMSS, AzureVNet, AzureSubnet, MMAWorkspaceMachine, MMAWorkspaceNetwork, AzureArcVM
     endpoint type.
    :vartype resource_id: str
    :ivar address: Address of the connection monitor endpoint. Supported for AzureVM,
     ExternalAddress, ArcMachine, MMAWorkspaceMachine endpoint type.
    :vartype address: str
    :ivar filter: Filter field is getting deprecated and should not be used. Instead use
     Include/Exclude scope fields for it.
    :vartype filter: ~azure.mgmt.network.models.ConnectionMonitorEndpointFilter
    :ivar scope: Endpoint scope defines which target resource to monitor in case of compound
     resource endpoints like VMSS, AzureSubnet, AzureVNet, MMAWorkspaceNetwork, AzureArcNetwork.
    :vartype scope: ~azure.mgmt.network.models.ConnectionMonitorEndpointScope
    :ivar coverage_level: Test coverage for the endpoint. Known values are: "Default", "Low",
     "BelowAverage", "Average", "AboveAverage", and "Full".
    :vartype coverage_level: str or ~azure.mgmt.network.models.CoverageLevel
    :ivar location_details: Location details is optional and only being used for 'AzureArcNetwork'
     type endpoints, which contains region details.
    :vartype location_details: ~azure.mgmt.network.models.ConnectionMonitorEndpointLocationDetails
    :ivar subscription_id: Subscription ID for connection monitor endpoint. It's an optional
     parameter which is being used for 'AzureArcNetwork' type endpoint.
    :vartype subscription_id: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "filter": {"key": "filter", "type": "ConnectionMonitorEndpointFilter"},
        "scope": {"key": "scope", "type": "ConnectionMonitorEndpointScope"},
        "coverage_level": {"key": "coverageLevel", "type": "str"},
        "location_details": {"key": "locationDetails", "type": "ConnectionMonitorEndpointLocationDetails"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Optional[Union[str, "_models.EndpointType"]] = None,
        resource_id: Optional[str] = None,
        address: Optional[str] = None,
        filter: Optional["_models.ConnectionMonitorEndpointFilter"] = None,  # pylint: disable=redefined-builtin
        scope: Optional["_models.ConnectionMonitorEndpointScope"] = None,
        coverage_level: Optional[Union[str, "_models.CoverageLevel"]] = None,
        location_details: Optional["_models.ConnectionMonitorEndpointLocationDetails"] = None,
        subscription_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the connection monitor endpoint. Required.
        :paramtype name: str
        :keyword type: The endpoint type. Known values are: "AzureVM", "AzureVNet", "AzureSubnet",
         "ExternalAddress", "MMAWorkspaceMachine", "MMAWorkspaceNetwork", "AzureArcVM", "AzureVMSS", and
         "AzureArcNetwork".
        :paramtype type: str or ~azure.mgmt.network.models.EndpointType
        :keyword resource_id: Resource ID of the connection monitor endpoint are supported for AzureVM,
         AzureVMSS, AzureVNet, AzureSubnet, MMAWorkspaceMachine, MMAWorkspaceNetwork, AzureArcVM
         endpoint type.
        :paramtype resource_id: str
        :keyword address: Address of the connection monitor endpoint. Supported for AzureVM,
         ExternalAddress, ArcMachine, MMAWorkspaceMachine endpoint type.
        :paramtype address: str
        :keyword filter: Filter field is getting deprecated and should not be used. Instead use
         Include/Exclude scope fields for it.
        :paramtype filter: ~azure.mgmt.network.models.ConnectionMonitorEndpointFilter
        :keyword scope: Endpoint scope defines which target resource to monitor in case of compound
         resource endpoints like VMSS, AzureSubnet, AzureVNet, MMAWorkspaceNetwork, AzureArcNetwork.
        :paramtype scope: ~azure.mgmt.network.models.ConnectionMonitorEndpointScope
        :keyword coverage_level: Test coverage for the endpoint. Known values are: "Default", "Low",
         "BelowAverage", "Average", "AboveAverage", and "Full".
        :paramtype coverage_level: str or ~azure.mgmt.network.models.CoverageLevel
        :keyword location_details: Location details is optional and only being used for
         'AzureArcNetwork' type endpoints, which contains region details.
        :paramtype location_details:
         ~azure.mgmt.network.models.ConnectionMonitorEndpointLocationDetails
        :keyword subscription_id: Subscription ID for connection monitor endpoint. It's an optional
         parameter which is being used for 'AzureArcNetwork' type endpoint.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.resource_id = resource_id
        self.address = address
        self.filter = filter
        self.scope = scope
        self.coverage_level = coverage_level
        self.location_details = location_details
        self.subscription_id = subscription_id


class ConnectionMonitorEndpointFilter(_serialization.Model):
    """Describes the connection monitor endpoint filter.

    :ivar type: The behavior of the endpoint filter. Currently only 'Include' is supported.
     "Include"
    :vartype type: str or ~azure.mgmt.network.models.ConnectionMonitorEndpointFilterType
    :ivar items: List of items in the filter.
    :vartype items: list[~azure.mgmt.network.models.ConnectionMonitorEndpointFilterItem]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "items": {"key": "items", "type": "[ConnectionMonitorEndpointFilterItem]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ConnectionMonitorEndpointFilterType"]] = None,
        items: Optional[list["_models.ConnectionMonitorEndpointFilterItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The behavior of the endpoint filter. Currently only 'Include' is supported.
         "Include"
        :paramtype type: str or ~azure.mgmt.network.models.ConnectionMonitorEndpointFilterType
        :keyword items: List of items in the filter.
        :paramtype items: list[~azure.mgmt.network.models.ConnectionMonitorEndpointFilterItem]
        """
        super().__init__(**kwargs)
        self.type = type
        self.items = items


class ConnectionMonitorEndpointFilterItem(_serialization.Model):
    """Describes the connection monitor endpoint filter item.

    :ivar type: The type of item included in the filter. Currently only 'AgentAddress' is
     supported. "AgentAddress"
    :vartype type: str or ~azure.mgmt.network.models.ConnectionMonitorEndpointFilterItemType
    :ivar address: The address of the filter item.
    :vartype address: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "address": {"key": "address", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ConnectionMonitorEndpointFilterItemType"]] = None,
        address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of item included in the filter. Currently only 'AgentAddress' is
         supported. "AgentAddress"
        :paramtype type: str or ~azure.mgmt.network.models.ConnectionMonitorEndpointFilterItemType
        :keyword address: The address of the filter item.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.address = address


class ConnectionMonitorEndpointLocationDetails(_serialization.Model):
    """Connection monitor endpoint location details only being used for 'AzureArcNetwork' type
    endpoints, which contains the region details.

    :ivar region: Region for connection monitor endpoint.
    :vartype region: str
    """

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
    }

    def __init__(self, *, region: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword region: Region for connection monitor endpoint.
        :paramtype region: str
        """
        super().__init__(**kwargs)
        self.region = region


class ConnectionMonitorEndpointScope(_serialization.Model):
    """Describes the connection monitor endpoint scope.

    :ivar include: List of items which needs to be included to the endpoint scope.
    :vartype include: list[~azure.mgmt.network.models.ConnectionMonitorEndpointScopeItem]
    :ivar exclude: List of items which needs to be excluded from the endpoint scope.
    :vartype exclude: list[~azure.mgmt.network.models.ConnectionMonitorEndpointScopeItem]
    """

    _attribute_map = {
        "include": {"key": "include", "type": "[ConnectionMonitorEndpointScopeItem]"},
        "exclude": {"key": "exclude", "type": "[ConnectionMonitorEndpointScopeItem]"},
    }

    def __init__(
        self,
        *,
        include: Optional[list["_models.ConnectionMonitorEndpointScopeItem"]] = None,
        exclude: Optional[list["_models.ConnectionMonitorEndpointScopeItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword include: List of items which needs to be included to the endpoint scope.
        :paramtype include: list[~azure.mgmt.network.models.ConnectionMonitorEndpointScopeItem]
        :keyword exclude: List of items which needs to be excluded from the endpoint scope.
        :paramtype exclude: list[~azure.mgmt.network.models.ConnectionMonitorEndpointScopeItem]
        """
        super().__init__(**kwargs)
        self.include = include
        self.exclude = exclude


class ConnectionMonitorEndpointScopeItem(_serialization.Model):
    """Describes the connection monitor endpoint scope item.

    :ivar address: The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or
     IPv4/IPv6 IP address.
    :vartype address: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
    }

    def __init__(self, *, address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address: The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask
         or IPv4/IPv6 IP address.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.address = address


class ConnectionMonitorHttpConfiguration(_serialization.Model):
    """Describes the HTTP configuration.

    :ivar port: The port to connect to.
    :vartype port: int
    :ivar method: The HTTP method to use. Known values are: "Get" and "Post".
    :vartype method: str or ~azure.mgmt.network.models.HTTPConfigurationMethod
    :ivar path: The path component of the URI. For instance, "/dir1/dir2".
    :vartype path: str
    :ivar request_headers: The HTTP headers to transmit with the request.
    :vartype request_headers: list[~azure.mgmt.network.models.HTTPHeader]
    :ivar valid_status_code_ranges: HTTP status codes to consider successful. For instance,
     "2xx,301-304,418".
    :vartype valid_status_code_ranges: list[str]
    :ivar prefer_https: Value indicating whether HTTPS is preferred over HTTP in cases where the
     choice is not explicit.
    :vartype prefer_https: bool
    """

    _validation = {
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
        "method": {"key": "method", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "request_headers": {"key": "requestHeaders", "type": "[HTTPHeader]"},
        "valid_status_code_ranges": {"key": "validStatusCodeRanges", "type": "[str]"},
        "prefer_https": {"key": "preferHTTPS", "type": "bool"},
    }

    def __init__(
        self,
        *,
        port: Optional[int] = None,
        method: Optional[Union[str, "_models.HTTPConfigurationMethod"]] = None,
        path: Optional[str] = None,
        request_headers: Optional[list["_models.HTTPHeader"]] = None,
        valid_status_code_ranges: Optional[list[str]] = None,
        prefer_https: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword port: The port to connect to.
        :paramtype port: int
        :keyword method: The HTTP method to use. Known values are: "Get" and "Post".
        :paramtype method: str or ~azure.mgmt.network.models.HTTPConfigurationMethod
        :keyword path: The path component of the URI. For instance, "/dir1/dir2".
        :paramtype path: str
        :keyword request_headers: The HTTP headers to transmit with the request.
        :paramtype request_headers: list[~azure.mgmt.network.models.HTTPHeader]
        :keyword valid_status_code_ranges: HTTP status codes to consider successful. For instance,
         "2xx,301-304,418".
        :paramtype valid_status_code_ranges: list[str]
        :keyword prefer_https: Value indicating whether HTTPS is preferred over HTTP in cases where the
         choice is not explicit.
        :paramtype prefer_https: bool
        """
        super().__init__(**kwargs)
        self.port = port
        self.method = method
        self.path = path
        self.request_headers = request_headers
        self.valid_status_code_ranges = valid_status_code_ranges
        self.prefer_https = prefer_https


class ConnectionMonitorIcmpConfiguration(_serialization.Model):
    """Describes the ICMP configuration.

    :ivar disable_trace_route: Value indicating whether path evaluation with trace route should be
     disabled.
    :vartype disable_trace_route: bool
    """

    _attribute_map = {
        "disable_trace_route": {"key": "disableTraceRoute", "type": "bool"},
    }

    def __init__(self, *, disable_trace_route: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword disable_trace_route: Value indicating whether path evaluation with trace route should
         be disabled.
        :paramtype disable_trace_route: bool
        """
        super().__init__(**kwargs)
        self.disable_trace_route = disable_trace_route


class ConnectionMonitorListResult(_serialization.Model):
    """List of connection monitors.

    :ivar value: Information about connection monitors.
    :vartype value: list[~azure.mgmt.network.models.ConnectionMonitorResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectionMonitorResult]"},
    }

    def __init__(self, *, value: Optional[list["_models.ConnectionMonitorResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Information about connection monitors.
        :paramtype value: list[~azure.mgmt.network.models.ConnectionMonitorResult]
        """
        super().__init__(**kwargs)
        self.value = value


class ConnectionMonitorOutput(_serialization.Model):
    """Describes a connection monitor output destination.

    :ivar type: Connection monitor output destination type. Currently, only "Workspace" is
     supported. "Workspace"
    :vartype type: str or ~azure.mgmt.network.models.OutputType
    :ivar workspace_settings: Describes the settings for producing output into a log analytics
     workspace.
    :vartype workspace_settings: ~azure.mgmt.network.models.ConnectionMonitorWorkspaceSettings
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "workspace_settings": {"key": "workspaceSettings", "type": "ConnectionMonitorWorkspaceSettings"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.OutputType"]] = None,
        workspace_settings: Optional["_models.ConnectionMonitorWorkspaceSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Connection monitor output destination type. Currently, only "Workspace" is
         supported. "Workspace"
        :paramtype type: str or ~azure.mgmt.network.models.OutputType
        :keyword workspace_settings: Describes the settings for producing output into a log analytics
         workspace.
        :paramtype workspace_settings: ~azure.mgmt.network.models.ConnectionMonitorWorkspaceSettings
        """
        super().__init__(**kwargs)
        self.type = type
        self.workspace_settings = workspace_settings


class ConnectionMonitorParameters(_serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    """

    _validation = {
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "notes", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[list["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[list["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[list["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[list["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.endpoints = endpoints
        self.test_configurations = test_configurations
        self.test_groups = test_groups
        self.outputs = outputs
        self.notes = notes


class ConnectionMonitorQueryResult(_serialization.Model):
    """List of connection states snapshots.

    :ivar source_status: Status of connection monitor source. Known values are: "Unknown",
     "Active", and "Inactive".
    :vartype source_status: str or ~azure.mgmt.network.models.ConnectionMonitorSourceStatus
    :ivar states: Information about connection states.
    :vartype states: list[~azure.mgmt.network.models.ConnectionStateSnapshot]
    """

    _attribute_map = {
        "source_status": {"key": "sourceStatus", "type": "str"},
        "states": {"key": "states", "type": "[ConnectionStateSnapshot]"},
    }

    def __init__(
        self,
        *,
        source_status: Optional[Union[str, "_models.ConnectionMonitorSourceStatus"]] = None,
        states: Optional[list["_models.ConnectionStateSnapshot"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_status: Status of connection monitor source. Known values are: "Unknown",
         "Active", and "Inactive".
        :paramtype source_status: str or ~azure.mgmt.network.models.ConnectionMonitorSourceStatus
        :keyword states: Information about connection states.
        :paramtype states: list[~azure.mgmt.network.models.ConnectionStateSnapshot]
        """
        super().__init__(**kwargs)
        self.source_status = source_status
        self.states = states


class ConnectionMonitorResult(_serialization.Model):
    """Information about the connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the connection monitor.
    :vartype name: str
    :ivar id: ID of the connection monitor.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Connection monitor type.
    :vartype type: str
    :ivar location: Connection monitor location.
    :vartype location: str
    :ivar tags: Connection monitor tags.
    :vartype tags: dict[str, str]
    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    :ivar provisioning_state: The provisioning state of the connection monitor. Known values are:
     "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    :ivar connection_monitor_type: Type of connection monitor. Known values are: "MultiEndpoint"
     and "SingleSourceDestination".
    :vartype connection_monitor_type: str or ~azure.mgmt.network.models.ConnectionMonitorType
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
        "provisioning_state": {"readonly": True},
        "start_time": {"readonly": True},
        "monitoring_status": {"readonly": True},
        "connection_monitor_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "properties.destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "properties.autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "properties.monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "properties.endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "properties.testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "properties.testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "properties.outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "properties.notes", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "monitoring_status": {"key": "properties.monitoringStatus", "type": "str"},
        "connection_monitor_type": {"key": "properties.connectionMonitorType", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[list["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[list["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[list["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[list["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Connection monitor location.
        :paramtype location: str
        :keyword tags: Connection monitor tags.
        :paramtype tags: dict[str, str]
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.id: Optional[str] = None
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.endpoints = endpoints
        self.test_configurations = test_configurations
        self.test_groups = test_groups
        self.outputs = outputs
        self.notes = notes
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.start_time: Optional[datetime.datetime] = None
        self.monitoring_status: Optional[str] = None
        self.connection_monitor_type: Optional[Union[str, "_models.ConnectionMonitorType"]] = None


class ConnectionMonitorResultProperties(ConnectionMonitorParameters):
    """Describes the properties of a connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    :ivar provisioning_state: The provisioning state of the connection monitor. Known values are:
     "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    :ivar connection_monitor_type: Type of connection monitor. Known values are: "MultiEndpoint"
     and "SingleSourceDestination".
    :vartype connection_monitor_type: str or ~azure.mgmt.network.models.ConnectionMonitorType
    """

    _validation = {
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
        "provisioning_state": {"readonly": True},
        "start_time": {"readonly": True},
        "monitoring_status": {"readonly": True},
        "connection_monitor_type": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "notes", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "monitoring_status": {"key": "monitoringStatus", "type": "str"},
        "connection_monitor_type": {"key": "connectionMonitorType", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[list["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[list["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[list["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[list["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(
            source=source,
            destination=destination,
            auto_start=auto_start,
            monitoring_interval_in_seconds=monitoring_interval_in_seconds,
            endpoints=endpoints,
            test_configurations=test_configurations,
            test_groups=test_groups,
            outputs=outputs,
            notes=notes,
            **kwargs
        )
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.start_time: Optional[datetime.datetime] = None
        self.monitoring_status: Optional[str] = None
        self.connection_monitor_type: Optional[Union[str, "_models.ConnectionMonitorType"]] = None


class ConnectionMonitorSource(_serialization.Model):
    """Describes the source of connection monitor.

    All required parameters must be populated in order to send to server.

    :ivar resource_id: The ID of the resource used as the source by connection monitor. Required.
    :vartype resource_id: str
    :ivar port: The source port used by connection monitor.
    :vartype port: int
    """

    _validation = {
        "resource_id": {"required": True},
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, resource_id: str, port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The ID of the resource used as the source by connection monitor.
         Required.
        :paramtype resource_id: str
        :keyword port: The source port used by connection monitor.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class ConnectionMonitorSuccessThreshold(_serialization.Model):
    """Describes the threshold for declaring a test successful.

    :ivar checks_failed_percent: The maximum percentage of failed checks permitted for a test to
     evaluate as successful.
    :vartype checks_failed_percent: int
    :ivar round_trip_time_ms: The maximum round-trip time in milliseconds permitted for a test to
     evaluate as successful.
    :vartype round_trip_time_ms: float
    """

    _attribute_map = {
        "checks_failed_percent": {"key": "checksFailedPercent", "type": "int"},
        "round_trip_time_ms": {"key": "roundTripTimeMs", "type": "float"},
    }

    def __init__(
        self, *, checks_failed_percent: Optional[int] = None, round_trip_time_ms: Optional[float] = None, **kwargs: Any
    ) -> None:
        """
        :keyword checks_failed_percent: The maximum percentage of failed checks permitted for a test to
         evaluate as successful.
        :paramtype checks_failed_percent: int
        :keyword round_trip_time_ms: The maximum round-trip time in milliseconds permitted for a test
         to evaluate as successful.
        :paramtype round_trip_time_ms: float
        """
        super().__init__(**kwargs)
        self.checks_failed_percent = checks_failed_percent
        self.round_trip_time_ms = round_trip_time_ms


class ConnectionMonitorTcpConfiguration(_serialization.Model):
    """Describes the TCP configuration.

    :ivar port: The port to connect to.
    :vartype port: int
    :ivar disable_trace_route: Value indicating whether path evaluation with trace route should be
     disabled.
    :vartype disable_trace_route: bool
    :ivar destination_port_behavior: Destination port behavior. Known values are: "None" and
     "ListenIfAvailable".
    :vartype destination_port_behavior: str or ~azure.mgmt.network.models.DestinationPortBehavior
    """

    _validation = {
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
        "disable_trace_route": {"key": "disableTraceRoute", "type": "bool"},
        "destination_port_behavior": {"key": "destinationPortBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        port: Optional[int] = None,
        disable_trace_route: Optional[bool] = None,
        destination_port_behavior: Optional[Union[str, "_models.DestinationPortBehavior"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword port: The port to connect to.
        :paramtype port: int
        :keyword disable_trace_route: Value indicating whether path evaluation with trace route should
         be disabled.
        :paramtype disable_trace_route: bool
        :keyword destination_port_behavior: Destination port behavior. Known values are: "None" and
         "ListenIfAvailable".
        :paramtype destination_port_behavior: str or ~azure.mgmt.network.models.DestinationPortBehavior
        """
        super().__init__(**kwargs)
        self.port = port
        self.disable_trace_route = disable_trace_route
        self.destination_port_behavior = destination_port_behavior


class ConnectionMonitorTestConfiguration(_serialization.Model):
    """Describes a connection monitor test configuration.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the connection monitor test configuration. Required.
    :vartype name: str
    :ivar test_frequency_sec: The frequency of test evaluation, in seconds.
    :vartype test_frequency_sec: int
    :ivar protocol: The protocol to use in test evaluation. Required. Known values are: "Tcp",
     "Http", and "Icmp".
    :vartype protocol: str or ~azure.mgmt.network.models.ConnectionMonitorTestConfigurationProtocol
    :ivar preferred_ip_version: The preferred IP version to use in test evaluation. The connection
     monitor may choose to use a different version depending on other parameters. Known values are:
     "IPv4" and "IPv6".
    :vartype preferred_ip_version: str or ~azure.mgmt.network.models.PreferredIPVersion
    :ivar http_configuration: The parameters used to perform test evaluation over HTTP.
    :vartype http_configuration: ~azure.mgmt.network.models.ConnectionMonitorHttpConfiguration
    :ivar tcp_configuration: The parameters used to perform test evaluation over TCP.
    :vartype tcp_configuration: ~azure.mgmt.network.models.ConnectionMonitorTcpConfiguration
    :ivar icmp_configuration: The parameters used to perform test evaluation over ICMP.
    :vartype icmp_configuration: ~azure.mgmt.network.models.ConnectionMonitorIcmpConfiguration
    :ivar success_threshold: The threshold for declaring a test successful.
    :vartype success_threshold: ~azure.mgmt.network.models.ConnectionMonitorSuccessThreshold
    """

    _validation = {
        "name": {"required": True},
        "protocol": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "test_frequency_sec": {"key": "testFrequencySec", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
        "preferred_ip_version": {"key": "preferredIPVersion", "type": "str"},
        "http_configuration": {"key": "httpConfiguration", "type": "ConnectionMonitorHttpConfiguration"},
        "tcp_configuration": {"key": "tcpConfiguration", "type": "ConnectionMonitorTcpConfiguration"},
        "icmp_configuration": {"key": "icmpConfiguration", "type": "ConnectionMonitorIcmpConfiguration"},
        "success_threshold": {"key": "successThreshold", "type": "ConnectionMonitorSuccessThreshold"},
    }

    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "_models.ConnectionMonitorTestConfigurationProtocol"],
        test_frequency_sec: Optional[int] = None,
        preferred_ip_version: Optional[Union[str, "_models.PreferredIPVersion"]] = None,
        http_configuration: Optional["_models.ConnectionMonitorHttpConfiguration"] = None,
        tcp_configuration: Optional["_models.ConnectionMonitorTcpConfiguration"] = None,
        icmp_configuration: Optional["_models.ConnectionMonitorIcmpConfiguration"] = None,
        success_threshold: Optional["_models.ConnectionMonitorSuccessThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the connection monitor test configuration. Required.
        :paramtype name: str
        :keyword test_frequency_sec: The frequency of test evaluation, in seconds.
        :paramtype test_frequency_sec: int
        :keyword protocol: The protocol to use in test evaluation. Required. Known values are: "Tcp",
         "Http", and "Icmp".
        :paramtype protocol: str or
         ~azure.mgmt.network.models.ConnectionMonitorTestConfigurationProtocol
        :keyword preferred_ip_version: The preferred IP version to use in test evaluation. The
         connection monitor may choose to use a different version depending on other parameters. Known
         values are: "IPv4" and "IPv6".
        :paramtype preferred_ip_version: str or ~azure.mgmt.network.models.PreferredIPVersion
        :keyword http_configuration: The parameters used to perform test evaluation over HTTP.
        :paramtype http_configuration: ~azure.mgmt.network.models.ConnectionMonitorHttpConfiguration
        :keyword tcp_configuration: The parameters used to perform test evaluation over TCP.
        :paramtype tcp_configuration: ~azure.mgmt.network.models.ConnectionMonitorTcpConfiguration
        :keyword icmp_configuration: The parameters used to perform test evaluation over ICMP.
        :paramtype icmp_configuration: ~azure.mgmt.network.models.ConnectionMonitorIcmpConfiguration
        :keyword success_threshold: The threshold for declaring a test successful.
        :paramtype success_threshold: ~azure.mgmt.network.models.ConnectionMonitorSuccessThreshold
        """
        super().__init__(**kwargs)
        self.name = name
        self.test_frequency_sec = test_frequency_sec
        self.protocol = protocol
        self.preferred_ip_version = preferred_ip_version
        self.http_configuration = http_configuration
        self.tcp_configuration = tcp_configuration
        self.icmp_configuration = icmp_configuration
        self.success_threshold = success_threshold


class ConnectionMonitorTestGroup(_serialization.Model):
    """Describes the connection monitor test group.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the connection monitor test group. Required.
    :vartype name: str
    :ivar disable: Value indicating whether test group is disabled.
    :vartype disable: bool
    :ivar test_configurations: List of test configuration names. Required.
    :vartype test_configurations: list[str]
    :ivar sources: List of source endpoint names. Required.
    :vartype sources: list[str]
    :ivar destinations: List of destination endpoint names. Required.
    :vartype destinations: list[str]
    """

    _validation = {
        "name": {"required": True},
        "test_configurations": {"required": True},
        "sources": {"required": True},
        "destinations": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "disable": {"key": "disable", "type": "bool"},
        "test_configurations": {"key": "testConfigurations", "type": "[str]"},
        "sources": {"key": "sources", "type": "[str]"},
        "destinations": {"key": "destinations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: str,
        test_configurations: list[str],
        sources: list[str],
        destinations: list[str],
        disable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the connection monitor test group. Required.
        :paramtype name: str
        :keyword disable: Value indicating whether test group is disabled.
        :paramtype disable: bool
        :keyword test_configurations: List of test configuration names. Required.
        :paramtype test_configurations: list[str]
        :keyword sources: List of source endpoint names. Required.
        :paramtype sources: list[str]
        :keyword destinations: List of destination endpoint names. Required.
        :paramtype destinations: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.disable = disable
        self.test_configurations = test_configurations
        self.sources = sources
        self.destinations = destinations


class ConnectionMonitorWorkspaceSettings(_serialization.Model):
    """Describes the settings for producing output into a log analytics workspace.

    :ivar workspace_resource_id: Log analytics workspace resource ID.
    :vartype workspace_resource_id: str
    """

    _attribute_map = {
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
    }

    def __init__(self, *, workspace_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword workspace_resource_id: Log analytics workspace resource ID.
        :paramtype workspace_resource_id: str
        """
        super().__init__(**kwargs)
        self.workspace_resource_id = workspace_resource_id


class ConnectionResetSharedKey(_serialization.Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to server.

    :ivar key_length: The virtual network connection reset shared key length, should between 1 and
     128. Required.
    :vartype key_length: int
    """

    _validation = {
        "key_length": {"required": True, "maximum": 128, "minimum": 1},
    }

    _attribute_map = {
        "key_length": {"key": "keyLength", "type": "int"},
    }

    def __init__(self, *, key_length: int, **kwargs: Any) -> None:
        """
        :keyword key_length: The virtual network connection reset shared key length, should between 1
         and 128. Required.
        :paramtype key_length: int
        """
        super().__init__(**kwargs)
        self.key_length = key_length


class ConnectionSharedKey(SubResource):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar value: The virtual network connection shared key value. Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, value: str, id: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword value: The virtual network connection shared key value. Required.
        :paramtype value: str
        """
        super().__init__(id=id, **kwargs)
        self.value = value


class ConnectionSharedKeyResult(SubResource):
    """SharedKey Resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar properties: Properties of the shared key.
    :vartype properties: ~azure.mgmt.network.models.SharedKeyProperties
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "properties": {"key": "properties", "type": "SharedKeyProperties"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        properties: Optional["_models.SharedKeyProperties"] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword properties: Properties of the shared key.
        :paramtype properties: ~azure.mgmt.network.models.SharedKeyProperties
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        """
        super().__init__(id=id, **kwargs)
        self.properties = properties
        self.name = name
        self.type: Optional[str] = None


class ConnectionSharedKeyResultList(_serialization.Model):
    """The list of shared keys for the vpn link connection. It should only contain one shared key for
    each vpn link connection.

    :ivar value: List of SharedKeys.
    :vartype value: list[~azure.mgmt.network.models.ConnectionSharedKeyResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectionSharedKeyResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ConnectionSharedKeyResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of SharedKeys.
        :paramtype value: list[~azure.mgmt.network.models.ConnectionSharedKeyResult]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectionStateSnapshot(_serialization.Model):
    """Connection state snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar connection_state: The connection state. Known values are: "Reachable", "Unreachable", and
     "Unknown".
    :vartype connection_state: str or ~azure.mgmt.network.models.ConnectionState
    :ivar start_time: The start time of the connection snapshot.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the connection snapshot.
    :vartype end_time: ~datetime.datetime
    :ivar evaluation_state: Connectivity analysis evaluation state. Known values are: "NotStarted",
     "InProgress", and "Completed".
    :vartype evaluation_state: str or ~azure.mgmt.network.models.EvaluationState
    :ivar avg_latency_in_ms: Average latency in ms.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in ms.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in ms.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: The number of sent probes.
    :vartype probes_sent: int
    :ivar probes_failed: The number of failed probes.
    :vartype probes_failed: int
    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.models.ConnectivityHop]
    """

    _validation = {
        "avg_latency_in_ms": {"maximum": 4294967295, "minimum": 0},
        "min_latency_in_ms": {"maximum": 4294967295, "minimum": 0},
        "max_latency_in_ms": {"maximum": 4294967295, "minimum": 0},
        "probes_sent": {"maximum": 4294967295, "minimum": 0},
        "probes_failed": {"maximum": 4294967295, "minimum": 0},
        "hops": {"readonly": True},
    }

    _attribute_map = {
        "connection_state": {"key": "connectionState", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "evaluation_state": {"key": "evaluationState", "type": "str"},
        "avg_latency_in_ms": {"key": "avgLatencyInMs", "type": "int"},
        "min_latency_in_ms": {"key": "minLatencyInMs", "type": "int"},
        "max_latency_in_ms": {"key": "maxLatencyInMs", "type": "int"},
        "probes_sent": {"key": "probesSent", "type": "int"},
        "probes_failed": {"key": "probesFailed", "type": "int"},
        "hops": {"key": "hops", "type": "[ConnectivityHop]"},
    }

    def __init__(
        self,
        *,
        connection_state: Optional[Union[str, "_models.ConnectionState"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        evaluation_state: Optional[Union[str, "_models.EvaluationState"]] = None,
        avg_latency_in_ms: Optional[int] = None,
        min_latency_in_ms: Optional[int] = None,
        max_latency_in_ms: Optional[int] = None,
        probes_sent: Optional[int] = None,
        probes_failed: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connection_state: The connection state. Known values are: "Reachable", "Unreachable",
         and "Unknown".
        :paramtype connection_state: str or ~azure.mgmt.network.models.ConnectionState
        :keyword start_time: The start time of the connection snapshot.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the connection snapshot.
        :paramtype end_time: ~datetime.datetime
        :keyword evaluation_state: Connectivity analysis evaluation state. Known values are:
         "NotStarted", "InProgress", and "Completed".
        :paramtype evaluation_state: str or ~azure.mgmt.network.models.EvaluationState
        :keyword avg_latency_in_ms: Average latency in ms.
        :paramtype avg_latency_in_ms: int
        :keyword min_latency_in_ms: Minimum latency in ms.
        :paramtype min_latency_in_ms: int
        :keyword max_latency_in_ms: Maximum latency in ms.
        :paramtype max_latency_in_ms: int
        :keyword probes_sent: The number of sent probes.
        :paramtype probes_sent: int
        :keyword probes_failed: The number of failed probes.
        :paramtype probes_failed: int
        """
        super().__init__(**kwargs)
        self.connection_state = connection_state
        self.start_time = start_time
        self.end_time = end_time
        self.evaluation_state = evaluation_state
        self.avg_latency_in_ms = avg_latency_in_ms
        self.min_latency_in_ms = min_latency_in_ms
        self.max_latency_in_ms = max_latency_in_ms
        self.probes_sent = probes_sent
        self.probes_failed = probes_failed
        self.hops: Optional[list["_models.ConnectivityHop"]] = None


class ConnectivityConfiguration(ChildResource):
    """The network manager connectivity configuration resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    :ivar description: A description of the connectivity configuration.
    :vartype description: str
    :ivar connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
     "Mesh".
    :vartype connectivity_topology: str or ~azure.mgmt.network.models.ConnectivityTopology
    :ivar hubs: List of hubItems.
    :vartype hubs: list[~azure.mgmt.network.models.Hub]
    :ivar is_global: Flag if global mesh is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.models.IsGlobal
    :ivar connectivity_capabilities: Collection of additional settings to enhance specific topology
     behaviors of the connectivity configuration resource.
    :vartype connectivity_capabilities:
     ~azure.mgmt.network.models.ConnectivityConfigurationPropertiesConnectivityCapabilities
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups: list[~azure.mgmt.network.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar delete_existing_peering: Flag if need to remove current existing peerings. Known values
     are: "False" and "True".
    :vartype delete_existing_peering: str or ~azure.mgmt.network.models.DeleteExistingPeering
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "connectivity_topology": {"key": "properties.connectivityTopology", "type": "str"},
        "hubs": {"key": "properties.hubs", "type": "[Hub]"},
        "is_global": {"key": "properties.isGlobal", "type": "str"},
        "connectivity_capabilities": {
            "key": "properties.connectivityCapabilities",
            "type": "ConnectivityConfigurationPropertiesConnectivityCapabilities",
        },
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[ConnectivityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "delete_existing_peering": {"key": "properties.deleteExistingPeering", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "_models.ConnectivityTopology"]] = None,
        hubs: Optional[list["_models.Hub"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        connectivity_capabilities: Optional[
            "_models.ConnectivityConfigurationPropertiesConnectivityCapabilities"
        ] = None,
        applies_to_groups: Optional[list["_models.ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "_models.DeleteExistingPeering"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: A description of the connectivity configuration.
        :paramtype description: str
        :keyword connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
         "Mesh".
        :paramtype connectivity_topology: str or ~azure.mgmt.network.models.ConnectivityTopology
        :keyword hubs: List of hubItems.
        :paramtype hubs: list[~azure.mgmt.network.models.Hub]
        :keyword is_global: Flag if global mesh is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.models.IsGlobal
        :keyword connectivity_capabilities: Collection of additional settings to enhance specific
         topology behaviors of the connectivity configuration resource.
        :paramtype connectivity_capabilities:
         ~azure.mgmt.network.models.ConnectivityConfigurationPropertiesConnectivityCapabilities
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups: list[~azure.mgmt.network.models.ConnectivityGroupItem]
        :keyword delete_existing_peering: Flag if need to remove current existing peerings. Known
         values are: "False" and "True".
        :paramtype delete_existing_peering: str or ~azure.mgmt.network.models.DeleteExistingPeering
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.description = description
        self.connectivity_topology = connectivity_topology
        self.hubs = hubs
        self.is_global = is_global
        self.connectivity_capabilities = connectivity_capabilities
        self.applies_to_groups = applies_to_groups
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.delete_existing_peering = delete_existing_peering
        self.resource_guid: Optional[str] = None


class ConnectivityConfigurationListResult(_serialization.Model):
    """Result of the request to list network manager connectivity configurations. It contains a list
    of configurations and a link to get the next set of results.

    :ivar value: Gets a page of Connectivity Configurations.
    :vartype value: list[~azure.mgmt.network.models.ConnectivityConfiguration]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectivityConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ConnectivityConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a page of Connectivity Configurations.
        :paramtype value: list[~azure.mgmt.network.models.ConnectivityConfiguration]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectivityConfigurationPropertiesConnectivityCapabilities(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Collection of additional settings to enhance specific topology behaviors of the connectivity
    configuration resource.

    All required parameters must be populated in order to send to server.

    :ivar connected_group_private_endpoints_scale: Option indicating the scale of private endpoints
     allowed in the connected group of the connectivity configuration. Known values are: "Standard"
     and "HighScale".
    :vartype connected_group_private_endpoints_scale: str or
     ~azure.mgmt.network.models.ConnectedGroupPrivateEndpointsScale
    :ivar connected_group_address_overlap: Behavior to handle overlapped IP address space among
     members of the connected group of the connectivity configuration. Known values are: "Allowed"
     and "Disallowed".
    :vartype connected_group_address_overlap: str or
     ~azure.mgmt.network.models.ConnectedGroupAddressOverlap
    :ivar peering_enforcement: Option indicating enforcement of peerings created by the
     connectivity configuration. Known values are: "Unenforced" and "Enforced".
    :vartype peering_enforcement: str or ~azure.mgmt.network.models.PeeringEnforcement
    """

    _validation = {
        "connected_group_private_endpoints_scale": {"required": True},
        "connected_group_address_overlap": {"required": True},
        "peering_enforcement": {"required": True},
    }

    _attribute_map = {
        "connected_group_private_endpoints_scale": {"key": "connectedGroupPrivateEndpointsScale", "type": "str"},
        "connected_group_address_overlap": {"key": "connectedGroupAddressOverlap", "type": "str"},
        "peering_enforcement": {"key": "peeringEnforcement", "type": "str"},
    }

    def __init__(
        self,
        *,
        connected_group_private_endpoints_scale: Union[str, "_models.ConnectedGroupPrivateEndpointsScale"] = "Standard",
        connected_group_address_overlap: Union[str, "_models.ConnectedGroupAddressOverlap"] = "Allowed",
        peering_enforcement: Union[str, "_models.PeeringEnforcement"] = "Unenforced",
        **kwargs: Any
    ) -> None:
        """
        :keyword connected_group_private_endpoints_scale: Option indicating the scale of private
         endpoints allowed in the connected group of the connectivity configuration. Known values are:
         "Standard" and "HighScale".
        :paramtype connected_group_private_endpoints_scale: str or
         ~azure.mgmt.network.models.ConnectedGroupPrivateEndpointsScale
        :keyword connected_group_address_overlap: Behavior to handle overlapped IP address space among
         members of the connected group of the connectivity configuration. Known values are: "Allowed"
         and "Disallowed".
        :paramtype connected_group_address_overlap: str or
         ~azure.mgmt.network.models.ConnectedGroupAddressOverlap
        :keyword peering_enforcement: Option indicating enforcement of peerings created by the
         connectivity configuration. Known values are: "Unenforced" and "Enforced".
        :paramtype peering_enforcement: str or ~azure.mgmt.network.models.PeeringEnforcement
        """
        super().__init__(**kwargs)
        self.connected_group_private_endpoints_scale = connected_group_private_endpoints_scale
        self.connected_group_address_overlap = connected_group_address_overlap
        self.peering_enforcement = peering_enforcement


class ConnectivityDestination(_serialization.Model):
    """Parameters that define destination of connection.

    :ivar resource_id: The ID of the resource to which a connection attempt will be made.
    :vartype resource_id: str
    :ivar address: The IP address or URI the resource to which a connection attempt will be made.
    :vartype address: str
    :ivar port: Port on which check connectivity will be performed.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        address: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The ID of the resource to which a connection attempt will be made.
        :paramtype resource_id: str
        :keyword address: The IP address or URI the resource to which a connection attempt will be
         made.
        :paramtype address: str
        :keyword port: Port on which check connectivity will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectivityGroupItem(_serialization.Model):
    """Connectivity group item.

    All required parameters must be populated in order to send to server.

    :ivar network_group_id: Network group Id. Required.
    :vartype network_group_id: str
    :ivar use_hub_gateway: Flag if need to use hub gateway. Known values are: "False" and "True".
    :vartype use_hub_gateway: str or ~azure.mgmt.network.models.UseHubGateway
    :ivar is_global: Flag if global is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.models.IsGlobal
    :ivar group_connectivity: Group connectivity type. Required. Known values are: "None" and
     "DirectlyConnected".
    :vartype group_connectivity: str or ~azure.mgmt.network.models.GroupConnectivity
    """

    _validation = {
        "network_group_id": {"required": True},
        "group_connectivity": {"required": True},
    }

    _attribute_map = {
        "network_group_id": {"key": "networkGroupId", "type": "str"},
        "use_hub_gateway": {"key": "useHubGateway", "type": "str"},
        "is_global": {"key": "isGlobal", "type": "str"},
        "group_connectivity": {"key": "groupConnectivity", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_group_id: str,
        group_connectivity: Union[str, "_models.GroupConnectivity"],
        use_hub_gateway: Optional[Union[str, "_models.UseHubGateway"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_group_id: Network group Id. Required.
        :paramtype network_group_id: str
        :keyword use_hub_gateway: Flag if need to use hub gateway. Known values are: "False" and
         "True".
        :paramtype use_hub_gateway: str or ~azure.mgmt.network.models.UseHubGateway
        :keyword is_global: Flag if global is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.models.IsGlobal
        :keyword group_connectivity: Group connectivity type. Required. Known values are: "None" and
         "DirectlyConnected".
        :paramtype group_connectivity: str or ~azure.mgmt.network.models.GroupConnectivity
        """
        super().__init__(**kwargs)
        self.network_group_id = network_group_id
        self.use_hub_gateway = use_hub_gateway
        self.is_global = is_global
        self.group_connectivity = group_connectivity


class ConnectivityHop(_serialization.Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar previous_hop_ids: List of previous hop identifiers.
    :vartype previous_hop_ids: list[str]
    :ivar links: List of hop links.
    :vartype links: list[~azure.mgmt.network.models.HopLink]
    :ivar previous_links: List of previous hop links.
    :vartype previous_links: list[~azure.mgmt.network.models.HopLink]
    :ivar issues: List of issues.
    :vartype issues: list[~azure.mgmt.network.models.ConnectivityIssue]
    """

    _validation = {
        "type": {"readonly": True},
        "id": {"readonly": True},
        "address": {"readonly": True},
        "resource_id": {"readonly": True},
        "next_hop_ids": {"readonly": True},
        "previous_hop_ids": {"readonly": True},
        "links": {"readonly": True},
        "previous_links": {"readonly": True},
        "issues": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "next_hop_ids": {"key": "nextHopIds", "type": "[str]"},
        "previous_hop_ids": {"key": "previousHopIds", "type": "[str]"},
        "links": {"key": "links", "type": "[HopLink]"},
        "previous_links": {"key": "previousLinks", "type": "[HopLink]"},
        "issues": {"key": "issues", "type": "[ConnectivityIssue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.id: Optional[str] = None
        self.address: Optional[str] = None
        self.resource_id: Optional[str] = None
        self.next_hop_ids: Optional[list[str]] = None
        self.previous_hop_ids: Optional[list[str]] = None
        self.links: Optional[list["_models.HopLink"]] = None
        self.previous_links: Optional[list["_models.HopLink"]] = None
        self.issues: Optional[list["_models.ConnectivityIssue"]] = None


class ConnectivityInformation(_serialization.Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.models.ConnectivityHop]
    :ivar connection_status: The connection status. Known values are: "Unknown", "Connected",
     "Disconnected", and "Degraded".
    :vartype connection_status: str or ~azure.mgmt.network.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        "hops": {"readonly": True},
        "connection_status": {"readonly": True},
        "avg_latency_in_ms": {"readonly": True},
        "min_latency_in_ms": {"readonly": True},
        "max_latency_in_ms": {"readonly": True},
        "probes_sent": {"readonly": True},
        "probes_failed": {"readonly": True},
    }

    _attribute_map = {
        "hops": {"key": "hops", "type": "[ConnectivityHop]"},
        "connection_status": {"key": "connectionStatus", "type": "str"},
        "avg_latency_in_ms": {"key": "avgLatencyInMs", "type": "int"},
        "min_latency_in_ms": {"key": "minLatencyInMs", "type": "int"},
        "max_latency_in_ms": {"key": "maxLatencyInMs", "type": "int"},
        "probes_sent": {"key": "probesSent", "type": "int"},
        "probes_failed": {"key": "probesFailed", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.hops: Optional[list["_models.ConnectivityHop"]] = None
        self.connection_status: Optional[Union[str, "_models.ConnectionStatus"]] = None
        self.avg_latency_in_ms: Optional[int] = None
        self.min_latency_in_ms: Optional[int] = None
        self.max_latency_in_ms: Optional[int] = None
        self.probes_sent: Optional[int] = None
        self.probes_failed: Optional[int] = None


class ConnectivityIssue(_serialization.Model):
    """Information about an issue encountered in the process of checking for connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the issue. Known values are: "Local", "Inbound", and "Outbound".
    :vartype origin: str or ~azure.mgmt.network.models.Origin
    :ivar severity: The severity of the issue. Known values are: "Error" and "Warning".
    :vartype severity: str or ~azure.mgmt.network.models.Severity
    :ivar type: The type of issue. Known values are: "Unknown", "AgentStopped", "GuestFirewall",
     "DnsResolution", "SocketBind", "NetworkSecurityRule", "UserDefinedRoute", "PortThrottled", and
     "Platform".
    :vartype type: str or ~azure.mgmt.network.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        "origin": {"readonly": True},
        "severity": {"readonly": True},
        "type": {"readonly": True},
        "context": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "context": {"key": "context", "type": "[{str}]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.severity: Optional[Union[str, "_models.Severity"]] = None
        self.type: Optional[Union[str, "_models.IssueType"]] = None
        self.context: Optional[list[dict[str, str]]] = None


class ConnectivityParameters(_serialization.Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to server.

    :ivar source: The source of the connection. Required.
    :vartype source: ~azure.mgmt.network.models.ConnectivitySource
    :ivar destination: The destination of connection. Required.
    :vartype destination: ~azure.mgmt.network.models.ConnectivityDestination
    :ivar protocol: Network protocol. Known values are: "Tcp", "Http", "Https", and "Icmp".
    :vartype protocol: str or ~azure.mgmt.network.models.Protocol
    :ivar protocol_configuration: Configuration of the protocol.
    :vartype protocol_configuration: ~azure.mgmt.network.models.ProtocolConfiguration
    :ivar preferred_ip_version: Preferred IP version of the connection. Known values are: "IPv4"
     and "IPv6".
    :vartype preferred_ip_version: str or ~azure.mgmt.network.models.IPVersion
    """

    _validation = {
        "source": {"required": True},
        "destination": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectivitySource"},
        "destination": {"key": "destination", "type": "ConnectivityDestination"},
        "protocol": {"key": "protocol", "type": "str"},
        "protocol_configuration": {"key": "protocolConfiguration", "type": "ProtocolConfiguration"},
        "preferred_ip_version": {"key": "preferredIPVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: "_models.ConnectivitySource",
        destination: "_models.ConnectivityDestination",
        protocol: Optional[Union[str, "_models.Protocol"]] = None,
        protocol_configuration: Optional["_models.ProtocolConfiguration"] = None,
        preferred_ip_version: Optional[Union[str, "_models.IPVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: The source of the connection. Required.
        :paramtype source: ~azure.mgmt.network.models.ConnectivitySource
        :keyword destination: The destination of connection. Required.
        :paramtype destination: ~azure.mgmt.network.models.ConnectivityDestination
        :keyword protocol: Network protocol. Known values are: "Tcp", "Http", "Https", and "Icmp".
        :paramtype protocol: str or ~azure.mgmt.network.models.Protocol
        :keyword protocol_configuration: Configuration of the protocol.
        :paramtype protocol_configuration: ~azure.mgmt.network.models.ProtocolConfiguration
        :keyword preferred_ip_version: Preferred IP version of the connection. Known values are: "IPv4"
         and "IPv6".
        :paramtype preferred_ip_version: str or ~azure.mgmt.network.models.IPVersion
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.protocol = protocol
        self.protocol_configuration = protocol_configuration
        self.preferred_ip_version = preferred_ip_version


class ConnectivitySource(_serialization.Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to server.

    :ivar resource_id: The ID of the resource from which a connectivity check will be initiated.
     Required.
    :vartype resource_id: str
    :ivar port: The source port from which a connectivity check will be performed.
    :vartype port: int
    """

    _validation = {
        "resource_id": {"required": True},
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, resource_id: str, port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The ID of the resource from which a connectivity check will be initiated.
         Required.
        :paramtype resource_id: str
        :keyword port: The source port from which a connectivity check will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class Container(SubResource):
    """Reference to container resource in remote resource provider.

    :ivar id: Resource ID.
    :vartype id: str
    """


class ContainerNetworkInterface(SubResource):
    """Container network interface child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar container_network_interface_configuration: Container network interface configuration from
     which this container network interface is created.
    :vartype container_network_interface_configuration:
     ~azure.mgmt.network.models.ContainerNetworkInterfaceConfiguration
    :ivar container: Reference to the container to which this container network interface is
     attached.
    :vartype container: ~azure.mgmt.network.models.Container
    :ivar ip_configurations: Reference to the ip configuration on this container nic.
    :vartype ip_configurations:
     list[~azure.mgmt.network.models.ContainerNetworkInterfaceIpConfiguration]
    :ivar provisioning_state: The provisioning state of the container network interface resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "container_network_interface_configuration": {"readonly": True},
        "ip_configurations": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "container_network_interface_configuration": {
            "key": "properties.containerNetworkInterfaceConfiguration",
            "type": "ContainerNetworkInterfaceConfiguration",
        },
        "container": {"key": "properties.container", "type": "Container"},
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[ContainerNetworkInterfaceIpConfiguration]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        container: Optional["_models.Container"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword container: Reference to the container to which this container network interface is
         attached.
        :paramtype container: ~azure.mgmt.network.models.Container
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.container_network_interface_configuration: Optional["_models.ContainerNetworkInterfaceConfiguration"] = (
            None
        )
        self.container = container
        self.ip_configurations: Optional[list["_models.ContainerNetworkInterfaceIpConfiguration"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ContainerNetworkInterfaceConfiguration(SubResource):
    """Container network interface configuration child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ip_configurations: A list of ip configurations of the container network interface
     configuration.
    :vartype ip_configurations: list[~azure.mgmt.network.models.IPConfigurationProfile]
    :ivar container_network_interfaces: A list of container network interfaces created from this
     container network interface configuration.
    :vartype container_network_interfaces: list[~azure.mgmt.network.models.SubResource]
    :ivar provisioning_state: The provisioning state of the container network interface
     configuration resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating",
     "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfigurationProfile]"},
        "container_network_interfaces": {"key": "properties.containerNetworkInterfaces", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        ip_configurations: Optional[list["_models.IPConfigurationProfile"]] = None,
        container_network_interfaces: Optional[list["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword ip_configurations: A list of ip configurations of the container network interface
         configuration.
        :paramtype ip_configurations: list[~azure.mgmt.network.models.IPConfigurationProfile]
        :keyword container_network_interfaces: A list of container network interfaces created from this
         container network interface configuration.
        :paramtype container_network_interfaces: list[~azure.mgmt.network.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.ip_configurations = ip_configurations
        self.container_network_interfaces = container_network_interfaces
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ContainerNetworkInterfaceIpConfiguration(_serialization.Model):
    """The ip configuration for a container network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the container network interface IP
     configuration resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating",
     "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class Criterion(_serialization.Model):
    """A matching criteria which matches routes based on route prefix, community, and AS path.

    :ivar route_prefix: List of route prefixes which this criteria matches.
    :vartype route_prefix: list[str]
    :ivar community: List of BGP communities which this criteria matches.
    :vartype community: list[str]
    :ivar as_path: List of AS paths which this criteria matches.
    :vartype as_path: list[str]
    :ivar match_condition: Match condition to apply RouteMap rules. Known values are: "Unknown",
     "Contains", "Equals", "NotContains", and "NotEquals".
    :vartype match_condition: str or ~azure.mgmt.network.models.RouteMapMatchCondition
    """

    _attribute_map = {
        "route_prefix": {"key": "routePrefix", "type": "[str]"},
        "community": {"key": "community", "type": "[str]"},
        "as_path": {"key": "asPath", "type": "[str]"},
        "match_condition": {"key": "matchCondition", "type": "str"},
    }

    def __init__(
        self,
        *,
        route_prefix: Optional[list[str]] = None,
        community: Optional[list[str]] = None,
        as_path: Optional[list[str]] = None,
        match_condition: Optional[Union[str, "_models.RouteMapMatchCondition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword route_prefix: List of route prefixes which this criteria matches.
        :paramtype route_prefix: list[str]
        :keyword community: List of BGP communities which this criteria matches.
        :paramtype community: list[str]
        :keyword as_path: List of AS paths which this criteria matches.
        :paramtype as_path: list[str]
        :keyword match_condition: Match condition to apply RouteMap rules. Known values are: "Unknown",
         "Contains", "Equals", "NotContains", and "NotEquals".
        :paramtype match_condition: str or ~azure.mgmt.network.models.RouteMapMatchCondition
        """
        super().__init__(**kwargs)
        self.route_prefix = route_prefix
        self.community = community
        self.as_path = as_path
        self.match_condition = match_condition


class CrossTenantScopes(_serialization.Model):
    """Cross tenant scopes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tenant_id: Tenant ID.
    :vartype tenant_id: str
    :ivar management_groups: List of management groups.
    :vartype management_groups: list[str]
    :ivar subscriptions: List of subscriptions.
    :vartype subscriptions: list[str]
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "management_groups": {"readonly": True},
        "subscriptions": {"readonly": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "management_groups": {"key": "managementGroups", "type": "[str]"},
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.tenant_id: Optional[str] = None
        self.management_groups: Optional[list[str]] = None
        self.subscriptions: Optional[list[str]] = None


class CustomDnsConfigPropertiesFormat(_serialization.Model):
    """Contains custom Dns resolution configuration from customer.

    :ivar fqdn: Fqdn that resolves to private endpoint ip address.
    :vartype fqdn: str
    :ivar ip_addresses: A list of private ip addresses of the private endpoint.
    :vartype ip_addresses: list[str]
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
    }

    def __init__(self, *, fqdn: Optional[str] = None, ip_addresses: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword fqdn: Fqdn that resolves to private endpoint ip address.
        :paramtype fqdn: str
        :keyword ip_addresses: A list of private ip addresses of the private endpoint.
        :paramtype ip_addresses: list[str]
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_addresses = ip_addresses


class CustomIpPrefix(Resource):
    """Custom IP prefix resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the custom IP prefix.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar asn: The ASN for CIDR advertising. Should be an integer as string.
    :vartype asn: str
    :ivar cidr: The prefix range in CIDR notation. Should include the start address and the prefix
     length.
    :vartype cidr: str
    :ivar signed_message: Signed message for WAN validation.
    :vartype signed_message: str
    :ivar authorization_message: Authorization message for WAN validation.
    :vartype authorization_message: str
    :ivar custom_ip_prefix_parent: The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
    :vartype custom_ip_prefix_parent: ~azure.mgmt.network.models.SubResource
    :ivar child_custom_ip_prefixes: The list of all Children for IPv6 /48 CustomIpPrefix.
    :vartype child_custom_ip_prefixes: list[~azure.mgmt.network.models.SubResource]
    :ivar commissioned_state: The commissioned state of the Custom IP Prefix. Known values are:
     "Provisioning", "Provisioned", "Commissioning", "CommissionedNoInternetAdvertise",
     "Commissioned", "Decommissioning", "Deprovisioning", and "Deprovisioned".
    :vartype commissioned_state: str or ~azure.mgmt.network.models.CommissionedState
    :ivar express_route_advertise: Whether to do express route advertise.
    :vartype express_route_advertise: bool
    :ivar geo: The Geo for CIDR advertising. Should be an Geo code. Known values are: "GLOBAL",
     "AFRI", "APAC", "EURO", "LATAM", "NAM", "ME", "OCEANIA", "AQ", and "GLOBAL".
    :vartype geo: str or ~azure.mgmt.network.models.Geo
    :ivar no_internet_advertise: Whether to Advertise the range to Internet.
    :vartype no_internet_advertise: bool
    :ivar prefix_type: Type of custom IP prefix. Should be Singular, Parent, or Child. Known values
     are: "Singular", "Parent", and "Child".
    :vartype prefix_type: str or ~azure.mgmt.network.models.CustomIpPrefixType
    :ivar public_ip_prefixes: The list of all referenced PublicIpPrefixes.
    :vartype public_ip_prefixes: list[~azure.mgmt.network.models.SubResource]
    :ivar resource_guid: The resource GUID property of the custom IP prefix resource.
    :vartype resource_guid: str
    :ivar failed_reason: The reason why resource is in failed state.
    :vartype failed_reason: str
    :ivar provisioning_state: The provisioning state of the custom IP prefix resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "child_custom_ip_prefixes": {"readonly": True},
        "public_ip_prefixes": {"readonly": True},
        "resource_guid": {"readonly": True},
        "failed_reason": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "asn": {"key": "properties.asn", "type": "str"},
        "cidr": {"key": "properties.cidr", "type": "str"},
        "signed_message": {"key": "properties.signedMessage", "type": "str"},
        "authorization_message": {"key": "properties.authorizationMessage", "type": "str"},
        "custom_ip_prefix_parent": {"key": "properties.customIpPrefixParent", "type": "SubResource"},
        "child_custom_ip_prefixes": {"key": "properties.childCustomIpPrefixes", "type": "[SubResource]"},
        "commissioned_state": {"key": "properties.commissionedState", "type": "str"},
        "express_route_advertise": {"key": "properties.expressRouteAdvertise", "type": "bool"},
        "geo": {"key": "properties.geo", "type": "str"},
        "no_internet_advertise": {"key": "properties.noInternetAdvertise", "type": "bool"},
        "prefix_type": {"key": "properties.prefixType", "type": "str"},
        "public_ip_prefixes": {"key": "properties.publicIpPrefixes", "type": "[SubResource]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "failed_reason": {"key": "properties.failedReason", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        zones: Optional[list[str]] = None,
        asn: Optional[str] = None,
        cidr: Optional[str] = None,
        signed_message: Optional[str] = None,
        authorization_message: Optional[str] = None,
        custom_ip_prefix_parent: Optional["_models.SubResource"] = None,
        commissioned_state: Optional[Union[str, "_models.CommissionedState"]] = None,
        express_route_advertise: Optional[bool] = None,
        geo: Optional[Union[str, "_models.Geo"]] = None,
        no_internet_advertise: Optional[bool] = None,
        prefix_type: Optional[Union[str, "_models.CustomIpPrefixType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the custom IP prefix.
        :paramtype extended_location: ~azure.mgmt.network.models.ExtendedLocation
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword asn: The ASN for CIDR advertising. Should be an integer as string.
        :paramtype asn: str
        :keyword cidr: The prefix range in CIDR notation. Should include the start address and the
         prefix length.
        :paramtype cidr: str
        :keyword signed_message: Signed message for WAN validation.
        :paramtype signed_message: str
        :keyword authorization_message: Authorization message for WAN validation.
        :paramtype authorization_message: str
        :keyword custom_ip_prefix_parent: The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
        :paramtype custom_ip_prefix_parent: ~azure.mgmt.network.models.SubResource
        :keyword commissioned_state: The commissioned state of the Custom IP Prefix. Known values are:
         "Provisioning", "Provisioned", "Commissioning", "CommissionedNoInternetAdvertise",
         "Commissioned", "Decommissioning", "Deprovisioning", and "Deprovisioned".
        :paramtype commissioned_state: str or ~azure.mgmt.network.models.CommissionedState
        :keyword express_route_advertise: Whether to do express route advertise.
        :paramtype express_route_advertise: bool
        :keyword geo: The Geo for CIDR advertising. Should be an Geo code. Known values are: "GLOBAL",
         "AFRI", "APAC", "EURO", "LATAM", "NAM", "ME", "OCEANIA", "AQ", and "GLOBAL".
        :paramtype geo: str or ~azure.mgmt.network.models.Geo
        :keyword no_internet_advertise: Whether to Advertise the range to Internet.
        :paramtype no_internet_advertise: bool
        :keyword prefix_type: Type of custom IP prefix. Should be Singular, Parent, or Child. Known
         values are: "Singular", "Parent", and "Child".
        :paramtype prefix_type: str or ~azure.mgmt.network.models.CustomIpPrefixType
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.etag: Optional[str] = None
        self.zones = zones
        self.asn = asn
        self.cidr = cidr
        self.signed_message = signed_message
        self.authorization_message = authorization_message
        self.custom_ip_prefix_parent = custom_ip_prefix_parent
        self.child_custom_ip_prefixes: Optional[list["_models.SubResource"]] = None
        self.commissioned_state = commissioned_state
        self.express_route_advertise = express_route_advertise
        self.geo = geo
        self.no_internet_advertise = no_internet_advertise
        self.prefix_type = prefix_type
        self.public_ip_prefixes: Optional[list["_models.SubResource"]] = None
        self.resource_guid: Optional[str] = None
        self.failed_reason: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class CustomIpPrefixListResult(_serialization.Model):
    """Response for ListCustomIpPrefixes API service call.

    :ivar value: A list of Custom IP prefixes that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.models.CustomIpPrefix]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomIpPrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.CustomIpPrefix"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of Custom IP prefixes that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.CustomIpPrefix]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DdosCustomPolicy(Resource):
    """A DDoS custom policy in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS custom policy resource. It uniquely
     identifies the resource, even if the user changes its name or migrate the resource across
     subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS custom policy resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.resource_guid: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class DdosProtectionPlan(_serialization.Model):
    """A DDoS protection plan in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS protection plan resource. It
     uniquely identifies the resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS protection plan resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar public_ip_addresses: The list of public IPs associated with the DDoS protection plan
     resource. This list is read-only.
    :vartype public_ip_addresses: list[~azure.mgmt.network.models.SubResource]
    :ivar virtual_networks: The list of virtual networks associated with the DDoS protection plan
     resource. This list is read-only.
    :vartype virtual_networks: list[~azure.mgmt.network.models.SubResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "public_ip_addresses": {"readonly": True},
        "virtual_networks": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "public_ip_addresses": {"key": "properties.publicIPAddresses", "type": "[SubResource]"},
        "virtual_networks": {"key": "properties.virtualNetworks", "type": "[SubResource]"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags
        self.etag: Optional[str] = None
        self.resource_guid: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.public_ip_addresses: Optional[list["_models.SubResource"]] = None
        self.virtual_networks: Optional[list["_models.SubResource"]] = None


class DdosProtectionPlanListResult(_serialization.Model):
    """A list of DDoS protection plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of DDoS protection plans.
    :vartype value: list[~azure.mgmt.network.models.DdosProtectionPlan]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DdosProtectionPlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.DdosProtectionPlan"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of DDoS protection plans.
        :paramtype value: list[~azure.mgmt.network.models.DdosProtectionPlan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DdosSettings(_serialization.Model):
    """Contains the DDoS protection settings of the public IP.

    :ivar protection_mode: The DDoS protection mode of the public IP. Known values are:
     "VirtualNetworkInherited", "Enabled", and "Disabled".
    :vartype protection_mode: str or ~azure.mgmt.network.models.DdosSettingsProtectionMode
    :ivar ddos_protection_plan: The DDoS protection plan associated with the public IP. Can only be
     set if ProtectionMode is Enabled.
    :vartype ddos_protection_plan: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "protection_mode": {"key": "protectionMode", "type": "str"},
        "ddos_protection_plan": {"key": "ddosProtectionPlan", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        protection_mode: Optional[Union[str, "_models.DdosSettingsProtectionMode"]] = None,
        ddos_protection_plan: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protection_mode: The DDoS protection mode of the public IP. Known values are:
         "VirtualNetworkInherited", "Enabled", and "Disabled".
        :paramtype protection_mode: str or ~azure.mgmt.network.models.DdosSettingsProtectionMode
        :keyword ddos_protection_plan: The DDoS protection plan associated with the public IP. Can only
         be set if ProtectionMode is Enabled.
        :paramtype ddos_protection_plan: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.protection_mode = protection_mode
        self.ddos_protection_plan = ddos_protection_plan


class DefaultAdminRule(BaseAdminRule):
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "access": {"readonly": True},
        "priority": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(self, *, flag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(**kwargs)
        self.kind: str = "Default"
        self.description: Optional[str] = None
        self.flag = flag
        self.protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None
        self.sources: Optional[list["_models.AddressPrefixItem"]] = None
        self.destinations: Optional[list["_models.AddressPrefixItem"]] = None
        self.source_port_ranges: Optional[list[str]] = None
        self.destination_port_ranges: Optional[list[str]] = None
        self.access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None
        self.priority: Optional[int] = None
        self.direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class Delegation(SubResource):
    """Details the service to which the subnet is delegated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a subnet. This name can be used to
     access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_name: The name of the service to whom the subnet should be delegated (e.g.
     Microsoft.Sql/servers).
    :vartype service_name: str
    :ivar actions: The actions permitted to the service upon delegation.
    :vartype actions: list[str]
    :ivar provisioning_state: The provisioning state of the service delegation resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "actions": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_name": {"key": "properties.serviceName", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        service_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a subnet. This name can be used
         to access the resource.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword service_name: The name of the service to whom the subnet should be delegated (e.g.
         Microsoft.Sql/servers).
        :paramtype service_name: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type = type
        self.service_name = service_name
        self.actions: Optional[list[str]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class DelegationProperties(_serialization.Model):
    """Properties of the delegation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_name: The service name to which the NVA is delegated.
    :vartype service_name: str
    :ivar provisioning_state: Provisioning states of a resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, service_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword service_name: The service name to which the NVA is delegated.
        :paramtype service_name: str
        """
        super().__init__(**kwargs)
        self.service_name = service_name
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class DeviceProperties(_serialization.Model):
    """List of properties of the device.

    :ivar device_vendor: Name of the device Vendor.
    :vartype device_vendor: str
    :ivar device_model: Model of the device.
    :vartype device_model: str
    :ivar link_speed_in_mbps: Link speed.
    :vartype link_speed_in_mbps: int
    """

    _attribute_map = {
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_model": {"key": "deviceModel", "type": "str"},
        "link_speed_in_mbps": {"key": "linkSpeedInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        device_vendor: Optional[str] = None,
        device_model: Optional[str] = None,
        link_speed_in_mbps: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_vendor: Name of the device Vendor.
        :paramtype device_vendor: str
        :keyword device_model: Model of the device.
        :paramtype device_model: str
        :keyword link_speed_in_mbps: Link speed.
        :paramtype link_speed_in_mbps: int
        """
        super().__init__(**kwargs)
        self.device_vendor = device_vendor
        self.device_model = device_model
        self.link_speed_in_mbps = link_speed_in_mbps


class DhcpOptions(_serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network.
    Standard DHCP option for a subnet overrides VNET DHCP options.

    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: The list of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class Dimension(_serialization.Model):
    """Dimension of the metric.

    :ivar name: The name of the dimension.
    :vartype name: str
    :ivar display_name: The display name of the dimension.
    :vartype display_name: str
    :ivar internal_name: The internal name of the dimension.
    :vartype internal_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the dimension.
        :paramtype name: str
        :keyword display_name: The display name of the dimension.
        :paramtype display_name: str
        :keyword internal_name: The internal name of the dimension.
        :paramtype internal_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name


class DnsNameAvailabilityResult(_serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :ivar available: Domain availability (True/False).
    :vartype available: bool
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
    }

    def __init__(self, *, available: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword available: Domain availability (True/False).
        :paramtype available: bool
        """
        super().__init__(**kwargs)
        self.available = available


class DnsSettings(_serialization.Model):
    """DNS Proxy Settings in Firewall Policy.

    :ivar servers: List of Custom DNS Servers.
    :vartype servers: list[str]
    :ivar enable_proxy: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
    :vartype enable_proxy: bool
    :ivar require_proxy_for_network_rules: FQDNs in Network Rules are supported when set to true.
    :vartype require_proxy_for_network_rules: bool
    """

    _attribute_map = {
        "servers": {"key": "servers", "type": "[str]"},
        "enable_proxy": {"key": "enableProxy", "type": "bool"},
        "require_proxy_for_network_rules": {"key": "requireProxyForNetworkRules", "type": "bool"},
    }

    def __init__(
        self,
        *,
        servers: Optional[list[str]] = None,
        enable_proxy: Optional[bool] = None,
        require_proxy_for_network_rules: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword servers: List of Custom DNS Servers.
        :paramtype servers: list[str]
        :keyword enable_proxy: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
        :paramtype enable_proxy: bool
        :keyword require_proxy_for_network_rules: FQDNs in Network Rules are supported when set to
         true.
        :paramtype require_proxy_for_network_rules: bool
        """
        super().__init__(**kwargs)
        self.servers = servers
        self.enable_proxy = enable_proxy
        self.require_proxy_for_network_rules = require_proxy_for_network_rules


class DscpConfiguration(Resource):
    """Differentiated Services Code Point configuration for any given network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar markings: List of markings to be used in the configuration.
    :vartype markings: list[int]
    :ivar source_ip_ranges: Source IP ranges.
    :vartype source_ip_ranges: list[~azure.mgmt.network.models.QosIpRange]
    :ivar destination_ip_ranges: Destination IP ranges.
    :vartype destination_ip_ranges: list[~azure.mgmt.network.models.QosIpRange]
    :ivar source_port_ranges: Sources port ranges.
    :vartype source_port_ranges: list[~azure.mgmt.network.models.QosPortRange]
    :ivar destination_port_ranges: Destination port ranges.
    :vartype destination_port_ranges: list[~azure.mgmt.network.models.QosPortRange]
    :ivar protocol: RNM supported protocol types. Known values are: "DoNotUse", "Icmp", "Tcp",
     "Udp", "Gre", "Esp", "Ah", "Vxlan", and "All".
    :vartype protocol: str or ~azure.mgmt.network.models.ProtocolType
    :ivar qos_definition_collection: QoS object definitions.
    :vartype qos_definition_collection: list[~azure.mgmt.network.models.QosDefinition]
    :ivar qos_collection_id: Qos Collection ID generated by RNM.
    :vartype qos_collection_id: str
    :ivar associated_network_interfaces: Associated Network Interfaces to the DSCP Configuration.
    :vartype associated_network_interfaces: list[~azure.mgmt.network.models.NetworkInterface]
    :ivar resource_guid: The resource GUID property of the DSCP Configuration resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DSCP Configuration resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "qos_collection_id": {"readonly": True},
        "associated_network_interfaces": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "markings": {"key": "properties.markings", "type": "[int]"},
        "source_ip_ranges": {"key": "properties.sourceIpRanges", "type": "[QosIpRange]"},
        "destination_ip_ranges": {"key": "properties.destinationIpRanges", "type": "[QosIpRange]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[QosPortRange]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[QosPortRange]"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "qos_definition_collection": {"key": "properties.qosDefinitionCollection", "type": "[QosDefinition]"},
        "qos_collection_id": {"key": "properties.qosCollectionId", "type": "str"},
        "associated_network_interfaces": {
            "key": "properties.associatedNetworkInterfaces",
            "type": "[NetworkInterface]",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        markings: Optional[list[int]] = None,
        source_ip_ranges: Optional[list["_models.QosIpRange"]] = None,
        destination_ip_ranges: Optional[list["_models.QosIpRange"]] = None,
        source_port_ranges: Optional[list["_models.QosPortRange"]] = None,
        destination_port_ranges: Optional[list["_models.QosPortRange"]] = None,
        protocol: Optional[Union[str, "_models.ProtocolType"]] = None,
        qos_definition_collection: Optional[list["_models.QosDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword markings: List of markings to be used in the configuration.
        :paramtype markings: list[int]
        :keyword source_ip_ranges: Source IP ranges.
        :paramtype source_ip_ranges: list[~azure.mgmt.network.models.QosIpRange]
        :keyword destination_ip_ranges: Destination IP ranges.
        :paramtype destination_ip_ranges: list[~azure.mgmt.network.models.QosIpRange]
        :keyword source_port_ranges: Sources port ranges.
        :paramtype source_port_ranges: list[~azure.mgmt.network.models.QosPortRange]
        :keyword destination_port_ranges: Destination port ranges.
        :paramtype destination_port_ranges: list[~azure.mgmt.network.models.QosPortRange]
        :keyword protocol: RNM supported protocol types. Known values are: "DoNotUse", "Icmp", "Tcp",
         "Udp", "Gre", "Esp", "Ah", "Vxlan", and "All".
        :paramtype protocol: str or ~azure.mgmt.network.models.ProtocolType
        :keyword qos_definition_collection: QoS object definitions.
        :paramtype qos_definition_collection: list[~azure.mgmt.network.models.QosDefinition]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.markings = markings
        self.source_ip_ranges = source_ip_ranges
        self.destination_ip_ranges = destination_ip_ranges
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.protocol = protocol
        self.qos_definition_collection = qos_definition_collection
        self.qos_collection_id: Optional[str] = None
        self.associated_network_interfaces: Optional[list["_models.NetworkInterface"]] = None
        self.resource_guid: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class DscpConfigurationListResult(_serialization.Model):
    """Response for the DscpConfigurationList API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of dscp configurations in a resource group.
    :vartype value: list[~azure.mgmt.network.models.DscpConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DscpConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.DscpConfiguration"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of dscp configurations in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.DscpConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class EffectiveBaseSecurityAdminRule(_serialization.Model):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EffectiveSecurityAdminRule, EffectiveDefaultSecurityAdminRule

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.EffectiveAdminRuleKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Custom": "EffectiveSecurityAdminRule", "Default": "EffectiveDefaultSecurityAdminRule"}}

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_description: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[list["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        """
        super().__init__(**kwargs)
        self.id = id
        self.configuration_description = configuration_description
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind: Optional[str] = None


class EffectiveDefaultSecurityAdminRule(EffectiveBaseSecurityAdminRule):
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.EffectiveAdminRuleKind
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "kind": {"required": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "access": {"readonly": True},
        "priority": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_description: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[list["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(
            id=id,
            configuration_description=configuration_description,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind: str = "Default"
        self.description: Optional[str] = None
        self.flag = flag
        self.protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None
        self.sources: Optional[list["_models.AddressPrefixItem"]] = None
        self.destinations: Optional[list["_models.AddressPrefixItem"]] = None
        self.source_port_ranges: Optional[list[str]] = None
        self.destination_port_ranges: Optional[list[str]] = None
        self.access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None
        self.priority: Optional[int] = None
        self.direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class EffectiveNetworkSecurityGroup(_serialization.Model):
    """Effective network security group.

    :ivar network_security_group: The ID of network security group that is applied.
    :vartype network_security_group: ~azure.mgmt.network.models.SubResource
    :ivar association: Associated resources.
    :vartype association: ~azure.mgmt.network.models.EffectiveNetworkSecurityGroupAssociation
    :ivar effective_security_rules: A collection of effective security rules.
    :vartype effective_security_rules:
     list[~azure.mgmt.network.models.EffectiveNetworkSecurityRule]
    :ivar tag_map: Mapping of tags to list of IP Addresses included within the tag.
    :vartype tag_map: str
    """

    _attribute_map = {
        "network_security_group": {"key": "networkSecurityGroup", "type": "SubResource"},
        "association": {"key": "association", "type": "EffectiveNetworkSecurityGroupAssociation"},
        "effective_security_rules": {"key": "effectiveSecurityRules", "type": "[EffectiveNetworkSecurityRule]"},
        "tag_map": {"key": "tagMap", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_security_group: Optional["_models.SubResource"] = None,
        association: Optional["_models.EffectiveNetworkSecurityGroupAssociation"] = None,
        effective_security_rules: Optional[list["_models.EffectiveNetworkSecurityRule"]] = None,
        tag_map: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_security_group: The ID of network security group that is applied.
        :paramtype network_security_group: ~azure.mgmt.network.models.SubResource
        :keyword association: Associated resources.
        :paramtype association: ~azure.mgmt.network.models.EffectiveNetworkSecurityGroupAssociation
        :keyword effective_security_rules: A collection of effective security rules.
        :paramtype effective_security_rules:
         list[~azure.mgmt.network.models.EffectiveNetworkSecurityRule]
        :keyword tag_map: Mapping of tags to list of IP Addresses included within the tag.
        :paramtype tag_map: str
        """
        super().__init__(**kwargs)
        self.network_security_group = network_security_group
        self.association = association
        self.effective_security_rules = effective_security_rules
        self.tag_map = tag_map


class EffectiveNetworkSecurityGroupAssociation(_serialization.Model):
    """The effective network security group association.

    :ivar network_manager: The ID of the Azure network manager if assigned.
    :vartype network_manager: ~azure.mgmt.network.models.SubResource
    :ivar subnet: The ID of the subnet if assigned.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar network_interface: The ID of the network interface if assigned.
    :vartype network_interface: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "network_manager": {"key": "networkManager", "type": "SubResource"},
        "subnet": {"key": "subnet", "type": "SubResource"},
        "network_interface": {"key": "networkInterface", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        network_manager: Optional["_models.SubResource"] = None,
        subnet: Optional["_models.SubResource"] = None,
        network_interface: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_manager: The ID of the Azure network manager if assigned.
        :paramtype network_manager: ~azure.mgmt.network.models.SubResource
        :keyword subnet: The ID of the subnet if assigned.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword network_interface: The ID of the network interface if assigned.
        :paramtype network_interface: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.network_manager = network_manager
        self.subnet = subnet
        self.network_interface = network_interface


class EffectiveNetworkSecurityGroupListResult(_serialization.Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective network security groups.
    :vartype value: list[~azure.mgmt.network.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveNetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.EffectiveNetworkSecurityGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of effective network security groups.
        :paramtype value: list[~azure.mgmt.network.models.EffectiveNetworkSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class EffectiveNetworkSecurityRule(_serialization.Model):
    """Effective network security rules.

    :ivar name: The name of the security rule specified by the user (if created by the user).
    :vartype name: str
    :ivar protocol: The network protocol this rule applies to. Known values are: "Tcp", "Udp", and
     "All".
    :vartype protocol: str or ~azure.mgmt.network.models.EffectiveSecurityRuleProtocol
    :ivar source_port_range: The source port or range.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range.
    :vartype destination_port_range: str
    :ivar source_port_ranges: The source port ranges. Expected values include a single integer
     between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges. Expected values include a single
     integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype destination_port_ranges: list[str]
    :ivar source_address_prefix: The source address prefix.
    :vartype source_address_prefix: str
    :ivar destination_address_prefix: The destination address prefix.
    :vartype destination_address_prefix: str
    :ivar source_address_prefixes: The source address prefixes. Expected values include CIDR IP
     ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
     asterisk (*).
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefixes: The destination address prefixes. Expected values include
     CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and
     the asterisk (*).
    :vartype destination_address_prefixes: list[str]
    :ivar expanded_source_address_prefix: The expanded source address prefix.
    :vartype expanded_source_address_prefix: list[str]
    :ivar expanded_destination_address_prefix: Expanded destination address prefix.
    :vartype expanded_destination_address_prefix: list[str]
    :ivar access: Whether network traffic is allowed or denied. Known values are: "Allow" and
     "Deny".
    :vartype access: str or ~azure.mgmt.network.models.SecurityRuleAccess
    :ivar priority: The priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityRuleDirection
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source_port_range": {"key": "sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "destinationPortRange", "type": "str"},
        "source_port_ranges": {"key": "sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "destinationPortRanges", "type": "[str]"},
        "source_address_prefix": {"key": "sourceAddressPrefix", "type": "str"},
        "destination_address_prefix": {"key": "destinationAddressPrefix", "type": "str"},
        "source_address_prefixes": {"key": "sourceAddressPrefixes", "type": "[str]"},
        "destination_address_prefixes": {"key": "destinationAddressPrefixes", "type": "[str]"},
        "expanded_source_address_prefix": {"key": "expandedSourceAddressPrefix", "type": "[str]"},
        "expanded_destination_address_prefix": {"key": "expandedDestinationAddressPrefix", "type": "[str]"},
        "access": {"key": "access", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "direction": {"key": "direction", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.EffectiveSecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_port_ranges: Optional[list[str]] = None,
        destination_port_ranges: Optional[list[str]] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[list[str]] = None,
        destination_address_prefixes: Optional[list[str]] = None,
        expanded_source_address_prefix: Optional[list[str]] = None,
        expanded_destination_address_prefix: Optional[list[str]] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the security rule specified by the user (if created by the user).
        :paramtype name: str
        :keyword protocol: The network protocol this rule applies to. Known values are: "Tcp", "Udp",
         and "All".
        :paramtype protocol: str or ~azure.mgmt.network.models.EffectiveSecurityRuleProtocol
        :keyword source_port_range: The source port or range.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range.
        :paramtype destination_port_range: str
        :keyword source_port_ranges: The source port ranges. Expected values include a single integer
         between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges. Expected values include a single
         integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype destination_port_ranges: list[str]
        :keyword source_address_prefix: The source address prefix.
        :paramtype source_address_prefix: str
        :keyword destination_address_prefix: The destination address prefix.
        :paramtype destination_address_prefix: str
        :keyword source_address_prefixes: The source address prefixes. Expected values include CIDR IP
         ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
         asterisk (*).
        :paramtype source_address_prefixes: list[str]
        :keyword destination_address_prefixes: The destination address prefixes. Expected values
         include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System
         Tags, and the asterisk (*).
        :paramtype destination_address_prefixes: list[str]
        :keyword expanded_source_address_prefix: The expanded source address prefix.
        :paramtype expanded_source_address_prefix: list[str]
        :keyword expanded_destination_address_prefix: Expanded destination address prefix.
        :paramtype expanded_destination_address_prefix: list[str]
        :keyword access: Whether network traffic is allowed or denied. Known values are: "Allow" and
         "Deny".
        :paramtype access: str or ~azure.mgmt.network.models.SecurityRuleAccess
        :keyword priority: The priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.SecurityRuleDirection
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.expanded_source_address_prefix = expanded_source_address_prefix
        self.expanded_destination_address_prefix = expanded_destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction


class EffectiveRoute(_serialization.Model):
    """Effective Route.

    :ivar name: The name of the user defined route. This is optional.
    :vartype name: str
    :ivar disable_bgp_route_propagation: If true, on-premises routes are not propagated to the
     network interfaces in the subnet.
    :vartype disable_bgp_route_propagation: bool
    :ivar source: Who created the route. Known values are: "Unknown", "User",
     "VirtualNetworkGateway", and "Default".
    :vartype source: str or ~azure.mgmt.network.models.EffectiveRouteSource
    :ivar state: The value of effective route. Known values are: "Active" and "Invalid".
    :vartype state: str or ~azure.mgmt.network.models.EffectiveRouteState
    :ivar address_prefix: The address prefixes of the effective routes in CIDR notation.
    :vartype address_prefix: list[str]
    :ivar next_hop_ip_address: The IP address of the next hop of the effective route.
    :vartype next_hop_ip_address: list[str]
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
     "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.models.RouteNextHopType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "disable_bgp_route_propagation": {"key": "disableBgpRoutePropagation", "type": "bool"},
        "source": {"key": "source", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "address_prefix": {"key": "addressPrefix", "type": "[str]"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "[str]"},
        "next_hop_type": {"key": "nextHopType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disable_bgp_route_propagation: Optional[bool] = None,
        source: Optional[Union[str, "_models.EffectiveRouteSource"]] = None,
        state: Optional[Union[str, "_models.EffectiveRouteState"]] = None,
        address_prefix: Optional[list[str]] = None,
        next_hop_ip_address: Optional[list[str]] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the user defined route. This is optional.
        :paramtype name: str
        :keyword disable_bgp_route_propagation: If true, on-premises routes are not propagated to the
         network interfaces in the subnet.
        :paramtype disable_bgp_route_propagation: bool
        :keyword source: Who created the route. Known values are: "Unknown", "User",
         "VirtualNetworkGateway", and "Default".
        :paramtype source: str or ~azure.mgmt.network.models.EffectiveRouteSource
        :keyword state: The value of effective route. Known values are: "Active" and "Invalid".
        :paramtype state: str or ~azure.mgmt.network.models.EffectiveRouteState
        :keyword address_prefix: The address prefixes of the effective routes in CIDR notation.
        :paramtype address_prefix: list[str]
        :keyword next_hop_ip_address: The IP address of the next hop of the effective route.
        :paramtype next_hop_ip_address: list[str]
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
         "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.models.RouteNextHopType
        """
        super().__init__(**kwargs)
        self.name = name
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.source = source
        self.state = state
        self.address_prefix = address_prefix
        self.next_hop_ip_address = next_hop_ip_address
        self.next_hop_type = next_hop_type


class EffectiveRouteListResult(_serialization.Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective routes.
    :vartype value: list[~azure.mgmt.network.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveRoute]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.EffectiveRoute"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of effective routes.
        :paramtype value: list[~azure.mgmt.network.models.EffectiveRoute]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class EffectiveRouteMapRoute(_serialization.Model):
    """The effective RouteMap route configured on the connection resource.

    :ivar prefix: The address prefix of the route.
    :vartype prefix: str
    :ivar bgp_communities: BGP communities of the route.
    :vartype bgp_communities: str
    :ivar as_path: The ASPath of this route.
    :vartype as_path: str
    """

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "bgp_communities": {"key": "bgpCommunities", "type": "str"},
        "as_path": {"key": "asPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        prefix: Optional[str] = None,
        bgp_communities: Optional[str] = None,
        as_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword prefix: The address prefix of the route.
        :paramtype prefix: str
        :keyword bgp_communities: BGP communities of the route.
        :paramtype bgp_communities: str
        :keyword as_path: The ASPath of this route.
        :paramtype as_path: str
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.bgp_communities = bgp_communities
        self.as_path = as_path


class EffectiveRouteMapRouteList(_serialization.Model):
    """EffectiveRouteMapRoute List.

    :ivar value: The list of Effective RouteMap Routes configured on the connection resource.
    :vartype value: list[~azure.mgmt.network.models.EffectiveRouteMapRoute]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveRouteMapRoute]"},
    }

    def __init__(self, *, value: Optional[list["_models.EffectiveRouteMapRoute"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of Effective RouteMap Routes configured on the connection resource.
        :paramtype value: list[~azure.mgmt.network.models.EffectiveRouteMapRoute]
        """
        super().__init__(**kwargs)
        self.value = value


class EffectiveRoutesParameters(_serialization.Model):
    """The parameters specifying the resource whose effective routes are being requested.

    :ivar resource_id: The resource whose effective routes are being requested.
    :vartype resource_id: str
    :ivar virtual_wan_resource_type: The type of the specified resource like RouteTable,
     ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
    :vartype virtual_wan_resource_type: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "virtual_wan_resource_type": {"key": "virtualWanResourceType", "type": "str"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, virtual_wan_resource_type: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource whose effective routes are being requested.
        :paramtype resource_id: str
        :keyword virtual_wan_resource_type: The type of the specified resource like RouteTable,
         ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
        :paramtype virtual_wan_resource_type: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.virtual_wan_resource_type = virtual_wan_resource_type


class EffectiveSecurityAdminRule(EffectiveBaseSecurityAdminRule):
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.models.EffectiveAdminRuleKind
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: Unique identifier for this resource.
    :vartype resource_guid: str
    """

    _validation = {
        "kind": {"required": True},
        "priority": {"maximum": 4096, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_description: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[list["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[list["_models.ConfigurationGroup"]] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[list["_models.AddressPrefixItem"]] = None,
        destinations: Optional[list["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[list[str]] = None,
        destination_port_ranges: Optional[list[str]] = None,
        access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ConfigurationGroup]
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or ~azure.mgmt.network.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: Indicates the access allowed for this particular rule. Known values are:
         "Allow", "Deny", and "AlwaysAllow".
        :paramtype access: str or ~azure.mgmt.network.models.SecurityConfigurationRuleAccess
        :keyword priority: The priority of the rule. The value can be between 1 and 4096. The priority
         number must be unique for each rule in the collection. The lower the priority number, the
         higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.SecurityConfigurationRuleDirection
        """
        super().__init__(
            id=id,
            configuration_description=configuration_description,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind: str = "Custom"
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None


class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class EndpointServicesListResult(_serialization.Model):
    """Response for the ListAvailableEndpointServices API service call.

    :ivar value: List of available endpoint services in a region.
    :vartype value: list[~azure.mgmt.network.models.EndpointServiceResult]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EndpointServiceResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.EndpointServiceResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of available endpoint services in a region.
        :paramtype value: list[~azure.mgmt.network.models.EndpointServiceResult]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Error(_serialization.Model):
    """Common error representation.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error details.
    :vartype details: list[~azure.mgmt.network.models.ErrorDetails]
    :ivar inner_error: Inner error message.
    :vartype inner_error: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetails]"},
        "inner_error": {"key": "innerError", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.ErrorDetails"]] = None,
        inner_error: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: Error details.
        :paramtype details: list[~azure.mgmt.network.models.ErrorDetails]
        :keyword inner_error: Inner error message.
        :paramtype inner_error: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.network.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.network.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetail"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorDetails(_serialization.Model):
    """Common error details representation.

    :ivar code: Error code.
    :vartype code: str
    :ivar target: Error target.
    :vartype target: str
    :ivar message: Error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword message: Error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ErrorResponse(_serialization.Model):
    """The error object.

    :ivar error: The error details object.
    :vartype error: ~azure.mgmt.network.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details object.
        :paramtype error: ~azure.mgmt.network.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class EvaluatedNetworkSecurityGroup(_serialization.Model):
    """Results of network security group evaluation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_security_group_id: Network security group ID.
    :vartype network_security_group_id: str
    :ivar applied_to: Resource ID of nic or subnet to which network security group is applied.
    :vartype applied_to: str
    :ivar matched_rule: Matched network security rule.
    :vartype matched_rule: ~azure.mgmt.network.models.MatchedRule
    :ivar rules_evaluation_result: List of network security rules evaluation results.
    :vartype rules_evaluation_result:
     list[~azure.mgmt.network.models.NetworkSecurityRulesEvaluationResult]
    """

    _validation = {
        "rules_evaluation_result": {"readonly": True},
    }

    _attribute_map = {
        "network_security_group_id": {"key": "networkSecurityGroupId", "type": "str"},
        "applied_to": {"key": "appliedTo", "type": "str"},
        "matched_rule": {"key": "matchedRule", "type": "MatchedRule"},
        "rules_evaluation_result": {"key": "rulesEvaluationResult", "type": "[NetworkSecurityRulesEvaluationResult]"},
    }

    def __init__(
        self,
        *,
        network_security_group_id: Optional[str] = None,
        applied_to: Optional[str] = None,
        matched_rule: Optional["_models.MatchedRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_security_group_id: Network security group ID.
        :paramtype network_security_group_id: str
        :keyword applied_to: Resource ID of nic or subnet to which network security group is applied.
        :paramtype applied_to: str
        :keyword matched_rule: Matched network security rule.
        :paramtype matched_rule: ~azure.mgmt.network.models.MatchedRule
        """
        super().__init__(**kwargs)
        self.network_security_group_id = network_security_group_id
        self.applied_to = applied_to
        self.matched_rule = matched_rule
        self.rules_evaluation_result: Optional[list["_models.NetworkSecurityRulesEvaluationResult"]] = None


class ExceptionEntry(_serialization.Model):
    """Adds exception to allow a request when the condition is satisfied.

    All required parameters must be populated in order to send to server.

    :ivar match_variable: The variable on which we evaluate the exception condition. Required.
     Known values are: "RequestURI", "RemoteAddr", and "RequestHeader".
    :vartype match_variable: str or ~azure.mgmt.network.models.ExceptionEntryMatchVariable
    :ivar values: Allowed values for the matchVariable.
    :vartype values: list[str]
    :ivar value_match_operator: Operates on the allowed values for the matchVariable. Required.
     Known values are: "Equals", "Contains", "StartsWith", "EndsWith", and "IPMatch".
    :vartype value_match_operator: str or
     ~azure.mgmt.network.models.ExceptionEntryValueMatchOperator
    :ivar selector_match_operator: When the matchVariable points to a key-value pair (e.g,
     RequestHeader), this operates on the selector. Known values are: "Equals", "Contains",
     "StartsWith", and "EndsWith".
    :vartype selector_match_operator: str or
     ~azure.mgmt.network.models.ExceptionEntrySelectorMatchOperator
    :ivar selector: When the matchVariable points to a key-value pair (e.g, RequestHeader), this
     identifies the key.
    :vartype selector: str
    :ivar exception_managed_rule_sets: The managed rule sets that are associated with the
     exception.
    :vartype exception_managed_rule_sets: list[~azure.mgmt.network.models.ExclusionManagedRuleSet]
    """

    _validation = {
        "match_variable": {"required": True},
        "value_match_operator": {"required": True},
    }

    _attribute_map = {
        "match_variable": {"key": "matchVariable", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "value_match_operator": {"key": "valueMatchOperator", "type": "str"},
        "selector_match_operator": {"key": "selectorMatchOperator", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
        "exception_managed_rule_sets": {"key": "exceptionManagedRuleSets", "type": "[ExclusionManagedRuleSet]"},
    }

    def __init__(
        self,
        *,
        match_variable: Union[str, "_models.ExceptionEntryMatchVariable"],
        value_match_operator: Union[str, "_models.ExceptionEntryValueMatchOperator"],
        values: Optional[list[str]] = None,
        selector_match_operator: Optional[Union[str, "_models.ExceptionEntrySelectorMatchOperator"]] = None,
        selector: Optional[str] = None,
        exception_managed_rule_sets: Optional[list["_models.ExclusionManagedRuleSet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword match_variable: The variable on which we evaluate the exception condition. Required.
         Known values are: "RequestURI", "RemoteAddr", and "RequestHeader".
        :paramtype match_variable: str or ~azure.mgmt.network.models.ExceptionEntryMatchVariable
        :keyword values: Allowed values for the matchVariable.
        :paramtype values: list[str]
        :keyword value_match_operator: Operates on the allowed values for the matchVariable. Required.
         Known values are: "Equals", "Contains", "StartsWith", "EndsWith", and "IPMatch".
        :paramtype value_match_operator: str or
         ~azure.mgmt.network.models.ExceptionEntryValueMatchOperator
        :keyword selector_match_operator: When the matchVariable points to a key-value pair (e.g,
         RequestHeader), this operates on the selector. Known values are: "Equals", "Contains",
         "StartsWith", and "EndsWith".
        :paramtype selector_match_operator: str or
         ~azure.mgmt.network.models.ExceptionEntrySelectorMatchOperator
        :keyword selector: When the matchVariable points to a key-value pair (e.g, RequestHeader), this
         identifies the key.
        :paramtype selector: str
        :keyword exception_managed_rule_sets: The managed rule sets that are associated with the
         exception.
        :paramtype exception_managed_rule_sets:
         list[~azure.mgmt.network.models.ExclusionManagedRuleSet]
        """
        super().__init__(**kwargs)
        self.match_variable = match_variable
        self.values = values
        self.value_match_operator = value_match_operator
        self.selector_match_operator = selector_match_operator
        self.selector = selector
        self.exception_managed_rule_sets = exception_managed_rule_sets


class ExclusionManagedRule(_serialization.Model):
    """Defines a managed rule to use for exclusion.

    All required parameters must be populated in order to send to server.

    :ivar rule_id: Identifier for the managed rule. Required.
    :vartype rule_id: str
    """

    _validation = {
        "rule_id": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
    }

    def __init__(self, *, rule_id: str, **kwargs: Any) -> None:
        """
        :keyword rule_id: Identifier for the managed rule. Required.
        :paramtype rule_id: str
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id


class ExclusionManagedRuleGroup(_serialization.Model):
    """Defines a managed rule group to use for exclusion.

    All required parameters must be populated in order to send to server.

    :ivar rule_group_name: The managed rule group for exclusion. Required.
    :vartype rule_group_name: str
    :ivar rules: List of rules that will be excluded. If none specified, all rules in the group
     will be excluded.
    :vartype rules: list[~azure.mgmt.network.models.ExclusionManagedRule]
    """

    _validation = {
        "rule_group_name": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "rules": {"key": "rules", "type": "[ExclusionManagedRule]"},
    }

    def __init__(
        self, *, rule_group_name: str, rules: Optional[list["_models.ExclusionManagedRule"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword rule_group_name: The managed rule group for exclusion. Required.
        :paramtype rule_group_name: str
        :keyword rules: List of rules that will be excluded. If none specified, all rules in the group
         will be excluded.
        :paramtype rules: list[~azure.mgmt.network.models.ExclusionManagedRule]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ExclusionManagedRuleSet(_serialization.Model):
    """Defines a managed rule set for Exclusions.

    All required parameters must be populated in order to send to server.

    :ivar rule_set_type: Defines the rule set type to use. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: Defines the version of the rule set to use. Required.
    :vartype rule_set_version: str
    :ivar rule_groups: Defines the rule groups to apply to the rule set.
    :vartype rule_groups: list[~azure.mgmt.network.models.ExclusionManagedRuleGroup]
    """

    _validation = {
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
    }

    _attribute_map = {
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "rule_groups": {"key": "ruleGroups", "type": "[ExclusionManagedRuleGroup]"},
    }

    def __init__(
        self,
        *,
        rule_set_type: str,
        rule_set_version: str,
        rule_groups: Optional[list["_models.ExclusionManagedRuleGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_set_type: Defines the rule set type to use. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: Defines the version of the rule set to use. Required.
        :paramtype rule_set_version: str
        :keyword rule_groups: Defines the rule groups to apply to the rule set.
        :paramtype rule_groups: list[~azure.mgmt.network.models.ExclusionManagedRuleGroup]
        """
        super().__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_groups = rule_groups


class ExplicitProxy(_serialization.Model):
    """Explicit Proxy Settings in Firewall Policy.

    :ivar enable_explicit_proxy: When set to true, explicit proxy mode is enabled.
    :vartype enable_explicit_proxy: bool
    :ivar http_port: Port number for explicit proxy http protocol, cannot be greater than 64000.
    :vartype http_port: int
    :ivar https_port: Port number for explicit proxy https protocol, cannot be greater than 64000.
    :vartype https_port: int
    :ivar enable_pac_file: When set to true, pac file port and url needs to be provided.
    :vartype enable_pac_file: bool
    :ivar pac_file_port: Port number for firewall to serve PAC file.
    :vartype pac_file_port: int
    :ivar pac_file: SAS URL for PAC file.
    :vartype pac_file: str
    """

    _validation = {
        "http_port": {"maximum": 64000, "minimum": 0},
        "https_port": {"maximum": 64000, "minimum": 0},
        "pac_file_port": {"maximum": 64000, "minimum": 0},
    }

    _attribute_map = {
        "enable_explicit_proxy": {"key": "enableExplicitProxy", "type": "bool"},
        "http_port": {"key": "httpPort", "type": "int"},
        "https_port": {"key": "httpsPort", "type": "int"},
        "enable_pac_file": {"key": "enablePacFile", "type": "bool"},
        "pac_file_port": {"key": "pacFilePort", "type": "int"},
        "pac_file": {"key": "pacFile", "type": "str"},
    }

    def __init__(
        self,
        *,
        enable_explicit_proxy: Optional[bool] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        enable_pac_file: Optional[bool] = None,
        pac_file_port: Optional[int] = None,
        pac_file: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_explicit_proxy: When set to true, explicit proxy mode is enabled.
        :paramtype enable_explicit_proxy: bool
        :keyword http_port: Port number for explicit proxy http protocol, cannot be greater than 64000.
        :paramtype http_port: int
        :keyword https_port: Port number for explicit proxy https protocol, cannot be greater than
         64000.
        :paramtype https_port: int
        :keyword enable_pac_file: When set to true, pac file port and url needs to be provided.
        :paramtype enable_pac_file: bool
        :keyword pac_file_port: Port number for firewall to serve PAC file.
        :paramtype pac_file_port: int
        :keyword pac_file: SAS URL for PAC file.
        :paramtype pac_file: str
        """
        super().__init__(**kwargs)
        self.enable_explicit_proxy = enable_explicit_proxy
        self.http_port = http_port
        self.https_port = https_port
        self.enable_pac_file = enable_pac_file
        self.pac_file_port = pac_file_port
        self.pac_file = pac_file


class ExpressRouteCircuit(Resource):
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU.
    :vartype sku: ~azure.mgmt.network.models.ExpressRouteCircuitSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allow_classic_operations: Allow classic operations.
    :vartype allow_classic_operations: bool
    :ivar circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :vartype circuit_provisioning_state: str
    :ivar service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
     "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.models.ServiceProviderProvisioningState
    :ivar authorizations: The list of authorizations.
    :vartype authorizations: list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
    :ivar peerings: The list of peerings.
    :vartype peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar service_key: The ServiceKey.
    :vartype service_key: str
    :ivar service_provider_notes: The ServiceProviderNotes.
    :vartype service_provider_notes: str
    :ivar service_provider_properties: The ServiceProviderProperties.
    :vartype service_provider_properties:
     ~azure.mgmt.network.models.ExpressRouteCircuitServiceProviderProperties
    :ivar express_route_port: The reference to the ExpressRoutePort resource when the circuit is
     provisioned on an ExpressRoutePort resource.
    :vartype express_route_port: ~azure.mgmt.network.models.SubResource
    :ivar bandwidth_in_gbps: The bandwidth of the circuit when the circuit is provisioned on an
     ExpressRoutePort resource.
    :vartype bandwidth_in_gbps: float
    :ivar stag: The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
    :vartype stag: int
    :ivar provisioning_state: The provisioning state of the express route circuit resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar global_reach_enabled: Flag denoting global reach status.
    :vartype global_reach_enabled: bool
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar authorization_status: The authorization status of the Circuit.
    :vartype authorization_status: str
    :ivar enable_direct_port_rate_limit: Flag denoting rate-limiting status of the ExpressRoute
     direct-port circuit.
    :vartype enable_direct_port_rate_limit: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "stag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "authorization_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ExpressRouteCircuitSku"},
        "etag": {"key": "etag", "type": "str"},
        "allow_classic_operations": {"key": "properties.allowClassicOperations", "type": "bool"},
        "circuit_provisioning_state": {"key": "properties.circuitProvisioningState", "type": "str"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ExpressRouteCircuitAuthorization]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "service_key": {"key": "properties.serviceKey", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "service_provider_properties": {
            "key": "properties.serviceProviderProperties",
            "type": "ExpressRouteCircuitServiceProviderProperties",
        },
        "express_route_port": {"key": "properties.expressRoutePort", "type": "SubResource"},
        "bandwidth_in_gbps": {"key": "properties.bandwidthInGbps", "type": "float"},
        "stag": {"key": "properties.stag", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "global_reach_enabled": {"key": "properties.globalReachEnabled", "type": "bool"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_status": {"key": "properties.authorizationStatus", "type": "str"},
        "enable_direct_port_rate_limit": {"key": "properties.enableDirectPortRateLimit", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.ExpressRouteCircuitSku"] = None,
        allow_classic_operations: Optional[bool] = None,
        circuit_provisioning_state: Optional[str] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        authorizations: Optional[list["_models.ExpressRouteCircuitAuthorization"]] = None,
        peerings: Optional[list["_models.ExpressRouteCircuitPeering"]] = None,
        service_key: Optional[str] = None,
        service_provider_notes: Optional[str] = None,
        service_provider_properties: Optional["_models.ExpressRouteCircuitServiceProviderProperties"] = None,
        express_route_port: Optional["_models.SubResource"] = None,
        bandwidth_in_gbps: Optional[float] = None,
        gateway_manager_etag: Optional[str] = None,
        global_reach_enabled: Optional[bool] = None,
        authorization_key: Optional[str] = None,
        enable_direct_port_rate_limit: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU.
        :paramtype sku: ~azure.mgmt.network.models.ExpressRouteCircuitSku
        :keyword allow_classic_operations: Allow classic operations.
        :paramtype allow_classic_operations: bool
        :keyword circuit_provisioning_state: The CircuitProvisioningState state of the resource.
        :paramtype circuit_provisioning_state: str
        :keyword service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
         resource. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
         "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.models.ServiceProviderProvisioningState
        :keyword authorizations: The list of authorizations.
        :paramtype authorizations: list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
        :keyword peerings: The list of peerings.
        :paramtype peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
        :keyword service_key: The ServiceKey.
        :paramtype service_key: str
        :keyword service_provider_notes: The ServiceProviderNotes.
        :paramtype service_provider_notes: str
        :keyword service_provider_properties: The ServiceProviderProperties.
        :paramtype service_provider_properties:
         ~azure.mgmt.network.models.ExpressRouteCircuitServiceProviderProperties
        :keyword express_route_port: The reference to the ExpressRoutePort resource when the circuit is
         provisioned on an ExpressRoutePort resource.
        :paramtype express_route_port: ~azure.mgmt.network.models.SubResource
        :keyword bandwidth_in_gbps: The bandwidth of the circuit when the circuit is provisioned on an
         ExpressRoutePort resource.
        :paramtype bandwidth_in_gbps: float
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword global_reach_enabled: Flag denoting global reach status.
        :paramtype global_reach_enabled: bool
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword enable_direct_port_rate_limit: Flag denoting rate-limiting status of the ExpressRoute
         direct-port circuit.
        :paramtype enable_direct_port_rate_limit: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag: Optional[str] = None
        self.allow_classic_operations = allow_classic_operations
        self.circuit_provisioning_state = circuit_provisioning_state
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = service_key
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.express_route_port = express_route_port
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.stag: Optional[int] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.gateway_manager_etag = gateway_manager_etag
        self.global_reach_enabled = global_reach_enabled
        self.authorization_key = authorization_key
        self.authorization_status: Optional[str] = None
        self.enable_direct_port_rate_limit = enable_direct_port_rate_limit


class ExpressRouteCircuitArpTable(_serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :ivar age: Entry age in minutes.
    :vartype age: int
    :ivar interface: Interface address.
    :vartype interface: str
    :ivar ip_address: The IP address.
    :vartype ip_address: str
    :ivar mac_address: The MAC address.
    :vartype mac_address: str
    """

    _attribute_map = {
        "age": {"key": "age", "type": "int"},
        "interface": {"key": "interface", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        age: Optional[int] = None,
        interface: Optional[str] = None,
        ip_address: Optional[str] = None,
        mac_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword age: Entry age in minutes.
        :paramtype age: int
        :keyword interface: Interface address.
        :paramtype interface: str
        :keyword ip_address: The IP address.
        :paramtype ip_address: str
        :keyword mac_address: The MAC address.
        :paramtype mac_address: str
        """
        super().__init__(**kwargs)
        self.age = age
        self.interface = interface
        self.ip_address = ip_address
        self.mac_address = mac_address


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar authorization_use_status: The authorization use status. Known values are: "Available" and
     "InUse".
    :vartype authorization_use_status: str or ~azure.mgmt.network.models.AuthorizationUseStatus
    :ivar connection_resource_uri: The reference to the ExpressRoute connection resource using the
     authorization.
    :vartype connection_resource_uri: str
    :ivar provisioning_state: The provisioning state of the authorization resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "connection_resource_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_use_status": {"key": "properties.authorizationUseStatus", "type": "str"},
        "connection_resource_uri": {"key": "properties.connectionResourceUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        authorization_key: Optional[str] = None,
        authorization_use_status: Optional[Union[str, "_models.AuthorizationUseStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        :keyword authorization_use_status: The authorization use status. Known values are: "Available"
         and "InUse".
        :paramtype authorization_use_status: str or ~azure.mgmt.network.models.AuthorizationUseStatus
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.authorization_key = authorization_key
        self.authorization_use_status = authorization_use_status
        self.connection_resource_uri: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ExpressRouteCircuitConnection(SubResource):
    """Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the circuit initiating connection.
    :vartype express_route_circuit_peering: ~azure.mgmt.network.models.SubResource
    :ivar peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the peered circuit.
    :vartype peer_express_route_circuit_peering: ~azure.mgmt.network.models.SubResource
    :ivar address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
    :vartype address_prefix: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar ipv6_circuit_connection_config: IPv6 Address PrefixProperties of the express route
     circuit connection.
    :vartype ipv6_circuit_connection_config: ~azure.mgmt.network.models.Ipv6CircuitConnectionConfig
    :ivar circuit_connection_status: Express Route Circuit connection state. Known values are:
     "Connected", "Connecting", and "Disconnected".
    :vartype circuit_connection_status: str or ~azure.mgmt.network.models.CircuitConnectionStatus
    :ivar provisioning_state: The provisioning state of the express route circuit connection
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "circuit_connection_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "express_route_circuit_peering": {"key": "properties.expressRouteCircuitPeering", "type": "SubResource"},
        "peer_express_route_circuit_peering": {
            "key": "properties.peerExpressRouteCircuitPeering",
            "type": "SubResource",
        },
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "ipv6_circuit_connection_config": {
            "key": "properties.ipv6CircuitConnectionConfig",
            "type": "Ipv6CircuitConnectionConfig",
        },
        "circuit_connection_status": {"key": "properties.circuitConnectionStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        express_route_circuit_peering: Optional["_models.SubResource"] = None,
        peer_express_route_circuit_peering: Optional["_models.SubResource"] = None,
        address_prefix: Optional[str] = None,
        authorization_key: Optional[str] = None,
        ipv6_circuit_connection_config: Optional["_models.Ipv6CircuitConnectionConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the circuit initiating connection.
        :paramtype express_route_circuit_peering: ~azure.mgmt.network.models.SubResource
        :keyword peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the peered circuit.
        :paramtype peer_express_route_circuit_peering: ~azure.mgmt.network.models.SubResource
        :keyword address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :paramtype address_prefix: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        :keyword ipv6_circuit_connection_config: IPv6 Address PrefixProperties of the express route
         circuit connection.
        :paramtype ipv6_circuit_connection_config:
         ~azure.mgmt.network.models.Ipv6CircuitConnectionConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.peer_express_route_circuit_peering = peer_express_route_circuit_peering
        self.address_prefix = address_prefix
        self.authorization_key = authorization_key
        self.ipv6_circuit_connection_config = ipv6_circuit_connection_config
        self.circuit_connection_status: Optional[Union[str, "_models.CircuitConnectionStatus"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ExpressRouteCircuitConnectionListResult(_serialization.Model):
    """Response for ListConnections API service call retrieves all global reach connections that
    belongs to a Private Peering for an ExpressRouteCircuit.

    :ivar value: The global reach connection associated with Private Peering in an ExpressRoute
     Circuit.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteCircuitConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The global reach connection associated with Private Peering in an ExpressRoute
         Circuit.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitListResult(_serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :ivar value: A list of ExpressRouteCircuits in a resource group.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuit]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuit]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteCircuit"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRouteCircuits in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuit]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitPeering(SubResource):
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar peering_type: The peering type. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
    :ivar state: The peering state. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config: ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
    :ivar stats: The peering stats of express route circuit.
    :vartype stats: ~azure.mgmt.network.models.ExpressRouteCircuitStats
    :ivar provisioning_state: The provisioning state of the express route circuit peering resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :ivar route_filter: The reference to the RouteFilter resource.
    :vartype route_filter: ~azure.mgmt.network.models.SubResource
    :ivar ipv6_peering_config: The IPv6 peering configuration.
    :vartype ipv6_peering_config: ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
    :ivar express_route_connection: The ExpressRoute connection.
    :vartype express_route_connection: ~azure.mgmt.network.models.ExpressRouteConnectionId
    :ivar connections: The list of circuit connections associated with Azure Private Peering for
     this circuit.
    :vartype connections: list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
    :ivar peered_connections: The list of peered circuit connections associated with Azure Private
     Peering for this circuit.
    :vartype peered_connections: list[~azure.mgmt.network.models.PeerExpressRouteCircuitConnection]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "last_modified_by": {"readonly": True},
        "peered_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "stats": {"key": "properties.stats", "type": "ExpressRouteCircuitStats"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "str"},
        "route_filter": {"key": "properties.routeFilter", "type": "SubResource"},
        "ipv6_peering_config": {"key": "properties.ipv6PeeringConfig", "type": "Ipv6ExpressRouteCircuitPeeringConfig"},
        "express_route_connection": {"key": "properties.expressRouteConnection", "type": "ExpressRouteConnectionId"},
        "connections": {"key": "properties.connections", "type": "[ExpressRouteCircuitConnection]"},
        "peered_connections": {"key": "properties.peeredConnections", "type": "[PeerExpressRouteCircuitConnection]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRoutePeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRoutePeeringState"]] = None,
        azure_asn: Optional[int] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        primary_azure_port: Optional[str] = None,
        secondary_azure_port: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        stats: Optional["_models.ExpressRouteCircuitStats"] = None,
        gateway_manager_etag: Optional[str] = None,
        route_filter: Optional["_models.SubResource"] = None,
        ipv6_peering_config: Optional["_models.Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        express_route_connection: Optional["_models.ExpressRouteConnectionId"] = None,
        connections: Optional[list["_models.ExpressRouteCircuitConnection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword peering_type: The peering type. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
        :keyword state: The peering state. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
        :keyword azure_asn: The Azure ASN.
        :paramtype azure_asn: int
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword primary_azure_port: The primary port.
        :paramtype primary_azure_port: str
        :keyword secondary_azure_port: The secondary port.
        :paramtype secondary_azure_port: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
        :keyword stats: The peering stats of express route circuit.
        :paramtype stats: ~azure.mgmt.network.models.ExpressRouteCircuitStats
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword route_filter: The reference to the RouteFilter resource.
        :paramtype route_filter: ~azure.mgmt.network.models.SubResource
        :keyword ipv6_peering_config: The IPv6 peering configuration.
        :paramtype ipv6_peering_config: ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
        :keyword express_route_connection: The ExpressRoute connection.
        :paramtype express_route_connection: ~azure.mgmt.network.models.ExpressRouteConnectionId
        :keyword connections: The list of circuit connections associated with Azure Private Peering for
         this circuit.
        :paramtype connections: list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = azure_asn
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = primary_azure_port
        self.secondary_azure_port = secondary_azure_port
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by: Optional[str] = None
        self.route_filter = route_filter
        self.ipv6_peering_config = ipv6_peering_config
        self.express_route_connection = express_route_connection
        self.connections = connections
        self.peered_connections: Optional[list["_models.PeerExpressRouteCircuitConnection"]] = None


class ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Specifies the peering configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar advertised_public_prefixes: The reference to AdvertisedPublicPrefixes.
    :vartype advertised_public_prefixes: list[str]
    :ivar advertised_communities: The communities of bgp peering. Specified for microsoft peering.
    :vartype advertised_communities: list[str]
    :ivar advertised_public_prefixes_state: The advertised public prefix state of the Peering
     resource. Known values are: "NotConfigured", "Configuring", "Configured", and
     "ValidationNeeded".
    :vartype advertised_public_prefixes_state: str or
     ~azure.mgmt.network.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :ivar legacy_mode: The legacy mode of the peering.
    :vartype legacy_mode: int
    :ivar customer_asn: The CustomerASN of the peering.
    :vartype customer_asn: int
    :ivar routing_registry_name: The RoutingRegistryName of the configuration.
    :vartype routing_registry_name: str
    :ivar advertised_public_prefix_info: List of Prefix information required to perform validation.
    :vartype advertised_public_prefix_info:
     list[~azure.mgmt.network.models.AdvertisedPublicPrefixProperties]
    """

    _validation = {
        "advertised_public_prefixes_state": {"readonly": True},
    }

    _attribute_map = {
        "advertised_public_prefixes": {"key": "advertisedPublicPrefixes", "type": "[str]"},
        "advertised_communities": {"key": "advertisedCommunities", "type": "[str]"},
        "advertised_public_prefixes_state": {"key": "advertisedPublicPrefixesState", "type": "str"},
        "legacy_mode": {"key": "legacyMode", "type": "int"},
        "customer_asn": {"key": "customerASN", "type": "int"},
        "routing_registry_name": {"key": "routingRegistryName", "type": "str"},
        "advertised_public_prefix_info": {
            "key": "advertisedPublicPrefixInfo",
            "type": "[AdvertisedPublicPrefixProperties]",
        },
    }

    def __init__(
        self,
        *,
        advertised_public_prefixes: Optional[list[str]] = None,
        advertised_communities: Optional[list[str]] = None,
        legacy_mode: Optional[int] = None,
        customer_asn: Optional[int] = None,
        routing_registry_name: Optional[str] = None,
        advertised_public_prefix_info: Optional[list["_models.AdvertisedPublicPrefixProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword advertised_public_prefixes: The reference to AdvertisedPublicPrefixes.
        :paramtype advertised_public_prefixes: list[str]
        :keyword advertised_communities: The communities of bgp peering. Specified for microsoft
         peering.
        :paramtype advertised_communities: list[str]
        :keyword legacy_mode: The legacy mode of the peering.
        :paramtype legacy_mode: int
        :keyword customer_asn: The CustomerASN of the peering.
        :paramtype customer_asn: int
        :keyword routing_registry_name: The RoutingRegistryName of the configuration.
        :paramtype routing_registry_name: str
        :keyword advertised_public_prefix_info: List of Prefix information required to perform
         validation.
        :paramtype advertised_public_prefix_info:
         list[~azure.mgmt.network.models.AdvertisedPublicPrefixProperties]
        """
        super().__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_communities = advertised_communities
        self.advertised_public_prefixes_state: Optional[
            Union[str, "_models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"]
        ] = None
        self.legacy_mode = legacy_mode
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name
        self.advertised_public_prefix_info = advertised_public_prefix_info


class ExpressRouteCircuitPeeringId(_serialization.Model):
    """ExpressRoute circuit peering identifier.

    :ivar id: The ID of the ExpressRoute circuit peering.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of the ExpressRoute circuit peering.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ExpressRouteCircuitPeeringListResult(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an
    ExpressRouteCircuit.

    :ivar value: The peerings in an express route circuit.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteCircuitPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The peerings in an express route circuit.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitReference(_serialization.Model):
    """Reference to an express route circuit.

    :ivar id: Corresponding Express Route Circuit Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Corresponding Express Route Circuit Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ExpressRouteCircuitRoutesTable(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar network: IP address of a network entity.
    :vartype network: str
    :ivar next_hop: NextHop address.
    :vartype next_hop: str
    :ivar loc_prf: Local preference value as set with the set local-preference route-map
     configuration command.
    :vartype loc_prf: str
    :ivar weight: Route Weight.
    :vartype weight: int
    :ivar path: Autonomous system paths to the destination network.
    :vartype path: str
    """

    _attribute_map = {
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "loc_prf": {"key": "locPrf", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        network: Optional[str] = None,
        next_hop: Optional[str] = None,
        loc_prf: Optional[str] = None,
        weight: Optional[int] = None,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network: IP address of a network entity.
        :paramtype network: str
        :keyword next_hop: NextHop address.
        :paramtype next_hop: str
        :keyword loc_prf: Local preference value as set with the set local-preference route-map
         configuration command.
        :paramtype loc_prf: str
        :keyword weight: Route Weight.
        :paramtype weight: int
        :keyword path: Autonomous system paths to the destination network.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.network = network
        self.next_hop = next_hop
        self.loc_prf = loc_prf
        self.weight = weight
        self.path = path


class ExpressRouteCircuitRoutesTableSummary(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar neighbor: IP address of the neighbor.
    :vartype neighbor: str
    :ivar v: BGP version number spoken to the neighbor.
    :vartype v: int
    :ivar as_property: Autonomous system number.
    :vartype as_property: int
    :ivar up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :vartype up_down: str
    :ivar state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
     been received from a neighbor or peer group.
    :vartype state_pfx_rcd: str
    """

    _attribute_map = {
        "neighbor": {"key": "neighbor", "type": "str"},
        "v": {"key": "v", "type": "int"},
        "as_property": {"key": "as", "type": "int"},
        "up_down": {"key": "upDown", "type": "str"},
        "state_pfx_rcd": {"key": "statePfxRcd", "type": "str"},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        v: Optional[int] = None,
        as_property: Optional[int] = None,
        up_down: Optional[str] = None,
        state_pfx_rcd: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword neighbor: IP address of the neighbor.
        :paramtype neighbor: str
        :keyword v: BGP version number spoken to the neighbor.
        :paramtype v: int
        :keyword as_property: Autonomous system number.
        :paramtype as_property: int
        :keyword up_down: The length of time that the BGP session has been in the Established state, or
         the current status if not in the Established state.
        :paramtype up_down: str
        :keyword state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
         been received from a neighbor or peer group.
        :paramtype state_pfx_rcd: str
        """
        super().__init__(**kwargs)
        self.neighbor = neighbor
        self.v = v
        self.as_property = as_property
        self.up_down = up_down
        self.state_pfx_rcd = state_pfx_rcd


class ExpressRouteCircuitsArpTableListResult(_serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :ivar value: A list of the ARP tables.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitArpTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitArpTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteCircuitArpTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of the ARP tables.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitArpTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitServiceProviderProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :ivar service_provider_name: The serviceProviderName.
    :vartype service_provider_name: str
    :ivar peering_location: The peering location.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The BandwidthInMbps.
    :vartype bandwidth_in_mbps: int
    """

    _attribute_map = {
        "service_provider_name": {"key": "serviceProviderName", "type": "str"},
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "bandwidthInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_provider_name: Optional[str] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_provider_name: The serviceProviderName.
        :paramtype service_provider_name: str
        :keyword peering_location: The peering location.
        :paramtype peering_location: str
        :keyword bandwidth_in_mbps: The BandwidthInMbps.
        :paramtype bandwidth_in_mbps: int
        """
        super().__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps


class ExpressRouteCircuitSku(_serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar tier: The tier of the SKU. Known values are: "Standard", "Premium", "Basic", and "Local".
    :vartype tier: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuTier
    :ivar family: The family of the SKU. Known values are: "UnlimitedData" and "MeteredData".
    :vartype family: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "_models.ExpressRouteCircuitSkuTier"]] = None,
        family: Optional[Union[str, "_models.ExpressRouteCircuitSkuFamily"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU.
        :paramtype name: str
        :keyword tier: The tier of the SKU. Known values are: "Standard", "Premium", "Basic", and
         "Local".
        :paramtype tier: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuTier
        :keyword family: The family of the SKU. Known values are: "UnlimitedData" and "MeteredData".
        :paramtype family: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuFamily
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family


class ExpressRouteCircuitsRoutesTableListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: The list of routes table.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteCircuitRoutesTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of routes table.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitsRoutesTableSummaryListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: A list of the routes table.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTableSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteCircuitRoutesTableSummary"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of the routes table.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTableSummary]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitStats(_serialization.Model):
    """Contains stats associated with the peering.

    :ivar primarybytes_in: The Primary BytesIn of the peering.
    :vartype primarybytes_in: int
    :ivar primarybytes_out: The primary BytesOut of the peering.
    :vartype primarybytes_out: int
    :ivar secondarybytes_in: The secondary BytesIn of the peering.
    :vartype secondarybytes_in: int
    :ivar secondarybytes_out: The secondary BytesOut of the peering.
    :vartype secondarybytes_out: int
    """

    _attribute_map = {
        "primarybytes_in": {"key": "primarybytesIn", "type": "int"},
        "primarybytes_out": {"key": "primarybytesOut", "type": "int"},
        "secondarybytes_in": {"key": "secondarybytesIn", "type": "int"},
        "secondarybytes_out": {"key": "secondarybytesOut", "type": "int"},
    }

    def __init__(
        self,
        *,
        primarybytes_in: Optional[int] = None,
        primarybytes_out: Optional[int] = None,
        secondarybytes_in: Optional[int] = None,
        secondarybytes_out: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primarybytes_in: The Primary BytesIn of the peering.
        :paramtype primarybytes_in: int
        :keyword primarybytes_out: The primary BytesOut of the peering.
        :paramtype primarybytes_out: int
        :keyword secondarybytes_in: The secondary BytesIn of the peering.
        :paramtype secondarybytes_in: int
        :keyword secondarybytes_out: The secondary BytesOut of the peering.
        :paramtype secondarybytes_out: int
        """
        super().__init__(**kwargs)
        self.primarybytes_in = primarybytes_in
        self.primarybytes_out = primarybytes_out
        self.secondarybytes_in = secondarybytes_in
        self.secondarybytes_out = secondarybytes_out


class ExpressRouteConnection(SubResource):
    """ExpressRouteConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar provisioning_state: The provisioning state of the express route connection resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar express_route_circuit_peering: The ExpressRoute circuit peering.
    :vartype express_route_circuit_peering: ~azure.mgmt.network.models.ExpressRouteCircuitPeeringId
    :ivar authorization_key: Authorization key to establish the connection.
    :vartype authorization_key: str
    :ivar routing_weight: The routing weight associated to the connection.
    :vartype routing_weight: int
    :ivar enable_internet_security: Enable internet security.
    :vartype enable_internet_security: bool
    :ivar express_route_gateway_bypass: Enable FastPath to vWan Firewall hub.
    :vartype express_route_gateway_bypass: bool
    :ivar enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
     private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
    :vartype enable_private_link_fast_path: bool
    :ivar routing_configuration: The Routing Configuration indicating the associated and propagated
     route tables on this connection.
    :vartype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
    """

    _validation = {
        "name": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_circuit_peering": {
            "key": "properties.expressRouteCircuitPeering",
            "type": "ExpressRouteCircuitPeeringId",
        },
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "enable_internet_security": {"key": "properties.enableInternetSecurity", "type": "bool"},
        "express_route_gateway_bypass": {"key": "properties.expressRouteGatewayBypass", "type": "bool"},
        "enable_private_link_fast_path": {"key": "properties.enablePrivateLinkFastPath", "type": "bool"},
        "routing_configuration": {"key": "properties.routingConfiguration", "type": "RoutingConfiguration"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        express_route_circuit_peering: Optional["_models.ExpressRouteCircuitPeeringId"] = None,
        authorization_key: Optional[str] = None,
        routing_weight: Optional[int] = None,
        enable_internet_security: Optional[bool] = None,
        express_route_gateway_bypass: Optional[bool] = None,
        enable_private_link_fast_path: Optional[bool] = None,
        routing_configuration: Optional["_models.RoutingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword express_route_circuit_peering: The ExpressRoute circuit peering.
        :paramtype express_route_circuit_peering:
         ~azure.mgmt.network.models.ExpressRouteCircuitPeeringId
        :keyword authorization_key: Authorization key to establish the connection.
        :paramtype authorization_key: str
        :keyword routing_weight: The routing weight associated to the connection.
        :paramtype routing_weight: int
        :keyword enable_internet_security: Enable internet security.
        :paramtype enable_internet_security: bool
        :keyword express_route_gateway_bypass: Enable FastPath to vWan Firewall hub.
        :paramtype express_route_gateway_bypass: bool
        :keyword enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
         private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
        :paramtype enable_private_link_fast_path: bool
        :keyword routing_configuration: The Routing Configuration indicating the associated and
         propagated route tables on this connection.
        :paramtype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.authorization_key = authorization_key
        self.routing_weight = routing_weight
        self.enable_internet_security = enable_internet_security
        self.express_route_gateway_bypass = express_route_gateway_bypass
        self.enable_private_link_fast_path = enable_private_link_fast_path
        self.routing_configuration = routing_configuration


class ExpressRouteConnectionId(_serialization.Model):
    """The ID of the ExpressRouteConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the ExpressRouteConnection.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class ExpressRouteConnectionList(_serialization.Model):
    """ExpressRouteConnection list.

    :ivar value: The list of ExpressRoute connections.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteConnection]"},
    }

    def __init__(self, *, value: Optional[list["_models.ExpressRouteConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of ExpressRoute connections.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class ExpressRouteCrossConnection(Resource):
    """ExpressRouteCrossConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar primary_azure_port: The name of the primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The name of the secondary port.
    :vartype secondary_azure_port: str
    :ivar s_tag: The identifier of the circuit traffic.
    :vartype s_tag: int
    :ivar peering_location: The peering location of the ExpressRoute circuit.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The circuit bandwidth In Mbps.
    :vartype bandwidth_in_mbps: int
    :ivar express_route_circuit: The ExpressRouteCircuit.
    :vartype express_route_circuit: ~azure.mgmt.network.models.ExpressRouteCircuitReference
    :ivar service_provider_provisioning_state: The provisioning state of the circuit in the
     connectivity provider system. Known values are: "NotProvisioned", "Provisioning",
     "Provisioned", and "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.models.ServiceProviderProvisioningState
    :ivar service_provider_notes: Additional read only notes set by the connectivity provider.
    :vartype service_provider_notes: str
    :ivar provisioning_state: The provisioning state of the express route cross connection
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar peerings: The list of peerings.
    :vartype peerings: list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "primary_azure_port": {"readonly": True},
        "secondary_azure_port": {"readonly": True},
        "s_tag": {"readonly": True},
        "peering_location": {"readonly": True},
        "bandwidth_in_mbps": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "s_tag": {"key": "properties.sTag", "type": "int"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "properties.bandwidthInMbps", "type": "int"},
        "express_route_circuit": {"key": "properties.expressRouteCircuit", "type": "ExpressRouteCircuitReference"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCrossConnectionPeering]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        express_route_circuit: Optional["_models.ExpressRouteCircuitReference"] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        service_provider_notes: Optional[str] = None,
        peerings: Optional[list["_models.ExpressRouteCrossConnectionPeering"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword express_route_circuit: The ExpressRouteCircuit.
        :paramtype express_route_circuit: ~azure.mgmt.network.models.ExpressRouteCircuitReference
        :keyword service_provider_provisioning_state: The provisioning state of the circuit in the
         connectivity provider system. Known values are: "NotProvisioned", "Provisioning",
         "Provisioned", and "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.models.ServiceProviderProvisioningState
        :keyword service_provider_notes: Additional read only notes set by the connectivity provider.
        :paramtype service_provider_notes: str
        :keyword peerings: The list of peerings.
        :paramtype peerings: list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.primary_azure_port: Optional[str] = None
        self.secondary_azure_port: Optional[str] = None
        self.s_tag: Optional[int] = None
        self.peering_location: Optional[str] = None
        self.bandwidth_in_mbps: Optional[int] = None
        self.express_route_circuit = express_route_circuit
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.service_provider_notes = service_provider_notes
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.peerings = peerings


class ExpressRouteCrossConnectionListResult(_serialization.Model):
    """Response for ListExpressRouteCrossConnection API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ExpressRouteCrossConnection resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.ExpressRouteCrossConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of ExpressRouteCrossConnection resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ExpressRouteCrossConnectionPeering(SubResource):
    """Peering in an ExpressRoute Cross Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar peering_type: The peering type. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
    :ivar state: The peering state. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config: ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
    :ivar provisioning_state: The provisioning state of the express route cross connection peering
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :ivar ipv6_peering_config: The IPv6 peering configuration.
    :vartype ipv6_peering_config: ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
    """

    _validation = {
        "etag": {"readonly": True},
        "azure_asn": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "primary_azure_port": {"readonly": True},
        "secondary_azure_port": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "last_modified_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "str"},
        "ipv6_peering_config": {"key": "properties.ipv6PeeringConfig", "type": "Ipv6ExpressRouteCircuitPeeringConfig"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRoutePeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRoutePeeringState"]] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        gateway_manager_etag: Optional[str] = None,
        ipv6_peering_config: Optional["_models.Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword peering_type: The peering type. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
        :keyword state: The peering state. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword ipv6_peering_config: The IPv6 peering configuration.
        :paramtype ipv6_peering_config: ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn: Optional[int] = None
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port: Optional[str] = None
        self.secondary_azure_port: Optional[str] = None
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by: Optional[str] = None
        self.ipv6_peering_config = ipv6_peering_config


class ExpressRouteCrossConnectionPeeringList(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an
    ExpressRouteCrossConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The peerings in an express route cross connection.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnectionPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.ExpressRouteCrossConnectionPeering"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The peerings in an express route cross connection.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ExpressRouteCrossConnectionRoutesTableSummary(_serialization.Model):  # pylint: disable=name-too-long
    """The routes table associated with the ExpressRouteCircuit.

    :ivar neighbor: IP address of Neighbor router.
    :vartype neighbor: str
    :ivar asn: Autonomous system number.
    :vartype asn: int
    :ivar up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :vartype up_down: str
    :ivar state_or_prefixes_received: Current state of the BGP session, and the number of prefixes
     that have been received from a neighbor or peer group.
    :vartype state_or_prefixes_received: str
    """

    _attribute_map = {
        "neighbor": {"key": "neighbor", "type": "str"},
        "asn": {"key": "asn", "type": "int"},
        "up_down": {"key": "upDown", "type": "str"},
        "state_or_prefixes_received": {"key": "stateOrPrefixesReceived", "type": "str"},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        asn: Optional[int] = None,
        up_down: Optional[str] = None,
        state_or_prefixes_received: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword neighbor: IP address of Neighbor router.
        :paramtype neighbor: str
        :keyword asn: Autonomous system number.
        :paramtype asn: int
        :keyword up_down: The length of time that the BGP session has been in the Established state, or
         the current status if not in the Established state.
        :paramtype up_down: str
        :keyword state_or_prefixes_received: Current state of the BGP session, and the number of
         prefixes that have been received from a neighbor or peer group.
        :paramtype state_or_prefixes_received: str
        """
        super().__init__(**kwargs)
        self.neighbor = neighbor
        self.asn = asn
        self.up_down = up_down
        self.state_or_prefixes_received = state_or_prefixes_received


class ExpressRouteCrossConnectionsRoutesTableSummaryListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListRoutesTable associated with the Express Route Cross Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of the routes table.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnectionRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnectionRoutesTableSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.ExpressRouteCrossConnectionRoutesTableSummary"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of the routes table.
        :paramtype value:
         list[~azure.mgmt.network.models.ExpressRouteCrossConnectionRoutesTableSummary]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ExpressRouteFailoverCircuitResourceDetails(_serialization.Model):  # pylint: disable=name-too-long
    """ExpressRouteFailoverCircuitResourceDetails.

    :ivar nrp_resource_uri: NRP Resource URI of the circuit.
    :vartype nrp_resource_uri: str
    :ivar name: Circuit Name.
    :vartype name: str
    :ivar connection_name: Connection name associated with the circuit.
    :vartype connection_name: str
    """

    _attribute_map = {
        "nrp_resource_uri": {"key": "nrpResourceUri", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "connection_name": {"key": "connectionName", "type": "str"},
    }

    def __init__(
        self,
        *,
        nrp_resource_uri: Optional[str] = None,
        name: Optional[str] = None,
        connection_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword nrp_resource_uri: NRP Resource URI of the circuit.
        :paramtype nrp_resource_uri: str
        :keyword name: Circuit Name.
        :paramtype name: str
        :keyword connection_name: Connection name associated with the circuit.
        :paramtype connection_name: str
        """
        super().__init__(**kwargs)
        self.nrp_resource_uri = nrp_resource_uri
        self.name = name
        self.connection_name = connection_name


class ExpressRouteFailoverConnectionResourceDetails(_serialization.Model):  # pylint: disable=name-too-long
    """ExpressRouteFailoverConnectionResourceDetails.

    :ivar nrp_resource_uri: NRP Resource URI of the connection.
    :vartype nrp_resource_uri: str
    :ivar name: Connection Name.
    :vartype name: str
    :ivar status: The current status of the connection. Known values are: "Connected" and
     "Disconnected".
    :vartype status: str or ~azure.mgmt.network.models.FailoverConnectionStatus
    :ivar last_updated_time: Time when the connection was last updated.
    :vartype last_updated_time: str
    """

    _attribute_map = {
        "nrp_resource_uri": {"key": "nrpResourceUri", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        nrp_resource_uri: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.FailoverConnectionStatus"]] = None,
        last_updated_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword nrp_resource_uri: NRP Resource URI of the connection.
        :paramtype nrp_resource_uri: str
        :keyword name: Connection Name.
        :paramtype name: str
        :keyword status: The current status of the connection. Known values are: "Connected" and
         "Disconnected".
        :paramtype status: str or ~azure.mgmt.network.models.FailoverConnectionStatus
        :keyword last_updated_time: Time when the connection was last updated.
        :paramtype last_updated_time: str
        """
        super().__init__(**kwargs)
        self.nrp_resource_uri = nrp_resource_uri
        self.name = name
        self.status = status
        self.last_updated_time = last_updated_time


class ExpressRouteFailoverRedundantRoute(_serialization.Model):
    """ExpressRouteFailoverRedundantRoute.

    :ivar peering_locations: A list of all the peering locations for the redundant routes.
    :vartype peering_locations: list[str]
    :ivar routes: A list of all the redundant routes in the peering locations.
    :vartype routes: list[str]
    """

    _attribute_map = {
        "peering_locations": {"key": "peeringLocations", "type": "[str]"},
        "routes": {"key": "routes", "type": "[str]"},
    }

    def __init__(
        self, *, peering_locations: Optional[list[str]] = None, routes: Optional[list[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword peering_locations: A list of all the peering locations for the redundant routes.
        :paramtype peering_locations: list[str]
        :keyword routes: A list of all the redundant routes in the peering locations.
        :paramtype routes: list[str]
        """
        super().__init__(**kwargs)
        self.peering_locations = peering_locations
        self.routes = routes


class ExpressRouteFailoverSingleTestDetails(_serialization.Model):
    """ExpressRoute failover single test details.

    :ivar peering_location: Peering location of the test.
    :vartype peering_location: str
    :ivar status: The current status of the test. Known values are: "NotStarted", "Starting",
     "Running", "StartFailed", "Stopping", "Completed", "StopFailed", "Invalid", and "Expired".
    :vartype status: str or ~azure.mgmt.network.models.FailoverTestStatusForSingleTest
    :ivar start_time_utc: Time when the test was started.
    :vartype start_time_utc: str
    :ivar end_time_utc: Time when the test was completed.
    :vartype end_time_utc: str
    :ivar redundant_routes: List of routes received from this peering as well as some other peering
     location.
    :vartype redundant_routes: list[~azure.mgmt.network.models.ExpressRouteFailoverRedundantRoute]
    :ivar non_redundant_routes: List of al the routes that were received only from this peering
     location.
    :vartype non_redundant_routes: list[str]
    :ivar was_simulation_successful: Whether the failover simulation was successful or not.
    :vartype was_simulation_successful: bool
    :ivar failover_connection_details: List of all the failover connections for this peering
     location.
    :vartype failover_connection_details:
     list[~azure.mgmt.network.models.FailoverConnectionDetails]
    """

    _attribute_map = {
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time_utc": {"key": "startTimeUtc", "type": "str"},
        "end_time_utc": {"key": "endTimeUtc", "type": "str"},
        "redundant_routes": {"key": "redundantRoutes", "type": "[ExpressRouteFailoverRedundantRoute]"},
        "non_redundant_routes": {"key": "nonRedundantRoutes", "type": "[str]"},
        "was_simulation_successful": {"key": "wasSimulationSuccessful", "type": "bool"},
        "failover_connection_details": {"key": "failoverConnectionDetails", "type": "[FailoverConnectionDetails]"},
    }

    def __init__(
        self,
        *,
        peering_location: Optional[str] = None,
        status: Optional[Union[str, "_models.FailoverTestStatusForSingleTest"]] = None,
        start_time_utc: Optional[str] = None,
        end_time_utc: Optional[str] = None,
        redundant_routes: Optional[list["_models.ExpressRouteFailoverRedundantRoute"]] = None,
        non_redundant_routes: Optional[list[str]] = None,
        was_simulation_successful: Optional[bool] = None,
        failover_connection_details: Optional[list["_models.FailoverConnectionDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword peering_location: Peering location of the test.
        :paramtype peering_location: str
        :keyword status: The current status of the test. Known values are: "NotStarted", "Starting",
         "Running", "StartFailed", "Stopping", "Completed", "StopFailed", "Invalid", and "Expired".
        :paramtype status: str or ~azure.mgmt.network.models.FailoverTestStatusForSingleTest
        :keyword start_time_utc: Time when the test was started.
        :paramtype start_time_utc: str
        :keyword end_time_utc: Time when the test was completed.
        :paramtype end_time_utc: str
        :keyword redundant_routes: List of routes received from this peering as well as some other
         peering location.
        :paramtype redundant_routes:
         list[~azure.mgmt.network.models.ExpressRouteFailoverRedundantRoute]
        :keyword non_redundant_routes: List of al the routes that were received only from this peering
         location.
        :paramtype non_redundant_routes: list[str]
        :keyword was_simulation_successful: Whether the failover simulation was successful or not.
        :paramtype was_simulation_successful: bool
        :keyword failover_connection_details: List of all the failover connections for this peering
         location.
        :paramtype failover_connection_details:
         list[~azure.mgmt.network.models.FailoverConnectionDetails]
        """
        super().__init__(**kwargs)
        self.peering_location = peering_location
        self.status = status
        self.start_time_utc = start_time_utc
        self.end_time_utc = end_time_utc
        self.redundant_routes = redundant_routes
        self.non_redundant_routes = non_redundant_routes
        self.was_simulation_successful = was_simulation_successful
        self.failover_connection_details = failover_connection_details


class ExpressRouteFailoverStopApiParameters(_serialization.Model):
    """Start packet capture parameters on virtual network gateway.

    :ivar peering_location: Peering location of the test.
    :vartype peering_location: str
    :ivar was_simulation_successful: Whether the failover simulation was successful or not.
    :vartype was_simulation_successful: bool
    :ivar details: List of all the failover connections for this peering location.
    :vartype details: list[~azure.mgmt.network.models.FailoverConnectionDetails]
    """

    _attribute_map = {
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "was_simulation_successful": {"key": "wasSimulationSuccessful", "type": "bool"},
        "details": {"key": "details", "type": "[FailoverConnectionDetails]"},
    }

    def __init__(
        self,
        *,
        peering_location: Optional[str] = None,
        was_simulation_successful: Optional[bool] = None,
        details: Optional[list["_models.FailoverConnectionDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword peering_location: Peering location of the test.
        :paramtype peering_location: str
        :keyword was_simulation_successful: Whether the failover simulation was successful or not.
        :paramtype was_simulation_successful: bool
        :keyword details: List of all the failover connections for this peering location.
        :paramtype details: list[~azure.mgmt.network.models.FailoverConnectionDetails]
        """
        super().__init__(**kwargs)
        self.peering_location = peering_location
        self.was_simulation_successful = was_simulation_successful
        self.details = details


class ExpressRouteFailoverTestDetails(_serialization.Model):
    """ExpressRoute failover test details.

    :ivar peering_location: Peering location of the test.
    :vartype peering_location: str
    :ivar circuits: All circuits in the peering location.
    :vartype circuits: list[~azure.mgmt.network.models.ExpressRouteFailoverCircuitResourceDetails]
    :ivar status: The current status of the test. Known values are: "NotStarted", "Starting",
     "Running", "StartFailed", "Stopping", "Completed", "StopFailed", "Invalid", and "Expired".
    :vartype status: str or ~azure.mgmt.network.models.FailoverTestStatus
    :ivar start_time: Time when the test was started.
    :vartype start_time: str
    :ivar end_time: Time when the test was completed.
    :vartype end_time: str
    :ivar connections: All connections to the circuits in the peering location.
    :vartype connections:
     list[~azure.mgmt.network.models.ExpressRouteFailoverConnectionResourceDetails]
    :ivar test_guid: The unique GUID associated with the test.
    :vartype test_guid: str
    :ivar test_type: The type of failover test. Known values are: "SingleSiteFailover",
     "MultiSiteFailover", and "All".
    :vartype test_type: str or ~azure.mgmt.network.models.FailoverTestType
    :ivar issues: A list of all issues with the test.
    :vartype issues: list[str]
    """

    _attribute_map = {
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "circuits": {"key": "circuits", "type": "[ExpressRouteFailoverCircuitResourceDetails]"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "connections": {"key": "connections", "type": "[ExpressRouteFailoverConnectionResourceDetails]"},
        "test_guid": {"key": "testGuid", "type": "str"},
        "test_type": {"key": "testType", "type": "str"},
        "issues": {"key": "issues", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        peering_location: Optional[str] = None,
        circuits: Optional[list["_models.ExpressRouteFailoverCircuitResourceDetails"]] = None,
        status: Optional[Union[str, "_models.FailoverTestStatus"]] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        connections: Optional[list["_models.ExpressRouteFailoverConnectionResourceDetails"]] = None,
        test_guid: Optional[str] = None,
        test_type: Optional[Union[str, "_models.FailoverTestType"]] = None,
        issues: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword peering_location: Peering location of the test.
        :paramtype peering_location: str
        :keyword circuits: All circuits in the peering location.
        :paramtype circuits:
         list[~azure.mgmt.network.models.ExpressRouteFailoverCircuitResourceDetails]
        :keyword status: The current status of the test. Known values are: "NotStarted", "Starting",
         "Running", "StartFailed", "Stopping", "Completed", "StopFailed", "Invalid", and "Expired".
        :paramtype status: str or ~azure.mgmt.network.models.FailoverTestStatus
        :keyword start_time: Time when the test was started.
        :paramtype start_time: str
        :keyword end_time: Time when the test was completed.
        :paramtype end_time: str
        :keyword connections: All connections to the circuits in the peering location.
        :paramtype connections:
         list[~azure.mgmt.network.models.ExpressRouteFailoverConnectionResourceDetails]
        :keyword test_guid: The unique GUID associated with the test.
        :paramtype test_guid: str
        :keyword test_type: The type of failover test. Known values are: "SingleSiteFailover",
         "MultiSiteFailover", and "All".
        :paramtype test_type: str or ~azure.mgmt.network.models.FailoverTestType
        :keyword issues: A list of all issues with the test.
        :paramtype issues: list[str]
        """
        super().__init__(**kwargs)
        self.peering_location = peering_location
        self.circuits = circuits
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.connections = connections
        self.test_guid = test_guid
        self.test_type = test_type
        self.issues = issues


class ExpressRouteGateway(Resource):
    """ExpressRoute gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar auto_scale_configuration: Configuration for auto scaling.
    :vartype auto_scale_configuration:
     ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
    :ivar express_route_connections: List of ExpressRoute connections to the ExpressRoute gateway.
    :vartype express_route_connections: list[~azure.mgmt.network.models.ExpressRouteConnection]
    :ivar provisioning_state: The provisioning state of the express route gateway resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar virtual_hub: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
    :vartype virtual_hub: ~azure.mgmt.network.models.VirtualHubId
    :ivar allow_non_virtual_wan_traffic: Configures this gateway to accept traffic from non Virtual
     WAN networks.
    :vartype allow_non_virtual_wan_traffic: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "auto_scale_configuration": {
            "key": "properties.autoScaleConfiguration",
            "type": "ExpressRouteGatewayPropertiesAutoScaleConfiguration",
        },
        "express_route_connections": {"key": "properties.expressRouteConnections", "type": "[ExpressRouteConnection]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "VirtualHubId"},
        "allow_non_virtual_wan_traffic": {"key": "properties.allowNonVirtualWanTraffic", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        auto_scale_configuration: Optional["_models.ExpressRouteGatewayPropertiesAutoScaleConfiguration"] = None,
        express_route_connections: Optional[list["_models.ExpressRouteConnection"]] = None,
        virtual_hub: Optional["_models.VirtualHubId"] = None,
        allow_non_virtual_wan_traffic: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword auto_scale_configuration: Configuration for auto scaling.
        :paramtype auto_scale_configuration:
         ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
        :keyword express_route_connections: List of ExpressRoute connections to the ExpressRoute
         gateway.
        :paramtype express_route_connections: list[~azure.mgmt.network.models.ExpressRouteConnection]
        :keyword virtual_hub: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
        :paramtype virtual_hub: ~azure.mgmt.network.models.VirtualHubId
        :keyword allow_non_virtual_wan_traffic: Configures this gateway to accept traffic from non
         Virtual WAN networks.
        :paramtype allow_non_virtual_wan_traffic: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.auto_scale_configuration = auto_scale_configuration
        self.express_route_connections = express_route_connections
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.virtual_hub = virtual_hub
        self.allow_non_virtual_wan_traffic = allow_non_virtual_wan_traffic


class ExpressRouteGatewayList(_serialization.Model):
    """List of ExpressRoute gateways.

    :ivar value: List of ExpressRoute gateways.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteGateway]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteGateway]"},
    }

    def __init__(self, *, value: Optional[list["_models.ExpressRouteGateway"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of ExpressRoute gateways.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteGateway]
        """
        super().__init__(**kwargs)
        self.value = value


class ExpressRouteGatewayPropertiesAutoScaleConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Configuration for auto scaling.

    :ivar bounds: Minimum and maximum number of scale units to deploy.
    :vartype bounds:
     ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
    """

    _attribute_map = {
        "bounds": {"key": "bounds", "type": "ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds"},
    }

    def __init__(
        self,
        *,
        bounds: Optional["_models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bounds: Minimum and maximum number of scale units to deploy.
        :paramtype bounds:
         ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
        """
        super().__init__(**kwargs)
        self.bounds = bounds


class ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds(_serialization.Model):  # pylint: disable=name-too-long
    """Minimum and maximum number of scale units to deploy.

    :ivar min: Minimum number of scale units deployed for ExpressRoute gateway.
    :vartype min: int
    :ivar max: Maximum number of scale units deployed for ExpressRoute gateway.
    :vartype max: int
    """

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: Minimum number of scale units deployed for ExpressRoute gateway.
        :paramtype min: int
        :keyword max: Maximum number of scale units deployed for ExpressRoute gateway.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max


class ExpressRouteLink(SubResource):
    """ExpressRouteLink child resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of child port resource that is unique among child port resources of the
     parent.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar router_name: Name of Azure router associated with physical port.
    :vartype router_name: str
    :ivar interface_name: Name of Azure router interface.
    :vartype interface_name: str
    :ivar patch_panel_id: Mapping between physical port to patch panel port.
    :vartype patch_panel_id: str
    :ivar rack_id: Mapping of physical patch panel to rack.
    :vartype rack_id: str
    :ivar colo_location: Cololocation for ExpressRoute Hybrid Direct.
    :vartype colo_location: str
    :ivar connector_type: Physical fiber port type. Known values are: "LC" and "SC".
    :vartype connector_type: str or ~azure.mgmt.network.models.ExpressRouteLinkConnectorType
    :ivar admin_state: Administrative state of the physical port. Known values are: "Enabled" and
     "Disabled".
    :vartype admin_state: str or ~azure.mgmt.network.models.ExpressRouteLinkAdminState
    :ivar provisioning_state: The provisioning state of the express route link resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar mac_sec_config: MacSec configuration.
    :vartype mac_sec_config: ~azure.mgmt.network.models.ExpressRouteLinkMacSecConfig
    """

    _validation = {
        "etag": {"readonly": True},
        "router_name": {"readonly": True},
        "interface_name": {"readonly": True},
        "patch_panel_id": {"readonly": True},
        "rack_id": {"readonly": True},
        "colo_location": {"readonly": True},
        "connector_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "router_name": {"key": "properties.routerName", "type": "str"},
        "interface_name": {"key": "properties.interfaceName", "type": "str"},
        "patch_panel_id": {"key": "properties.patchPanelId", "type": "str"},
        "rack_id": {"key": "properties.rackId", "type": "str"},
        "colo_location": {"key": "properties.coloLocation", "type": "str"},
        "connector_type": {"key": "properties.connectorType", "type": "str"},
        "admin_state": {"key": "properties.adminState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "mac_sec_config": {"key": "properties.macSecConfig", "type": "ExpressRouteLinkMacSecConfig"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        admin_state: Optional[Union[str, "_models.ExpressRouteLinkAdminState"]] = None,
        mac_sec_config: Optional["_models.ExpressRouteLinkMacSecConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of child port resource that is unique among child port resources of the
         parent.
        :paramtype name: str
        :keyword admin_state: Administrative state of the physical port. Known values are: "Enabled"
         and "Disabled".
        :paramtype admin_state: str or ~azure.mgmt.network.models.ExpressRouteLinkAdminState
        :keyword mac_sec_config: MacSec configuration.
        :paramtype mac_sec_config: ~azure.mgmt.network.models.ExpressRouteLinkMacSecConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.router_name: Optional[str] = None
        self.interface_name: Optional[str] = None
        self.patch_panel_id: Optional[str] = None
        self.rack_id: Optional[str] = None
        self.colo_location: Optional[str] = None
        self.connector_type: Optional[Union[str, "_models.ExpressRouteLinkConnectorType"]] = None
        self.admin_state = admin_state
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.mac_sec_config = mac_sec_config


class ExpressRouteLinkListResult(_serialization.Model):
    """Response for ListExpressRouteLinks API service call.

    :ivar value: The list of ExpressRouteLink sub-resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteLink"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of ExpressRouteLink sub-resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteLink]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteLinkMacSecConfig(_serialization.Model):
    """ExpressRouteLink Mac Security Configuration.

    :ivar ckn_secret_identifier: Keyvault Secret Identifier URL containing Mac security CKN key.
    :vartype ckn_secret_identifier: str
    :ivar cak_secret_identifier: Keyvault Secret Identifier URL containing Mac security CAK key.
    :vartype cak_secret_identifier: str
    :ivar cipher: Mac security cipher. Known values are: "GcmAes256", "GcmAes128", "GcmAesXpn128",
     and "GcmAesXpn256".
    :vartype cipher: str or ~azure.mgmt.network.models.ExpressRouteLinkMacSecCipher
    :ivar sci_state: Sci mode enabled/disabled. Known values are: "Disabled" and "Enabled".
    :vartype sci_state: str or ~azure.mgmt.network.models.ExpressRouteLinkMacSecSciState
    """

    _attribute_map = {
        "ckn_secret_identifier": {"key": "cknSecretIdentifier", "type": "str"},
        "cak_secret_identifier": {"key": "cakSecretIdentifier", "type": "str"},
        "cipher": {"key": "cipher", "type": "str"},
        "sci_state": {"key": "sciState", "type": "str"},
    }

    def __init__(
        self,
        *,
        ckn_secret_identifier: Optional[str] = None,
        cak_secret_identifier: Optional[str] = None,
        cipher: Optional[Union[str, "_models.ExpressRouteLinkMacSecCipher"]] = None,
        sci_state: Optional[Union[str, "_models.ExpressRouteLinkMacSecSciState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ckn_secret_identifier: Keyvault Secret Identifier URL containing Mac security CKN key.
        :paramtype ckn_secret_identifier: str
        :keyword cak_secret_identifier: Keyvault Secret Identifier URL containing Mac security CAK key.
        :paramtype cak_secret_identifier: str
        :keyword cipher: Mac security cipher. Known values are: "GcmAes256", "GcmAes128",
         "GcmAesXpn128", and "GcmAesXpn256".
        :paramtype cipher: str or ~azure.mgmt.network.models.ExpressRouteLinkMacSecCipher
        :keyword sci_state: Sci mode enabled/disabled. Known values are: "Disabled" and "Enabled".
        :paramtype sci_state: str or ~azure.mgmt.network.models.ExpressRouteLinkMacSecSciState
        """
        super().__init__(**kwargs)
        self.ckn_secret_identifier = ckn_secret_identifier
        self.cak_secret_identifier = cak_secret_identifier
        self.cipher = cipher
        self.sci_state = sci_state


class ExpressRoutePort(Resource):
    """ExpressRoutePort resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar identity: The identity of ExpressRoutePort, if configured.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar peering_location: The name of the peering location that the ExpressRoutePort is mapped to
     physically.
    :vartype peering_location: str
    :ivar bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
    :vartype bandwidth_in_gbps: int
    :ivar provisioned_bandwidth_in_gbps: Aggregate Gbps of associated circuit bandwidths.
    :vartype provisioned_bandwidth_in_gbps: float
    :ivar mtu: Maximum transmission unit of the physical port pair(s).
    :vartype mtu: str
    :ivar encapsulation: Encapsulation method on physical ports. Known values are: "Dot1Q" and
     "QinQ".
    :vartype encapsulation: str or ~azure.mgmt.network.models.ExpressRoutePortsEncapsulation
    :ivar ether_type: Ether type of the physical port.
    :vartype ether_type: str
    :ivar allocation_date: Date of the physical port allocation to be used in Letter of
     Authorization.
    :vartype allocation_date: str
    :ivar links: The set of physical links of the ExpressRoutePort resource.
    :vartype links: list[~azure.mgmt.network.models.ExpressRouteLink]
    :ivar circuits: Reference the ExpressRoute circuit(s) that are provisioned on this
     ExpressRoutePort resource.
    :vartype circuits: list[~azure.mgmt.network.models.SubResource]
    :ivar provisioning_state: The provisioning state of the express route port resource. Known
     values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: The resource GUID property of the express route port resource.
    :vartype resource_guid: str
    :ivar billing_type: The billing type of the ExpressRoutePort resource. Known values are:
     "MeteredData" and "UnlimitedData".
    :vartype billing_type: str or ~azure.mgmt.network.models.ExpressRoutePortsBillingType
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioned_bandwidth_in_gbps": {"readonly": True},
        "mtu": {"readonly": True},
        "ether_type": {"readonly": True},
        "allocation_date": {"readonly": True},
        "circuits": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "bandwidth_in_gbps": {"key": "properties.bandwidthInGbps", "type": "int"},
        "provisioned_bandwidth_in_gbps": {"key": "properties.provisionedBandwidthInGbps", "type": "float"},
        "mtu": {"key": "properties.mtu", "type": "str"},
        "encapsulation": {"key": "properties.encapsulation", "type": "str"},
        "ether_type": {"key": "properties.etherType", "type": "str"},
        "allocation_date": {"key": "properties.allocationDate", "type": "str"},
        "links": {"key": "properties.links", "type": "[ExpressRouteLink]"},
        "circuits": {"key": "properties.circuits", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "billing_type": {"key": "properties.billingType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_gbps: Optional[int] = None,
        encapsulation: Optional[Union[str, "_models.ExpressRoutePortsEncapsulation"]] = None,
        links: Optional[list["_models.ExpressRouteLink"]] = None,
        billing_type: Optional[Union[str, "_models.ExpressRoutePortsBillingType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of ExpressRoutePort, if configured.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword peering_location: The name of the peering location that the ExpressRoutePort is mapped
         to physically.
        :paramtype peering_location: str
        :keyword bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
        :paramtype bandwidth_in_gbps: int
        :keyword encapsulation: Encapsulation method on physical ports. Known values are: "Dot1Q" and
         "QinQ".
        :paramtype encapsulation: str or ~azure.mgmt.network.models.ExpressRoutePortsEncapsulation
        :keyword links: The set of physical links of the ExpressRoutePort resource.
        :paramtype links: list[~azure.mgmt.network.models.ExpressRouteLink]
        :keyword billing_type: The billing type of the ExpressRoutePort resource. Known values are:
         "MeteredData" and "UnlimitedData".
        :paramtype billing_type: str or ~azure.mgmt.network.models.ExpressRoutePortsBillingType
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.identity = identity
        self.peering_location = peering_location
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.provisioned_bandwidth_in_gbps: Optional[float] = None
        self.mtu: Optional[str] = None
        self.encapsulation = encapsulation
        self.ether_type: Optional[str] = None
        self.allocation_date: Optional[str] = None
        self.links = links
        self.circuits: Optional[list["_models.SubResource"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.resource_guid: Optional[str] = None
        self.billing_type = billing_type


class ExpressRoutePortAuthorization(SubResource):
    """ExpressRoutePort Authorization resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar authorization_use_status: The authorization use status. Known values are: "Available" and
     "InUse".
    :vartype authorization_use_status: str or
     ~azure.mgmt.network.models.ExpressRoutePortAuthorizationUseStatus
    :ivar circuit_resource_uri: The reference to the ExpressRoute circuit resource using the
     authorization.
    :vartype circuit_resource_uri: str
    :ivar provisioning_state: The provisioning state of the authorization resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "authorization_key": {"readonly": True},
        "authorization_use_status": {"readonly": True},
        "circuit_resource_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_use_status": {"key": "properties.authorizationUseStatus", "type": "str"},
        "circuit_resource_uri": {"key": "properties.circuitResourceUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.authorization_key: Optional[str] = None
        self.authorization_use_status: Optional[Union[str, "_models.ExpressRoutePortAuthorizationUseStatus"]] = None
        self.circuit_resource_uri: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ExpressRoutePortAuthorizationListResult(_serialization.Model):
    """Response for ListExpressRoutePortAuthorizations API service call.

    :ivar value: The authorizations in an ExpressRoute Port.
    :vartype value: list[~azure.mgmt.network.models.ExpressRoutePortAuthorization]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRoutePortAuthorization]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRoutePortAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The authorizations in an ExpressRoute Port.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRoutePortAuthorization]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRoutePortListResult(_serialization.Model):
    """Response for ListExpressRoutePorts API service call.

    :ivar value: A list of ExpressRoutePort resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRoutePort]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRoutePort]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRoutePort"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRoutePort resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRoutePort]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRoutePortsLocation(Resource):
    """Definition of the ExpressRoutePorts peering location resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar address: Address of peering location.
    :vartype address: str
    :ivar contact: Contact details of peering locations.
    :vartype contact: str
    :ivar available_bandwidths: The inventory of available ExpressRoutePort bandwidths.
    :vartype available_bandwidths:
     list[~azure.mgmt.network.models.ExpressRoutePortsLocationBandwidths]
    :ivar provisioning_state: The provisioning state of the express route port location resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "address": {"readonly": True},
        "contact": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "address": {"key": "properties.address", "type": "str"},
        "contact": {"key": "properties.contact", "type": "str"},
        "available_bandwidths": {
            "key": "properties.availableBandwidths",
            "type": "[ExpressRoutePortsLocationBandwidths]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        available_bandwidths: Optional[list["_models.ExpressRoutePortsLocationBandwidths"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword available_bandwidths: The inventory of available ExpressRoutePort bandwidths.
        :paramtype available_bandwidths:
         list[~azure.mgmt.network.models.ExpressRoutePortsLocationBandwidths]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.address: Optional[str] = None
        self.contact: Optional[str] = None
        self.available_bandwidths = available_bandwidths
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ExpressRoutePortsLocationBandwidths(_serialization.Model):
    """Real-time inventory of available ExpressRoute port bandwidths.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar offer_name: Bandwidth descriptive name.
    :vartype offer_name: str
    :ivar value_in_gbps: Bandwidth value in Gbps.
    :vartype value_in_gbps: int
    """

    _validation = {
        "offer_name": {"readonly": True},
        "value_in_gbps": {"readonly": True},
    }

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_gbps": {"key": "valueInGbps", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offer_name: Optional[str] = None
        self.value_in_gbps: Optional[int] = None


class ExpressRoutePortsLocationListResult(_serialization.Model):
    """Response for ListExpressRoutePortsLocations API service call.

    :ivar value: The list of all ExpressRoutePort peering locations.
    :vartype value: list[~azure.mgmt.network.models.ExpressRoutePortsLocation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRoutePortsLocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRoutePortsLocation"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of all ExpressRoutePort peering locations.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRoutePortsLocation]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteProviderPort(Resource):
    """ExpressRouteProviderPort resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar port_pair_descriptor: The name of the port pair.
    :vartype port_pair_descriptor: str
    :ivar primary_azure_port: The name of the primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The name of the secondary port.
    :vartype secondary_azure_port: str
    :ivar peering_location: The peering location of the port pair.
    :vartype peering_location: str
    :ivar overprovision_factor: Overprovisioning factor for the port pair.
    :vartype overprovision_factor: int
    :ivar port_bandwidth_in_mbps: Bandwidth of the port in Mbps.
    :vartype port_bandwidth_in_mbps: int
    :ivar used_bandwidth_in_mbps: Used Bandwidth of the port in Mbps.
    :vartype used_bandwidth_in_mbps: int
    :ivar remaining_bandwidth_in_mbps: Remaining Bandwidth of the port in Mbps.
    :vartype remaining_bandwidth_in_mbps: int
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "port_pair_descriptor": {"readonly": True},
        "primary_azure_port": {"readonly": True},
        "secondary_azure_port": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "port_pair_descriptor": {"key": "properties.portPairDescriptor", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "overprovision_factor": {"key": "properties.overprovisionFactor", "type": "int"},
        "port_bandwidth_in_mbps": {"key": "properties.portBandwidthInMbps", "type": "int"},
        "used_bandwidth_in_mbps": {"key": "properties.usedBandwidthInMbps", "type": "int"},
        "remaining_bandwidth_in_mbps": {"key": "properties.remainingBandwidthInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        peering_location: Optional[str] = None,
        overprovision_factor: Optional[int] = None,
        port_bandwidth_in_mbps: Optional[int] = None,
        used_bandwidth_in_mbps: Optional[int] = None,
        remaining_bandwidth_in_mbps: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_location: The peering location of the port pair.
        :paramtype peering_location: str
        :keyword overprovision_factor: Overprovisioning factor for the port pair.
        :paramtype overprovision_factor: int
        :keyword port_bandwidth_in_mbps: Bandwidth of the port in Mbps.
        :paramtype port_bandwidth_in_mbps: int
        :keyword used_bandwidth_in_mbps: Used Bandwidth of the port in Mbps.
        :paramtype used_bandwidth_in_mbps: int
        :keyword remaining_bandwidth_in_mbps: Remaining Bandwidth of the port in Mbps.
        :paramtype remaining_bandwidth_in_mbps: int
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.port_pair_descriptor: Optional[str] = None
        self.primary_azure_port: Optional[str] = None
        self.secondary_azure_port: Optional[str] = None
        self.peering_location = peering_location
        self.overprovision_factor = overprovision_factor
        self.port_bandwidth_in_mbps = port_bandwidth_in_mbps
        self.used_bandwidth_in_mbps = used_bandwidth_in_mbps
        self.remaining_bandwidth_in_mbps = remaining_bandwidth_in_mbps


class ExpressRouteProviderPortListResult(_serialization.Model):
    """Response for ListExpressRouteProviderPort API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ExpressRouteProviderPort resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteProviderPort]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteProviderPort]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.ExpressRouteProviderPort"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of ExpressRouteProviderPort resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteProviderPort]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar peering_locations: A list of peering locations.
    :vartype peering_locations: list[str]
    :ivar bandwidths_offered: A list of bandwidths offered.
    :vartype bandwidths_offered:
     list[~azure.mgmt.network.models.ExpressRouteServiceProviderBandwidthsOffered]
    :ivar provisioning_state: The provisioning state of the express route service provider
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "peering_locations": {"key": "properties.peeringLocations", "type": "[str]"},
        "bandwidths_offered": {
            "key": "properties.bandwidthsOffered",
            "type": "[ExpressRouteServiceProviderBandwidthsOffered]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        peering_locations: Optional[list[str]] = None,
        bandwidths_offered: Optional[list["_models.ExpressRouteServiceProviderBandwidthsOffered"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_locations: A list of peering locations.
        :paramtype peering_locations: list[str]
        :keyword bandwidths_offered: A list of bandwidths offered.
        :paramtype bandwidths_offered:
         list[~azure.mgmt.network.models.ExpressRouteServiceProviderBandwidthsOffered]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ExpressRouteServiceProviderBandwidthsOffered(_serialization.Model):  # pylint: disable=name-too-long
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :ivar offer_name: The OfferName.
    :vartype offer_name: str
    :ivar value_in_mbps: The ValueInMbps.
    :vartype value_in_mbps: int
    """

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_mbps": {"key": "valueInMbps", "type": "int"},
    }

    def __init__(self, *, offer_name: Optional[str] = None, value_in_mbps: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword offer_name: The OfferName.
        :paramtype offer_name: str
        :keyword value_in_mbps: The ValueInMbps.
        :paramtype value_in_mbps: int
        """
        super().__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class ExpressRouteServiceProviderListResult(_serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :ivar value: A list of ExpressRouteResourceProvider resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteServiceProvider]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteServiceProvider]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ExpressRouteServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRouteResourceProvider resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteServiceProvider]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExtendedLocation(_serialization.Model):
    """ExtendedLocation complex type.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.network.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.network.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class FailoverConnectionDetails(_serialization.Model):
    """FailoverConnectionDetails.

    :ivar failover_connection_name: Name of the failover connection.
    :vartype failover_connection_name: str
    :ivar failover_location: Location of the failover connection.
    :vartype failover_location: str
    :ivar is_verified: Whether the customer was able to establish connectivity through this
     failover connection or not.
    :vartype is_verified: bool
    """

    _attribute_map = {
        "failover_connection_name": {"key": "failoverConnectionName", "type": "str"},
        "failover_location": {"key": "failoverLocation", "type": "str"},
        "is_verified": {"key": "isVerified", "type": "bool"},
    }

    def __init__(
        self,
        *,
        failover_connection_name: Optional[str] = None,
        failover_location: Optional[str] = None,
        is_verified: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword failover_connection_name: Name of the failover connection.
        :paramtype failover_connection_name: str
        :keyword failover_location: Location of the failover connection.
        :paramtype failover_location: str
        :keyword is_verified: Whether the customer was able to establish connectivity through this
         failover connection or not.
        :paramtype is_verified: bool
        """
        super().__init__(**kwargs)
        self.failover_connection_name = failover_connection_name
        self.failover_location = failover_location
        self.is_verified = is_verified


class FilterItems(_serialization.Model):
    """Will contain the filter name and values to operate on.

    :ivar field: The name of the field we would like to filter.
    :vartype field: str
    :ivar values: List of values to filter the current field by.
    :vartype values: list[str]
    """

    _attribute_map = {
        "field": {"key": "field", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, field: Optional[str] = None, values: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword field: The name of the field we would like to filter.
        :paramtype field: str
        :keyword values: List of values to filter the current field by.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.field = field
        self.values = values


class FirewallPacketCaptureParameters(_serialization.Model):
    """Azure Firewall Packet Capture Parameters.

    :ivar duration_in_seconds: Duration of packet capture in seconds. If the field is not provided,
     the default value is 60.
    :vartype duration_in_seconds: int
    :ivar number_of_packets_to_capture: Number of packets to be captured. If the field is not
     provided, the default value is 1000.
    :vartype number_of_packets_to_capture: int
    :ivar sas_url: Upload capture location.
    :vartype sas_url: str
    :ivar file_name: Name of file to be uploaded to sasURL.
    :vartype file_name: str
    :ivar protocol: The protocol of packets to capture. Known values are: "TCP", "UDP", "Any", and
     "ICMP".
    :vartype protocol: str or ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol
    :ivar flags: The tcp-flag type to be captured. Used with protocol TCP.
    :vartype flags: list[~azure.mgmt.network.models.AzureFirewallPacketCaptureFlags]
    :ivar filters: Rules to filter packet captures.
    :vartype filters: list[~azure.mgmt.network.models.AzureFirewallPacketCaptureRule]
    :ivar operation: The Azure Firewall packet capture operation to perform. Known values are:
     "Start", "Status", and "Stop".
    :vartype operation: str or ~azure.mgmt.network.models.AzureFirewallPacketCaptureOperationType
    """

    _validation = {
        "duration_in_seconds": {"maximum": 1800, "minimum": 30},
        "number_of_packets_to_capture": {"maximum": 90000, "minimum": 100},
    }

    _attribute_map = {
        "duration_in_seconds": {"key": "durationInSeconds", "type": "int"},
        "number_of_packets_to_capture": {"key": "numberOfPacketsToCapture", "type": "int"},
        "sas_url": {"key": "sasUrl", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "flags": {"key": "flags", "type": "[AzureFirewallPacketCaptureFlags]"},
        "filters": {"key": "filters", "type": "[AzureFirewallPacketCaptureRule]"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        duration_in_seconds: int = 60,
        number_of_packets_to_capture: int = 1000,
        sas_url: Optional[str] = None,
        file_name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.AzureFirewallNetworkRuleProtocol"]] = None,
        flags: Optional[list["_models.AzureFirewallPacketCaptureFlags"]] = None,
        filters: Optional[list["_models.AzureFirewallPacketCaptureRule"]] = None,
        operation: Union[str, "_models.AzureFirewallPacketCaptureOperationType"] = "Start",
        **kwargs: Any
    ) -> None:
        """
        :keyword duration_in_seconds: Duration of packet capture in seconds. If the field is not
         provided, the default value is 60.
        :paramtype duration_in_seconds: int
        :keyword number_of_packets_to_capture: Number of packets to be captured. If the field is not
         provided, the default value is 1000.
        :paramtype number_of_packets_to_capture: int
        :keyword sas_url: Upload capture location.
        :paramtype sas_url: str
        :keyword file_name: Name of file to be uploaded to sasURL.
        :paramtype file_name: str
        :keyword protocol: The protocol of packets to capture. Known values are: "TCP", "UDP", "Any",
         and "ICMP".
        :paramtype protocol: str or ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol
        :keyword flags: The tcp-flag type to be captured. Used with protocol TCP.
        :paramtype flags: list[~azure.mgmt.network.models.AzureFirewallPacketCaptureFlags]
        :keyword filters: Rules to filter packet captures.
        :paramtype filters: list[~azure.mgmt.network.models.AzureFirewallPacketCaptureRule]
        :keyword operation: The Azure Firewall packet capture operation to perform. Known values are:
         "Start", "Status", and "Stop".
        :paramtype operation: str or ~azure.mgmt.network.models.AzureFirewallPacketCaptureOperationType
        """
        super().__init__(**kwargs)
        self.duration_in_seconds = duration_in_seconds
        self.number_of_packets_to_capture = number_of_packets_to_capture
        self.sas_url = sas_url
        self.file_name = file_name
        self.protocol = protocol
        self.flags = flags
        self.filters = filters
        self.operation = operation


class FirewallPolicy(Resource):
    """FirewallPolicy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar identity: The identity of the firewall policy.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar size: A read-only string that represents the size of the FirewallPolicyPropertiesFormat
     in MB. (ex 0.5MB).
    :vartype size: str
    :ivar rule_collection_groups: List of references to FirewallPolicyRuleCollectionGroups.
    :vartype rule_collection_groups: list[~azure.mgmt.network.models.SubResource]
    :ivar provisioning_state: The provisioning state of the firewall policy resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar base_policy: The parent firewall policy from which rules are inherited.
    :vartype base_policy: ~azure.mgmt.network.models.SubResource
    :ivar firewalls: List of references to Azure Firewalls that this Firewall Policy is associated
     with.
    :vartype firewalls: list[~azure.mgmt.network.models.SubResource]
    :ivar child_policies: List of references to Child Firewall Policies.
    :vartype child_policies: list[~azure.mgmt.network.models.SubResource]
    :ivar threat_intel_mode: The operation mode for Threat Intelligence. Known values are: "Alert",
     "Deny", and "Off".
    :vartype threat_intel_mode: str or ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
    :ivar threat_intel_whitelist: ThreatIntel Whitelist for Firewall Policy.
    :vartype threat_intel_whitelist: ~azure.mgmt.network.models.FirewallPolicyThreatIntelWhitelist
    :ivar insights: Insights on Firewall Policy.
    :vartype insights: ~azure.mgmt.network.models.FirewallPolicyInsights
    :ivar snat: The private IP addresses/IP ranges to which traffic will not be SNAT.
    :vartype snat: ~azure.mgmt.network.models.FirewallPolicySNAT
    :ivar sql: SQL Settings definition.
    :vartype sql: ~azure.mgmt.network.models.FirewallPolicySQL
    :ivar dns_settings: DNS Proxy Settings definition.
    :vartype dns_settings: ~azure.mgmt.network.models.DnsSettings
    :ivar explicit_proxy: Explicit Proxy Settings definition.
    :vartype explicit_proxy: ~azure.mgmt.network.models.ExplicitProxy
    :ivar intrusion_detection: The configuration for Intrusion detection.
    :vartype intrusion_detection: ~azure.mgmt.network.models.FirewallPolicyIntrusionDetection
    :ivar transport_security: TLS Configuration definition.
    :vartype transport_security: ~azure.mgmt.network.models.FirewallPolicyTransportSecurity
    :ivar sku: The Firewall Policy SKU.
    :vartype sku: ~azure.mgmt.network.models.FirewallPolicySku
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "size": {"readonly": True},
        "rule_collection_groups": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "firewalls": {"readonly": True},
        "child_policies": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "size": {"key": "properties.size", "type": "str"},
        "rule_collection_groups": {"key": "properties.ruleCollectionGroups", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "base_policy": {"key": "properties.basePolicy", "type": "SubResource"},
        "firewalls": {"key": "properties.firewalls", "type": "[SubResource]"},
        "child_policies": {"key": "properties.childPolicies", "type": "[SubResource]"},
        "threat_intel_mode": {"key": "properties.threatIntelMode", "type": "str"},
        "threat_intel_whitelist": {
            "key": "properties.threatIntelWhitelist",
            "type": "FirewallPolicyThreatIntelWhitelist",
        },
        "insights": {"key": "properties.insights", "type": "FirewallPolicyInsights"},
        "snat": {"key": "properties.snat", "type": "FirewallPolicySNAT"},
        "sql": {"key": "properties.sql", "type": "FirewallPolicySQL"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "DnsSettings"},
        "explicit_proxy": {"key": "properties.explicitProxy", "type": "ExplicitProxy"},
        "intrusion_detection": {"key": "properties.intrusionDetection", "type": "FirewallPolicyIntrusionDetection"},
        "transport_security": {"key": "properties.transportSecurity", "type": "FirewallPolicyTransportSecurity"},
        "sku": {"key": "properties.sku", "type": "FirewallPolicySku"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        base_policy: Optional["_models.SubResource"] = None,
        threat_intel_mode: Optional[Union[str, "_models.AzureFirewallThreatIntelMode"]] = None,
        threat_intel_whitelist: Optional["_models.FirewallPolicyThreatIntelWhitelist"] = None,
        insights: Optional["_models.FirewallPolicyInsights"] = None,
        snat: Optional["_models.FirewallPolicySNAT"] = None,
        sql: Optional["_models.FirewallPolicySQL"] = None,
        dns_settings: Optional["_models.DnsSettings"] = None,
        explicit_proxy: Optional["_models.ExplicitProxy"] = None,
        intrusion_detection: Optional["_models.FirewallPolicyIntrusionDetection"] = None,
        transport_security: Optional["_models.FirewallPolicyTransportSecurity"] = None,
        sku: Optional["_models.FirewallPolicySku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the firewall policy.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword base_policy: The parent firewall policy from which rules are inherited.
        :paramtype base_policy: ~azure.mgmt.network.models.SubResource
        :keyword threat_intel_mode: The operation mode for Threat Intelligence. Known values are:
         "Alert", "Deny", and "Off".
        :paramtype threat_intel_mode: str or ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
        :keyword threat_intel_whitelist: ThreatIntel Whitelist for Firewall Policy.
        :paramtype threat_intel_whitelist:
         ~azure.mgmt.network.models.FirewallPolicyThreatIntelWhitelist
        :keyword insights: Insights on Firewall Policy.
        :paramtype insights: ~azure.mgmt.network.models.FirewallPolicyInsights
        :keyword snat: The private IP addresses/IP ranges to which traffic will not be SNAT.
        :paramtype snat: ~azure.mgmt.network.models.FirewallPolicySNAT
        :keyword sql: SQL Settings definition.
        :paramtype sql: ~azure.mgmt.network.models.FirewallPolicySQL
        :keyword dns_settings: DNS Proxy Settings definition.
        :paramtype dns_settings: ~azure.mgmt.network.models.DnsSettings
        :keyword explicit_proxy: Explicit Proxy Settings definition.
        :paramtype explicit_proxy: ~azure.mgmt.network.models.ExplicitProxy
        :keyword intrusion_detection: The configuration for Intrusion detection.
        :paramtype intrusion_detection: ~azure.mgmt.network.models.FirewallPolicyIntrusionDetection
        :keyword transport_security: TLS Configuration definition.
        :paramtype transport_security: ~azure.mgmt.network.models.FirewallPolicyTransportSecurity
        :keyword sku: The Firewall Policy SKU.
        :paramtype sku: ~azure.mgmt.network.models.FirewallPolicySku
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.identity = identity
        self.size: Optional[str] = None
        self.rule_collection_groups: Optional[list["_models.SubResource"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.base_policy = base_policy
        self.firewalls: Optional[list["_models.SubResource"]] = None
        self.child_policies: Optional[list["_models.SubResource"]] = None
        self.threat_intel_mode = threat_intel_mode
        self.threat_intel_whitelist = threat_intel_whitelist
        self.insights = insights
        self.snat = snat
        self.sql = sql
        self.dns_settings = dns_settings
        self.explicit_proxy = explicit_proxy
        self.intrusion_detection = intrusion_detection
        self.transport_security = transport_security
        self.sku = sku


class FirewallPolicyCertificateAuthority(_serialization.Model):
    """Trusted Root certificates properties for tls.

    :ivar key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :vartype key_vault_secret_id: str
    :ivar name: Name of the CA certificate.
    :vartype name: str
    """

    _attribute_map = {
        "key_vault_secret_id": {"key": "keyVaultSecretId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, key_vault_secret_id: Optional[str] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
         'Certificate' object stored in KeyVault.
        :paramtype key_vault_secret_id: str
        :keyword name: Name of the CA certificate.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.key_vault_secret_id = key_vault_secret_id
        self.name = name


class FirewallPolicyDraft(Resource):
    """FirewallPolicy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar base_policy: The parent firewall policy from which rules are inherited.
    :vartype base_policy: ~azure.mgmt.network.models.SubResource
    :ivar threat_intel_mode: The operation mode for Threat Intelligence. Known values are: "Alert",
     "Deny", and "Off".
    :vartype threat_intel_mode: str or ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
    :ivar threat_intel_whitelist: ThreatIntel Whitelist for Firewall Policy.
    :vartype threat_intel_whitelist: ~azure.mgmt.network.models.FirewallPolicyThreatIntelWhitelist
    :ivar insights: Insights on Firewall Policy.
    :vartype insights: ~azure.mgmt.network.models.FirewallPolicyInsights
    :ivar snat: The private IP addresses/IP ranges to which traffic will not be SNAT.
    :vartype snat: ~azure.mgmt.network.models.FirewallPolicySNAT
    :ivar sql: SQL Settings definition.
    :vartype sql: ~azure.mgmt.network.models.FirewallPolicySQL
    :ivar dns_settings: DNS Proxy Settings definition.
    :vartype dns_settings: ~azure.mgmt.network.models.DnsSettings
    :ivar explicit_proxy: Explicit Proxy Settings definition.
    :vartype explicit_proxy: ~azure.mgmt.network.models.ExplicitProxy
    :ivar intrusion_detection: The configuration for Intrusion detection.
    :vartype intrusion_detection: ~azure.mgmt.network.models.FirewallPolicyIntrusionDetection
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "base_policy": {"key": "properties.basePolicy", "type": "SubResource"},
        "threat_intel_mode": {"key": "properties.threatIntelMode", "type": "str"},
        "threat_intel_whitelist": {
            "key": "properties.threatIntelWhitelist",
            "type": "FirewallPolicyThreatIntelWhitelist",
        },
        "insights": {"key": "properties.insights", "type": "FirewallPolicyInsights"},
        "snat": {"key": "properties.snat", "type": "FirewallPolicySNAT"},
        "sql": {"key": "properties.sql", "type": "FirewallPolicySQL"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "DnsSettings"},
        "explicit_proxy": {"key": "properties.explicitProxy", "type": "ExplicitProxy"},
        "intrusion_detection": {"key": "properties.intrusionDetection", "type": "FirewallPolicyIntrusionDetection"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        base_policy: Optional["_models.SubResource"] = None,
        threat_intel_mode: Optional[Union[str, "_models.AzureFirewallThreatIntelMode"]] = None,
        threat_intel_whitelist: Optional["_models.FirewallPolicyThreatIntelWhitelist"] = None,
        insights: Optional["_models.FirewallPolicyInsights"] = None,
        snat: Optional["_models.FirewallPolicySNAT"] = None,
        sql: Optional["_models.FirewallPolicySQL"] = None,
        dns_settings: Optional["_models.DnsSettings"] = None,
        explicit_proxy: Optional["_models.ExplicitProxy"] = None,
        intrusion_detection: Optional["_models.FirewallPolicyIntrusionDetection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword base_policy: The parent firewall policy from which rules are inherited.
        :paramtype base_policy: ~azure.mgmt.network.models.SubResource
        :keyword threat_intel_mode: The operation mode for Threat Intelligence. Known values are:
         "Alert", "Deny", and "Off".
        :paramtype threat_intel_mode: str or ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
        :keyword threat_intel_whitelist: ThreatIntel Whitelist for Firewall Policy.
        :paramtype threat_intel_whitelist:
         ~azure.mgmt.network.models.FirewallPolicyThreatIntelWhitelist
        :keyword insights: Insights on Firewall Policy.
        :paramtype insights: ~azure.mgmt.network.models.FirewallPolicyInsights
        :keyword snat: The private IP addresses/IP ranges to which traffic will not be SNAT.
        :paramtype snat: ~azure.mgmt.network.models.FirewallPolicySNAT
        :keyword sql: SQL Settings definition.
        :paramtype sql: ~azure.mgmt.network.models.FirewallPolicySQL
        :keyword dns_settings: DNS Proxy Settings definition.
        :paramtype dns_settings: ~azure.mgmt.network.models.DnsSettings
        :keyword explicit_proxy: Explicit Proxy Settings definition.
        :paramtype explicit_proxy: ~azure.mgmt.network.models.ExplicitProxy
        :keyword intrusion_detection: The configuration for Intrusion detection.
        :paramtype intrusion_detection: ~azure.mgmt.network.models.FirewallPolicyIntrusionDetection
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.base_policy = base_policy
        self.threat_intel_mode = threat_intel_mode
        self.threat_intel_whitelist = threat_intel_whitelist
        self.insights = insights
        self.snat = snat
        self.sql = sql
        self.dns_settings = dns_settings
        self.explicit_proxy = explicit_proxy
        self.intrusion_detection = intrusion_detection


class FirewallPolicyRuleCollection(_serialization.Model):
    """Properties of the rule collection.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FirewallPolicyFilterRuleCollection, FirewallPolicyNatRuleCollection

    All required parameters must be populated in order to send to server.

    :ivar rule_collection_type: The type of the rule collection. Required. Known values are:
     "FirewallPolicyNatRuleCollection" and "FirewallPolicyFilterRuleCollection".
    :vartype rule_collection_type: str or
     ~azure.mgmt.network.models.FirewallPolicyRuleCollectionType
    :ivar name: The name of the rule collection.
    :vartype name: str
    :ivar priority: Priority of the Firewall Policy Rule Collection resource.
    :vartype priority: int
    """

    _validation = {
        "rule_collection_type": {"required": True},
        "priority": {"maximum": 65000, "minimum": 100},
    }

    _attribute_map = {
        "rule_collection_type": {"key": "ruleCollectionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
    }

    _subtype_map = {
        "rule_collection_type": {
            "FirewallPolicyFilterRuleCollection": "FirewallPolicyFilterRuleCollection",
            "FirewallPolicyNatRuleCollection": "FirewallPolicyNatRuleCollection",
        }
    }

    def __init__(self, *, name: Optional[str] = None, priority: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the rule collection.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule Collection resource.
        :paramtype priority: int
        """
        super().__init__(**kwargs)
        self.rule_collection_type: Optional[str] = None
        self.name = name
        self.priority = priority


class FirewallPolicyFilterRuleCollection(FirewallPolicyRuleCollection):
    """Firewall Policy Filter Rule Collection.

    All required parameters must be populated in order to send to server.

    :ivar rule_collection_type: The type of the rule collection. Required. Known values are:
     "FirewallPolicyNatRuleCollection" and "FirewallPolicyFilterRuleCollection".
    :vartype rule_collection_type: str or
     ~azure.mgmt.network.models.FirewallPolicyRuleCollectionType
    :ivar name: The name of the rule collection.
    :vartype name: str
    :ivar priority: Priority of the Firewall Policy Rule Collection resource.
    :vartype priority: int
    :ivar action: The action type of a Filter rule collection.
    :vartype action: ~azure.mgmt.network.models.FirewallPolicyFilterRuleCollectionAction
    :ivar rules: List of rules included in a rule collection.
    :vartype rules: list[~azure.mgmt.network.models.FirewallPolicyRule]
    """

    _validation = {
        "rule_collection_type": {"required": True},
        "priority": {"maximum": 65000, "minimum": 100},
    }

    _attribute_map = {
        "rule_collection_type": {"key": "ruleCollectionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "action": {"key": "action", "type": "FirewallPolicyFilterRuleCollectionAction"},
        "rules": {"key": "rules", "type": "[FirewallPolicyRule]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.FirewallPolicyFilterRuleCollectionAction"] = None,
        rules: Optional[list["_models.FirewallPolicyRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the rule collection.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule Collection resource.
        :paramtype priority: int
        :keyword action: The action type of a Filter rule collection.
        :paramtype action: ~azure.mgmt.network.models.FirewallPolicyFilterRuleCollectionAction
        :keyword rules: List of rules included in a rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.FirewallPolicyRule]
        """
        super().__init__(name=name, priority=priority, **kwargs)
        self.rule_collection_type: str = "FirewallPolicyFilterRuleCollection"
        self.action = action
        self.rules = rules


class FirewallPolicyFilterRuleCollectionAction(_serialization.Model):
    """Properties of the FirewallPolicyFilterRuleCollectionAction.

    :ivar type: The type of action. Known values are: "Allow" and "Deny".
    :vartype type: str or ~azure.mgmt.network.models.FirewallPolicyFilterRuleCollectionActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.FirewallPolicyFilterRuleCollectionActionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of action. Known values are: "Allow" and "Deny".
        :paramtype type: str or ~azure.mgmt.network.models.FirewallPolicyFilterRuleCollectionActionType
        """
        super().__init__(**kwargs)
        self.type = type


class FirewallPolicyHttpHeaderToInsert(_serialization.Model):
    """name and value of HTTP/S header to insert.

    :ivar header_name: Contains the name of the header.
    :vartype header_name: str
    :ivar header_value: Contains the value of the header.
    :vartype header_value: str
    """

    _attribute_map = {
        "header_name": {"key": "headerName", "type": "str"},
        "header_value": {"key": "headerValue", "type": "str"},
    }

    def __init__(self, *, header_name: Optional[str] = None, header_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword header_name: Contains the name of the header.
        :paramtype header_name: str
        :keyword header_value: Contains the value of the header.
        :paramtype header_value: str
        """
        super().__init__(**kwargs)
        self.header_name = header_name
        self.header_value = header_value


class FirewallPolicyInsights(_serialization.Model):
    """Firewall Policy Insights.

    :ivar is_enabled: A flag to indicate if the insights are enabled on the policy.
    :vartype is_enabled: bool
    :ivar retention_days: Number of days the insights should be enabled on the policy.
    :vartype retention_days: int
    :ivar log_analytics_resources: Workspaces needed to configure the Firewall Policy Insights.
    :vartype log_analytics_resources:
     ~azure.mgmt.network.models.FirewallPolicyLogAnalyticsResources
    """

    _attribute_map = {
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "retention_days": {"key": "retentionDays", "type": "int"},
        "log_analytics_resources": {"key": "logAnalyticsResources", "type": "FirewallPolicyLogAnalyticsResources"},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        retention_days: Optional[int] = None,
        log_analytics_resources: Optional["_models.FirewallPolicyLogAnalyticsResources"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: A flag to indicate if the insights are enabled on the policy.
        :paramtype is_enabled: bool
        :keyword retention_days: Number of days the insights should be enabled on the policy.
        :paramtype retention_days: int
        :keyword log_analytics_resources: Workspaces needed to configure the Firewall Policy Insights.
        :paramtype log_analytics_resources:
         ~azure.mgmt.network.models.FirewallPolicyLogAnalyticsResources
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled
        self.retention_days = retention_days
        self.log_analytics_resources = log_analytics_resources


class FirewallPolicyIntrusionDetection(_serialization.Model):
    """Configuration for intrusion detection mode and rules.

    :ivar mode: Intrusion detection general state. When attached to a parent policy, the firewall's
     effective IDPS mode is the stricter mode of the two. Known values are: "Off", "Alert", and
     "Deny".
    :vartype mode: str or ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionStateType
    :ivar profile: IDPS profile name. When attached to a parent policy, the firewall's effective
     profile is the profile name of the parent policy. Known values are: "Basic", "Standard",
     "Advanced", and "Extended".
    :vartype profile: str or ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionProfileType
    :ivar configuration: Intrusion detection configuration properties.
    :vartype configuration:
     ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionConfiguration
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "profile": {"key": "profile", "type": "str"},
        "configuration": {"key": "configuration", "type": "FirewallPolicyIntrusionDetectionConfiguration"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.FirewallPolicyIntrusionDetectionStateType"]] = None,
        profile: Optional[Union[str, "_models.FirewallPolicyIntrusionDetectionProfileType"]] = None,
        configuration: Optional["_models.FirewallPolicyIntrusionDetectionConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Intrusion detection general state. When attached to a parent policy, the
         firewall's effective IDPS mode is the stricter mode of the two. Known values are: "Off",
         "Alert", and "Deny".
        :paramtype mode: str or ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionStateType
        :keyword profile: IDPS profile name. When attached to a parent policy, the firewall's effective
         profile is the profile name of the parent policy. Known values are: "Basic", "Standard",
         "Advanced", and "Extended".
        :paramtype profile: str or
         ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionProfileType
        :keyword configuration: Intrusion detection configuration properties.
        :paramtype configuration:
         ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionConfiguration
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.profile = profile
        self.configuration = configuration


class FirewallPolicyIntrusionDetectionBypassTrafficSpecifications(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Intrusion detection bypass traffic specification.

    :ivar name: Name of the bypass traffic rule.
    :vartype name: str
    :ivar description: Description of the bypass traffic rule.
    :vartype description: str
    :ivar protocol: The rule bypass protocol. Known values are: "TCP", "UDP", "ICMP", and "ANY".
    :vartype protocol: str or ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionProtocol
    :ivar source_addresses: List of source IP addresses or ranges for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses or ranges for this rule.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports or ranges.
    :vartype destination_ports: list[str]
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    :ivar destination_ip_groups: List of destination IpGroups for this rule.
    :vartype destination_ip_groups: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
        "destination_ip_groups": {"key": "destinationIpGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.FirewallPolicyIntrusionDetectionProtocol"]] = None,
        source_addresses: Optional[list[str]] = None,
        destination_addresses: Optional[list[str]] = None,
        destination_ports: Optional[list[str]] = None,
        source_ip_groups: Optional[list[str]] = None,
        destination_ip_groups: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the bypass traffic rule.
        :paramtype name: str
        :keyword description: Description of the bypass traffic rule.
        :paramtype description: str
        :keyword protocol: The rule bypass protocol. Known values are: "TCP", "UDP", "ICMP", and "ANY".
        :paramtype protocol: str or ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionProtocol
        :keyword source_addresses: List of source IP addresses or ranges for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses or ranges for this rule.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports or ranges.
        :paramtype destination_ports: list[str]
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        :keyword destination_ip_groups: List of destination IpGroups for this rule.
        :paramtype destination_ip_groups: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.protocol = protocol
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.source_ip_groups = source_ip_groups
        self.destination_ip_groups = destination_ip_groups


class FirewallPolicyIntrusionDetectionConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """The operation for configuring intrusion detection.

    :ivar signature_overrides: List of specific signatures states.
    :vartype signature_overrides:
     list[~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionSignatureSpecification]
    :ivar bypass_traffic_settings: List of rules for traffic to bypass.
    :vartype bypass_traffic_settings:
     list[~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionBypassTrafficSpecifications]
    :ivar private_ranges: IDPS Private IP address ranges are used to identify traffic direction
     (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered
     private IP addresses. To modify default ranges, specify your Private IP address ranges with
     this property.
    :vartype private_ranges: list[str]
    """

    _attribute_map = {
        "signature_overrides": {
            "key": "signatureOverrides",
            "type": "[FirewallPolicyIntrusionDetectionSignatureSpecification]",
        },
        "bypass_traffic_settings": {
            "key": "bypassTrafficSettings",
            "type": "[FirewallPolicyIntrusionDetectionBypassTrafficSpecifications]",
        },
        "private_ranges": {"key": "privateRanges", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        signature_overrides: Optional[list["_models.FirewallPolicyIntrusionDetectionSignatureSpecification"]] = None,
        bypass_traffic_settings: Optional[
            list["_models.FirewallPolicyIntrusionDetectionBypassTrafficSpecifications"]
        ] = None,
        private_ranges: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword signature_overrides: List of specific signatures states.
        :paramtype signature_overrides:
         list[~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionSignatureSpecification]
        :keyword bypass_traffic_settings: List of rules for traffic to bypass.
        :paramtype bypass_traffic_settings:
         list[~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionBypassTrafficSpecifications]
        :keyword private_ranges: IDPS Private IP address ranges are used to identify traffic direction
         (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered
         private IP addresses. To modify default ranges, specify your Private IP address ranges with
         this property.
        :paramtype private_ranges: list[str]
        """
        super().__init__(**kwargs)
        self.signature_overrides = signature_overrides
        self.bypass_traffic_settings = bypass_traffic_settings
        self.private_ranges = private_ranges


class FirewallPolicyIntrusionDetectionSignatureSpecification(_serialization.Model):  # pylint: disable=name-too-long
    """Intrusion detection signatures specification states.

    :ivar id: Signature id.
    :vartype id: str
    :ivar mode: The signature state. Known values are: "Off", "Alert", and "Deny".
    :vartype mode: str or ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionStateType
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        mode: Optional[Union[str, "_models.FirewallPolicyIntrusionDetectionStateType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Signature id.
        :paramtype id: str
        :keyword mode: The signature state. Known values are: "Off", "Alert", and "Deny".
        :paramtype mode: str or ~azure.mgmt.network.models.FirewallPolicyIntrusionDetectionStateType
        """
        super().__init__(**kwargs)
        self.id = id
        self.mode = mode


class FirewallPolicyListResult(_serialization.Model):
    """Response for ListFirewallPolicies API service call.

    :ivar value: List of Firewall Policies in a resource group.
    :vartype value: list[~azure.mgmt.network.models.FirewallPolicy]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.FirewallPolicy"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Firewall Policies in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.FirewallPolicy]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FirewallPolicyLogAnalyticsResources(_serialization.Model):
    """Log Analytics Resources for Firewall Policy Insights.

    :ivar workspaces: List of workspaces for Firewall Policy Insights.
    :vartype workspaces: list[~azure.mgmt.network.models.FirewallPolicyLogAnalyticsWorkspace]
    :ivar default_workspace_id: The default workspace Id for Firewall Policy Insights.
    :vartype default_workspace_id: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "workspaces": {"key": "workspaces", "type": "[FirewallPolicyLogAnalyticsWorkspace]"},
        "default_workspace_id": {"key": "defaultWorkspaceId", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        workspaces: Optional[list["_models.FirewallPolicyLogAnalyticsWorkspace"]] = None,
        default_workspace_id: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workspaces: List of workspaces for Firewall Policy Insights.
        :paramtype workspaces: list[~azure.mgmt.network.models.FirewallPolicyLogAnalyticsWorkspace]
        :keyword default_workspace_id: The default workspace Id for Firewall Policy Insights.
        :paramtype default_workspace_id: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.workspaces = workspaces
        self.default_workspace_id = default_workspace_id


class FirewallPolicyLogAnalyticsWorkspace(_serialization.Model):
    """Log Analytics Workspace for Firewall Policy Insights.

    :ivar region: Region to configure the Workspace.
    :vartype region: str
    :ivar workspace_id: The workspace Id for Firewall Policy Insights.
    :vartype workspace_id: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "SubResource"},
    }

    def __init__(
        self, *, region: Optional[str] = None, workspace_id: Optional["_models.SubResource"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword region: Region to configure the Workspace.
        :paramtype region: str
        :keyword workspace_id: The workspace Id for Firewall Policy Insights.
        :paramtype workspace_id: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.region = region
        self.workspace_id = workspace_id


class FirewallPolicyNatRuleCollection(FirewallPolicyRuleCollection):
    """Firewall Policy NAT Rule Collection.

    All required parameters must be populated in order to send to server.

    :ivar rule_collection_type: The type of the rule collection. Required. Known values are:
     "FirewallPolicyNatRuleCollection" and "FirewallPolicyFilterRuleCollection".
    :vartype rule_collection_type: str or
     ~azure.mgmt.network.models.FirewallPolicyRuleCollectionType
    :ivar name: The name of the rule collection.
    :vartype name: str
    :ivar priority: Priority of the Firewall Policy Rule Collection resource.
    :vartype priority: int
    :ivar action: The action type of a Nat rule collection.
    :vartype action: ~azure.mgmt.network.models.FirewallPolicyNatRuleCollectionAction
    :ivar rules: List of rules included in a rule collection.
    :vartype rules: list[~azure.mgmt.network.models.FirewallPolicyRule]
    """

    _validation = {
        "rule_collection_type": {"required": True},
        "priority": {"maximum": 65000, "minimum": 100},
    }

    _attribute_map = {
        "rule_collection_type": {"key": "ruleCollectionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "action": {"key": "action", "type": "FirewallPolicyNatRuleCollectionAction"},
        "rules": {"key": "rules", "type": "[FirewallPolicyRule]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.FirewallPolicyNatRuleCollectionAction"] = None,
        rules: Optional[list["_models.FirewallPolicyRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the rule collection.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule Collection resource.
        :paramtype priority: int
        :keyword action: The action type of a Nat rule collection.
        :paramtype action: ~azure.mgmt.network.models.FirewallPolicyNatRuleCollectionAction
        :keyword rules: List of rules included in a rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.FirewallPolicyRule]
        """
        super().__init__(name=name, priority=priority, **kwargs)
        self.rule_collection_type: str = "FirewallPolicyNatRuleCollection"
        self.action = action
        self.rules = rules


class FirewallPolicyNatRuleCollectionAction(_serialization.Model):
    """Properties of the FirewallPolicyNatRuleCollectionAction.

    :ivar type: The type of action. "DNAT"
    :vartype type: str or ~azure.mgmt.network.models.FirewallPolicyNatRuleCollectionActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.FirewallPolicyNatRuleCollectionActionType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of action. "DNAT"
        :paramtype type: str or ~azure.mgmt.network.models.FirewallPolicyNatRuleCollectionActionType
        """
        super().__init__(**kwargs)
        self.type = type


class FirewallPolicyRuleApplicationProtocol(_serialization.Model):
    """Properties of the application rule protocol.

    :ivar protocol_type: Protocol type. Known values are: "Http" and "Https".
    :vartype protocol_type: str or
     ~azure.mgmt.network.models.FirewallPolicyRuleApplicationProtocolType
    :ivar port: Port number for the protocol, cannot be greater than 64000.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 64000, "minimum": 0},
    }

    _attribute_map = {
        "protocol_type": {"key": "protocolType", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.FirewallPolicyRuleApplicationProtocolType"]] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_type: Protocol type. Known values are: "Http" and "Https".
        :paramtype protocol_type: str or
         ~azure.mgmt.network.models.FirewallPolicyRuleApplicationProtocolType
        :keyword port: Port number for the protocol, cannot be greater than 64000.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.protocol_type = protocol_type
        self.port = port


class FirewallPolicyRuleCollectionGroup(SubResource):
    """Rule Collection Group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Rule Group type.
    :vartype type: str
    :ivar size: A read-only string that represents the size of the
     FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB).
    :vartype size: str
    :ivar priority: Priority of the Firewall Policy Rule Collection Group resource.
    :vartype priority: int
    :ivar rule_collections: Group of Firewall Policy rule collections.
    :vartype rule_collections: list[~azure.mgmt.network.models.FirewallPolicyRuleCollection]
    :ivar provisioning_state: The provisioning state of the firewall policy rule collection group
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "size": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "size": {"key": "properties.size", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "rule_collections": {"key": "properties.ruleCollections", "type": "[FirewallPolicyRuleCollection]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        rule_collections: Optional[list["_models.FirewallPolicyRuleCollection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule Collection Group resource.
        :paramtype priority: int
        :keyword rule_collections: Group of Firewall Policy rule collections.
        :paramtype rule_collections: list[~azure.mgmt.network.models.FirewallPolicyRuleCollection]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.size: Optional[str] = None
        self.priority = priority
        self.rule_collections = rule_collections
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class FirewallPolicyRuleCollectionGroupDraft(SubResource):
    """Rule Collection Group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Rule Group type.
    :vartype type: str
    :ivar size: A read-only string that represents the size of the
     FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB).
    :vartype size: str
    :ivar priority: Priority of the Firewall Policy Rule Collection Group resource.
    :vartype priority: int
    :ivar rule_collections: Group of Firewall Policy rule collections.
    :vartype rule_collections: list[~azure.mgmt.network.models.FirewallPolicyRuleCollection]
    """

    _validation = {
        "type": {"readonly": True},
        "size": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "size": {"key": "properties.size", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "rule_collections": {"key": "properties.ruleCollections", "type": "[FirewallPolicyRuleCollection]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        rule_collections: Optional[list["_models.FirewallPolicyRuleCollection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the Firewall Policy Rule Collection Group resource.
        :paramtype priority: int
        :keyword rule_collections: Group of Firewall Policy rule collections.
        :paramtype rule_collections: list[~azure.mgmt.network.models.FirewallPolicyRuleCollection]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type: Optional[str] = None
        self.size: Optional[str] = None
        self.priority = priority
        self.rule_collections = rule_collections


class FirewallPolicyRuleCollectionGroupListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListFirewallPolicyRuleCollectionGroups API service call.

    :ivar value: List of FirewallPolicyRuleCollectionGroups in a FirewallPolicy.
    :vartype value: list[~azure.mgmt.network.models.FirewallPolicyRuleCollectionGroup]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallPolicyRuleCollectionGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.FirewallPolicyRuleCollectionGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of FirewallPolicyRuleCollectionGroups in a FirewallPolicy.
        :paramtype value: list[~azure.mgmt.network.models.FirewallPolicyRuleCollectionGroup]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FirewallPolicySku(_serialization.Model):
    """SKU of Firewall policy.

    :ivar tier: Tier of Firewall Policy. Known values are: "Standard", "Premium", and "Basic".
    :vartype tier: str or ~azure.mgmt.network.models.FirewallPolicySkuTier
    """

    _attribute_map = {
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, tier: Optional[Union[str, "_models.FirewallPolicySkuTier"]] = None, **kwargs: Any) -> None:
        """
        :keyword tier: Tier of Firewall Policy. Known values are: "Standard", "Premium", and "Basic".
        :paramtype tier: str or ~azure.mgmt.network.models.FirewallPolicySkuTier
        """
        super().__init__(**kwargs)
        self.tier = tier


class FirewallPolicySNAT(_serialization.Model):
    """The private IP addresses/IP ranges to which traffic will not be SNAT.

    :ivar private_ranges: List of private IP addresses/IP address ranges to not be SNAT.
    :vartype private_ranges: list[str]
    :ivar auto_learn_private_ranges: The operation mode for automatically learning private ranges
     to not be SNAT. Known values are: "Enabled" and "Disabled".
    :vartype auto_learn_private_ranges: str or
     ~azure.mgmt.network.models.AutoLearnPrivateRangesMode
    """

    _attribute_map = {
        "private_ranges": {"key": "privateRanges", "type": "[str]"},
        "auto_learn_private_ranges": {"key": "autoLearnPrivateRanges", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_ranges: Optional[list[str]] = None,
        auto_learn_private_ranges: Optional[Union[str, "_models.AutoLearnPrivateRangesMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_ranges: List of private IP addresses/IP address ranges to not be SNAT.
        :paramtype private_ranges: list[str]
        :keyword auto_learn_private_ranges: The operation mode for automatically learning private
         ranges to not be SNAT. Known values are: "Enabled" and "Disabled".
        :paramtype auto_learn_private_ranges: str or
         ~azure.mgmt.network.models.AutoLearnPrivateRangesMode
        """
        super().__init__(**kwargs)
        self.private_ranges = private_ranges
        self.auto_learn_private_ranges = auto_learn_private_ranges


class FirewallPolicySQL(_serialization.Model):
    """SQL Settings in Firewall Policy.

    :ivar allow_sql_redirect: A flag to indicate if SQL Redirect traffic filtering is enabled.
     Turning on the flag requires no rule using port 11000-11999.
    :vartype allow_sql_redirect: bool
    """

    _attribute_map = {
        "allow_sql_redirect": {"key": "allowSqlRedirect", "type": "bool"},
    }

    def __init__(self, *, allow_sql_redirect: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword allow_sql_redirect: A flag to indicate if SQL Redirect traffic filtering is enabled.
         Turning on the flag requires no rule using port 11000-11999.
        :paramtype allow_sql_redirect: bool
        """
        super().__init__(**kwargs)
        self.allow_sql_redirect = allow_sql_redirect


class FirewallPolicyThreatIntelWhitelist(_serialization.Model):
    """ThreatIntel Whitelist for Firewall Policy.

    :ivar ip_addresses: List of IP addresses for the ThreatIntel Whitelist.
    :vartype ip_addresses: list[str]
    :ivar fqdns: List of FQDNs for the ThreatIntel Whitelist.
    :vartype fqdns: list[str]
    """

    _attribute_map = {
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "fqdns": {"key": "fqdns", "type": "[str]"},
    }

    def __init__(
        self, *, ip_addresses: Optional[list[str]] = None, fqdns: Optional[list[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ip_addresses: List of IP addresses for the ThreatIntel Whitelist.
        :paramtype ip_addresses: list[str]
        :keyword fqdns: List of FQDNs for the ThreatIntel Whitelist.
        :paramtype fqdns: list[str]
        """
        super().__init__(**kwargs)
        self.ip_addresses = ip_addresses
        self.fqdns = fqdns


class FirewallPolicyTransportSecurity(_serialization.Model):
    """Configuration needed to perform TLS termination & initiation.

    :ivar certificate_authority: The CA used for intermediate CA generation.
    :vartype certificate_authority: ~azure.mgmt.network.models.FirewallPolicyCertificateAuthority
    """

    _attribute_map = {
        "certificate_authority": {"key": "certificateAuthority", "type": "FirewallPolicyCertificateAuthority"},
    }

    def __init__(
        self, *, certificate_authority: Optional["_models.FirewallPolicyCertificateAuthority"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword certificate_authority: The CA used for intermediate CA generation.
        :paramtype certificate_authority: ~azure.mgmt.network.models.FirewallPolicyCertificateAuthority
        """
        super().__init__(**kwargs)
        self.certificate_authority = certificate_authority


class FlowLog(Resource):
    """A flow log resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar identity: FlowLog resource Managed Identity.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar target_resource_id: ID of network security group to which flow log will be applied.
    :vartype target_resource_id: str
    :ivar target_resource_guid: Guid of network security group to which flow log will be applied.
    :vartype target_resource_guid: str
    :ivar storage_id: ID of the storage account which is used to store the flow log.
    :vartype storage_id: str
    :ivar enabled_filtering_criteria: Optional field to filter network traffic logs based on SrcIP,
     SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all
     network traffic will be logged.
    :vartype enabled_filtering_criteria: str
    :ivar enabled: Flag to enable/disable flow logging.
    :vartype enabled: bool
    :ivar retention_policy: Parameters that define the retention policy for flow log.
    :vartype retention_policy: ~azure.mgmt.network.models.RetentionPolicyParameters
    :ivar format: Parameters that define the flow log format.
    :vartype format: ~azure.mgmt.network.models.FlowLogFormatParameters
    :ivar flow_analytics_configuration: Parameters that define the configuration of traffic
     analytics.
    :vartype flow_analytics_configuration: ~azure.mgmt.network.models.TrafficAnalyticsProperties
    :ivar provisioning_state: The provisioning state of the flow log. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "target_resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "target_resource_id": {"key": "properties.targetResourceId", "type": "str"},
        "target_resource_guid": {"key": "properties.targetResourceGuid", "type": "str"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "enabled_filtering_criteria": {"key": "properties.enabledFilteringCriteria", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "retention_policy": {"key": "properties.retentionPolicy", "type": "RetentionPolicyParameters"},
        "format": {"key": "properties.format", "type": "FlowLogFormatParameters"},
        "flow_analytics_configuration": {
            "key": "properties.flowAnalyticsConfiguration",
            "type": "TrafficAnalyticsProperties",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        target_resource_id: Optional[str] = None,
        storage_id: Optional[str] = None,
        enabled_filtering_criteria: Optional[str] = None,
        enabled: Optional[bool] = None,
        retention_policy: Optional["_models.RetentionPolicyParameters"] = None,
        format: Optional["_models.FlowLogFormatParameters"] = None,
        flow_analytics_configuration: Optional["_models.TrafficAnalyticsProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: FlowLog resource Managed Identity.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword target_resource_id: ID of network security group to which flow log will be applied.
        :paramtype target_resource_id: str
        :keyword storage_id: ID of the storage account which is used to store the flow log.
        :paramtype storage_id: str
        :keyword enabled_filtering_criteria: Optional field to filter network traffic logs based on
         SrcIP, SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified,
         all network traffic will be logged.
        :paramtype enabled_filtering_criteria: str
        :keyword enabled: Flag to enable/disable flow logging.
        :paramtype enabled: bool
        :keyword retention_policy: Parameters that define the retention policy for flow log.
        :paramtype retention_policy: ~azure.mgmt.network.models.RetentionPolicyParameters
        :keyword format: Parameters that define the flow log format.
        :paramtype format: ~azure.mgmt.network.models.FlowLogFormatParameters
        :keyword flow_analytics_configuration: Parameters that define the configuration of traffic
         analytics.
        :paramtype flow_analytics_configuration: ~azure.mgmt.network.models.TrafficAnalyticsProperties
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.identity = identity
        self.target_resource_id = target_resource_id
        self.target_resource_guid: Optional[str] = None
        self.storage_id = storage_id
        self.enabled_filtering_criteria = enabled_filtering_criteria
        self.enabled = enabled
        self.retention_policy = retention_policy
        self.format = format
        self.flow_analytics_configuration = flow_analytics_configuration
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class FlowLogFormatParameters(_serialization.Model):
    """Parameters that define the flow log format.

    :ivar type: The file type of flow log. "JSON"
    :vartype type: str or ~azure.mgmt.network.models.FlowLogFormatType
    :ivar version: The version (revision) of the flow log.
    :vartype version: int
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "int"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.FlowLogFormatType"]] = None, version: int = 0, **kwargs: Any
    ) -> None:
        """
        :keyword type: The file type of flow log. "JSON"
        :paramtype type: str or ~azure.mgmt.network.models.FlowLogFormatType
        :keyword version: The version (revision) of the flow log.
        :paramtype version: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.version = version


class FlowLogInformation(_serialization.Model):
    """Information on the configuration of flow log and traffic analytics (optional) .

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The ID of the resource to configure for flow log and traffic
     analytics (optional) . Required.
    :vartype target_resource_id: str
    :ivar flow_analytics_configuration: Parameters that define the configuration of traffic
     analytics.
    :vartype flow_analytics_configuration: ~azure.mgmt.network.models.TrafficAnalyticsProperties
    :ivar identity: FlowLog resource Managed Identity.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar storage_id: ID of the storage account which is used to store the flow log. Required.
    :vartype storage_id: str
    :ivar enabled_filtering_criteria: Optional field to filter network traffic logs based on SrcIP,
     SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all
     network traffic will be logged.
    :vartype enabled_filtering_criteria: str
    :ivar enabled: Flag to enable/disable flow logging. Required.
    :vartype enabled: bool
    :ivar retention_policy: Parameters that define the retention policy for flow log.
    :vartype retention_policy: ~azure.mgmt.network.models.RetentionPolicyParameters
    :ivar format: Parameters that define the flow log format.
    :vartype format: ~azure.mgmt.network.models.FlowLogFormatParameters
    """

    _validation = {
        "target_resource_id": {"required": True},
        "storage_id": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "flow_analytics_configuration": {"key": "flowAnalyticsConfiguration", "type": "TrafficAnalyticsProperties"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "enabled_filtering_criteria": {"key": "properties.enabledFilteringCriteria", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "retention_policy": {"key": "properties.retentionPolicy", "type": "RetentionPolicyParameters"},
        "format": {"key": "properties.format", "type": "FlowLogFormatParameters"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        storage_id: str,
        enabled: bool,
        flow_analytics_configuration: Optional["_models.TrafficAnalyticsProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled_filtering_criteria: Optional[str] = None,
        retention_policy: Optional["_models.RetentionPolicyParameters"] = None,
        format: Optional["_models.FlowLogFormatParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_id: The ID of the resource to configure for flow log and traffic
         analytics (optional) . Required.
        :paramtype target_resource_id: str
        :keyword flow_analytics_configuration: Parameters that define the configuration of traffic
         analytics.
        :paramtype flow_analytics_configuration: ~azure.mgmt.network.models.TrafficAnalyticsProperties
        :keyword identity: FlowLog resource Managed Identity.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword storage_id: ID of the storage account which is used to store the flow log. Required.
        :paramtype storage_id: str
        :keyword enabled_filtering_criteria: Optional field to filter network traffic logs based on
         SrcIP, SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified,
         all network traffic will be logged.
        :paramtype enabled_filtering_criteria: str
        :keyword enabled: Flag to enable/disable flow logging. Required.
        :paramtype enabled: bool
        :keyword retention_policy: Parameters that define the retention policy for flow log.
        :paramtype retention_policy: ~azure.mgmt.network.models.RetentionPolicyParameters
        :keyword format: Parameters that define the flow log format.
        :paramtype format: ~azure.mgmt.network.models.FlowLogFormatParameters
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.flow_analytics_configuration = flow_analytics_configuration
        self.identity = identity
        self.storage_id = storage_id
        self.enabled_filtering_criteria = enabled_filtering_criteria
        self.enabled = enabled
        self.retention_policy = retention_policy
        self.format = format


class FlowLogListResult(_serialization.Model):
    """List of flow logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Information about flow log resource.
    :vartype value: list[~azure.mgmt.network.models.FlowLog]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FlowLog]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.FlowLog"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Information about flow log resource.
        :paramtype value: list[~azure.mgmt.network.models.FlowLog]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class FlowLogStatusParameters(_serialization.Model):
    """Parameters that define a resource to query flow log and traffic analytics (optional) status.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The target resource where getting the flow log and traffic analytics
     (optional) status. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs: Any) -> None:
        """
        :keyword target_resource_id: The target resource where getting the flow log and traffic
         analytics (optional) status. Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id


class FrontendIPConfiguration(SubResource):
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of frontend IP
     configurations used by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar inbound_nat_rules: An array of references to inbound rules that use this frontend IP.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar inbound_nat_pools: An array of references to inbound pools that use this frontend IP.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.models.SubResource]
    :ivar outbound_rules: An array of references to outbound rules that use this frontend IP.
    :vartype outbound_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     frontend IP.
    :vartype load_balancing_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The Private IP allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
    :ivar private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6. Default
     is taken as IPv4. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
    :ivar subnet: The reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar public_ip_address: The reference to the Public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar public_ip_prefix: The reference to the Public IP Prefix resource.
    :vartype public_ip_prefix: ~azure.mgmt.network.models.SubResource
    :ivar gateway_load_balancer: The reference to gateway load balancer frontend IP.
    :vartype gateway_load_balancer: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "inbound_nat_rules": {"readonly": True},
        "inbound_nat_pools": {"readonly": True},
        "outbound_rules": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[SubResource]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[SubResource]"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[SubResource]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "gateway_load_balancer": {"key": "properties.gatewayLoadBalancer", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        zones: Optional[list[str]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        gateway_load_balancer: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of frontend IP
         configurations used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The Private IP allocation method. Known values are:
         "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
        :keyword private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6.
         Default is taken as IPv4. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
        :keyword subnet: The reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        :keyword public_ip_address: The reference to the Public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        :keyword public_ip_prefix: The reference to the Public IP Prefix resource.
        :paramtype public_ip_prefix: ~azure.mgmt.network.models.SubResource
        :keyword gateway_load_balancer: The reference to gateway load balancer frontend IP.
        :paramtype gateway_load_balancer: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.zones = zones
        self.inbound_nat_rules: Optional[list["_models.SubResource"]] = None
        self.inbound_nat_pools: Optional[list["_models.SubResource"]] = None
        self.outbound_rules: Optional[list["_models.SubResource"]] = None
        self.load_balancing_rules: Optional[list["_models.SubResource"]] = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.public_ip_prefix = public_ip_prefix
        self.gateway_load_balancer = gateway_load_balancer
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class GatewayCustomBgpIpAddressIpConfiguration(_serialization.Model):
    """GatewayCustomBgpIpAddressIpConfiguration for a virtual network gateway connection.

    All required parameters must be populated in order to send to server.

    :ivar ip_configuration_id: The IpconfigurationId of ipconfiguration which belongs to gateway.
     Required.
    :vartype ip_configuration_id: str
    :ivar custom_bgp_ip_address: The custom BgpPeeringAddress which belongs to IpconfigurationId.
     Required.
    :vartype custom_bgp_ip_address: str
    """

    _validation = {
        "ip_configuration_id": {"required": True},
        "custom_bgp_ip_address": {"required": True},
    }

    _attribute_map = {
        "ip_configuration_id": {"key": "ipConfigurationId", "type": "str"},
        "custom_bgp_ip_address": {"key": "customBgpIpAddress", "type": "str"},
    }

    def __init__(self, *, ip_configuration_id: str, custom_bgp_ip_address: str, **kwargs: Any) -> None:
        """
        :keyword ip_configuration_id: The IpconfigurationId of ipconfiguration which belongs to
         gateway. Required.
        :paramtype ip_configuration_id: str
        :keyword custom_bgp_ip_address: The custom BgpPeeringAddress which belongs to
         IpconfigurationId. Required.
        :paramtype custom_bgp_ip_address: str
        """
        super().__init__(**kwargs)
        self.ip_configuration_id = ip_configuration_id
        self.custom_bgp_ip_address = custom_bgp_ip_address


class GatewayLoadBalancerTunnelInterface(_serialization.Model):
    """Gateway load balancer tunnel interface of a load balancer backend address pool.

    :ivar port: Port of gateway load balancer tunnel interface.
    :vartype port: int
    :ivar identifier: Identifier of gateway load balancer tunnel interface.
    :vartype identifier: int
    :ivar protocol: Protocol of gateway load balancer tunnel interface. Known values are: "None",
     "Native", and "VXLAN".
    :vartype protocol: str or ~azure.mgmt.network.models.GatewayLoadBalancerTunnelProtocol
    :ivar type: Traffic type of gateway load balancer tunnel interface. Known values are: "None",
     "Internal", and "External".
    :vartype type: str or ~azure.mgmt.network.models.GatewayLoadBalancerTunnelInterfaceType
    """

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
        "identifier": {"key": "identifier", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        port: Optional[int] = None,
        identifier: Optional[int] = None,
        protocol: Optional[Union[str, "_models.GatewayLoadBalancerTunnelProtocol"]] = None,
        type: Optional[Union[str, "_models.GatewayLoadBalancerTunnelInterfaceType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword port: Port of gateway load balancer tunnel interface.
        :paramtype port: int
        :keyword identifier: Identifier of gateway load balancer tunnel interface.
        :paramtype identifier: int
        :keyword protocol: Protocol of gateway load balancer tunnel interface. Known values are:
         "None", "Native", and "VXLAN".
        :paramtype protocol: str or ~azure.mgmt.network.models.GatewayLoadBalancerTunnelProtocol
        :keyword type: Traffic type of gateway load balancer tunnel interface. Known values are:
         "None", "Internal", and "External".
        :paramtype type: str or ~azure.mgmt.network.models.GatewayLoadBalancerTunnelInterfaceType
        """
        super().__init__(**kwargs)
        self.port = port
        self.identifier = identifier
        self.protocol = protocol
        self.type = type


class GatewayResiliencyInformation(_serialization.Model):
    """Gateway Resiliency Information.

    :ivar overall_score: Current Resiliency Score for the gateway.
    :vartype overall_score: str
    :ivar score_change: Update in the Resiliency Score for the gateway from the last computed
     score.
    :vartype score_change: str
    :ivar min_score_from_recommendations: Minimum increase expected in the score if the at least
     one of the recommendations is applied for the gateway.
    :vartype min_score_from_recommendations: str
    :ivar max_score_from_recommendations: Maximum increase expected in the score if all of the
     recommendations are applied for the gateway.
    :vartype max_score_from_recommendations: str
    :ivar last_computed_time: Timestamp denoting the last time when the resiliency score was
     computed for the gateway.
    :vartype last_computed_time: ~datetime.datetime
    :ivar next_eligible_compute_time: Timestamp denoting the next eligible time to re-compute the
     resiliency score for the gateway.
    :vartype next_eligible_compute_time: ~datetime.datetime
    :ivar components: List of Resiliency based Recommendation Components for the gateway.
    :vartype components: list[~azure.mgmt.network.models.ResiliencyRecommendationComponents]
    """

    _attribute_map = {
        "overall_score": {"key": "overallScore", "type": "str"},
        "score_change": {"key": "scoreChange", "type": "str"},
        "min_score_from_recommendations": {"key": "minScoreFromRecommendations", "type": "str"},
        "max_score_from_recommendations": {"key": "maxScoreFromRecommendations", "type": "str"},
        "last_computed_time": {"key": "lastComputedTime", "type": "iso-8601"},
        "next_eligible_compute_time": {"key": "nextEligibleComputeTime", "type": "iso-8601"},
        "components": {"key": "components", "type": "[ResiliencyRecommendationComponents]"},
    }

    def __init__(
        self,
        *,
        overall_score: Optional[str] = None,
        score_change: Optional[str] = None,
        min_score_from_recommendations: Optional[str] = None,
        max_score_from_recommendations: Optional[str] = None,
        last_computed_time: Optional[datetime.datetime] = None,
        next_eligible_compute_time: Optional[datetime.datetime] = None,
        components: Optional[list["_models.ResiliencyRecommendationComponents"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword overall_score: Current Resiliency Score for the gateway.
        :paramtype overall_score: str
        :keyword score_change: Update in the Resiliency Score for the gateway from the last computed
         score.
        :paramtype score_change: str
        :keyword min_score_from_recommendations: Minimum increase expected in the score if the at least
         one of the recommendations is applied for the gateway.
        :paramtype min_score_from_recommendations: str
        :keyword max_score_from_recommendations: Maximum increase expected in the score if all of the
         recommendations are applied for the gateway.
        :paramtype max_score_from_recommendations: str
        :keyword last_computed_time: Timestamp denoting the last time when the resiliency score was
         computed for the gateway.
        :paramtype last_computed_time: ~datetime.datetime
        :keyword next_eligible_compute_time: Timestamp denoting the next eligible time to re-compute
         the resiliency score for the gateway.
        :paramtype next_eligible_compute_time: ~datetime.datetime
        :keyword components: List of Resiliency based Recommendation Components for the gateway.
        :paramtype components: list[~azure.mgmt.network.models.ResiliencyRecommendationComponents]
        """
        super().__init__(**kwargs)
        self.overall_score = overall_score
        self.score_change = score_change
        self.min_score_from_recommendations = min_score_from_recommendations
        self.max_score_from_recommendations = max_score_from_recommendations
        self.last_computed_time = last_computed_time
        self.next_eligible_compute_time = next_eligible_compute_time
        self.components = components


class GatewayResiliencyRecommendation(_serialization.Model):
    """Resiliency Recommendation details.

    :ivar recommendation_title: Recommendation Title.
    :vartype recommendation_title: str
    :ivar recommendation_id: Recommendation Id.
    :vartype recommendation_id: str
    :ivar severity: Impact associated with the recommendation.
    :vartype severity: str
    :ivar recommendation_text: Recommendation details.
    :vartype recommendation_text: str
    :ivar call_to_action_text: Acton items to apply the recommendation.
    :vartype call_to_action_text: str
    :ivar call_to_action_link: Link to the public documentation for the associated recommendation.
    :vartype call_to_action_link: str
    """

    _attribute_map = {
        "recommendation_title": {"key": "recommendationTitle", "type": "str"},
        "recommendation_id": {"key": "recommendationId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "recommendation_text": {"key": "recommendationText", "type": "str"},
        "call_to_action_text": {"key": "callToActionText", "type": "str"},
        "call_to_action_link": {"key": "callToActionLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        recommendation_title: Optional[str] = None,
        recommendation_id: Optional[str] = None,
        severity: Optional[str] = None,
        recommendation_text: Optional[str] = None,
        call_to_action_text: Optional[str] = None,
        call_to_action_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recommendation_title: Recommendation Title.
        :paramtype recommendation_title: str
        :keyword recommendation_id: Recommendation Id.
        :paramtype recommendation_id: str
        :keyword severity: Impact associated with the recommendation.
        :paramtype severity: str
        :keyword recommendation_text: Recommendation details.
        :paramtype recommendation_text: str
        :keyword call_to_action_text: Acton items to apply the recommendation.
        :paramtype call_to_action_text: str
        :keyword call_to_action_link: Link to the public documentation for the associated
         recommendation.
        :paramtype call_to_action_link: str
        """
        super().__init__(**kwargs)
        self.recommendation_title = recommendation_title
        self.recommendation_id = recommendation_id
        self.severity = severity
        self.recommendation_text = recommendation_text
        self.call_to_action_text = call_to_action_text
        self.call_to_action_link = call_to_action_link


class GatewayRoute(_serialization.Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The gateway's local address.
    :vartype local_address: str
    :ivar network: The route's network prefix.
    :vartype network: str
    :ivar next_hop: The route's next hop.
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from.
    :vartype source_peer: str
    :ivar origin: The source this route was learned from.
    :vartype origin: str
    :ivar as_path: The route's AS path sequence.
    :vartype as_path: str
    :ivar weight: The route's weight.
    :vartype weight: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "network": {"readonly": True},
        "next_hop": {"readonly": True},
        "source_peer": {"readonly": True},
        "origin": {"readonly": True},
        "as_path": {"readonly": True},
        "weight": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "source_peer": {"key": "sourcePeer", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "as_path": {"key": "asPath", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.local_address: Optional[str] = None
        self.network: Optional[str] = None
        self.next_hop: Optional[str] = None
        self.source_peer: Optional[str] = None
        self.origin: Optional[str] = None
        self.as_path: Optional[str] = None
        self.weight: Optional[int] = None


class GatewayRouteListResult(_serialization.Model):
    """List of virtual network gateway routes.

    :ivar value: List of gateway routes.
    :vartype value: list[~azure.mgmt.network.models.GatewayRoute]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GatewayRoute]"},
    }

    def __init__(self, *, value: Optional[list["_models.GatewayRoute"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of gateway routes.
        :paramtype value: list[~azure.mgmt.network.models.GatewayRoute]
        """
        super().__init__(**kwargs)
        self.value = value


class GatewayRouteSet(_serialization.Model):
    """GatewayRouteSet.

    :ivar name: Route Set name.
    :vartype name: str
    :ivar locations: List of different locations from where the routes are learned.
    :vartype locations: list[str]
    :ivar details: List of different Route Sources.
    :vartype details: dict[str, list[~azure.mgmt.network.models.RouteSourceDetails]]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "details": {"key": "details", "type": "{[RouteSourceDetails]}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        locations: Optional[list[str]] = None,
        details: Optional[dict[str, list["_models.RouteSourceDetails"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Route Set name.
        :paramtype name: str
        :keyword locations: List of different locations from where the routes are learned.
        :paramtype locations: list[str]
        :keyword details: List of different Route Sources.
        :paramtype details: dict[str, list[~azure.mgmt.network.models.RouteSourceDetails]]
        """
        super().__init__(**kwargs)
        self.name = name
        self.locations = locations
        self.details = details


class GatewayRouteSetsInformation(_serialization.Model):
    """Gateway Route Sets Information.

    :ivar last_computed_time: Timestamp denoting the last time when the route sets were computed
     for the gateway.
    :vartype last_computed_time: ~datetime.datetime
    :ivar next_eligible_compute_time: Timestamp denoting the next eligible time to re-compute the
     route sets for the gateway.
    :vartype next_eligible_compute_time: ~datetime.datetime
    :ivar route_set_version: Version for the route set.
    :vartype route_set_version: str
    :ivar route_sets: List of Gateway Route Sets.
    :vartype route_sets: list[~azure.mgmt.network.models.GatewayRouteSet]
    :ivar circuits_metadata_map: Dictionary containing map of the circuit id and circuit details.
    :vartype circuits_metadata_map: dict[str, ~azure.mgmt.network.models.CircuitMetadataMap]
    """

    _attribute_map = {
        "last_computed_time": {"key": "lastComputedTime", "type": "iso-8601"},
        "next_eligible_compute_time": {"key": "nextEligibleComputeTime", "type": "iso-8601"},
        "route_set_version": {"key": "routeSetVersion", "type": "str"},
        "route_sets": {"key": "routeSets", "type": "[GatewayRouteSet]"},
        "circuits_metadata_map": {"key": "circuitsMetadataMap", "type": "{CircuitMetadataMap}"},
    }

    def __init__(
        self,
        *,
        last_computed_time: Optional[datetime.datetime] = None,
        next_eligible_compute_time: Optional[datetime.datetime] = None,
        route_set_version: Optional[str] = None,
        route_sets: Optional[list["_models.GatewayRouteSet"]] = None,
        circuits_metadata_map: Optional[dict[str, "_models.CircuitMetadataMap"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_computed_time: Timestamp denoting the last time when the route sets were computed
         for the gateway.
        :paramtype last_computed_time: ~datetime.datetime
        :keyword next_eligible_compute_time: Timestamp denoting the next eligible time to re-compute
         the route sets for the gateway.
        :paramtype next_eligible_compute_time: ~datetime.datetime
        :keyword route_set_version: Version for the route set.
        :paramtype route_set_version: str
        :keyword route_sets: List of Gateway Route Sets.
        :paramtype route_sets: list[~azure.mgmt.network.models.GatewayRouteSet]
        :keyword circuits_metadata_map: Dictionary containing map of the circuit id and circuit
         details.
        :paramtype circuits_metadata_map: dict[str, ~azure.mgmt.network.models.CircuitMetadataMap]
        """
        super().__init__(**kwargs)
        self.last_computed_time = last_computed_time
        self.next_eligible_compute_time = next_eligible_compute_time
        self.route_set_version = route_set_version
        self.route_sets = route_sets
        self.circuits_metadata_map = circuits_metadata_map


class GenerateExpressRoutePortsLOARequest(_serialization.Model):
    """The customer name to be printed on a letter of authorization.

    All required parameters must be populated in order to send to server.

    :ivar customer_name: The customer name. Required.
    :vartype customer_name: str
    """

    _validation = {
        "customer_name": {"required": True},
    }

    _attribute_map = {
        "customer_name": {"key": "customerName", "type": "str"},
    }

    def __init__(self, *, customer_name: str, **kwargs: Any) -> None:
        """
        :keyword customer_name: The customer name. Required.
        :paramtype customer_name: str
        """
        super().__init__(**kwargs)
        self.customer_name = customer_name


class GenerateExpressRoutePortsLOAResult(_serialization.Model):
    """Response for GenerateExpressRoutePortsLOA API service call.

    :ivar encoded_content: The content as a base64 encoded string.
    :vartype encoded_content: str
    """

    _attribute_map = {
        "encoded_content": {"key": "encodedContent", "type": "str"},
    }

    def __init__(self, *, encoded_content: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword encoded_content: The content as a base64 encoded string.
        :paramtype encoded_content: str
        """
        super().__init__(**kwargs)
        self.encoded_content = encoded_content


class GetInboundRoutesParameters(_serialization.Model):
    """The parameters specifying the connection resource whose inbound routes are being requested.

    :ivar resource_uri: The connection resource whose inbound routes are being requested.
    :vartype resource_uri: str
    :ivar connection_type: The type of the specified connection resource like
     ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
    :vartype connection_type: str
    """

    _attribute_map = {
        "resource_uri": {"key": "resourceUri", "type": "str"},
        "connection_type": {"key": "connectionType", "type": "str"},
    }

    def __init__(
        self, *, resource_uri: Optional[str] = None, connection_type: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_uri: The connection resource whose inbound routes are being requested.
        :paramtype resource_uri: str
        :keyword connection_type: The type of the specified connection resource like
         ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
        :paramtype connection_type: str
        """
        super().__init__(**kwargs)
        self.resource_uri = resource_uri
        self.connection_type = connection_type


class GetOutboundRoutesParameters(_serialization.Model):
    """The parameters specifying the connection resource whose outbound routes are being requested.

    :ivar resource_uri: The connection resource whose outbound routes are being requested.
    :vartype resource_uri: str
    :ivar connection_type: The type of the specified connection resource like
     ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
    :vartype connection_type: str
    """

    _attribute_map = {
        "resource_uri": {"key": "resourceUri", "type": "str"},
        "connection_type": {"key": "connectionType", "type": "str"},
    }

    def __init__(
        self, *, resource_uri: Optional[str] = None, connection_type: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_uri: The connection resource whose outbound routes are being requested.
        :paramtype resource_uri: str
        :keyword connection_type: The type of the specified connection resource like
         ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
        :paramtype connection_type: str
        """
        super().__init__(**kwargs)
        self.resource_uri = resource_uri
        self.connection_type = connection_type


class GetVpnSitesConfigurationRequest(_serialization.Model):
    """List of Vpn-Sites.

    All required parameters must be populated in order to send to server.

    :ivar vpn_sites: List of resource-ids of the vpn-sites for which config is to be downloaded.
    :vartype vpn_sites: list[str]
    :ivar output_blob_sas_url: The sas-url to download the configurations for vpn-sites. Required.
    :vartype output_blob_sas_url: str
    """

    _validation = {
        "output_blob_sas_url": {"required": True},
    }

    _attribute_map = {
        "vpn_sites": {"key": "vpnSites", "type": "[str]"},
        "output_blob_sas_url": {"key": "outputBlobSasUrl", "type": "str"},
    }

    def __init__(self, *, output_blob_sas_url: str, vpn_sites: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword vpn_sites: List of resource-ids of the vpn-sites for which config is to be downloaded.
        :paramtype vpn_sites: list[str]
        :keyword output_blob_sas_url: The sas-url to download the configurations for vpn-sites.
         Required.
        :paramtype output_blob_sas_url: str
        """
        super().__init__(**kwargs)
        self.vpn_sites = vpn_sites
        self.output_blob_sas_url = output_blob_sas_url


class GroupByUserSession(_serialization.Model):
    """Define user session identifier group by clauses.

    All required parameters must be populated in order to send to server.

    :ivar group_by_variables: List of group by clause variables. Required.
    :vartype group_by_variables: list[~azure.mgmt.network.models.GroupByVariable]
    """

    _validation = {
        "group_by_variables": {"required": True},
    }

    _attribute_map = {
        "group_by_variables": {"key": "groupByVariables", "type": "[GroupByVariable]"},
    }

    def __init__(self, *, group_by_variables: list["_models.GroupByVariable"], **kwargs: Any) -> None:
        """
        :keyword group_by_variables: List of group by clause variables. Required.
        :paramtype group_by_variables: list[~azure.mgmt.network.models.GroupByVariable]
        """
        super().__init__(**kwargs)
        self.group_by_variables = group_by_variables


class GroupByVariable(_serialization.Model):
    """Define user session group by clause variables.

    All required parameters must be populated in order to send to server.

    :ivar variable_name: User Session clause variable. Required. Known values are: "ClientAddr",
     "GeoLocation", "None", "ClientAddrXFFHeader", and "GeoLocationXFFHeader".
    :vartype variable_name: str or
     ~azure.mgmt.network.models.ApplicationGatewayFirewallUserSessionVariable
    """

    _validation = {
        "variable_name": {"required": True},
    }

    _attribute_map = {
        "variable_name": {"key": "variableName", "type": "str"},
    }

    def __init__(
        self, *, variable_name: Union[str, "_models.ApplicationGatewayFirewallUserSessionVariable"], **kwargs: Any
    ) -> None:
        """
        :keyword variable_name: User Session clause variable. Required. Known values are: "ClientAddr",
         "GeoLocation", "None", "ClientAddrXFFHeader", and "GeoLocationXFFHeader".
        :paramtype variable_name: str or
         ~azure.mgmt.network.models.ApplicationGatewayFirewallUserSessionVariable
        """
        super().__init__(**kwargs)
        self.variable_name = variable_name


class HeaderValueMatcher(_serialization.Model):
    """An optional field under "Rewrite Action". It lets you capture and modify the value(s) of a
    specific header when multiple headers with the same name exist. Currently supported for
    Set-Cookie Response header only. For more details, visit https://aka.ms/appgwheadercrud.

    :ivar pattern: The pattern, either fixed string or regular expression, that evaluates if a
     header value should be selected for rewrite.
    :vartype pattern: str
    :ivar ignore_case: Setting this parameter to truth value with force the pattern to do a case
     in-sensitive comparison.
    :vartype ignore_case: bool
    :ivar negate: Setting this value as truth will force to check the negation of the condition
     given by the user in the pattern field.
    :vartype negate: bool
    """

    _attribute_map = {
        "pattern": {"key": "pattern", "type": "str"},
        "ignore_case": {"key": "ignoreCase", "type": "bool"},
        "negate": {"key": "negate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        pattern: Optional[str] = None,
        ignore_case: Optional[bool] = None,
        negate: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pattern: The pattern, either fixed string or regular expression, that evaluates if a
         header value should be selected for rewrite.
        :paramtype pattern: str
        :keyword ignore_case: Setting this parameter to truth value with force the pattern to do a case
         in-sensitive comparison.
        :paramtype ignore_case: bool
        :keyword negate: Setting this value as truth will force to check the negation of the condition
         given by the user in the pattern field.
        :paramtype negate: bool
        """
        super().__init__(**kwargs)
        self.pattern = pattern
        self.ignore_case = ignore_case
        self.negate = negate


class HopLink(_serialization.Model):
    """Hop link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_hop_id: The ID of the next hop.
    :vartype next_hop_id: str
    :ivar link_type: Link type.
    :vartype link_type: str
    :ivar issues: List of issues.
    :vartype issues: list[~azure.mgmt.network.models.ConnectivityIssue]
    :ivar context: Provides additional context on links.
    :vartype context: dict[str, str]
    :ivar resource_id: Resource ID.
    :vartype resource_id: str
    :ivar round_trip_time_min: Minimum roundtrip time in milliseconds.
    :vartype round_trip_time_min: int
    :ivar round_trip_time_avg: Average roundtrip time in milliseconds.
    :vartype round_trip_time_avg: int
    :ivar round_trip_time_max: Maximum roundtrip time in milliseconds.
    :vartype round_trip_time_max: int
    """

    _validation = {
        "next_hop_id": {"readonly": True},
        "link_type": {"readonly": True},
        "issues": {"readonly": True},
        "context": {"readonly": True},
        "resource_id": {"readonly": True},
        "round_trip_time_min": {"readonly": True, "maximum": 4294967295, "minimum": 0},
        "round_trip_time_avg": {"readonly": True, "maximum": 4294967295, "minimum": 0},
        "round_trip_time_max": {"readonly": True, "maximum": 4294967295, "minimum": 0},
    }

    _attribute_map = {
        "next_hop_id": {"key": "nextHopId", "type": "str"},
        "link_type": {"key": "linkType", "type": "str"},
        "issues": {"key": "issues", "type": "[ConnectivityIssue]"},
        "context": {"key": "context", "type": "{str}"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "round_trip_time_min": {"key": "properties.roundTripTimeMin", "type": "int"},
        "round_trip_time_avg": {"key": "properties.roundTripTimeAvg", "type": "int"},
        "round_trip_time_max": {"key": "properties.roundTripTimeMax", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.next_hop_id: Optional[str] = None
        self.link_type: Optional[str] = None
        self.issues: Optional[list["_models.ConnectivityIssue"]] = None
        self.context: Optional[dict[str, str]] = None
        self.resource_id: Optional[str] = None
        self.round_trip_time_min: Optional[int] = None
        self.round_trip_time_avg: Optional[int] = None
        self.round_trip_time_max: Optional[int] = None


class HTTPConfiguration(_serialization.Model):
    """HTTP configuration of the connectivity check.

    :ivar method: HTTP method. "Get"
    :vartype method: str or ~azure.mgmt.network.models.HTTPMethod
    :ivar headers: List of HTTP headers.
    :vartype headers: list[~azure.mgmt.network.models.HTTPHeader]
    :ivar valid_status_codes: Valid status codes.
    :vartype valid_status_codes: list[int]
    """

    _attribute_map = {
        "method": {"key": "method", "type": "str"},
        "headers": {"key": "headers", "type": "[HTTPHeader]"},
        "valid_status_codes": {"key": "validStatusCodes", "type": "[int]"},
    }

    def __init__(
        self,
        *,
        method: Optional[Union[str, "_models.HTTPMethod"]] = None,
        headers: Optional[list["_models.HTTPHeader"]] = None,
        valid_status_codes: Optional[list[int]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword method: HTTP method. "Get"
        :paramtype method: str or ~azure.mgmt.network.models.HTTPMethod
        :keyword headers: List of HTTP headers.
        :paramtype headers: list[~azure.mgmt.network.models.HTTPHeader]
        :keyword valid_status_codes: Valid status codes.
        :paramtype valid_status_codes: list[int]
        """
        super().__init__(**kwargs)
        self.method = method
        self.headers = headers
        self.valid_status_codes = valid_status_codes


class HTTPHeader(_serialization.Model):
    """The HTTP header.

    :ivar name: The name in HTTP header.
    :vartype name: str
    :ivar value: The value in HTTP header.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name in HTTP header.
        :paramtype name: str
        :keyword value: The value in HTTP header.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class Hub(_serialization.Model):
    """Hub Item.

    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    :ivar resource_type: Resource Type.
    :vartype resource_type: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, resource_type: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Resource Id.
        :paramtype resource_id: str
        :keyword resource_type: Resource Type.
        :paramtype resource_type: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.resource_type = resource_type


class HubIPAddresses(_serialization.Model):
    """IP addresses associated with azure firewall.

    :ivar public_i_ps: Public IP addresses associated with azure firewall.
    :vartype public_i_ps: ~azure.mgmt.network.models.HubPublicIPAddresses
    :ivar private_ip_address: Private IP Address associated with azure firewall.
    :vartype private_ip_address: str
    """

    _attribute_map = {
        "public_i_ps": {"key": "publicIPs", "type": "HubPublicIPAddresses"},
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_i_ps: Optional["_models.HubPublicIPAddresses"] = None,
        private_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_i_ps: Public IP addresses associated with azure firewall.
        :paramtype public_i_ps: ~azure.mgmt.network.models.HubPublicIPAddresses
        :keyword private_ip_address: Private IP Address associated with azure firewall.
        :paramtype private_ip_address: str
        """
        super().__init__(**kwargs)
        self.public_i_ps = public_i_ps
        self.private_ip_address = private_ip_address


class HubIpConfiguration(SubResource):
    """IpConfigurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the Ip Configuration.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Ipconfiguration type.
    :vartype type: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
    :ivar subnet: The reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar public_ip_address: The reference to the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar provisioning_state: The provisioning state of the IP configuration resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the Ip Configuration.
        :paramtype name: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
        :keyword subnet: The reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        :keyword public_ip_address: The reference to the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class HubPublicIPAddresses(_serialization.Model):
    """Public IP addresses associated with azure firewall.

    :ivar addresses: The list of Public IP addresses associated with azure firewall or IP addresses
     to be retained.
    :vartype addresses: list[~azure.mgmt.network.models.AzureFirewallPublicIPAddress]
    :ivar count: The number of Public IP addresses associated with azure firewall.
    :vartype count: int
    """

    _attribute_map = {
        "addresses": {"key": "addresses", "type": "[AzureFirewallPublicIPAddress]"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(
        self,
        *,
        addresses: Optional[list["_models.AzureFirewallPublicIPAddress"]] = None,
        count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword addresses: The list of Public IP addresses associated with azure firewall or IP
         addresses to be retained.
        :paramtype addresses: list[~azure.mgmt.network.models.AzureFirewallPublicIPAddress]
        :keyword count: The number of Public IP addresses associated with azure firewall.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.addresses = addresses
        self.count = count


class HubRoute(_serialization.Model):
    """RouteTable route.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the Route that is unique within a RouteTable. This name can be used to
     access this route. Required.
    :vartype name: str
    :ivar destination_type: The type of destinations (eg: CIDR, ResourceId, Service). Required.
    :vartype destination_type: str
    :ivar destinations: List of all destinations. Required.
    :vartype destinations: list[str]
    :ivar next_hop_type: The type of next hop (eg: ResourceId). Required.
    :vartype next_hop_type: str
    :ivar next_hop: NextHop resource ID. Required.
    :vartype next_hop: str
    """

    _validation = {
        "name": {"required": True},
        "destination_type": {"required": True},
        "destinations": {"required": True},
        "next_hop_type": {"required": True},
        "next_hop": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "destination_type": {"key": "destinationType", "type": "str"},
        "destinations": {"key": "destinations", "type": "[str]"},
        "next_hop_type": {"key": "nextHopType", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        destination_type: str,
        destinations: list[str],
        next_hop_type: str,
        next_hop: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the Route that is unique within a RouteTable. This name can be used
         to access this route. Required.
        :paramtype name: str
        :keyword destination_type: The type of destinations (eg: CIDR, ResourceId, Service). Required.
        :paramtype destination_type: str
        :keyword destinations: List of all destinations. Required.
        :paramtype destinations: list[str]
        :keyword next_hop_type: The type of next hop (eg: ResourceId). Required.
        :paramtype next_hop_type: str
        :keyword next_hop: NextHop resource ID. Required.
        :paramtype next_hop: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.destination_type = destination_type
        self.destinations = destinations
        self.next_hop_type = next_hop_type
        self.next_hop = next_hop


class HubRouteTable(SubResource):
    """RouteTable resource in a virtual hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar routes: List of all routes.
    :vartype routes: list[~azure.mgmt.network.models.HubRoute]
    :ivar labels: List of labels associated with this route table.
    :vartype labels: list[str]
    :ivar associated_connections: List of all connections associated with this route table.
    :vartype associated_connections: list[str]
    :ivar propagating_connections: List of all connections that advertise to this route table.
    :vartype propagating_connections: list[str]
    :ivar provisioning_state: The provisioning state of the RouteTable resource. Known values are:
     "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "associated_connections": {"readonly": True},
        "propagating_connections": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[HubRoute]"},
        "labels": {"key": "properties.labels", "type": "[str]"},
        "associated_connections": {"key": "properties.associatedConnections", "type": "[str]"},
        "propagating_connections": {"key": "properties.propagatingConnections", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        routes: Optional[list["_models.HubRoute"]] = None,
        labels: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword routes: List of all routes.
        :paramtype routes: list[~azure.mgmt.network.models.HubRoute]
        :keyword labels: List of labels associated with this route table.
        :paramtype labels: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.routes = routes
        self.labels = labels
        self.associated_connections: Optional[list[str]] = None
        self.propagating_connections: Optional[list[str]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class HubVirtualNetworkConnection(SubResource):
    """HubVirtualNetworkConnection Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar remote_virtual_network: Reference to the remote virtual network.
    :vartype remote_virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar allow_hub_to_remote_vnet_transit: Deprecated: VirtualHub to RemoteVnet transit to enabled
     or not.
    :vartype allow_hub_to_remote_vnet_transit: bool
    :ivar allow_remote_vnet_to_use_hub_vnet_gateways: Deprecated: Allow RemoteVnet to use Virtual
     Hub's gateways.
    :vartype allow_remote_vnet_to_use_hub_vnet_gateways: bool
    :ivar enable_internet_security: Enable internet security.
    :vartype enable_internet_security: bool
    :ivar routing_configuration: The Routing Configuration indicating the associated and propagated
     route tables on this connection.
    :vartype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
    :ivar provisioning_state: The provisioning state of the hub virtual network connection
     resource. Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "remote_virtual_network": {"key": "properties.remoteVirtualNetwork", "type": "SubResource"},
        "allow_hub_to_remote_vnet_transit": {"key": "properties.allowHubToRemoteVnetTransit", "type": "bool"},
        "allow_remote_vnet_to_use_hub_vnet_gateways": {
            "key": "properties.allowRemoteVnetToUseHubVnetGateways",
            "type": "bool",
        },
        "enable_internet_security": {"key": "properties.enableInternetSecurity", "type": "bool"},
        "routing_configuration": {"key": "properties.routingConfiguration", "type": "RoutingConfiguration"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        remote_virtual_network: Optional["_models.SubResource"] = None,
        allow_hub_to_remote_vnet_transit: Optional[bool] = None,
        allow_remote_vnet_to_use_hub_vnet_gateways: Optional[bool] = None,
        enable_internet_security: Optional[bool] = None,
        routing_configuration: Optional["_models.RoutingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword remote_virtual_network: Reference to the remote virtual network.
        :paramtype remote_virtual_network: ~azure.mgmt.network.models.SubResource
        :keyword allow_hub_to_remote_vnet_transit: Deprecated: VirtualHub to RemoteVnet transit to
         enabled or not.
        :paramtype allow_hub_to_remote_vnet_transit: bool
        :keyword allow_remote_vnet_to_use_hub_vnet_gateways: Deprecated: Allow RemoteVnet to use
         Virtual Hub's gateways.
        :paramtype allow_remote_vnet_to_use_hub_vnet_gateways: bool
        :keyword enable_internet_security: Enable internet security.
        :paramtype enable_internet_security: bool
        :keyword routing_configuration: The Routing Configuration indicating the associated and
         propagated route tables on this connection.
        :paramtype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.remote_virtual_network = remote_virtual_network
        self.allow_hub_to_remote_vnet_transit = allow_hub_to_remote_vnet_transit
        self.allow_remote_vnet_to_use_hub_vnet_gateways = allow_remote_vnet_to_use_hub_vnet_gateways
        self.enable_internet_security = enable_internet_security
        self.routing_configuration = routing_configuration
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class IDPSQueryObject(_serialization.Model):
    """Will describe the query to run against the IDPS signatures DB.

    :ivar filters: Contain all filters names and values.
    :vartype filters: list[~azure.mgmt.network.models.FilterItems]
    :ivar search: Search term in all columns.
    :vartype search: str
    :ivar order_by: Column to sort response by.
    :vartype order_by: ~azure.mgmt.network.models.OrderBy
    :ivar results_per_page: The number of the results to return in each page.
    :vartype results_per_page: int
    :ivar skip: The number of records matching the filter to skip.
    :vartype skip: int
    """

    _validation = {
        "results_per_page": {"maximum": 1000, "minimum": 1},
    }

    _attribute_map = {
        "filters": {"key": "filters", "type": "[FilterItems]"},
        "search": {"key": "search", "type": "str"},
        "order_by": {"key": "orderBy", "type": "OrderBy"},
        "results_per_page": {"key": "resultsPerPage", "type": "int"},
        "skip": {"key": "skip", "type": "int"},
    }

    def __init__(
        self,
        *,
        filters: Optional[list["_models.FilterItems"]] = None,
        search: Optional[str] = None,
        order_by: Optional["_models.OrderBy"] = None,
        results_per_page: Optional[int] = None,
        skip: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword filters: Contain all filters names and values.
        :paramtype filters: list[~azure.mgmt.network.models.FilterItems]
        :keyword search: Search term in all columns.
        :paramtype search: str
        :keyword order_by: Column to sort response by.
        :paramtype order_by: ~azure.mgmt.network.models.OrderBy
        :keyword results_per_page: The number of the results to return in each page.
        :paramtype results_per_page: int
        :keyword skip: The number of records matching the filter to skip.
        :paramtype skip: int
        """
        super().__init__(**kwargs)
        self.filters = filters
        self.search = search
        self.order_by = order_by
        self.results_per_page = results_per_page
        self.skip = skip


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of inbound NAT pools used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar protocol: The reference to the transport protocol used by the inbound NAT pool. Known
     values are: "Udp", "Tcp", "All", and "Quic".
    :vartype protocol: str or ~azure.mgmt.network.models.TransportProtocol
    :ivar frontend_port_range_start: The first port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65534.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The last port number in the range of external ports that will be
     used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :vartype frontend_port_range_end: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT pool resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port_range_start": {"key": "properties.frontendPortRangeStart", "type": "int"},
        "frontend_port_range_end": {"key": "properties.frontendPortRangeEnd", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of inbound NAT pools used
         by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the inbound NAT pool. Known
         values are: "Udp", "Tcp", "All", and "Quic".
        :paramtype protocol: str or ~azure.mgmt.network.models.TransportProtocol
        :keyword frontend_port_range_start: The first port number in the range of external ports that
         will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
         range between 1 and 65534.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: The last port number in the range of external ports that will
         be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
         between 1 and 65535.
        :paramtype frontend_port_range_end: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class InboundNatRule(SubResource):
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of inbound NAT rules used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backend IP.
    :vartype backend_ip_configuration: ~azure.mgmt.network.models.NetworkInterfaceIPConfiguration
    :ivar protocol: The reference to the transport protocol used by the load balancing rule. Known
     values are: "Udp", "Tcp", "All", and "Quic".
    :vartype protocol: str or ~azure.mgmt.network.models.TransportProtocol
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :vartype frontend_port: int
    :ivar backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar frontend_port_range_start: The port range start for the external endpoint. This property
     is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule
     port mappings will be created for each backend address from BackendAddressPool. Acceptable
     values range from 1 to 65534.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The port range end for the external endpoint. This property is
     used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule
     port mappings will be created for each backend address from BackendAddressPool. Acceptable
     values range from 1 to 65534.
    :vartype frontend_port_range_end: int
    :ivar backend_address_pool: A reference to backendAddressPool resource.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the inbound NAT rule resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "backend_ip_configuration": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_ip_configuration": {
            "key": "properties.backendIPConfiguration",
            "type": "NetworkInterfaceIPConfiguration",
        },
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "frontend_port_range_start": {"key": "properties.frontendPortRangeStart", "type": "int"},
        "frontend_port_range_end": {"key": "properties.frontendPortRangeEnd", "type": "int"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of inbound NAT rules used
         by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the load balancing rule.
         Known values are: "Udp", "Tcp", "All", and "Quic".
        :paramtype protocol: str or ~azure.mgmt.network.models.TransportProtocol
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :paramtype frontend_port: int
        :keyword backend_port: The port used for the internal endpoint. Acceptable values range from 1
         to 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        :keyword frontend_port_range_start: The port range start for the external endpoint. This
         property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound
         NAT rule port mappings will be created for each backend address from BackendAddressPool.
         Acceptable values range from 1 to 65534.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: The port range end for the external endpoint. This property
         is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT
         rule port mappings will be created for each backend address from BackendAddressPool. Acceptable
         values range from 1 to 65534.
        :paramtype frontend_port_range_end: int
        :keyword backend_address_pool: A reference to backendAddressPool resource.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration: Optional["_models.NetworkInterfaceIPConfiguration"] = None
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_address_pool = backend_address_pool
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class InboundNatRuleListResult(_serialization.Model):
    """Response for ListInboundNatRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of inbound NAT rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.models.InboundNatRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InboundNatRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.InboundNatRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of inbound NAT rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.models.InboundNatRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class InboundNatRulePortMapping(_serialization.Model):
    """Individual port mappings for inbound NAT rule created for backend pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar inbound_nat_rule_name: Name of inbound NAT rule.
    :vartype inbound_nat_rule_name: str
    :ivar protocol: The reference to the transport protocol used by the inbound NAT rule. Known
     values are: "Udp", "Tcp", "All", and "Quic".
    :vartype protocol: str or ~azure.mgmt.network.models.TransportProtocol
    :ivar frontend_port: Frontend port.
    :vartype frontend_port: int
    :ivar backend_port: Backend port.
    :vartype backend_port: int
    """

    _validation = {
        "inbound_nat_rule_name": {"readonly": True},
        "protocol": {"readonly": True},
        "frontend_port": {"readonly": True},
        "backend_port": {"readonly": True},
    }

    _attribute_map = {
        "inbound_nat_rule_name": {"key": "inboundNatRuleName", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "frontend_port": {"key": "frontendPort", "type": "int"},
        "backend_port": {"key": "backendPort", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.inbound_nat_rule_name: Optional[str] = None
        self.protocol: Optional[Union[str, "_models.TransportProtocol"]] = None
        self.frontend_port: Optional[int] = None
        self.backend_port: Optional[int] = None


class InboundSecurityRule(SubResource):
    """NVA Inbound Security Rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of security rule collection.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: NVA inbound security rule type.
    :vartype type: str
    :ivar rule_type: Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule
     only creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule. Known values are:
     "AutoExpire" and "Permanent".
    :vartype rule_type: str or ~azure.mgmt.network.models.InboundSecurityRuleType
    :ivar rules: List of allowed rules.
    :vartype rules: list[~azure.mgmt.network.models.InboundSecurityRules]
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "rules": {"key": "properties.rules", "type": "[InboundSecurityRules]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.InboundSecurityRuleType"]] = None,
        rules: Optional[list["_models.InboundSecurityRules"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of security rule collection.
        :paramtype name: str
        :keyword rule_type: Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule
         only creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule. Known values are:
         "AutoExpire" and "Permanent".
        :paramtype rule_type: str or ~azure.mgmt.network.models.InboundSecurityRuleType
        :keyword rules: List of allowed rules.
        :paramtype rules: list[~azure.mgmt.network.models.InboundSecurityRules]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.type: Optional[str] = None
        self.rule_type = rule_type
        self.rules = rules
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class InboundSecurityRules(_serialization.Model):
    """Properties of the Inbound Security Rules resource.

    :ivar name: Name of the rule.
    :vartype name: str
    :ivar protocol: Protocol. This should be either TCP or UDP. Known values are: "TCP" and "UDP".
    :vartype protocol: str or ~azure.mgmt.network.models.InboundSecurityRulesProtocol
    :ivar source_address_prefix: The CIDR or source IP range.
    :vartype source_address_prefix: str
    :ivar destination_port_range: NVA port ranges to be opened up. One needs to provide specific
     ports.
    :vartype destination_port_range: int
    :ivar destination_port_ranges: NVA port ranges to be opened up. One can provide a range of
     ports. Allowed port value between 0 and 65535.
    :vartype destination_port_ranges: list[str]
    :ivar applies_on: Public IP name in case of Permanent Rule type & Interface Name in case of
     Auto Expire Rule type.
    :vartype applies_on: list[str]
    """

    _validation = {
        "destination_port_range": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source_address_prefix": {"key": "sourceAddressPrefix", "type": "str"},
        "destination_port_range": {"key": "destinationPortRange", "type": "int"},
        "destination_port_ranges": {"key": "destinationPortRanges", "type": "[str]"},
        "applies_on": {"key": "appliesOn", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.InboundSecurityRulesProtocol"]] = None,
        source_address_prefix: Optional[str] = None,
        destination_port_range: Optional[int] = None,
        destination_port_ranges: Optional[list[str]] = None,
        applies_on: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the rule.
        :paramtype name: str
        :keyword protocol: Protocol. This should be either TCP or UDP. Known values are: "TCP" and
         "UDP".
        :paramtype protocol: str or ~azure.mgmt.network.models.InboundSecurityRulesProtocol
        :keyword source_address_prefix: The CIDR or source IP range.
        :paramtype source_address_prefix: str
        :keyword destination_port_range: NVA port ranges to be opened up. One needs to provide specific
         ports.
        :paramtype destination_port_range: int
        :keyword destination_port_ranges: NVA port ranges to be opened up. One can provide a range of
         ports. Allowed port value between 0 and 65535.
        :paramtype destination_port_ranges: list[str]
        :keyword applies_on: Public IP name in case of Permanent Rule type & Interface Name in case of
         Auto Expire Rule type.
        :paramtype applies_on: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.source_address_prefix = source_address_prefix
        self.destination_port_range = destination_port_range
        self.destination_port_ranges = destination_port_ranges
        self.applies_on = applies_on


class IntentContent(_serialization.Model):
    """Intent information.

    All required parameters must be populated in order to send to server.

    :ivar description:
    :vartype description: str
    :ivar source_resource_id: Source resource id of the intent. Required.
    :vartype source_resource_id: str
    :ivar destination_resource_id: Destination resource id of the intent. Required.
    :vartype destination_resource_id: str
    :ivar ip_traffic: IP traffic information. Required.
    :vartype ip_traffic: ~azure.mgmt.network.models.IPTraffic
    """

    _validation = {
        "source_resource_id": {"required": True},
        "destination_resource_id": {"required": True},
        "ip_traffic": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "destination_resource_id": {"key": "destinationResourceId", "type": "str"},
        "ip_traffic": {"key": "ipTraffic", "type": "IPTraffic"},
    }

    def __init__(
        self,
        *,
        source_resource_id: str,
        destination_resource_id: str,
        ip_traffic: "_models.IPTraffic",
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description:
        :paramtype description: str
        :keyword source_resource_id: Source resource id of the intent. Required.
        :paramtype source_resource_id: str
        :keyword destination_resource_id: Destination resource id of the intent. Required.
        :paramtype destination_resource_id: str
        :keyword ip_traffic: IP traffic information. Required.
        :paramtype ip_traffic: ~azure.mgmt.network.models.IPTraffic
        """
        super().__init__(**kwargs)
        self.description = description
        self.source_resource_id = source_resource_id
        self.destination_resource_id = destination_resource_id
        self.ip_traffic = ip_traffic


class InternetIngressPublicIpsProperties(_serialization.Model):
    """Resource Uri of Public Ip for Standard Load Balancer Frontend End.

    :ivar id: Resource Uri of Public Ip.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Uri of Public Ip.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class IPAddressAvailabilityResult(_serialization.Model):
    """Response for CheckIPAddressAvailability API service call.

    :ivar available: Private IP address availability.
    :vartype available: bool
    :ivar available_ip_addresses: Contains other available private IP addresses if the asked for
     address is taken.
    :vartype available_ip_addresses: list[str]
    :ivar is_platform_reserved: Private IP address platform reserved.
    :vartype is_platform_reserved: bool
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
        "available_ip_addresses": {"key": "availableIPAddresses", "type": "[str]"},
        "is_platform_reserved": {"key": "isPlatformReserved", "type": "bool"},
    }

    def __init__(
        self,
        *,
        available: Optional[bool] = None,
        available_ip_addresses: Optional[list[str]] = None,
        is_platform_reserved: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available: Private IP address availability.
        :paramtype available: bool
        :keyword available_ip_addresses: Contains other available private IP addresses if the asked for
         address is taken.
        :paramtype available_ip_addresses: list[str]
        :keyword is_platform_reserved: Private IP address platform reserved.
        :paramtype is_platform_reserved: bool
        """
        super().__init__(**kwargs)
        self.available = available
        self.available_ip_addresses = available_ip_addresses
        self.is_platform_reserved = is_platform_reserved


class IpAllocation(Resource):
    """IpAllocation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar subnet: The Subnet that using the prefix of this IpAllocation resource.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar virtual_network: The VirtualNetwork that using the prefix of this IpAllocation resource.
    :vartype virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar type_properties_type: The type for the IpAllocation. Known values are: "Undefined" and
     "Hypernet".
    :vartype type_properties_type: str or ~azure.mgmt.network.models.IpAllocationType
    :ivar prefix: The address prefix for the IpAllocation.
    :vartype prefix: str
    :ivar prefix_length: The address prefix length for the IpAllocation.
    :vartype prefix_length: int
    :ivar prefix_type: The address prefix Type for the IpAllocation. Known values are: "IPv4" and
     "IPv6".
    :vartype prefix_type: str or ~azure.mgmt.network.models.IPVersion
    :ivar ipam_allocation_id: The IPAM allocation ID.
    :vartype ipam_allocation_id: str
    :ivar allocation_tags: IpAllocation tags.
    :vartype allocation_tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "subnet": {"readonly": True},
        "virtual_network": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "SubResource"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "prefix": {"key": "properties.prefix", "type": "str"},
        "prefix_length": {"key": "properties.prefixLength", "type": "int"},
        "prefix_type": {"key": "properties.prefixType", "type": "str"},
        "ipam_allocation_id": {"key": "properties.ipamAllocationId", "type": "str"},
        "allocation_tags": {"key": "properties.allocationTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        type_properties_type: Optional[Union[str, "_models.IpAllocationType"]] = None,
        prefix: Optional[str] = None,
        prefix_length: int = 0,
        prefix_type: Optional[Union[str, "_models.IPVersion"]] = None,
        ipam_allocation_id: Optional[str] = None,
        allocation_tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword type_properties_type: The type for the IpAllocation. Known values are: "Undefined" and
         "Hypernet".
        :paramtype type_properties_type: str or ~azure.mgmt.network.models.IpAllocationType
        :keyword prefix: The address prefix for the IpAllocation.
        :paramtype prefix: str
        :keyword prefix_length: The address prefix length for the IpAllocation.
        :paramtype prefix_length: int
        :keyword prefix_type: The address prefix Type for the IpAllocation. Known values are: "IPv4"
         and "IPv6".
        :paramtype prefix_type: str or ~azure.mgmt.network.models.IPVersion
        :keyword ipam_allocation_id: The IPAM allocation ID.
        :paramtype ipam_allocation_id: str
        :keyword allocation_tags: IpAllocation tags.
        :paramtype allocation_tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.subnet: Optional["_models.SubResource"] = None
        self.virtual_network: Optional["_models.SubResource"] = None
        self.type_properties_type = type_properties_type
        self.prefix = prefix
        self.prefix_length = prefix_length
        self.prefix_type = prefix_type
        self.ipam_allocation_id = ipam_allocation_id
        self.allocation_tags = allocation_tags


class IpAllocationListResult(_serialization.Model):
    """Response for the ListIpAllocations API service call.

    :ivar value: A list of IpAllocation resources.
    :vartype value: list[~azure.mgmt.network.models.IpAllocation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpAllocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.IpAllocation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of IpAllocation resources.
        :paramtype value: list[~azure.mgmt.network.models.IpAllocation]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpamPool(CommonTrackedResource):
    """Instance of Pool resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.network.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of IpamPool resource properties which are specific to the Pool
     resource. Required.
    :vartype properties: ~azure.mgmt.network.models.IpamPoolProperties
    :ivar etag: String representing unique etag for the resource document.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "IpamPoolProperties"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.IpamPoolProperties",
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Properties of IpamPool resource properties which are specific to the Pool
         resource. Required.
        :paramtype properties: ~azure.mgmt.network.models.IpamPoolProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.etag: Optional[str] = None


class IpamPoolList(_serialization.Model):
    """List of IpamPool.

    :ivar value:
    :vartype value: list[~azure.mgmt.network.models.IpamPool]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpamPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.IpamPool"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.network.models.IpamPool]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpamPoolPrefixAllocation(_serialization.Model):
    """IpamPool prefix allocation reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_ip_addresses: Number of IP addresses to allocate.
    :vartype number_of_ip_addresses: str
    :ivar allocated_address_prefixes: List of assigned IP address prefixes in the IpamPool of the
     associated resource.
    :vartype allocated_address_prefixes: list[str]
    :ivar id: Resource id of the associated Azure IpamPool resource.
    :vartype id: str
    """

    _validation = {
        "allocated_address_prefixes": {"readonly": True},
    }

    _attribute_map = {
        "number_of_ip_addresses": {"key": "numberOfIpAddresses", "type": "str"},
        "allocated_address_prefixes": {"key": "allocatedAddressPrefixes", "type": "[str]"},
        "id": {"key": "pool.id", "type": "str"},
    }

    def __init__(
        self,
        *,
        number_of_ip_addresses: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_ip_addresses: Number of IP addresses to allocate.
        :paramtype number_of_ip_addresses: str
        :keyword id: Resource id of the associated Azure IpamPool resource.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.number_of_ip_addresses = number_of_ip_addresses
        self.allocated_address_prefixes: Optional[list[str]] = None
        self.id = id


class IpamPoolProperties(_serialization.Model):
    """Properties of IpamPool resource properties which are specific to the Pool resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar description:
    :vartype description: str
    :ivar display_name: String representing a friendly name for the resource.
    :vartype display_name: str
    :ivar ip_address_type: List of IP address type for the IpamPool.
    :vartype ip_address_type: list[str or ~azure.mgmt.network.models.IpType]
    :ivar parent_pool_name: String representing parent IpamPool resource name. If empty the
     IpamPool will be a root pool.
    :vartype parent_pool_name: str
    :ivar address_prefixes: List of IP address prefixes of the resource. Required.
    :vartype address_prefixes: list[str]
    :ivar provisioning_state: Provisioning states of a resource. Known values are: "Failed",
     "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "ip_address_type": {"readonly": True},
        "address_prefixes": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "ip_address_type": {"key": "ipAddressType", "type": "[str]"},
        "parent_pool_name": {"key": "parentPoolName", "type": "str"},
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        address_prefixes: list[str],
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        parent_pool_name: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description:
        :paramtype description: str
        :keyword display_name: String representing a friendly name for the resource.
        :paramtype display_name: str
        :keyword parent_pool_name: String representing parent IpamPool resource name. If empty the
         IpamPool will be a root pool.
        :paramtype parent_pool_name: str
        :keyword address_prefixes: List of IP address prefixes of the resource. Required.
        :paramtype address_prefixes: list[str]
        :keyword provisioning_state: Provisioning states of a resource. Known values are: "Failed",
         "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
        :paramtype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.description = description
        self.display_name = display_name
        self.ip_address_type: Optional[list[Union[str, "_models.IpType"]]] = None
        self.parent_pool_name = parent_pool_name
        self.address_prefixes = address_prefixes
        self.provisioning_state = provisioning_state


class IpamPoolUpdate(_serialization.Model):
    """Represents the IpamPool update API request interface.

    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar properties: Represents the IpamPool update properties.
    :vartype properties: ~azure.mgmt.network.models.IpamPoolUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "IpamPoolUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.IpamPoolUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword properties: Represents the IpamPool update properties.
        :paramtype properties: ~azure.mgmt.network.models.IpamPoolUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class IpamPoolUpdateProperties(_serialization.Model):
    """Represents the IpamPool update properties.

    :ivar description:
    :vartype description: str
    :ivar display_name: String representing a friendly name for the resource.
    :vartype display_name: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description:
        :paramtype description: str
        :keyword display_name: String representing a friendly name for the resource.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.display_name = display_name


class IPConfiguration(SubResource):
    """IP configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
    :ivar subnet: The reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar public_ip_address: The reference to the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar provisioning_state: The provisioning state of the IP configuration resource. Known values
     are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or ~azure.mgmt.network.models.IPAllocationMethod
        :keyword subnet: The reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        :keyword public_ip_address: The reference to the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag: Optional[str] = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class IPConfigurationBgpPeeringAddress(_serialization.Model):
    """Properties of IPConfigurationBgpPeeringAddress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ipconfiguration_id: The ID of IP configuration which belongs to gateway.
    :vartype ipconfiguration_id: str
    :ivar default_bgp_ip_addresses: The list of default BGP peering addresses which belong to IP
     configuration.
    :vartype default_bgp_ip_addresses: list[str]
    :ivar custom_bgp_ip_addresses: The list of custom BGP peering addresses which belong to IP
     configuration.
    :vartype custom_bgp_ip_addresses: list[str]
    :ivar tunnel_ip_addresses: The list of tunnel public IP addresses which belong to IP
     configuration.
    :vartype tunnel_ip_addresses: list[str]
    """

    _validation = {
        "default_bgp_ip_addresses": {"readonly": True},
        "tunnel_ip_addresses": {"readonly": True},
    }

    _attribute_map = {
        "ipconfiguration_id": {"key": "ipconfigurationId", "type": "str"},
        "default_bgp_ip_addresses": {"key": "defaultBgpIpAddresses", "type": "[str]"},
        "custom_bgp_ip_addresses": {"key": "customBgpIpAddresses", "type": "[str]"},
        "tunnel_ip_addresses": {"key": "tunnelIpAddresses", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        ipconfiguration_id: Optional[str] = None,
        custom_bgp_ip_addresses: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ipconfiguration_id: The ID of IP configuration which belongs to gateway.
        :paramtype ipconfiguration_id: str
        :keyword custom_bgp_ip_addresses: The list of custom BGP peering addresses which belong to IP
         configuration.
        :paramtype custom_bgp_ip_addresses: list[str]
        """
        super().__init__(**kwargs)
        self.ipconfiguration_id = ipconfiguration_id
        self.default_bgp_ip_addresses: Optional[list[str]] = None
        self.custom_bgp_ip_addresses = custom_bgp_ip_addresses
        self.tunnel_ip_addresses: Optional[list[str]] = None


class IPConfigurationProfile(SubResource):
    """IP configuration profile child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar subnet: The reference to the subnet resource to create a container network interface ip
     configuration.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar provisioning_state: The provisioning state of the IP configuration profile resource.
     Known values are: "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.Subnet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword subnet: The reference to the subnet resource to create a container network interface
         ip configuration.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type: Optional[str] = None
        self.etag: Optional[str] = None
        self.subnet = subnet
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class IpGroup(Resource):
    """The IpGroups resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the IpGroups resource. Known values are:
     "Failed", "Succeeded", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar ip_addresses: IpAddresses/IpAddressPrefixes in the IpGroups resource.
    :vartype ip_addresses: list[str]
    :ivar firewalls: List of references to Firewall resources that this IpGroups is associated
     with.
    :vartype firewalls: list[~azure.mgmt.network.models.SubResource]
    :ivar firewall_policies: List of references to Firewall Policies resources that this IpGroups
     is associated with.
    :vartype firewall_policies: list[~azure.mgmt.network.models.SubResource]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "firewalls": {"readonly": True},
        "firewall_policies": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "ip_addresses": {"key": "properties.ipAddresses", "type": "[str]"},
        "firewalls": {"key": "properties.firewalls", "type": "[SubResource]"},
        "firewall_policies": {"key": "properties.firewallPolicies", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        ip_addresses: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword ip_addresses: IpAddresses/IpAddressPrefixes in the IpGroups resource.
        :paramtype ip_addresses: list[str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.ip_addresses = ip_addresses
        self.firewalls: Optional[list["_models.SubResource"]] = None
        self.firewall_policies: Optional[list["_models.SubResource"]] = None


class IpGroupListResult(_serialization.Model):
    """Response for the ListIpGroups API service call.

    :ivar value: The list of IpGroups information resources.
    :vartype value: list[~azure.mgmt.network.models.IpGroup]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.IpGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of IpGroups information resources.
        :paramtype value: list[~azure.mgmt.network.models.IpGroup]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IPPrefixesList(_serialization.Model):
    """List of SNAT IP Prefixes learnt by firewall to not SNAT.

    :ivar ip_prefixes: IP Prefix value.
    :vartype ip_prefixes: list[str]
    """

    _attribute_map = {
        "ip_prefixes": {"key": "ipPrefixes", "type": "[str]"},
    }

    def __init__(self, *, ip_prefixes: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_prefixes: IP Prefix value.
        :paramtype ip_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.ip_prefixes = ip_prefixes


class IPRule(_serialization.Model):
    """IPRule.

    :ivar address_prefix: Specifies the IP or IP range in CIDR format. Only IPV4 address is
     allowed.
    :vartype address_prefix: str
    """

    _attribute_map = {
        "address_prefix": {"key": "addressPrefix", "type": "str"},
    }

    def __init__(self, *, address_prefix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address_prefix: Specifies the IP or IP range in CIDR format. Only IPV4 address is
         allowed.
        :paramtype address_prefix: str
        """
        super().__init__(**kwargs)
        self.address_prefix = address_prefix


class IpsecPolicy(_serialization.Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to server.

    :ivar sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) lifetime in seconds for a site to site VPN tunnel. Required.
    :vartype sa_life_time_seconds: int
    :ivar sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) payload size in KB for a site to site VPN tunnel. Required.
    :vartype sa_data_size_kilobytes: int
    :ivar ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
     are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
     "GCMAES256".
    :vartype ipsec_encryption: str or ~azure.mgmt.network.models.IpsecEncryption
    :ivar ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values are:
     "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
    :vartype ipsec_integrity: str or ~azure.mgmt.network.models.IpsecIntegrity
    :ivar ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values are:
     "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
    :vartype ike_encryption: str or ~azure.mgmt.network.models.IkeEncryption
    :ivar ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
     "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
    :vartype ike_integrity: str or ~azure.mgmt.network.models.IkeIntegrity
    :ivar dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
     "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
     "DHGroup24".
    :vartype dh_group: str or ~azure.mgmt.network.models.DhGroup
    :ivar pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
     are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
    :vartype pfs_group: str or ~azure.mgmt.network.models.PfsGroup
    """

    _validation = {
        "sa_life_time_seconds": {"required": True},
        "sa_data_size_kilobytes": {"required": True},
        "ipsec_encryption": {"required": True},
        "ipsec_integrity": {"required": True},
        "ike_encryption": {"required": True},
        "ike_integrity": {"required": True},
        "dh_group": {"required": True},
        "pfs_group": {"required": True},
    }

    _attribute_map = {
        "sa_life_time_seconds": {"key": "saLifeTimeSeconds", "type": "int"},
        "sa_data_size_kilobytes": {"key": "saDataSizeKilobytes", "type": "int"},
        "ipsec_encryption": {"key": "ipsecEncryption", "type": "str"},
        "ipsec_integrity": {"key": "ipsecIntegrity", "type": "str"},
        "ike_encryption": {"key": "ikeEncryption", "type": "str"},
        "ike_integrity": {"key": "ikeIntegrity", "type": "str"},
        "dh_group": {"key": "dhGroup", "type": "str"},
        "pfs_group": {"key": "pfsGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        sa_life_time_seconds: int,
        sa_data_size_kilobytes: int,
        ipsec_encryption: Union[str, "_models.IpsecEncryption"],
        ipsec_integrity: Union[str, "_models.IpsecIntegrity"],
        ike_encryption: Union[str, "_models.IkeEncryption"],
        ike_integrity: Union[str, "_models.IkeIntegrity"],
        dh_group: Union[str, "_models.DhGroup"],
        pfs_group: Union[str, "_models.PfsGroup"],
        **kwargs: Any
    ) -> None:
        """
        :keyword sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase
         2 SA) lifetime in seconds for a site to site VPN tunnel. Required.
        :paramtype sa_life_time_seconds: int
        :keyword sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or
         Phase 2 SA) payload size in KB for a site to site VPN tunnel. Required.
        :paramtype sa_data_size_kilobytes: int
        :keyword ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
         are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
         "GCMAES256".
        :paramtype ipsec_encryption: str or ~azure.mgmt.network.models.IpsecEncryption
        :keyword ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values
         are: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
        :paramtype ipsec_integrity: str or ~azure.mgmt.network.models.IpsecIntegrity
        :keyword ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values
         are: "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
        :paramtype ike_encryption: str or ~azure.mgmt.network.models.IkeEncryption
        :keyword ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
         "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
        :paramtype ike_integrity: str or ~azure.mgmt.network.models.IkeIntegrity
        :keyword dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
         "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
         "DHGroup24".
        :paramtype dh_group: str or ~azure.mgmt.network.models.DhGroup
        :keyword pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
         are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
        :paramtype pfs_group: str or ~azure.mgmt.network.models.PfsGroup
        """
        super().__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group


class IpTag(_serialization.Model):
    """Contains the IpTag associated with the object.

    :ivar ip_tag_type: The IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: The value of the IP tag associated with the public IP. Example: SQL.
    :vartype tag: str
    """

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: Optional[str] = None, tag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_tag_type: The IP tag type. Example: FirstPartyUsage.
        :paramtype ip_tag_type: str
        :keyword tag: The value of the IP tag associated with the public IP. Example: SQL.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class IPTraffic(_serialization.Model):
    """IP traffic information.

    All required parameters must be populated in order to send to server.

    :ivar source_ips: List of source IP addresses of the traffic.. Required.
    :vartype source_ips: list[str]
    :ivar destination_ips: List of destination IP addresses of the traffic.. Required.
    :vartype destination_ips: list[str]
    :ivar source_ports: The source ports of the traffic. Required.
    :vartype source_ports: list[str]
    :ivar destination_ports: The destination ports of the traffic. Required.
    :vartype destination_ports: list[str]
    :ivar protocols: Required.
    :vartype protocols: list[str or ~azure.mgmt.network.models.NetworkProtocol]
    """

    _validation = {
        "source_ips": {"required": True},
        "destination_ips": {"required": True},
        "source_ports": {"required": True},
        "destination_ports": {"required": True},
        "protocols": {"required": True},
    }

    _attribute_map = {
        "source_ips": {"key": "sourceIps", "type": "[str]"},
        "destination_ips": {"key": "destinationIps", "type": "[str]"},
        "source_ports": {"key": "sourcePorts", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        source_ips: list[str],
        destination_ips: list[str],
        source_ports: list[str],
        destination_ports: list[str],
        protocols: list[Union[str, "_models.NetworkProtocol"]],
        **kwargs: Any
    ) -> None:
        """
        :keyword source_ips: List of source IP addresses of the traffic.. Required.
        :paramtype source_ips: list[str]
        :keyword destination_ips: List of destination IP addresses of the traffic.. Required.
        :paramtype destination_ips: list[str]
        :keyword source_ports: The source ports of the traffic. Required.
        :paramtype source_ports: list[str]
        :keyword destination_ports: The destination ports of the traffic. Required.
        :paramtype destination_ports: list[str]
        :keyword protocols: Required.
        :paramtype protocols: list[str or ~azure.mgmt.network.models.NetworkProtocol]
        """
        super().__init__(**kwargs)
        self.source_ips = source_ips
        self.destination_ips = destination_ips
        self.source_ports = source_ports
        self.destination_ports = destination_ports
        self.protocols = protocols


class Ipv6CircuitConnectionConfig(_serialization.Model):
    """IPv6 Circuit Connection properties for global reach.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar address_prefix: /125 IP address space to carve out customer addresses for global reach.
    :vartype address_prefix: str
    :ivar circuit_connection_status: Express Route Circuit connection state. Known values are:
     "Connected", "Connecting", and "Disconnected".
    :vartype circuit_connection_status: str or ~azure.mgmt.network.models.CircuitConnectionStatus
    """

    _validation = {
        "circuit_connection_status": {"readonly": True},
    }

    _attribute_map = {
        "address_prefix": {"key": "addressPrefix", "type": "str"},
        "circuit_connection_status": {"key": "circuitConnectionStatus", "type": "str"},
    }

    def __init__(self, *, address_prefix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address_prefix: /125 IP address space to carve out customer addresses for global
         reach.
        :paramtype address_prefix: str
        """
        super().__init__(**kwargs)
        self.address_prefix = address_prefix
        self.circuit_connection_status: Optional[Union[str, "_models.CircuitConnectionStatus"]] = None

