# Documentation

**[Installation](1-installation.md)**
- [Requirements](1-installation.md#requirements)
- [Installation and update](1-installation.md#installation-and-update)
- [Imports](1-installation.md#imports)

**[Built-in functions](2-functions.md)**
- [`ping`](2-functions.md#ping)
- [`multiping`](2-functions.md#multiping)
- [`traceroute`](2-functions.md#traceroute)
- [`async_ping`](2-functions.md#async_ping)
- [`async_multiping`](2-functions.md#async_multiping)

**[Sockets and classes](3-sockets.md)**
- [`ICMPRequest`](3-sockets.md#ICMPRequest)
- [`ICMPReply`](3-sockets.md#ICMPReply)
- [`ICMPv4Socket`](3-sockets.md#ICMPv4Socket)
- [`ICMPv6Socket`](3-sockets.md#ICMPv6Socket)
- [`AsyncSocket`](3-sockets.md#AsyncSocket)
- [Examples](3-sockets.md#examples)

**[Exceptions](4-exceptions.md)**
- [`ICMPLibError`](4-exceptions.md#ICMPLibError)
- [`NameLookupError`](4-exceptions.md#NameLookupError)
- [`ICMPSocketError`](4-exceptions.md#ICMPSocketError)
- [`SocketAddressError`](4-exceptions.md#SocketAddressError)
- [`SocketPermissionError`](4-exceptions.md#SocketPermissionError)
- [`SocketUnavailableError`](4-exceptions.md#SocketUnavailableError)
- [`SocketBroadcastError`](4-exceptions.md#SocketBroadcastError)
- [`TimeoutExceeded`](4-exceptions.md#TimeoutExceeded)
- [`ICMPError`](4-exceptions.md#ICMPError)
- [`DestinationUnreachable`](4-exceptions.md#DestinationUnreachable)
- [`TimeExceeded`](4-exceptions.md#TimeExceeded)

**[Utilities](5-utilities.md)**
- [`resolve`](5-utilities.md#resolve)
- [`async_resolve`](5-utilities.md#async_resolve)
- [`is_hostname`](5-utilities.md#is_hostname)
- [`is_ipv4_address`](5-utilities.md#is_ipv4_address)
- [`is_ipv6_address`](5-utilities.md#is_ipv6_address)

**[Use icmplib without root privileges](6-use-icmplib-without-privileges.md)**

**[Examples](../examples)**
