% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escape.R
\name{curl_escape}
\alias{curl_escape}
\alias{curl_unescape}
\title{URL encoding}
\usage{
curl_escape(url)

curl_unescape(url)
}
\arguments{
\item{url}{A character vector (typically containing urls or parameters) to be
encoded/decoded}
}
\description{
Escape all special characters (i.e. everything except for a-z, A-Z, 0-9, '-',
'.', '_' or '~') for use in URLs.
}
\examples{
# Escape strings
out <- curl_escape("foo = bar + 5")
curl_unescape(out)

# All non-ascii characters are encoded
mu <- "\u00b5"
curl_escape(mu)
curl_unescape(curl_escape(mu))
}
