% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi.R
\name{ppi}
\alias{ppi}
\title{Compute the primitive partition identities}
\usage{
ppi(N, dir = tempdir(), quiet = TRUE, shell = FALSE, ...)
}
\arguments{
\item{N}{A postive integer > 2}

\item{dir}{Directory to place the files in, without an ending /}

\item{quiet}{If FALSE, messages the 4ti2 output}

\item{shell}{Messages the shell code used to do the computation}

\item{...}{Additional arguments to pass to the function}
}
\value{
A matrix containing the basis as its columns (for easy addition to
tables)
}
\description{
ppi runs 4ti2's ppi program to compute the primitive partition identities,
that is, the Graver basis of 1:N.
}
\examples{

if (has_4ti2()) {

ppi(3)
t(ppi(3)) \%*\% 1:3
plot_matrix(ppi(3))

graver(t(1:3))
plot_matrix(graver(t(1:3)))

ppi(5, quiet = FALSE, shell = TRUE)

}


}
\seealso{
\code{\link[=graver]{graver()}}
}
