// SPDX-FileCopyrightText: 2024 heersin <teablearcher@gmail.com>
// SPDX-License-Identifier: LGPL-3.0-only

const char *opnames[_RX_OP_COUNT] = {
	"invalid",
	"abs",
	"adc",
	"add",
	"add.UB",
	"and",
	"and.UB",
	"bclr",
	// bcnd.s, cnd provided by cond_names
	"b%s.S",
	"b%s.B",
	"b%s.W",
	"bm%s",
	"bnot",
	"bra.S",
	"bra.B",
	"bra.W",
	"bra.A",
	"bra.L",
	"brk",
	"bset",
	"bsr.W",
	"bsr.A",
	"bsr.L",
	"btst",
	"clrpsw",
	"cmp",
	"cmp.UB",
	"div",
	"div.UB",
	"divu",
	"divu.UB",
	"emul",
	"emul.UB",
	"emulu",
	"emulu.UB",
	"fadd",
	"fcmp",
	"fdiv",
	"fmul",
	"fsub",
	"ftoi",
	"int",
	"itof",
	"itof.UB",
	"jmp",
	"jsr",
	"machi",
	"maclo",
	"max",
	"max.UB",
	"min",
	"min.UB",
	"mov",
	"movu",
	"mul",
	"mul.UB",
	"mulhi",
	"mullo",
	"mvfachi",
	"mvfacmi",
	"mvfc",
	"mvtachi",
	"mvtaclo",
	"mvtc",
	"mvtipl",
	"neg",
	"nop",
	"not",
	"or",
	"or.UB",
	"pop",
	"popc",
	"popm",
	"push",
	"pushc",
	"pushm",
	"racw",
	"revl",
	"revw",
	"rmpa",
	"rolc",
	"rorc",
	"rotl",
	"rotr",
	"round",
	"rte",
	"rtfi",
	"rts",
	"rtsd",
	"sat",
	"satr",
	"sbb",
	"sc%s",
	"scmpu",
	"setpsw",
	"shar",
	"shll",
	"shlr",
	"smovb",
	"smovf",
	"smovu",
	"sstr",
	"stnz",
	"stz",
	"sub",
	"sub.UB",
	"suntil",
	"swhile",
	"tst",
	"tst.UB",
	"wait",
	"xchg",
	"xchg.UB",
	"xor",
	"xor.UB"
};

const char *extmark_names[_RX_EXT_COUNT] = {
	"B",
	"W",
	"L",
	"UW",
};

const char *reg_names[RX_REG_RESERVED] = {
	"r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7",
	"r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15",
	"isp", "usp", "intb", "pc",
	"psw", "bpc", "bpsw", "fintv",
	"fpsw", "acc"
};

const char *flag_names[7] = {
	"C",
	"Z",
	"S",
	"O",
	"I",
	"U",
	"",
};

const char *cond_names[RX_COND_RESERVED] = {
	"eq",
	"ne",
	"geu",
	"ltu",
	"gtu",
	"leu",
	"pz",
	"n",
	"ge",
	"lt",
	"gt",
	"le",
	"o",
	"no",
	"ra",
	"jump",
};

#define RxNameOp(op)     ((op) < _RX_OP_COUNT ? opnames[(op)] : "invalid")
#define RxNameExt(ext)   ((ext) < _RX_EXT_COUNT ? extmark_names[((ext)-RX_EXT_B)] : "invalid")
#define RxNameReg(reg)   ((reg) < RX_REG_RESERVED ? reg_names[(reg)-RX_REG_R0] : "invalid")
#define RxNameFlag(flag) ((flag) < 7 ? flag_names[(flag)] : "invalid")
#define RxNameCond(cond) ((cond) < RX_COND_RESERVED ? cond_names[(cond)] : "invalid")