from unittest import mock
from routersploit.modules.exploits.routers.cisco.rv320_command_injection import Exploit


@mock.patch("routersploit.modules.exploits.routers.cisco.rv320_command_injection.shell")
def test_check_success(mocked_shell, target):
    """ Test scenario - successful check """

    route_mock = target.get_route_mock("/cgi-bin/config.exp", methods=["GET"])
    route_mock.return_value = (
        "TEST\nsysconfig\nTEST"
    )

    exploit = Exploit()

    assert exploit.target == ""
    assert exploit.port == 443

    exploit.target = target.host
    exploit.port = target.port

    assert exploit.check()
    assert exploit.run() is None
