#[test]
fn random_colors() {
    // The color string is randomly generated, then parsed using Chrome 87.0 on Android
    let test_data = vec![
        ("#6946", [102, 153, 68, 102]),
        ("#4F0", [68, 255, 0, 255]),
        ("#75C57A", [117, 197, 122, 255]),
        ("#4E0A70", [78, 10, 112, 255]),
        ("#A195", [170, 17, 153, 85]),
        ("#4A4786", [74, 71, 134, 255]),
        ("#FC0", [255, 204, 0, 255]),
        ("#517FE4", [81, 127, 228, 255]),
        ("#1594A4", [21, 148, 164, 255]),
        ("#1B574A", [27, 87, 74, 255]),
        ("#9445D48C", [148, 69, 212, 140]),
        ("#BC9", [187, 204, 153, 255]),
        ("#9E3C6B", [158, 60, 107, 255]),
        ("#E92C2E5B", [233, 44, 46, 91]),
        ("#563B", [85, 102, 51, 187]),
        ("#FAD87DAA", [250, 216, 125, 170]),
        ("#B11", [187, 17, 17, 255]),
        ("#817B", [136, 17, 119, 187]),
        ("#2DD", [34, 221, 221, 255]),
        ("#7403B61A", [116, 3, 182, 26]),
        ("#02ABBC2F", [2, 171, 188, 47]),
        ("#B9A1D823", [185, 161, 216, 35]),
        ("#180", [17, 136, 0, 255]),
        ("#AB8D15A1", [171, 141, 21, 161]),
        ("#B701", [187, 119, 0, 17]),
        ("#6DEBD9", [109, 235, 217, 255]),
        ("#A09", [170, 0, 153, 255]),
        ("#84A2CB", [132, 162, 203, 255]),
        ("#361501", [54, 21, 1, 255]),
        ("#8F20", [136, 255, 34, 0]),
        ("#9EC963", [158, 201, 99, 255]),
        ("#B2B50F", [178, 181, 15, 255]),
        ("#B038", [187, 0, 51, 136]),
        ("#E769EB", [231, 105, 235, 255]),
        ("#C4A", [204, 68, 170, 255]),
        ("#9E5", [153, 238, 85, 255]),
        ("#FF0", [255, 255, 0, 255]),
        ("#6DF", [102, 221, 255, 255]),
        ("#A41", [170, 68, 17, 255]),
        ("#596F0B", [89, 111, 11, 255]),
        ("#1A6", [17, 170, 102, 255]),
        ("#BB9B0EA9", [187, 155, 14, 169]),
        ("#85A", [136, 85, 170, 255]),
        ("#938B", [153, 51, 136, 187]),
        ("#F89", [255, 136, 153, 255]),
        ("#447591", [68, 117, 145, 255]),
        ("#8CE6", [136, 204, 238, 102]),
        ("#E1528097", [225, 82, 128, 151]),
        ("#7BCE11", [123, 206, 17, 255]),
        ("#40AECEB7", [64, 174, 206, 183]),
        ("rgb(93.170,64.269,73.499)", [93, 64, 73, 255]),
        ("rgb(7.929,61.287,229.755,-0.172)", [8, 61, 230, 0]),
        ("rgb(59.947,234.441,231.856)", [60, 234, 232, 255]),
        ("rgb(40.839,233.232,263.280)", [41, 233, 255, 255]),
        ("rgb(146.043,242.067,228.262,1.148)", [146, 242, 228, 255]),
        ("rgb(40.800,31.415,141.897,0.721)", [41, 31, 142, 184]),
        ("rgb(252.237,162.173,239.848,1.159)", [252, 162, 240, 255]),
        ("rgb(187.805,86.185,253.946,1.088)", [188, 86, 254, 255]),
        ("rgb(20.891,82.288,149.768)", [21, 82, 150, 255]),
        ("rgb(132.275,143.495,131.475)", [132, 143, 131, 255]),
        ("rgb(106.238,145.684,129.067)", [106, 146, 129, 255]),
        ("rgb(6.092,125.387,194.562,0.176)", [6, 125, 195, 45]),
        ("rgb(215.571,177.198,41.277)", [216, 177, 41, 255]),
        ("rgb(226.868,90.077,42.413,0.458)", [227, 90, 42, 117]),
        ("rgb(79.828,63.604,4.446,-0.071)", [80, 64, 4, 0]),
        ("rgb(182.752,129.166,77.250,0.955)", [183, 129, 77, 244]),
        ("rgb(214.852,23.610,245.474)", [215, 24, 245, 255]),
        ("rgb(132.858,192.196,34.316)", [133, 192, 34, 255]),
        ("rgb(222.322,136.431,72.692)", [222, 136, 73, 255]),
        ("rgb(263.504,94.097,7.834)", [255, 94, 8, 255]),
        ("rgb(254.248,34.996,26.785)", [254, 35, 27, 255]),
        ("rgb(154.676,75.369,247.392)", [155, 75, 247, 255]),
        ("rgb(98.048,245.136,84.628)", [98, 245, 85, 255]),
        ("rgb(257.612,4.746,247.485,0.894)", [255, 5, 247, 228]),
        ("rgb(108.478,219.046,146.111)", [108, 219, 146, 255]),
        ("rgb(87.414,185.873,26.154,0.536)", [87, 186, 26, 137]),
        ("rgb(91.980,117.789,56.497)", [92, 118, 56, 255]),
        ("rgb(134.494,228.709,63.294,0.649)", [134, 229, 63, 165]),
        ("rgb(44.674,131.163,35.602)", [45, 131, 36, 255]),
        ("rgb(127.390,73.029,27.948,0.963)", [127, 73, 28, 246]),
        ("rgb(187.426,125.312,219.397)", [187, 125, 219, 255]),
        ("rgb(254.713,264.153,258.329)", [255, 255, 255, 255]),
        ("rgb(244.510,207.326,178.902,0.339)", [245, 207, 179, 86]),
        ("rgb(26.199,-9.612,231.652,0.662)", [26, 0, 232, 169]),
        ("rgb(45.304,89.336,172.582)", [45, 89, 173, 255]),
        ("rgb(191.387,107.530,36.480)", [191, 108, 36, 255]),
        ("rgb(100.149,52.445,27.521,0.677)", [100, 52, 28, 173]),
        ("rgb(51.050,84.982,166.808)", [51, 85, 167, 255]),
        ("rgb(37.221,239.178,59.749)", [37, 239, 60, 255]),
        ("rgb(92.024,78.623,56.212,0.765)", [92, 79, 56, 195]),
        ("rgb(61.206,222.657,-6.863,0.526)", [61, 223, 0, 134]),
        ("rgb(233.507,205.865,171.023,0.637)", [234, 206, 171, 162]),
        ("rgb(135.288,90.821,193.045)", [135, 91, 193, 255]),
        ("rgb(18.590,144.907,124.470)", [19, 145, 124, 255]),
        ("rgb(241.835,158.227,224.189)", [242, 158, 224, 255]),
        ("rgb(184.917,157.120,206.682,0.283)", [185, 157, 207, 72]),
        ("rgb(185.019,101.395,60.572)", [185, 101, 61, 255]),
        ("rgb(67.718,1.945,198.884)", [68, 2, 199, 255]),
        ("rgb(129.479,142.689,149.387,0.186)", [129, 143, 149, 47]),
        ("rgb(253.673,-2.343,196.555,-0.144)", [254, 0, 197, 0]),
        ("rgb(98.168%,7.203%,51.225%)", [250, 18, 131, 255]),
        ("rgb(96.170%,77.147%,85.996%)", [245, 197, 219, 255]),
        ("rgb(44.834%,53.204%,-9.634%,0.188)", [114, 136, 0, 48]),
        ("rgb(-7.920%,77.363%,-5.832%)", [0, 197, 0, 255]),
        ("rgb(81.003%,65.363%,-9.457%)", [207, 167, 0, 255]),
        ("rgb(85.894%,7.216%,-7.468%)", [219, 18, 0, 255]),
        ("rgb(100.659%,-3.397%,-0.802%,0.330)", [255, 0, 0, 84]),
        ("rgb(32.614%,63.257%,55.861%,-0.179)", [83, 161, 142, 0]),
        ("rgb(17.267%,78.342%,106.706%)", [44, 200, 255, 255]),
        ("rgb(-2.465%,70.281%,64.300%)", [0, 179, 164, 255]),
        ("rgb(74.917%,92.472%,35.277%)", [191, 236, 90, 255]),
        ("rgb(25.250%,103.119%,9.820%,1.073)", [64, 255, 25, 255]),
        ("rgb(16.308%,73.992%,41.494%)", [42, 189, 106, 255]),
        ("rgb(33.416%,64.317%,2.900%)", [85, 164, 7, 255]),
        ("rgb(86.321%,-7.134%,95.066%,0.407)", [220, 0, 242, 104]),
        ("rgb(72.337%,85.660%,37.990%)", [184, 218, 97, 255]),
        ("rgb(60.830%,102.371%,64.532%)", [155, 255, 165, 255]),
        ("rgb(22.944%,45.301%,57.417%,0.233)", [59, 116, 146, 59]),
        ("rgb(-8.796%,77.305%,55.175%)", [0, 197, 141, 255]),
        ("rgb(62.273%,88.630%,40.361%,-0.133)", [159, 226, 103, 0]),
        ("rgb(9.002%,9.048%,55.050%)", [23, 23, 140, 255]),
        ("rgb(39.705%,64.215%,33.386%)", [101, 164, 85, 255]),
        ("rgb(79.062%,9.806%,-0.228%)", [202, 25, 0, 255]),
        ("rgb(12.557%,26.742%,81.062%,0.187)", [32, 68, 207, 48]),
        ("rgb(48.037%,44.658%,94.883%,0.104)", [122, 114, 242, 27]),
        ("rgb(70.643%,18.209%,5.847%)", [180, 46, 15, 255]),
        ("rgb(17.439%,107.090%,-4.975%,0.301)", [44, 255, 0, 77]),
        ("rgb(36.867%,63.947%,53.503%)", [94, 163, 136, 255]),
        ("rgb(58.049%,108.306%,41.125%,-0.083)", [148, 255, 105, 0]),
        ("rgb(53.613%,-2.382%,20.660%,0.375)", [137, 0, 53, 96]),
        ("rgb(17.281%,0.850%,86.809%)", [44, 2, 221, 255]),
        ("rgb(28.877%,108.291%,22.159%,0.048)", [74, 255, 57, 12]),
        ("rgb(67.469%,33.982%,29.863%)", [172, 87, 76, 255]),
        ("rgb(12.841%,42.108%,77.364%)", [33, 107, 197, 255]),
        ("rgb(-6.254%,104.573%,54.338%,0.326)", [0, 255, 139, 83]),
        ("rgb(23.335%,-7.262%,32.061%)", [60, 0, 82, 255]),
        ("rgb(33.559%,104.368%,82.602%)", [86, 255, 211, 255]),
        ("rgb(51.030%,84.331%,22.085%)", [130, 215, 56, 255]),
        ("rgb(-7.688%,-0.346%,109.870%,0.492)", [0, 0, 255, 125]),
        ("rgb(37.791%,66.140%,-2.511%)", [96, 169, 0, 255]),
        ("rgb(14.877%,-9.937%,98.026%,0.391)", [38, 0, 250, 100]),
        ("rgb(68.965%,54.114%,79.671%,0.786)", [176, 138, 203, 200]),
        ("rgb(32.699%,84.074%,12.438%)", [83, 214, 32, 255]),
        ("rgb(61.109%,37.962%,9.726%)", [156, 97, 25, 255]),
        ("rgb(50.551%,21.936%,91.162%,0.379)", [129, 56, 232, 97]),
        ("rgb(12.006%,50.391%,84.702%)", [31, 128, 216, 255]),
        ("rgb(58.866%,36.294%,44.703%)", [150, 93, 114, 255]),
        ("rgb(73.712%,35.422%,91.533%)", [188, 90, 233, 255]),
        ("rgb(35.268%,82.428%,99.633%)", [90, 210, 254, 255]),
        ("rgb(77.313%,92.131%,3.558%)", [197, 235, 9, 255]),
        ("hsl(191.596grad,43.986%,97.620%)", [246, 252, 251, 255]),
        ("hsl(79.060deg,8.776%,101.675%)", [255, 255, 255, 255]),
        (
            "hsl(218.222deg,30.111%,58.967%,0.650)",
            [119, 142, 182, 166],
        ),
        ("hsl(-0.032turn,90.086%,72.510%)", [248, 122, 146, 255]),
        ("hsl(21.358deg,34.513%,70.780%)", [206, 173, 155, 255]),
        ("hsl(248.704deg,41.071%,94.868%,-0.194)", [238, 237, 247, 0]),
        ("hsl(0.315turn,88.238%,77.402%,0.394)", [158, 248, 147, 100]),
        ("hsl(1.126rad,23.412%,92.759%)", [240, 241, 232, 255]),
        ("hsl(221.926,39.531%,81.028%)", [187, 199, 226, 255]),
        ("hsl(275.876deg,77.777%,21.408%)", [63, 12, 97, 255]),
        ("hsl(0.223turn,6.827%,45.074%)", [117, 123, 107, 255]),
        ("hsl(88.794deg,91.390%,9.152%)", [24, 45, 2, 255]),
        ("hsl(322.793grad,7.388%,26.361%,0.283)", [71, 62, 72, 72]),
        ("hsl(320.912grad,89.287%,50.117%)", [199, 14, 241, 255]),
        ("hsl(89.001grad,-6.397%,14.927%)", [38, 38, 38, 255]),
        ("hsl(0.315turn,61.008%,39.837%)", [53, 164, 40, 255]),
        ("hsl(3.187rad,10.620%,1.837%,0.852)", [4, 5, 5, 217]),
        ("hsl(15.726,68.485%,92.900%,0.955)", [249, 231, 224, 244]),
        ("hsl(288.124deg,102.249%,26.487%)", [108, 0, 135, 255]),
        (
            "hsl(66.360deg,17.120%,104.832%,0.867)",
            [255, 255, 255, 221],
        ),
        ("hsl(199.194deg,105.374%,33.202%)", [0, 115, 169, 255]),
        ("hsl(337.002grad,71.223%,56.730%)", [223, 66, 215, 255]),
        ("hsl(359.117,89.688%,25.416%,0.329)", [123, 7, 8, 84]),
        ("hsl(0.210rad,50.484%,31.972%)", [123, 57, 40, 255]),
        ("hsl(-3.642,101.576%,101.667%)", [255, 255, 255, 255]),
        ("hsl(0.904turn,97.186%,99.315%)", [255, 252, 254, 255]),
        ("hsl(0.123turn,64.031%,76.579%)", [234, 213, 157, 255]),
        ("hsl(165.918grad,2.876%,-4.821%,-0.128)", [0, 0, 0, 0]),
        ("hsl(47.128grad,86.109%,42.237%)", [200, 146, 15, 255]),
        ("hsl(357.805,66.392%,90.933%,0.084)", [247, 217, 218, 21]),
        ("hsl(59.582deg,72.571%,70.685%)", [234, 234, 126, 255]),
        ("hsl(219.957grad,88.355%,34.566%)", [10, 119, 166, 255]),
        ("hsl(184.649,78.952%,88.831%,0.234)", [204, 246, 249, 60]),
        ("hsl(243.323,11.432%,-6.552%)", [0, 0, 0, 255]),
        ("hsl(2.873rad,97.021%,7.421%)", [1, 37, 28, 255]),
        ("hsl(-5.237grad,32.508%,7.772%,0.700)", [26, 13, 14, 179]),
        ("hsl(0.065turn,74.685%,70.874%,-0.026)", [236, 169, 125, 0]),
        ("hsl(209.534grad,-3.497%,28.848%)", [74, 74, 74, 255]),
        ("hsl(120.884,48.350%,6.898%)", [9, 26, 9, 255]),
        ("hsl(327.151grad,8.405%,32.912%)", [90, 77, 91, 255]),
        ("hsl(3.470rad,38.504%,41.877%)", [66, 122, 148, 255]),
        ("hsl(5.489rad,88.555%,44.840%,0.832)", [216, 13, 167, 212]),
        ("hsl(0.295turn,34.256%,11.399%)", [24, 39, 19, 255]),
        (
            "hsl(70.479deg,86.200%,102.072%,0.789)",
            [255, 255, 255, 201],
        ),
        ("hsl(77.957grad,53.345%,16.670%)", [58, 65, 20, 255]),
        ("hsl(5.562rad,11.968%,109.436%)", [255, 255, 255, 255]),
        ("hsl(404.677grad,103.003%,9.650%)", [49, 3, 0, 255]),
        ("hsl(2.715rad,89.884%,15.064%,-0.083)", [4, 73, 45, 0]),
        ("hsl(235.834,104.274%,12.569%)", [0, 4, 64, 255]),
        ("hsl(5.068rad,5.213%,83.391%)", [214, 210, 215, 255]),
    ];
    for (s, expected) in test_data {
        let rgba = csscolorparser::parse(s).unwrap().to_rgba8();
        assert_eq!(expected, rgba);
    }
}
