/* 
 * tclStubs.c --
 *
 *	This file contains the wrapper functions for the platform independent
 *	public Tcl API.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclStubs.c,v 1.2 1999/04/19 18:29:42 aku Exp $
 */

#include "tcl.h"

/*
 * Undefine function macros that will interfere with the defintions below.
 */

#undef Tcl_Alloc
#undef Tcl_Free
#undef Tcl_Realloc
#undef Tcl_NewBooleanObj
#undef Tcl_NewByteArrayObj
#undef Tcl_NewDoubleObj
#undef Tcl_NewIntObj
#undef Tcl_NewListObj
#undef Tcl_NewLongObj
#undef Tcl_NewObj
#undef Tcl_NewStringObj
#undef Tcl_InitMemory
#undef Tcl_DumpActiveMemory
#undef Tcl_ValidateAllMemory
#undef Tcl_EvalObj
#undef Tcl_GlobalEvalObj
#undef Tcl_MutexLock
#undef Tcl_MutexUnlock
#undef Tcl_ConditionNotify
#undef Tcl_ConditionWait

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tcl.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported stub functions:
 */

/* Slot 0 */
int
Tcl_PkgProvideEx(interp, name, version, clientData)
    Tcl_Interp * interp;
    char * name;
    char * version;
    ClientData clientData;
{
    return (tclStubsPtr->tcl_PkgProvideEx)(interp, name, version, clientData);
}

/* Slot 1 */
char *
Tcl_PkgRequireEx(interp, name, version, exact, clientDataPtr)
    Tcl_Interp * interp;
    char * name;
    char * version;
    int exact;
    ClientData * clientDataPtr;
{
    return (tclStubsPtr->tcl_PkgRequireEx)(interp, name, version, exact, clientDataPtr);
}

/* Slot 2 */
void
Tcl_Panic TCL_VARARGS_DEF(char *,format)
{
    char * var;
    va_list argList;

    var = (char *) TCL_VARARGS_START(char *,format,argList);

    (tclStubsPtr->tcl_PanicVA)(var, argList);
    va_end(argList);
}

/* Slot 3 */
char *
Tcl_Alloc(size)
    unsigned int size;
{
    return (tclStubsPtr->tcl_Alloc)(size);
}

/* Slot 4 */
void
Tcl_Free(ptr)
    char * ptr;
{
    (tclStubsPtr->tcl_Free)(ptr);
}

/* Slot 5 */
char *
Tcl_Realloc(ptr, size)
    char * ptr;
    unsigned int size;
{
    return (tclStubsPtr->tcl_Realloc)(ptr, size);
}

/* Slot 6 */
char *
Tcl_DbCkalloc(size, file, line)
    unsigned int size;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbCkalloc)(size, file, line);
}

/* Slot 7 */
int
Tcl_DbCkfree(ptr, file, line)
    char * ptr;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbCkfree)(ptr, file, line);
}

/* Slot 8 */
char *
Tcl_DbCkrealloc(ptr, size, file, line)
    char * ptr;
    unsigned int size;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbCkrealloc)(ptr, size, file, line);
}

#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
/* Slot 9 */
void
Tcl_CreateFileHandler(fd, mask, proc, clientData)
    int fd;
    int mask;
    Tcl_FileProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CreateFileHandler)(fd, mask, proc, clientData);
}

#endif /* UNIX */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
/* Slot 10 */
void
Tcl_DeleteFileHandler(fd)
    int fd;
{
    (tclStubsPtr->tcl_DeleteFileHandler)(fd);
}

#endif /* UNIX */
/* Slot 11 */
void
Tcl_SetTimer(timePtr)
    Tcl_Time * timePtr;
{
    (tclStubsPtr->tcl_SetTimer)(timePtr);
}

/* Slot 12 */
void
Tcl_Sleep(ms)
    int ms;
{
    (tclStubsPtr->tcl_Sleep)(ms);
}

/* Slot 13 */
int
Tcl_WaitForEvent(timePtr)
    Tcl_Time * timePtr;
{
    return (tclStubsPtr->tcl_WaitForEvent)(timePtr);
}

/* Slot 14 */
int
Tcl_AppendAllObjTypes(interp, objPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_AppendAllObjTypes)(interp, objPtr);
}

/* Slot 15 */
void
Tcl_AppendStringsToObj TCL_VARARGS_DEF(Tcl_Obj *,objPtr)
{
    Tcl_Obj * var;
    va_list argList;

    var = (Tcl_Obj *) TCL_VARARGS_START(Tcl_Obj *,objPtr,argList);

    (tclStubsPtr->tcl_AppendStringsToObjVA)(var, argList);
    va_end(argList);
}

/* Slot 16 */
void
Tcl_AppendToObj(objPtr, bytes, length)
    Tcl_Obj * objPtr;
    char * bytes;
    int length;
{
    (tclStubsPtr->tcl_AppendToObj)(objPtr, bytes, length);
}

/* Slot 17 */
Tcl_Obj *
Tcl_ConcatObj(objc, objv)
    int objc;
    Tcl_Obj *CONST objv[];
{
    return (tclStubsPtr->tcl_ConcatObj)(objc, objv);
}

/* Slot 18 */
int
Tcl_ConvertToType(interp, objPtr, typePtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    Tcl_ObjType * typePtr;
{
    return (tclStubsPtr->tcl_ConvertToType)(interp, objPtr, typePtr);
}

/* Slot 19 */
void
Tcl_DbDecrRefCount(objPtr, file, line)
    Tcl_Obj * objPtr;
    char * file;
    int line;
{
    (tclStubsPtr->tcl_DbDecrRefCount)(objPtr, file, line);
}

/* Slot 20 */
void
Tcl_DbIncrRefCount(objPtr, file, line)
    Tcl_Obj * objPtr;
    char * file;
    int line;
{
    (tclStubsPtr->tcl_DbIncrRefCount)(objPtr, file, line);
}

/* Slot 21 */
int
Tcl_DbIsShared(objPtr, file, line)
    Tcl_Obj * objPtr;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbIsShared)(objPtr, file, line);
}

/* Slot 22 */
Tcl_Obj *
Tcl_DbNewBooleanObj(boolValue, file, line)
    int boolValue;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbNewBooleanObj)(boolValue, file, line);
}

/* Slot 23 */
Tcl_Obj *
Tcl_DbNewByteArrayObj(bytes, length, file, line)
    unsigned char * bytes;
    int length;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbNewByteArrayObj)(bytes, length, file, line);
}

/* Slot 24 */
Tcl_Obj *
Tcl_DbNewDoubleObj(doubleValue, file, line)
    double doubleValue;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbNewDoubleObj)(doubleValue, file, line);
}

/* Slot 25 */
Tcl_Obj *
Tcl_DbNewListObj(objc, objv, file, line)
    int objc;
    Tcl_Obj *CONST objv[];
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbNewListObj)(objc, objv, file, line);
}

/* Slot 26 */
Tcl_Obj *
Tcl_DbNewLongObj(longValue, file, line)
    long longValue;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbNewLongObj)(longValue, file, line);
}

/* Slot 27 */
Tcl_Obj *
Tcl_DbNewObj(file, line)
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbNewObj)(file, line);
}

/* Slot 28 */
Tcl_Obj *
Tcl_DbNewStringObj(bytes, length, file, line)
    CONST char * bytes;
    int length;
    char * file;
    int line;
{
    return (tclStubsPtr->tcl_DbNewStringObj)(bytes, length, file, line);
}

/* Slot 29 */
Tcl_Obj *
Tcl_DuplicateObj(objPtr)
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_DuplicateObj)(objPtr);
}

/* Slot 30 */
void
TclFreeObj(objPtr)
    Tcl_Obj * objPtr;
{
    (tclStubsPtr->tclFreeObj)(objPtr);
}

/* Slot 31 */
int
Tcl_GetBoolean(interp, str, boolPtr)
    Tcl_Interp * interp;
    char * str;
    int * boolPtr;
{
    return (tclStubsPtr->tcl_GetBoolean)(interp, str, boolPtr);
}

/* Slot 32 */
int
Tcl_GetBooleanFromObj(interp, objPtr, boolPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    int * boolPtr;
{
    return (tclStubsPtr->tcl_GetBooleanFromObj)(interp, objPtr, boolPtr);
}

/* Slot 33 */
unsigned char *
Tcl_GetByteArrayFromObj(objPtr, lengthPtr)
    Tcl_Obj * objPtr;
    int * lengthPtr;
{
    return (tclStubsPtr->tcl_GetByteArrayFromObj)(objPtr, lengthPtr);
}

/* Slot 34 */
int
Tcl_GetDouble(interp, str, doublePtr)
    Tcl_Interp * interp;
    char * str;
    double * doublePtr;
{
    return (tclStubsPtr->tcl_GetDouble)(interp, str, doublePtr);
}

/* Slot 35 */
int
Tcl_GetDoubleFromObj(interp, objPtr, doublePtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    double * doublePtr;
{
    return (tclStubsPtr->tcl_GetDoubleFromObj)(interp, objPtr, doublePtr);
}

/* Slot 36 */
int
Tcl_GetIndexFromObj(interp, objPtr, tablePtr, msg, flags, indexPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    char ** tablePtr;
    char * msg;
    int flags;
    int * indexPtr;
{
    return (tclStubsPtr->tcl_GetIndexFromObj)(interp, objPtr, tablePtr, msg, flags, indexPtr);
}

/* Slot 37 */
int
Tcl_GetInt(interp, str, intPtr)
    Tcl_Interp * interp;
    char * str;
    int * intPtr;
{
    return (tclStubsPtr->tcl_GetInt)(interp, str, intPtr);
}

/* Slot 38 */
int
Tcl_GetIntFromObj(interp, objPtr, intPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    int * intPtr;
{
    return (tclStubsPtr->tcl_GetIntFromObj)(interp, objPtr, intPtr);
}

/* Slot 39 */
int
Tcl_GetLongFromObj(interp, objPtr, longPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    long * longPtr;
{
    return (tclStubsPtr->tcl_GetLongFromObj)(interp, objPtr, longPtr);
}

/* Slot 40 */
Tcl_ObjType *
Tcl_GetObjType(typeName)
    char * typeName;
{
    return (tclStubsPtr->tcl_GetObjType)(typeName);
}

/* Slot 41 */
char *
Tcl_GetStringFromObj(objPtr, lengthPtr)
    Tcl_Obj * objPtr;
    int * lengthPtr;
{
    return (tclStubsPtr->tcl_GetStringFromObj)(objPtr, lengthPtr);
}

/* Slot 42 */
void
Tcl_InvalidateStringRep(objPtr)
    Tcl_Obj * objPtr;
{
    (tclStubsPtr->tcl_InvalidateStringRep)(objPtr);
}

/* Slot 43 */
int
Tcl_ListObjAppendList(interp, listPtr, elemListPtr)
    Tcl_Interp * interp;
    Tcl_Obj * listPtr;
    Tcl_Obj * elemListPtr;
{
    return (tclStubsPtr->tcl_ListObjAppendList)(interp, listPtr, elemListPtr);
}

/* Slot 44 */
int
Tcl_ListObjAppendElement(interp, listPtr, objPtr)
    Tcl_Interp * interp;
    Tcl_Obj * listPtr;
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_ListObjAppendElement)(interp, listPtr, objPtr);
}

/* Slot 45 */
int
Tcl_ListObjGetElements(interp, listPtr, objcPtr, objvPtr)
    Tcl_Interp * interp;
    Tcl_Obj * listPtr;
    int * objcPtr;
    Tcl_Obj *** objvPtr;
{
    return (tclStubsPtr->tcl_ListObjGetElements)(interp, listPtr, objcPtr, objvPtr);
}

/* Slot 46 */
int
Tcl_ListObjIndex(interp, listPtr, index, objPtrPtr)
    Tcl_Interp * interp;
    Tcl_Obj * listPtr;
    int index;
    Tcl_Obj ** objPtrPtr;
{
    return (tclStubsPtr->tcl_ListObjIndex)(interp, listPtr, index, objPtrPtr);
}

/* Slot 47 */
int
Tcl_ListObjLength(interp, listPtr, intPtr)
    Tcl_Interp * interp;
    Tcl_Obj * listPtr;
    int * intPtr;
{
    return (tclStubsPtr->tcl_ListObjLength)(interp, listPtr, intPtr);
}

/* Slot 48 */
int
Tcl_ListObjReplace(interp, listPtr, first, count, objc, objv)
    Tcl_Interp * interp;
    Tcl_Obj * listPtr;
    int first;
    int count;
    int objc;
    Tcl_Obj *CONST objv[];
{
    return (tclStubsPtr->tcl_ListObjReplace)(interp, listPtr, first, count, objc, objv);
}

/* Slot 49 */
Tcl_Obj *
Tcl_NewBooleanObj(boolValue)
    int boolValue;
{
    return (tclStubsPtr->tcl_NewBooleanObj)(boolValue);
}

/* Slot 50 */
Tcl_Obj *
Tcl_NewByteArrayObj(bytes, length)
    unsigned char * bytes;
    int length;
{
    return (tclStubsPtr->tcl_NewByteArrayObj)(bytes, length);
}

/* Slot 51 */
Tcl_Obj *
Tcl_NewDoubleObj(doubleValue)
    double doubleValue;
{
    return (tclStubsPtr->tcl_NewDoubleObj)(doubleValue);
}

/* Slot 52 */
Tcl_Obj *
Tcl_NewIntObj(intValue)
    int intValue;
{
    return (tclStubsPtr->tcl_NewIntObj)(intValue);
}

/* Slot 53 */
Tcl_Obj *
Tcl_NewListObj(objc, objv)
    int objc;
    Tcl_Obj *CONST objv[];
{
    return (tclStubsPtr->tcl_NewListObj)(objc, objv);
}

/* Slot 54 */
Tcl_Obj *
Tcl_NewLongObj(longValue)
    long longValue;
{
    return (tclStubsPtr->tcl_NewLongObj)(longValue);
}

/* Slot 55 */
Tcl_Obj *
Tcl_NewObj()
{
    return (tclStubsPtr->tcl_NewObj)();
}

/* Slot 56 */
Tcl_Obj *
Tcl_NewStringObj(bytes, length)
    CONST char * bytes;
    int length;
{
    return (tclStubsPtr->tcl_NewStringObj)(bytes, length);
}

/* Slot 57 */
void
Tcl_SetBooleanObj(objPtr, boolValue)
    Tcl_Obj * objPtr;
    int boolValue;
{
    (tclStubsPtr->tcl_SetBooleanObj)(objPtr, boolValue);
}

/* Slot 58 */
unsigned char *
Tcl_SetByteArrayLength(objPtr, length)
    Tcl_Obj * objPtr;
    int length;
{
    return (tclStubsPtr->tcl_SetByteArrayLength)(objPtr, length);
}

/* Slot 59 */
void
Tcl_SetByteArrayObj(objPtr, bytes, length)
    Tcl_Obj * objPtr;
    unsigned char * bytes;
    int length;
{
    (tclStubsPtr->tcl_SetByteArrayObj)(objPtr, bytes, length);
}

/* Slot 60 */
void
Tcl_SetDoubleObj(objPtr, doubleValue)
    Tcl_Obj * objPtr;
    double doubleValue;
{
    (tclStubsPtr->tcl_SetDoubleObj)(objPtr, doubleValue);
}

/* Slot 61 */
void
Tcl_SetIntObj(objPtr, intValue)
    Tcl_Obj * objPtr;
    int intValue;
{
    (tclStubsPtr->tcl_SetIntObj)(objPtr, intValue);
}

/* Slot 62 */
void
Tcl_SetListObj(objPtr, objc, objv)
    Tcl_Obj * objPtr;
    int objc;
    Tcl_Obj *CONST objv[];
{
    (tclStubsPtr->tcl_SetListObj)(objPtr, objc, objv);
}

/* Slot 63 */
void
Tcl_SetLongObj(objPtr, longValue)
    Tcl_Obj * objPtr;
    long longValue;
{
    (tclStubsPtr->tcl_SetLongObj)(objPtr, longValue);
}

/* Slot 64 */
void
Tcl_SetObjLength(objPtr, length)
    Tcl_Obj * objPtr;
    int length;
{
    (tclStubsPtr->tcl_SetObjLength)(objPtr, length);
}

/* Slot 65 */
void
Tcl_SetStringObj(objPtr, bytes, length)
    Tcl_Obj * objPtr;
    char * bytes;
    int length;
{
    (tclStubsPtr->tcl_SetStringObj)(objPtr, bytes, length);
}

/* Slot 66 */
void
Tcl_AddErrorInfo(interp, message)
    Tcl_Interp * interp;
    CONST char * message;
{
    (tclStubsPtr->tcl_AddErrorInfo)(interp, message);
}

/* Slot 67 */
void
Tcl_AddObjErrorInfo(interp, message, length)
    Tcl_Interp * interp;
    CONST char * message;
    int length;
{
    (tclStubsPtr->tcl_AddObjErrorInfo)(interp, message, length);
}

/* Slot 68 */
void
Tcl_AllowExceptions(interp)
    Tcl_Interp * interp;
{
    (tclStubsPtr->tcl_AllowExceptions)(interp);
}

/* Slot 69 */
void
Tcl_AppendElement(interp, string)
    Tcl_Interp * interp;
    CONST char * string;
{
    (tclStubsPtr->tcl_AppendElement)(interp, string);
}

/* Slot 70 */
void
Tcl_AppendResult TCL_VARARGS_DEF(Tcl_Interp *,interp)
{
    Tcl_Interp * var;
    va_list argList;

    var = (Tcl_Interp *) TCL_VARARGS_START(Tcl_Interp *,interp,argList);

    (tclStubsPtr->tcl_AppendResultVA)(var, argList);
    va_end(argList);
}

/* Slot 71 */
Tcl_AsyncHandler
Tcl_AsyncCreate(proc, clientData)
    Tcl_AsyncProc * proc;
    ClientData clientData;
{
    return (tclStubsPtr->tcl_AsyncCreate)(proc, clientData);
}

/* Slot 72 */
void
Tcl_AsyncDelete(async)
    Tcl_AsyncHandler async;
{
    (tclStubsPtr->tcl_AsyncDelete)(async);
}

/* Slot 73 */
int
Tcl_AsyncInvoke(interp, code)
    Tcl_Interp * interp;
    int code;
{
    return (tclStubsPtr->tcl_AsyncInvoke)(interp, code);
}

/* Slot 74 */
void
Tcl_AsyncMark(async)
    Tcl_AsyncHandler async;
{
    (tclStubsPtr->tcl_AsyncMark)(async);
}

/* Slot 75 */
int
Tcl_AsyncReady()
{
    return (tclStubsPtr->tcl_AsyncReady)();
}

/* Slot 76 */
void
Tcl_BackgroundError(interp)
    Tcl_Interp * interp;
{
    (tclStubsPtr->tcl_BackgroundError)(interp);
}

/* Slot 77 */
char
Tcl_Backslash(src, readPtr)
    CONST char * src;
    int * readPtr;
{
    return (tclStubsPtr->tcl_Backslash)(src, readPtr);
}

/* Slot 78 */
int
Tcl_BadChannelOption(interp, optionName, optionList)
    Tcl_Interp * interp;
    char * optionName;
    char * optionList;
{
    return (tclStubsPtr->tcl_BadChannelOption)(interp, optionName, optionList);
}

/* Slot 79 */
void
Tcl_CallWhenDeleted(interp, proc, clientData)
    Tcl_Interp * interp;
    Tcl_InterpDeleteProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CallWhenDeleted)(interp, proc, clientData);
}

/* Slot 80 */
void
Tcl_CancelIdleCall(idleProc, clientData)
    Tcl_IdleProc * idleProc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CancelIdleCall)(idleProc, clientData);
}

/* Slot 81 */
int
Tcl_Close(interp, chan)
    Tcl_Interp * interp;
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_Close)(interp, chan);
}

/* Slot 82 */
int
Tcl_CommandComplete(cmd)
    char * cmd;
{
    return (tclStubsPtr->tcl_CommandComplete)(cmd);
}

/* Slot 83 */
char *
Tcl_Concat(argc, argv)
    int argc;
    char ** argv;
{
    return (tclStubsPtr->tcl_Concat)(argc, argv);
}

/* Slot 84 */
int
Tcl_ConvertElement(src, dst, flags)
    CONST char * src;
    char * dst;
    int flags;
{
    return (tclStubsPtr->tcl_ConvertElement)(src, dst, flags);
}

/* Slot 85 */
int
Tcl_ConvertCountedElement(src, length, dst, flags)
    CONST char * src;
    int length;
    char * dst;
    int flags;
{
    return (tclStubsPtr->tcl_ConvertCountedElement)(src, length, dst, flags);
}

/* Slot 86 */
int
Tcl_CreateAlias(slave, slaveCmd, target, targetCmd, argc, argv)
    Tcl_Interp * slave;
    char * slaveCmd;
    Tcl_Interp * target;
    char * targetCmd;
    int argc;
    char ** argv;
{
    return (tclStubsPtr->tcl_CreateAlias)(slave, slaveCmd, target, targetCmd, argc, argv);
}

/* Slot 87 */
int
Tcl_CreateAliasObj(slave, slaveCmd, target, targetCmd, objc, objv)
    Tcl_Interp * slave;
    char * slaveCmd;
    Tcl_Interp * target;
    char * targetCmd;
    int objc;
    Tcl_Obj *CONST objv[];
{
    return (tclStubsPtr->tcl_CreateAliasObj)(slave, slaveCmd, target, targetCmd, objc, objv);
}

/* Slot 88 */
Tcl_Channel
Tcl_CreateChannel(typePtr, chanName, instanceData, mask)
    Tcl_ChannelType * typePtr;
    char * chanName;
    ClientData instanceData;
    int mask;
{
    return (tclStubsPtr->tcl_CreateChannel)(typePtr, chanName, instanceData, mask);
}

/* Slot 89 */
void
Tcl_CreateChannelHandler(chan, mask, proc, clientData)
    Tcl_Channel chan;
    int mask;
    Tcl_ChannelProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CreateChannelHandler)(chan, mask, proc, clientData);
}

/* Slot 90 */
void
Tcl_CreateCloseHandler(chan, proc, clientData)
    Tcl_Channel chan;
    Tcl_CloseProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CreateCloseHandler)(chan, proc, clientData);
}

/* Slot 91 */
Tcl_Command
Tcl_CreateCommand(interp, cmdName, proc, clientData, deleteProc)
    Tcl_Interp * interp;
    char * cmdName;
    Tcl_CmdProc * proc;
    ClientData clientData;
    Tcl_CmdDeleteProc * deleteProc;
{
    return (tclStubsPtr->tcl_CreateCommand)(interp, cmdName, proc, clientData, deleteProc);
}

/* Slot 92 */
void
Tcl_CreateEventSource(setupProc, checkProc, clientData)
    Tcl_EventSetupProc * setupProc;
    Tcl_EventCheckProc * checkProc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CreateEventSource)(setupProc, checkProc, clientData);
}

/* Slot 93 */
void
Tcl_CreateExitHandler(proc, clientData)
    Tcl_ExitProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CreateExitHandler)(proc, clientData);
}

/* Slot 94 */
Tcl_Interp *
Tcl_CreateInterp()
{
    return (tclStubsPtr->tcl_CreateInterp)();
}

/* Slot 95 */
void
Tcl_CreateMathFunc(interp, name, numArgs, argTypes, proc, clientData)
    Tcl_Interp * interp;
    char * name;
    int numArgs;
    Tcl_ValueType * argTypes;
    Tcl_MathProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CreateMathFunc)(interp, name, numArgs, argTypes, proc, clientData);
}

/* Slot 96 */
Tcl_Command
Tcl_CreateObjCommand(interp, cmdName, proc, clientData, deleteProc)
    Tcl_Interp * interp;
    char * cmdName;
    Tcl_ObjCmdProc * proc;
    ClientData clientData;
    Tcl_CmdDeleteProc * deleteProc;
{
    return (tclStubsPtr->tcl_CreateObjCommand)(interp, cmdName, proc, clientData, deleteProc);
}

/* Slot 97 */
Tcl_Interp *
Tcl_CreateSlave(interp, slaveName, isSafe)
    Tcl_Interp * interp;
    char * slaveName;
    int isSafe;
{
    return (tclStubsPtr->tcl_CreateSlave)(interp, slaveName, isSafe);
}

/* Slot 98 */
Tcl_TimerToken
Tcl_CreateTimerHandler(milliseconds, proc, clientData)
    int milliseconds;
    Tcl_TimerProc * proc;
    ClientData clientData;
{
    return (tclStubsPtr->tcl_CreateTimerHandler)(milliseconds, proc, clientData);
}

/* Slot 99 */
Tcl_Trace
Tcl_CreateTrace(interp, level, proc, clientData)
    Tcl_Interp * interp;
    int level;
    Tcl_CmdTraceProc * proc;
    ClientData clientData;
{
    return (tclStubsPtr->tcl_CreateTrace)(interp, level, proc, clientData);
}

/* Slot 100 */
void
Tcl_DeleteAssocData(interp, name)
    Tcl_Interp * interp;
    char * name;
{
    (tclStubsPtr->tcl_DeleteAssocData)(interp, name);
}

/* Slot 101 */
void
Tcl_DeleteChannelHandler(chan, proc, clientData)
    Tcl_Channel chan;
    Tcl_ChannelProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DeleteChannelHandler)(chan, proc, clientData);
}

/* Slot 102 */
void
Tcl_DeleteCloseHandler(chan, proc, clientData)
    Tcl_Channel chan;
    Tcl_CloseProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DeleteCloseHandler)(chan, proc, clientData);
}

/* Slot 103 */
int
Tcl_DeleteCommand(interp, cmdName)
    Tcl_Interp * interp;
    char * cmdName;
{
    return (tclStubsPtr->tcl_DeleteCommand)(interp, cmdName);
}

/* Slot 104 */
int
Tcl_DeleteCommandFromToken(interp, command)
    Tcl_Interp * interp;
    Tcl_Command command;
{
    return (tclStubsPtr->tcl_DeleteCommandFromToken)(interp, command);
}

/* Slot 105 */
void
Tcl_DeleteEvents(proc, clientData)
    Tcl_EventDeleteProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DeleteEvents)(proc, clientData);
}

/* Slot 106 */
void
Tcl_DeleteEventSource(setupProc, checkProc, clientData)
    Tcl_EventSetupProc * setupProc;
    Tcl_EventCheckProc * checkProc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DeleteEventSource)(setupProc, checkProc, clientData);
}

/* Slot 107 */
void
Tcl_DeleteExitHandler(proc, clientData)
    Tcl_ExitProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DeleteExitHandler)(proc, clientData);
}

/* Slot 108 */
void
Tcl_DeleteHashEntry(entryPtr)
    Tcl_HashEntry * entryPtr;
{
    (tclStubsPtr->tcl_DeleteHashEntry)(entryPtr);
}

/* Slot 109 */
void
Tcl_DeleteHashTable(tablePtr)
    Tcl_HashTable * tablePtr;
{
    (tclStubsPtr->tcl_DeleteHashTable)(tablePtr);
}

/* Slot 110 */
void
Tcl_DeleteInterp(interp)
    Tcl_Interp * interp;
{
    (tclStubsPtr->tcl_DeleteInterp)(interp);
}

/* Slot 111 */
void
Tcl_DetachPids(numPids, pidPtr)
    int numPids;
    Tcl_Pid * pidPtr;
{
    (tclStubsPtr->tcl_DetachPids)(numPids, pidPtr);
}

/* Slot 112 */
void
Tcl_DeleteTimerHandler(token)
    Tcl_TimerToken token;
{
    (tclStubsPtr->tcl_DeleteTimerHandler)(token);
}

/* Slot 113 */
void
Tcl_DeleteTrace(interp, trace)
    Tcl_Interp * interp;
    Tcl_Trace trace;
{
    (tclStubsPtr->tcl_DeleteTrace)(interp, trace);
}

/* Slot 114 */
void
Tcl_DontCallWhenDeleted(interp, proc, clientData)
    Tcl_Interp * interp;
    Tcl_InterpDeleteProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DontCallWhenDeleted)(interp, proc, clientData);
}

/* Slot 115 */
int
Tcl_DoOneEvent(flags)
    int flags;
{
    return (tclStubsPtr->tcl_DoOneEvent)(flags);
}

/* Slot 116 */
void
Tcl_DoWhenIdle(proc, clientData)
    Tcl_IdleProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DoWhenIdle)(proc, clientData);
}

/* Slot 117 */
char *
Tcl_DStringAppend(dsPtr, str, length)
    Tcl_DString * dsPtr;
    CONST char * str;
    int length;
{
    return (tclStubsPtr->tcl_DStringAppend)(dsPtr, str, length);
}

/* Slot 118 */
char *
Tcl_DStringAppendElement(dsPtr, string)
    Tcl_DString * dsPtr;
    CONST char * string;
{
    return (tclStubsPtr->tcl_DStringAppendElement)(dsPtr, string);
}

/* Slot 119 */
void
Tcl_DStringEndSublist(dsPtr)
    Tcl_DString * dsPtr;
{
    (tclStubsPtr->tcl_DStringEndSublist)(dsPtr);
}

/* Slot 120 */
void
Tcl_DStringFree(dsPtr)
    Tcl_DString * dsPtr;
{
    (tclStubsPtr->tcl_DStringFree)(dsPtr);
}

/* Slot 121 */
void
Tcl_DStringGetResult(interp, dsPtr)
    Tcl_Interp * interp;
    Tcl_DString * dsPtr;
{
    (tclStubsPtr->tcl_DStringGetResult)(interp, dsPtr);
}

/* Slot 122 */
void
Tcl_DStringInit(dsPtr)
    Tcl_DString * dsPtr;
{
    (tclStubsPtr->tcl_DStringInit)(dsPtr);
}

/* Slot 123 */
void
Tcl_DStringResult(interp, dsPtr)
    Tcl_Interp * interp;
    Tcl_DString * dsPtr;
{
    (tclStubsPtr->tcl_DStringResult)(interp, dsPtr);
}

/* Slot 124 */
void
Tcl_DStringSetLength(dsPtr, length)
    Tcl_DString * dsPtr;
    int length;
{
    (tclStubsPtr->tcl_DStringSetLength)(dsPtr, length);
}

/* Slot 125 */
void
Tcl_DStringStartSublist(dsPtr)
    Tcl_DString * dsPtr;
{
    (tclStubsPtr->tcl_DStringStartSublist)(dsPtr);
}

/* Slot 126 */
int
Tcl_Eof(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_Eof)(chan);
}

/* Slot 127 */
char *
Tcl_ErrnoId()
{
    return (tclStubsPtr->tcl_ErrnoId)();
}

/* Slot 128 */
char *
Tcl_ErrnoMsg(err)
    int err;
{
    return (tclStubsPtr->tcl_ErrnoMsg)(err);
}

/* Slot 129 */
int
Tcl_Eval(interp, string)
    Tcl_Interp * interp;
    char * string;
{
    return (tclStubsPtr->tcl_Eval)(interp, string);
}

/* Slot 130 */
int
Tcl_EvalFile(interp, fileName)
    Tcl_Interp * interp;
    char * fileName;
{
    return (tclStubsPtr->tcl_EvalFile)(interp, fileName);
}

/* Slot 131 */
int
Tcl_EvalObj(interp, objPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_EvalObj)(interp, objPtr);
}

/* Slot 132 */
void
Tcl_EventuallyFree(clientData, freeProc)
    ClientData clientData;
    Tcl_FreeProc * freeProc;
{
    (tclStubsPtr->tcl_EventuallyFree)(clientData, freeProc);
}

/* Slot 133 */
void
Tcl_Exit(status)
    int status;
{
    (tclStubsPtr->tcl_Exit)(status);
}

/* Slot 134 */
int
Tcl_ExposeCommand(interp, hiddenCmdToken, cmdName)
    Tcl_Interp * interp;
    char * hiddenCmdToken;
    char * cmdName;
{
    return (tclStubsPtr->tcl_ExposeCommand)(interp, hiddenCmdToken, cmdName);
}

/* Slot 135 */
int
Tcl_ExprBoolean(interp, str, ptr)
    Tcl_Interp * interp;
    char * str;
    int * ptr;
{
    return (tclStubsPtr->tcl_ExprBoolean)(interp, str, ptr);
}

/* Slot 136 */
int
Tcl_ExprBooleanObj(interp, objPtr, ptr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    int * ptr;
{
    return (tclStubsPtr->tcl_ExprBooleanObj)(interp, objPtr, ptr);
}

/* Slot 137 */
int
Tcl_ExprDouble(interp, str, ptr)
    Tcl_Interp * interp;
    char * str;
    double * ptr;
{
    return (tclStubsPtr->tcl_ExprDouble)(interp, str, ptr);
}

/* Slot 138 */
int
Tcl_ExprDoubleObj(interp, objPtr, ptr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    double * ptr;
{
    return (tclStubsPtr->tcl_ExprDoubleObj)(interp, objPtr, ptr);
}

/* Slot 139 */
int
Tcl_ExprLong(interp, str, ptr)
    Tcl_Interp * interp;
    char * str;
    long * ptr;
{
    return (tclStubsPtr->tcl_ExprLong)(interp, str, ptr);
}

/* Slot 140 */
int
Tcl_ExprLongObj(interp, objPtr, ptr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    long * ptr;
{
    return (tclStubsPtr->tcl_ExprLongObj)(interp, objPtr, ptr);
}

/* Slot 141 */
int
Tcl_ExprObj(interp, objPtr, resultPtrPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    Tcl_Obj ** resultPtrPtr;
{
    return (tclStubsPtr->tcl_ExprObj)(interp, objPtr, resultPtrPtr);
}

/* Slot 142 */
int
Tcl_ExprString(interp, string)
    Tcl_Interp * interp;
    char * string;
{
    return (tclStubsPtr->tcl_ExprString)(interp, string);
}

/* Slot 143 */
void
Tcl_Finalize()
{
    (tclStubsPtr->tcl_Finalize)();
}

/* Slot 144 */
void
Tcl_FindExecutable(argv0)
    CONST char * argv0;
{
    (tclStubsPtr->tcl_FindExecutable)(argv0);
}

/* Slot 145 */
Tcl_HashEntry *
Tcl_FirstHashEntry(tablePtr, searchPtr)
    Tcl_HashTable * tablePtr;
    Tcl_HashSearch * searchPtr;
{
    return (tclStubsPtr->tcl_FirstHashEntry)(tablePtr, searchPtr);
}

/* Slot 146 */
int
Tcl_Flush(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_Flush)(chan);
}

/* Slot 147 */
void
Tcl_FreeResult(interp)
    Tcl_Interp * interp;
{
    (tclStubsPtr->tcl_FreeResult)(interp);
}

/* Slot 148 */
int
Tcl_GetAlias(interp, slaveCmd, targetInterpPtr, targetCmdPtr, argcPtr, argvPtr)
    Tcl_Interp * interp;
    char * slaveCmd;
    Tcl_Interp ** targetInterpPtr;
    char ** targetCmdPtr;
    int * argcPtr;
    char *** argvPtr;
{
    return (tclStubsPtr->tcl_GetAlias)(interp, slaveCmd, targetInterpPtr, targetCmdPtr, argcPtr, argvPtr);
}

/* Slot 149 */
int
Tcl_GetAliasObj(interp, slaveCmd, targetInterpPtr, targetCmdPtr, objcPtr, objv)
    Tcl_Interp * interp;
    char * slaveCmd;
    Tcl_Interp ** targetInterpPtr;
    char ** targetCmdPtr;
    int * objcPtr;
    Tcl_Obj *** objv;
{
    return (tclStubsPtr->tcl_GetAliasObj)(interp, slaveCmd, targetInterpPtr, targetCmdPtr, objcPtr, objv);
}

/* Slot 150 */
ClientData
Tcl_GetAssocData(interp, name, procPtr)
    Tcl_Interp * interp;
    char * name;
    Tcl_InterpDeleteProc ** procPtr;
{
    return (tclStubsPtr->tcl_GetAssocData)(interp, name, procPtr);
}

/* Slot 151 */
Tcl_Channel
Tcl_GetChannel(interp, chanName, modePtr)
    Tcl_Interp * interp;
    char * chanName;
    int * modePtr;
{
    return (tclStubsPtr->tcl_GetChannel)(interp, chanName, modePtr);
}

/* Slot 152 */
int
Tcl_GetChannelBufferSize(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_GetChannelBufferSize)(chan);
}

/* Slot 153 */
int
Tcl_GetChannelHandle(chan, direction, handlePtr)
    Tcl_Channel chan;
    int direction;
    ClientData * handlePtr;
{
    return (tclStubsPtr->tcl_GetChannelHandle)(chan, direction, handlePtr);
}

/* Slot 154 */
ClientData
Tcl_GetChannelInstanceData(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_GetChannelInstanceData)(chan);
}

/* Slot 155 */
int
Tcl_GetChannelMode(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_GetChannelMode)(chan);
}

/* Slot 156 */
char *
Tcl_GetChannelName(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_GetChannelName)(chan);
}

/* Slot 157 */
int
Tcl_GetChannelOption(interp, chan, optionName, dsPtr)
    Tcl_Interp * interp;
    Tcl_Channel chan;
    char * optionName;
    Tcl_DString * dsPtr;
{
    return (tclStubsPtr->tcl_GetChannelOption)(interp, chan, optionName, dsPtr);
}

/* Slot 158 */
Tcl_ChannelType *
Tcl_GetChannelType(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_GetChannelType)(chan);
}

/* Slot 159 */
int
Tcl_GetCommandInfo(interp, cmdName, infoPtr)
    Tcl_Interp * interp;
    char * cmdName;
    Tcl_CmdInfo * infoPtr;
{
    return (tclStubsPtr->tcl_GetCommandInfo)(interp, cmdName, infoPtr);
}

/* Slot 160 */
char *
Tcl_GetCommandName(interp, command)
    Tcl_Interp * interp;
    Tcl_Command command;
{
    return (tclStubsPtr->tcl_GetCommandName)(interp, command);
}

/* Slot 161 */
int
Tcl_GetErrno()
{
    return (tclStubsPtr->tcl_GetErrno)();
}

/* Slot 162 */
char *
Tcl_GetHostName()
{
    return (tclStubsPtr->tcl_GetHostName)();
}

/* Slot 163 */
int
Tcl_GetInterpPath(askInterp, slaveInterp)
    Tcl_Interp * askInterp;
    Tcl_Interp * slaveInterp;
{
    return (tclStubsPtr->tcl_GetInterpPath)(askInterp, slaveInterp);
}

/* Slot 164 */
Tcl_Interp *
Tcl_GetMaster(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_GetMaster)(interp);
}

/* Slot 165 */
CONST char *
Tcl_GetNameOfExecutable()
{
    return (tclStubsPtr->tcl_GetNameOfExecutable)();
}

/* Slot 166 */
Tcl_Obj *
Tcl_GetObjResult(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_GetObjResult)(interp);
}

#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
/* Slot 167 */
int
Tcl_GetOpenFile(interp, str, write, checkUsage, filePtr)
    Tcl_Interp * interp;
    char * str;
    int write;
    int checkUsage;
    ClientData * filePtr;
{
    return (tclStubsPtr->tcl_GetOpenFile)(interp, str, write, checkUsage, filePtr);
}

#endif /* UNIX */
/* Slot 168 */
Tcl_PathType
Tcl_GetPathType(path)
    char * path;
{
    return (tclStubsPtr->tcl_GetPathType)(path);
}

/* Slot 169 */
int
Tcl_Gets(chan, dsPtr)
    Tcl_Channel chan;
    Tcl_DString * dsPtr;
{
    return (tclStubsPtr->tcl_Gets)(chan, dsPtr);
}

/* Slot 170 */
int
Tcl_GetsObj(chan, objPtr)
    Tcl_Channel chan;
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_GetsObj)(chan, objPtr);
}

/* Slot 171 */
int
Tcl_GetServiceMode()
{
    return (tclStubsPtr->tcl_GetServiceMode)();
}

/* Slot 172 */
Tcl_Interp *
Tcl_GetSlave(interp, slaveName)
    Tcl_Interp * interp;
    char * slaveName;
{
    return (tclStubsPtr->tcl_GetSlave)(interp, slaveName);
}

/* Slot 173 */
Tcl_Channel
Tcl_GetStdChannel(type)
    int type;
{
    return (tclStubsPtr->tcl_GetStdChannel)(type);
}

/* Slot 174 */
char *
Tcl_GetStringResult(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_GetStringResult)(interp);
}

/* Slot 175 */
char *
Tcl_GetVar(interp, varName, flags)
    Tcl_Interp * interp;
    char * varName;
    int flags;
{
    return (tclStubsPtr->tcl_GetVar)(interp, varName, flags);
}

/* Slot 176 */
char *
Tcl_GetVar2(interp, part1, part2, flags)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    int flags;
{
    return (tclStubsPtr->tcl_GetVar2)(interp, part1, part2, flags);
}

/* Slot 177 */
int
Tcl_GlobalEval(interp, command)
    Tcl_Interp * interp;
    char * command;
{
    return (tclStubsPtr->tcl_GlobalEval)(interp, command);
}

/* Slot 178 */
int
Tcl_GlobalEvalObj(interp, objPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_GlobalEvalObj)(interp, objPtr);
}

/* Slot 179 */
int
Tcl_HideCommand(interp, cmdName, hiddenCmdToken)
    Tcl_Interp * interp;
    char * cmdName;
    char * hiddenCmdToken;
{
    return (tclStubsPtr->tcl_HideCommand)(interp, cmdName, hiddenCmdToken);
}

/* Slot 180 */
int
Tcl_Init(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_Init)(interp);
}

/* Slot 181 */
void
Tcl_InitHashTable(tablePtr, keyType)
    Tcl_HashTable * tablePtr;
    int keyType;
{
    (tclStubsPtr->tcl_InitHashTable)(tablePtr, keyType);
}

/* Slot 182 */
int
Tcl_InputBlocked(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_InputBlocked)(chan);
}

/* Slot 183 */
int
Tcl_InputBuffered(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_InputBuffered)(chan);
}

/* Slot 184 */
int
Tcl_InterpDeleted(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_InterpDeleted)(interp);
}

/* Slot 185 */
int
Tcl_IsSafe(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_IsSafe)(interp);
}

/* Slot 186 */
char *
Tcl_JoinPath(argc, argv, resultPtr)
    int argc;
    CONST char ** argv;
    Tcl_DString * resultPtr;
{
    return (tclStubsPtr->tcl_JoinPath)(argc, argv, resultPtr);
}

/* Slot 187 */
int
Tcl_LinkVar(interp, varName, addr, type)
    Tcl_Interp * interp;
    char * varName;
    char * addr;
    int type;
{
    return (tclStubsPtr->tcl_LinkVar)(interp, varName, addr, type);
}

/* Slot 188 is reserved */
/* Slot 189 */
Tcl_Channel
Tcl_MakeFileChannel(handle, mode)
    ClientData handle;
    int mode;
{
    return (tclStubsPtr->tcl_MakeFileChannel)(handle, mode);
}

/* Slot 190 */
int
Tcl_MakeSafe(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_MakeSafe)(interp);
}

/* Slot 191 */
Tcl_Channel
Tcl_MakeTcpClientChannel(tcpSocket)
    ClientData tcpSocket;
{
    return (tclStubsPtr->tcl_MakeTcpClientChannel)(tcpSocket);
}

/* Slot 192 */
char *
Tcl_Merge(argc, argv)
    int argc;
    char ** argv;
{
    return (tclStubsPtr->tcl_Merge)(argc, argv);
}

/* Slot 193 */
Tcl_HashEntry *
Tcl_NextHashEntry(searchPtr)
    Tcl_HashSearch * searchPtr;
{
    return (tclStubsPtr->tcl_NextHashEntry)(searchPtr);
}

/* Slot 194 */
void
Tcl_NotifyChannel(channel, mask)
    Tcl_Channel channel;
    int mask;
{
    (tclStubsPtr->tcl_NotifyChannel)(channel, mask);
}

/* Slot 195 */
Tcl_Obj *
Tcl_ObjGetVar2(interp, part1Ptr, part2Ptr, flags)
    Tcl_Interp * interp;
    Tcl_Obj * part1Ptr;
    Tcl_Obj * part2Ptr;
    int flags;
{
    return (tclStubsPtr->tcl_ObjGetVar2)(interp, part1Ptr, part2Ptr, flags);
}

/* Slot 196 */
Tcl_Obj *
Tcl_ObjSetVar2(interp, part1Ptr, part2Ptr, newValuePtr, flags)
    Tcl_Interp * interp;
    Tcl_Obj * part1Ptr;
    Tcl_Obj * part2Ptr;
    Tcl_Obj * newValuePtr;
    int flags;
{
    return (tclStubsPtr->tcl_ObjSetVar2)(interp, part1Ptr, part2Ptr, newValuePtr, flags);
}

/* Slot 197 */
Tcl_Channel
Tcl_OpenCommandChannel(interp, argc, argv, flags)
    Tcl_Interp * interp;
    int argc;
    char ** argv;
    int flags;
{
    return (tclStubsPtr->tcl_OpenCommandChannel)(interp, argc, argv, flags);
}

/* Slot 198 */
Tcl_Channel
Tcl_OpenFileChannel(interp, fileName, modeString, permissions)
    Tcl_Interp * interp;
    char * fileName;
    char * modeString;
    int permissions;
{
    return (tclStubsPtr->tcl_OpenFileChannel)(interp, fileName, modeString, permissions);
}

/* Slot 199 */
Tcl_Channel
Tcl_OpenTcpClient(interp, port, address, myaddr, myport, async)
    Tcl_Interp * interp;
    int port;
    char * address;
    char * myaddr;
    int myport;
    int async;
{
    return (tclStubsPtr->tcl_OpenTcpClient)(interp, port, address, myaddr, myport, async);
}

/* Slot 200 */
Tcl_Channel
Tcl_OpenTcpServer(interp, port, host, acceptProc, callbackData)
    Tcl_Interp * interp;
    int port;
    char * host;
    Tcl_TcpAcceptProc * acceptProc;
    ClientData callbackData;
{
    return (tclStubsPtr->tcl_OpenTcpServer)(interp, port, host, acceptProc, callbackData);
}

/* Slot 201 */
void
Tcl_Preserve(data)
    ClientData data;
{
    (tclStubsPtr->tcl_Preserve)(data);
}

/* Slot 202 */
void
Tcl_PrintDouble(interp, value, dst)
    Tcl_Interp * interp;
    double value;
    char * dst;
{
    (tclStubsPtr->tcl_PrintDouble)(interp, value, dst);
}

/* Slot 203 */
int
Tcl_PutEnv(string)
    CONST char * string;
{
    return (tclStubsPtr->tcl_PutEnv)(string);
}

/* Slot 204 */
char *
Tcl_PosixError(interp)
    Tcl_Interp * interp;
{
    return (tclStubsPtr->tcl_PosixError)(interp);
}

/* Slot 205 */
void
Tcl_QueueEvent(evPtr, position)
    Tcl_Event * evPtr;
    Tcl_QueuePosition position;
{
    (tclStubsPtr->tcl_QueueEvent)(evPtr, position);
}

/* Slot 206 */
int
Tcl_Read(chan, bufPtr, toRead)
    Tcl_Channel chan;
    char * bufPtr;
    int toRead;
{
    return (tclStubsPtr->tcl_Read)(chan, bufPtr, toRead);
}

/* Slot 207 */
void
Tcl_ReapDetachedProcs()
{
    (tclStubsPtr->tcl_ReapDetachedProcs)();
}

/* Slot 208 */
int
Tcl_RecordAndEval(interp, cmd, flags)
    Tcl_Interp * interp;
    char * cmd;
    int flags;
{
    return (tclStubsPtr->tcl_RecordAndEval)(interp, cmd, flags);
}

/* Slot 209 */
int
Tcl_RecordAndEvalObj(interp, cmdPtr, flags)
    Tcl_Interp * interp;
    Tcl_Obj * cmdPtr;
    int flags;
{
    return (tclStubsPtr->tcl_RecordAndEvalObj)(interp, cmdPtr, flags);
}

/* Slot 210 */
void
Tcl_RegisterChannel(interp, chan)
    Tcl_Interp * interp;
    Tcl_Channel chan;
{
    (tclStubsPtr->tcl_RegisterChannel)(interp, chan);
}

/* Slot 211 */
void
Tcl_RegisterObjType(typePtr)
    Tcl_ObjType * typePtr;
{
    (tclStubsPtr->tcl_RegisterObjType)(typePtr);
}

/* Slot 212 */
Tcl_RegExp
Tcl_RegExpCompile(interp, string)
    Tcl_Interp * interp;
    char * string;
{
    return (tclStubsPtr->tcl_RegExpCompile)(interp, string);
}

/* Slot 213 */
int
Tcl_RegExpExec(interp, regexp, str, start)
    Tcl_Interp * interp;
    Tcl_RegExp regexp;
    CONST char * str;
    CONST char * start;
{
    return (tclStubsPtr->tcl_RegExpExec)(interp, regexp, str, start);
}

/* Slot 214 */
int
Tcl_RegExpMatch(interp, str, pattern)
    Tcl_Interp * interp;
    char * str;
    char * pattern;
{
    return (tclStubsPtr->tcl_RegExpMatch)(interp, str, pattern);
}

/* Slot 215 */
void
Tcl_RegExpRange(regexp, index, startPtr, endPtr)
    Tcl_RegExp regexp;
    int index;
    char ** startPtr;
    char ** endPtr;
{
    (tclStubsPtr->tcl_RegExpRange)(regexp, index, startPtr, endPtr);
}

/* Slot 216 */
void
Tcl_Release(clientData)
    ClientData clientData;
{
    (tclStubsPtr->tcl_Release)(clientData);
}

/* Slot 217 */
void
Tcl_ResetResult(interp)
    Tcl_Interp * interp;
{
    (tclStubsPtr->tcl_ResetResult)(interp);
}

/* Slot 218 */
int
Tcl_ScanElement(str, flagPtr)
    CONST char * str;
    int * flagPtr;
{
    return (tclStubsPtr->tcl_ScanElement)(str, flagPtr);
}

/* Slot 219 */
int
Tcl_ScanCountedElement(str, length, flagPtr)
    CONST char * str;
    int length;
    int * flagPtr;
{
    return (tclStubsPtr->tcl_ScanCountedElement)(str, length, flagPtr);
}

/* Slot 220 */
int
Tcl_Seek(chan, offset, mode)
    Tcl_Channel chan;
    int offset;
    int mode;
{
    return (tclStubsPtr->tcl_Seek)(chan, offset, mode);
}

/* Slot 221 */
int
Tcl_ServiceAll()
{
    return (tclStubsPtr->tcl_ServiceAll)();
}

/* Slot 222 */
int
Tcl_ServiceEvent(flags)
    int flags;
{
    return (tclStubsPtr->tcl_ServiceEvent)(flags);
}

/* Slot 223 */
void
Tcl_SetAssocData(interp, name, proc, clientData)
    Tcl_Interp * interp;
    char * name;
    Tcl_InterpDeleteProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_SetAssocData)(interp, name, proc, clientData);
}

/* Slot 224 */
void
Tcl_SetChannelBufferSize(chan, sz)
    Tcl_Channel chan;
    int sz;
{
    (tclStubsPtr->tcl_SetChannelBufferSize)(chan, sz);
}

/* Slot 225 */
int
Tcl_SetChannelOption(interp, chan, optionName, newValue)
    Tcl_Interp * interp;
    Tcl_Channel chan;
    char * optionName;
    char * newValue;
{
    return (tclStubsPtr->tcl_SetChannelOption)(interp, chan, optionName, newValue);
}

/* Slot 226 */
int
Tcl_SetCommandInfo(interp, cmdName, infoPtr)
    Tcl_Interp * interp;
    char * cmdName;
    Tcl_CmdInfo * infoPtr;
{
    return (tclStubsPtr->tcl_SetCommandInfo)(interp, cmdName, infoPtr);
}

/* Slot 227 */
void
Tcl_SetErrno(err)
    int err;
{
    (tclStubsPtr->tcl_SetErrno)(err);
}

/* Slot 228 */
void
Tcl_SetErrorCode TCL_VARARGS_DEF(Tcl_Interp *,interp)
{
    Tcl_Interp * var;
    va_list argList;

    var = (Tcl_Interp *) TCL_VARARGS_START(Tcl_Interp *,interp,argList);

    (tclStubsPtr->tcl_SetErrorCodeVA)(var, argList);
    va_end(argList);
}

/* Slot 229 */
void
Tcl_SetMaxBlockTime(timePtr)
    Tcl_Time * timePtr;
{
    (tclStubsPtr->tcl_SetMaxBlockTime)(timePtr);
}

/* Slot 230 */
void
Tcl_SetPanicProc(panicProc)
    Tcl_PanicProc * panicProc;
{
    (tclStubsPtr->tcl_SetPanicProc)(panicProc);
}

/* Slot 231 */
int
Tcl_SetRecursionLimit(interp, depth)
    Tcl_Interp * interp;
    int depth;
{
    return (tclStubsPtr->tcl_SetRecursionLimit)(interp, depth);
}

/* Slot 232 */
void
Tcl_SetResult(interp, str, freeProc)
    Tcl_Interp * interp;
    char * str;
    Tcl_FreeProc * freeProc;
{
    (tclStubsPtr->tcl_SetResult)(interp, str, freeProc);
}

/* Slot 233 */
int
Tcl_SetServiceMode(mode)
    int mode;
{
    return (tclStubsPtr->tcl_SetServiceMode)(mode);
}

/* Slot 234 */
void
Tcl_SetObjErrorCode(interp, errorObjPtr)
    Tcl_Interp * interp;
    Tcl_Obj * errorObjPtr;
{
    (tclStubsPtr->tcl_SetObjErrorCode)(interp, errorObjPtr);
}

/* Slot 235 */
void
Tcl_SetObjResult(interp, resultObjPtr)
    Tcl_Interp * interp;
    Tcl_Obj * resultObjPtr;
{
    (tclStubsPtr->tcl_SetObjResult)(interp, resultObjPtr);
}

/* Slot 236 */
void
Tcl_SetStdChannel(channel, type)
    Tcl_Channel channel;
    int type;
{
    (tclStubsPtr->tcl_SetStdChannel)(channel, type);
}

/* Slot 237 */
char *
Tcl_SetVar(interp, varName, newValue, flags)
    Tcl_Interp * interp;
    char * varName;
    char * newValue;
    int flags;
{
    return (tclStubsPtr->tcl_SetVar)(interp, varName, newValue, flags);
}

/* Slot 238 */
char *
Tcl_SetVar2(interp, part1, part2, newValue, flags)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    char * newValue;
    int flags;
{
    return (tclStubsPtr->tcl_SetVar2)(interp, part1, part2, newValue, flags);
}

/* Slot 239 */
char *
Tcl_SignalId(sig)
    int sig;
{
    return (tclStubsPtr->tcl_SignalId)(sig);
}

/* Slot 240 */
char *
Tcl_SignalMsg(sig)
    int sig;
{
    return (tclStubsPtr->tcl_SignalMsg)(sig);
}

/* Slot 241 */
void
Tcl_SourceRCFile(interp)
    Tcl_Interp * interp;
{
    (tclStubsPtr->tcl_SourceRCFile)(interp);
}

/* Slot 242 */
int
Tcl_SplitList(interp, listStr, argcPtr, argvPtr)
    Tcl_Interp * interp;
    CONST char * listStr;
    int * argcPtr;
    char *** argvPtr;
{
    return (tclStubsPtr->tcl_SplitList)(interp, listStr, argcPtr, argvPtr);
}

/* Slot 243 */
void
Tcl_SplitPath(path, argcPtr, argvPtr)
    CONST char * path;
    int * argcPtr;
    char *** argvPtr;
{
    (tclStubsPtr->tcl_SplitPath)(path, argcPtr, argvPtr);
}

/* Slot 244 */
void
Tcl_StaticPackage(interp, pkgName, initProc, safeInitProc)
    Tcl_Interp * interp;
    char * pkgName;
    Tcl_PackageInitProc * initProc;
    Tcl_PackageInitProc * safeInitProc;
{
    (tclStubsPtr->tcl_StaticPackage)(interp, pkgName, initProc, safeInitProc);
}

/* Slot 245 */
int
Tcl_StringMatch(str, pattern)
    CONST char * str;
    CONST char * pattern;
{
    return (tclStubsPtr->tcl_StringMatch)(str, pattern);
}

/* Slot 246 */
int
Tcl_Tell(chan)
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_Tell)(chan);
}

/* Slot 247 */
int
Tcl_TraceVar(interp, varName, flags, proc, clientData)
    Tcl_Interp * interp;
    char * varName;
    int flags;
    Tcl_VarTraceProc * proc;
    ClientData clientData;
{
    return (tclStubsPtr->tcl_TraceVar)(interp, varName, flags, proc, clientData);
}

/* Slot 248 */
int
Tcl_TraceVar2(interp, part1, part2, flags, proc, clientData)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    int flags;
    Tcl_VarTraceProc * proc;
    ClientData clientData;
{
    return (tclStubsPtr->tcl_TraceVar2)(interp, part1, part2, flags, proc, clientData);
}

/* Slot 249 */
char *
Tcl_TranslateFileName(interp, name, bufferPtr)
    Tcl_Interp * interp;
    CONST char * name;
    Tcl_DString * bufferPtr;
{
    return (tclStubsPtr->tcl_TranslateFileName)(interp, name, bufferPtr);
}

/* Slot 250 */
int
Tcl_Ungets(chan, str, len, atHead)
    Tcl_Channel chan;
    char * str;
    int len;
    int atHead;
{
    return (tclStubsPtr->tcl_Ungets)(chan, str, len, atHead);
}

/* Slot 251 */
void
Tcl_UnlinkVar(interp, varName)
    Tcl_Interp * interp;
    char * varName;
{
    (tclStubsPtr->tcl_UnlinkVar)(interp, varName);
}

/* Slot 252 */
int
Tcl_UnregisterChannel(interp, chan)
    Tcl_Interp * interp;
    Tcl_Channel chan;
{
    return (tclStubsPtr->tcl_UnregisterChannel)(interp, chan);
}

/* Slot 253 */
int
Tcl_UnsetVar(interp, varName, flags)
    Tcl_Interp * interp;
    char * varName;
    int flags;
{
    return (tclStubsPtr->tcl_UnsetVar)(interp, varName, flags);
}

/* Slot 254 */
int
Tcl_UnsetVar2(interp, part1, part2, flags)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    int flags;
{
    return (tclStubsPtr->tcl_UnsetVar2)(interp, part1, part2, flags);
}

/* Slot 255 */
void
Tcl_UntraceVar(interp, varName, flags, proc, clientData)
    Tcl_Interp * interp;
    char * varName;
    int flags;
    Tcl_VarTraceProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_UntraceVar)(interp, varName, flags, proc, clientData);
}

/* Slot 256 */
void
Tcl_UntraceVar2(interp, part1, part2, flags, proc, clientData)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    int flags;
    Tcl_VarTraceProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_UntraceVar2)(interp, part1, part2, flags, proc, clientData);
}

/* Slot 257 */
void
Tcl_UpdateLinkedVar(interp, varName)
    Tcl_Interp * interp;
    char * varName;
{
    (tclStubsPtr->tcl_UpdateLinkedVar)(interp, varName);
}

/* Slot 258 */
int
Tcl_UpVar(interp, frameName, varName, localName, flags)
    Tcl_Interp * interp;
    char * frameName;
    char * varName;
    char * localName;
    int flags;
{
    return (tclStubsPtr->tcl_UpVar)(interp, frameName, varName, localName, flags);
}

/* Slot 259 */
int
Tcl_UpVar2(interp, frameName, part1, part2, localName, flags)
    Tcl_Interp * interp;
    char * frameName;
    char * part1;
    char * part2;
    char * localName;
    int flags;
{
    return (tclStubsPtr->tcl_UpVar2)(interp, frameName, part1, part2, localName, flags);
}

/* Slot 260 */
int
Tcl_VarEval TCL_VARARGS_DEF(Tcl_Interp *,interp)
{
    Tcl_Interp * var;
    va_list argList;
    int resultValue;

    var = (Tcl_Interp *) TCL_VARARGS_START(Tcl_Interp *,interp,argList);

    resultValue = (tclStubsPtr->tcl_VarEvalVA)(var, argList);
    va_end(argList);
return resultValue;
}

/* Slot 261 */
ClientData
Tcl_VarTraceInfo(interp, varName, flags, procPtr, prevClientData)
    Tcl_Interp * interp;
    char * varName;
    int flags;
    Tcl_VarTraceProc * procPtr;
    ClientData prevClientData;
{
    return (tclStubsPtr->tcl_VarTraceInfo)(interp, varName, flags, procPtr, prevClientData);
}

/* Slot 262 */
ClientData
Tcl_VarTraceInfo2(interp, part1, part2, flags, procPtr, prevClientData)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    int flags;
    Tcl_VarTraceProc * procPtr;
    ClientData prevClientData;
{
    return (tclStubsPtr->tcl_VarTraceInfo2)(interp, part1, part2, flags, procPtr, prevClientData);
}

/* Slot 263 */
int
Tcl_Write(chan, s, slen)
    Tcl_Channel chan;
    char * s;
    int slen;
{
    return (tclStubsPtr->tcl_Write)(chan, s, slen);
}

/* Slot 264 */
void
Tcl_WrongNumArgs(interp, objc, objv, message)
    Tcl_Interp * interp;
    int objc;
    Tcl_Obj *CONST objv[];
    char * message;
{
    (tclStubsPtr->tcl_WrongNumArgs)(interp, objc, objv, message);
}

/* Slot 265 */
int
Tcl_DumpActiveMemory(fileName)
    char * fileName;
{
    return (tclStubsPtr->tcl_DumpActiveMemory)(fileName);
}

/* Slot 266 */
void
Tcl_ValidateAllMemory(file, line)
    char * file;
    int line;
{
    (tclStubsPtr->tcl_ValidateAllMemory)(file, line);
}

/* Slot 267 */
void
Tcl_AppendResultVA(interp, argList)
    Tcl_Interp * interp;
    va_list argList;
{
    (tclStubsPtr->tcl_AppendResultVA)(interp, argList);
}

/* Slot 268 */
void
Tcl_AppendStringsToObjVA(objPtr, argList)
    Tcl_Obj * objPtr;
    va_list argList;
{
    (tclStubsPtr->tcl_AppendStringsToObjVA)(objPtr, argList);
}

/* Slot 269 */
char *
Tcl_HashStats(tablePtr)
    Tcl_HashTable * tablePtr;
{
    return (tclStubsPtr->tcl_HashStats)(tablePtr);
}

/* Slot 270 */
char *
Tcl_ParseVar(interp, str, termPtr)
    Tcl_Interp * interp;
    char * str;
    char ** termPtr;
{
    return (tclStubsPtr->tcl_ParseVar)(interp, str, termPtr);
}

/* Slot 271 */
char *
Tcl_PkgPresent(interp, name, version, exact)
    Tcl_Interp * interp;
    char * name;
    char * version;
    int exact;
{
    return (tclStubsPtr->tcl_PkgPresent)(interp, name, version, exact);
}

/* Slot 272 */
char *
Tcl_PkgPresentEx(interp, name, version, exact, clientDataPtr)
    Tcl_Interp * interp;
    char * name;
    char * version;
    int exact;
    ClientData * clientDataPtr;
{
    return (tclStubsPtr->tcl_PkgPresentEx)(interp, name, version, exact, clientDataPtr);
}

/* Slot 273 */
int
Tcl_PkgProvide(interp, name, version)
    Tcl_Interp * interp;
    char * name;
    char * version;
{
    return (tclStubsPtr->tcl_PkgProvide)(interp, name, version);
}

/* Slot 274 */
char *
Tcl_PkgRequire(interp, name, version, exact)
    Tcl_Interp * interp;
    char * name;
    char * version;
    int exact;
{
    return (tclStubsPtr->tcl_PkgRequire)(interp, name, version, exact);
}

/* Slot 275 */
void
Tcl_SetErrorCodeVA(interp, argList)
    Tcl_Interp * interp;
    va_list argList;
{
    (tclStubsPtr->tcl_SetErrorCodeVA)(interp, argList);
}

/* Slot 276 */
int
Tcl_VarEvalVA(interp, argList)
    Tcl_Interp * interp;
    va_list argList;
{
    return (tclStubsPtr->tcl_VarEvalVA)(interp, argList);
}

/* Slot 277 */
Tcl_Pid
Tcl_WaitPid(pid, statPtr, options)
    Tcl_Pid pid;
    int * statPtr;
    int options;
{
    return (tclStubsPtr->tcl_WaitPid)(pid, statPtr, options);
}

/* Slot 278 */
void
Tcl_PanicVA(format, argList)
    char * format;
    va_list argList;
{
    (tclStubsPtr->tcl_PanicVA)(format, argList);
}

/* Slot 279 */
void
Tcl_GetVersion(major, minor, patchLevel, type)
    int * major;
    int * minor;
    int * patchLevel;
    int * type;
{
    (tclStubsPtr->tcl_GetVersion)(major, minor, patchLevel, type);
}

/* Slot 280 is reserved */
/* Slot 281 is reserved */
/* Slot 282 is reserved */
/* Slot 283 is reserved */
/* Slot 284 is reserved */
/* Slot 285 is reserved */
/* Slot 286 */
void
Tcl_AppendObjToObj(objPtr, appendObjPtr)
    Tcl_Obj * objPtr;
    Tcl_Obj * appendObjPtr;
{
    (tclStubsPtr->tcl_AppendObjToObj)(objPtr, appendObjPtr);
}

/* Slot 287 */
Tcl_Encoding
Tcl_CreateEncoding(typePtr)
    Tcl_EncodingType * typePtr;
{
    return (tclStubsPtr->tcl_CreateEncoding)(typePtr);
}

/* Slot 288 */
void
Tcl_CreateThreadExitHandler(proc, clientData)
    Tcl_ExitProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_CreateThreadExitHandler)(proc, clientData);
}

/* Slot 289 */
void
Tcl_DeleteThreadExitHandler(proc, clientData)
    Tcl_ExitProc * proc;
    ClientData clientData;
{
    (tclStubsPtr->tcl_DeleteThreadExitHandler)(proc, clientData);
}

/* Slot 290 */
void
Tcl_DiscardResult(statePtr)
    Tcl_SavedResult * statePtr;
{
    (tclStubsPtr->tcl_DiscardResult)(statePtr);
}

/* Slot 291 */
int
Tcl_EvalEx(interp, script, numBytes, flags)
    Tcl_Interp * interp;
    char * script;
    int numBytes;
    int flags;
{
    return (tclStubsPtr->tcl_EvalEx)(interp, script, numBytes, flags);
}

/* Slot 292 */
int
Tcl_EvalObjv(interp, objc, objv, flags)
    Tcl_Interp * interp;
    int objc;
    Tcl_Obj *CONST objv[];
    int flags;
{
    return (tclStubsPtr->tcl_EvalObjv)(interp, objc, objv, flags);
}

/* Slot 293 */
int
Tcl_EvalObjEx(interp, objPtr, flags)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    int flags;
{
    return (tclStubsPtr->tcl_EvalObjEx)(interp, objPtr, flags);
}

/* Slot 294 */
void
Tcl_ExitThread(status)
    int status;
{
    (tclStubsPtr->tcl_ExitThread)(status);
}

/* Slot 295 */
int
Tcl_ExternalToUtf(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr)
    Tcl_Interp * interp;
    Tcl_Encoding encoding;
    CONST char * src;
    int srcLen;
    int flags;
    Tcl_EncodingState * statePtr;
    char * dst;
    int dstLen;
    int * srcReadPtr;
    int * dstWrotePtr;
    int * dstCharsPtr;
{
    return (tclStubsPtr->tcl_ExternalToUtf)(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr);
}

/* Slot 296 */
char *
Tcl_ExternalToUtfDString(encoding, src, srcLen, dsPtr)
    Tcl_Encoding encoding;
    CONST char * src;
    int srcLen;
    Tcl_DString * dsPtr;
{
    return (tclStubsPtr->tcl_ExternalToUtfDString)(encoding, src, srcLen, dsPtr);
}

/* Slot 297 */
void
Tcl_FinalizeThread()
{
    (tclStubsPtr->tcl_FinalizeThread)();
}

/* Slot 298 */
void
Tcl_FinalizeNotifier(clientData)
    ClientData clientData;
{
    (tclStubsPtr->tcl_FinalizeNotifier)(clientData);
}

/* Slot 299 */
void
Tcl_FreeEncoding(encoding)
    Tcl_Encoding encoding;
{
    (tclStubsPtr->tcl_FreeEncoding)(encoding);
}

/* Slot 300 */
Tcl_ThreadId
Tcl_GetCurrentThread()
{
    return (tclStubsPtr->tcl_GetCurrentThread)();
}

/* Slot 301 */
Tcl_Encoding
Tcl_GetEncoding(interp, name)
    Tcl_Interp * interp;
    CONST char * name;
{
    return (tclStubsPtr->tcl_GetEncoding)(interp, name);
}

/* Slot 302 */
char *
Tcl_GetEncodingName(encoding)
    Tcl_Encoding encoding;
{
    return (tclStubsPtr->tcl_GetEncodingName)(encoding);
}

/* Slot 303 */
void
Tcl_GetEncodingNames(interp)
    Tcl_Interp * interp;
{
    (tclStubsPtr->tcl_GetEncodingNames)(interp);
}

/* Slot 304 */
int
Tcl_GetIndexFromObjStruct(interp, objPtr, tablePtr, offset, msg, flags, indexPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    char ** tablePtr;
    int offset;
    char * msg;
    int flags;
    int * indexPtr;
{
    return (tclStubsPtr->tcl_GetIndexFromObjStruct)(interp, objPtr, tablePtr, offset, msg, flags, indexPtr);
}

/* Slot 305 */
VOID *
Tcl_GetThreadData(keyPtr, size)
    Tcl_ThreadDataKey * keyPtr;
    int size;
{
    return (tclStubsPtr->tcl_GetThreadData)(keyPtr, size);
}

/* Slot 306 */
Tcl_Obj *
Tcl_GetVar2Ex(interp, part1, part2, flags)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    int flags;
{
    return (tclStubsPtr->tcl_GetVar2Ex)(interp, part1, part2, flags);
}

/* Slot 307 */
ClientData
Tcl_InitNotifier()
{
    return (tclStubsPtr->tcl_InitNotifier)();
}

/* Slot 308 */
void
Tcl_MutexLock(mutexPtr)
    Tcl_Mutex * mutexPtr;
{
    (tclStubsPtr->tcl_MutexLock)(mutexPtr);
}

/* Slot 309 */
void
Tcl_MutexUnlock(mutexPtr)
    Tcl_Mutex * mutexPtr;
{
    (tclStubsPtr->tcl_MutexUnlock)(mutexPtr);
}

/* Slot 310 */
void
Tcl_ConditionNotify(condPtr)
    Tcl_Condition * condPtr;
{
    (tclStubsPtr->tcl_ConditionNotify)(condPtr);
}

/* Slot 311 */
void
Tcl_ConditionWait(condPtr, mutexPtr, timePtr)
    Tcl_Condition * condPtr;
    Tcl_Mutex * mutexPtr;
    Tcl_Time * timePtr;
{
    (tclStubsPtr->tcl_ConditionWait)(condPtr, mutexPtr, timePtr);
}

/* Slot 312 */
int
Tcl_NumUtfChars(src, len)
    CONST char * src;
    int len;
{
    return (tclStubsPtr->tcl_NumUtfChars)(src, len);
}

/* Slot 313 */
int
Tcl_ReadChars(channel, objPtr, charsToRead, appendFlag)
    Tcl_Channel channel;
    Tcl_Obj * objPtr;
    int charsToRead;
    int appendFlag;
{
    return (tclStubsPtr->tcl_ReadChars)(channel, objPtr, charsToRead, appendFlag);
}

/* Slot 314 */
void
Tcl_RestoreResult(interp, statePtr)
    Tcl_Interp * interp;
    Tcl_SavedResult * statePtr;
{
    (tclStubsPtr->tcl_RestoreResult)(interp, statePtr);
}

/* Slot 315 */
void
Tcl_SaveResult(interp, statePtr)
    Tcl_Interp * interp;
    Tcl_SavedResult * statePtr;
{
    (tclStubsPtr->tcl_SaveResult)(interp, statePtr);
}

/* Slot 316 */
int
Tcl_SetSystemEncoding(interp, name)
    Tcl_Interp * interp;
    CONST char * name;
{
    return (tclStubsPtr->tcl_SetSystemEncoding)(interp, name);
}

/* Slot 317 */
Tcl_Obj *
Tcl_SetVar2Ex(interp, part1, part2, newValuePtr, flags)
    Tcl_Interp * interp;
    char * part1;
    char * part2;
    Tcl_Obj * newValuePtr;
    int flags;
{
    return (tclStubsPtr->tcl_SetVar2Ex)(interp, part1, part2, newValuePtr, flags);
}

/* Slot 318 */
void
Tcl_ThreadAlert(threadId)
    Tcl_ThreadId threadId;
{
    (tclStubsPtr->tcl_ThreadAlert)(threadId);
}

/* Slot 319 */
void
Tcl_ThreadQueueEvent(threadId, evPtr, position)
    Tcl_ThreadId threadId;
    Tcl_Event* evPtr;
    Tcl_QueuePosition position;
{
    (tclStubsPtr->tcl_ThreadQueueEvent)(threadId, evPtr, position);
}

/* Slot 320 */
Tcl_UniChar
Tcl_UniCharAtIndex(src, index)
    CONST char * src;
    int index;
{
    return (tclStubsPtr->tcl_UniCharAtIndex)(src, index);
}

/* Slot 321 */
Tcl_UniChar
Tcl_UniCharToLower(ch)
    int ch;
{
    return (tclStubsPtr->tcl_UniCharToLower)(ch);
}

/* Slot 322 */
Tcl_UniChar
Tcl_UniCharToTitle(ch)
    int ch;
{
    return (tclStubsPtr->tcl_UniCharToTitle)(ch);
}

/* Slot 323 */
Tcl_UniChar
Tcl_UniCharToUpper(ch)
    int ch;
{
    return (tclStubsPtr->tcl_UniCharToUpper)(ch);
}

/* Slot 324 */
int
Tcl_UniCharToUtf(ch, buf)
    int ch;
    char * buf;
{
    return (tclStubsPtr->tcl_UniCharToUtf)(ch, buf);
}

/* Slot 325 */
char *
Tcl_UtfAtIndex(src, index)
    CONST char * src;
    int index;
{
    return (tclStubsPtr->tcl_UtfAtIndex)(src, index);
}

/* Slot 326 */
int
Tcl_UtfCharComplete(src, len)
    CONST char * src;
    int len;
{
    return (tclStubsPtr->tcl_UtfCharComplete)(src, len);
}

/* Slot 327 */
int
Tcl_UtfBackslash(src, readPtr, dst)
    CONST char * src;
    int * readPtr;
    char * dst;
{
    return (tclStubsPtr->tcl_UtfBackslash)(src, readPtr, dst);
}

/* Slot 328 */
char *
Tcl_UtfFindFirst(src, ch)
    CONST char * src;
    int ch;
{
    return (tclStubsPtr->tcl_UtfFindFirst)(src, ch);
}

/* Slot 329 */
char *
Tcl_UtfFindLast(src, ch)
    CONST char * src;
    int ch;
{
    return (tclStubsPtr->tcl_UtfFindLast)(src, ch);
}

/* Slot 330 */
char *
Tcl_UtfNext(src)
    CONST char * src;
{
    return (tclStubsPtr->tcl_UtfNext)(src);
}

/* Slot 331 */
char *
Tcl_UtfPrev(src, start)
    CONST char * src;
    CONST char * start;
{
    return (tclStubsPtr->tcl_UtfPrev)(src, start);
}

/* Slot 332 */
int
Tcl_UtfToExternal(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr)
    Tcl_Interp * interp;
    Tcl_Encoding encoding;
    CONST char * src;
    int srcLen;
    int flags;
    Tcl_EncodingState * statePtr;
    char * dst;
    int dstLen;
    int * srcReadPtr;
    int * dstWrotePtr;
    int * dstCharsPtr;
{
    return (tclStubsPtr->tcl_UtfToExternal)(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr);
}

/* Slot 333 */
char *
Tcl_UtfToExternalDString(encoding, src, srcLen, dsPtr)
    Tcl_Encoding encoding;
    CONST char * src;
    int srcLen;
    Tcl_DString * dsPtr;
{
    return (tclStubsPtr->tcl_UtfToExternalDString)(encoding, src, srcLen, dsPtr);
}

/* Slot 334 */
int
Tcl_UtfToLower(src)
    char * src;
{
    return (tclStubsPtr->tcl_UtfToLower)(src);
}

/* Slot 335 */
int
Tcl_UtfToTitle(src)
    char * src;
{
    return (tclStubsPtr->tcl_UtfToTitle)(src);
}

/* Slot 336 */
int
Tcl_UtfToUniChar(src, chPtr)
    CONST char * src;
    Tcl_UniChar * chPtr;
{
    return (tclStubsPtr->tcl_UtfToUniChar)(src, chPtr);
}

/* Slot 337 */
int
Tcl_UtfToUpper(src)
    char * src;
{
    return (tclStubsPtr->tcl_UtfToUpper)(src);
}

/* Slot 338 */
int
Tcl_WriteChars(chan, src, srcLen)
    Tcl_Channel chan;
    CONST char * src;
    int srcLen;
{
    return (tclStubsPtr->tcl_WriteChars)(chan, src, srcLen);
}

/* Slot 339 */
int
Tcl_WriteObj(chan, objPtr)
    Tcl_Channel chan;
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_WriteObj)(chan, objPtr);
}

/* Slot 340 */
char *
Tcl_GetString(objPtr)
    Tcl_Obj * objPtr;
{
    return (tclStubsPtr->tcl_GetString)(objPtr);
}

/* Slot 341 */
char *
Tcl_GetDefaultEncodingDir()
{
    return (tclStubsPtr->tcl_GetDefaultEncodingDir)();
}

/* Slot 342 */
void
Tcl_SetDefaultEncodingDir(path)
    char * path;
{
    (tclStubsPtr->tcl_SetDefaultEncodingDir)(path);
}

/* Slot 343 */
void
Tcl_AlertNotifier(clientData)
    ClientData clientData;
{
    (tclStubsPtr->tcl_AlertNotifier)(clientData);
}

/* Slot 344 */
void
Tcl_ServiceModeHook(mode)
    int mode;
{
    (tclStubsPtr->tcl_ServiceModeHook)(mode);
}

/* Slot 345 */
Tcl_Channel
Tcl_ReplaceChannel(interp, typePtr, instanceData, mask, prevChan)
    Tcl_Interp * interp;
    Tcl_ChannelType * typePtr;
    ClientData instanceData;
    int mask;
    Tcl_Channel prevChan;
{
    return (tclStubsPtr->tcl_ReplaceChannel)(interp, typePtr, instanceData, mask, prevChan);
}

/* Slot 346 */
void
Tcl_UndoReplaceChannel(interp, chan)
    Tcl_Interp * interp;
    Tcl_Channel chan;
{
    (tclStubsPtr->tcl_UndoReplaceChannel)(interp, chan);
}


/* !END!: Do not edit above this line. */
