.TH TANGLE 1 "02 March 2022" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP
.el .ds OX TeX
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
tangle \- translate WEB to Pascal
.SH SYNOPSIS
.PP
\f[B]tangle\f[R] [\f[I]options\f[R]]
\f[I]webfile\f[R][\f[B].web\f[R]]
[{\f[I]changefile\f[R][\f[B].ch\f[R]]|\f[B]-\f[R]}
[\f[I]outfile\f[R][\f[B].p\f[R]]]]
.\"=====================================================================
.SH DESCRIPTION
This manual page is not meant to be exhaustive.  The complete
documentation for this version of \*(TX can be found in the info file
or manual
.IR "Web2C: A TeX implementation" .
.PP
The
.B tangle
program converts a \*(WB
source document into a Pascal program that may be compiled in the usual
way with the on-line Pascal compiler (e.g.,
.BR pc (1)).
The output file is packed into lines of 72 characters or less, with
the only concession to readability being the termination of lines at
semicolons when this can be done conveniently.
.PP
The \*(WB language allows you to prepare a single document containing all
the information that is needed both to produce a compilable Pascal
program and to produce a well-formatted document describing the program
in as much detail as the writer may desire.  The user of \*(WB must be
familiar with both \*(TX and Pascal.  \*(WB also provides a relatively
simple, although adequate, macro facility that permits a Pascal program
to be written in small easily-understood modules.
.PP
The command line should have one, two or three names on it.
The first is taken as the \*(WB file (and
.B .web
is added if there is no
extension).
If there is second name, it is a change file (and
.B .ch
is added if there is
no extension).  The change file overrides parts of the \*(WB file,
as described in the \*(WB system documentation.
.PP
If there is a third name, it is the Pascal output file (and
.B .p
is added if there is no extension). In this case you can specify an empty
change file with '-' as the second argument.
Otherwise the name of the Pascal file is formed by adding
.B .p
to the root of the \*(WB file name.
.PP
An optional second output file is a string pool file,
whose name is formed by adding
.B .pool
to the root of the Pascal file name.
.\"=====================================================================
.SH "OPTIONS"
This version of
.B tangle
understands the following options.  Note that some of these options
may render the output unsuitable for processing by a Pascal compiler.
.TP
.B --help
Print help message and exit.
.TP
.BI --length \ number
Compare only the first
.I number
characters of identifiers when checking for collisions.  The default
is 32, the original
.B tangle
used 7.
.TP
.B --loose
When checking for collisions between identifiers, honor the settings
of the
.BR --lowercase ,
.BR --mixedcase ,
.BR --uppercase ,
and
.B --underline
options. This is the default.
.TP
.B --lowercase
Convert all identifiers to lowercase.
.TP
.B --mixedcase
Retain the case of identifiers.  This is the default.
.TP
.B --strict
When checking for collisions between identifiers, strip underlines and
convert all identifiers to uppercase first.
.TP
.B --underline
Retain underlines (also known as underscores) in identifiers.
.TP
.B --uppercase
Convert all identifiers to uppercase.  This is the behaviour of the
original
.BR tangle .
.TP
.B --version
Print version information and exit.
.\"=====================================================================
.SH ENVIRONMENT
The environment variable WEBINPUTS is used to search for the input files,
or the system default if WEBINPUTS is not set.  See
.BR tex (1)
for the details of the searching.
.\"=====================================================================
.SH "SEE ALSO"
.BR pc (1),
.BR pxp (1)
(for formatting
.B tangle
output when debugging),
.BR tex (1).
.PP
Donald E. Knuth,
.IR "The \*(WB System of Structured Documentation" .
.PP
Donald E. Knuth,
.IR "Literate Programming" ,
Computer Journal
.BR 27 ,
97\-111, 1984.
.PP
Wayne Sewell,
.IR "Weaving a Program" ,
Van Nostrand Reinhold, 1989, ISBN 0-442-31946-0.
.PP
Donald E. Knuth,
.I "\*(OX: The Program"
(Volume B of
.IR "Computers and Typesetting" ),
Addison-Wesley, 1986, ISBN 0-201-13437-3.
.PP
Donald E. Knuth,
.I "\*(MF: The Program"
(Volume D of
.IR "Computers and Typesetting" ),
Addison-Wesley, 1986, ISBN 0-201-13438-1.
.PP
These last two are by far the largest extant examples of \*(WB
programs.
.PP
There is an active Internet electronic mail discussion list on the
subject of literate programming; send a subscription request to
.I litprog-request@shsu.edu
to join.
.\"=====================================================================
.SH AUTHORS
\*(WB was designed by Donald E. Knuth, based on an earlier system
called DOC (implemented by Ignacio Zabala).
The
.B tangle
and
.B weave
programs are themselves written in \*(WB. The system
was originally ported to Unix at Stanford by Howard Trickey, and at
Cornell by Pavel Curtis.
