---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes, dimension, espace
---

# Comment modifier l'espace entre une figure et sa légende ?

Les longueurs qui gèrent cet espace s'appelle `\abovecaptionskip` 
(pour l'espace placé au-dessus de la légende) et `\belowcaptionskip` 
(au-dessous de la légende).

::::{tab-set}

:::{tab-item} Sans correction
```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)  
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Comme le dit la Wikipédia, A (capitale : A, minuscule : a) est la première 
lettre de l'alphabet latin ainsi que sa première voyelle.
\begin{figure}[ht]
  \centering
  \includegraphics[width=.5\linewidth]{example-image-a}
  \caption{La lettre A}
  \label{monA}
\end{figure}

La lettre A est présentée dans la figure~\ref{monA}.
\end{document}
```
:::

:::{tab-item} Avec une correction

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)  
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \addtolength{\abovecaptionskip}{5mm}
  \addtolength{\belowcaptionskip}{1cm}

\begin{document}
Comme le dit la Wikipédia, A (capitale : A, minuscule : a) est la première 
lettre de l'alphabet latin ainsi que sa première voyelle.
\begin{figure}[ht]
  \centering
  \includegraphics[width=.5\linewidth]{example-image-a}
  \caption{La lettre A}
  \label{monA}
\end{figure}

La lettre A est présentée dans la figure~\ref{monA}.
\end{document}
```
:::

::::