// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLAL_D_S_S_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLAL_D_S_S_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqdmlal_D_S_S[] = {
  0x000000007c080000, 0x0000000000000000,
  0x00000000f90c0000, 0x0000000000000000,
  0x0000007ef6180000, 0x0000000000000000,
  0x0000007ef6180000, 0x0000000000000000,
  0x000000007d040000, 0x0000000000000000,
  0x0000007e7a100000, 0x0000000000000000,
  0x0000007e7a100000, 0x0000000000000000,
  0x0000007e7a10fc00, 0x0000000000000000,
  0x0000007dfd0c0000, 0x0000000000000000,
  0x0000007dfd0c0000, 0x0000000000000000,
  0x0000007dfd0cfc00, 0x0000000000000000,
  0x0000007dfd0ef400, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fc00, 0x0000000000000000,
  0x000000000002f400, 0x0000000000000000,
  0x0000000000227400, 0x0000000000000000,
  0x000000000000fc00, 0x0000000000000000,
  0x000000000002f400, 0x0000000000000000,
  0x0000000000227400, 0x0000000000000000,
  0x00000000009d8000, 0x0000000000000000,
  0x000000000001f800, 0x0000000000000000,
  0x0000000000217800, 0x0000000000000000,
  0x00000000009c8400, 0x0000000000000000,
  0x0000000001188c00, 0x0000000000000000,
  0x00000000001f8000, 0x0000000000000000,
  0x00000000009a8c00, 0x0000000000000000,
  0x0000000001169400, 0x0000000000000000,
  0x0000000001939800, 0x0000000000000000,
  0x00000000007b0c00, 0x0000000000000000,
  0x0000000000f71400, 0x0000000000000000,
  0x0000000001741800, 0x0000000000000000,
  0x000000007f712400, 0x0000000000000000,
  0x00000000007c0800, 0x0000000000000000,
  0x0000000000f90c00, 0x0000000000000000,
  0x000000007ef61800, 0x0000000000000000,
  0x00000000fcf42000, 0x0000000000000000,
  0x00000000007d0400, 0x0000000000000000,
  0x000000007e7a1000, 0x0000000000000000,
  0x00000000fc781800, 0x0000000000000000,
  0x000000017a771c00, 0x0000000000000000,
  0x000000007dfd0c00, 0x0000000000000000,
  0x00000000fbfb1400, 0x0000000000000000,
  0x0000000179fa1800, 0x0000000000000000,
  0x00003267e0604c00, 0x0000000000000000,
  0x000000007dfe0800, 0x0000000000000000,
  0x00000000fbfd0c00, 0x0000000000000000,
  0x0000326762634000, 0x0000000000000000,
  0x000086676262ec00, 0x0000000000000000,
  0x000000007dff0400, 0x0000000000000000,
  0x00003266e4653800, 0x0000000000000000,
  0x00008666e464e400, 0x0000000000000000,
  0x00010466e461f000, 0x0000000000000000,
  0x0000326666663400, 0x0000000000000000,
  0x000086666665e000, 0x0000000000000000,
  0x000104666662ec00, 0x0000000000000000,
  0x000182666660f400, 0x0000000000000000,
  0x000053ffffffac00, 0x0000000000000000,
  0x0000d1fffffcb800, 0x0000000000000000,
  0x00014ffffffac000, 0x0000000000000000,
  0x0001cdfffff9c400, 0x0000000000000000,
  0x00007dfffffd0c00, 0x0000000000000000,
  0x0000fbfffffb1400, 0x0000000000000000,
  0x000179fffffa1800, 0x0000000000000000,
  0x0000fbfffffa1800, 0x0000000000000000,
  0x00007dfffffe0800, 0x0000000000000000,
  0x0000fbfffffd0c00, 0x0000000000000000,
  0x00007dfffffd0c00, 0x0000000000000000,
  0xfffffffffffe0800, 0x0000000000000000,
  0x00007dffffff0400, 0x0000000000000000,
  0xffffffffffff0400, 0x0000000000000000,
  0xffff820000000000, 0x0000000000000000,
  0xffff2dffffff5800, 0x0000000000000000,
  0xffff820000000000, 0x0000000000000000,
  0xffff04000000fc00, 0x0000000000000000,
  0xfffeb00000005400, 0x0000000000000000,
  0xfffe7d9999992400, 0x0000000000000000,
  0xffff82000000fc00, 0x0000000000000000,
  0xffff2e0000005400, 0x0000000000000000,
  0xfffefb9999992400, 0x0000000000000000,
  0xfffefb991b992400, 0x0000000000000000,
  0xffffabffffff5800, 0x0000000000000000,
  0xffff799999982800, 0x0000000000000000,
  0xffff79991b982800, 0x0000000000000000,
  0xffff79989d992400, 0x0000000000000000,
  0xffffcd999998d000, 0x0000000000000000,
  0xffffcd991b98d000, 0x0000000000000000,
  0xffffcd989d99cc00, 0x0000000000000000,
  0xffffcd981f9bc400, 0x0000000000000000,
  0xffffffff82000000, 0x0000000000000000,
  0xffffffff0400fc00, 0x0000000000000000,
  0xfffffffe8602f400, 0x0000000000000000,
  0xfffffffe0805e800, 0x0000000000000000,
  0xffffffff8200fc00, 0x0000000000000000,
  0xffffffff0402f400, 0x0000000000000000,
  0xfffffffe8605e800, 0x0000000000000000,
  0xfffffffe8587e800, 0x0000000000000000,
  0xffffffff8201f800, 0x0000000000000000,
  0xffffffff0404ec00, 0x0000000000000000,
  0xffffffff0386ec00, 0x0000000000000000,
  0xffffffff0309e800, 0x0000000000000000,
  0xffffffff8202f400, 0x0000000000000000,
  0xffffffff8184f400, 0x0000000000000000,
  0xffffffff8107f000, 0x0000000000000000,
  0xffffffff808be800, 0x0000000000000000,
  0xffffffffff820000, 0x0000000000000000,
  0xffffffffff04fc00, 0x0000000000000000,
  0xfffffffffe88f400, 0x0000000000000000,
  0xfffffffffe0de800, 0x0000000000000000,
  0xffffffffff82fc00, 0x0000000000000000,
  0xffffffffff06f400, 0x0000000000000000,
  0xfffffffffe8be800, 0x0000000000000000,
  0xfffffffffe6c6800, 0x0000000000000000,
  0xffffffffff83f800, 0x0000000000000000,
  0xffffffffff08ec00, 0x0000000000000000,
  0xfffffffffee96c00, 0x0000000000000000,
  0xfffffffffee67800, 0x0000000000000000,
  0xffffffffff84f400, 0x0000000000000000,
  0xffffffffff657400, 0x0000000000000000,
  0xffffffffff628000, 0x0000000000000000,
  0xffffffffff608800, 0x0000000000000000,
  0xffffffffffe08000, 0x0000000000000000,
  0xffffffffffdd8c00, 0x0000000000000000,
  0xffffffffffdb9400, 0x0000000000000000,
  0xffffffffffda9800, 0x0000000000000000,
  0xfffffffffffd0600, 0x0000000000000000,
  0xfffffffffffb0a00, 0x0000000000000000,
  0xfffffffffffa0c00, 0x0000000000000000,
  0xfffffffffffa0c00, 0x0000000000000000,
  0xfffffffffffe0400, 0x0000000000000000,
  0xfffffffffffd0600, 0x0000000000000000,
  0xfffffffffffd0600, 0x0000000000000000,
  0xfffffffffffe0400, 0x0000000000000000,
  0xffffffffffff0200, 0x0000000000000000,
  0xffffffffffff0200, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000001fc00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fe00, 0x0000000000000000,
  0x000000000002fa00, 0x0000000000000000,
  0x000000000022ba00, 0x0000000000000000,
  0x000000000000fe00, 0x0000000000000000,
  0x000000000002fa00, 0x0000000000000000,
  0x000000000022ba00, 0x0000000000000000,
  0x00000000009ec000, 0x0000000000000000,
  0x000000000001fc00, 0x0000000000000000,
  0x000000000021bc00, 0x0000000000000000,
  0x00000000009dc200, 0x0000000000000000,
  0x00000000011ac600, 0x0000000000000000,
  0x00000000001fc000, 0x0000000000000000,
  0x00000000009bc600, 0x0000000000000000,
  0x000000000118ca00, 0x0000000000000000,
  0x000000000196cc00, 0x0000000000000000,
  0x00000000007c0600, 0x0000000000000000,
  0x0000000000f90a00, 0x0000000000000000,
  0x0000000001770c00, 0x0000000000000000,
  0x0000000080741200, 0x0000000000000000,
  0x00000000007d0400, 0x0000000000000000,
  0x0000000000fb0600, 0x0000000000000000,
  0x000000007ff80c00, 0x0000000000000000,
  0x00000000fef61000, 0x0000000000000000,
  0x00000000007e0200, 0x0000000000000000,
  0x000000007f7b0800, 0x0000000000000000,
  0x00000000fe790c00, 0x0000000000000000,
  0x000000017d780e00, 0x0000000000000000,
  0x000000007efd0600, 0x0000000000000000,
  0x00000000fdfb0a00, 0x0000000000000000,
  0x000000017cfa0c00, 0x0000000000000000,
  0x000032ce49c6a600, 0x0000000000000000,
  0x000000007efe0400, 0x0000000000000000,
  0x00000000fdfd0600, 0x0000000000000000,
  0x000032cdcac9a000, 0x0000000000000000,
  0x000087787573f600, 0x0000000000000000,
  0x000000007eff0200, 0x0000000000000000,
  0x000032cd4bcb9c00, 0x0000000000000000,
  0x00008777f675f200, 0x0000000000000000,
  0x00010677f672f800, 0x0000000000000000,
  0x000032cccccc9a00, 0x0000000000000000,
  0x000087777776f000, 0x0000000000000000,
  0x000106777773f600, 0x0000000000000000,
  0x000185777771fa00, 0x0000000000000000,
  0x000054aaaaaa5600, 0x0000000000000000,
  0x0000d3aaaaa75c00, 0x0000000000000000,
  0x000152aaaaa56000, 0x0000000000000000,
  0x0001d1aaaaa46200, 0x0000000000000000,
  0x00007efffffd0600, 0x0000000000000000,
  0x0000fdfffffb0a00, 0x0000000000000000,
  0x00017cfffffa0c00, 0x0000000000000000,
  0x0000fdfffffa0c00, 0x0000000000000000,
  0x00007efffffe0400, 0x0000000000000000,
  0x0000fdfffffd0600, 0x0000000000000000,
  0x00007efffffd0600, 0x0000000000000000,
  0xfffffffffffe0400, 0x0000000000000000,
  0x00007effffff0200, 0x0000000000000000,
  0xffffffffffff0200, 0x0000000000000000,
  0xffff810000000000, 0x0000000000000000,
  0xffff2c555554ac00, 0x0000000000000000,
  0xffff810000000000, 0x0000000000000000,
  0xffff02000000fe00, 0x0000000000000000,
  0xfffead555555aa00, 0x0000000000000000,
  0xfffe7a8888881200, 0x0000000000000000,
  0xffff81000000fe00, 0x0000000000000000,
  0xffff2c555555aa00, 0x0000000000000000,
  0xfffef98888881200, 0x0000000000000000,
  0xfffef98809881200, 0x0000000000000000,
  0xffffab555554ac00, 0x0000000000000000,
  0xffff788888871400, 0x0000000000000000,
  0xffff788809871400, 0x0000000000000000,
  0xffff78878a881200, 0x0000000000000000,
  0xffffcd3333326800, 0x0000000000000000,
  0xffffcd32b4326800, 0x0000000000000000,
  0xffffcd3235336600, 0x0000000000000000,
  0xffffcd31b6356200, 0x0000000000000000,
  0xffffffff81000000, 0x0000000000000000,
  0xffffffff0200fe00, 0x0000000000000000,
  0xfffffffe8302fa00, 0x0000000000000000,
  0xfffffffe0405f400, 0x0000000000000000,
  0xffffffff8100fe00, 0x0000000000000000,
  0xffffffff0202fa00, 0x0000000000000000,
  0xfffffffe8305f400, 0x0000000000000000,
  0xfffffffe8286f400, 0x0000000000000000,
  0xffffffff8101fc00, 0x0000000000000000,
  0xffffffff0204f600, 0x0000000000000000,
  0xffffffff0185f600, 0x0000000000000000,
  0xffffffff0107f400, 0x0000000000000000,
  0xffffffff8102fa00, 0x0000000000000000,
  0xffffffff8083fa00, 0x0000000000000000,
  0xffffffff8005f800, 0x0000000000000000,
  0xffffffff7f88f400, 0x0000000000000000,
  0xffffffffff810000, 0x0000000000000000,
  0xffffffffff02fe00, 0x0000000000000000,
  0xfffffffffe85fa00, 0x0000000000000000,
  0xfffffffffe09f400, 0x0000000000000000,
  0xffffffffff81fe00, 0x0000000000000000,
  0xffffffffff04fa00, 0x0000000000000000,
  0xfffffffffe88f400, 0x0000000000000000,
  0xfffffffffe693400, 0x0000000000000000,
  0xffffffffff82fc00, 0x0000000000000000,
  0xffffffffff06f600, 0x0000000000000000,
  0xfffffffffee73600, 0x0000000000000000,
  0xfffffffffee43c00, 0x0000000000000000,
  0xffffffffff83fa00, 0x0000000000000000,
  0xffffffffff643a00, 0x0000000000000000,
  0xffffffffff614000, 0x0000000000000000,
  0xffffffffff5f4400, 0x0000000000000000,
  0xffffffffffe04000, 0x0000000000000000,
  0xffffffffffdd4600, 0x0000000000000000,
  0xffffffffffdb4a00, 0x0000000000000000,
  0xffffffffffda4c00, 0x0000000000000000,
  0xfffffffffd001200, 0x0000000000000000,
  0xfffffffffb001e00, 0x0000000000000000,
  0xfffffffffa002400, 0x0000000000000000,
  0xfffffffffa002400, 0x0000000000000000,
  0xfffffffffe000c00, 0x0000000000000000,
  0xfffffffffd001200, 0x0000000000000000,
  0xfffffffffd001200, 0x0000000000000000,
  0xfffffffffe000c00, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000001fff400, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x0000000002ffee00, 0x0000000000000000,
  0x0000000022ff2e00, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x0000000002ffee00, 0x0000000000000000,
  0x0000000022ff2e00, 0x0000000000000000,
  0x000000009ffc4000, 0x0000000000000000,
  0x0000000001fff400, 0x0000000000000000,
  0x0000000021ff3400, 0x0000000000000000,
  0x000000009efc4600, 0x0000000000000000,
  0x000000011cf95200, 0x0000000000000000,
  0x000000001fff4000, 0x0000000000000000,
  0x000000009cfc5200, 0x0000000000000000,
  0x000000011af95e00, 0x0000000000000000,
  0x0000000199f66400, 0x0000000000000000,
  0x000000007cfd1200, 0x0000000000000000,
  0x00000000fafa1e00, 0x0000000000000000,
  0x0000000179f72400, 0x0000000000000000,
  0x0000008173f73600, 0x0000000000000000,
  0x000000007dfd0c00, 0x0000000000000000,
  0x00000000fcfa1200, 0x0000000000000000,
  0x00000080f6fa2400, 0x0000000000000000,
  0x00000100f1fa3000, 0x0000000000000000,
  0x000000007efd0600, 0x0000000000000000,
  0x0000008078fd1800, 0x0000000000000000,
  0x0000010073fd2400, 0x0000000000000000,
  0x000001806ffd2a00, 0x0000000000000000,
  0x0000007ffa001200, 0x0000000000000000,
  0x000000fff5001e00, 0x0000000000000000,
  0x0000017ff1002400, 0x0000000000000000,
  0x0033337ff0ccf200, 0x0000000000000000,
  0x0000007ffb000c00, 0x0000000000000000,
  0x000000fff7001200, 0x0000000000000000,
  0x003332fff6cce000, 0x0000000000000000,
  0x008886554bcce200, 0x0000000000000000,
  0x0000007ffc000600, 0x0000000000000000,
  0x0033327ffbccd400, 0x0000000000000000,
  0x008885d550ccd600, 0x0000000000000000,
  0x010882d54dcce800, 0x0000000000000000,
  0x003331ffffccce00, 0x0000000000000000,
  0x0088855554ccd000, 0x0000000000000000,
  0x0108825551cce200, 0x0000000000000000,
  0x01887f554fccee00, 0x0000000000000000,
  0x0055535555000200, 0x0000000000000000,
  0x00d5505552001400, 0x0000000000000000,
  0x01554d5550002000, 0x0000000000000000,
  0x01d54a554f002600, 0x0000000000000000,
  0x007ffcfffd001200, 0x0000000000000000,
  0x00fff9fffb001e00, 0x0000000000000000,
  0x017ff6fffa002400, 0x0000000000000000,
  0x00fff9fffa002400, 0x0000000000000000,
  0x007ffcfffe000c00, 0x0000000000000000,
  0x00fff9fffd001200, 0x0000000000000000,
  0x007ffcfffd001200, 0x0000000000000000,
  0xfffffffffe000c00, 0x0000000000000000,
  0x007ffcffff000600, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0xff80030000000000, 0x0000000000000000,
  0xff2aafaaaa000400, 0x0000000000000000,
  0xff80030000000000, 0x0000000000000000,
  0xff00060000fffa00, 0x0000000000000000,
  0xfeaab2aaaafffe00, 0x0000000000000000,
  0xfe7780aaaa333600, 0x0000000000000000,
  0xff80030000fffa00, 0x0000000000000000,
  0xff2aafaaaafffe00, 0x0000000000000000,
  0xfef77daaaa333600, 0x0000000000000000,
  0xfef77d2aad333600, 0x0000000000000000,
  0xffaaacaaaa000400, 0x0000000000000000,
  0xff777aaaa9333c00, 0x0000000000000000,
  0xff777a2aac333c00, 0x0000000000000000,
  0xff7779aab0333600, 0x0000000000000000,
  0xffcccdffff333800, 0x0000000000000000,
  0xffcccd8002333800, 0x0000000000000000,
  0xffcccd0006333200, 0x0000000000000000,
  0xffcccc800b332600, 0x0000000000000000,
  0xffffff8003000000, 0x0000000000000000,
  0xffffff0006fffa00, 0x0000000000000000,
  0xfffffe800bffee00, 0x0000000000000000,
  0xfffffe0011ffdc00, 0x0000000000000000,
  0xffffff8003fffa00, 0x0000000000000000,
  0xffffff0008ffee00, 0x0000000000000000,
  0xfffffe800effdc00, 0x0000000000000000,
  0xfffffe7f8f02dc00, 0x0000000000000000,
  0xffffff8004fff400, 0x0000000000000000,
  0xffffff000affe200, 0x0000000000000000,
  0xfffffeff8b02e200, 0x0000000000000000,
  0xfffffeff0c05dc00, 0x0000000000000000,
  0xffffff8005ffee00, 0x0000000000000000,
  0xffffff7f8602ee00, 0x0000000000000000,
  0xffffff7f0705e800, 0x0000000000000000,
  0xffffff7e8908dc00, 0x0000000000000000,
  0xffffffff80030000, 0x0000000000000000,
  0xffffffff0105fa00, 0x0000000000000000,
  0xfffffffe8308ee00, 0x0000000000000000,
  0xfffffffe060bdc00, 0x0000000000000000,
  0xffffffff8102fa00, 0x0000000000000000,
  0xffffffff0305ee00, 0x0000000000000000,
  0xfffffffe8608dc00, 0x0000000000000000,
  0xfffffffe66099c00, 0x0000000000000000,
  0xffffffff8202f400, 0x0000000000000000,
  0xffffffff0505e200, 0x0000000000000000,
  0xfffffffee506a200, 0x0000000000000000,
  0xfffffffee206b400, 0x0000000000000000,
  0xffffffff8302ee00, 0x0000000000000000,
  0xffffffff6303ae00, 0x0000000000000000,
  0xffffffff6003c000, 0x0000000000000000,
  0xffffffff5e03cc00, 0x0000000000000000,
  0xffffffffe000c000, 0x0000000000000000,
  0xffffffffdd00d200, 0x0000000000000000,
  0xffffffffdb00de00, 0x0000000000000000,
  0xffffffffda00e400, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffffa, 0x0000000000000000,
  0xfffffffffffffff6, 0x0000000000000000,
  0xfffffffffffffff4, 0x0000000000000000,
  0xfffffffffffffff4, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffa, 0x0000000000000000,
  0xfffffffffffffffa, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000006, 0x0000000000000000,
  0x0000000000000046, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000006, 0x0000000000000000,
  0x0000000000000046, 0x0000000000000000,
  0x0000000000000140, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000044, 0x0000000000000000,
  0x000000000000013e, 0x0000000000000000,
  0x000000000000023a, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x000000000000013a, 0x0000000000000000,
  0x0000000000000236, 0x0000000000000000,
  0x0000000000000334, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000001f6, 0x0000000000000000,
  0x00000000000002f4, 0x0000000000000000,
  0x00000000000102ee, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000001fa, 0x0000000000000000,
  0x00000000000101f4, 0x0000000000000000,
  0x00000000000201f0, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x00000000000100f8, 0x0000000000000000,
  0x00000000000200f4, 0x0000000000000000,
  0x00000000000300f2, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x000000000001fff6, 0x0000000000000000,
  0x000000000002fff4, 0x0000000000000000,
  0x000000006669665a, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000001fffa, 0x0000000000000000,
  0x0000000066686660, 0x0000000000000000,
  0x000000011113110a, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x0000000066676664, 0x0000000000000000,
  0x000000011112110e, 0x0000000000000000,
  0x0000000211121108, 0x0000000000000000,
  0x0000000066666666, 0x0000000000000000,
  0x0000000111111110, 0x0000000000000000,
  0x000000021111110a, 0x0000000000000000,
  0x0000000311111106, 0x0000000000000000,
  0x00000000aaaaaaaa, 0x0000000000000000,
  0x00000001aaaaaaa4, 0x0000000000000000,
  0x00000002aaaaaaa0, 0x0000000000000000,
  0x00000003aaaaaa9e, 0x0000000000000000,
  0x00000000fffffffa, 0x0000000000000000,
  0x00000001fffffff6, 0x0000000000000000,
  0x00000002fffffff4, 0x0000000000000000,
  0x00000001fffffff4, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x00000001fffffffa, 0x0000000000000000,
  0x00000000fffffffa, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0xfffffffe55555554, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0xfffffffe00000002, 0x0000000000000000,
  0xfffffffd55555556, 0x0000000000000000,
  0xfffffffceeeeeeee, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xfffffffe55555556, 0x0000000000000000,
  0xfffffffdeeeeeeee, 0x0000000000000000,
  0xfffffffdeeedeeee, 0x0000000000000000,
  0xffffffff55555554, 0x0000000000000000,
  0xfffffffeeeeeeeec, 0x0000000000000000,
  0xfffffffeeeedeeec, 0x0000000000000000,
  0xfffffffeeeeceeee, 0x0000000000000000,
  0xffffffff99999998, 0x0000000000000000,
  0xffffffff99989998, 0x0000000000000000,
  0xffffffff9997999a, 0x0000000000000000,
  0xffffffff9996999e, 0x0000000000000000,
  0xffffffffffff0000, 0x0000000000000000,
  0xfffffffffffe0002, 0x0000000000000000,
  0xfffffffffffd0006, 0x0000000000000000,
  0xfffffffffffc000c, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xfffffffffffe0006, 0x0000000000000000,
  0xfffffffffffd000c, 0x0000000000000000,
  0xfffffffffffcff0c, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xfffffffffffe000a, 0x0000000000000000,
  0xfffffffffffdff0a, 0x0000000000000000,
  0xfffffffffffdfe0c, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xfffffffffffeff06, 0x0000000000000000,
  0xfffffffffffefe08, 0x0000000000000000,
  0xfffffffffffefd0c, 0x0000000000000000,
  0xffffffffffffff00, 0x0000000000000000,
  0xfffffffffffffe02, 0x0000000000000000,
  0xfffffffffffffd06, 0x0000000000000000,
  0xfffffffffffffc0c, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xfffffffffffffe06, 0x0000000000000000,
  0xfffffffffffffd0c, 0x0000000000000000,
  0xfffffffffffffccc, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xfffffffffffffe0a, 0x0000000000000000,
  0xfffffffffffffdca, 0x0000000000000000,
  0xfffffffffffffdc4, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xfffffffffffffec6, 0x0000000000000000,
  0xfffffffffffffec0, 0x0000000000000000,
  0xfffffffffffffebc, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffffba, 0x0000000000000000,
  0xffffffffffffffb6, 0x0000000000000000,
  0xffffffffffffffb4, 0x0000000000000000,
  0xfffffffffffffff4, 0x0000000000000000,
  0xffffffffffffffec, 0x0000000000000000,
  0xffffffffffffffe8, 0x0000000000000000,
  0xffffffffffffffe8, 0x0000000000000000,
  0xfffffffffffffff8, 0x0000000000000000,
  0xfffffffffffffff4, 0x0000000000000000,
  0xfffffffffffffff4, 0x0000000000000000,
  0xfffffffffffffff8, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x000000000000000c, 0x0000000000000000,
  0x000000000000008c, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x000000000000000c, 0x0000000000000000,
  0x000000000000008c, 0x0000000000000000,
  0x0000000000000280, 0x0000000000000000,
  0x0000000000000008, 0x0000000000000000,
  0x0000000000000088, 0x0000000000000000,
  0x000000000000027c, 0x0000000000000000,
  0x0000000000000474, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000274, 0x0000000000000000,
  0x000000000000046c, 0x0000000000000000,
  0x0000000000000668, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x00000000000003ec, 0x0000000000000000,
  0x00000000000005e8, 0x0000000000000000,
  0x00000000000205dc, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x00000000000003f4, 0x0000000000000000,
  0x00000000000203e8, 0x0000000000000000,
  0x00000000000403e0, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x00000000000201f0, 0x0000000000000000,
  0x00000000000401e8, 0x0000000000000000,
  0x00000000000601e4, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x000000000003ffec, 0x0000000000000000,
  0x000000000005ffe8, 0x0000000000000000,
  0x00000000ccd2ccb4, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x000000000003fff4, 0x0000000000000000,
  0x00000000ccd0ccc0, 0x0000000000000000,
  0x0000000222262214, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x00000000ccceccc8, 0x0000000000000000,
  0x000000022224221c, 0x0000000000000000,
  0x0000000422242210, 0x0000000000000000,
  0x00000000cccccccc, 0x0000000000000000,
  0x0000000222222220, 0x0000000000000000,
  0x0000000422222214, 0x0000000000000000,
  0x000000062222220c, 0x0000000000000000,
  0x0000000155555554, 0x0000000000000000,
  0x0000000355555548, 0x0000000000000000,
  0x0000000555555540, 0x0000000000000000,
  0x000000075555553c, 0x0000000000000000,
  0x00000001fffffff4, 0x0000000000000000,
  0x00000003ffffffec, 0x0000000000000000,
  0x00000005ffffffe8, 0x0000000000000000,
  0x00000003ffffffe8, 0x0000000000000000,
  0x00000001fffffff8, 0x0000000000000000,
  0x00000003fffffff4, 0x0000000000000000,
  0x00000001fffffff4, 0x0000000000000000,
  0xfffffffffffffff8, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffe00000000, 0x0000000000000000,
  0xfffffffcaaaaaaa8, 0x0000000000000000,
  0xfffffffe00000000, 0x0000000000000000,
  0xfffffffc00000004, 0x0000000000000000,
  0xfffffffaaaaaaaac, 0x0000000000000000,
  0xfffffff9dddddddc, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0xfffffffcaaaaaaac, 0x0000000000000000,
  0xfffffffbdddddddc, 0x0000000000000000,
  0xfffffffbdddbdddc, 0x0000000000000000,
  0xfffffffeaaaaaaa8, 0x0000000000000000,
  0xfffffffdddddddd8, 0x0000000000000000,
  0xfffffffddddbddd8, 0x0000000000000000,
  0xfffffffdddd9dddc, 0x0000000000000000,
  0xffffffff33333330, 0x0000000000000000,
  0xffffffff33313330, 0x0000000000000000,
  0xffffffff332f3334, 0x0000000000000000,
  0xffffffff332d333c, 0x0000000000000000,
  0xfffffffffffe0000, 0x0000000000000000,
  0xfffffffffffc0004, 0x0000000000000000,
  0xfffffffffffa000c, 0x0000000000000000,
  0xfffffffffff80018, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0xfffffffffffc000c, 0x0000000000000000,
  0xfffffffffffa0018, 0x0000000000000000,
  0xfffffffffff9fe18, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0xfffffffffffc0014, 0x0000000000000000,
  0xfffffffffffbfe14, 0x0000000000000000,
  0xfffffffffffbfc18, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0xfffffffffffdfe0c, 0x0000000000000000,
  0xfffffffffffdfc10, 0x0000000000000000,
  0xfffffffffffdfa18, 0x0000000000000000,
  0xfffffffffffffe00, 0x0000000000000000,
  0xfffffffffffffc04, 0x0000000000000000,
  0xfffffffffffffa0c, 0x0000000000000000,
  0xfffffffffffff818, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0xfffffffffffffc0c, 0x0000000000000000,
  0xfffffffffffffa18, 0x0000000000000000,
  0xfffffffffffff998, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0xfffffffffffffc14, 0x0000000000000000,
  0xfffffffffffffb94, 0x0000000000000000,
  0xfffffffffffffb88, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0xfffffffffffffd8c, 0x0000000000000000,
  0xfffffffffffffd80, 0x0000000000000000,
  0xfffffffffffffd78, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff74, 0x0000000000000000,
  0xffffffffffffff6c, 0x0000000000000000,
  0xffffffffffffff68, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xfffffffffffffec0, 0x0000000000000000,
  0xfffffffffffffe80, 0x0000000000000000,
  0xfffffffffffffe80, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x00000000000000c0, 0x0000000000000000,
  0x00000000000008c0, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x00000000000000c0, 0x0000000000000000,
  0x00000000000008c0, 0x0000000000000000,
  0x0000000000002800, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000880, 0x0000000000000000,
  0x00000000000027c0, 0x0000000000000000,
  0x0000000000004740, 0x0000000000000000,
  0x0000000000000800, 0x0000000000000000,
  0x0000000000002740, 0x0000000000000000,
  0x00000000000046c0, 0x0000000000000000,
  0x0000000000006680, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x0000000000003ec0, 0x0000000000000000,
  0x0000000000005e80, 0x0000000000000000,
  0x0000000000205dc0, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x0000000000003f40, 0x0000000000000000,
  0x0000000000203e80, 0x0000000000000000,
  0x0000000000403e00, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x0000000000201f00, 0x0000000000000000,
  0x0000000000401e80, 0x0000000000000000,
  0x0000000000601e40, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x00000000003ffec0, 0x0000000000000000,
  0x00000000005ffe80, 0x0000000000000000,
  0x0000000ccd2ccb40, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x00000000003fff40, 0x0000000000000000,
  0x0000000ccd0ccc00, 0x0000000000000000,
  0x0000002222622140, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x0000000ccceccc80, 0x0000000000000000,
  0x00000022224221c0, 0x0000000000000000,
  0x0000004222422100, 0x0000000000000000,
  0x0000000cccccccc0, 0x0000000000000000,
  0x0000002222222200, 0x0000000000000000,
  0x0000004222222140, 0x0000000000000000,
  0x00000062222220c0, 0x0000000000000000,
  0x0000001555555540, 0x0000000000000000,
  0x0000003555555480, 0x0000000000000000,
  0x0000005555555400, 0x0000000000000000,
  0x00000075555553c0, 0x0000000000000000,
  0x0000001fffffff40, 0x0000000000000000,
  0x0000003ffffffec0, 0x0000000000000000,
  0x0000005ffffffe80, 0x0000000000000000,
  0x0000003ffffffe80, 0x0000000000000000,
  0x0000001fffffff80, 0x0000000000000000,
  0x0000003fffffff40, 0x0000000000000000,
  0x0000001fffffff40, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffe000000000, 0x0000000000000000,
  0xffffffcaaaaaaa80, 0x0000000000000000,
  0xffffffe000000000, 0x0000000000000000,
  0xffffffc000000040, 0x0000000000000000,
  0xffffffaaaaaaaac0, 0x0000000000000000,
  0xffffff9dddddddc0, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0xffffffcaaaaaaac0, 0x0000000000000000,
  0xffffffbdddddddc0, 0x0000000000000000,
  0xffffffbdddbdddc0, 0x0000000000000000,
  0xffffffeaaaaaaa80, 0x0000000000000000,
  0xffffffdddddddd80, 0x0000000000000000,
  0xffffffddddbddd80, 0x0000000000000000,
  0xffffffdddd9dddc0, 0x0000000000000000,
  0xfffffff333333300, 0x0000000000000000,
  0xfffffff333133300, 0x0000000000000000,
  0xfffffff332f33340, 0x0000000000000000,
  0xfffffff332d333c0, 0x0000000000000000,
  0xffffffffffe00000, 0x0000000000000000,
  0xffffffffffc00040, 0x0000000000000000,
  0xffffffffffa000c0, 0x0000000000000000,
  0xffffffffff800180, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xffffffffffc000c0, 0x0000000000000000,
  0xffffffffffa00180, 0x0000000000000000,
  0xffffffffff9fe180, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xffffffffffc00140, 0x0000000000000000,
  0xffffffffffbfe140, 0x0000000000000000,
  0xffffffffffbfc180, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xffffffffffdfe0c0, 0x0000000000000000,
  0xffffffffffdfc100, 0x0000000000000000,
  0xffffffffffdfa180, 0x0000000000000000,
  0xffffffffffffe000, 0x0000000000000000,
  0xffffffffffffc040, 0x0000000000000000,
  0xffffffffffffa0c0, 0x0000000000000000,
  0xffffffffffff8180, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xffffffffffffc0c0, 0x0000000000000000,
  0xffffffffffffa180, 0x0000000000000000,
  0xffffffffffff9980, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xffffffffffffc140, 0x0000000000000000,
  0xffffffffffffb940, 0x0000000000000000,
  0xffffffffffffb880, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xffffffffffffd8c0, 0x0000000000000000,
  0xffffffffffffd800, 0x0000000000000000,
  0xffffffffffffd780, 0x0000000000000000,
  0xfffffffffffff800, 0x0000000000000000,
  0xfffffffffffff740, 0x0000000000000000,
  0xfffffffffffff6c0, 0x0000000000000000,
  0xfffffffffffff680, 0x0000000000000000,
  0xfffffffffffffd12, 0x0000000000000000,
  0xfffffffffffffb1e, 0x0000000000000000,
  0xfffffffffffffa24, 0x0000000000000000,
  0xfffffffffffffa24, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0xfffffffffffffd12, 0x0000000000000000,
  0xfffffffffffffd12, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000002ee, 0x0000000000000000,
  0x000000000000222e, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000002ee, 0x0000000000000000,
  0x000000000000222e, 0x0000000000000000,
  0x0000000000009c40, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x0000000000002134, 0x0000000000000000,
  0x0000000000009b46, 0x0000000000000000,
  0x0000000000011652, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x0000000000009952, 0x0000000000000000,
  0x000000000001145e, 0x0000000000000000,
  0x0000000000019064, 0x0000000000000000,
  0x0000000000007a12, 0x0000000000000000,
  0x000000000000f51e, 0x0000000000000000,
  0x0000000000017124, 0x0000000000000000,
  0x00000000007e6e36, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x000000000000f712, 0x0000000000000000,
  0x00000000007df424, 0x0000000000000000,
  0x0000000000faf230, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x00000000007d7918, 0x0000000000000000,
  0x0000000000fa7724, 0x0000000000000000,
  0x000000000177762a, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x0000000000f9fb1e, 0x0000000000000000,
  0x000000000176fa24, 0x0000000000000000,
  0x000000320176f9f2, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x0000000000f9fd12, 0x0000000000000000,
  0x0000003200f9fce0, 0x0000000000000000,
  0x00000085564f51e2, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x00000032007cfed4, 0x0000000000000000,
  0x0000008555d253d6, 0x0000000000000000,
  0x0000010255d250e8, 0x0000000000000000,
  0x00000031ffffffce, 0x0000000000000000,
  0x00000085555554d0, 0x0000000000000000,
  0x00000102555551e2, 0x0000000000000000,
  0x0000017f55554fee, 0x0000000000000000,
  0x0000005355555502, 0x0000000000000000,
  0x000000d055555214, 0x0000000000000000,
  0x0000014d55555020, 0x0000000000000000,
  0x000001ca55554f26, 0x0000000000000000,
  0x0000007cfffffd12, 0x0000000000000000,
  0x000000f9fffffb1e, 0x0000000000000000,
  0x00000176fffffa24, 0x0000000000000000,
  0x000000f9fffffa24, 0x0000000000000000,
  0x0000007cfffffe0c, 0x0000000000000000,
  0x000000f9fffffd12, 0x0000000000000000,
  0x0000007cfffffd12, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xffffff8300000000, 0x0000000000000000,
  0xffffff2faaaaaa04, 0x0000000000000000,
  0xffffff8300000000, 0x0000000000000000,
  0xffffff06000000fa, 0x0000000000000000,
  0xfffffeb2aaaaaafe, 0x0000000000000000,
  0xfffffe80aaaaaa36, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0xffffff2faaaaaafe, 0x0000000000000000,
  0xfffffefdaaaaaa36, 0x0000000000000000,
  0xfffffefdaa2daa36, 0x0000000000000000,
  0xffffffacaaaaaa04, 0x0000000000000000,
  0xffffff7aaaaaa93c, 0x0000000000000000,
  0xffffff7aaa2da93c, 0x0000000000000000,
  0xffffff7aa9b0aa36, 0x0000000000000000,
  0xffffffcdffffff38, 0x0000000000000000,
  0xffffffcdff82ff38, 0x0000000000000000,
  0xffffffcdff060032, 0x0000000000000000,
  0xffffffcdfe890226, 0x0000000000000000,
  0xffffffffff830000, 0x0000000000000000,
  0xffffffffff0600fa, 0x0000000000000000,
  0xfffffffffe8902ee, 0x0000000000000000,
  0xfffffffffe0c05dc, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffffff0602ee, 0x0000000000000000,
  0xfffffffffe8905dc, 0x0000000000000000,
  0xfffffffffe8888dc, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffff0604e2, 0x0000000000000000,
  0xffffffffff0587e2, 0x0000000000000000,
  0xffffffffff050bdc, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffff8285ee, 0x0000000000000000,
  0xffffffffff8209e8, 0x0000000000000000,
  0xffffffffff818edc, 0x0000000000000000,
  0xffffffffffff8300, 0x0000000000000000,
  0xffffffffffff06fa, 0x0000000000000000,
  0xfffffffffffe8bee, 0x0000000000000000,
  0xfffffffffffe11dc, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffffff08ee, 0x0000000000000000,
  0xfffffffffffe8edc, 0x0000000000000000,
  0xfffffffffffe6f9c, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffff0ae2, 0x0000000000000000,
  0xfffffffffffeeba2, 0x0000000000000000,
  0xfffffffffffee8b4, 0x0000000000000000,
  0xffffffffffff85ee, 0x0000000000000000,
  0xffffffffffff66ae, 0x0000000000000000,
  0xffffffffffff63c0, 0x0000000000000000,
  0xffffffffffff61cc, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xffffffffffffddd2, 0x0000000000000000,
  0xffffffffffffdbde, 0x0000000000000000,
  0xffffffffffffdae4, 0x0000000000000000,
  0xfffffffffffffd0c, 0x0000000000000000,
  0xfffffffffffffb14, 0x0000000000000000,
  0xfffffffffffffa18, 0x0000000000000000,
  0xfffffffffffffa18, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0xfffffffffffffd0c, 0x0000000000000000,
  0xfffffffffffffd0c, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000002f4, 0x0000000000000000,
  0x0000000000002274, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000002f4, 0x0000000000000000,
  0x0000000000002274, 0x0000000000000000,
  0x0000000000009d80, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x0000000000002178, 0x0000000000000000,
  0x0000000000009c84, 0x0000000000000000,
  0x000000000001188c, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x0000000000009a8c, 0x0000000000000000,
  0x0000000000011694, 0x0000000000000000,
  0x0000000000019398, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x000000000000f714, 0x0000000000000000,
  0x0000000000017418, 0x0000000000000000,
  0x00000000007f7124, 0x0000000000000000,
  0x0000000000007c08, 0x0000000000000000,
  0x000000000000f90c, 0x0000000000000000,
  0x00000000007ef618, 0x0000000000000000,
  0x0000000000fcf420, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x00000000007e7a10, 0x0000000000000000,
  0x0000000000fc7818, 0x0000000000000000,
  0x00000000017a771c, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x0000000000fbfb14, 0x0000000000000000,
  0x000000000179fa18, 0x0000000000000000,
  0x0000003267e0604c, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x0000000000fbfd0c, 0x0000000000000000,
  0x0000003267626340, 0x0000000000000000,
  0x00000086676262ec, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x0000003266e46538, 0x0000000000000000,
  0x0000008666e464e4, 0x0000000000000000,
  0x0000010466e461f0, 0x0000000000000000,
  0x0000003266666634, 0x0000000000000000,
  0x00000086666665e0, 0x0000000000000000,
  0x00000104666662ec, 0x0000000000000000,
  0x00000182666660f4, 0x0000000000000000,
  0x00000053ffffffac, 0x0000000000000000,
  0x000000d1fffffcb8, 0x0000000000000000,
  0x0000014ffffffac0, 0x0000000000000000,
  0x000001cdfffff9c4, 0x0000000000000000,
  0x0000007dfffffd0c, 0x0000000000000000,
  0x000000fbfffffb14, 0x0000000000000000,
  0x00000179fffffa18, 0x0000000000000000,
  0x000000fbfffffa18, 0x0000000000000000,
  0x0000007dfffffe08, 0x0000000000000000,
  0x000000fbfffffd0c, 0x0000000000000000,
  0x0000007dfffffd0c, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xffffff8200000000, 0x0000000000000000,
  0xffffff2dffffff58, 0x0000000000000000,
  0xffffff8200000000, 0x0000000000000000,
  0xffffff04000000fc, 0x0000000000000000,
  0xfffffeb000000054, 0x0000000000000000,
  0xfffffe7d99999924, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0xffffff2e00000054, 0x0000000000000000,
  0xfffffefb99999924, 0x0000000000000000,
  0xfffffefb991b9924, 0x0000000000000000,
  0xffffffabffffff58, 0x0000000000000000,
  0xffffff7999999828, 0x0000000000000000,
  0xffffff79991b9828, 0x0000000000000000,
  0xffffff79989d9924, 0x0000000000000000,
  0xffffffcd999998d0, 0x0000000000000000,
  0xffffffcd991b98d0, 0x0000000000000000,
  0xffffffcd989d99cc, 0x0000000000000000,
  0xffffffcd981f9bc4, 0x0000000000000000,
  0xffffffffff820000, 0x0000000000000000,
  0xffffffffff0400fc, 0x0000000000000000,
  0xfffffffffe8602f4, 0x0000000000000000,
  0xfffffffffe0805e8, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffffff0402f4, 0x0000000000000000,
  0xfffffffffe8605e8, 0x0000000000000000,
  0xfffffffffe8587e8, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff0404ec, 0x0000000000000000,
  0xffffffffff0386ec, 0x0000000000000000,
  0xffffffffff0309e8, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffff8184f4, 0x0000000000000000,
  0xffffffffff8107f0, 0x0000000000000000,
  0xffffffffff808be8, 0x0000000000000000,
  0xffffffffffff8200, 0x0000000000000000,
  0xffffffffffff04fc, 0x0000000000000000,
  0xfffffffffffe88f4, 0x0000000000000000,
  0xfffffffffffe0de8, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffffff06f4, 0x0000000000000000,
  0xfffffffffffe8be8, 0x0000000000000000,
  0xfffffffffffe6c68, 0x0000000000000000,
  0xffffffffffff83f8, 0x0000000000000000,
  0xffffffffffff08ec, 0x0000000000000000,
  0xfffffffffffee96c, 0x0000000000000000,
  0xfffffffffffee678, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffff6574, 0x0000000000000000,
  0xffffffffffff6280, 0x0000000000000000,
  0xffffffffffff6088, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xffffffffffffdd8c, 0x0000000000000000,
  0xffffffffffffdb94, 0x0000000000000000,
  0xffffffffffffda98, 0x0000000000000000,
  0xfffffffffffffd06, 0x0000000000000000,
  0xfffffffffffffb0a, 0x0000000000000000,
  0xfffffffffffffa0c, 0x0000000000000000,
  0xfffffffffffffa0c, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0xfffffffffffffd06, 0x0000000000000000,
  0xfffffffffffffd06, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x00000000000002fa, 0x0000000000000000,
  0x00000000000022ba, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x00000000000002fa, 0x0000000000000000,
  0x00000000000022ba, 0x0000000000000000,
  0x0000000000009ec0, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x00000000000021bc, 0x0000000000000000,
  0x0000000000009dc2, 0x0000000000000000,
  0x0000000000011ac6, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x0000000000009bc6, 0x0000000000000000,
  0x00000000000118ca, 0x0000000000000000,
  0x00000000000196cc, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x000000000000f90a, 0x0000000000000000,
  0x000000000001770c, 0x0000000000000000,
  0x0000000000807412, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x000000000000fb06, 0x0000000000000000,
  0x00000000007ff80c, 0x0000000000000000,
  0x0000000000fef610, 0x0000000000000000,
  0x0000000000007e02, 0x0000000000000000,
  0x00000000007f7b08, 0x0000000000000000,
  0x0000000000fe790c, 0x0000000000000000,
  0x00000000017d780e, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x0000000000fdfb0a, 0x0000000000000000,
  0x00000000017cfa0c, 0x0000000000000000,
  0x00000032ce49c6a6, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x0000000000fdfd06, 0x0000000000000000,
  0x00000032cdcac9a0, 0x0000000000000000,
  0x00000087787573f6, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x00000032cd4bcb9c, 0x0000000000000000,
  0x0000008777f675f2, 0x0000000000000000,
  0x0000010677f672f8, 0x0000000000000000,
  0x00000032cccccc9a, 0x0000000000000000,
  0x00000087777776f0, 0x0000000000000000,
  0x00000106777773f6, 0x0000000000000000,
  0x00000185777771fa, 0x0000000000000000,
  0x00000054aaaaaa56, 0x0000000000000000,
  0x000000d3aaaaa75c, 0x0000000000000000,
  0x00000152aaaaa560, 0x0000000000000000,
  0x000001d1aaaaa462, 0x0000000000000000,
  0x0000007efffffd06, 0x0000000000000000,
  0x000000fdfffffb0a, 0x0000000000000000,
  0x0000017cfffffa0c, 0x0000000000000000,
  0x000000fdfffffa0c, 0x0000000000000000,
  0x0000007efffffe04, 0x0000000000000000,
  0x000000fdfffffd06, 0x0000000000000000,
  0x0000007efffffd06, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xffffff8100000000, 0x0000000000000000,
  0xffffff2c555554ac, 0x0000000000000000,
  0xffffff8100000000, 0x0000000000000000,
  0xffffff02000000fe, 0x0000000000000000,
  0xfffffead555555aa, 0x0000000000000000,
  0xfffffe7a88888812, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0xffffff2c555555aa, 0x0000000000000000,
  0xfffffef988888812, 0x0000000000000000,
  0xfffffef988098812, 0x0000000000000000,
  0xffffffab555554ac, 0x0000000000000000,
  0xffffff7888888714, 0x0000000000000000,
  0xffffff7888098714, 0x0000000000000000,
  0xffffff78878a8812, 0x0000000000000000,
  0xffffffcd33333268, 0x0000000000000000,
  0xffffffcd32b43268, 0x0000000000000000,
  0xffffffcd32353366, 0x0000000000000000,
  0xffffffcd31b63562, 0x0000000000000000,
  0xffffffffff810000, 0x0000000000000000,
  0xffffffffff0200fe, 0x0000000000000000,
  0xfffffffffe8302fa, 0x0000000000000000,
  0xfffffffffe0405f4, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffffff0202fa, 0x0000000000000000,
  0xfffffffffe8305f4, 0x0000000000000000,
  0xfffffffffe8286f4, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffffff0204f6, 0x0000000000000000,
  0xffffffffff0185f6, 0x0000000000000000,
  0xffffffffff0107f4, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffffff8083fa, 0x0000000000000000,
  0xffffffffff8005f8, 0x0000000000000000,
  0xffffffffff7f88f4, 0x0000000000000000,
  0xffffffffffff8100, 0x0000000000000000,
  0xffffffffffff02fe, 0x0000000000000000,
  0xfffffffffffe85fa, 0x0000000000000000,
  0xfffffffffffe09f4, 0x0000000000000000,
  0xffffffffffff81fe, 0x0000000000000000,
  0xffffffffffff04fa, 0x0000000000000000,
  0xfffffffffffe88f4, 0x0000000000000000,
  0xfffffffffffe6934, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffffff06f6, 0x0000000000000000,
  0xfffffffffffee736, 0x0000000000000000,
  0xfffffffffffee43c, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffffff643a, 0x0000000000000000,
  0xffffffffffff6140, 0x0000000000000000,
  0xffffffffffff5f44, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xffffffffffffdd46, 0x0000000000000000,
  0xffffffffffffdb4a, 0x0000000000000000,
  0xffffffffffffda4c, 0x0000000000000000,
  0xfffffffffffd0012, 0x0000000000000000,
  0xfffffffffffb001e, 0x0000000000000000,
  0xfffffffffffa0024, 0x0000000000000000,
  0xfffffffffffa0024, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0xfffffffffffd0012, 0x0000000000000000,
  0xfffffffffffd0012, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x000000000002ffee, 0x0000000000000000,
  0x000000000022ff2e, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x000000000002ffee, 0x0000000000000000,
  0x000000000022ff2e, 0x0000000000000000,
  0x00000000009ffc40, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x000000000021ff34, 0x0000000000000000,
  0x00000000009efc46, 0x0000000000000000,
  0x00000000011cf952, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x00000000009cfc52, 0x0000000000000000,
  0x00000000011af95e, 0x0000000000000000,
  0x000000000199f664, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x0000000000fafa1e, 0x0000000000000000,
  0x000000000179f724, 0x0000000000000000,
  0x000000008173f736, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x0000000000fcfa12, 0x0000000000000000,
  0x0000000080f6fa24, 0x0000000000000000,
  0x0000000100f1fa30, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x000000008078fd18, 0x0000000000000000,
  0x000000010073fd24, 0x0000000000000000,
  0x00000001806ffd2a, 0x0000000000000000,
  0x000000007ffa0012, 0x0000000000000000,
  0x00000000fff5001e, 0x0000000000000000,
  0x000000017ff10024, 0x0000000000000000,
  0x000033337ff0ccf2, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x00000000fff70012, 0x0000000000000000,
  0x00003332fff6cce0, 0x0000000000000000,
  0x00008886554bcce2, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x000033327ffbccd4, 0x0000000000000000,
  0x00008885d550ccd6, 0x0000000000000000,
  0x00010882d54dcce8, 0x0000000000000000,
  0x00003331ffffccce, 0x0000000000000000,
  0x000088855554ccd0, 0x0000000000000000,
  0x000108825551cce2, 0x0000000000000000,
  0x0001887f554fccee, 0x0000000000000000,
  0x0000555355550002, 0x0000000000000000,
  0x0000d55055520014, 0x0000000000000000,
  0x0001554d55500020, 0x0000000000000000,
  0x0001d54a554f0026, 0x0000000000000000,
  0x00007ffcfffd0012, 0x0000000000000000,
  0x0000fff9fffb001e, 0x0000000000000000,
  0x00017ff6fffa0024, 0x0000000000000000,
  0x0000fff9fffa0024, 0x0000000000000000,
  0x00007ffcfffe000c, 0x0000000000000000,
  0x0000fff9fffd0012, 0x0000000000000000,
  0x00007ffcfffd0012, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xffff800300000000, 0x0000000000000000,
  0xffff2aafaaaa0004, 0x0000000000000000,
  0xffff800300000000, 0x0000000000000000,
  0xffff00060000fffa, 0x0000000000000000,
  0xfffeaab2aaaafffe, 0x0000000000000000,
  0xfffe7780aaaa3336, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0xffff2aafaaaafffe, 0x0000000000000000,
  0xfffef77daaaa3336, 0x0000000000000000,
  0xfffef77d2aad3336, 0x0000000000000000,
  0xffffaaacaaaa0004, 0x0000000000000000,
  0xffff777aaaa9333c, 0x0000000000000000,
  0xffff777a2aac333c, 0x0000000000000000,
  0xffff7779aab03336, 0x0000000000000000,
  0xffffcccdffff3338, 0x0000000000000000,
  0xffffcccd80023338, 0x0000000000000000,
  0xffffcccd00063332, 0x0000000000000000,
  0xffffcccc800b3326, 0x0000000000000000,
  0xffffffff80030000, 0x0000000000000000,
  0xffffffff0006fffa, 0x0000000000000000,
  0xfffffffe800bffee, 0x0000000000000000,
  0xfffffffe0011ffdc, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffffff0008ffee, 0x0000000000000000,
  0xfffffffe800effdc, 0x0000000000000000,
  0xfffffffe7f8f02dc, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffff000affe2, 0x0000000000000000,
  0xfffffffeff8b02e2, 0x0000000000000000,
  0xfffffffeff0c05dc, 0x0000000000000000,
  0xffffffff8005ffee, 0x0000000000000000,
  0xffffffff7f8602ee, 0x0000000000000000,
  0xffffffff7f0705e8, 0x0000000000000000,
  0xffffffff7e8908dc, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0xffffffffff0105fa, 0x0000000000000000,
  0xfffffffffe8308ee, 0x0000000000000000,
  0xfffffffffe060bdc, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffffff0305ee, 0x0000000000000000,
  0xfffffffffe8608dc, 0x0000000000000000,
  0xfffffffffe66099c, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffff0505e2, 0x0000000000000000,
  0xfffffffffee506a2, 0x0000000000000000,
  0xfffffffffee206b4, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffff6303ae, 0x0000000000000000,
  0xffffffffff6003c0, 0x0000000000000000,
  0xffffffffff5e03cc, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xffffffffffdd00d2, 0x0000000000000000,
  0xffffffffffdb00de, 0x0000000000000000,
  0xffffffffffda00e4, 0x0000000000000000,
  0xfffffffffffd000c, 0x0000000000000000,
  0xfffffffffffb0014, 0x0000000000000000,
  0xfffffffffffa0018, 0x0000000000000000,
  0xfffffffffffa0018, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0xfffffffffffd000c, 0x0000000000000000,
  0xfffffffffffd000c, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000002fff4, 0x0000000000000000,
  0x000000000022ff74, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000002fff4, 0x0000000000000000,
  0x000000000022ff74, 0x0000000000000000,
  0x00000000009ffd80, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x000000000021ff78, 0x0000000000000000,
  0x00000000009efd84, 0x0000000000000000,
  0x00000000011cfb8c, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x00000000009cfd8c, 0x0000000000000000,
  0x00000000011afb94, 0x0000000000000000,
  0x000000000199f998, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x0000000000fafc14, 0x0000000000000000,
  0x000000000179fa18, 0x0000000000000000,
  0x000000008174fa24, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x0000000000fcfc0c, 0x0000000000000000,
  0x0000000080f7fc18, 0x0000000000000000,
  0x0000000100f3fc20, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x000000008079fe10, 0x0000000000000000,
  0x000000010075fe18, 0x0000000000000000,
  0x000000018072fe1c, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x00000000fff70014, 0x0000000000000000,
  0x000000017ff40018, 0x0000000000000000,
  0x00003333e65a334c, 0x0000000000000000,
  0x000000007ffc0008, 0x0000000000000000,
  0x00000000fff9000c, 0x0000000000000000,
  0x00003333665f3340, 0x0000000000000000,
  0x00008887665eddec, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x00003332e6633338, 0x0000000000000000,
  0x00008886e662dde4, 0x0000000000000000,
  0x00010884e65fddf0, 0x0000000000000000,
  0x0000333266663334, 0x0000000000000000,
  0x000088866665dde0, 0x0000000000000000,
  0x000108846662ddec, 0x0000000000000000,
  0x000188826660ddf4, 0x0000000000000000,
  0x00005553ffffaaac, 0x0000000000000000,
  0x0000d551fffcaab8, 0x0000000000000000,
  0x0001554ffffaaac0, 0x0000000000000000,
  0x0001d54dfff9aac4, 0x0000000000000000,
  0x00007ffdfffd000c, 0x0000000000000000,
  0x0000fffbfffb0014, 0x0000000000000000,
  0x00017ff9fffa0018, 0x0000000000000000,
  0x0000fffbfffa0018, 0x0000000000000000,
  0x00007ffdfffe0008, 0x0000000000000000,
  0x0000fffbfffd000c, 0x0000000000000000,
  0x00007ffdfffd000c, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xffff800200000000, 0x0000000000000000,
  0xffff2aadffff5558, 0x0000000000000000,
  0xffff800200000000, 0x0000000000000000,
  0xffff00040000fffc, 0x0000000000000000,
  0xfffeaab000005554, 0x0000000000000000,
  0xfffe777d99992224, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0xffff2aae00005554, 0x0000000000000000,
  0xfffef77b99992224, 0x0000000000000000,
  0xfffef77b199b2224, 0x0000000000000000,
  0xffffaaabffff5558, 0x0000000000000000,
  0xffff777999982228, 0x0000000000000000,
  0xffff7779199a2228, 0x0000000000000000,
  0xffff7778999d2224, 0x0000000000000000,
  0xffffcccd9998ccd0, 0x0000000000000000,
  0xffffcccd199accd0, 0x0000000000000000,
  0xffffcccc999dcccc, 0x0000000000000000,
  0xffffcccc19a1ccc4, 0x0000000000000000,
  0xffffffff80020000, 0x0000000000000000,
  0xffffffff0004fffc, 0x0000000000000000,
  0xfffffffe8008fff4, 0x0000000000000000,
  0xfffffffe000dffe8, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffffff0006fff4, 0x0000000000000000,
  0xfffffffe800bffe8, 0x0000000000000000,
  0xfffffffe7f8c01e8, 0x0000000000000000,
  0xffffffff8003fff8, 0x0000000000000000,
  0xffffffff0008ffec, 0x0000000000000000,
  0xfffffffeff8901ec, 0x0000000000000000,
  0xfffffffeff0a03e8, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffff7f8501f4, 0x0000000000000000,
  0xffffffff7f0603f0, 0x0000000000000000,
  0xffffffff7e8805e8, 0x0000000000000000,
  0xffffffffff800200, 0x0000000000000000,
  0xffffffffff0103fc, 0x0000000000000000,
  0xfffffffffe8305f4, 0x0000000000000000,
  0xfffffffffe0607e8, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffffff0303f4, 0x0000000000000000,
  0xfffffffffe8605e8, 0x0000000000000000,
  0xfffffffffe660668, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff0503ec, 0x0000000000000000,
  0xfffffffffee5046c, 0x0000000000000000,
  0xfffffffffee20478, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffff630274, 0x0000000000000000,
  0xffffffffff600280, 0x0000000000000000,
  0xffffffffff5e0288, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xffffffffffdd008c, 0x0000000000000000,
  0xffffffffffdb0094, 0x0000000000000000,
  0xffffffffffda0098, 0x0000000000000000,
  0xfffffffffffd0006, 0x0000000000000000,
  0xfffffffffffb000a, 0x0000000000000000,
  0xfffffffffffa000c, 0x0000000000000000,
  0xfffffffffffa000c, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0xfffffffffffd0006, 0x0000000000000000,
  0xfffffffffffd0006, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x000000000002fffa, 0x0000000000000000,
  0x000000000022ffba, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x000000000002fffa, 0x0000000000000000,
  0x000000000022ffba, 0x0000000000000000,
  0x00000000009ffec0, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x000000000021ffbc, 0x0000000000000000,
  0x00000000009efec2, 0x0000000000000000,
  0x00000000011cfdc6, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x00000000009cfec6, 0x0000000000000000,
  0x00000000011afdca, 0x0000000000000000,
  0x000000000199fccc, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x0000000000fafe0a, 0x0000000000000000,
  0x000000000179fd0c, 0x0000000000000000,
  0x000000008175fd12, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x0000000000fcfe06, 0x0000000000000000,
  0x0000000080f8fe0c, 0x0000000000000000,
  0x0000000100f5fe10, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x00000000807aff08, 0x0000000000000000,
  0x000000010077ff0c, 0x0000000000000000,
  0x000000018075ff0e, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x00000000fff9000a, 0x0000000000000000,
  0x000000017ff7000c, 0x0000000000000000,
  0x000033344cc399a6, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x00000000fffb0006, 0x0000000000000000,
  0x00003333ccc799a0, 0x0000000000000000,
  0x000088887771eef6, 0x0000000000000000,
  0x000000007ffe0002, 0x0000000000000000,
  0x000033334cca999c, 0x0000000000000000,
  0x00008887f774eef2, 0x0000000000000000,
  0x00010886f771eef8, 0x0000000000000000,
  0x00003332cccc999a, 0x0000000000000000,
  0x000088877776eef0, 0x0000000000000000,
  0x000108867773eef6, 0x0000000000000000,
  0x000188857771eefa, 0x0000000000000000,
  0x00005554aaaa5556, 0x0000000000000000,
  0x0000d553aaa7555c, 0x0000000000000000,
  0x00015552aaa55560, 0x0000000000000000,
  0x0001d551aaa45562, 0x0000000000000000,
  0x00007ffefffd0006, 0x0000000000000000,
  0x0000fffdfffb000a, 0x0000000000000000,
  0x00017ffcfffa000c, 0x0000000000000000,
  0x0000fffdfffa000c, 0x0000000000000000,
  0x00007ffefffe0004, 0x0000000000000000,
  0x0000fffdfffd0006, 0x0000000000000000,
  0x00007ffefffd0006, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xffff800100000000, 0x0000000000000000,
  0xffff2aac5554aaac, 0x0000000000000000,
  0xffff800100000000, 0x0000000000000000,
  0xffff00020000fffe, 0x0000000000000000,
  0xfffeaaad5555aaaa, 0x0000000000000000,
  0xfffe777a88881112, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0xffff2aac5555aaaa, 0x0000000000000000,
  0xfffef77988881112, 0x0000000000000000,
  0xfffef77908891112, 0x0000000000000000,
  0xffffaaab5554aaac, 0x0000000000000000,
  0xffff777888871114, 0x0000000000000000,
  0xffff777808881114, 0x0000000000000000,
  0xffff7777888a1112, 0x0000000000000000,
  0xffffcccd33326668, 0x0000000000000000,
  0xffffccccb3336668, 0x0000000000000000,
  0xffffcccc33356666, 0x0000000000000000,
  0xffffcccbb3386662, 0x0000000000000000,
  0xffffffff80010000, 0x0000000000000000,
  0xffffffff0002fffe, 0x0000000000000000,
  0xfffffffe8005fffa, 0x0000000000000000,
  0xfffffffe0009fff4, 0x0000000000000000,
  0xffffffff8001fffe, 0x0000000000000000,
  0xffffffff0004fffa, 0x0000000000000000,
  0xfffffffe8008fff4, 0x0000000000000000,
  0xfffffffe7f8900f4, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffffff0006fff6, 0x0000000000000000,
  0xfffffffeff8700f6, 0x0000000000000000,
  0xfffffffeff0801f4, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffffff7f8400fa, 0x0000000000000000,
  0xffffffff7f0501f8, 0x0000000000000000,
  0xffffffff7e8702f4, 0x0000000000000000,
  0xffffffffff800100, 0x0000000000000000,
  0xffffffffff0101fe, 0x0000000000000000,
  0xfffffffffe8302fa, 0x0000000000000000,
  0xfffffffffe0603f4, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffffff0301fa, 0x0000000000000000,
  0xfffffffffe8602f4, 0x0000000000000000,
  0xfffffffffe660334, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffffff0501f6, 0x0000000000000000,
  0xfffffffffee50236, 0x0000000000000000,
  0xfffffffffee2023c, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffffff63013a, 0x0000000000000000,
  0xffffffffff600140, 0x0000000000000000,
  0xffffffffff5e0144, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xffffffffffdd0046, 0x0000000000000000,
  0xffffffffffdb004a, 0x0000000000000000,
  0xffffffffffda004c, 0x0000000000000000,
  0xfffffffeccccccce, 0x0000000000000000,
  0xfffffffe00000002, 0x0000000000000000,
  0xfffffffd9999999c, 0x0000000000000000,
  0xfffffffd9999999c, 0x0000000000000000,
  0xffffffff33333334, 0x0000000000000000,
  0xfffffffeccccccce, 0x0000000000000000,
  0xfffffffeccccccce, 0x0000000000000000,
  0xffffffff33333334, 0x0000000000000000,
  0xffffffff9999999a, 0x0000000000000000,
  0xffffffff9999999a, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000cccccccc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000066666666, 0x0000000000000000,
  0x0000000133333332, 0x0000000000000000,
  0x0000000dfffffff2, 0x0000000000000000,
  0x0000000066666666, 0x0000000000000000,
  0x0000000133333332, 0x0000000000000000,
  0x0000000dfffffff2, 0x0000000000000000,
  0x0000003fffffffc0, 0x0000000000000000,
  0x00000000cccccccc, 0x0000000000000000,
  0x0000000d9999998c, 0x0000000000000000,
  0x0000003f9999995a, 0x0000000000000000,
  0x00000071ffffff8e, 0x0000000000000000,
  0x0000000cccccccc0, 0x0000000000000000,
  0x0000003ecccccc8e, 0x0000000000000000,
  0x00000071333332c2, 0x0000000000000000,
  0x000000a3ffffff5c, 0x0000000000000000,
  0x00000031ffffffce, 0x0000000000000000,
  0x0000006466666602, 0x0000000000000000,
  0x000000973333329c, 0x0000000000000000,
  0x000033c93332ff6a, 0x0000000000000000,
  0x0000003266666634, 0x0000000000000000,
  0x00000065333332ce, 0x0000000000000000,
  0x000033973332ff9c, 0x0000000000000000,
  0x000066c9999932d0, 0x0000000000000000,
  0x00000032cccccc9a, 0x0000000000000000,
  0x00003364cccc9968, 0x0000000000000000,
  0x000066973332cc9c, 0x0000000000000000,
  0x000099c9ffff6636, 0x0000000000000000,
  0x00003331ffffccce, 0x0000000000000000,
  0x0000666466660002, 0x0000000000000000,
  0x000099973332999c, 0x0000000000000000,
  0x147b7adeb85151ee, 0x0000000000000000,
  0x0000333266663334, 0x0000000000000000,
  0x000066653332ccce, 0x0000000000000000,
  0x147b47acb8518520, 0x0000000000000000,
  0x369d69ce962f62fe, 0x0000000000000000,
  0x00003332cccc999a, 0x0000000000000000,
  0x147b147a51eb51ec, 0x0000000000000000,
  0x369d369c2fc92fca, 0x0000000000000000,
  0x69d069cdfc95fc98, 0x0000000000000000,
  0x147ae147851eb852, 0x0000000000000000,
  0x369d036962fc9630, 0x0000000000000000,
  0x69d0369b2fc962fe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x22222221ddddddde, 0x0000000000000000,
  0x55555553aaaaaaac, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x33333331ccccccce, 0x0000000000000000,
  0x6666666400000002, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x4cccccccffffffff, 0x0000000000000000,
  0x3333333233333334, 0x0000000000000000,
  0x66666664ccccccce, 0x0000000000000000,
  0x33333331ccccccce, 0x0000000000000000,
  0xffffffff33333334, 0x0000000000000000,
  0x333333329999999a, 0x0000000000000000,
  0xffffffff9999999a, 0x0000000000000000,
  0xcccccccd00000000, 0x0000000000000000,
  0xaaaaaaaabbbbbbbc, 0x0000000000000000,
  0xcccccccd00000000, 0x0000000000000000,
  0x9999999a66666666, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xcccccccd66666666, 0x0000000000000000,
  0xaaaaaaab22222222, 0x0000000000000000,
  0x962fc963369d036a, 0x0000000000000000,
  0x962f9630036a036a, 0x0000000000000000,
  0xddddddddbbbbbbbc, 0x0000000000000000,
  0xc962fc95d0369d04, 0x0000000000000000,
  0xc962c9629d039d04, 0x0000000000000000,
  0xc962962fd037036a, 0x0000000000000000,
  0xeb851eb8147ae148, 0x0000000000000000,
  0xeb84eb84e147e148, 0x0000000000000000,
  0xeb84b852147b47ae, 0x0000000000000000,
  0xeb84851fae15147a, 0x0000000000000000,
  0xffffcccccccd0000, 0x0000000000000000,
  0xffff999a00006666, 0x0000000000000000,
  0xffff6667999a3332, 0x0000000000000000,
  0xffff3335999a6664, 0x0000000000000000,
  0xffffcccd33336666, 0x0000000000000000,
  0xffff999acccd3332, 0x0000000000000000,
  0xffff6668cccd6664, 0x0000000000000000,
  0xffff6635999a3364, 0x0000000000000000,
  0xffffcccd9999cccc, 0x0000000000000000,
  0xffff999b9999fffe, 0x0000000000000000,
  0xffff99686666ccfe, 0x0000000000000000,
  0xffff9935999a0064, 0x0000000000000000,
  0xffffccce00003332, 0x0000000000000000,
  0xffffcc9acccd0032, 0x0000000000000000,
  0xffffcc6800003398, 0x0000000000000000,
  0xffffcc359999cd64, 0x0000000000000000,
  0xffffffcccccccd00, 0x0000000000000000,
  0xffffff9a00000066, 0x0000000000000000,
  0xffffff6799999a32, 0x0000000000000000,
  0xffffff3599999a64, 0x0000000000000000,
  0xffffffcd33333366, 0x0000000000000000,
  0xffffff9acccccd32, 0x0000000000000000,
  0xffffff68cccccd64, 0x0000000000000000,
  0xffffff5c000000a4, 0x0000000000000000,
  0xffffffcd999999cc, 0x0000000000000000,
  0xffffff9b999999fe, 0x0000000000000000,
  0xffffff8ecccccd3e, 0x0000000000000000,
  0xffffff8d99999a0c, 0x0000000000000000,
  0xffffffce00000032, 0x0000000000000000,
  0xffffffc133333372, 0x0000000000000000,
  0xffffffc000000040, 0x0000000000000000,
  0xffffffbf33333374, 0x0000000000000000,
  0xfffffff333333340, 0x0000000000000000,
  0xfffffff20000000e, 0x0000000000000000,
  0xfffffff133333342, 0x0000000000000000,
  0xfffffff0ccccccdc, 0x0000000000000000,
  0xfffffffe00000002, 0x0000000000000000,
  0xfffffffcaaaaaaae, 0x0000000000000000,
  0xfffffffc00000004, 0x0000000000000000,
  0xfffffffc00000004, 0x0000000000000000,
  0xfffffffeaaaaaaac, 0x0000000000000000,
  0xfffffffe00000002, 0x0000000000000000,
  0xfffffffe00000002, 0x0000000000000000,
  0xfffffffeaaaaaaac, 0x0000000000000000,
  0xffffffff55555556, 0x0000000000000000,
  0xffffffff55555556, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000155555554, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000aaaaaaaa, 0x0000000000000000,
  0x00000001fffffffe, 0x0000000000000000,
  0x000000175555553e, 0x0000000000000000,
  0x00000000aaaaaaaa, 0x0000000000000000,
  0x00000001fffffffe, 0x0000000000000000,
  0x000000175555553e, 0x0000000000000000,
  0x0000006aaaaaaa40, 0x0000000000000000,
  0x0000000155555554, 0x0000000000000000,
  0x00000016aaaaaa94, 0x0000000000000000,
  0x00000069ffffff96, 0x0000000000000000,
  0x000000bdffffff42, 0x0000000000000000,
  0x0000001555555540, 0x0000000000000000,
  0x00000068aaaaaa42, 0x0000000000000000,
  0x000000bcaaaaa9ee, 0x0000000000000000,
  0x0000011155555444, 0x0000000000000000,
  0x0000005355555502, 0x0000000000000000,
  0x000000a7555554ae, 0x0000000000000000,
  0x000000fbffffff04, 0x0000000000000000,
  0x0000564f5554ff06, 0x0000000000000000,
  0x00000053ffffffac, 0x0000000000000000,
  0x000000a8aaaaaa02, 0x0000000000000000,
  0x000055fbffffaa04, 0x0000000000000000,
  0x0000ab4fffff54b0, 0x0000000000000000,
  0x00000054aaaaaa56, 0x0000000000000000,
  0x000055a7ffffaa58, 0x0000000000000000,
  0x0000aafbffff5504, 0x0000000000000000,
  0x00010050aaa9aa5a, 0x0000000000000000,
  0x0000555355550002, 0x0000000000000000,
  0x0000aaa75554aaae, 0x0000000000000000,
  0x0000fffbffff0004, 0x0000000000000000,
  0x2223221ddddcdde2, 0x0000000000000000,
  0x00005553ffffaaac, 0x0000000000000000,
  0x0000aaa8aaaa0002, 0x0000000000000000,
  0x2222ccca8887dde0, 0x0000000000000000,
  0x5b065b02fa4efa52, 0x0000000000000000,
  0x00005554aaaa5556, 0x0000000000000000,
  0x2222777688883334, 0x0000000000000000,
  0x5b0605aefa4f4fa6, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x22222221ddddddde, 0x0000000000000000,
  0x5b05b05a4fa4fa50, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x38e38e3871c71c72, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x5555555300000002, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x2aaaaaaaffffffff, 0x0000000000000000,
  0x55555553aaaaaaac, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x2aaaaaaaffffffff, 0x0000000000000000,
  0xd5555556aaaaaaa9, 0x0000000000000000,
  0x5555555455555556, 0x0000000000000000,
  0xffffffff55555556, 0x0000000000000000,
  0xaaaaaaab00000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaab00000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaabaaaaaaaa, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xc71c71c6e38e38e4, 0x0000000000000000,
  0xa4fa4fa45b05b05c, 0x0000000000000000,
  0xa4f9fa4f05b0b05c, 0x0000000000000000,
  0xa4f9a4fa5b065b06, 0x0000000000000000,
  0xdddddddd77777778, 0x0000000000000000,
  0xdddd888822227778, 0x0000000000000000,
  0xdddd333377782222, 0x0000000000000000,
  0xdddcdddf77787776, 0x0000000000000000,
  0xffffaaaaaaab0000, 0x0000000000000000,
  0xffff55560000aaaa, 0x0000000000000000,
  0xffff00020000fffe, 0x0000000000000000,
  0xfffeaaaeaaabfffc, 0x0000000000000000,
  0xffffaaab5555aaaa, 0x0000000000000000,
  0xffff55575555fffe, 0x0000000000000000,
  0xffff00040000fffc, 0x0000000000000000,
  0xfffeffaeaaabaafc, 0x0000000000000000,
  0xffffaaac00005554, 0x0000000000000000,
  0xffff5558aaab5552, 0x0000000000000000,
  0xffff550355560052, 0x0000000000000000,
  0xffff54aeaaab55fc, 0x0000000000000000,
  0xffffaaacaaaafffe, 0x0000000000000000,
  0xffffaa575555aafe, 0x0000000000000000,
  0xffffaa02aaab00a8, 0x0000000000000000,
  0xffffa9aeaaab00fc, 0x0000000000000000,
  0xffffffaaaaaaab00, 0x0000000000000000,
  0xffffff56000000aa, 0x0000000000000000,
  0xffffff02000000fe, 0x0000000000000000,
  0xfffffeaeaaaaabfc, 0x0000000000000000,
  0xffffffab555555aa, 0x0000000000000000,
  0xffffff57555555fe, 0x0000000000000000,
  0xffffff04000000fc, 0x0000000000000000,
  0xfffffeeeaaaaabbc, 0x0000000000000000,
  0xffffffac00000054, 0x0000000000000000,
  0xffffff58aaaaab52, 0x0000000000000000,
  0xffffff4355555612, 0x0000000000000000,
  0xffffff4155555614, 0x0000000000000000,
  0xffffffacaaaaaafe, 0x0000000000000000,
  0xffffff97555555be, 0x0000000000000000,
  0xffffff95555555c0, 0x0000000000000000,
  0xffffff940000006c, 0x0000000000000000,
  0xffffffeaaaaaaac0, 0x0000000000000000,
  0xffffffe8aaaaaac2, 0x0000000000000000,
  0xffffffe75555556e, 0x0000000000000000,
  0xffffffe6aaaaaac4, 0x0000000000000000,
  0xfffffffd00000012, 0x0000000000000000,
  0xfffffffb0000001e, 0x0000000000000000,
  0xfffffffa00000024, 0x0000000000000000,
  0xfffffffa00000024, 0x0000000000000000,
  0xfffffffe0000000c, 0x0000000000000000,
  0xfffffffd00000012, 0x0000000000000000,
  0xfffffffd00000012, 0x0000000000000000,
  0xfffffffe0000000c, 0x0000000000000000,
  0xffffffff00000006, 0x0000000000000000,
  0xffffffff00000006, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000001fffffff4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000fffffffa, 0x0000000000000000,
  0x00000002ffffffee, 0x0000000000000000,
  0x00000022ffffff2e, 0x0000000000000000,
  0x00000000fffffffa, 0x0000000000000000,
  0x00000002ffffffee, 0x0000000000000000,
  0x00000022ffffff2e, 0x0000000000000000,
  0x0000009ffffffc40, 0x0000000000000000,
  0x00000001fffffff4, 0x0000000000000000,
  0x00000021ffffff34, 0x0000000000000000,
  0x0000009efffffc46, 0x0000000000000000,
  0x0000011cfffff952, 0x0000000000000000,
  0x0000001fffffff40, 0x0000000000000000,
  0x0000009cfffffc52, 0x0000000000000000,
  0x0000011afffff95e, 0x0000000000000000,
  0x00000199fffff664, 0x0000000000000000,
  0x0000007cfffffd12, 0x0000000000000000,
  0x000000fafffffa1e, 0x0000000000000000,
  0x00000179fffff724, 0x0000000000000000,
  0x00008176fffcf736, 0x0000000000000000,
  0x0000007dfffffd0c, 0x0000000000000000,
  0x000000fcfffffa12, 0x0000000000000000,
  0x000080f9fffcfa24, 0x0000000000000000,
  0x000100f7fff9fa30, 0x0000000000000000,
  0x0000007efffffd06, 0x0000000000000000,
  0x0000807bfffcfd18, 0x0000000000000000,
  0x00010079fff9fd24, 0x0000000000000000,
  0x00018078fff6fd2a, 0x0000000000000000,
  0x00007ffcfffd0012, 0x0000000000000000,
  0x0000fffafffa001e, 0x0000000000000000,
  0x00017ff9fff70024, 0x0000000000000000,
  0x3334b32bccc3ccf2, 0x0000000000000000,
  0x00007ffdfffd000c, 0x0000000000000000,
  0x0000fffcfffa0012, 0x0000000000000000,
  0x3334332eccc6cce0, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00007ffefffd0006, 0x0000000000000000,
  0x3333b330ccc9ccd4, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x33333331ccccccce, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x5555555300000002, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7ffffffa00000012, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00000002ffffffff, 0x0000000000000000,
  0x7ffffffb0000000c, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00000002ffffffff, 0x0000000000000000,
  0x80000006fffffff9, 0x0000000000000000,
  0x7ffffffc00000006, 0x0000000000000000,
  0xffffffff00000006, 0x0000000000000000,
  0x8000000300000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000300000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x80000003fffffffa, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaac00000004, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xcccccccd33333338, 0x0000000000000000,
  0xcccc4ccd33363338, 0x0000000000000000,
  0xcccbccce33393332, 0x0000000000000000,
  0xcccb4cd0333c3326, 0x0000000000000000,
  0xffff800000030000, 0x0000000000000000,
  0xffff00010005fffa, 0x0000000000000000,
  0xfffe80030008ffee, 0x0000000000000000,
  0xfffe0006000bffdc, 0x0000000000000000,
  0xffff80010002fffa, 0x0000000000000000,
  0xffff00030005ffee, 0x0000000000000000,
  0xfffe80060008ffdc, 0x0000000000000000,
  0xfffe7f86000902dc, 0x0000000000000000,
  0xffff80020002fff4, 0x0000000000000000,
  0xffff00050005ffe2, 0x0000000000000000,
  0xfffeff85000602e2, 0x0000000000000000,
  0xfffeff06000605dc, 0x0000000000000000,
  0xffff80030002ffee, 0x0000000000000000,
  0xffff7f83000302ee, 0x0000000000000000,
  0xffff7f04000305e8, 0x0000000000000000,
  0xffff7e86000308dc, 0x0000000000000000,
  0xffffff8000000300, 0x0000000000000000,
  0xffffff01000005fa, 0x0000000000000000,
  0xfffffe83000008ee, 0x0000000000000000,
  0xfffffe0600000bdc, 0x0000000000000000,
  0xffffff81000002fa, 0x0000000000000000,
  0xffffff03000005ee, 0x0000000000000000,
  0xfffffe86000008dc, 0x0000000000000000,
  0xfffffe660000099c, 0x0000000000000000,
  0xffffff82000002f4, 0x0000000000000000,
  0xffffff05000005e2, 0x0000000000000000,
  0xfffffee5000006a2, 0x0000000000000000,
  0xfffffee2000006b4, 0x0000000000000000,
  0xffffff83000002ee, 0x0000000000000000,
  0xffffff63000003ae, 0x0000000000000000,
  0xffffff60000003c0, 0x0000000000000000,
  0xffffff5e000003cc, 0x0000000000000000,
  0xffffffe0000000c0, 0x0000000000000000,
  0xffffffdd000000d2, 0x0000000000000000,
  0xffffffdb000000de, 0x0000000000000000,
  0xffffffda000000e4, 0x0000000000000000,
  0xfffffffd0000000c, 0x0000000000000000,
  0xfffffffb00000014, 0x0000000000000000,
  0xfffffffa00000018, 0x0000000000000000,
  0xfffffffa00000018, 0x0000000000000000,
  0xfffffffe00000008, 0x0000000000000000,
  0xfffffffd0000000c, 0x0000000000000000,
  0xfffffffd0000000c, 0x0000000000000000,
  0xfffffffe00000008, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000001fffffff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x00000002fffffff4, 0x0000000000000000,
  0x00000022ffffff74, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x00000002fffffff4, 0x0000000000000000,
  0x00000022ffffff74, 0x0000000000000000,
  0x0000009ffffffd80, 0x0000000000000000,
  0x00000001fffffff8, 0x0000000000000000,
  0x00000021ffffff78, 0x0000000000000000,
  0x0000009efffffd84, 0x0000000000000000,
  0x0000011cfffffb8c, 0x0000000000000000,
  0x0000001fffffff80, 0x0000000000000000,
  0x0000009cfffffd8c, 0x0000000000000000,
  0x0000011afffffb94, 0x0000000000000000,
  0x00000199fffff998, 0x0000000000000000,
  0x0000007cfffffe0c, 0x0000000000000000,
  0x000000fafffffc14, 0x0000000000000000,
  0x00000179fffffa18, 0x0000000000000000,
  0x00008176fffdfa24, 0x0000000000000000,
  0x0000007dfffffe08, 0x0000000000000000,
  0x000000fcfffffc0c, 0x0000000000000000,
  0x000080f9fffdfc18, 0x0000000000000000,
  0x000100f7fffbfc20, 0x0000000000000000,
  0x0000007efffffe04, 0x0000000000000000,
  0x0000807bfffdfe10, 0x0000000000000000,
  0x00010079fffbfe18, 0x0000000000000000,
  0x00018078fff9fe1c, 0x0000000000000000,
  0x00007ffcfffe000c, 0x0000000000000000,
  0x0000fffafffc0014, 0x0000000000000000,
  0x00017ff9fffa0018, 0x0000000000000000,
  0x3334b32c332d334c, 0x0000000000000000,
  0x00007ffdfffe0008, 0x0000000000000000,
  0x0000fffcfffc000c, 0x0000000000000000,
  0x3334332f332f3340, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00007ffefffe0004, 0x0000000000000000,
  0x3333b33133313338, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x3333333233333334, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x55555553aaaaaaac, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7ffffffb0000000c, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00000001ffffffff, 0x0000000000000000,
  0x7ffffffc00000008, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00000001ffffffff, 0x0000000000000000,
  0x80000004fffffffb, 0x0000000000000000,
  0x7ffffffd00000004, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0x8000000200000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000200000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x80000002fffffffc, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaab55555558, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xccccccccccccccd0, 0x0000000000000000,
  0xcccc4cccccceccd0, 0x0000000000000000,
  0xcccbcccdccd0cccc, 0x0000000000000000,
  0xcccb4ccfccd2ccc4, 0x0000000000000000,
  0xffff800000020000, 0x0000000000000000,
  0xffff00010003fffc, 0x0000000000000000,
  0xfffe80030005fff4, 0x0000000000000000,
  0xfffe00060007ffe8, 0x0000000000000000,
  0xffff80010001fffc, 0x0000000000000000,
  0xffff00030003fff4, 0x0000000000000000,
  0xfffe80060005ffe8, 0x0000000000000000,
  0xfffe7f86000601e8, 0x0000000000000000,
  0xffff80020001fff8, 0x0000000000000000,
  0xffff00050003ffec, 0x0000000000000000,
  0xfffeff85000401ec, 0x0000000000000000,
  0xfffeff06000403e8, 0x0000000000000000,
  0xffff80030001fff4, 0x0000000000000000,
  0xffff7f83000201f4, 0x0000000000000000,
  0xffff7f04000203f0, 0x0000000000000000,
  0xffff7e86000205e8, 0x0000000000000000,
  0xffffff8000000200, 0x0000000000000000,
  0xffffff01000003fc, 0x0000000000000000,
  0xfffffe83000005f4, 0x0000000000000000,
  0xfffffe06000007e8, 0x0000000000000000,
  0xffffff81000001fc, 0x0000000000000000,
  0xffffff03000003f4, 0x0000000000000000,
  0xfffffe86000005e8, 0x0000000000000000,
  0xfffffe6600000668, 0x0000000000000000,
  0xffffff82000001f8, 0x0000000000000000,
  0xffffff05000003ec, 0x0000000000000000,
  0xfffffee50000046c, 0x0000000000000000,
  0xfffffee200000478, 0x0000000000000000,
  0xffffff83000001f4, 0x0000000000000000,
  0xffffff6300000274, 0x0000000000000000,
  0xffffff6000000280, 0x0000000000000000,
  0xffffff5e00000288, 0x0000000000000000,
  0xffffffe000000080, 0x0000000000000000,
  0xffffffdd0000008c, 0x0000000000000000,
  0xffffffdb00000094, 0x0000000000000000,
  0xffffffda00000098, 0x0000000000000000,
  0xfffffffd00000006, 0x0000000000000000,
  0xfffffffb0000000a, 0x0000000000000000,
  0xfffffffa0000000c, 0x0000000000000000,
  0xfffffffa0000000c, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0xfffffffd00000006, 0x0000000000000000,
  0xfffffffd00000006, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x00000002fffffffa, 0x0000000000000000,
  0x00000022ffffffba, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x00000002fffffffa, 0x0000000000000000,
  0x00000022ffffffba, 0x0000000000000000,
  0x0000009ffffffec0, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0x00000021ffffffbc, 0x0000000000000000,
  0x0000009efffffec2, 0x0000000000000000,
  0x0000011cfffffdc6, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0x0000009cfffffec6, 0x0000000000000000,
  0x0000011afffffdca, 0x0000000000000000,
  0x00000199fffffccc, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0x000000fafffffe0a, 0x0000000000000000,
  0x00000179fffffd0c, 0x0000000000000000,
  0x00008176fffefd12, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0x000000fcfffffe06, 0x0000000000000000,
  0x000080f9fffefe0c, 0x0000000000000000,
  0x000100f7fffdfe10, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0x0000807bfffeff08, 0x0000000000000000,
  0x00010079fffdff0c, 0x0000000000000000,
  0x00018078fffcff0e, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0x0000fffafffe000a, 0x0000000000000000,
  0x00017ff9fffd000c, 0x0000000000000000,
  0x3334b32c999699a6, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0x0000fffcfffe0006, 0x0000000000000000,
  0x3334332f999799a0, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0x3333b3319998999c, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x333333329999999a, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x5555555455555556, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7ffffffc00000006, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00000000ffffffff, 0x0000000000000000,
  0x7ffffffd00000004, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x00000000ffffffff, 0x0000000000000000,
  0x80000002fffffffd, 0x0000000000000000,
  0x7ffffffe00000002, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0x8000000100000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000100000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x80000001fffffffe, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xcccccccc66666668, 0x0000000000000000,
  0xcccc4ccc66676668, 0x0000000000000000,
  0xcccbcccd66686666, 0x0000000000000000,
  0xcccb4ccf66696662, 0x0000000000000000,
  0xffff800000010000, 0x0000000000000000,
  0xffff00010001fffe, 0x0000000000000000,
  0xfffe80030002fffa, 0x0000000000000000,
  0xfffe00060003fff4, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0xffff00030001fffa, 0x0000000000000000,
  0xfffe80060002fff4, 0x0000000000000000,
  0xfffe7f86000300f4, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0xffff00050001fff6, 0x0000000000000000,
  0xfffeff85000200f6, 0x0000000000000000,
  0xfffeff06000201f4, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0xffff7f83000100fa, 0x0000000000000000,
  0xffff7f04000101f8, 0x0000000000000000,
  0xffff7e86000102f4, 0x0000000000000000,
  0xffffff8000000100, 0x0000000000000000,
  0xffffff01000001fe, 0x0000000000000000,
  0xfffffe83000002fa, 0x0000000000000000,
  0xfffffe06000003f4, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0xffffff03000001fa, 0x0000000000000000,
  0xfffffe86000002f4, 0x0000000000000000,
  0xfffffe6600000334, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0xffffff05000001f6, 0x0000000000000000,
  0xfffffee500000236, 0x0000000000000000,
  0xfffffee20000023c, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0xffffff630000013a, 0x0000000000000000,
  0xffffff6000000140, 0x0000000000000000,
  0xffffff5e00000144, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0xffffffdd00000046, 0x0000000000000000,
  0xffffffdb0000004a, 0x0000000000000000,
  0xffffffda0000004c, 0x0000000000000000,
  0x0000000300000000, 0x0000000000000000,
  0x0000000500000000, 0x0000000000000000,
  0x0000000600000000, 0x0000000000000000,
  0x0000000600000000, 0x0000000000000000,
  0x0000000200000000, 0x0000000000000000,
  0x0000000300000000, 0x0000000000000000,
  0x0000000300000000, 0x0000000000000000,
  0x0000000200000000, 0x0000000000000000,
  0x0000000100000000, 0x0000000000000000,
  0x0000000100000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffe00000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0xfffffffd00000000, 0x0000000000000000,
  0xffffffdd00000000, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0xfffffffd00000000, 0x0000000000000000,
  0xffffffdd00000000, 0x0000000000000000,
  0xffffff6000000000, 0x0000000000000000,
  0xfffffffe00000000, 0x0000000000000000,
  0xffffffde00000000, 0x0000000000000000,
  0xffffff6100000000, 0x0000000000000000,
  0xfffffee300000000, 0x0000000000000000,
  0xffffffe000000000, 0x0000000000000000,
  0xffffff6300000000, 0x0000000000000000,
  0xfffffee500000000, 0x0000000000000000,
  0xfffffe6600000000, 0x0000000000000000,
  0xffffff8300000000, 0x0000000000000000,
  0xffffff0500000000, 0x0000000000000000,
  0xfffffe8600000000, 0x0000000000000000,
  0xffff7e8900000000, 0x0000000000000000,
  0xffffff8200000000, 0x0000000000000000,
  0xffffff0300000000, 0x0000000000000000,
  0xffff7f0600000000, 0x0000000000000000,
  0xfffeff0800000000, 0x0000000000000000,
  0xffffff8100000000, 0x0000000000000000,
  0xffff7f8400000000, 0x0000000000000000,
  0xfffeff8600000000, 0x0000000000000000,
  0xfffe7f8700000000, 0x0000000000000000,
  0xffff800300000000, 0x0000000000000000,
  0xffff000500000000, 0x0000000000000000,
  0xfffe800600000000, 0x0000000000000000,
  0xcccb4cd300000000, 0x0000000000000000,
  0xffff800200000000, 0x0000000000000000,
  0xffff000300000000, 0x0000000000000000,
  0xcccbccd000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xffff800100000000, 0x0000000000000000,
  0xcccc4cce00000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xcccccccd00000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaab00000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000300000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x8000000200000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x7ffffffeffffffff, 0x0000000000000000,
  0x8000000100000000, 0x0000000000000000,
  0x00000000ffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffff00000000, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x5555555600000000, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x3333333400000000, 0x0000000000000000,
  0x3333b33400000000, 0x0000000000000000,
  0x3334333300000000, 0x0000000000000000,
  0x3334b33100000000, 0x0000000000000000,
  0x0000800000000000, 0x0000000000000000,
  0x0000ffff00000000, 0x0000000000000000,
  0x00017ffd00000000, 0x0000000000000000,
  0x0001fffa00000000, 0x0000000000000000,
  0x00007fff00000000, 0x0000000000000000,
  0x0000fffd00000000, 0x0000000000000000,
  0x00017ffa00000000, 0x0000000000000000,
  0x0001807a00000000, 0x0000000000000000,
  0x00007ffe00000000, 0x0000000000000000,
  0x0000fffb00000000, 0x0000000000000000,
  0x0001007b00000000, 0x0000000000000000,
  0x000100fa00000000, 0x0000000000000000,
  0x00007ffd00000000, 0x0000000000000000,
  0x0000807d00000000, 0x0000000000000000,
  0x000080fc00000000, 0x0000000000000000,
  0x0000817a00000000, 0x0000000000000000,
  0x0000008000000000, 0x0000000000000000,
  0x000000ff00000000, 0x0000000000000000,
  0x0000017d00000000, 0x0000000000000000,
  0x000001fa00000000, 0x0000000000000000,
  0x0000007f00000000, 0x0000000000000000,
  0x000000fd00000000, 0x0000000000000000,
  0x0000017a00000000, 0x0000000000000000,
  0x0000019a00000000, 0x0000000000000000,
  0x0000007e00000000, 0x0000000000000000,
  0x000000fb00000000, 0x0000000000000000,
  0x0000011b00000000, 0x0000000000000000,
  0x0000011e00000000, 0x0000000000000000,
  0x0000007d00000000, 0x0000000000000000,
  0x0000009d00000000, 0x0000000000000000,
  0x000000a000000000, 0x0000000000000000,
  0x000000a200000000, 0x0000000000000000,
  0x0000002000000000, 0x0000000000000000,
  0x0000002300000000, 0x0000000000000000,
  0x0000002500000000, 0x0000000000000000,
  0x0000002600000000, 0x0000000000000000,
  0x00000002fffffffa, 0x0000000000000000,
  0x00000004fffffff6, 0x0000000000000000,
  0x00000005fffffff4, 0x0000000000000000,
  0x00000005fffffff4, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0x00000002fffffffa, 0x0000000000000000,
  0x00000002fffffffa, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xfffffffd00000006, 0x0000000000000000,
  0xffffffdd00000046, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xfffffffd00000006, 0x0000000000000000,
  0xffffffdd00000046, 0x0000000000000000,
  0xffffff6000000140, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0xffffffde00000044, 0x0000000000000000,
  0xffffff610000013e, 0x0000000000000000,
  0xfffffee30000023a, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0xffffff630000013a, 0x0000000000000000,
  0xfffffee500000236, 0x0000000000000000,
  0xfffffe6600000334, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0xffffff05000001f6, 0x0000000000000000,
  0xfffffe86000002f4, 0x0000000000000000,
  0xffff7e89000102ee, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0xffffff03000001fa, 0x0000000000000000,
  0xffff7f06000101f4, 0x0000000000000000,
  0xfffeff08000201f0, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0xffff7f84000100f8, 0x0000000000000000,
  0xfffeff86000200f4, 0x0000000000000000,
  0xfffe7f87000300f2, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0xffff00050001fff6, 0x0000000000000000,
  0xfffe80060002fff4, 0x0000000000000000,
  0xcccb4cd36669665a, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0xffff00030001fffa, 0x0000000000000000,
  0xcccbccd066686660, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0xcccc4cce66676664, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xcccccccd66666666, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaabaaaaaaaa, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x80000003fffffffa, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0x80000002fffffffc, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0x7ffffffd00000002, 0x0000000000000000,
  0x80000001fffffffe, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x7fffffff00000000, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffff00000000, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7ffffffe00000002, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x5555555555555554, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x3333333399999998, 0x0000000000000000,
  0x3333b33399989998, 0x0000000000000000,
  0x333433329997999a, 0x0000000000000000,
  0x3334b3309996999e, 0x0000000000000000,
  0x00007fffffff0000, 0x0000000000000000,
  0x0000fffefffe0002, 0x0000000000000000,
  0x00017ffcfffd0006, 0x0000000000000000,
  0x0001fff9fffc000c, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0x0000fffcfffe0006, 0x0000000000000000,
  0x00017ff9fffd000c, 0x0000000000000000,
  0x00018079fffcff0c, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0x0000fffafffe000a, 0x0000000000000000,
  0x0001007afffdff0a, 0x0000000000000000,
  0x000100f9fffdfe0c, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0x0000807cfffeff06, 0x0000000000000000,
  0x000080fbfffefe08, 0x0000000000000000,
  0x00008179fffefd0c, 0x0000000000000000,
  0x0000007fffffff00, 0x0000000000000000,
  0x000000fefffffe02, 0x0000000000000000,
  0x0000017cfffffd06, 0x0000000000000000,
  0x000001f9fffffc0c, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0x000000fcfffffe06, 0x0000000000000000,
  0x00000179fffffd0c, 0x0000000000000000,
  0x00000199fffffccc, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0x000000fafffffe0a, 0x0000000000000000,
  0x0000011afffffdca, 0x0000000000000000,
  0x0000011dfffffdc4, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0x0000009cfffffec6, 0x0000000000000000,
  0x0000009ffffffec0, 0x0000000000000000,
  0x000000a1fffffebc, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0x00000022ffffffba, 0x0000000000000000,
  0x00000024ffffffb6, 0x0000000000000000,
  0x00000025ffffffb4, 0x0000000000000000,
  0x0000000200000004, 0x0000000000000000,
  0x000000035555555c, 0x0000000000000000,
  0x0000000400000008, 0x0000000000000000,
  0x0000000400000008, 0x0000000000000000,
  0x0000000155555558, 0x0000000000000000,
  0x0000000200000004, 0x0000000000000000,
  0x0000000200000004, 0x0000000000000000,
  0x0000000155555558, 0x0000000000000000,
  0x00000000aaaaaaac, 0x0000000000000000,
  0x00000000aaaaaaac, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffeaaaaaaa8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff55555554, 0x0000000000000000,
  0xfffffffdfffffffc, 0x0000000000000000,
  0xffffffe8aaaaaa7c, 0x0000000000000000,
  0xffffffff55555554, 0x0000000000000000,
  0xfffffffdfffffffc, 0x0000000000000000,
  0xffffffe8aaaaaa7c, 0x0000000000000000,
  0xffffff9555555480, 0x0000000000000000,
  0xfffffffeaaaaaaa8, 0x0000000000000000,
  0xffffffe955555528, 0x0000000000000000,
  0xffffff95ffffff2c, 0x0000000000000000,
  0xffffff41fffffe84, 0x0000000000000000,
  0xffffffeaaaaaaa80, 0x0000000000000000,
  0xffffff9755555484, 0x0000000000000000,
  0xffffff43555553dc, 0x0000000000000000,
  0xfffffeeeaaaaa888, 0x0000000000000000,
  0xffffffacaaaaaa04, 0x0000000000000000,
  0xffffff58aaaaa95c, 0x0000000000000000,
  0xffffff03fffffe08, 0x0000000000000000,
  0xffffa9b0aaa9fe0c, 0x0000000000000000,
  0xffffffabffffff58, 0x0000000000000000,
  0xffffff5755555404, 0x0000000000000000,
  0xffffaa03ffff5408, 0x0000000000000000,
  0xffff54affffea960, 0x0000000000000000,
  0xffffffab555554ac, 0x0000000000000000,
  0xffffaa57ffff54b0, 0x0000000000000000,
  0xffff5503fffeaa08, 0x0000000000000000,
  0xfffeffaf555354b4, 0x0000000000000000,
  0xffffaaacaaaa0004, 0x0000000000000000,
  0xffff5558aaa9555c, 0x0000000000000000,
  0xffff0003fffe0008, 0x0000000000000000,
  0xdddcdde1bbb9bbc4, 0x0000000000000000,
  0xffffaaabffff5558, 0x0000000000000000,
  0xffff555755540004, 0x0000000000000000,
  0xdddd3335110fbbc0, 0x0000000000000000,
  0xa4f9a4fbf49df4a4, 0x0000000000000000,
  0xffffaaab5554aaac, 0x0000000000000000,
  0xdddd888911106668, 0x0000000000000000,
  0xa4f9fa4ff49e9f4c, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xddddddddbbbbbbbc, 0x0000000000000000,
  0xa4fa4fa49f49f4a0, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xc71c71c6e38e38e4, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaac00000004, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xd555555600000000, 0x0000000000000000,
  0xaaaaaaab55555558, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xd555555600000000, 0x0000000000000000,
  0x2aaaaaab55555554, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0x00000000aaaaaaac, 0x0000000000000000,
  0x5555555600000000, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x5555555600000000, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x5555555555555554, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x38e38e39c71c71c8, 0x0000000000000000,
  0x5b05b05cb60b60b8, 0x0000000000000000,
  0x5b0605b20b6160b8, 0x0000000000000000,
  0x5b065b06b60cb60c, 0x0000000000000000,
  0x22222222eeeeeef0, 0x0000000000000000,
  0x222277784444eef0, 0x0000000000000000,
  0x2222cccceef04444, 0x0000000000000000,
  0x22232220eef0eeec, 0x0000000000000000,
  0x0000555555560000, 0x0000000000000000,
  0x0000aaaa00015554, 0x0000000000000000,
  0x0000fffe0001fffc, 0x0000000000000000,
  0x000155515557fff8, 0x0000000000000000,
  0x00005554aaab5554, 0x0000000000000000,
  0x0000aaa8aaabfffc, 0x0000000000000000,
  0x0000fffc0001fff8, 0x0000000000000000,
  0x00010051555755f8, 0x0000000000000000,
  0x000055540000aaa8, 0x0000000000000000,
  0x0000aaa75556aaa4, 0x0000000000000000,
  0x0000aafcaaac00a4, 0x0000000000000000,
  0x0000ab515556abf8, 0x0000000000000000,
  0x000055535555fffc, 0x0000000000000000,
  0x000055a8aaab55fc, 0x0000000000000000,
  0x000055fd55560150, 0x0000000000000000,
  0x00005651555601f8, 0x0000000000000000,
  0x0000005555555600, 0x0000000000000000,
  0x000000aa00000154, 0x0000000000000000,
  0x000000fe000001fc, 0x0000000000000000,
  0x00000151555557f8, 0x0000000000000000,
  0x00000054aaaaab54, 0x0000000000000000,
  0x000000a8aaaaabfc, 0x0000000000000000,
  0x000000fc000001f8, 0x0000000000000000,
  0x0000011155555778, 0x0000000000000000,
  0x00000054000000a8, 0x0000000000000000,
  0x000000a7555556a4, 0x0000000000000000,
  0x000000bcaaaaac24, 0x0000000000000000,
  0x000000beaaaaac28, 0x0000000000000000,
  0x00000053555555fc, 0x0000000000000000,
  0x00000068aaaaab7c, 0x0000000000000000,
  0x0000006aaaaaab80, 0x0000000000000000,
  0x0000006c000000d8, 0x0000000000000000,
  0x0000001555555580, 0x0000000000000000,
  0x0000001755555584, 0x0000000000000000,
  0x00000018aaaaaadc, 0x0000000000000000,
  0x0000001955555588, 0x0000000000000000,
  0x0000000133333338, 0x0000000000000000,
  0x0000000200000008, 0x0000000000000000,
  0x0000000266666670, 0x0000000000000000,
  0x0000000266666670, 0x0000000000000000,
  0x00000000ccccccd0, 0x0000000000000000,
  0x0000000133333338, 0x0000000000000000,
  0x0000000133333338, 0x0000000000000000,
  0x00000000ccccccd0, 0x0000000000000000,
  0x0000000066666668, 0x0000000000000000,
  0x0000000066666668, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff33333330, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff99999998, 0x0000000000000000,
  0xfffffffeccccccc8, 0x0000000000000000,
  0xfffffff1ffffffc8, 0x0000000000000000,
  0xffffffff99999998, 0x0000000000000000,
  0xfffffffeccccccc8, 0x0000000000000000,
  0xfffffff1ffffffc8, 0x0000000000000000,
  0xffffffbfffffff00, 0x0000000000000000,
  0xffffffff33333330, 0x0000000000000000,
  0xfffffff266666630, 0x0000000000000000,
  0xffffffc066666568, 0x0000000000000000,
  0xffffff8dfffffe38, 0x0000000000000000,
  0xfffffff333333300, 0x0000000000000000,
  0xffffffc133333238, 0x0000000000000000,
  0xffffff8ecccccb08, 0x0000000000000000,
  0xffffff5bfffffd70, 0x0000000000000000,
  0xffffffcdffffff38, 0x0000000000000000,
  0xffffff9b99999808, 0x0000000000000000,
  0xffffff68ccccca70, 0x0000000000000000,
  0xffffcc36cccbfda8, 0x0000000000000000,
  0xffffffcd999998d0, 0x0000000000000000,
  0xffffff9acccccb38, 0x0000000000000000,
  0xffffcc68cccbfe70, 0x0000000000000000,
  0xffff99366664cb40, 0x0000000000000000,
  0xffffffcd33333268, 0x0000000000000000,
  0xffffcc9b333265a0, 0x0000000000000000,
  0xffff9968cccb3270, 0x0000000000000000,
  0xffff6635fffd98d8, 0x0000000000000000,
  0xffffcccdffff3338, 0x0000000000000000,
  0xffff999b99980008, 0x0000000000000000,
  0xffff6668ccca6670, 0x0000000000000000,
  0xeb848520e14547b8, 0x0000000000000000,
  0xffffcccd9998ccd0, 0x0000000000000000,
  0xffff999acccb3338, 0x0000000000000000,
  0xeb84b852e1461480, 0x0000000000000000,
  0xc962963058bd8bf8, 0x0000000000000000,
  0xffffcccd33326668, 0x0000000000000000,
  0xeb84eb8547ad47b0, 0x0000000000000000,
  0xc962c962bf24bf28, 0x0000000000000000,
  0x962f962ff257f260, 0x0000000000000000,
  0xeb851eb8147ae148, 0x0000000000000000,
  0xc962fc958bf258c0, 0x0000000000000000,
  0x962fc962bf258bf8, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xdddddddd77777778, 0x0000000000000000,
  0xaaaaaaaaaaaaaab0, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xcccccccd33333338, 0x0000000000000000,
  0x9999999a00000008, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xb333333400000000, 0x0000000000000000,
  0xccccccccccccccd0, 0x0000000000000000,
  0x9999999933333338, 0x0000000000000000,
  0xcccccccd33333338, 0x0000000000000000,
  0x00000000ccccccd0, 0x0000000000000000,
  0xcccccccc66666668, 0x0000000000000000,
  0x0000000066666668, 0x0000000000000000,
  0x3333333400000000, 0x0000000000000000,
  0x55555556eeeeeef0, 0x0000000000000000,
  0x3333333400000000, 0x0000000000000000,
  0x6666666799999998, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x3333333399999998, 0x0000000000000000,
  0x5555555688888888, 0x0000000000000000,
  0x69d0369eda740da8, 0x0000000000000000,
  0x69d069d20da80da8, 0x0000000000000000,
  0x22222222eeeeeef0, 0x0000000000000000,
  0x369d036b40da7410, 0x0000000000000000,
  0x369d369e740e7410, 0x0000000000000000,
  0x369d69d140dc0da8, 0x0000000000000000,
  0x147ae14851eb8520, 0x0000000000000000,
  0x147b147b851f8520, 0x0000000000000000,
  0x147b47ae51ed1eb8, 0x0000000000000000,
  0x147b7ae0b85451e8, 0x0000000000000000,
  0x0000333333340000, 0x0000000000000000,
  0x0000666600019998, 0x0000000000000000,
  0x000099986668ccc8, 0x0000000000000000,
  0x0000ccca66699990, 0x0000000000000000,
  0x00003332cccd9998, 0x0000000000000000,
  0x000066653334ccc8, 0x0000000000000000,
  0x0000999733359990, 0x0000000000000000,
  0x000099ca6668cd90, 0x0000000000000000,
  0x0000333266673330, 0x0000000000000000,
  0x000066646667fff8, 0x0000000000000000,
  0x00006697999b33f8, 0x0000000000000000,
  0x000066ca66680190, 0x0000000000000000,
  0x000033320000ccc8, 0x0000000000000000,
  0x00003365333400c8, 0x0000000000000000,
  0x000033980000ce60, 0x0000000000000000,
  0x000033ca66673590, 0x0000000000000000,
  0x0000003333333400, 0x0000000000000000,
  0x0000006600000198, 0x0000000000000000,
  0x00000098666668c8, 0x0000000000000000,
  0x000000ca66666990, 0x0000000000000000,
  0x00000032cccccd98, 0x0000000000000000,
  0x00000065333334c8, 0x0000000000000000,
  0x0000009733333590, 0x0000000000000000,
  0x000000a400000290, 0x0000000000000000,
  0x0000003266666730, 0x0000000000000000,
  0x00000064666667f8, 0x0000000000000000,
  0x00000071333334f8, 0x0000000000000000,
  0x0000007266666830, 0x0000000000000000,
  0x00000032000000c8, 0x0000000000000000,
  0x0000003ecccccdc8, 0x0000000000000000,
  0x0000004000000100, 0x0000000000000000,
  0x00000040cccccdd0, 0x0000000000000000,
  0x0000000ccccccd00, 0x0000000000000000,
  0x0000000e00000038, 0x0000000000000000,
  0x0000000ecccccd08, 0x0000000000000000,
  0x0000000f33333370, 0x0000000000000000,
  0x0000000000030000, 0x0000000000000000,
  0x0000000000050000, 0x0000000000000000,
  0x0000000000060000, 0x0000000000000000,
  0x0000000000060000, 0x0000000000000000,
  0x0000000000020000, 0x0000000000000000,
  0x0000000000030000, 0x0000000000000000,
  0x0000000000030000, 0x0000000000000000,
  0x0000000000020000, 0x0000000000000000,
  0x0000000000010000, 0x0000000000000000,
  0x0000000000010000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffe0000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0000, 0x0000000000000000,
  0xfffffffffffd0000, 0x0000000000000000,
  0xffffffffffdd0000, 0x0000000000000000,
  0xffffffffffff0000, 0x0000000000000000,
  0xfffffffffffd0000, 0x0000000000000000,
  0xffffffffffdd0000, 0x0000000000000000,
  0xffffffffff600000, 0x0000000000000000,
  0xfffffffffffe0000, 0x0000000000000000,
  0xffffffffffde0000, 0x0000000000000000,
  0xffffffffff610000, 0x0000000000000000,
  0xfffffffffee30000, 0x0000000000000000,
  0xffffffffffe00000, 0x0000000000000000,
  0xffffffffff630000, 0x0000000000000000,
  0xfffffffffee50000, 0x0000000000000000,
  0xfffffffffe660000, 0x0000000000000000,
  0xffffffffff830000, 0x0000000000000000,
  0xffffffffff050000, 0x0000000000000000,
  0xfffffffffe860000, 0x0000000000000000,
  0xffffffff7e890000, 0x0000000000000000,
  0xffffffffff820000, 0x0000000000000000,
  0xffffffffff030000, 0x0000000000000000,
  0xffffffff7f060000, 0x0000000000000000,
  0xfffffffeff080000, 0x0000000000000000,
  0xffffffffff810000, 0x0000000000000000,
  0xffffffff7f840000, 0x0000000000000000,
  0xfffffffeff860000, 0x0000000000000000,
  0xfffffffe7f870000, 0x0000000000000000,
  0xffffffff80030000, 0x0000000000000000,
  0xffffffff00050000, 0x0000000000000000,
  0xfffffffe80060000, 0x0000000000000000,
  0xffffcccb4cd30000, 0x0000000000000000,
  0xffffffff80020000, 0x0000000000000000,
  0xffffffff00030000, 0x0000000000000000,
  0xffffcccbccd00000, 0x0000000000000000,
  0xffff7776777b0000, 0x0000000000000000,
  0xffffffff80010000, 0x0000000000000000,
  0xffffcccc4cce0000, 0x0000000000000000,
  0xffff7776f7790000, 0x0000000000000000,
  0xfffef776f77c0000, 0x0000000000000000,
  0xffffcccccccd0000, 0x0000000000000000,
  0xffff777777780000, 0x0000000000000000,
  0xfffef777777b0000, 0x0000000000000000,
  0xfffe7777777d0000, 0x0000000000000000,
  0xffffaaaaaaab0000, 0x0000000000000000,
  0xffff2aaaaaae0000, 0x0000000000000000,
  0xfffeaaaaaab00000, 0x0000000000000000,
  0xfffe2aaaaab10000, 0x0000000000000000,
  0xffff800000030000, 0x0000000000000000,
  0xffff000000050000, 0x0000000000000000,
  0xfffe800000060000, 0x0000000000000000,
  0xffff000000060000, 0x0000000000000000,
  0xffff800000020000, 0x0000000000000000,
  0xffff000000030000, 0x0000000000000000,
  0xffff800000030000, 0x0000000000000000,
  0x0000000000020000, 0x0000000000000000,
  0xffff800000010000, 0x0000000000000000,
  0x0000000000010000, 0x0000000000000000,
  0x0000800000000000, 0x0000000000000000,
  0x0000d55555560000, 0x0000000000000000,
  0x0000800000000000, 0x0000000000000000,
  0x0000ffffffff0000, 0x0000000000000000,
  0x0001555555550000, 0x0000000000000000,
  0x0001888888890000, 0x0000000000000000,
  0x00007fffffff0000, 0x0000000000000000,
  0x0000d55555550000, 0x0000000000000000,
  0x0001088888890000, 0x0000000000000000,
  0x0001088908890000, 0x0000000000000000,
  0x0000555555560000, 0x0000000000000000,
  0x00008888888a0000, 0x0000000000000000,
  0x00008889088a0000, 0x0000000000000000,
  0x0000888988890000, 0x0000000000000000,
  0x0000333333340000, 0x0000000000000000,
  0x00003333b3340000, 0x0000000000000000,
  0x0000333433330000, 0x0000000000000000,
  0x00003334b3310000, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x00000000ffff0000, 0x0000000000000000,
  0x000000017ffd0000, 0x0000000000000000,
  0x00000001fffa0000, 0x0000000000000000,
  0x000000007fff0000, 0x0000000000000000,
  0x00000000fffd0000, 0x0000000000000000,
  0x000000017ffa0000, 0x0000000000000000,
  0x00000001807a0000, 0x0000000000000000,
  0x000000007ffe0000, 0x0000000000000000,
  0x00000000fffb0000, 0x0000000000000000,
  0x00000001007b0000, 0x0000000000000000,
  0x0000000100fa0000, 0x0000000000000000,
  0x000000007ffd0000, 0x0000000000000000,
  0x00000000807d0000, 0x0000000000000000,
  0x0000000080fc0000, 0x0000000000000000,
  0x00000000817a0000, 0x0000000000000000,
  0x0000000000800000, 0x0000000000000000,
  0x0000000000ff0000, 0x0000000000000000,
  0x00000000017d0000, 0x0000000000000000,
  0x0000000001fa0000, 0x0000000000000000,
  0x00000000007f0000, 0x0000000000000000,
  0x0000000000fd0000, 0x0000000000000000,
  0x00000000017a0000, 0x0000000000000000,
  0x00000000019a0000, 0x0000000000000000,
  0x00000000007e0000, 0x0000000000000000,
  0x0000000000fb0000, 0x0000000000000000,
  0x00000000011b0000, 0x0000000000000000,
  0x00000000011e0000, 0x0000000000000000,
  0x00000000007d0000, 0x0000000000000000,
  0x00000000009d0000, 0x0000000000000000,
  0x0000000000a00000, 0x0000000000000000,
  0x0000000000a20000, 0x0000000000000000,
  0x0000000000200000, 0x0000000000000000,
  0x0000000000230000, 0x0000000000000000,
  0x0000000000250000, 0x0000000000000000,
  0x0000000000260000, 0x0000000000000000,
  0x000000000002fffa, 0x0000000000000000,
  0x000000000004fff6, 0x0000000000000000,
  0x000000000005fff4, 0x0000000000000000,
  0x000000000005fff4, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x000000000002fffa, 0x0000000000000000,
  0x000000000002fffa, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xfffffffffffd0006, 0x0000000000000000,
  0xffffffffffdd0046, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xfffffffffffd0006, 0x0000000000000000,
  0xffffffffffdd0046, 0x0000000000000000,
  0xffffffffff600140, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0xffffffffffde0044, 0x0000000000000000,
  0xffffffffff61013e, 0x0000000000000000,
  0xfffffffffee3023a, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xffffffffff63013a, 0x0000000000000000,
  0xfffffffffee50236, 0x0000000000000000,
  0xfffffffffe660334, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffffff0501f6, 0x0000000000000000,
  0xfffffffffe8602f4, 0x0000000000000000,
  0xffffffff7e8a02ee, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffffff0301fa, 0x0000000000000000,
  0xffffffff7f0701f4, 0x0000000000000000,
  0xfffffffeff0a01f0, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffff7f8500f8, 0x0000000000000000,
  0xfffffffeff8800f4, 0x0000000000000000,
  0xfffffffe7f8a00f2, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffffff0006fff6, 0x0000000000000000,
  0xfffffffe8008fff4, 0x0000000000000000,
  0xffffcccbb33c665a, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffffff0004fffa, 0x0000000000000000,
  0xffffcccc33386660, 0x0000000000000000,
  0xffff7777888e110a, 0x0000000000000000,
  0xffffffff8001fffe, 0x0000000000000000,
  0xffffccccb3356664, 0x0000000000000000,
  0xffff7778088b110e, 0x0000000000000000,
  0xfffef779088e1108, 0x0000000000000000,
  0xffffcccd33336666, 0x0000000000000000,
  0xffff777888891110, 0x0000000000000000,
  0xfffef779888c110a, 0x0000000000000000,
  0xfffe777a888e1106, 0x0000000000000000,
  0xffffaaab5555aaaa, 0x0000000000000000,
  0xffff2aac5558aaa4, 0x0000000000000000,
  0xfffeaaad555aaaa0, 0x0000000000000000,
  0xfffe2aae555baa9e, 0x0000000000000000,
  0xffff80010002fffa, 0x0000000000000000,
  0xffff00020004fff6, 0x0000000000000000,
  0xfffe80030005fff4, 0x0000000000000000,
  0xffff00020005fff4, 0x0000000000000000,
  0xffff80010001fffc, 0x0000000000000000,
  0xffff00020002fffa, 0x0000000000000000,
  0xffff80010002fffa, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x00007fff00000000, 0x0000000000000000,
  0x0000d553aaab5554, 0x0000000000000000,
  0x00007fff00000000, 0x0000000000000000,
  0x0000fffdffff0002, 0x0000000000000000,
  0x00015552aaaa5556, 0x0000000000000000,
  0x000188857777eeee, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0x0000d553aaaa5556, 0x0000000000000000,
  0x000108867777eeee, 0x0000000000000000,
  0x00010886f776eeee, 0x0000000000000000,
  0x00005554aaab5554, 0x0000000000000000,
  0x000088877778eeec, 0x0000000000000000,
  0x00008887f777eeec, 0x0000000000000000,
  0x000088887775eeee, 0x0000000000000000,
  0x00003332cccd9998, 0x0000000000000000,
  0x000033334ccc9998, 0x0000000000000000,
  0x00003333ccca999a, 0x0000000000000000,
  0x000033344cc7999e, 0x0000000000000000,
  0x000000007fff0000, 0x0000000000000000,
  0x00000000fffd0002, 0x0000000000000000,
  0x000000017ffa0006, 0x0000000000000000,
  0x00000001fff6000c, 0x0000000000000000,
  0x000000007ffe0002, 0x0000000000000000,
  0x00000000fffb0006, 0x0000000000000000,
  0x000000017ff7000c, 0x0000000000000000,
  0x000000018076ff0c, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x00000000fff9000a, 0x0000000000000000,
  0x000000010078ff0a, 0x0000000000000000,
  0x0000000100f7fe0c, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x00000000807bff06, 0x0000000000000000,
  0x0000000080fafe08, 0x0000000000000000,
  0x000000008178fd0c, 0x0000000000000000,
  0x00000000007fff00, 0x0000000000000000,
  0x0000000000fefe02, 0x0000000000000000,
  0x00000000017cfd06, 0x0000000000000000,
  0x0000000001f9fc0c, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x0000000000fcfe06, 0x0000000000000000,
  0x000000000179fd0c, 0x0000000000000000,
  0x000000000199fccc, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x0000000000fafe0a, 0x0000000000000000,
  0x00000000011afdca, 0x0000000000000000,
  0x00000000011dfdc4, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x00000000009cfec6, 0x0000000000000000,
  0x00000000009ffec0, 0x0000000000000000,
  0x0000000000a1febc, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x000000000022ffba, 0x0000000000000000,
  0x000000000024ffb6, 0x0000000000000000,
  0x000000000025ffb4, 0x0000000000000000,
  0x000000000002fff4, 0x0000000000000000,
  0x000000000004ffec, 0x0000000000000000,
  0x000000000005ffe8, 0x0000000000000000,
  0x000000000005ffe8, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x000000000002fff4, 0x0000000000000000,
  0x000000000002fff4, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xfffffffffffd000c, 0x0000000000000000,
  0xffffffffffdd008c, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xfffffffffffd000c, 0x0000000000000000,
  0xffffffffffdd008c, 0x0000000000000000,
  0xffffffffff600280, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0xffffffffffde0088, 0x0000000000000000,
  0xffffffffff61027c, 0x0000000000000000,
  0xfffffffffee30474, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xffffffffff630274, 0x0000000000000000,
  0xfffffffffee5046c, 0x0000000000000000,
  0xfffffffffe660668, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffff0503ec, 0x0000000000000000,
  0xfffffffffe8605e8, 0x0000000000000000,
  0xffffffff7e8b05dc, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff0303f4, 0x0000000000000000,
  0xffffffff7f0803e8, 0x0000000000000000,
  0xfffffffeff0c03e0, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffff7f8601f0, 0x0000000000000000,
  0xfffffffeff8a01e8, 0x0000000000000000,
  0xfffffffe7f8d01e4, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffff0008ffec, 0x0000000000000000,
  0xfffffffe800bffe8, 0x0000000000000000,
  0xffffcccc19a5ccb4, 0x0000000000000000,
  0xffffffff8003fff8, 0x0000000000000000,
  0xffffffff0006fff4, 0x0000000000000000,
  0xffffcccc99a0ccc0, 0x0000000000000000,
  0xffff777899a12214, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffcccd199cccc8, 0x0000000000000000,
  0xffff7779199d221c, 0x0000000000000000,
  0xfffef77b19a02210, 0x0000000000000000,
  0xffffcccd9999cccc, 0x0000000000000000,
  0xffff7779999a2220, 0x0000000000000000,
  0xfffef77b999d2214, 0x0000000000000000,
  0xfffe777d999f220c, 0x0000000000000000,
  0xffffaaac00005554, 0x0000000000000000,
  0xffff2aae00035548, 0x0000000000000000,
  0xfffeaab000055540, 0x0000000000000000,
  0xfffe2ab20006553c, 0x0000000000000000,
  0xffff80020002fff4, 0x0000000000000000,
  0xffff00040004ffec, 0x0000000000000000,
  0xfffe80060005ffe8, 0x0000000000000000,
  0xffff00040005ffe8, 0x0000000000000000,
  0xffff80020001fff8, 0x0000000000000000,
  0xffff00040002fff4, 0x0000000000000000,
  0xffff80020002fff4, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x00007ffe00000000, 0x0000000000000000,
  0x0000d5520000aaa8, 0x0000000000000000,
  0x00007ffe00000000, 0x0000000000000000,
  0x0000fffbffff0004, 0x0000000000000000,
  0x0001554fffffaaac, 0x0000000000000000,
  0x000188826666dddc, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0x0000d551ffffaaac, 0x0000000000000000,
  0x000108846666dddc, 0x0000000000000000,
  0x00010884e664dddc, 0x0000000000000000,
  0x000055540000aaa8, 0x0000000000000000,
  0x000088866667ddd8, 0x0000000000000000,
  0x00008886e665ddd8, 0x0000000000000000,
  0x000088876662dddc, 0x0000000000000000,
  0x0000333266673330, 0x0000000000000000,
  0x00003332e6653330, 0x0000000000000000,
  0x0000333366623334, 0x0000000000000000,
  0x00003333e65e333c, 0x0000000000000000,
  0x000000007ffe0000, 0x0000000000000000,
  0x00000000fffb0004, 0x0000000000000000,
  0x000000017ff7000c, 0x0000000000000000,
  0x00000001fff20018, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x00000000fff9000c, 0x0000000000000000,
  0x000000017ff40018, 0x0000000000000000,
  0x000000018073fe18, 0x0000000000000000,
  0x000000007ffc0008, 0x0000000000000000,
  0x00000000fff70014, 0x0000000000000000,
  0x000000010076fe14, 0x0000000000000000,
  0x0000000100f5fc18, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x00000000807afe0c, 0x0000000000000000,
  0x0000000080f9fc10, 0x0000000000000000,
  0x000000008177fa18, 0x0000000000000000,
  0x00000000007ffe00, 0x0000000000000000,
  0x0000000000fefc04, 0x0000000000000000,
  0x00000000017cfa0c, 0x0000000000000000,
  0x0000000001f9f818, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x0000000000fcfc0c, 0x0000000000000000,
  0x000000000179fa18, 0x0000000000000000,
  0x000000000199f998, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x0000000000fafc14, 0x0000000000000000,
  0x00000000011afb94, 0x0000000000000000,
  0x00000000011dfb88, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x00000000009cfd8c, 0x0000000000000000,
  0x00000000009ffd80, 0x0000000000000000,
  0x0000000000a1fd78, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x000000000022ff74, 0x0000000000000000,
  0x000000000024ff6c, 0x0000000000000000,
  0x000000000025ff68, 0x0000000000000000,
  0x000000000002ffee, 0x0000000000000000,
  0x000000000004ffe2, 0x0000000000000000,
  0x000000000005ffdc, 0x0000000000000000,
  0x000000000005ffdc, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x000000000002ffee, 0x0000000000000000,
  0x000000000002ffee, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xfffffffffffd0012, 0x0000000000000000,
  0xffffffffffdd00d2, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xfffffffffffd0012, 0x0000000000000000,
  0xffffffffffdd00d2, 0x0000000000000000,
  0xffffffffff6003c0, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0xffffffffffde00cc, 0x0000000000000000,
  0xffffffffff6103ba, 0x0000000000000000,
  0xfffffffffee306ae, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xffffffffff6303ae, 0x0000000000000000,
  0xfffffffffee506a2, 0x0000000000000000,
  0xfffffffffe66099c, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffff0505e2, 0x0000000000000000,
  0xfffffffffe8608dc, 0x0000000000000000,
  0xffffffff7e8c08ca, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffff0305ee, 0x0000000000000000,
  0xffffffff7f0905dc, 0x0000000000000000,
  0xfffffffeff0e05d0, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffff7f8702e8, 0x0000000000000000,
  0xfffffffeff8c02dc, 0x0000000000000000,
  0xfffffffe7f9002d6, 0x0000000000000000,
  0xffffffff8005ffee, 0x0000000000000000,
  0xffffffff000affe2, 0x0000000000000000,
  0xfffffffe800effdc, 0x0000000000000000,
  0xffffcccc800f330e, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffff0008ffee, 0x0000000000000000,
  0xffffcccd00093320, 0x0000000000000000,
  0xffff7779aab4331e, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffcccd8004332c, 0x0000000000000000,
  0xffff777a2aaf332a, 0x0000000000000000,
  0xfffef77d2ab23318, 0x0000000000000000,
  0xffffccce00003332, 0x0000000000000000,
  0xffff777aaaab3330, 0x0000000000000000,
  0xfffef77daaae331e, 0x0000000000000000,
  0xfffe7780aab03312, 0x0000000000000000,
  0xffffaaacaaaafffe, 0x0000000000000000,
  0xffff2aafaaadffec, 0x0000000000000000,
  0xfffeaab2aaafffe0, 0x0000000000000000,
  0xfffe2ab5aab0ffda, 0x0000000000000000,
  0xffff80030002ffee, 0x0000000000000000,
  0xffff00060004ffe2, 0x0000000000000000,
  0xfffe80090005ffdc, 0x0000000000000000,
  0xffff00060005ffdc, 0x0000000000000000,
  0xffff80030001fff4, 0x0000000000000000,
  0xffff00060002ffee, 0x0000000000000000,
  0xffff80030002ffee, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x00007ffd00000000, 0x0000000000000000,
  0x0000d5505555fffc, 0x0000000000000000,
  0x00007ffd00000000, 0x0000000000000000,
  0x0000fff9ffff0006, 0x0000000000000000,
  0x0001554d55550002, 0x0000000000000000,
  0x0001887f5555ccca, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0x0000d55055550002, 0x0000000000000000,
  0x000108825555ccca, 0x0000000000000000,
  0x00010882d552ccca, 0x0000000000000000,
  0x000055535555fffc, 0x0000000000000000,
  0x000088855556ccc4, 0x0000000000000000,
  0x00008885d553ccc4, 0x0000000000000000,
  0x00008886554fccca, 0x0000000000000000,
  0x000033320000ccc8, 0x0000000000000000,
  0x000033327ffdccc8, 0x0000000000000000,
  0x00003332fff9ccce, 0x0000000000000000,
  0x000033337ff4ccda, 0x0000000000000000,
  0x000000007ffd0000, 0x0000000000000000,
  0x00000000fff90006, 0x0000000000000000,
  0x000000017ff40012, 0x0000000000000000,
  0x00000001ffee0024, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x00000000fff70012, 0x0000000000000000,
  0x000000017ff10024, 0x0000000000000000,
  0x000000018070fd24, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x00000000fff5001e, 0x0000000000000000,
  0x000000010074fd1e, 0x0000000000000000,
  0x0000000100f3fa24, 0x0000000000000000,
  0x000000007ffa0012, 0x0000000000000000,
  0x000000008079fd12, 0x0000000000000000,
  0x0000000080f8fa18, 0x0000000000000000,
  0x000000008176f724, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0x0000000000fefa06, 0x0000000000000000,
  0x00000000017cf712, 0x0000000000000000,
  0x0000000001f9f424, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x0000000000fcfa12, 0x0000000000000000,
  0x000000000179f724, 0x0000000000000000,
  0x000000000199f664, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x0000000000fafa1e, 0x0000000000000000,
  0x00000000011af95e, 0x0000000000000000,
  0x00000000011df94c, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x00000000009cfc52, 0x0000000000000000,
  0x00000000009ffc40, 0x0000000000000000,
  0x0000000000a1fc34, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x000000000022ff2e, 0x0000000000000000,
  0x000000000024ff22, 0x0000000000000000,
  0x000000000025ff1c, 0x0000000000000000,
  0x0000000000000300, 0x0000000000000000,
  0x0000000000000500, 0x0000000000000000,
  0x0000000000000600, 0x0000000000000000,
  0x0000000000000600, 0x0000000000000000,
  0x0000000000000200, 0x0000000000000000,
  0x0000000000000300, 0x0000000000000000,
  0x0000000000000300, 0x0000000000000000,
  0x0000000000000200, 0x0000000000000000,
  0x0000000000000100, 0x0000000000000000,
  0x0000000000000100, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffe00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff00, 0x0000000000000000,
  0xfffffffffffffd00, 0x0000000000000000,
  0xffffffffffffdd00, 0x0000000000000000,
  0xffffffffffffff00, 0x0000000000000000,
  0xfffffffffffffd00, 0x0000000000000000,
  0xffffffffffffdd00, 0x0000000000000000,
  0xffffffffffff6000, 0x0000000000000000,
  0xfffffffffffffe00, 0x0000000000000000,
  0xffffffffffffde00, 0x0000000000000000,
  0xffffffffffff6100, 0x0000000000000000,
  0xfffffffffffee300, 0x0000000000000000,
  0xffffffffffffe000, 0x0000000000000000,
  0xffffffffffff6300, 0x0000000000000000,
  0xfffffffffffee500, 0x0000000000000000,
  0xfffffffffffe6600, 0x0000000000000000,
  0xffffffffffff8300, 0x0000000000000000,
  0xffffffffffff0500, 0x0000000000000000,
  0xfffffffffffe8600, 0x0000000000000000,
  0xffffffffff7e8900, 0x0000000000000000,
  0xffffffffffff8200, 0x0000000000000000,
  0xffffffffffff0300, 0x0000000000000000,
  0xffffffffff7f0600, 0x0000000000000000,
  0xfffffffffeff0800, 0x0000000000000000,
  0xffffffffffff8100, 0x0000000000000000,
  0xffffffffff7f8400, 0x0000000000000000,
  0xfffffffffeff8600, 0x0000000000000000,
  0xfffffffffe7f8700, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0xffffffffff000500, 0x0000000000000000,
  0xfffffffffe800600, 0x0000000000000000,
  0xffffffcccb4cd300, 0x0000000000000000,
  0xffffffffff800200, 0x0000000000000000,
  0xffffffffff000300, 0x0000000000000000,
  0xffffffcccbccd000, 0x0000000000000000,
  0xffffff7776777b00, 0x0000000000000000,
  0xffffffffff800100, 0x0000000000000000,
  0xffffffcccc4cce00, 0x0000000000000000,
  0xffffff7776f77900, 0x0000000000000000,
  0xfffffef776f77c00, 0x0000000000000000,
  0xffffffcccccccd00, 0x0000000000000000,
  0xffffff7777777800, 0x0000000000000000,
  0xfffffef777777b00, 0x0000000000000000,
  0xfffffe7777777d00, 0x0000000000000000,
  0xffffffaaaaaaab00, 0x0000000000000000,
  0xffffff2aaaaaae00, 0x0000000000000000,
  0xfffffeaaaaaab000, 0x0000000000000000,
  0xfffffe2aaaaab100, 0x0000000000000000,
  0xffffff8000000300, 0x0000000000000000,
  0xffffff0000000500, 0x0000000000000000,
  0xfffffe8000000600, 0x0000000000000000,
  0xffffff0000000600, 0x0000000000000000,
  0xffffff8000000200, 0x0000000000000000,
  0xffffff0000000300, 0x0000000000000000,
  0xffffff8000000300, 0x0000000000000000,
  0x0000000000000200, 0x0000000000000000,
  0xffffff8000000100, 0x0000000000000000,
  0x0000000000000100, 0x0000000000000000,
  0x0000008000000000, 0x0000000000000000,
  0x000000d555555600, 0x0000000000000000,
  0x0000008000000000, 0x0000000000000000,
  0x000000ffffffff00, 0x0000000000000000,
  0x0000015555555500, 0x0000000000000000,
  0x0000018888888900, 0x0000000000000000,
  0x0000007fffffff00, 0x0000000000000000,
  0x000000d555555500, 0x0000000000000000,
  0x0000010888888900, 0x0000000000000000,
  0x0000010889088900, 0x0000000000000000,
  0x0000005555555600, 0x0000000000000000,
  0x0000008888888a00, 0x0000000000000000,
  0x0000008889088a00, 0x0000000000000000,
  0x0000008889888900, 0x0000000000000000,
  0x0000003333333400, 0x0000000000000000,
  0x0000003333b33400, 0x0000000000000000,
  0x0000003334333300, 0x0000000000000000,
  0x0000003334b33100, 0x0000000000000000,
  0x0000000000800000, 0x0000000000000000,
  0x0000000000ffff00, 0x0000000000000000,
  0x00000000017ffd00, 0x0000000000000000,
  0x0000000001fffa00, 0x0000000000000000,
  0x00000000007fff00, 0x0000000000000000,
  0x0000000000fffd00, 0x0000000000000000,
  0x00000000017ffa00, 0x0000000000000000,
  0x0000000001807a00, 0x0000000000000000,
  0x00000000007ffe00, 0x0000000000000000,
  0x0000000000fffb00, 0x0000000000000000,
  0x0000000001007b00, 0x0000000000000000,
  0x000000000100fa00, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0x0000000000807d00, 0x0000000000000000,
  0x000000000080fc00, 0x0000000000000000,
  0x0000000000817a00, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x000000000000ff00, 0x0000000000000000,
  0x0000000000017d00, 0x0000000000000000,
  0x000000000001fa00, 0x0000000000000000,
  0x0000000000007f00, 0x0000000000000000,
  0x000000000000fd00, 0x0000000000000000,
  0x0000000000017a00, 0x0000000000000000,
  0x0000000000019a00, 0x0000000000000000,
  0x0000000000007e00, 0x0000000000000000,
  0x000000000000fb00, 0x0000000000000000,
  0x0000000000011b00, 0x0000000000000000,
  0x0000000000011e00, 0x0000000000000000,
  0x0000000000007d00, 0x0000000000000000,
  0x0000000000009d00, 0x0000000000000000,
  0x000000000000a000, 0x0000000000000000,
  0x000000000000a200, 0x0000000000000000,
  0x0000000000002000, 0x0000000000000000,
  0x0000000000002300, 0x0000000000000000,
  0x0000000000002500, 0x0000000000000000,
  0x0000000000002600, 0x0000000000000000,
  0x00000000000002fa, 0x0000000000000000,
  0x00000000000004f6, 0x0000000000000000,
  0x00000000000005f4, 0x0000000000000000,
  0x00000000000005f4, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x00000000000002fa, 0x0000000000000000,
  0x00000000000002fa, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xfffffffffffffd06, 0x0000000000000000,
  0xffffffffffffdd46, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xfffffffffffffd06, 0x0000000000000000,
  0xffffffffffffdd46, 0x0000000000000000,
  0xffffffffffff6140, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0xffffffffffffde44, 0x0000000000000000,
  0xffffffffffff623e, 0x0000000000000000,
  0xfffffffffffee53a, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xffffffffffff643a, 0x0000000000000000,
  0xfffffffffffee736, 0x0000000000000000,
  0xfffffffffffe6934, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffffff06f6, 0x0000000000000000,
  0xfffffffffffe88f4, 0x0000000000000000,
  0xffffffffff7f8bee, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffffff04fa, 0x0000000000000000,
  0xffffffffff8007f4, 0x0000000000000000,
  0xffffffffff0109f0, 0x0000000000000000,
  0xffffffffffff81fe, 0x0000000000000000,
  0xffffffffff8084f8, 0x0000000000000000,
  0xffffffffff0186f4, 0x0000000000000000,
  0xfffffffffe8287f2, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffffff0204f6, 0x0000000000000000,
  0xfffffffffe8305f4, 0x0000000000000000,
  0xffffffcd31b6395a, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffffff0202fa, 0x0000000000000000,
  0xffffffcd32353660, 0x0000000000000000,
  0xffffff78878a8c0a, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffcd32b43464, 0x0000000000000000,
  0xffffff7888098a0e, 0x0000000000000000,
  0xfffffef988098d08, 0x0000000000000000,
  0xffffffcd33333366, 0x0000000000000000,
  0xffffff7888888910, 0x0000000000000000,
  0xfffffef988888c0a, 0x0000000000000000,
  0xfffffe7a88888e06, 0x0000000000000000,
  0xffffffab555555aa, 0x0000000000000000,
  0xffffff2c555558a4, 0x0000000000000000,
  0xfffffead55555aa0, 0x0000000000000000,
  0xfffffe2e55555b9e, 0x0000000000000000,
  0xffffff81000002fa, 0x0000000000000000,
  0xffffff02000004f6, 0x0000000000000000,
  0xfffffe83000005f4, 0x0000000000000000,
  0xffffff02000005f4, 0x0000000000000000,
  0xffffff81000001fc, 0x0000000000000000,
  0xffffff02000002fa, 0x0000000000000000,
  0xffffff81000002fa, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x0000007f00000000, 0x0000000000000000,
  0x000000d3aaaaab54, 0x0000000000000000,
  0x0000007f00000000, 0x0000000000000000,
  0x000000fdffffff02, 0x0000000000000000,
  0x00000152aaaaaa56, 0x0000000000000000,
  0x00000185777777ee, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0x000000d3aaaaaa56, 0x0000000000000000,
  0x00000106777777ee, 0x0000000000000000,
  0x0000010677f677ee, 0x0000000000000000,
  0x00000054aaaaab54, 0x0000000000000000,
  0x00000087777778ec, 0x0000000000000000,
  0x0000008777f678ec, 0x0000000000000000,
  0x00000087787577ee, 0x0000000000000000,
  0x00000032cccccd98, 0x0000000000000000,
  0x00000032cd4bcd98, 0x0000000000000000,
  0x00000032cdcacc9a, 0x0000000000000000,
  0x00000032ce49ca9e, 0x0000000000000000,
  0x00000000007f0000, 0x0000000000000000,
  0x0000000000fdff02, 0x0000000000000000,
  0x00000000017cfd06, 0x0000000000000000,
  0x0000000001fbfa0c, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x0000000000fdfd06, 0x0000000000000000,
  0x00000000017cfa0c, 0x0000000000000000,
  0x00000000017d790c, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x0000000000fdfb0a, 0x0000000000000000,
  0x0000000000fe7a0a, 0x0000000000000000,
  0x0000000000fef80c, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x00000000007f7c06, 0x0000000000000000,
  0x00000000007ffa08, 0x0000000000000000,
  0x000000000080770c, 0x0000000000000000,
  0x0000000000007f00, 0x0000000000000000,
  0x000000000000fd02, 0x0000000000000000,
  0x0000000000017a06, 0x0000000000000000,
  0x000000000001f60c, 0x0000000000000000,
  0x0000000000007e02, 0x0000000000000000,
  0x000000000000fb06, 0x0000000000000000,
  0x000000000001770c, 0x0000000000000000,
  0x00000000000196cc, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x000000000000f90a, 0x0000000000000000,
  0x00000000000118ca, 0x0000000000000000,
  0x0000000000011bc4, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x0000000000009bc6, 0x0000000000000000,
  0x0000000000009ec0, 0x0000000000000000,
  0x000000000000a0bc, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x00000000000022ba, 0x0000000000000000,
  0x00000000000024b6, 0x0000000000000000,
  0x00000000000025b4, 0x0000000000000000,
  0x00000000000002f4, 0x0000000000000000,
  0x00000000000004ec, 0x0000000000000000,
  0x00000000000005e8, 0x0000000000000000,
  0x00000000000005e8, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x00000000000002f4, 0x0000000000000000,
  0x00000000000002f4, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xfffffffffffffd0c, 0x0000000000000000,
  0xffffffffffffdd8c, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xfffffffffffffd0c, 0x0000000000000000,
  0xffffffffffffdd8c, 0x0000000000000000,
  0xffffffffffff6280, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0xffffffffffffde88, 0x0000000000000000,
  0xffffffffffff637c, 0x0000000000000000,
  0xfffffffffffee774, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xffffffffffff6574, 0x0000000000000000,
  0xfffffffffffee96c, 0x0000000000000000,
  0xfffffffffffe6c68, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffff08ec, 0x0000000000000000,
  0xfffffffffffe8be8, 0x0000000000000000,
  0xffffffffff808edc, 0x0000000000000000,
  0xffffffffffff83f8, 0x0000000000000000,
  0xffffffffffff06f4, 0x0000000000000000,
  0xffffffffff8109e8, 0x0000000000000000,
  0xffffffffff030be0, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffff8185f0, 0x0000000000000000,
  0xffffffffff0387e8, 0x0000000000000000,
  0xfffffffffe8588e4, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffff0404ec, 0x0000000000000000,
  0xfffffffffe8605e8, 0x0000000000000000,
  0xffffffcd981f9fb4, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff0402f4, 0x0000000000000000,
  0xffffffcd989d9cc0, 0x0000000000000000,
  0xffffff79989d9d14, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffcd991b9ac8, 0x0000000000000000,
  0xffffff79991b9b1c, 0x0000000000000000,
  0xfffffefb991b9e10, 0x0000000000000000,
  0xffffffcd999999cc, 0x0000000000000000,
  0xffffff7999999a20, 0x0000000000000000,
  0xfffffefb99999d14, 0x0000000000000000,
  0xfffffe7d99999f0c, 0x0000000000000000,
  0xffffffac00000054, 0x0000000000000000,
  0xffffff2e00000348, 0x0000000000000000,
  0xfffffeb000000540, 0x0000000000000000,
  0xfffffe320000063c, 0x0000000000000000,
  0xffffff82000002f4, 0x0000000000000000,
  0xffffff04000004ec, 0x0000000000000000,
  0xfffffe86000005e8, 0x0000000000000000,
  0xffffff04000005e8, 0x0000000000000000,
  0xffffff82000001f8, 0x0000000000000000,
  0xffffff04000002f4, 0x0000000000000000,
  0xffffff82000002f4, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x0000007e00000000, 0x0000000000000000,
  0x000000d2000000a8, 0x0000000000000000,
  0x0000007e00000000, 0x0000000000000000,
  0x000000fbffffff04, 0x0000000000000000,
  0x0000014fffffffac, 0x0000000000000000,
  0x00000182666666dc, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0x000000d1ffffffac, 0x0000000000000000,
  0x00000104666666dc, 0x0000000000000000,
  0x0000010466e466dc, 0x0000000000000000,
  0x00000054000000a8, 0x0000000000000000,
  0x00000086666667d8, 0x0000000000000000,
  0x0000008666e467d8, 0x0000000000000000,
  0x00000086676266dc, 0x0000000000000000,
  0x0000003266666730, 0x0000000000000000,
  0x0000003266e46730, 0x0000000000000000,
  0x0000003267626634, 0x0000000000000000,
  0x0000003267e0643c, 0x0000000000000000,
  0x00000000007e0000, 0x0000000000000000,
  0x0000000000fbff04, 0x0000000000000000,
  0x000000000179fd0c, 0x0000000000000000,
  0x0000000001f7fa18, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x0000000000fbfd0c, 0x0000000000000000,
  0x000000000179fa18, 0x0000000000000000,
  0x00000000017a7818, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x0000000000fbfb14, 0x0000000000000000,
  0x0000000000fc7914, 0x0000000000000000,
  0x0000000000fcf618, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x00000000007e7b0c, 0x0000000000000000,
  0x00000000007ef810, 0x0000000000000000,
  0x00000000007f7418, 0x0000000000000000,
  0x0000000000007e00, 0x0000000000000000,
  0x000000000000fb04, 0x0000000000000000,
  0x000000000001770c, 0x0000000000000000,
  0x000000000001f218, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x000000000000f90c, 0x0000000000000000,
  0x0000000000017418, 0x0000000000000000,
  0x0000000000019398, 0x0000000000000000,
  0x0000000000007c08, 0x0000000000000000,
  0x000000000000f714, 0x0000000000000000,
  0x0000000000011694, 0x0000000000000000,
  0x0000000000011988, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x0000000000009a8c, 0x0000000000000000,
  0x0000000000009d80, 0x0000000000000000,
  0x0000000000009f78, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x0000000000002274, 0x0000000000000000,
  0x000000000000246c, 0x0000000000000000,
  0x0000000000002568, 0x0000000000000000,
  0x00000000000002ee, 0x0000000000000000,
  0x00000000000004e2, 0x0000000000000000,
  0x00000000000005dc, 0x0000000000000000,
  0x00000000000005dc, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x00000000000002ee, 0x0000000000000000,
  0x00000000000002ee, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xfffffffffffffd12, 0x0000000000000000,
  0xffffffffffffddd2, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xfffffffffffffd12, 0x0000000000000000,
  0xffffffffffffddd2, 0x0000000000000000,
  0xffffffffffff63c0, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0xffffffffffffdecc, 0x0000000000000000,
  0xffffffffffff64ba, 0x0000000000000000,
  0xfffffffffffee9ae, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xffffffffffff66ae, 0x0000000000000000,
  0xfffffffffffeeba2, 0x0000000000000000,
  0xfffffffffffe6f9c, 0x0000000000000000,
  0xffffffffffff85ee, 0x0000000000000000,
  0xffffffffffff0ae2, 0x0000000000000000,
  0xfffffffffffe8edc, 0x0000000000000000,
  0xffffffffff8191ca, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffff08ee, 0x0000000000000000,
  0xffffffffff820bdc, 0x0000000000000000,
  0xffffffffff050dd0, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffff8286e8, 0x0000000000000000,
  0xffffffffff0588dc, 0x0000000000000000,
  0xfffffffffe8889d6, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffff0604e2, 0x0000000000000000,
  0xfffffffffe8905dc, 0x0000000000000000,
  0xffffffcdfe89060e, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffff0602ee, 0x0000000000000000,
  0xffffffcdff060320, 0x0000000000000000,
  0xffffff7aa9b0ae1e, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffcdff83012c, 0x0000000000000000,
  0xffffff7aaa2dac2a, 0x0000000000000000,
  0xfffffefdaa2daf18, 0x0000000000000000,
  0xffffffce00000032, 0x0000000000000000,
  0xffffff7aaaaaab30, 0x0000000000000000,
  0xfffffefdaaaaae1e, 0x0000000000000000,
  0xfffffe80aaaab012, 0x0000000000000000,
  0xffffffacaaaaaafe, 0x0000000000000000,
  0xffffff2faaaaadec, 0x0000000000000000,
  0xfffffeb2aaaaafe0, 0x0000000000000000,
  0xfffffe35aaaab0da, 0x0000000000000000,
  0xffffff83000002ee, 0x0000000000000000,
  0xffffff06000004e2, 0x0000000000000000,
  0xfffffe89000005dc, 0x0000000000000000,
  0xffffff06000005dc, 0x0000000000000000,
  0xffffff83000001f4, 0x0000000000000000,
  0xffffff06000002ee, 0x0000000000000000,
  0xffffff83000002ee, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x0000007d00000000, 0x0000000000000000,
  0x000000d0555555fc, 0x0000000000000000,
  0x0000007d00000000, 0x0000000000000000,
  0x000000f9ffffff06, 0x0000000000000000,
  0x0000014d55555502, 0x0000000000000000,
  0x0000017f555555ca, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0x000000d055555502, 0x0000000000000000,
  0x00000102555555ca, 0x0000000000000000,
  0x0000010255d255ca, 0x0000000000000000,
  0x00000053555555fc, 0x0000000000000000,
  0x00000085555556c4, 0x0000000000000000,
  0x0000008555d256c4, 0x0000000000000000,
  0x00000085564f55ca, 0x0000000000000000,
  0x00000032000000c8, 0x0000000000000000,
  0x00000032007d00c8, 0x0000000000000000,
  0x0000003200f9ffce, 0x0000000000000000,
  0x000000320176fdda, 0x0000000000000000,
  0x00000000007d0000, 0x0000000000000000,
  0x0000000000f9ff06, 0x0000000000000000,
  0x000000000176fd12, 0x0000000000000000,
  0x0000000001f3fa24, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x0000000000f9fd12, 0x0000000000000000,
  0x000000000176fa24, 0x0000000000000000,
  0x0000000001777724, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x0000000000f9fb1e, 0x0000000000000000,
  0x0000000000fa781e, 0x0000000000000000,
  0x0000000000faf424, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x00000000007d7a12, 0x0000000000000000,
  0x00000000007df618, 0x0000000000000000,
  0x00000000007e7124, 0x0000000000000000,
  0x0000000000007d00, 0x0000000000000000,
  0x000000000000f906, 0x0000000000000000,
  0x0000000000017412, 0x0000000000000000,
  0x000000000001ee24, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x000000000000f712, 0x0000000000000000,
  0x0000000000017124, 0x0000000000000000,
  0x0000000000019064, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x000000000000f51e, 0x0000000000000000,
  0x000000000001145e, 0x0000000000000000,
  0x000000000001174c, 0x0000000000000000,
  0x0000000000007a12, 0x0000000000000000,
  0x0000000000009952, 0x0000000000000000,
  0x0000000000009c40, 0x0000000000000000,
  0x0000000000009e34, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x000000000000222e, 0x0000000000000000,
  0x0000000000002422, 0x0000000000000000,
  0x000000000000251c, 0x0000000000000000,
  0x00000000000000c0, 0x0000000000000000,
  0x0000000000000140, 0x0000000000000000,
  0x0000000000000180, 0x0000000000000000,
  0x0000000000000180, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x00000000000000c0, 0x0000000000000000,
  0x00000000000000c0, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xfffffffffffff740, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xfffffffffffff740, 0x0000000000000000,
  0xffffffffffffd800, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xfffffffffffff780, 0x0000000000000000,
  0xffffffffffffd840, 0x0000000000000000,
  0xffffffffffffb8c0, 0x0000000000000000,
  0xfffffffffffff800, 0x0000000000000000,
  0xffffffffffffd8c0, 0x0000000000000000,
  0xffffffffffffb940, 0x0000000000000000,
  0xffffffffffff9980, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xffffffffffffc140, 0x0000000000000000,
  0xffffffffffffa180, 0x0000000000000000,
  0xffffffffffdfa240, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xffffffffffffc0c0, 0x0000000000000000,
  0xffffffffffdfc180, 0x0000000000000000,
  0xffffffffffbfc200, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xffffffffffdfe100, 0x0000000000000000,
  0xffffffffffbfe180, 0x0000000000000000,
  0xffffffffff9fe1c0, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xffffffffffc00140, 0x0000000000000000,
  0xffffffffffa00180, 0x0000000000000000,
  0xfffffff332d334c0, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xffffffffffc000c0, 0x0000000000000000,
  0xfffffff332f33400, 0x0000000000000000,
  0xffffffdddd9ddec0, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xfffffff333133380, 0x0000000000000000,
  0xffffffddddbdde40, 0x0000000000000000,
  0xffffffbdddbddf00, 0x0000000000000000,
  0xfffffff333333340, 0x0000000000000000,
  0xffffffddddddde00, 0x0000000000000000,
  0xffffffbddddddec0, 0x0000000000000000,
  0xffffff9ddddddf40, 0x0000000000000000,
  0xffffffeaaaaaaac0, 0x0000000000000000,
  0xffffffcaaaaaab80, 0x0000000000000000,
  0xffffffaaaaaaac00, 0x0000000000000000,
  0xffffff8aaaaaac40, 0x0000000000000000,
  0xffffffe0000000c0, 0x0000000000000000,
  0xffffffc000000140, 0x0000000000000000,
  0xffffffa000000180, 0x0000000000000000,
  0xffffffc000000180, 0x0000000000000000,
  0xffffffe000000080, 0x0000000000000000,
  0xffffffc0000000c0, 0x0000000000000000,
  0xffffffe0000000c0, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x0000002000000000, 0x0000000000000000,
  0x0000003555555580, 0x0000000000000000,
  0x0000002000000000, 0x0000000000000000,
  0x0000003fffffffc0, 0x0000000000000000,
  0x0000005555555540, 0x0000000000000000,
  0x0000006222222240, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0x0000003555555540, 0x0000000000000000,
  0x0000004222222240, 0x0000000000000000,
  0x0000004222422240, 0x0000000000000000,
  0x0000001555555580, 0x0000000000000000,
  0x0000002222222280, 0x0000000000000000,
  0x0000002222422280, 0x0000000000000000,
  0x0000002222622240, 0x0000000000000000,
  0x0000000ccccccd00, 0x0000000000000000,
  0x0000000ccceccd00, 0x0000000000000000,
  0x0000000ccd0cccc0, 0x0000000000000000,
  0x0000000ccd2ccc40, 0x0000000000000000,
  0x0000000000200000, 0x0000000000000000,
  0x00000000003fffc0, 0x0000000000000000,
  0x00000000005fff40, 0x0000000000000000,
  0x00000000007ffe80, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x00000000003fff40, 0x0000000000000000,
  0x00000000005ffe80, 0x0000000000000000,
  0x0000000000601e80, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x00000000003ffec0, 0x0000000000000000,
  0x0000000000401ec0, 0x0000000000000000,
  0x0000000000403e80, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x0000000000201f40, 0x0000000000000000,
  0x0000000000203f00, 0x0000000000000000,
  0x0000000000205e80, 0x0000000000000000,
  0x0000000000002000, 0x0000000000000000,
  0x0000000000003fc0, 0x0000000000000000,
  0x0000000000005f40, 0x0000000000000000,
  0x0000000000007e80, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x0000000000003f40, 0x0000000000000000,
  0x0000000000005e80, 0x0000000000000000,
  0x0000000000006680, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x0000000000003ec0, 0x0000000000000000,
  0x00000000000046c0, 0x0000000000000000,
  0x0000000000004780, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x0000000000002740, 0x0000000000000000,
  0x0000000000002800, 0x0000000000000000,
  0x0000000000002880, 0x0000000000000000,
  0x0000000000000800, 0x0000000000000000,
  0x00000000000008c0, 0x0000000000000000,
  0x0000000000000940, 0x0000000000000000,
  0x0000000000000980, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_sqdmlal_D_S_S = 3844;

#endif  // VIXL_SIM_SQDMLAL_D_S_S_TRACE_AARCH64_H_
