/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.SerializationContext;
import java.util.Calendar;
import java.util.Date;

public abstract class ActionScriptDecoder {
    public boolean hasShell() {
        return false;
    }

    public Object createShell(Object encodedObject, Class desiredClass) {
        return null;
    }

    public abstract Object decodeObject(Object var1, Object var2, Class var3);

    public Object decodeObject(Object encodedObject, Class desiredClass) {
        Object shell = null;
        if (this.hasShell()) {
            shell = this.createShell(encodedObject, desiredClass);
        }
        return this.decodeObject(shell, encodedObject, desiredClass);
    }

    protected boolean canUseByReference(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return false;
        }
        if (o instanceof Number) {
            return false;
        }
        if (o instanceof Boolean) {
            return false;
        }
        if (o instanceof Date) {
            return SerializationContext.getSerializationContext().supportDatesByReference;
        }
        if (o instanceof Calendar) {
            return false;
        }
        return !(o instanceof Character);
    }

    protected static Object getDefaultPrimitiveValue(Class type) {
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        return null;
    }
}

