/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.MessageException;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.util.MethodKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMatcher {
    private final Map methodCache = new HashMap();
    private static final int ARGUMENT_CONVERSION_ERROR = 10006;
    private static final int CANNOT_INVOKE_METHOD = 10007;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class c, String methodName, List parameters) {
        Method method = null;
        Match bestMatch = new Match(methodName);
        Class[] suppliedParamTypes = MethodMatcher.paramTypes(parameters);
        MethodKey methodKey = new MethodKey(c, methodName, suppliedParamTypes);
        if (this.methodCache.containsKey(methodKey)) {
            String thisMethodName;
            method = (Method)this.methodCache.get(methodKey);
            bestMatch.matchedMethodName = thisMethodName = method.getName();
            Class[] desiredParamTypes = method.getParameterTypes();
            bestMatch.methodParamTypes = desiredParamTypes;
            MethodMatcher.convertParams(parameters, desiredParamTypes, bestMatch);
        } else {
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method thisMethod = methods[i];
                String thisMethodName = thisMethod.getName();
                if (!thisMethodName.equalsIgnoreCase(methodName)) continue;
                Match currentMatch = new Match(methodName);
                currentMatch.matchedMethodName = thisMethodName;
                if (bestMatch.matchedMethodName == null) {
                    bestMatch = currentMatch;
                }
                Class[] desiredParamTypes = thisMethod.getParameterTypes();
                currentMatch.methodParamTypes = desiredParamTypes;
                if (desiredParamTypes.length != suppliedParamTypes.length) continue;
                currentMatch.matchedByNumberOfParams = true;
                if (!bestMatch.matchedByNumberOfParams && bestMatch.matchedParamCount == 0) {
                    bestMatch = currentMatch;
                }
                MethodMatcher.convertParams(parameters, desiredParamTypes, currentMatch);
                if (currentMatch.matchedParamCount >= bestMatch.matchedParamCount) {
                    bestMatch = currentMatch;
                }
                if (currentMatch.matchedParamCount != desiredParamTypes.length) continue;
                method = thisMethod;
                bestMatch = currentMatch;
                Map map = this.methodCache;
                synchronized (map) {
                    Method method2 = (Method)this.methodCache.get(methodKey);
                    if (method2 == null) {
                        this.methodCache.put(methodKey, method);
                    } else {
                        method = method2;
                    }
                    break;
                }
            }
        }
        if (method == null) {
            MethodMatcher.methodNotFound(methodName, suppliedParamTypes, bestMatch);
        } else if (bestMatch.paramTypeConversionFailure != null) {
            MessageException me = new MessageException();
            me.setMessage(10006);
            me.setCode("Server.Processing");
            me.setRootCause(bestMatch.paramTypeConversionFailure);
            throw me;
        }
        return method;
    }

    public static void convertParams(List parameters, Class[] desiredParamTypes, Match currentMatch) {
        int matchCount = 0;
        currentMatch.matchedParamCount = 0;
        currentMatch.convertedSuppliedTypes = new Class[desiredParamTypes.length];
        TypeMarshaller marshaller = TypeMarshallingContext.getTypeMarshaller();
        for (int i = 0; i < desiredParamTypes.length; ++i) {
            Object param = parameters.get(i);
            if (param != null) {
                Object obj;
                block5: {
                    obj = null;
                    if (marshaller != null) {
                        try {
                            obj = marshaller.convert(param, desiredParamTypes[i]);
                            break block5;
                        }
                        catch (MessageException ex) {
                            currentMatch.paramTypeConversionFailure = ex;
                            break;
                        }
                    }
                    obj = param;
                }
                Class<?> clazz = currentMatch.convertedSuppliedTypes[i] = obj != null ? obj.getClass() : null;
                if (!(desiredParamTypes[i].isAssignableFrom(obj.getClass()) || desiredParamTypes[i] == Integer.TYPE && (class$java$lang$Integer == null ? MethodMatcher.class$("java.lang.Integer") : class$java$lang$Integer).isAssignableFrom(obj.getClass()) || desiredParamTypes[i] == Double.TYPE && (class$java$lang$Double == null ? MethodMatcher.class$("java.lang.Double") : class$java$lang$Double).isAssignableFrom(obj.getClass()) || desiredParamTypes[i] == Long.TYPE && (class$java$lang$Long == null ? MethodMatcher.class$("java.lang.Long") : class$java$lang$Long).isAssignableFrom(obj.getClass()) || desiredParamTypes[i] == Boolean.TYPE && (class$java$lang$Boolean == null ? MethodMatcher.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(obj.getClass()) || desiredParamTypes[i] == Character.TYPE && (class$java$lang$Character == null ? MethodMatcher.class$("java.lang.Character") : class$java$lang$Character).isAssignableFrom(obj.getClass()) || desiredParamTypes[i] == Float.TYPE && (class$java$lang$Float == null ? MethodMatcher.class$("java.lang.Float") : class$java$lang$Float).isAssignableFrom(obj.getClass()) || desiredParamTypes[i] == Short.TYPE && (class$java$lang$Short == null ? MethodMatcher.class$("java.lang.Short") : class$java$lang$Short).isAssignableFrom(obj.getClass())) && (desiredParamTypes[i] != Byte.TYPE || !(class$java$lang$Byte == null ? MethodMatcher.class$("java.lang.Byte") : class$java$lang$Byte).isAssignableFrom(obj.getClass()))) break;
                parameters.set(i, obj);
                ++matchCount;
                continue;
            }
            ++matchCount;
        }
        currentMatch.matchedParamCount = matchCount;
    }

    public static Class[] paramTypes(List parameters) {
        Class[] paramTypes = new Class[parameters.size()];
        for (int i = 0; i < paramTypes.length; ++i) {
            Object p = parameters.get(i);
            paramTypes[i] = p == null ? (class$java$lang$Object == null ? MethodMatcher.class$("java.lang.Object") : class$java$lang$Object) : p.getClass();
        }
        return paramTypes;
    }

    public static void methodNotFound(String methodName, Class[] suppliedParamTypes, Match bestMatch) {
        int errorCode = 10007;
        Object[] errorParams = new Object[]{methodName};
        String errorDetailVariant = "0";
        Object[] errorDetailParams = new Object[]{methodName};
        if (bestMatch.matchedMethodName != null) {
            int expectedParamCount;
            errorCode = 10007;
            errorParams = new Object[]{bestMatch.matchedMethodName};
            int suppliedParamCount = suppliedParamTypes.length;
            int n = expectedParamCount = bestMatch.methodParamTypes != null ? bestMatch.methodParamTypes.length : 0;
            if (suppliedParamCount != expectedParamCount) {
                errorDetailVariant = "1";
                errorDetailParams = new Object[]{new Integer(suppliedParamCount), new Integer(expectedParamCount)};
            } else {
                String suppliedTypes = bestMatch.listTypes(suppliedParamTypes);
                String convertedTypes = bestMatch.listConvertedTypes();
                String expectedTypes = bestMatch.listExpectedTypes();
                if (expectedTypes != null) {
                    if (suppliedTypes != null) {
                        if (convertedTypes != null) {
                            errorDetailVariant = "2";
                            errorDetailParams = new Object[]{expectedTypes, suppliedTypes, convertedTypes};
                        } else {
                            errorDetailVariant = "3";
                            errorDetailParams = new Object[]{expectedTypes, suppliedTypes};
                        }
                    } else {
                        errorDetailVariant = "4";
                        errorDetailParams = new Object[]{expectedTypes};
                    }
                } else {
                    errorDetailVariant = "5";
                    errorDetailParams = new Object[]{suppliedTypes};
                }
            }
        }
        MessageException ex = new MessageException();
        ex.setMessage(errorCode, errorParams);
        ex.setCode("Server.ResourceUnavailable");
        if (errorDetailVariant != null) {
            ex.setDetails(errorCode, errorDetailVariant, errorDetailParams);
        }
        if (bestMatch.paramTypeConversionFailure != null) {
            ex.setRootCause(bestMatch.paramTypeConversionFailure);
        }
        throw ex;
    }

    public static class Match {
        final String methodName;
        String matchedMethodName;
        boolean matchedByNumberOfParams;
        int matchedParamCount;
        Class[] methodParamTypes;
        Class[] convertedSuppliedTypes;
        Exception paramTypeConversionFailure;

        public Match(String name) {
            this.methodName = name;
        }

        public boolean matchedExactlyByName() {
            if (this.matchedMethodName != null) {
                return this.matchedMethodName.equals(this.methodName);
            }
            return false;
        }

        public boolean matchedLooselyByName() {
            if (this.matchedMethodName != null) {
                return !this.matchedExactlyByName() && this.matchedMethodName.equalsIgnoreCase(this.methodName);
            }
            return false;
        }

        public String listExpectedTypes() {
            return this.listTypes(this.methodParamTypes);
        }

        public String listConvertedTypes() {
            return this.listTypes(this.convertedSuppliedTypes);
        }

        public String listTypes(Class[] types) {
            if (types != null && types.length > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < types.length; ++i) {
                    Class<?> c;
                    if (i > 0) {
                        sb.append(", ");
                    }
                    if ((c = types[i]) != null) {
                        if (c.isArray()) {
                            c = c.getComponentType();
                            sb.append(c.getName()).append("[]");
                            continue;
                        }
                        sb.append(c.getName());
                        continue;
                    }
                    sb.append("null");
                }
                return sb.toString();
            }
            return null;
        }
    }
}

