/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import org.ccil.cowan.tagsoup.AttributesImpl;
import org.ccil.cowan.tagsoup.ElementType;

public class Element {
    private ElementType theType;
    private AttributesImpl theAtts;
    private Element theNext;
    private boolean preclosed;

    public Element(ElementType elementType) {
        this.theType = elementType;
        this.theAtts = new AttributesImpl(elementType.atts());
        this.theNext = null;
        this.preclosed = false;
    }

    public ElementType type() {
        return this.theType;
    }

    public AttributesImpl atts() {
        return this.theAtts;
    }

    public Element next() {
        return this.theNext;
    }

    public void setNext(Element element) {
        this.theNext = element;
    }

    public String name() {
        return this.theType.name();
    }

    public String namespace() {
        return this.theType.namespace();
    }

    public String localName() {
        return this.theType.localName();
    }

    public int model() {
        return this.theType.model();
    }

    public int memberOf() {
        return this.theType.memberOf();
    }

    public int flags() {
        return this.theType.flags();
    }

    public ElementType parent() {
        return this.theType.parent();
    }

    public boolean canContain(Element element) {
        return this.theType.canContain(element.theType);
    }

    public void setAttribute(String string, String string2, String string3) {
        this.theType.setAttribute(this.theAtts, string, string2, string3);
    }

    public void anonymize() {
        for (int i = this.theAtts.getLength() - 1; i >= 0; --i) {
            if (!this.theAtts.getType(i).equals("ID") && !this.theAtts.getQName(i).equals("name")) continue;
            this.theAtts.removeAttribute(i);
        }
    }

    public void clean() {
        for (int i = this.theAtts.getLength() - 1; i >= 0; --i) {
            String string = this.theAtts.getLocalName(i);
            if (this.theAtts.getValue(i) == null || string == null || string.length() == 0) {
                this.theAtts.removeAttribute(i);
                continue;
            }
            if (!this.theAtts.getType(i).equals("BOOLEAN")) continue;
            this.theAtts.setType(i, "NMTOKEN");
        }
    }

    public void preclose() {
        this.preclosed = true;
    }

    public boolean isPreclosed() {
        return this.preclosed;
    }
}

