Welcome to wxWidgets, a free and open source cross-platform C++ framework for writing advanced GUI applications using native controls.

wxWidgets 3.2.7 is part of 3.2 stable branch. This means that it is API _and_ ABI-compatible with the previous 3.2.x releases, i.e. the applications previously built using 3.2.6 or earlier shared libraries will continue working with this release even without recompiling when using shared libraries and can be rebuilt without any changes to the code otherwise.

We recommend using this version for any new wxWidgets applications. Existing applications using wxWidgets 3.0 or 3.1 shouldn't require any special effort to upgrade to this version too, so please try upgrading them to it.

Please see [**README**](https://raw.githubusercontent.com/wxWidgets/wxWidgets/v3.2.7/docs/readme.txt) for more information about this release and the [change log](https://raw.githubusercontent.com/wxWidgets/wxWidgets/v3.2.7/docs/changes.txt) for more details of the changes in it.


## Source Files and Documentation

If you intend to build wxWidgets from sources (which is recommended), please do **NOT** download the files using the "Source code" links just above, which are automatically generated by GitHub and don't contain the submodules sources which are necessary for building wxWidgets.

Instead, download one of [wxWidgets-3.2.7.zip](https://github.com/wxWidgets/wxWidgets/releases/download/v3.2.7/wxWidgets-3.2.7.zip) or [wxWidgets-3.2.7.7z](https://github.com/wxWidgets/wxWidgets/releases/download/v3.2.7/wxWidgets-3.2.7.7z), for much smaller size, for Microsoft Windows systems or [wxWidgets-3.2.7.tar.bz2](https://github.com/wxWidgets/wxWidgets/releases/download/v3.2.7/wxWidgets-3.2.7.tar.bz2) for Unix ones, including macOS. These archives have exactly the same contents, but use the line endings appropriate for the corresponding platform.

In addition, we provide archives containing the documentation in either HTML or Microsoft CHM formats. Notice that the documentation is also [available online](https://docs.wxwidgets.org/3.2.7).

Finally, Microsoft Windows users may download [Setup.exe file](https://github.com/wxWidgets/wxWidgets/releases/download/v3.2.7/wxMSW-3.2.7-Setup.exe) containing both sources and documentation, however please note that this file does _not_ contain any binaries, please see below for those.

To verify your download please use the following SHA-1 checksums:

    0000000000000000000000000000000000000000  wxMSW-3.2.7-Setup.exe
    0000000000000000000000000000000000000000  wxWidgets-3.2.7-docs-chm.zip
    0000000000000000000000000000000000000000  wxWidgets-3.2.7-docs-html.tar.bz2
    0000000000000000000000000000000000000000  wxWidgets-3.2.7-docs-html.zip
    0000000000000000000000000000000000000000  wxWidgets-3.2.7-headers.7z
    0000000000000000000000000000000000000000  wxWidgets-3.2.7.7z
    0000000000000000000000000000000000000000  wxWidgets-3.2.7.tar.bz2
    0000000000000000000000000000000000000000  wxWidgets-3.2.7.zip

## Binaries

We provide pre-built binary files for the following compilers:

* Microsoft Visual C++ compiler versions 9.0, 10.0, 11.0, 12.0, 14.0, 14.1, 14.2 and 14.3 (corresponding to marketing product names of Microsoft Visual Studio 2008, 2010, 2012, 2013, 2015, 2017, 2019 and 2022 respectively). Please note that MSVC 14.x versions are ABI-compatible and the same set of binaries is used for all of them.
* MinGW-w64 versions 7.3 and 8.1 (32-bit binaries use SJLJ exceptions, 64-bit ones use SEH, and all binaries use Win32 threads).
* [TDM-GCC](https://jmeubank.github.io/tdm-gcc/) 10.3.0.
* [MSYS2](https://www.msys2.org/) MinGW 12.2.0 and 13.2.0.

### For Developers

For developing applications with wxWidgets you need to download the compiler-independent `wxWidgets-3.2.7_Headers.7z` file and one of `wxMSW-3.2.7-vcXXX_Dev.7z` or `wxMSW-3.2.7_gccXXX_Dev.7z` files depending on your compiler, its version and the target architecture (x86 if not specified or x64).

Unpack both files into the same directory so that `include` and `lib` directories are at the same level after unpacking. You should be able to compile and link applications using wxWidgets in both debug and release modes but the debug symbols are provided only for debug libraries in this archive, see below for the release build debug symbols.

Note that if you're setting up a new project using these binaries, the simplest way to do it is to use the provided `wxwidgets.props` file: for this, open the `View|Property Manager` menu item in the IDE, select "Add Existing Property Sheet..." from the project context menu and browse to this file in the file open dialog.

### For End Users

End users may download one of `wxMSW-3.2.7_vcXXX_ReleaseDLL.7z` or `wxMSW-3.2.7_gccXXX_ReleaseDLL.7z` files to get just the DLLs required for running the applications using wxWidgets.

### For Debugging

* Microsoft Visual C++ users: Files `wxMSW-3.2.7_vcXXX_ReleasePDB.7z` contain the debug symbols for the release build of the DLLs. Download them if you want to debug your own applications in release build or if you want to get meaningful information from mini-dumps retrieved from your users machines.
* MinGW-TDM users: Currently the debug symbols are not available for the release build of the DLLs (only the debug versions of the DLLs contains the debug symbols).

### Binary File Download Verification

To verify your download please use the following SHA-1 checksums:

    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc730_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc730_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc730_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc730_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc810_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc810_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc810_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc810_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1030TDM_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1030TDM_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1030TDM_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1030TDM_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1220_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1220_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1220_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1220_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1320_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1320_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1320_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_gcc1320_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc90_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc90_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc90_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc90_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc90_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc90_x64_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc100_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc100_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc100_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc100_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc100_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc100_x64_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc110_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc110_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc110_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc110_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc110_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc110_x64_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc120_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc120_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc120_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc120_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc120_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc120_x64_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc14x_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc14x_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc14x_ReleasePDB.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc14x_x64_Dev.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc14x_x64_ReleaseDLL.7z
    0000000000000000000000000000000000000000 wxMSW-3.2.7_vc14x_x64_ReleasePDB.7z

## Reporting Problems

Please report bugs to the [issue tracker](https://github.com/wxWidgets/wxWidgets/issues/new) or the [wx-users mailing list](http://groups.google.com/group/wx-users).
