/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.error.reporting.ui;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.error.reporting.ui.NotificationUtility;
import com.paterva.maltego.error.reporting.ui.ProblemDtoBuilder;
import com.paterva.maltego.util.MaltegoUrl;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProblemSender {
    private static final Logger LOG = Logger.getLogger(ProblemSender.class.getName());
    private final ProblemDtoBuilder problemBuilder;
    private final int timeoutMillis = 15000;

    public ProblemSender(ProblemDtoBuilder problemBuilder) {
        this.problemBuilder = problemBuilder;
    }

    public void send(boolean notify) {
        new Thread(() -> {
            block3: {
                try {
                    HttpAgent agent = new HttpAgent(new URL(MaltegoUrl.getCurrent().getErrorReport()));
                    agent.setConnectTimeout(15000);
                    agent.setReadTimeout(15000);
                    String problemJson = this.problemBuilder.buildJsonString();
                    LOG.log(Level.FINE, "Problem JSON:\n{0}", problemJson);
                    agent.doPostString("application/json", problemJson);
                    if (notify) {
                        NotificationUtility.showNotification("Problem Reported");
                    }
                }
                catch (Exception ex) {
                    String msg = "Failed to Report Problem";
                    LOG.warning(() -> msg + ": " + ex.getMessage());
                    if (!notify) break block3;
                    NotificationUtility.showNotification(msg);
                }
            }
        }).start();
    }
}

