/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.save;

import com.maltego.cloud.serializer.NeoJsonAttachmentsFactory;
import com.maltego.cloud.serializer.NeoJsonWriter;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.actions.FileOpenAction;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class TestSaveToCloudAction
extends TopGraphAction {
    private static final Logger LOG = Logger.getLogger(TestSaveToCloudAction.class.getName());
    private boolean isTestFileOpened = false;

    public TestSaveToCloudAction() {
        this.setEnabled(true);
    }

    protected boolean isEnabled(TopComponent tc) {
        return true;
    }

    public String getName() {
        return "Test Save To Maltego Cases";
    }

    protected void actionPerformed(TopComponent tc) {
        try {
            this.isTestFileOpened = true;
            URL url = ((Object)((Object)this)).getClass().getResource("L1-footprint.mtgl");
            File file = new File(url.toURI());
            FileOpenAction.open((File)file);
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void onTopGraphChanged() {
        super.onTopGraphChanged();
        if (this.isTestFileOpened) {
            try {
                GraphID maltegoGraphID = this.getTopGraphID();
                if (maltegoGraphID == null) {
                    return;
                }
                TopComponent topComponent = this.getTopComponent();
                String graphName = GraphUtils.getTopGraphName((TopComponent)topComponent, (String)"Cloud Graph");
                NeoJsonAttachmentsFactory attsFactory = new NeoJsonAttachmentsFactory();
                Map attachments = attsFactory.getAttachments(maltegoGraphID);
                NeoJsonWriter jsonWriter = new NeoJsonWriter(maltegoGraphID, graphName, attachments, null);
                String graphJson = jsonWriter.writeToString();
                LOG.info(graphJson);
                try {
                    Path path = Paths.get("test_cloud_graph.json", new String[0]);
                    Files.write(path, graphJson.getBytes(), new OpenOption[0]);
                    File file = path.toAbsolutePath().toFile();
                    LOG.info("cloud graph path : " + file.getAbsolutePath());
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)("Test cloud graph saved as;\n" + file.getAbsolutePath() + "\n\nDo you want to open containing folder?"), 2);
                    Object notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (NotifyDescriptor.OK_OPTION.equals(notify)) {
                        Desktop.getDesktop().open(file.getParentFile());
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.isTestFileOpened = false;
    }
}

