/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.TutorialDefaults;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TitlePanel
extends JPanel {
    private TourStep tourStep = TourStep.DEFAULT;
    private Runnable closeActionRunner = () -> this.tourStep.closeTour();
    private JLabel closeLabel;
    private JLabel titleLabel;

    public TitlePanel() {
        this.initComponents();
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitlePanel.this.closeActionRunner.run();
            }
        });
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
    }

    public void setCustomCloseAction(Runnable closeActionRunner) {
        this.closeActionRunner = closeActionRunner;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.closeLabel = new JLabel();
        this.setOpaque(false);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1, this.titleLabel.getFont().getSize() + 5));
        this.titleLabel.setForeground(TutorialDefaults.COLOR_TEXT);
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(TitlePanel.class, (String)"TitlePanel.titleLabel.text"));
        this.closeLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/guided/tour/ui/ico_close.png")));
        this.closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TitlePanel.this.closeLabelMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TitlePanel.this.closeLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TitlePanel.this.closeLabelMouseEntered(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 52, Short.MAX_VALUE).addComponent(this.closeLabel)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeLabel).addComponent(this.titleLabel));
    }

    private void closeLabelMouseEntered(MouseEvent evt) {
        this.closeLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/guided/tour/ui/ico_close-hovered.png")));
    }

    private void closeLabelMouseExited(MouseEvent evt) {
        this.closeLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/guided/tour/ui/ico_close.png")));
    }

    private void closeLabelMouseClicked(MouseEvent evt) {
        this.closeActionRunner.run();
    }
}

