/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.cache.skeletons;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonCache;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.EntitySectionsQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import com.paterva.maltego.graph.store.query.part.PartSectionsQuery;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class EntitySkeletonProvider {
    private static final Logger LOG = Logger.getLogger(EntitySkeletonProvider.class.getName());
    private final GraphID _graphID;
    private final GraphDataStoreReader _reader;
    private final EntitySkeletonCache _cache;
    private final GraphDataStore _graphDataStore;
    private EntityDataQuery _skeletonQuery;
    private PropertyChangeListener _dataStoreListener;

    EntitySkeletonProvider(GraphID _graphID, GraphDataStoreReader _reader, EntitySkeletonCache _cache, GraphDataStore _graphDataStore) {
        this._graphID = _graphID;
        this._reader = _reader;
        this._cache = _cache;
        this._graphDataStore = _graphDataStore;
    }

    public EntitySkeletonProvider(GraphID graphID) throws GraphStoreException {
        this._graphID = graphID;
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
        this._graphDataStore = graphStore.getGraphDataStore();
        this._reader = this._graphDataStore.getDataStoreReader();
        this._cache = new EntitySkeletonCache();
        this._dataStoreListener = new DataStoreListener();
        this._graphDataStore.addPropertyChangeListener(this._dataStoreListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new GraphCloseListener());
    }

    public MaltegoEntity getEntitySkeleton(EntityID id) throws GraphStoreException {
        MaltegoEntity skeleton = (MaltegoEntity)this._cache.get(id);
        if (skeleton != null) {
            return skeleton;
        }
        EntityDataQuery query = this.getEntitySkeletonQuery();
        skeleton = this._reader.getEntity(id, query);
        this.queryAndDecorateOverlays(skeleton);
        this._cache.put(id, skeleton);
        return skeleton;
    }

    public Map<EntityID, MaltegoEntity> getEntitySkeletons(Set<EntityID> ids) throws GraphStoreException {
        LOG.log(Level.FINE, "IDs: {0}", ids);
        HashMap<EntityID, MaltegoEntity> skeletons = new HashMap<EntityID, MaltegoEntity>(ids.size());
        HashSet<EntityID> toGetFromReader = new HashSet<EntityID>(ids.size());
        toGetFromReader.addAll(ids);
        for (EntityID id : ids) {
            MaltegoEntity skeleton = (MaltegoEntity)this._cache.get(id);
            if (skeleton == null) continue;
            skeletons.put(id, skeleton);
            toGetFromReader.remove(id);
        }
        if (!toGetFromReader.isEmpty()) {
            LOG.log(Level.FINE, "IDs: {0}", toGetFromReader);
            EntitiesDataQuery query = new EntitiesDataQuery();
            query.setIDs(toGetFromReader);
            query.setPartDataQuery((PartDataQuery)this.getEntitySkeletonQuery());
            Map maltegoEntities = this._reader.getEntities(query);
            LOG.log(Level.FINE, "Skeletons: {0}", maltegoEntities);
            for (MaltegoEntity skeleton : maltegoEntities.values()) {
                this.queryAndDecorateOverlays(skeleton);
            }
            skeletons.putAll(maltegoEntities);
            this._cache.put(maltegoEntities.values());
        }
        LOG.log(Level.FINE, "Skeletons: {0}\n\n", skeletons);
        if (ids.size() != skeletons.size()) {
            HashSet<EntityID> missing = new HashSet<EntityID>(ids);
            missing.removeAll(skeletons.keySet());
            throw new IllegalStateException("Skeletons not found for: " + missing);
        }
        return skeletons;
    }

    public void putSkeleton(MaltegoEntity entity) {
        MaltegoEntity skeleton = entity.createClone();
        skeleton.clear();
        skeleton.setDisplayInformation(null);
        OverlayDescriptorSet overlays = entity.getOverlaySet();
        if (overlays == null || overlays.isEmpty()) {
            this._cache.put(skeleton.getID(), skeleton);
            return;
        }
        this.setSkeletonOverlayData(skeleton, overlays, entity);
        this._cache.put(skeleton.getID(), skeleton);
    }

    public void removeEntitySkeleton(EntityID id) {
        this._cache.remove(id);
    }

    void queryAndDecorateOverlays(MaltegoEntity skeleton) throws GraphStoreException {
        OverlayDescriptorSet overlays = skeleton.getOverlaySet();
        if (overlays == null || overlays.isEmpty()) {
            return;
        }
        Set properties = overlays.stream().map(OverlayDescriptor::getPropertyName).collect(Collectors.toSet());
        EntityDataQuery query = new EntityDataQuery();
        query.setSections((PartSectionsQuery)new EntitySectionsQuery());
        query.setPropertyNames(properties);
        MaltegoEntity overlaydEntity = this._reader.getEntity((EntityID)skeleton.getID(), query);
        this.setSkeletonOverlayData(skeleton, overlays, overlaydEntity);
    }

    void setSkeletonOverlayData(MaltegoEntity skeleton, OverlayDescriptorSet overlays, MaltegoEntity data) {
        for (OverlayDescriptor overlay : overlays) {
            Object value;
            String propertyName = overlay.getPropertyName();
            if (propertyName.contains("$property(")) {
                this.setOverlayPropertyExpression(skeleton, propertyName, data);
                continue;
            }
            PropertyDescriptor property = data.getProperties().get(propertyName);
            if (property == null || (value = data.getValue(property)) == null) continue;
            skeleton.setValue(property, value);
        }
    }

    void setOverlayPropertyExpression(MaltegoEntity skeleton, String expression, MaltegoEntity data) {
        Matcher matcher = Evaluator.PROPERTY_PATTERN.matcher(expression);
        while (matcher.find()) {
            Object value;
            String group = matcher.group();
            String propertyName = group.substring(10, group.length() - 1);
            PropertyDescriptor property = data.getProperties().get(propertyName);
            if (property == null || (value = data.getValue(property)) == null) continue;
            skeleton.setValue(property, value);
        }
    }

    private synchronized EntityDataQuery getEntitySkeletonQuery() {
        if (this._skeletonQuery == null) {
            this._skeletonQuery = new EntityDataQuery();
            EntitySectionsQuery sectionsQuery = new EntitySectionsQuery();
            sectionsQuery.setQueryType(true);
            sectionsQuery.setQueryCachedValueStr(true);
            sectionsQuery.setQueryCachedDisplayStr(true);
            sectionsQuery.setQueryCachedImageValue(true);
            sectionsQuery.setQueryCachedHasAttachments(true);
            sectionsQuery.setQueryBookmark(true);
            sectionsQuery.setQueryNotes(true);
            sectionsQuery.setQueryWeight(true);
            this._skeletonQuery.setSections((PartSectionsQuery)sectionsQuery);
        }
        return this._skeletonQuery;
    }

    private class GraphCloseListener
    implements PropertyChangeListener {
        private GraphCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(EntitySkeletonProvider.this._graphID)) {
                GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                EntitySkeletonProvider.this._graphDataStore.removePropertyChangeListener(EntitySkeletonProvider.this._dataStoreListener);
                EntitySkeletonProvider.this._dataStoreListener = null;
            }
        }
    }

    private class DataStoreListener
    implements PropertyChangeListener {
        private DataStoreListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("partsChanged".equals(evt.getPropertyName())) {
                GraphDataMods mods = (GraphDataMods)evt.getNewValue();
                EntitySkeletonProvider.this._cache.remove(mods.getEntitiesUpdated().keySet());
            }
        }
    }
}

