/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.error.reporting.ui;

import com.paterva.maltego.error.reporting.ui.ProblemDtoBuilder;
import com.paterva.maltego.error.reporting.ui.ProblemNotificationPanel;
import com.paterva.maltego.error.reporting.ui.ProblemSender;
import com.paterva.maltego.util.ui.problemreport.settings.ProblemReportOptions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;

public final class NotificationUtility {
    private static final int NOTIFICATION_DISPLAY_TIME = (int)Duration.ofMinutes(1L).toMillis();
    private static final long BACKOFF_MILLIS = Duration.ofMinutes(1L).toMillis();
    private static long lastSentMillis = 0L;

    public static void showNotification(String message) {
        NotificationUtility.showNotification(message, "Maltego");
    }

    public static void showNotification(String message, String title) {
        ImageIcon img = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/util/ui/notification/infoBox24.png", (boolean)true);
        NotificationUtility.showNotification(message, title, img);
    }

    public static void showNotification(String message, String title, Icon icon) {
        Notification notif = NotificationDisplayer.getDefault().notify(title, icon, message, null, NotificationDisplayer.Priority.HIGH);
        Timer timer = new Timer(NOTIFICATION_DISPLAY_TIME, new TimerListener(notif));
        timer.setRepeats(false);
        timer.start();
    }

    public static void showNotification(String title, JComponent details, Icon icon, boolean silentNotification) {
        Notification notif = silentNotification ? null : NotificationDisplayer.getDefault().notify(title, icon, details, details, NotificationDisplayer.Priority.HIGH);
        Timer timer = details instanceof ProblemNotificationPanel ? new Timer(NOTIFICATION_DISPLAY_TIME, new TimerListener(notif, ((ProblemNotificationPanel)details).getProblemBuilder(), silentNotification)) : new Timer(NOTIFICATION_DISPLAY_TIME, new TimerListener(notif));
        timer.setRepeats(false);
        timer.start();
    }

    private static class TimerListener
    implements ActionListener {
        private final Notification notification;
        private ProblemDtoBuilder problemBuilder;
        private boolean silentNotification = false;

        public TimerListener(Notification theNotification) {
            this.notification = theNotification;
        }

        public TimerListener(Notification notification, ProblemDtoBuilder problemBuilder) {
            this.notification = notification;
            this.problemBuilder = problemBuilder;
        }

        public TimerListener(Notification notification, ProblemDtoBuilder problemBuilder, boolean silentNotification) {
            this.notification = notification;
            this.problemBuilder = problemBuilder;
            this.silentNotification = silentNotification;
        }

        @Override
        public void actionPerformed(ActionEvent Event2) {
            if (this.notification != null) {
                this.notification.clear();
            }
            if (this.problemBuilder != null && !this.problemBuilder.hasUserIntervened() && ProblemReportOptions.getDefault().isAutoSendExceptions()) {
                long time;
                if (this.silentNotification) {
                    this.problemBuilder.userIntervened();
                }
                if ((time = System.currentTimeMillis()) - lastSentMillis > BACKOFF_MILLIS) {
                    lastSentMillis = time;
                    new ProblemSender(this.problemBuilder).send(false);
                }
            }
        }
    }
}

