/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.HttpUtils;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WriteCompletionManager {
    private static final Logger LOG = Logger.getLogger(WriteCompletionManager.class.getName());
    private final String connectionId;
    private final Map<WriteCompletionHolder, List<ByteBuffer>> pendingCompletionConfirmations = new HashMap<WriteCompletionHolder, List<ByteBuffer>>();
    private AtomicBoolean isWriteCompletionSupportActivated = new AtomicBoolean(false);

    public WriteCompletionManager(String connectionId) {
        this.connectionId = connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPendingCompletionConfirmationsEmtpy() {
        WriteCompletionManager writeCompletionManager = this;
        synchronized (writeCompletionManager) {
            return this.pendingCompletionConfirmations.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCompletionHandler(IWriteCompletionHandler writeCompletionHandler, AbstractHttpConnection.IMultimodeExecutor executor, ByteBuffer[] buffersToWrite) {
        WriteCompletionHolder holder = new WriteCompletionHolder(writeCompletionHandler, executor, buffersToWrite, this.connectionId);
        WriteCompletionManager writeCompletionManager = this;
        synchronized (writeCompletionManager) {
            this.isWriteCompletionSupportActivated.set(true);
            this.pendingCompletionConfirmations.put(holder, new ArrayList<ByteBuffer>(Arrays.asList(buffersToWrite)));
        }
        if (LOG.isLoggable(Level.FINE)) {
            int size = 0;
            for (ByteBuffer byteBuffer : buffersToWrite) {
                size += byteBuffer.remaining();
            }
            LOG.fine("[" + this.connectionId + "] {" + buffersToWrite.hashCode() + "} registering " + writeCompletionHandler.getClass().getSimpleName() + "#" + writeCompletionHandler.hashCode() + " for  data  size=" + size + " bytes)");
        }
    }

    public void onWritten(ByteBuffer[] data, boolean isForceMultithreaded) {
        if (this.isWriteCompletionSupportActivated.get()) {
            for (ByteBuffer byteBuffer : data) {
                this.handleOnWritten(byteBuffer, isForceMultithreaded);
            }
        }
    }

    public void onWritten(ByteBuffer data, boolean isForceMultithreaded) {
        if (this.isWriteCompletionSupportActivated.get()) {
            this.handleOnWritten(data, isForceMultithreaded);
        }
    }

    public List<ByteBuffer> getPendungBuffers() {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (List<ByteBuffer> byteBuffers : this.pendingCompletionConfirmations.values()) {
            buffers.addAll(byteBuffers);
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnWritten(ByteBuffer data, boolean isForceMultithreaded) {
        WriteCompletionHolder holderToExecute = null;
        if (data != null) {
            WriteCompletionManager writeCompletionManager = this;
            synchronized (writeCompletionManager) {
                for (Map.Entry<WriteCompletionHolder, List<ByteBuffer>> entry : this.pendingCompletionConfirmations.entrySet()) {
                    List<ByteBuffer> buffers = entry.getValue();
                    for (ByteBuffer buffer : buffers) {
                        if (buffer != data) continue;
                        buffers.remove(data);
                        break;
                    }
                    if (!buffers.isEmpty()) continue;
                    this.pendingCompletionConfirmations.remove(entry.getKey());
                    holderToExecute = entry.getKey();
                    break;
                }
            }
        }
        if (holderToExecute != null) {
            holderToExecute.performOnWritten(isForceMultithreaded);
        }
    }

    public void onWriteException(IOException ioException, ByteBuffer[] data) {
        if (this.isWriteCompletionSupportActivated.get()) {
            for (ByteBuffer byteBuffer : data) {
                this.onWriteException(ioException, byteBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWriteException(IOException ioException, ByteBuffer data) {
        WriteCompletionHolder holderToExecute = null;
        if (data != null) {
            WriteCompletionManager writeCompletionManager = this;
            synchronized (writeCompletionManager) {
                block3: for (Map.Entry<WriteCompletionHolder, List<ByteBuffer>> entry : this.pendingCompletionConfirmations.entrySet()) {
                    List<ByteBuffer> buffers = entry.getValue();
                    for (ByteBuffer buffer : buffers) {
                        if (buffer != data) continue;
                        buffers.remove(data);
                        holderToExecute = entry.getKey();
                        break block3;
                    }
                }
            }
        }
        if (holderToExecute != null) {
            holderToExecute.performOnException(ioException);
        }
    }

    public static final class WriteCompletionHolder
    implements Runnable {
        private final IWriteCompletionHandler handler;
        private final HttpUtils.CompletionHandlerInfo handlerInfo;
        private final AbstractHttpConnection.IMultimodeExecutor executor;
        private final String id;
        private final ByteBuffer[] bufs;
        private final int size;

        public WriteCompletionHolder(IWriteCompletionHandler handler, AbstractHttpConnection.IMultimodeExecutor executor, ByteBuffer[] bufs, String id) {
            this.handler = handler;
            this.executor = executor;
            this.handlerInfo = HttpUtils.getCompletionHandlerInfo(handler);
            this.id = id;
            this.bufs = bufs;
            this.size = WriteCompletionHolder.computeSize(bufs);
        }

        private static int computeSize(ByteBuffer[] bufs) {
            int i = 0;
            for (ByteBuffer byteBuffer : bufs) {
                i += byteBuffer.remaining();
            }
            return i;
        }

        void performOnWritten(boolean isForceMultithreaded) {
            if (isForceMultithreaded || this.handlerInfo.isOnWrittenMultithreaded()) {
                this.executor.processMultithreaded(this);
            } else {
                this.executor.processNonthreaded(this);
            }
        }

        public void run() {
            this.callOnWritten();
        }

        private void callOnWritten() {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] {" + this.bufs.hashCode() + "}  data (size=" + this.size + " bytes) has been written. calling " + this.handler.getClass().getSimpleName() + "#" + this.handler.hashCode() + " onWritten method");
                }
                this.handler.onWritten(this.size);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] {" + this.bufs.hashCode() + "}   error occured by calling onWritten " + ioe.toString() + " closing connection");
                }
                this.performOnException(ioe);
            }
        }

        void performOnException(final IOException ioe) {
            if (this.handlerInfo.isOnExceptionMutlithreaded()) {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHolder.this.callOnException(ioe);
                    }
                };
                this.executor.processMultithreaded(task);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHolder.this.callOnException(ioe);
                    }
                };
                this.executor.processNonthreaded(task);
            }
        }

        private void callOnException(IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.id + "] calling " + this.handler.getClass().getSimpleName() + "#" + this.handler.hashCode() + " onException with " + ioe.toString());
            }
            this.handler.onException(ioe);
        }
    }
}

