/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.HashMap;

public class DataSources {
    private static DataSource EMPTY;

    private DataSources() {
    }

    public static DataSource empty() {
        if (EMPTY == null) {
            EMPTY = new DataSource(){

                @Override
                public Object getValue(PropertyDescriptor descriptor) {
                    return null;
                }

                @Override
                public void setValue(PropertyDescriptor descriptor, Object value) {
                }

                @Override
                public void clear() {
                }
            };
        }
        return EMPTY;
    }

    public static DataSource proxy(DataSource ... sources) {
        return new Proxy(sources);
    }

    public static DataSource readOnlyProxy(DataSource ... sources) {
        return new ReadOnlyProxy(sources);
    }

    public static class Map
    extends HashMap<PropertyDescriptor, Object>
    implements DataSource {
        @Override
        public Object getValue(PropertyDescriptor descriptor) {
            return this.get(descriptor);
        }

        @Override
        public void setValue(PropertyDescriptor descriptor, Object value) {
            this.put(descriptor, value);
        }
    }

    public static class ReadOnlyProxy
    extends Proxy {
        public ReadOnlyProxy(DataSource ... delegates) {
            super(delegates);
        }

        @Override
        public void setValue(PropertyDescriptor descriptor, Object value) {
            throw new UnsupportedOperationException("This data source is read only");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("This data source is read only");
        }
    }

    public static class Proxy
    implements DataSource {
        protected final DataSource[] _delegates;

        public Proxy(DataSource ... sources) {
            this._delegates = sources;
        }

        @Override
        public Object getValue(PropertyDescriptor descriptor) {
            for (DataSource ds : this._delegates) {
                Object value = ds.getValue(descriptor);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public void setValue(PropertyDescriptor descriptor, Object value) {
            if (this._delegates.length > 0) {
                this._delegates[0].setValue(descriptor, value);
            }
        }

        @Override
        public void clear() {
        }
    }
}

