/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openide.util.Exceptions;

public class RegistryInheritedTypesProvider
implements InheritedTypesProvider {
    private final EntityRegistry _registry;
    private final GraphID _graphID;
    private final Collection<EntityID> _entities;
    private Set<String> _entityTypes;

    public RegistryInheritedTypesProvider(GraphID graphID, EntityRegistry registry, Collection<EntityID> entities) {
        this._graphID = graphID;
        this._registry = registry;
        this._entities = entities;
    }

    public Set<String> getAllInheritedTypes() {
        if (this._entityTypes == null) {
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                this._entityTypes = dataReader.getEntityTypesOnly(this._entities);
                EntityRegistry registry = EntityRegistry.forGraphID((GraphID)this._graphID);
                if (registry == null) {
                    registry = EntityRegistry.getDefault();
                }
                this._entityTypes = GraphUtils.getAllTypeNames(this._entityTypes, (EntityRegistry)registry, (boolean)true);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._entityTypes;
    }

    public List<String> getAllInheritedTypes(String type) {
        return InheritanceHelper.getInheritanceList((SpecRegistry)this._registry, (String)type);
    }
}

