/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui;

import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.paterva.maltego.seeds.ui.hub.HubSeedManager;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SortToolbar
extends JToolBar {
    private static final Color FG = MaltegoLAF.getLookAndFeelDefaults().getColor("hub-static-sort-fg");
    private final HubSeedManager _manager;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JLabel sortLabel;
    private JToggleButton toggleDefault;
    private ButtonGroup toggleGroup;
    private JToggleButton toggleName;
    private JToggleButton toggleNewest;

    public SortToolbar(HubSeedManager manager) {
        this._manager = manager;
        this.initComponents();
        this.setFloatable(false);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.sortLabel.setFont(this.sortLabel.getFont().deriveFont(1));
        this.sortLabel.setForeground(FG);
        this.toggleDefault.putClientProperty("inHubPanel", Boolean.TRUE);
        this.toggleName.putClientProperty("inHubPanel", Boolean.TRUE);
        this.toggleNewest.putClientProperty("inHubPanel", Boolean.TRUE);
        Color partnersBg = MaltegoLAF.getLookAndFeelDefaults().getColor("hub-partners-bg");
        this.toggleDefault.setBackground(partnersBg);
        this.toggleName.setBackground(partnersBg);
        this.toggleNewest.setBackground(partnersBg);
        String selectBg = "hub-toggle-select-bg";
        this.toggleDefault.putClientProperty("toggleButtonSelectBg", selectBg);
        this.toggleName.putClientProperty("toggleButtonSelectBg", selectBg);
        this.toggleNewest.putClientProperty("toggleButtonSelectBg", selectBg);
        this.toggleDefault.setFont(this.toggleDefault.getFont().deriveFont(1));
        this.toggleName.setFont(this.toggleName.getFont().deriveFont(1));
        this.toggleNewest.setFont(this.toggleNewest.getFont().deriveFont(1));
        Color buttonFg = DarculaButtonUI.getButtonColorHub();
        this.toggleDefault.setForeground(buttonFg);
        this.toggleName.setForeground(buttonFg);
        this.toggleNewest.setForeground(buttonFg);
        this.resetState();
    }

    public void resetState() {
        if (this.toggleGroup != null && this.toggleDefault != null) {
            this.toggleGroup.setSelected(this.toggleDefault.getModel(), true);
            this.toggleDefaultActionPerformed(null);
        }
    }

    private void refreshLater() {
        SwingUtilities.invokeLater(() -> this._manager.refresh(false));
    }

    private void initComponents() {
        this.toggleGroup = new ButtonGroup();
        this.sortLabel = new JLabel();
        this.toggleDefault = new JToggleButton();
        this.jSeparator1 = new JSeparator();
        this.toggleNewest = new JToggleButton();
        this.jSeparator3 = new JSeparator();
        this.toggleName = new JToggleButton();
        Mnemonics.setLocalizedText((JLabel)this.sortLabel, (String)NbBundle.getMessage(SortToolbar.class, (String)"SortToolbar.sortLabel.text"));
        this.add(this.sortLabel);
        this.toggleGroup.add(this.toggleDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.toggleDefault, (String)NbBundle.getMessage(SortToolbar.class, (String)"SortToolbar.toggleDefault.text"));
        this.toggleDefault.setFocusPainted(false);
        this.toggleDefault.setFocusable(false);
        this.toggleDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortToolbar.this.toggleDefaultActionPerformed(evt);
            }
        });
        this.add(this.toggleDefault);
        this.jSeparator1.setBackground(new Color(0, 0, 0));
        this.jSeparator1.setForeground(new Color(0, 0, 0));
        this.jSeparator1.setMaximumSize(new Dimension(1, 13));
        this.jSeparator1.setMinimumSize(new Dimension(1, 13));
        this.jSeparator1.setOpaque(true);
        this.jSeparator1.setPreferredSize(new Dimension(1, 13));
        this.jSeparator1.setRequestFocusEnabled(false);
        this.jSeparator1.setVerifyInputWhenFocusTarget(false);
        this.add(this.jSeparator1);
        this.toggleGroup.add(this.toggleNewest);
        Mnemonics.setLocalizedText((AbstractButton)this.toggleNewest, (String)NbBundle.getMessage(SortToolbar.class, (String)"SortToolbar.toggleNewest.text"));
        this.toggleNewest.setFocusPainted(false);
        this.toggleNewest.setFocusable(false);
        this.toggleNewest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortToolbar.this.toggleNewestActionPerformed(evt);
            }
        });
        this.add(this.toggleNewest);
        this.jSeparator3.setBackground(new Color(0, 0, 0));
        this.jSeparator3.setForeground(new Color(0, 0, 0));
        this.jSeparator3.setMaximumSize(new Dimension(1, 13));
        this.jSeparator3.setMinimumSize(new Dimension(1, 13));
        this.jSeparator3.setOpaque(true);
        this.jSeparator3.setPreferredSize(new Dimension(1, 13));
        this.jSeparator3.setRequestFocusEnabled(false);
        this.jSeparator3.setVerifyInputWhenFocusTarget(false);
        this.add(this.jSeparator3);
        this.toggleGroup.add(this.toggleName);
        Mnemonics.setLocalizedText((AbstractButton)this.toggleName, (String)NbBundle.getMessage(SortToolbar.class, (String)"SortToolbar.toggleName.text"));
        this.toggleName.setFocusPainted(false);
        this.toggleName.setFocusable(false);
        this.toggleName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortToolbar.this.toggleNameActionPerformed(evt);
            }
        });
        this.add(this.toggleName);
    }

    private void toggleDefaultActionPerformed(ActionEvent evt) {
        this._manager.setSort(Sort.DEFAULT);
        this.refreshLater();
    }

    private void toggleNewestActionPerformed(ActionEvent evt) {
        this._manager.setSort(Sort.NEWEST);
        this.refreshLater();
    }

    private void toggleNameActionPerformed(ActionEvent evt) {
        this._manager.setSort(Sort.NAME);
        this.refreshLater();
    }

    public static enum Sort {
        DEFAULT,
        NEWEST,
        NAME;

    }
}

