/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.A.J;
import yguard.A.A.X;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.F.F;

public class GraphStructureUtils {
    public static Set<LinkID> getLinksBetween(GraphID graphID, Collection<EntityID> entities) {
        Set links = Collections.emptySet();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            links = structureReader.getLinksBetween(entities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links;
    }

    public static Set<EntityID> getAttachedEntities(GraphID graphID, Set<LinkID> links) {
        Set<EntityID> entities = Collections.emptySet();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            Map entitiesMap = structureReader.getEntities(links);
            entities = GraphStructureUtils.onlyEntities(entitiesMap);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entities;
    }

    public static X getShortestPaths(D graph, Y node1, Y node2) {
        HashSet<Y> nodes = new HashSet<Y>();
        J edgeMap = graph.\u00cf();
        F.A((D)graph, (Y)node1, (Y)node2, (boolean)false, (J)edgeMap);
        Z ec = graph.u();
        while (ec.ok()) {
            if (edgeMap.getBool((Object)ec.D())) {
                nodes.add(ec.D().X());
                nodes.add(ec.D().V());
            }
            ec.next();
        }
        graph.A(edgeMap);
        return new X(nodes.toArray(new Y[0]));
    }

    private static Set<EntityID> onlyEntities(Map<LinkID, LinkEntityIDs> entitiesMap) {
        HashSet<EntityID> entities = new HashSet<EntityID>();
        for (Map.Entry<LinkID, LinkEntityIDs> entry : entitiesMap.entrySet()) {
            LinkEntityIDs linkEntities = entry.getValue();
            entities.add(linkEntities.getSourceID());
            entities.add(linkEntities.getTargetID());
        }
        return entities;
    }
}

