/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.typing.editing.MapDataSource;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.ValidatingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openide.WizardDescriptor;

public class InputFormController
extends ValidatingController<Component> {
    private final DataSource data;
    private final DisplayDescriptorEnumeration descriptors;

    public InputFormController(DataSource data, DisplayDescriptorEnumeration descriptors) {
        Args.notNull((Object)data, (String)"data");
        Args.notNull((Object)descriptors, (String)"descriptors");
        this.data = data;
        this.descriptors = descriptors;
    }

    public InputFormController(Map<String, Object> properties) {
        Args.notNullOrEmpty(properties, (String)"properties");
        this.data = new MapDataSource(new HashMap<String, Object>(properties));
        DisplayDescriptorList displayDescriptors = new DisplayDescriptorList();
        properties.forEach((name, value) -> {
            DisplayDescriptor displayDescriptor = new DisplayDescriptor(value.getClass(), name);
            displayDescriptor.setNullable(false);
            displayDescriptors.add(displayDescriptor);
        });
        this.descriptors = displayDescriptors;
    }

    public InputFormController(String propertyName, Object propertyValue) {
        this(Collections.singletonMap(propertyName, propertyValue));
    }

    public DataSource getData() {
        return this.data;
    }

    public DisplayDescriptorEnumeration getDescriptors() {
        return this.descriptors;
    }

    public Object getValue(String name) {
        Args.notNull((Object)name, (String)"name");
        DisplayDescriptor descriptor = this.descriptors.get(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor with name: " + name);
        }
        return this.data.getValue((PropertyDescriptor)descriptor);
    }

    protected Component createComponent() {
        Component editingComponent = ComponentFactories.form().createEditingComponent(new ObservableDataSource(), this.descriptors, null);
        ValidatingPanel panel = new ValidatingPanel((ValidatingController)this);
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add(editingComponent);
        return panel;
    }

    protected String getFirstError(Component component) {
        for (DisplayDescriptor prop : this.descriptors) {
            if (prop.isNullable() || !StringUtilities.isNullString((Object)prop.getDefaultValue()) || !StringUtilities.isNullString((Object)this.data.getValue((PropertyDescriptor)prop))) continue;
            return prop.getDisplayName() + " required";
        }
        return null;
    }

    protected void readSettings(WizardDescriptor settings) {
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    private class ObservableDataSource
    implements DataSource {
        private ObservableDataSource() {
        }

        public Object getValue(PropertyDescriptor descriptor) {
            Args.notNull((Object)descriptor, (String)"descriptor");
            return InputFormController.this.data.getValue(descriptor);
        }

        public void setValue(PropertyDescriptor descriptor, Object value) {
            Args.notNull((Object)descriptor, (String)"descriptor");
            InputFormController.this.data.setValue(descriptor, value);
            InputFormController.this.doValidate();
        }

        public void clear() {
            InputFormController.this.data.clear();
        }
    }
}

