/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostLanguage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

final class LanguageCache
implements Comparable<LanguageCache> {
    private static final Map<String, LanguageCache> nativeImageCache = TruffleOptions.AOT ? new HashMap() : null;
    private static final Map<String, LanguageCache> nativeImageMimes = TruffleOptions.AOT ? new HashMap() : null;
    private static final Map<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, LanguageCache>> runtimeCaches = new HashMap<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, LanguageCache>>();
    private static volatile Map<String, LanguageCache> runtimeMimes;
    private final String className;
    private final Set<String> mimeTypes;
    private final Set<String> characterMimeTypes;
    private final String defaultMimeType;
    private final Set<String> dependentLanguages;
    private final String id;
    private final String name;
    private final String implementationName;
    private final String version;
    private final boolean interactive;
    private final boolean internal;
    private final Set<String> services;
    private final LanguageReflection languageReflection;
    private String languageHome;

    private LanguageCache(String id, String name, String implementationName, String version, String className, String languageHome, Set<String> characterMimeTypes, Set<String> byteMimeTypes, String defaultMimeType, Set<String> dependentLanguages, boolean interactive, boolean internal, Set<String> services, LanguageReflection languageReflection) {
        this.languageReflection = languageReflection;
        this.className = className;
        this.name = name;
        this.implementationName = implementationName;
        this.version = version;
        this.characterMimeTypes = characterMimeTypes;
        this.mimeTypes = new TreeSet<String>();
        this.mimeTypes.addAll(characterMimeTypes);
        this.mimeTypes.addAll(byteMimeTypes);
        this.defaultMimeType = this.mimeTypes.size() == 1 && defaultMimeType == null ? this.mimeTypes.iterator().next() : defaultMimeType;
        this.dependentLanguages = dependentLanguages;
        this.id = id;
        this.interactive = interactive;
        this.internal = internal;
        this.languageHome = languageHome;
        this.services = services;
        if (TruffleOptions.AOT) {
            languageReflection.aotInitializeAtBuildTime();
        }
    }

    static LanguageCache createHostLanguageCache(String ... services) {
        Set<String> servicesClassNames;
        HostLanguage languageInstance = new HostLanguage();
        if (services.length == 0) {
            servicesClassNames = Collections.emptySet();
        } else {
            servicesClassNames = new TreeSet();
            Collections.addAll(servicesClassNames, services);
            servicesClassNames = Collections.unmodifiableSet(servicesClassNames);
        }
        return new LanguageCache("host", "Host", "Host", System.getProperty("java.version"), languageInstance.getClass().getName(), null, Collections.emptySet(), Collections.emptySet(), null, Collections.emptySet(), false, false, servicesClassNames, LanguageReflection.forLanguageInstance(new HostLanguage(), TruffleLanguage.ContextPolicy.SHARED, new TruffleFile.FileTypeDetector[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, LanguageCache> languageMimes() {
        if (TruffleOptions.AOT) {
            return nativeImageMimes;
        }
        Map<String, LanguageCache> cache = runtimeMimes;
        if (cache != null) return cache;
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            cache = runtimeMimes;
            if (cache != null) return cache;
            runtimeMimes = cache = LanguageCache.createMimes();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, LanguageCache> createMimes() {
        LinkedHashMap<String, LanguageCache> mimes = new LinkedHashMap<String, LanguageCache>();
        for (LanguageCache cache : LanguageCache.languages().values()) {
            for (String mime : cache.getMimeTypes()) {
                mimes.put(mime, cache);
            }
        }
        return mimes;
    }

    static Map<String, LanguageCache> languages() {
        return LanguageCache.loadLanguages(EngineAccessor.locatorOrDefaultLoaders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, LanguageCache> loadLanguages(List<EngineAccessor.AbstractClassLoaderSupplier> classLoaders) {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            Map<String, LanguageCache> cache = runtimeCaches.get(classLoaders);
            if (cache == null) {
                cache = LanguageCache.createLanguages(classLoaders);
                runtimeCaches.put(classLoaders, cache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, LanguageCache> createLanguages(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        ArrayList caches = new ArrayList();
        for (Supplier supplier : suppliers) {
            Loader.load((ClassLoader)supplier.get(), caches);
        }
        HashMap<String, LanguageCache> cacheToId = new HashMap<String, LanguageCache>();
        for (LanguageCache languageCache : caches) {
            LanguageCache prev = cacheToId.put(languageCache.getId(), languageCache);
            if (prev == null || prev.getClassName().equals(languageCache.getClassName()) && prev.languageReflection.hasSameCodeSource(languageCache.languageReflection)) continue;
            String message = String.format("Duplicate language id %s. First language [%s]. Second language [%s].", languageCache.getId(), LanguageCache.formatLanguageLocation(prev), LanguageCache.formatLanguageLocation(languageCache));
            throw new IllegalStateException(message);
        }
        return cacheToId;
    }

    private static String formatLanguageLocation(LanguageCache languageCache) {
        StringBuilder sb = new StringBuilder();
        sb.append("Language class ").append(languageCache.getClassName());
        URL url = languageCache.languageReflection.getCodeSource();
        if (url != null) {
            sb.append(", Loaded from " + url);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(LanguageCache o) {
        return this.id.compareTo(o.id);
    }

    String getId() {
        return this.id;
    }

    Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    boolean isCharacterMimeType(String mimeType) {
        return this.characterMimeTypes.contains(mimeType);
    }

    boolean isByteMimeType(String mimeType) {
        return this.characterMimeTypes.contains(mimeType);
    }

    String getName() {
        return this.name;
    }

    String getImplementationName() {
        return this.implementationName;
    }

    Set<String> getDependentLanguages() {
        return this.dependentLanguages;
    }

    String getVersion() {
        return this.version;
    }

    String getClassName() {
        return this.className;
    }

    boolean isInternal() {
        return this.internal;
    }

    boolean isInteractive() {
        return this.interactive;
    }

    String getLanguageHome() {
        if (this.languageHome == null) {
            this.languageHome = LanguageCache.getLanguageHomeImpl(this.id);
        }
        return this.languageHome;
    }

    private static String getLanguageHomeImpl(String languageId) {
        String home = System.getProperty("org.graalvm.language." + languageId + ".home");
        if (home == null) {
            home = System.getProperty(languageId + ".home");
        }
        return home;
    }

    TruffleLanguage<?> loadLanguage() {
        return this.languageReflection.newInstance();
    }

    Set<? extends Class<? extends Tag>> getProvidedTags() {
        return this.languageReflection.getProvidedTags();
    }

    TruffleLanguage.ContextPolicy getPolicy() {
        return this.languageReflection.getContextPolicy();
    }

    Collection<String> getServices() {
        return this.services;
    }

    boolean supportsService(Class<?> clazz) {
        return this.services.contains(clazz.getName()) || this.services.contains(clazz.getCanonicalName());
    }

    List<? extends TruffleFile.FileTypeDetector> getFileTypeDetectors() {
        return this.languageReflection.getFileTypeDetectors();
    }

    public String toString() {
        return "LanguageCache [id=" + this.id + ", name=" + this.name + ", implementationName=" + this.implementationName + ", version=" + this.version + ", className=" + this.className + ", services=" + this.services + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetNativeImageCacheLanguageHomes() {
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            if (nativeImageCache != null) {
                LanguageCache.resetNativeImageCacheLanguageHomes(nativeImageCache);
            }
            for (Map<String, LanguageCache> caches : runtimeCaches.values()) {
                LanguageCache.resetNativeImageCacheLanguageHomes(caches);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void resetNativeImageCacheLanguageHomes(Map<String, LanguageCache> caches) {
        for (LanguageCache cache : caches.values()) {
            cache.languageHome = null;
        }
    }

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.putAll(LanguageCache.createLanguages(Arrays.asList(new EngineAccessor.StrongClassLoaderSupplier(imageClassLoader))));
        nativeImageMimes.putAll(LanguageCache.createMimes());
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.clear();
        nativeImageMimes.clear();
    }

    private static void removeLanguageFromNativeImage(String languageId) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        assert (nativeImageCache.containsKey(languageId));
        LanguageCache cache = nativeImageCache.remove(languageId);
        if (cache != null) {
            for (String mime : cache.getMimeTypes()) {
                if (nativeImageCache.get(mime) != cache) continue;
                nativeImageMimes.remove(mime);
            }
        }
    }

    private static Collection<Class<?>> getLanguageClasses() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        ArrayList list = new ArrayList();
        for (LanguageCache cache : nativeImageCache.values()) {
            Class<? extends TruffleLanguage<?>> clz = cache.languageReflection.aotInitializeAtBuildTime();
            if (clz == null) continue;
            list.add(clz);
        }
        return list;
    }

    private static abstract class Loader {
        private Loader() {
        }

        static void load(ClassLoader loader, Collection<? super LanguageCache> into) {
            if (loader == null) {
                return;
            }
            try {
                Class<?> truffleLanguageClassAsSeenByLoader = Class.forName(TruffleLanguage.class.getName(), true, loader);
                if (truffleLanguageClassAsSeenByLoader != TruffleLanguage.class) {
                    return;
                }
            }
            catch (ClassNotFoundException ex) {
                return;
            }
            LegacyLoader.INSTANCE.loadImpl(loader, into);
            ServicesLoader.INSTANCE.loadImpl(loader, into);
        }

        static void exportTruffle(ClassLoader loader) {
            if (!TruffleOptions.AOT) {
                EngineAccessor.JDKSERVICES.exportTo(loader, null);
            }
        }

        abstract void loadImpl(ClassLoader var1, Collection<? super LanguageCache> var2);

        static String defaultId(String name, String className) {
            String resolvedId;
            if (name.isEmpty()) {
                int lastIndex = className.lastIndexOf(36);
                if (lastIndex == -1) {
                    lastIndex = className.lastIndexOf(46);
                }
                resolvedId = className.substring(lastIndex + 1, className.length());
            } else {
                resolvedId = name.length() == 1 ? name : name.toLowerCase();
            }
            return resolvedId;
        }

        static String getLanguageHomeFromURLConnection(String languageId, URLConnection connection) {
            block4: {
                if (connection instanceof JarURLConnection) {
                    try {
                        URL url = ((JarURLConnection)connection).getJarFileURL();
                        if ("file".equals(url.getProtocol())) {
                            Path path = Paths.get(url.toURI());
                            Path parent = path.getParent();
                            return parent != null ? parent.toString() : null;
                        }
                    }
                    catch (IllegalArgumentException | SecurityException | URISyntaxException | FileSystemNotFoundException e) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError((Object)("Cannot locate " + languageId + " language home due to " + e.getMessage()));
                    }
                }
            }
            return null;
        }

        private static final class ServicesLoader
        extends Loader {
            static final Loader INSTANCE = new ServicesLoader();

            private ServicesLoader() {
            }

            @Override
            public void loadImpl(ClassLoader loader, Collection<? super LanguageCache> into) {
                ServicesLoader.exportTruffle(loader);
                for (TruffleLanguage.Provider provider : ServiceLoader.load(TruffleLanguage.Provider.class, loader)) {
                    URL url;
                    String languageHome;
                    TruffleLanguage.Registration reg = provider.getClass().getAnnotation(TruffleLanguage.Registration.class);
                    if (reg == null) {
                        PrintStream out = System.err;
                        out.println("Provider " + provider.getClass() + " is missing @Registration annotation.");
                        continue;
                    }
                    String className = provider.getLanguageClassName();
                    String name = reg.name();
                    String id = reg.id();
                    if (id == null || id.isEmpty()) {
                        id = ServicesLoader.defaultId(name, className);
                    }
                    if ((languageHome = LanguageCache.getLanguageHomeImpl(id)) == null && (url = provider.getClass().getClassLoader().getResource(className.replace('.', '/') + ".class")) != null) {
                        try {
                            languageHome = ServicesLoader.getLanguageHomeFromURLConnection(id, url.openConnection());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    String implementationName = reg.implementationName();
                    String version = reg.version();
                    TreeSet characterMimes = new TreeSet();
                    Collections.addAll(characterMimes, reg.characterMimeTypes());
                    if (characterMimes.isEmpty()) {
                        Collections.addAll(characterMimes, ServicesLoader.getMimeTypesDepecated(reg));
                    }
                    TreeSet byteMimeTypes = new TreeSet();
                    Collections.addAll(byteMimeTypes, reg.byteMimeTypes());
                    String defaultMime = reg.defaultMimeType();
                    if (defaultMime.isEmpty()) {
                        defaultMime = null;
                    }
                    TreeSet dependentLanguages = new TreeSet();
                    Collections.addAll(dependentLanguages, reg.dependentLanguages());
                    boolean interactive = reg.interactive();
                    boolean internal = reg.internal();
                    TreeSet<String> servicesClassNames = new TreeSet<String>();
                    for (String service : provider.getServicesClassNames()) {
                        servicesClassNames.add(service);
                    }
                    ServiceLoaderLanguageReflection reflection = new ServiceLoaderLanguageReflection(provider, reg.contextPolicy());
                    into.add(new LanguageCache(id, name, implementationName, version, className, languageHome, characterMimes, byteMimeTypes, defaultMime, dependentLanguages, interactive, internal, servicesClassNames, reflection));
                }
            }

            private static String[] getMimeTypesDepecated(TruffleLanguage.Registration reg) {
                return reg.mimeType();
            }

            private static final class ServiceLoaderLanguageReflection
            extends LanguageReflection {
                private final TruffleLanguage.Provider provider;
                private final TruffleLanguage.ContextPolicy contextPolicy;
                private volatile Set<Class<? extends Tag>> providedTags;
                private volatile List<TruffleFile.FileTypeDetector> fileTypeDetectors;

                ServiceLoaderLanguageReflection(TruffleLanguage.Provider provider, TruffleLanguage.ContextPolicy contextPolicy) {
                    assert (provider != null);
                    assert (contextPolicy != null);
                    this.provider = provider;
                    this.contextPolicy = contextPolicy;
                }

                @Override
                TruffleLanguage<?> newInstance() {
                    return this.provider.create();
                }

                @Override
                List<? extends TruffleFile.FileTypeDetector> getFileTypeDetectors() {
                    List<TruffleFile.FileTypeDetector> result = this.fileTypeDetectors;
                    if (result == null) {
                        this.fileTypeDetectors = result = this.provider.createFileTypeDetectors();
                    }
                    return result;
                }

                @Override
                TruffleLanguage.ContextPolicy getContextPolicy() {
                    return this.contextPolicy;
                }

                @Override
                Set<? extends Class<? extends Tag>> getProvidedTags() {
                    Set<Class<Tag>> res = this.providedTags;
                    if (res == null) {
                        ProvidedTags tags = this.provider.getClass().getAnnotation(ProvidedTags.class);
                        if (tags == null) {
                            res = Collections.emptySet();
                        } else {
                            res = new HashSet<Class<? extends Tag>>();
                            Collections.addAll(res, tags.value());
                            res = Collections.unmodifiableSet(res);
                        }
                        this.providedTags = res;
                    }
                    return res;
                }

                @Override
                Class<? extends TruffleLanguage<?>> aotInitializeAtBuildTime() {
                    return null;
                }

                @Override
                boolean hasSameCodeSource(LanguageReflection other) {
                    if (other instanceof ServiceLoaderLanguageReflection) {
                        return this.provider.getClass() == ((ServiceLoaderLanguageReflection)other).provider.getClass();
                    }
                    return false;
                }

                @Override
                URL getCodeSource() {
                    CodeSource source = this.provider.getClass().getProtectionDomain().getCodeSource();
                    return source != null ? source.getLocation() : null;
                }
            }
        }

        private static final class LegacyLoader
        extends Loader {
            static final Loader INSTANCE = new LegacyLoader();

            private LegacyLoader() {
            }

            @Override
            public void loadImpl(ClassLoader loader, Collection<? super LanguageCache> into) {
                Enumeration<URL> en;
                try {
                    en = loader.getResources("META-INF/truffle/language");
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot read list of Truffle languages", ex);
                }
                while (en.hasMoreElements()) {
                    String prefix;
                    String name;
                    URLConnection connection;
                    Properties p;
                    URL u = en.nextElement();
                    try {
                        p = new Properties();
                        connection = u.openConnection();
                        connection.setUseCaches(false);
                        try (InputStream is = connection.getInputStream();){
                            p.load(is);
                        }
                    }
                    catch (IOException ex) {
                        PrintStream out = System.err;
                        out.println("Cannot process " + u + " as language definition");
                        ex.printStackTrace();
                        continue;
                    }
                    int cnt = 1;
                    while ((name = p.getProperty((prefix = "language" + cnt + ".") + "name")) != null) {
                        into.add(LegacyLoader.createLanguageCache(name, prefix, p, loader, connection));
                        ++cnt;
                    }
                }
            }

            private static LanguageCache createLanguageCache(String name, String prefix, Properties info, ClassLoader loader, URLConnection connection) {
                String nth;
                String fileTypeDetectorClassName;
                String nth2;
                String serviceName;
                String languageHome;
                String id = info.getProperty(prefix + "id");
                if (id == null) {
                    id = LegacyLoader.defaultId(name, info.getProperty(prefix + "className"));
                }
                if ((languageHome = LanguageCache.getLanguageHomeImpl(id)) == null) {
                    languageHome = LegacyLoader.getLanguageHomeFromURLConnection(id, connection);
                }
                String className = info.getProperty(prefix + "className");
                String implementationName = info.getProperty(prefix + "implementationName");
                String version = info.getProperty(prefix + "version");
                TreeSet<String> characterMimes = LegacyLoader.parseList(info, prefix + "characterMimeType");
                if (characterMimes.isEmpty()) {
                    characterMimes = LegacyLoader.parseList(info, prefix + "mimeType");
                }
                TreeSet<String> byteMimeTypes = LegacyLoader.parseList(info, prefix + "byteMimeType");
                String defaultMime = info.getProperty(prefix + "defaultMimeType");
                TreeSet<String> dependentLanguages = LegacyLoader.parseList(info, prefix + "dependentLanguage");
                boolean interactive = Boolean.valueOf(info.getProperty(prefix + "interactive"));
                boolean internal = Boolean.valueOf(info.getProperty(prefix + "internal"));
                TreeSet<String> servicesClassNames = new TreeSet<String>();
                int servicesCounter = 0;
                while ((serviceName = info.getProperty(nth2 = prefix + "service" + servicesCounter)) != null) {
                    servicesClassNames.add(serviceName);
                    ++servicesCounter;
                }
                ArrayList<String> detectorClassNames = new ArrayList<String>();
                int fileTypeDetectorCounter = 0;
                while ((fileTypeDetectorClassName = info.getProperty(nth = prefix + "fileTypeDetector" + fileTypeDetectorCounter)) != null) {
                    detectorClassNames.add(fileTypeDetectorClassName);
                    ++fileTypeDetectorCounter;
                }
                LegacyLanguageReflection reflection = new LegacyLanguageReflection(name, loader, className, detectorClassNames);
                return new LanguageCache(id, name, implementationName, version, className, languageHome, characterMimes, byteMimeTypes, defaultMime, dependentLanguages, interactive, internal, servicesClassNames, reflection);
            }

            private static TreeSet<String> parseList(Properties info, String prefix) {
                String mt;
                TreeSet<String> mimeTypesSet = new TreeSet<String>();
                int i = 0;
                while ((mt = info.getProperty(prefix + "." + i)) != null) {
                    mimeTypesSet.add(mt);
                    ++i;
                }
                return mimeTypesSet;
            }

            private static final class LegacyLanguageReflection
            extends LanguageReflection {
                private final String name;
                private final ClassLoader loader;
                private final String className;
                private final List<String> fileTypeDetectorClassNames;
                private volatile Class<? extends TruffleLanguage<?>> languageClass;
                private volatile TruffleLanguage.ContextPolicy policy;
                private volatile List<? extends TruffleFile.FileTypeDetector> fileTypeDetectors;

                LegacyLanguageReflection(String name, ClassLoader loader, String className, List<String> fileTypeDetectorClassNames) {
                    Objects.requireNonNull(name, "Name must be non null.");
                    Objects.requireNonNull(loader, "Loader must be non null.");
                    Objects.requireNonNull(className, "ClassName must be non null.");
                    Objects.requireNonNull(fileTypeDetectorClassNames, "FileTypeDetectorClassNames must be non null.");
                    this.name = name;
                    this.loader = loader;
                    this.className = className;
                    this.fileTypeDetectorClassNames = fileTypeDetectorClassNames;
                }

                @Override
                TruffleLanguage<?> newInstance() {
                    try {
                        return this.getLanguageClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create instance of " + this.name + " language implementation. Public default constructor expected in " + this.className + ".", e);
                    }
                }

                @Override
                List<? extends TruffleFile.FileTypeDetector> getFileTypeDetectors() {
                    this.initializeFileTypeDetectors();
                    return this.fileTypeDetectors;
                }

                @Override
                TruffleLanguage.ContextPolicy getContextPolicy() {
                    this.initializeLanguageClass();
                    return this.policy;
                }

                @Override
                Set<? extends Class<? extends Tag>> getProvidedTags() {
                    this.initializeLanguageClass();
                    ProvidedTags tags = this.languageClass.getAnnotation(ProvidedTags.class);
                    if (tags == null) {
                        return Collections.emptySet();
                    }
                    HashSet result = new HashSet();
                    Collections.addAll(result, tags.value());
                    return result;
                }

                @Override
                Class<? extends TruffleLanguage<?>> aotInitializeAtBuildTime() {
                    this.initializeLanguageClass();
                    this.initializeFileTypeDetectors();
                    assert (this.languageClass != null);
                    assert (this.policy != null);
                    return this.languageClass;
                }

                @Override
                boolean hasSameCodeSource(LanguageReflection other) {
                    if (other instanceof LegacyLanguageReflection) {
                        return this.loadUnitialized() == ((LegacyLanguageReflection)other).loadUnitialized();
                    }
                    return false;
                }

                @Override
                URL getCodeSource() {
                    CodeSource source = this.getLanguageClass().getProtectionDomain().getCodeSource();
                    return source != null ? source.getLocation() : null;
                }

                private Class<? extends TruffleLanguage<?>> loadUnitialized() {
                    try {
                        return Class.forName(this.className, false, this.loader);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Cannot load language " + this.name + ". Language implementation class " + this.className + " failed to load.", e);
                    }
                }

                private Class<? extends TruffleLanguage<?>> getLanguageClass() {
                    if (!TruffleOptions.AOT) {
                        this.initializeLanguageClass();
                    }
                    return this.languageClass;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void initializeLanguageClass() {
                    if (this.languageClass == null) {
                        LegacyLanguageReflection legacyLanguageReflection = this;
                        synchronized (legacyLanguageReflection) {
                            if (this.languageClass == null) {
                                try {
                                    Loader.exportTruffle(this.loader);
                                    Class<?> loadedClass = Class.forName(this.className, true, this.loader);
                                    TruffleLanguage.Registration reg = loadedClass.getAnnotation(TruffleLanguage.Registration.class);
                                    this.policy = reg == null ? TruffleLanguage.ContextPolicy.EXCLUSIVE : loadedClass.getAnnotation(TruffleLanguage.Registration.class).contextPolicy();
                                    this.languageClass = loadedClass;
                                }
                                catch (ClassNotFoundException e) {
                                    throw new IllegalStateException("Cannot load language " + this.name + ". Language implementation class " + this.className + " failed to load.", e);
                                }
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void initializeFileTypeDetectors() {
                    if (this.fileTypeDetectors == null) {
                        LegacyLanguageReflection legacyLanguageReflection = this;
                        synchronized (legacyLanguageReflection) {
                            if (this.fileTypeDetectors == null) {
                                Loader.exportTruffle(this.loader);
                                ArrayList<TruffleFile.FileTypeDetector> instances = new ArrayList<TruffleFile.FileTypeDetector>(this.fileTypeDetectorClassNames.size());
                                for (String fileTypeDetectorClassName : this.fileTypeDetectorClassNames) {
                                    try {
                                        Class<TruffleFile.FileTypeDetector> detectorClass = Class.forName(fileTypeDetectorClassName, true, this.loader).asSubclass(TruffleFile.FileTypeDetector.class);
                                        TruffleFile.FileTypeDetector instance = detectorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                        instances.add(instance);
                                    }
                                    catch (ReflectiveOperationException e) {
                                        throw new IllegalStateException("Cannot instantiate FileTypeDetector, class  " + fileTypeDetectorClassName + ".", e);
                                    }
                                }
                                this.fileTypeDetectors = Collections.unmodifiableList(instances);
                            }
                        }
                    }
                }
            }
        }
    }

    private static abstract class LanguageReflection {
        private LanguageReflection() {
        }

        abstract TruffleLanguage<?> newInstance();

        abstract List<? extends TruffleFile.FileTypeDetector> getFileTypeDetectors();

        abstract TruffleLanguage.ContextPolicy getContextPolicy();

        abstract Set<? extends Class<? extends Tag>> getProvidedTags();

        abstract Class<? extends TruffleLanguage<?>> aotInitializeAtBuildTime();

        abstract boolean hasSameCodeSource(LanguageReflection var1);

        abstract URL getCodeSource();

        static LanguageReflection forLanguageInstance(TruffleLanguage<?> language, TruffleLanguage.ContextPolicy contextPolycy, TruffleFile.FileTypeDetector ... fileTypeDetectors) {
            return new LanguageInstanceReflection(language, contextPolycy, fileTypeDetectors);
        }

        private static final class LanguageInstanceReflection
        extends LanguageReflection {
            private final TruffleLanguage<?> languageInstance;
            private final TruffleLanguage.ContextPolicy contextPolycy;
            private final List<? extends TruffleFile.FileTypeDetector> fileTypeDetectors;

            LanguageInstanceReflection(TruffleLanguage<?> languageInstance, TruffleLanguage.ContextPolicy contextPolycy, TruffleFile.FileTypeDetector ... detectors) {
                assert (languageInstance != null);
                assert (contextPolycy != null);
                this.languageInstance = languageInstance;
                this.contextPolycy = contextPolycy;
                this.fileTypeDetectors = detectors.length == 0 ? Collections.emptyList() : Arrays.asList(detectors);
            }

            @Override
            TruffleLanguage<?> newInstance() {
                return this.languageInstance;
            }

            @Override
            List<? extends TruffleFile.FileTypeDetector> getFileTypeDetectors() {
                return this.fileTypeDetectors;
            }

            @Override
            TruffleLanguage.ContextPolicy getContextPolicy() {
                return this.contextPolycy;
            }

            @Override
            Set<? extends Class<? extends Tag>> getProvidedTags() {
                return Collections.emptySet();
            }

            @Override
            Class<? extends TruffleLanguage<?>> aotInitializeAtBuildTime() {
                return null;
            }

            @Override
            boolean hasSameCodeSource(LanguageReflection other) {
                throw new UnsupportedOperationException("Should not reach here.");
            }

            @Override
            URL getCodeSource() {
                throw new UnsupportedOperationException("Should not reach here.");
            }
        }
    }
}

