/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lobobrowser.html.domimpl.DocumentNotificationAdapter;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Nodes;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;

public class DescendentHTMLCollection
extends AbstractScriptableDelegate
implements HTMLCollection {
    private final NodeImpl rootNode;
    private final NodeFilter nodeFilter;
    private final Object treeLock;
    private final boolean nestIntoMatchingNodes;
    private Map itemsByName = null;
    private List itemsByIndex = null;

    public DescendentHTMLCollection(NodeImpl node, NodeFilter filter, Object treeLock) {
        this(node, filter, treeLock, true);
    }

    public DescendentHTMLCollection(NodeImpl node, NodeFilter filter, Object treeLock, boolean nestMatchingNodes) {
        this.rootNode = node;
        this.nodeFilter = filter;
        this.treeLock = treeLock;
        this.nestIntoMatchingNodes = nestMatchingNodes;
        HTMLDocumentImpl document = (HTMLDocumentImpl)node.getOwnerDocument();
        document.addDocumentNotificationListener(new LocalNotificationListener(document, this));
    }

    private void ensurePopulatedImpl() {
        if (this.itemsByName == null) {
            HashMap<String, ElementImpl> itemsByName;
            ArrayList descendents = this.rootNode.getDescendents(this.nodeFilter, this.nestIntoMatchingNodes);
            this.itemsByIndex = descendents == null ? Collections.EMPTY_LIST : descendents;
            int size = descendents == null ? 0 : descendents.size();
            this.itemsByName = itemsByName = new HashMap<String, ElementImpl>(size * 3 / 2);
            for (int i = 0; i < size; ++i) {
                String name;
                Object descNode = descendents.get(i);
                if (!(descNode instanceof ElementImpl)) continue;
                ElementImpl element = (ElementImpl)descNode;
                String id = element.getId();
                if (id != null && id.length() != 0) {
                    itemsByName.put(id, element);
                }
                if ((name = element.getAttribute("name")) == null || name.length() == 0 || name.equals(id)) continue;
                itemsByName.put(name, element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.treeLock;
        synchronized (object) {
            this.itemsByName = null;
            this.itemsByIndex = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.itemsByName != null && this.itemsByIndex != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLength() {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return this.itemsByIndex.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node item(int index) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            try {
                return (Node)this.itemsByIndex.get(index);
            }
            catch (IndexOutOfBoundsException iob) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node namedItem(String name) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return (Node)this.itemsByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Node node) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ensurePopulatedImpl();
            return this.itemsByIndex.indexOf(node);
        }
    }

    private static class LocalNotificationListener
    extends DocumentNotificationAdapter {
        private final HTMLDocumentImpl document;
        private final WeakReference collectionRef;

        public LocalNotificationListener(HTMLDocumentImpl document, DescendentHTMLCollection collection) {
            this.document = document;
            this.collectionRef = new WeakReference<DescendentHTMLCollection>(collection);
        }

        @Override
        public void structureInvalidated(NodeImpl node) {
            DescendentHTMLCollection collection = (DescendentHTMLCollection)this.collectionRef.get();
            if (collection == null) {
                this.document.removeDocumentNotificationListener(this);
                return;
            }
            if (collection.isValid() && Nodes.isSameOrAncestorOf(collection.rootNode, node)) {
                collection.invalidate();
            }
        }

        @Override
        public void nodeLoaded(NodeImpl node) {
            this.structureInvalidated(node);
        }
    }
}

