<#
.Synopsis
    Quick PortScan / EgressBuster

    PortScan / EgressBuster 2017
    Rob Maslen @rbmaslen 

.DESCRIPTION
	PS C:\> Usage: PortScan [-Hosts <Comma delimited list of domain names or IP addresses>] [-Ports <Ports>] [-Threads <Concurrent Thread>] [-Delay <Delay>] [-RevDNS] [-Closed] <Show Closed Ports> [-Live] <Live updates in the console, don't use in C2>
.EXAMPLE
    PS C:\> PortScan -Hosts "127.0.0.1" -Ports 1-65535 -Threads 10000
.EXAMPLE
    PS C:\> PortScan -Hosts "192.168.1.0/24" -Ports 1-65535 -Threads 10000
.EXAMPLE
    PS C:\> PortScan -Hosts "192.168.1.1-50" -Ports "80,443,55" -Threads 10000 -RevDNS
.EXAMPLE
    PS C:\> PortScan -Hosts "192.168.1.1-50" -Ports "80,443,55" -Threads 1 -Delay 1
.EXAMPLE
    PS C:\> PortScan -Hosts "192.168.1.1-50" -Ports "80,443,55" -Threads 1 -Delay 1 -RevDNS
.EXAMPLE
    PS C:\> PortScan -Hosts "host1.local,hos2.local,127.0.0.1" -Ports "80,443,55" -Threads 1 -Delay 1
.EXAMPLE
    PS C:\> PortScan -Hosts "host1.local,hos2.local,127.0.0.1" -Ports "80,443,55" -Threads 1 -Delay 30
    .EXAMPLE
    PS C:\> PortScan -Hosts "host1.local,hos2.local,127.0.0.1" -Ports "80,443,55" -Threads 1 -Delay 1 -Closed
.EXAMPLE
    PS C:\> PortScan -Hosts "host1.local,hos2.local,127.0.0.1" -Ports "80,443,55" -Threads 1 -Delay 30 -Closed -Live
#>

$pscanloaded = $null
function PortScan {
param(
[Parameter(Mandatory=$true)][string]$Hosts, 
[Parameter(Mandatory=$false)][string]$Ports="1-1000",
[Parameter(Mandatory=$false)][string]$Threads=1000,
[Parameter(Mandatory=$false)][int]$Delay=0,
[switch]$RevDNS,
[switch]$Closed,
[switch]$Live
)
    $ps = "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"
    $ps2 = "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"

    $status = "[+] Loading Assembly v4"

    if ($psversiontable.PSVersion.Major -lt 4)
    {
        $ps = $ps2
        $status = "[+] Loading Assembly v2"
    }
    try 
    {
        $Delay = $Delay *1000
        if ($pscanloaded -ne "TRUE") 
        {
            $script:pscanloaded = "TRUE"
            echo $status
            [System.IO.MemoryStream] $output = New-Object System.IO.MemoryStream(45000)
            [System.IO.MemoryStream] $gzdll = New-Object System.IO.MemoryStream(,[System.Convert]::FromBase64String($ps))
            $gzipStream = New-Object System.IO.Compression.GzipStream $gzdll, ([IO.Compression.CompressionMode]::Decompress)
            try {
                $buffer = New-Object byte[](32000);
                while ($true) 
                {
                    $read = $gzipStream.Read($buffer, 0, 32000)
                    if ($read -le 0) 
                    {
                        break;
                    }
                    $output.Write($buffer, 0, $read)
                }
            }
            finally 
            {
                Write-Verbose "Closing streams and newly decompressed file"
                $gzipStream.Close();
                $output.Close();
                $gzdll.Close();
            }
            $assembly = [System.Reflection.Assembly]::Load($output.ToArray())
        }
    } 
    catch
    {
        echo $_.Exception.Message
    }

    try 
    {
        [PortScanner_Dll.Scanner.TCPConnectScanner]::VisualResults = $Live
        $scanner = [PortScanner_Dll.Scanner.TCPConnectScanner]::PerformTCPConnectScan("$Hosts","$Ports","$Delay","$Threads", $RevDNS, $Closed)
        $scanner.Results
    } 
    catch 
    {
        echo $_.Exception.Message
    }
}
