; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=newgvn -S | FileCheck %s

define i32 @main() {
; CHECK-LABEL: @main(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    ret i32 0
;
block1:
  %z1 = bitcast i32 0 to i32
  br label %block2
block2:
  %z2 = bitcast i32 0 to i32
  ret i32 %z2
}

; Test that we simplify selects properly
define i64 @simplifyselect(i64 %x, i64 %y, i1 %c1, i1 %c2, i1 %zzz) {
; CHECK-LABEL: @simplifyselect(
; CHECK-NEXT:    [[SHARED:%.*]] = add i64 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R1:%.*]] = select i1 [[C1:%.*]], i64 [[SHARED]], i64 [[X]]
; CHECK-NEXT:    [[R2:%.*]] = select i1 [[C2:%.*]], i64 [[SHARED]], i64 [[Y]]
; CHECK-NEXT:    [[R:%.*]] = add i64 [[R1]], [[R2]]
; CHECK-NEXT:    ret i64 [[R]]
;
  %shared = add i64 %x, %y
  %r1 = select i1 %c1, i64 %shared, i64 %x
  %r2 = select i1 %c2, i64 %shared, i64 %y
  %tmp = select i1 %c2, i64 %x, i64 0
  %r2_eq2 = select i1 %zzz, i64 %r2, i64 %r2
  %r = add i64 %r1, %r2_eq2
  ret i64 %r
}

define i8 @simplify_add_poison(i8 %x) {
; CHECK-LABEL: @simplify_add_poison(
; CHECK-NEXT:    ret i8 poison
;
  %r = add i8 poison, %x
  ret i8 %r
}

define i8 @simplify_xor_poison(i8 %x) {
; CHECK-LABEL: @simplify_xor_poison(
; CHECK-NEXT:    ret i8 poison
;
  %r = xor i8 poison, %x
  ret i8 %r
}

define i8 @simplify_sdiv_poison(i8 %x) {
; CHECK-LABEL: @simplify_sdiv_poison(
; CHECK-NEXT:    ret i8 poison
;
  %r = sdiv i8 poison, %x
  ret i8 %r
}

define i8 @simplify_urem_poison(i8 %x) {
; CHECK-LABEL: @simplify_urem_poison(
; CHECK-NEXT:    ret i8 poison
;
  %r = urem i8 %x, poison
  ret i8 %r
}
