# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-01-30 16:38
from __future__ import unicode_literals

from django.conf import settings
import django.core.validators
from django.db import (
    migrations,
    models,
)
import django.db.models.deletion
import maasserver.models.cleansave


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('maasserver', '0139_add_endpoint_and_increase_user_agent_length_for_event'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(editable=False)),
                ('updated', models.DateTimeField(editable=False)),
                ('name', models.CharField(max_length=256, unique=True, validators=[django.core.validators.RegexValidator('^\\w[ \\w-]*$')])),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['name'],
            },
            bases=(maasserver.models.cleansave.CleanSave, models.Model, object),
        ),
        migrations.CreateModel(
            name='UserGroupMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='maasserver.UserGroup')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='usergroup',
            name='users',
            field=models.ManyToManyField(through='maasserver.UserGroupMembership', to=settings.AUTH_USER_MODEL),
        ),
    ]
