/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Christopher James Halse Rogers <christopher.halse.rogers@canonical.com>
 */

#ifndef MIR_DISPLAY_CONFIGURATION_MULTIPLEXER_H_
#define MIR_DISPLAY_CONFIGURATION_MULTIPLEXER_H_

#include "mir/observer_registrar.h"
#include "mir/observer_multiplexer.h"
#include "mir/graphics/display_configuration_observer.h"

namespace mir
{
namespace frontend
{
class Session;
}
namespace graphics
{
class DisplayConfigurationObserverMultiplexer : public ObserverMultiplexer<DisplayConfigurationObserver>
{
public:
    DisplayConfigurationObserverMultiplexer(std::shared_ptr<Executor> const& default_executor);

    void initial_configuration(std::shared_ptr<DisplayConfiguration const> const& config) override;

    void configuration_applied(std::shared_ptr<DisplayConfiguration const> const& config) override;

    void base_configuration_updated(std::shared_ptr<DisplayConfiguration const> const& base_config) override;

    void session_configuration_applied(std::shared_ptr<frontend::Session> const& session,
                                       std::shared_ptr<DisplayConfiguration> const& config) override;

    void session_configuration_removed(std::shared_ptr<frontend::Session> const& session) override;

    void configuration_failed(
        std::shared_ptr<DisplayConfiguration const> const& attempted,
        std::exception const& error) override;

    void catastrophic_configuration_error(
        std::shared_ptr<DisplayConfiguration const> const& failed_fallback,
        std::exception const& error) override;

private:
    std::shared_ptr<Executor> const executor;
};

}
}

#endif //MIR_DISPLAY_CONFIGURATION_MULTIPLEXER_H_
